/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.debugger.locationResolving.JSLocationResolver;
import com.intellij.javascript.karma.execution.KarmaConsoleProperties;
import com.intellij.javascript.karma.execution.KarmaExecutionSession;
import com.intellij.javascript.karma.execution.KarmaExecutionType;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerRegistry;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.CatchingConsumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunProfileState
implements RunProfileState {
    private static final Logger LOG = Logger.getInstance(KarmaRunProfileState.class);
    private final Project myProject;
    private final KarmaRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myKarmaPackage;
    private final KarmaRunSettings myRunSettings;
    private final KarmaExecutionType myExecutionType;
    private List<List<String>> myFailedTestNames;

    public KarmaRunProfileState(@NotNull Project project, @NotNull KarmaRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage karmaPackage) {
        if (project == null) {
            KarmaRunProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            KarmaRunProfileState.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            KarmaRunProfileState.$$$reportNull$$$0(2);
        }
        if (karmaPackage == null) {
            KarmaRunProfileState.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myKarmaPackage = karmaPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
        this.myExecutionType = KarmaRunProfileState.findExecutionType(this.myEnvironment.getExecutor());
    }

    @Nullable
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        KarmaServer server;
        if (executor == null) {
            KarmaRunProfileState.$$$reportNull$$$0(4);
        }
        if (runner == null) {
            KarmaRunProfileState.$$$reportNull$$$0(5);
        }
        if ((server = this.getServerOrStart(executor)) != null) {
            return this.executeWithServer(executor, server);
        }
        return null;
    }

    @Nullable
    public KarmaServer getServerOrStart(final @NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            KarmaRunProfileState.$$$reportNull$$$0(6);
        }
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        KarmaServerSettings serverSettings = new KarmaServerSettings.Builder().setNodeInterpreter(interpreter).setKarmaPackage(this.myKarmaPackage).setRunSettings(this.myRunSettings).setWithCoverage(this.myExecutionType == KarmaExecutionType.COVERAGE).setDebug(this.myExecutionType == KarmaExecutionType.DEBUG).build();
        KarmaServerRegistry registry = KarmaServerRegistry.getInstance(this.myProject);
        KarmaServer server = registry.getServer(serverSettings);
        if (server != null && server.getRestarter().isRestartRequired()) {
            server.shutdownAsync();
            server = null;
        }
        if (server == null) {
            JSLocationResolver.Companion.getInstance().dropCache((RunProfile)this.myRunConfiguration);
            registry.startServer(serverSettings, new CatchingConsumer<KarmaServer, Exception>(){

                public void consume(KarmaServer server) {
                    RunnerAndConfigurationSettings configuration = KarmaRunProfileState.this.myEnvironment.getRunnerAndConfigurationSettings();
                    if (configuration != null) {
                        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
                    }
                }

                public void consume(Exception e) {
                    LOG.error((Throwable)e);
                    KarmaRunProfileState.this.showServerStartupError(e);
                }
            });
        }
        return server;
    }

    @NotNull
    public ExecutionResult executeWithServer(@NotNull Executor executor, @NotNull KarmaServer server) throws ExecutionException {
        if (executor == null) {
            KarmaRunProfileState.$$$reportNull$$$0(7);
        }
        if (server == null) {
            KarmaRunProfileState.$$$reportNull$$$0(8);
        }
        KarmaExecutionSession session = new KarmaExecutionSession(this.myProject, this.myRunConfiguration, executor, server, this.myRunSettings, this.myExecutionType, this.myFailedTestNames);
        SMTRunnerConsoleView consoleView = session.getSmtConsoleView();
        ProcessHandler processHandler = session.getProcessHandler();
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
        executionResult.setRestartActions(new AnAction[]{((KarmaConsoleProperties)consoleView.getProperties()).createRerunFailedTestsAction((ConsoleView)consoleView), new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            KarmaRunProfileState.$$$reportNull$$$0(9);
        }
        return defaultExecutionResult;
    }

    public void setFailedTestNames(@NotNull List<List<String>> failedTestNames) {
        if (failedTestNames == null) {
            KarmaRunProfileState.$$$reportNull$$$0(10);
        }
        this.myFailedTestNames = failedTestNames;
    }

    @NotNull
    private static KarmaExecutionType findExecutionType(@NotNull Executor executor) {
        if (executor == null) {
            KarmaRunProfileState.$$$reportNull$$$0(11);
        }
        if (executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
            KarmaExecutionType karmaExecutionType = KarmaExecutionType.DEBUG;
            if (karmaExecutionType == null) {
                KarmaRunProfileState.$$$reportNull$$$0(12);
            }
            return karmaExecutionType;
        }
        if (executor.equals(ExecutorRegistry.getInstance().getExecutorById("Coverage"))) {
            KarmaExecutionType karmaExecutionType = KarmaExecutionType.COVERAGE;
            if (karmaExecutionType == null) {
                KarmaRunProfileState.$$$reportNull$$$0(13);
            }
            return karmaExecutionType;
        }
        KarmaExecutionType karmaExecutionType = KarmaExecutionType.RUN;
        if (karmaExecutionType == null) {
            KarmaRunProfileState.$$$reportNull$$$0(14);
        }
        return karmaExecutionType;
    }

    private void showServerStartupError(@NotNull Exception serverException) {
        if (serverException == null) {
            KarmaRunProfileState.$$$reportNull$$$0(15);
        }
        StringBuilder errorMessage = new StringBuilder("Karma server launching failed");
        String prevMessage = null;
        for (Throwable e = serverException; e != null; e = e.getCause()) {
            String message = e.getMessage();
            if (message == null || message.equals(prevMessage)) continue;
            errorMessage.append("\n\nCaused by:\n");
            errorMessage.append(message);
            prevMessage = message;
        }
        Messages.showErrorDialog((Project)this.myProject, (String)errorMessage.toString(), (String)"Karma Server");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaPackage";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunProfileState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTestNames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunProfileState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWithServer";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExecutionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getServerOrStart";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeWithServer";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTestNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExecutionType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showServerStartupError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

