/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class KarmaRunSettingsSerializationUtil {
    private static final String CONFIG_FILE = "config-file";
    private static final String KARMA_PACKAGE_DIR = "karma-package-dir";
    private static final String WORKING_DIRECTORY = "working-directory";
    private static final String BROWSERS = "browsers";
    private static final String NODE_INTERPRETER = "node-interpreter";
    private static final String NODE_OPTIONS = "node-options";
    private static final String SCOPE_KIND = "scope-kind";
    private static final String TEST_FILE_PATH = "test-file-path";
    private static final String TEST_NAMES = "test-names";
    private static final String TEST_NAME = "test-name";

    private KarmaRunSettingsSerializationUtil() {
    }

    public static KarmaRunSettings readXml(@NotNull Element element, @NotNull Project project, boolean templateRunConfiguration) {
        String workingDirPath;
        if (element == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(1);
        }
        KarmaRunSettings.Builder builder = new KarmaRunSettings.Builder();
        String configPath = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)CONFIG_FILE));
        builder.setConfigPath(configPath);
        builder.setBrowsers(JDOMExternalizerUtil.readCustomField((Element)element, (String)BROWSERS));
        String karmaPackageDir = JDOMExternalizerUtil.readCustomField((Element)element, (String)KARMA_PACKAGE_DIR);
        if (karmaPackageDir != null) {
            builder.setKarmaPackage(new NodePackage(karmaPackageDir));
        }
        if ((workingDirPath = JDOMExternalizerUtil.readCustomField((Element)element, (String)WORKING_DIRECTORY)) == null && !templateRunConfiguration) {
            VirtualFile workingDir = JsTestRunConfigurationProducer.guessWorkingDirectory((Project)project, (String)configPath);
            workingDirPath = workingDir != null ? workingDir.getPath() : PathUtil.getParentPath((String)configPath);
        }
        builder.setWorkingDirectory(workingDirPath);
        builder.setInterpreterRef(NodeJsInterpreterRef.create((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)NODE_INTERPRETER)));
        builder.setNodeOptions(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)NODE_OPTIONS)));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        KarmaScopeKind scopeKind = KarmaRunSettingsSerializationUtil.readScopeKind(element);
        builder.setScopeKind(scopeKind);
        if (scopeKind == KarmaScopeKind.TEST_FILE) {
            builder.setTestFilePath(JDOMExternalizerUtil.readCustomField((Element)element, (String)TEST_FILE_PATH));
        } else if (scopeKind == KarmaScopeKind.SUITE || scopeKind == KarmaScopeKind.TEST) {
            builder.setTestNames(KarmaRunSettingsSerializationUtil.readTestNames(element));
        }
        return builder.build();
    }

    @NotNull
    private static KarmaScopeKind readScopeKind(@NotNull Element element) {
        String value;
        if (element == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(2);
        }
        if (StringUtil.isNotEmpty((String)(value = JDOMExternalizerUtil.readCustomField((Element)element, (String)SCOPE_KIND)))) {
            KarmaScopeKind karmaScopeKind;
            try {
                karmaScopeKind = KarmaScopeKind.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (karmaScopeKind == null) {
                KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(3);
            }
            return karmaScopeKind;
        }
        KarmaScopeKind karmaScopeKind = KarmaScopeKind.ALL;
        if (karmaScopeKind == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(4);
        }
        return karmaScopeKind;
    }

    @NotNull
    private static List<String> readTestNames(@NotNull Element parent) {
        Element testNamesElement;
        if (parent == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(5);
        }
        if ((testNamesElement = parent.getChild(TEST_NAMES)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TEST_NAME);
        if (list == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static void writeXml(@NotNull Element element, @NotNull KarmaRunSettings settings, boolean templateRunConfiguration) {
        String workingDir;
        if (element == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(9);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)CONFIG_FILE, (String)settings.getConfigPathSystemIndependent());
        if (StringUtil.isNotEmpty((String)settings.getBrowsers())) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)BROWSERS, (String)settings.getBrowsers());
        }
        if (settings.getKarmaPackage() != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)KARMA_PACKAGE_DIR, (String)settings.getKarmaPackage().getSystemIndependentPath());
        }
        if (!(workingDir = settings.getWorkingDirectorySystemIndependent()).isEmpty() && (templateRunConfiguration || KarmaRunSettingsSerializationUtil.shouldWriteWorkingDir(settings))) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)WORKING_DIRECTORY, (String)workingDir);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)NODE_INTERPRETER, (String)settings.getInterpreterRef().getReferenceName());
        if (StringUtil.isNotEmpty((String)settings.getNodeOptions())) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)NODE_OPTIONS, (String)settings.getNodeOptions());
        }
        settings.getEnvData().writeExternal(element);
        KarmaScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind != KarmaScopeKind.ALL) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)SCOPE_KIND, (String)scopeKind.name());
        }
        if (scopeKind == KarmaScopeKind.TEST_FILE) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)TEST_FILE_PATH, (String)settings.getTestFileSystemIndependentPath());
        } else if (scopeKind == KarmaScopeKind.SUITE || scopeKind == KarmaScopeKind.TEST) {
            Element testNamesElement = new Element(TEST_NAMES);
            if (!settings.getTestNames().isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TEST_NAME, settings.getTestNames());
            }
            element.addContent(testNamesElement);
        }
    }

    private static boolean shouldWriteWorkingDir(@NotNull KarmaRunSettings settings) {
        String workingDirPath;
        String configFileDirPath;
        if (settings == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(10);
        }
        return !(configFileDirPath = KarmaRunSettingsSerializationUtil.trimTrailingPathSeparator(PathUtil.getParentPath((String)settings.getConfigPathSystemIndependent()))).equals(workingDirPath = KarmaRunSettingsSerializationUtil.trimTrailingPathSeparator(settings.getWorkingDirectorySystemIndependent()));
    }

    @NotNull
    private static String trimTrailingPathSeparator(@NotNull String path) {
        char ch;
        if (path == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(11);
        }
        if (path.length() > 1 && ((ch = path.charAt(path.length() - 1)) == '/' || ch == '\\')) {
            String string = path.substring(0, path.length() - 1);
            if (string == null) {
                KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readScopeKind";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readTestNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingPathSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readXml";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readScopeKind";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readTestNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldWriteWorkingDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailingPathSeparator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

