/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class KarmaServerSettings {
    private final boolean myWithCoverage;
    private final boolean myDebug;
    private final NodeJsInterpreter myNodeInterpreter;
    private final String myNodeOptions;
    private final NodePackage myKarmaPackage;
    private final String myConfigFilePath;
    private final String myBrowsers;
    private final String myWorkingDirectory;
    private final EnvironmentVariablesData myEnvData;

    private KarmaServerSettings(@NotNull Builder builder) {
        if (builder == null) {
            KarmaServerSettings.$$$reportNull$$$0(0);
        }
        this.myWithCoverage = builder.myWithCoverage;
        this.myDebug = builder.myDebug;
        this.myNodeInterpreter = builder.myNodeInterpreter;
        this.myNodeOptions = builder.myRunSettings.getNodeOptions();
        this.myKarmaPackage = builder.myKarmaPackage;
        this.myConfigFilePath = builder.myRunSettings.getConfigPathSystemDependent();
        this.myBrowsers = builder.myRunSettings.getBrowsers();
        this.myWorkingDirectory = builder.myRunSettings.getWorkingDirectorySystemDependent();
        this.myEnvData = builder.myRunSettings.getEnvData();
    }

    @NotNull
    public NodeJsInterpreter getNodeInterpreter() {
        NodeJsInterpreter nodeJsInterpreter = this.myNodeInterpreter;
        if (nodeJsInterpreter == null) {
            KarmaServerSettings.$$$reportNull$$$0(1);
        }
        return nodeJsInterpreter;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            KarmaServerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public NodePackage getKarmaPackage() {
        NodePackage nodePackage = this.myKarmaPackage;
        if (nodePackage == null) {
            KarmaServerSettings.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    public boolean isWithCoverage() {
        return this.myWithCoverage;
    }

    public boolean isDebug() {
        return this.myDebug;
    }

    @NotNull
    public File getConfigurationFile() {
        File file = new File(this.myConfigFilePath);
        if (file == null) {
            KarmaServerSettings.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public String getConfigurationFilePath() {
        String string = this.myConfigFilePath;
        if (string == null) {
            KarmaServerSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getBrowsers() {
        String string = this.myBrowsers;
        if (string == null) {
            KarmaServerSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getWorkingDirectorySystemDependent() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            KarmaServerSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            KarmaServerSettings.$$$reportNull$$$0(8);
        }
        return environmentVariablesData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KarmaServerSettings that = (KarmaServerSettings)o;
        return this.myWithCoverage == that.myWithCoverage && this.myDebug == that.myDebug && this.myNodeInterpreter.equals(that.myNodeInterpreter) && this.myNodeOptions.equals(that.myNodeOptions) && this.myKarmaPackage.equals((Object)that.myKarmaPackage) && this.myConfigFilePath.equals(that.myConfigFilePath) && this.myBrowsers.equals(that.myBrowsers) && this.myWorkingDirectory.equals(that.myWorkingDirectory) && this.myEnvData.equals((Object)that.myEnvData);
    }

    public int hashCode() {
        int result = this.myWithCoverage ? 1 : 0;
        result = 31 * result + (this.myDebug ? 1 : 0);
        result = 31 * result + this.myNodeInterpreter.hashCode();
        result = 31 * result + this.myNodeOptions.hashCode();
        result = 31 * result + this.myKarmaPackage.hashCode();
        result = 31 * result + this.myConfigFilePath.hashCode();
        result = 31 * result + this.myBrowsers.hashCode();
        result = 31 * result + this.myWorkingDirectory.hashCode();
        result = 31 * result + this.myEnvData.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaServerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaServerSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeInterpreter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKarmaPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySystemDependent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private NodeJsInterpreter myNodeInterpreter;
        private NodePackage myKarmaPackage;
        private KarmaRunSettings myRunSettings;
        private boolean myWithCoverage;
        private boolean myDebug;

        @NotNull
        public Builder setNodeInterpreter(@NotNull NodeJsInterpreter interpreter) {
            if (interpreter == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myNodeInterpreter = interpreter;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setKarmaPackage(@NotNull NodePackage karmaPackage) {
            if (karmaPackage == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myKarmaPackage = karmaPackage;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setRunSettings(@NotNull KarmaRunSettings runSettings) {
            if (runSettings == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myRunSettings = runSettings;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setWithCoverage(boolean withCoverage) {
            this.myWithCoverage = withCoverage;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setDebug(boolean debug) {
            this.myDebug = debug;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public KarmaServerSettings build() {
            if (this.myNodeInterpreter == null) {
                throw new RuntimeException("Unspecified Node.js interpreter");
            }
            if (this.myKarmaPackage == null) {
                throw new RuntimeException("Unspecified karma package");
            }
            if (this.myRunSettings == null) {
                throw new RuntimeException("Unspecified run settings");
            }
            KarmaServerSettings karmaServerSettings = new KarmaServerSettings(this);
            if (karmaServerSettings == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return karmaServerSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "karmaPackage";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaServerSettings$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeInterpreter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKarmaPackage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRunSettings";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setWithCoverage";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDebug";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setNodeInterpreter";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setKarmaPackage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setRunSettings";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

