/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.karma.util.ArchivedOutputListener;
import com.intellij.javascript.karma.util.StreamEventListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class KarmaProcessOutputManager {
    private static final int MAX_ARCHIVED_TEXTS_LENGTH = 0x100000;
    private static final char NEW_LINE = '\n';
    private static final String PREFIX = "##intellij-event[";
    private static final String SUFFIX = "]\n";
    private final ProcessHandler myProcessHandler;
    private final Deque<Pair<String, Key>> myArchivedTexts;
    private int myArchivedTextsLength;
    private boolean myArchiveTextsTruncated;
    private final List<ArchivedOutputListener> myOutputListeners;
    private final List<StreamEventListener> myStdOutStreamEventListeners;
    private final List<Pair<String, Key>> myStdOutCurrentLineChunks;
    private final Consumer<? super String> myStdOutLineConsumer;

    public KarmaProcessOutputManager(@NotNull ProcessHandler processHandler, @NotNull Consumer<? super String> stdOutLineConsumer) {
        if (processHandler == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(0);
        }
        if (stdOutLineConsumer == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(1);
        }
        this.myArchivedTexts = new ArrayDeque<Pair<String, Key>>();
        this.myArchivedTextsLength = 0;
        this.myArchiveTextsTruncated = false;
        this.myOutputListeners = new CopyOnWriteArrayList<ArchivedOutputListener>();
        this.myStdOutStreamEventListeners = new CopyOnWriteArrayList<StreamEventListener>();
        this.myStdOutCurrentLineChunks = ContainerUtil.newArrayList();
        this.myProcessHandler = processHandler;
        this.myStdOutLineConsumer = stdOutLineConsumer;
    }

    public void startNotify() {
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ProcessOutputType.isStdout((Key)outputType)) {
                    KarmaProcessOutputManager.this.processStandardOutput(event.getText(), outputType);
                } else {
                    KarmaProcessOutputManager.this.addText(event.getText(), outputType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/karma/server/KarmaProcessOutputManager$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myProcessHandler.startNotify();
    }

    private void processStandardOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(2);
        }
        if (type == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(3);
        }
        int lineStartInd = 0;
        int newLineInd = text.indexOf(10, lineStartInd);
        while (newLineInd != -1) {
            String line = text.substring(lineStartInd, newLineInd + 1);
            if (!this.myStdOutCurrentLineChunks.isEmpty()) {
                this.myStdOutCurrentLineChunks.add((Pair<String, Key>)Pair.create((Object)line, (Object)type));
                line = this.concatCurrentLineChunks();
            }
            if (!this.handleLineAsEvent(line)) {
                this.onStandardOutputLineAvailable(line);
                if (!this.myStdOutCurrentLineChunks.isEmpty()) {
                    for (Pair<String, Key> chunk : this.myStdOutCurrentLineChunks) {
                        this.addText((String)chunk.getFirst(), (Key)chunk.getSecond());
                    }
                } else {
                    this.addText(line, type);
                }
            }
            this.myStdOutCurrentLineChunks.clear();
            lineStartInd = newLineInd + 1;
            newLineInd = text.indexOf(10, lineStartInd);
        }
        if (lineStartInd < text.length()) {
            this.myStdOutCurrentLineChunks.add((Pair<String, Key>)Pair.create((Object)text.substring(lineStartInd), (Object)type));
        }
    }

    @NotNull
    private String concatCurrentLineChunks() {
        int size = 0;
        for (Pair<String, Key> chunk : this.myStdOutCurrentLineChunks) {
            size += ((String)chunk.getFirst()).length();
        }
        StringBuilder result = new StringBuilder(size);
        for (Pair<String, Key> chunk : this.myStdOutCurrentLineChunks) {
            result.append((String)chunk.getFirst());
        }
        String string = result.toString();
        if (string == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addText(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(6);
        }
        Deque<Pair<String, Key>> deque = this.myArchivedTexts;
        synchronized (deque) {
            this.myArchivedTexts.addLast((Pair<String, Key>)Pair.create((Object)text, (Object)outputType));
            this.myArchivedTextsLength += text.length();
            while (this.myArchivedTextsLength > 0x100000) {
                Pair<String, Key> pair = this.myArchivedTexts.removeFirst();
                this.myArchivedTextsLength -= ((String)pair.getFirst()).length();
                this.myArchiveTextsTruncated = true;
            }
            for (ArchivedOutputListener listener : this.myOutputListeners) {
                listener.onOutputAvailable(text, outputType, false);
            }
        }
    }

    private void onStandardOutputLineAvailable(@NotNull String line) {
        if (line == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(7);
        }
        this.myStdOutLineConsumer.consume((Object)line);
    }

    private boolean handleLineAsEvent(@NotNull String line) {
        if (line == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(8);
        }
        if (line.startsWith(PREFIX) && line.endsWith(SUFFIX)) {
            int colonInd = line.indexOf(58);
            if (colonInd == -1) {
                return false;
            }
            String eventType = line.substring(PREFIX.length(), colonInd);
            String eventBody = line.substring(colonInd + 1, line.length() - SUFFIX.length());
            for (StreamEventListener listener : this.myStdOutStreamEventListeners) {
                listener.on(eventType, eventBody);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(9);
        }
        return processHandler;
    }

    public void addOutputListener(@NotNull ArchivedOutputListener outputListener) {
        if (outputListener == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (outputListener == null) {
                KarmaProcessOutputManager.$$$reportNull$$$0(13);
            }
            Deque<Pair<String, Key>> deque = this.myArchivedTexts;
            synchronized (deque) {
                if (this.myArchiveTextsTruncated) {
                    outputListener.onOutputAvailable("... too much output to process, truncated\n", ProcessOutputTypes.SYSTEM, true);
                }
                for (Pair<String, Key> text : this.myArchivedTexts) {
                    outputListener.onOutputAvailable((String)text.getFirst(), (Key)text.getSecond(), true);
                }
                this.myOutputListeners.add(outputListener);
            }
        });
    }

    public void removeOutputListener(@NotNull ArchivedOutputListener outputListener) {
        if (outputListener == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(11);
        }
        this.myOutputListeners.remove(outputListener);
    }

    void addStreamEventListener(@NotNull StreamEventListener listener) {
        if (listener == null) {
            KarmaProcessOutputManager.$$$reportNull$$$0(12);
        }
        this.myStdOutStreamEventListeners.add(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdOutLineConsumer";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaProcessOutputManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputListener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaProcessOutputManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "concatCurrentLineChunks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processStandardOutput";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onStandardOutputLineAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleLineAsEvent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addOutputListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeOutputListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addStreamEventListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addOutputListener$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

