/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.coverage.KarmaCoveragePeer;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.AngularCliConfig;
import com.intellij.javascript.karma.server.KarmaJsSourcesLocator;
import com.intellij.javascript.karma.server.KarmaProcessOutputManager;
import com.intellij.javascript.karma.server.KarmaServerRestarter;
import com.intellij.javascript.karma.server.KarmaServerState;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.karma.util.StreamEventListener;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServer {
    private static final Logger LOG = Logger.getInstance(KarmaServer.class);
    private final KarmaProcessOutputManager myProcessOutputManager;
    private final KarmaServerState myState;
    private final KarmaCoveragePeer myCoveragePeer;
    private final KarmaServerSettings myServerSettings;
    private final ConsoleCommandLineFolder myCommandLineFolder;
    private List<Runnable> myOnPortBoundCallbacks;
    private List<Runnable> myOnBrowsersReadyCallbacks;
    private Integer myExitCode;
    private final List<KarmaServerTerminatedListener> myTerminationCallbacks;
    private final Map<String, StreamEventHandler> myHandlers;
    private final MyDisposable myDisposable;
    private final KarmaServerRestarter myRestarter;
    private final int myProcessHashCode;

    public KarmaServer(@NotNull Project project, @NotNull KarmaServerSettings serverSettings) throws IOException {
        if (project == null) {
            KarmaServer.$$$reportNull$$$0(0);
        }
        if (serverSettings == null) {
            KarmaServer.$$$reportNull$$$0(1);
        }
        this.myCommandLineFolder = new ConsoleCommandLineFolder(new String[0]);
        this.myOnPortBoundCallbacks = Lists.newCopyOnWriteArrayList();
        this.myOnBrowsersReadyCallbacks = Lists.newCopyOnWriteArrayList();
        this.myExitCode = null;
        this.myTerminationCallbacks = Lists.newCopyOnWriteArrayList();
        this.myHandlers = ContainerUtil.newConcurrentMap();
        this.myServerSettings = serverSettings;
        this.myCoveragePeer = serverSettings.isWithCoverage() ? new KarmaCoveragePeer() : null;
        KillableColoredProcessHandler processHandler = KarmaServer.startServer(serverSettings, this.myCoveragePeer, this.myCommandLineFolder);
        this.myProcessHashCode = System.identityHashCode(processHandler.getProcess());
        File configurationFile = this.myServerSettings.getConfigurationFile();
        this.myState = new KarmaServerState(this, configurationFile);
        this.myProcessOutputManager = new KarmaProcessOutputManager((ProcessHandler)processHandler, (Consumer<? super String>)((Consumer)this.myState::onStandardOutputLineAvailable));
        this.registerStreamEventHandlers();
        this.myProcessOutputManager.startNotify();
        this.myDisposable = new MyDisposable();
        Disposer.register((Disposable)project, (Disposable)this.myDisposable);
        this.myRestarter = new KarmaServerRestarter(configurationFile, this.myDisposable);
        final int processHashCode = System.identityHashCode(processHandler.getProcess());
        LOG.info("Karma server " + processHashCode + " started successfully: " + processHandler.getCommandLine());
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.info("Karma server " + processHashCode + " terminated with exit code " + event.getExitCode());
                Disposer.dispose((Disposable)KarmaServer.this.myDisposable);
                KarmaServer.this.fireOnTerminated(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/KarmaServer$1", "processTerminated"));
            }
        });
    }

    private void registerStreamEventHandlers() {
        if (this.myCoveragePeer != null) {
            this.myCoveragePeer.registerEventHandlers(this);
        }
        this.myProcessOutputManager.addStreamEventListener(new StreamEventListener(){

            @Override
            public void on(@NotNull String eventType, @NotNull String eventBody) {
                JsonElement jsonElement;
                if (eventType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (eventBody == null) {
                    2.$$$reportNull$$$0(1);
                }
                LOG.info("Processing Karma event " + eventType + " " + eventBody);
                try {
                    JsonParser jsonParser = new JsonParser();
                    jsonElement = jsonParser.parse(eventBody);
                }
                catch (Exception e) {
                    LOG.warn("Cannot parse message from karma server: (eventType: " + eventType + ", eventBody: " + eventBody + ")");
                    return;
                }
                StreamEventHandler handler = (StreamEventHandler)KarmaServer.this.myHandlers.get(eventType);
                if (handler != null) {
                    handler.handle(jsonElement);
                } else {
                    LOG.warn("Cannot find handler for " + eventType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "eventType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "eventBody";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/karma/server/KarmaServer$2";
                objectArray[2] = "on";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public KarmaServerSettings getServerSettings() {
        KarmaServerSettings karmaServerSettings = this.myServerSettings;
        if (karmaServerSettings == null) {
            KarmaServer.$$$reportNull$$$0(2);
        }
        return karmaServerSettings;
    }

    @NotNull
    public KarmaServerRestarter getRestarter() {
        KarmaServerRestarter karmaServerRestarter = this.myRestarter;
        if (karmaServerRestarter == null) {
            KarmaServer.$$$reportNull$$$0(3);
        }
        return karmaServerRestarter;
    }

    @Nullable
    public KarmaCoveragePeer getCoveragePeer() {
        return this.myCoveragePeer;
    }

    public void registerStreamEventHandler(@NotNull StreamEventHandler handler) {
        if (handler == null) {
            KarmaServer.$$$reportNull$$$0(4);
        }
        this.myHandlers.put(handler.getEventType(), handler);
    }

    @NotNull
    public ConsoleCommandLineFolder getCommandLineFolder() {
        ConsoleCommandLineFolder consoleCommandLineFolder = this.myCommandLineFolder;
        if (consoleCommandLineFolder == null) {
            KarmaServer.$$$reportNull$$$0(5);
        }
        return consoleCommandLineFolder;
    }

    @NotNull
    private static KillableColoredProcessHandler startServer(@NotNull KarmaServerSettings serverSettings, @Nullable KarmaCoveragePeer coveragePeer, @NotNull ConsoleCommandLineFolder commandLineFolder) throws IOException {
        KillableColoredProcessHandler processHandler;
        if (serverSettings == null) {
            KarmaServer.$$$reportNull$$$0(6);
        }
        if (commandLineFolder == null) {
            KarmaServer.$$$reportNull$$$0(7);
        }
        GeneralCommandLine commandLine = (GeneralCommandLine)ReadAction.compute(() -> {
            if (serverSettings == null) {
                KarmaServer.$$$reportNull$$$0(33);
            }
            if (commandLineFolder == null) {
                KarmaServer.$$$reportNull$$$0(34);
            }
            try {
                return KarmaServer.createCommandLine(serverSettings, coveragePeer, commandLineFolder);
            }
            catch (ExecutionException e) {
                throw new IOException("Can not create command line", e);
            }
        });
        try {
            processHandler = NodeCommandLineUtil.createKillableColoredProcessHandler((GeneralCommandLine)commandLine, (boolean)true);
        }
        catch (ExecutionException e) {
            throw new IOException("Can not start Karma server: " + commandLine.getCommandLineString(), e);
        }
        processHandler.setShouldDestroyProcessRecursively(true);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            KarmaServer.$$$reportNull$$$0(8);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull KarmaServerSettings serverSettings, @Nullable KarmaCoveragePeer coveragePeer, @NotNull ConsoleCommandLineFolder commandLineFolder) throws IOException, ExecutionException {
        if (serverSettings == null) {
            KarmaServer.$$$reportNull$$$0(9);
        }
        if (commandLineFolder == null) {
            KarmaServer.$$$reportNull$$$0(10);
        }
        NodeCommandLineConfigurator configurator = NodeCommandLineConfigurator.find((NodeJsInterpreter)serverSettings.getNodeInterpreter());
        GeneralCommandLine commandLine = new GeneralCommandLine();
        serverSettings.getEnvData().configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)commandLine);
        commandLine.withWorkDirectory(serverSettings.getWorkingDirectorySystemDependent());
        commandLine.setRedirectErrorStream(true);
        List nodeOptionList = ParametersListUtil.parse((String)serverSettings.getNodeOptions().trim());
        commandLine.addParameters(nodeOptionList);
        if (Boolean.parseBoolean((String)commandLine.getEnvironment().get("KARMA_SERVER_WITH_INSPECT_BRK"))) {
            try {
                NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)34598, (boolean)true, (NodeJsInterpreter)serverSettings.getNodeInterpreter(), (boolean)true);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        NodePackage pkg = serverSettings.getKarmaPackage();
        String userConfigFileName = PathUtil.getFileName((String)serverSettings.getConfigurationFilePath());
        boolean angularCli = KarmaUtil.isAngularCliPkg(pkg);
        if (angularCli) {
            commandLine.addParameter(pkg.getSystemDependentPath() + File.separator + "bin" + File.separator + "ng");
            commandLine.addParameter("test");
            commandLineFolder.addPlaceholderTexts(new String[]{"ng", "test"});
            File configFile = KarmaJsSourcesLocator.getInstance().getIntellijConfigFile();
            File workingDir = new File(serverSettings.getWorkingDirectorySystemDependent());
            SemVer version = pkg.getVersion();
            if (version == null || version.isGreaterOrEqualThan(6, 0, 0)) {
                String defaultProject;
                AngularCliConfig config = AngularCliConfig.findProjectConfig(workingDir);
                VirtualFile karmaConfFile = LocalFileSystem.getInstance().findFileByPath(serverSettings.getConfigurationFilePath());
                String string = defaultProject = config != null ? config.getProjectContainingFileOrDefault(karmaConfFile) : null;
                if (defaultProject != null) {
                    commandLine.addParameter(defaultProject);
                    commandLineFolder.addPlaceholderText(defaultProject);
                }
                commandLine.addParameters(new String[]{"--karma-config", configFile.getAbsolutePath()});
                commandLineFolder.addPlaceholderText("--karma-config=" + userConfigFileName);
                commandLine.addParameter("--source-map");
            } else {
                String configPath = FileUtil.getRelativePath((File)workingDir, (File)configFile);
                if (configPath == null) {
                    configPath = configFile.getAbsolutePath();
                }
                commandLine.addParameters(new String[]{"--config", configPath});
                commandLineFolder.addPlaceholderText("--config=" + userConfigFileName);
            }
        } else {
            commandLine.addParameter(pkg.getSystemDependentPath() + File.separator + "bin" + File.separator + "karma");
            commandLine.addParameter("start");
            commandLine.addParameter(KarmaJsSourcesLocator.getInstance().getIntellijConfigFile().getAbsolutePath());
            commandLineFolder.addPlaceholderTexts(new String[]{"karma", "start", userConfigFileName});
        }
        String browsers = serverSettings.getBrowsers();
        if (!StringUtil.isEmptyOrSpaces((String)browsers)) {
            commandLine.addParameter("--browsers=" + browsers);
            commandLineFolder.addLastParameterFrom(commandLine);
        }
        KarmaServer.setIntellijParameter(commandLine, "user-config", configurator.convertLocalPathToRemote(serverSettings.getConfigurationFilePath()));
        if (coveragePeer != null) {
            String coverageDir = configurator.convertLocalPathToRemote(coveragePeer.getCoverageTempDir().getAbsolutePath());
            KarmaServer.setIntellijParameter(commandLine, "coverage-temp-dir", coverageDir);
            if (angularCli) {
                commandLine.addParameter("--code-coverage");
                commandLineFolder.addLastParameterFrom(commandLine);
            }
        }
        if (serverSettings.isDebug()) {
            KarmaServer.setIntellijParameter(commandLine, "debug", "true");
        }
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        configurator.configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            KarmaServer.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    private static void setIntellijParameter(@NotNull GeneralCommandLine commandLine, @NotNull String name, @NotNull String value) {
        if (commandLine == null) {
            KarmaServer.$$$reportNull$$$0(12);
        }
        if (name == null) {
            KarmaServer.$$$reportNull$$$0(13);
        }
        if (value == null) {
            KarmaServer.$$$reportNull$$$0(14);
        }
        commandLine.getEnvironment().put("_INTELLIJ_KARMA_INTERNAL_PARAMETER_" + name, value);
    }

    public void shutdownAsync() {
        LOG.info("Shutting down asynchronously Karma server " + this.myProcessHashCode);
        ApplicationManager.getApplication().executeOnPooledThread(this::shutdown);
    }

    private void shutdown() {
        ProcessHandler processHandler = this.myProcessOutputManager.getProcessHandler();
        if (!processHandler.isProcessTerminated()) {
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)1000L, null);
        }
    }

    @NotNull
    public KarmaProcessOutputManager getProcessOutputManager() {
        KarmaProcessOutputManager karmaProcessOutputManager = this.myProcessOutputManager;
        if (karmaProcessOutputManager == null) {
            KarmaServer.$$$reportNull$$$0(15);
        }
        return karmaProcessOutputManager;
    }

    public boolean isPortBound() {
        return this.myState.getServerPort() != -1;
    }

    public int getServerPort() {
        return this.myState.getServerPort();
    }

    public void onPortBound(@NotNull Runnable callback) {
        if (callback == null) {
            KarmaServer.$$$reportNull$$$0(16);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (callback == null) {
                KarmaServer.$$$reportNull$$$0(32);
            }
            if (this.myOnPortBoundCallbacks != null) {
                this.myOnPortBoundCallbacks.add(callback);
            } else {
                callback.run();
            }
        });
    }

    void fireOnPortBound() {
        UIUtil.invokeLaterIfNeeded(() -> {
            ArrayList callbacks = ContainerUtil.newArrayList(this.myOnPortBoundCallbacks);
            this.myOnPortBoundCallbacks.clear();
            this.myOnPortBoundCallbacks = null;
            for (Runnable callback : callbacks) {
                callback.run();
            }
        });
    }

    public boolean areBrowsersReady() {
        return this.myState.areBrowsersReady();
    }

    public void onBrowsersReady(@NotNull Runnable callback) {
        if (callback == null) {
            KarmaServer.$$$reportNull$$$0(17);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (callback == null) {
                KarmaServer.$$$reportNull$$$0(31);
            }
            if (this.myOnBrowsersReadyCallbacks != null) {
                this.myOnBrowsersReadyCallbacks.add(callback);
            } else {
                callback.run();
            }
        });
    }

    void fireOnBrowsersReady(boolean browsersReady) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (browsersReady) {
                ArrayList callbacks = ContainerUtil.newArrayList(this.myOnBrowsersReadyCallbacks);
                this.myOnBrowsersReadyCallbacks.clear();
                this.myOnBrowsersReadyCallbacks = null;
                for (Runnable callback : callbacks) {
                    callback.run();
                }
            } else {
                this.myOnBrowsersReadyCallbacks = Lists.newCopyOnWriteArrayList();
            }
        });
    }

    public void onTerminated(@NotNull KarmaServerTerminatedListener terminationCallback) {
        if (terminationCallback == null) {
            KarmaServer.$$$reportNull$$$0(18);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (terminationCallback == null) {
                KarmaServer.$$$reportNull$$$0(30);
            }
            if (this.myExitCode != null) {
                terminationCallback.onTerminated(this.myExitCode);
            } else {
                this.myTerminationCallbacks.add(terminationCallback);
            }
        });
    }

    public void removeTerminatedListener(@NotNull KarmaServerTerminatedListener listener) {
        if (listener == null) {
            KarmaServer.$$$reportNull$$$0(19);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (listener == null) {
                KarmaServer.$$$reportNull$$$0(29);
            }
            this.myTerminationCallbacks.remove(listener);
        });
    }

    private void fireOnTerminated(int exitCode) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myExitCode = exitCode;
            ArrayList listeners = ContainerUtil.newArrayList(this.myTerminationCallbacks);
            this.myTerminationCallbacks.clear();
            for (KarmaServerTerminatedListener listener : listeners) {
                listener.onTerminated(exitCode);
            }
        });
    }

    @Nullable
    public KarmaConfig getKarmaConfig() {
        return this.myState.getKarmaConfig();
    }

    @NotNull
    public String formatUrlWithoutUrlRoot(@NotNull String path) {
        if (path == null) {
            KarmaServer.$$$reportNull$$$0(20);
        }
        String string = this.formatUrl(path, false);
        if (string == null) {
            KarmaServer.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String formatUrl(@NotNull String path) {
        if (path == null) {
            KarmaServer.$$$reportNull$$$0(22);
        }
        String string = this.formatUrl(path, true);
        if (string == null) {
            KarmaServer.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private String formatUrl(@NotNull String path, boolean withUrlRoot) {
        KarmaConfig config;
        if (path == null) {
            KarmaServer.$$$reportNull$$$0(24);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((config = this.myState.getKarmaConfig()) != null) {
            String baseUrl = config.getProtocol() + "//" + config.getHostname() + ":" + this.getServerPort();
            String urlRoot = config.getUrlRoot();
            if (!withUrlRoot || "/".equals(urlRoot)) {
                String string = baseUrl + path;
                if (string == null) {
                    KarmaServer.$$$reportNull$$$0(25);
                }
                return string;
            }
            String string = baseUrl + config.getUrlRoot() + path;
            if (string == null) {
                KarmaServer.$$$reportNull$$$0(26);
            }
            return string;
        }
        LOG.error("Karma config not ready");
        String string = "http://localhost:" + this.getServerPort() + path;
        if (string == null) {
            KarmaServer.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessOutputManager.getProcessHandler();
        if (processHandler == null) {
            KarmaServer.$$$reportNull$$$0(28);
        }
        return processHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSettings";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: 
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineFolder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: 
            case 17: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationCallback";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestarter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "startServer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutputManager";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "formatUrlWithoutUrlRoot";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "formatUrl";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerStreamEventHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startServer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIntellijParameter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onPortBound";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onBrowsersReady";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onTerminated";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeTerminatedListener";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "formatUrlWithoutUrlRoot";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "formatUrl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeTerminatedListener$6";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onTerminated$5";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onBrowsersReady$3";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onPortBound$1";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startServer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDisposable
    implements Disposable {
        private final Runnable myRunnable = ConcurrencyUtil.once(() -> {
            LOG.info("Disposing Karma server " + KarmaServer.this.myProcessHashCode);
            if (KarmaServer.this.myCoveragePeer != null) {
                FileUtil.asyncDelete((File)KarmaServer.this.myCoveragePeer.getCoverageTempDir());
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (KarmaServer.this.myOnPortBoundCallbacks != null) {
                    KarmaServer.this.myOnPortBoundCallbacks.clear();
                }
                if (KarmaServer.this.myOnBrowsersReadyCallbacks != null) {
                    KarmaServer.this.myOnBrowsersReadyCallbacks.clear();
                }
            });
            KarmaServer.this.shutdown();
        });

        private MyDisposable() {
        }

        public void dispose() {
            this.myRunnable.run();
        }
    }
}

