/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.concurrency.JobScheduler;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.CatchingConsumer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServerRegistry {
    private static final Logger LOG = Logger.getInstance(KarmaServerRegistry.class);
    private final Project myProject;
    private final ConcurrentMap<String, KarmaServer> myServerByConfigFile;
    private final ConcurrentMap<KarmaServerSettings, KarmaServer> myServers;
    private final ConcurrentMap<KarmaServerSettings, KarmaServerSettings> myStartingServers;

    public KarmaServerRegistry(@NotNull Project project) {
        if (project == null) {
            KarmaServerRegistry.$$$reportNull$$$0(0);
        }
        this.myServerByConfigFile = new ConcurrentHashMap<String, KarmaServer>();
        this.myServers = new ConcurrentHashMap<KarmaServerSettings, KarmaServer>();
        this.myStartingServers = new ConcurrentHashMap<KarmaServerSettings, KarmaServerSettings>();
        this.myProject = project;
    }

    @NotNull
    public static KarmaServerRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            KarmaServerRegistry.$$$reportNull$$$0(1);
        }
        KarmaServerRegistry karmaServerRegistry = (KarmaServerRegistry)ServiceManager.getService((Project)project, KarmaServerRegistry.class);
        if (karmaServerRegistry == null) {
            KarmaServerRegistry.$$$reportNull$$$0(2);
        }
        return karmaServerRegistry;
    }

    @Nullable
    public KarmaServer getServer(@NotNull KarmaServerSettings serverSettings) {
        if (serverSettings == null) {
            KarmaServerRegistry.$$$reportNull$$$0(3);
        }
        return (KarmaServer)this.myServers.get(serverSettings);
    }

    public void startServer(final @NotNull KarmaServerSettings serverSettings, final CatchingConsumer<KarmaServer, Exception> consumer) {
        KarmaServer prevServer;
        if (serverSettings == null) {
            KarmaServerRegistry.$$$reportNull$$$0(4);
        }
        if ((prevServer = (KarmaServer)this.myServerByConfigFile.get(serverSettings.getConfigurationFilePath())) != null) {
            prevServer.onTerminated(new KarmaServerTerminatedListener(){

                @Override
                public void onTerminated(int exitCode) {
                    KarmaServerRegistry.this.doStartServer(serverSettings, (CatchingConsumer<KarmaServer, Exception>)consumer);
                }
            });
            prevServer.shutdownAsync();
        } else {
            this.doStartServer(serverSettings, consumer);
        }
    }

    private void doStartServer(final @NotNull KarmaServerSettings serverSettings, @NotNull CatchingConsumer<KarmaServer, Exception> consumer) {
        if (serverSettings == null) {
            KarmaServerRegistry.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            KarmaServerRegistry.$$$reportNull$$$0(6);
        }
        if (this.myStartingServers.putIfAbsent(serverSettings, serverSettings) != null) {
            LOG.warn(new Throwable("Unexpected subsequent karma server starting:" + serverSettings.toString()));
            JobScheduler.getScheduler().schedule(() -> {
                if (serverSettings == null) {
                    KarmaServerRegistry.$$$reportNull$$$0(11);
                }
                if (consumer == null) {
                    KarmaServerRegistry.$$$reportNull$$$0(12);
                }
                this.startServer(serverSettings, consumer);
            }, 100L, TimeUnit.MILLISECONDS);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (serverSettings == null) {
                KarmaServerRegistry.$$$reportNull$$$0(7);
            }
            if (consumer == null) {
                KarmaServerRegistry.$$$reportNull$$$0(8);
            }
            try {
                KarmaServer server;
                try {
                    server = new KarmaServer(this.myProject, serverSettings);
                    this.myServers.put(serverSettings, server);
                    this.myServerByConfigFile.put(serverSettings.getConfigurationFilePath(), server);
                }
                finally {
                    this.myStartingServers.remove(serverSettings);
                }
                server.onTerminated(new KarmaServerTerminatedListener(){

                    @Override
                    public void onTerminated(int exitCode) {
                        KarmaServerRegistry.this.myServers.remove(serverSettings, server);
                        KarmaServerRegistry.this.myServerByConfigFile.remove(serverSettings.getConfigurationFilePath(), server);
                    }
                });
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (consumer == null) {
                        KarmaServerRegistry.$$$reportNull$$$0(10);
                    }
                    consumer.consume((Object)server);
                });
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (consumer == null) {
                        KarmaServerRegistry.$$$reportNull$$$0(9);
                    }
                    consumer.consume((Throwable)e);
                });
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerRegistry";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSettings";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startServer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doStartServer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doStartServer$3";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doStartServer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

