/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class KarmaServerRestarter {
    private final AtomicInteger myActiveRunners;
    private final AtomicBoolean myConfigChanged;
    private boolean myRestartRequested;

    public KarmaServerRestarter(@NotNull File configurationFile, @NotNull Disposable parentDisposable) {
        if (configurationFile == null) {
            KarmaServerRestarter.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            KarmaServerRestarter.$$$reportNull$$$0(1);
        }
        this.myActiveRunners = new AtomicInteger(0);
        this.myConfigChanged = new AtomicBoolean(false);
        this.myRestartRequested = false;
        this.listenForConfigurationFileChanges(configurationFile, parentDisposable);
    }

    private void listenForConfigurationFileChanges(@NotNull File configurationFile, @NotNull Disposable parentDisposable) {
        if (configurationFile == null) {
            KarmaServerRestarter.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            KarmaServerRestarter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configurationFile == null) {
                KarmaServerRestarter.$$$reportNull$$$0(5);
            }
            if (parentDisposable == null) {
                KarmaServerRestarter.$$$reportNull$$$0(6);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                Document document;
                VirtualFile virtualFile;
                if (configurationFile == null) {
                    KarmaServerRestarter.$$$reportNull$$$0(7);
                }
                if (parentDisposable == null) {
                    KarmaServerRestarter.$$$reportNull$$$0(8);
                }
                if ((virtualFile = LocalFileSystem.getInstance().findFileByIoFile(configurationFile)) != null && virtualFile.isValid() && !virtualFile.isDirectory() && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null && !Disposer.isDisposed((Disposable)parentDisposable)) {
                    document.addDocumentListener(new DocumentListener(){

                        public void documentChanged(@NotNull DocumentEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            KarmaServerRestarter.this.myConfigChanged.set(true);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/karma/server/KarmaServerRestarter$1", "documentChanged"));
                        }
                    }, parentDisposable);
                }
            });
        }, ModalityState.any());
    }

    public void onRunnerExecutionStarted(final @NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            KarmaServerRestarter.$$$reportNull$$$0(4);
        }
        this.myActiveRunners.incrementAndGet();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                KarmaServerRestarter.this.myActiveRunners.decrementAndGet();
                processHandler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/KarmaServerRestarter$2", "processTerminated"));
            }
        });
    }

    public boolean isRestartRequired() {
        return this.myActiveRunners.get() == 0 && (this.myRestartRequested || this.myConfigChanged.get());
    }

    public void requestRestart() {
        this.myRestartRequested = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerRestarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "listenForConfigurationFileChanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onRunnerExecutionStarted";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$listenForConfigurationFileChanges$1";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

