/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.server.CapturedBrowser;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServerState {
    private static final Logger LOG = Logger.getInstance(KarmaServerState.class);
    private static final String BROWSER_CONNECTED_EVENT_TYPE = "browserConnected";
    private static final String BROWSER_DISCONNECTED_EVENT_TYPE = "browserDisconnected";
    private static final Pattern SERVER_PORT_LINE_PATTERN = Pattern.compile("Karma.+server started at http[s]?://[^:]+:(\\d+)/.*$");
    private static final String[][] FAILED_TO_START_BROWSER_PATTERNS = new String[][]{{"ERROR [launcher]: No binary for ", " browser on your platform.\n"}, {"ERROR [launcher]: Cannot start ", "\n"}};
    private final KarmaServer myServer;
    private final List<String> myOverriddenBrowsers;
    private final ConcurrentMap<String, CapturedBrowser> myCapturedBrowsers;
    private final AtomicInteger myBoundServerPort;
    private final AtomicBoolean myBrowsersReady;
    private final List<String> myFailedToStartBrowsers;
    private volatile KarmaConfig myConfig;

    public KarmaServerState(@NotNull KarmaServer server, @NotNull File configurationFile) {
        if (server == null) {
            KarmaServerState.$$$reportNull$$$0(0);
        }
        if (configurationFile == null) {
            KarmaServerState.$$$reportNull$$$0(1);
        }
        this.myCapturedBrowsers = Maps.newConcurrentMap();
        this.myBoundServerPort = new AtomicInteger(-1);
        this.myBrowsersReady = new AtomicBoolean(false);
        this.myFailedToStartBrowsers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myServer = server;
        this.myOverriddenBrowsers = KarmaServerState.parseBrowsers(server.getServerSettings().getBrowsers());
        this.myServer.registerStreamEventHandler(new BrowserEventHandler(BROWSER_CONNECTED_EVENT_TYPE));
        this.myServer.registerStreamEventHandler(new BrowserEventHandler(BROWSER_DISCONNECTED_EVENT_TYPE));
        this.myServer.registerStreamEventHandler(new BrowserCapturingFailedEventHandler());
        this.myServer.registerStreamEventHandler(new ConfigHandler(configurationFile, server.getServerSettings().getNodeInterpreter()));
    }

    @Nullable
    private static List<String> parseBrowsers(@NotNull String browsersStr) {
        if (browsersStr == null) {
            KarmaServerState.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)browsersStr)) {
            return null;
        }
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return splitter.splitToList((CharSequence)browsersStr);
    }

    private void handleBrowsersChange(@NotNull String eventType, @NotNull String browserId, @NotNull String browserName, @Nullable Boolean autoCaptured) {
        if (eventType == null) {
            KarmaServerState.$$$reportNull$$$0(3);
        }
        if (browserId == null) {
            KarmaServerState.$$$reportNull$$$0(4);
        }
        if (browserName == null) {
            KarmaServerState.$$$reportNull$$$0(5);
        }
        if (BROWSER_CONNECTED_EVENT_TYPE.equals(eventType)) {
            CapturedBrowser browser = new CapturedBrowser(browserName, browserId, (Boolean)ObjectUtils.notNull((Object)autoCaptured, (Object)true));
            this.myCapturedBrowsers.put(browserId, browser);
        } else {
            this.myCapturedBrowsers.remove(browserId);
        }
        this.updateBrowsersReadyStatus();
    }

    private void updateBrowsersReadyStatus() {
        boolean ready = this.isCapturedBrowsersQuorum();
        if (this.myBrowsersReady.compareAndSet(!ready, ready)) {
            this.myServer.fireOnBrowsersReady(ready);
        }
    }

    private boolean isCapturedBrowsersQuorum() {
        List<String> expectedBrowsers = this.myOverriddenBrowsers;
        if (expectedBrowsers == null) {
            KarmaConfig config = this.myConfig;
            if (config == null) {
                return true;
            }
            expectedBrowsers = config.getBrowsers();
        }
        HashSet expectedBrowserSet = ContainerUtil.newHashSet(expectedBrowsers);
        expectedBrowserSet.removeAll(this.myFailedToStartBrowsers);
        if (this.myCapturedBrowsers.values().stream().anyMatch(o -> !o.isAutoCaptured())) {
            return true;
        }
        long autoCapturedCount = this.myCapturedBrowsers.values().stream().filter(o -> o.isAutoCaptured()).count();
        return autoCapturedCount > 0L && (long)expectedBrowserSet.size() <= autoCapturedCount;
    }

    public boolean areBrowsersReady() {
        return this.myBrowsersReady.get();
    }

    @NotNull
    public Collection<CapturedBrowser> getCapturedBrowsers() {
        Collection<CapturedBrowser> collection = this.myCapturedBrowsers.values();
        if (collection == null) {
            KarmaServerState.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public int getServerPort() {
        return this.myBoundServerPort.get();
    }

    @Nullable
    public KarmaConfig getKarmaConfig() {
        return this.myConfig;
    }

    public void onStandardOutputLineAvailable(@NotNull String line) {
        String failedToStartBrowser;
        int serverPort;
        if (line == null) {
            KarmaServerState.$$$reportNull$$$0(7);
        }
        if ((serverPort = this.myBoundServerPort.get()) == -1 && (serverPort = KarmaServerState.parseServerPort(line)) != -1 && this.myBoundServerPort.compareAndSet(-1, serverPort)) {
            this.myServer.fireOnPortBound();
        }
        if (!this.myBrowsersReady.get() && (failedToStartBrowser = KarmaServerState.parseFailedToStartBrowser(line)) != null) {
            this.onBrowserCapturingFailed(failedToStartBrowser);
        }
    }

    private void onBrowserCapturingFailed(@NotNull String notCapturedBrowser) {
        if (notCapturedBrowser == null) {
            KarmaServerState.$$$reportNull$$$0(8);
        }
        LOG.info("Browser " + notCapturedBrowser + " failed to be captured");
        this.myFailedToStartBrowsers.add(notCapturedBrowser);
        this.updateBrowsersReadyStatus();
    }

    @Nullable
    private static String parseFailedToStartBrowser(@NotNull String line) {
        if (line == null) {
            KarmaServerState.$$$reportNull$$$0(9);
        }
        for (String[] pattern : FAILED_TO_START_BROWSER_PATTERNS) {
            String failedToStartBrowser = KarmaServerState.getInnerSubstring(line, pattern[0], pattern[1]);
            if (failedToStartBrowser == null) continue;
            return failedToStartBrowser;
        }
        return null;
    }

    private static int parseServerPort(@NotNull String text) {
        Matcher m;
        if (text == null) {
            KarmaServerState.$$$reportNull$$$0(10);
        }
        if ((m = SERVER_PORT_LINE_PATTERN.matcher(text)).find()) {
            String portStr = m.group(1);
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                LOG.warn("Can't parse web server port from '" + text + "'");
            }
        }
        return -1;
    }

    @Nullable
    private static String getInnerSubstring(@NotNull String str, @NotNull String prefix, @NotNull String suffix) {
        if (str == null) {
            KarmaServerState.$$$reportNull$$$0(11);
        }
        if (prefix == null) {
            KarmaServerState.$$$reportNull$$$0(12);
        }
        if (suffix == null) {
            KarmaServerState.$$$reportNull$$$0(13);
        }
        if (str.startsWith(prefix) && str.endsWith(suffix) && prefix.length() + suffix.length() <= str.length()) {
            return str.substring(prefix.length(), str.length() - suffix.length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browsersStr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerState";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notCapturedBrowser";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedBrowsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseBrowsers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleBrowsersChange";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onStandardOutputLineAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onBrowserCapturingFailed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseFailedToStartBrowser";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseServerPort";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInnerSubstring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BrowserCapturingFailedEventHandler
    implements StreamEventHandler {
        private BrowserCapturingFailedEventHandler() {
        }

        @Override
        @NotNull
        public String getEventType() {
            if ("browserCapturingFailed" == null) {
                BrowserCapturingFailedEventHandler.$$$reportNull$$$0(0);
            }
            return "browserCapturingFailed";
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                BrowserCapturingFailedEventHandler.$$$reportNull$$$0(1);
            }
            if (!eventBody.isJsonObject()) {
                LOG.warn("Not an object");
                return;
            }
            String name = JsonUtil.getChildAsString((JsonObject)eventBody.getAsJsonObject(), (String)"browserLauncherName");
            if (name != null) {
                KarmaServerState.this.onBrowserCapturingFailed(name);
            } else {
                LOG.warn("Unspecified name");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerState$BrowserCapturingFailedEventHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventBody";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEventType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerState$BrowserCapturingFailedEventHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ConfigHandler
    implements StreamEventHandler {
        private final File myConfigurationFileDir;
        private final NodeJsInterpreter myInterpreter;

        ConfigHandler(@NotNull File configurationFile, NodeJsInterpreter interpreter) {
            if (configurationFile == null) {
                ConfigHandler.$$$reportNull$$$0(0);
            }
            if (interpreter == null) {
                ConfigHandler.$$$reportNull$$$0(1);
            }
            this.myConfigurationFileDir = configurationFile.getParentFile();
            this.myInterpreter = interpreter;
        }

        @Override
        @NotNull
        public String getEventType() {
            if ("configFile" == null) {
                ConfigHandler.$$$reportNull$$$0(2);
            }
            return "configFile";
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                ConfigHandler.$$$reportNull$$$0(3);
            }
            KarmaServerState.this.myConfig = KarmaConfig.parseFromJson(eventBody, this.myConfigurationFileDir, this.myInterpreter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerState$ConfigHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventBody";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerState$ConfigHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEventType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class BrowserEventHandler
    implements StreamEventHandler {
        private final String myEventType;

        private BrowserEventHandler(String eventType) {
            if (eventType == null) {
                BrowserEventHandler.$$$reportNull$$$0(0);
            }
            this.myEventType = eventType;
        }

        @Override
        @NotNull
        public String getEventType() {
            String string = this.myEventType;
            if (string == null) {
                BrowserEventHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                BrowserEventHandler.$$$reportNull$$$0(2);
            }
            if (eventBody.isJsonObject()) {
                JsonObject event = eventBody.getAsJsonObject();
                String id = JsonUtil.getChildAsString((JsonObject)event, (String)"id");
                String name = JsonUtil.getChildAsString((JsonObject)event, (String)"name");
                Boolean autoCaptured = JsonUtil.getChildAsBooleanObj((JsonObject)event, (String)"isAutoCaptured");
                if (id != null && name != null) {
                    KarmaServerState.this.handleBrowsersChange(this.myEventType, id, name, autoCaptured);
                } else {
                    LOG.warn("Illegal browser event. Type: " + this.myEventType + ", body: " + eventBody.toString());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerState$BrowserEventHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventBody";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerState$BrowserEventHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEventType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

