/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.util;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentDescriptorReusePolicy;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class KarmaUtil {
    public static final String KARMA_PACKAGE_NAME = "karma";
    public static final String ANGULAR_CLI__PACKAGE_NAME = "@angular/cli";
    public static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor(new String[]{"@angular/cli", "karma"});
    private static final String[] STARTING_PARTS = new String[]{"karma"};
    private static final String NAME_PART_DELIMITERS = ".-";
    private static final String[] BEFORE_EXT_PARTS = new String[]{"conf", "karma"};
    private static final String[] EXTENSIONS = new String[]{"js", "coffee", "es6", "ts"};
    private static final String[] MOST_RELEVANT_NAMES = new String[]{"karma.conf", "karma-conf", "karma-js.conf"};

    private KarmaUtil() {
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            KarmaUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList result = ContainerUtil.newArrayList();
        for (FileType type : JSLanguageUtil.getFileTypesCompilableToJavaScript()) {
            Collection files = FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope);
            for (VirtualFile file : files) {
                if (file == null || !file.isValid() || file.isDirectory() || !KarmaUtil.isKarmaConfigFile(file.getNameSequence(), false) || JSLibraryUtil.isProbableLibraryFile((VirtualFile)file)) continue;
                result.add(file);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            KarmaUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static boolean isKarmaConfigFile(@NotNull CharSequence filename, boolean matchMostRelevantNamesOnly) {
        int len;
        int extensionInd;
        if (filename == null) {
            KarmaUtil.$$$reportNull$$$0(2);
        }
        if ((extensionInd = StringUtil.lastIndexOf((CharSequence)filename, (char)'.', (int)0, (int)(len = filename.length()))) == -1) {
            return false;
        }
        boolean extMatched = false;
        for (String ext : EXTENSIONS) {
            if (ext.length() != len - extensionInd - 1 || !StringUtil.endsWith((CharSequence)filename, (CharSequence)ext)) continue;
            extMatched = true;
            break;
        }
        if (matchMostRelevantNamesOnly) {
            return KarmaUtil.isStartingPartMatched(filename, MOST_RELEVANT_NAMES);
        }
        if (!extMatched) {
            return false;
        }
        for (String beforeExtPart : BEFORE_EXT_PARTS) {
            int startOffset = extensionInd - beforeExtPart.length();
            if (startOffset <= 0 || !CharArrayUtil.regionMatches((CharSequence)filename, (int)startOffset, (CharSequence)beforeExtPart) || NAME_PART_DELIMITERS.indexOf(filename.charAt(startOffset - 1)) < 0) continue;
            return !StringUtil.contains((CharSequence)filename, (CharSequence)"protractor");
        }
        return KarmaUtil.isStartingPartMatched(filename, STARTING_PARTS);
    }

    private static boolean isStartingPartMatched(@NotNull CharSequence filename, @NotNull String[] startingParts) {
        if (filename == null) {
            KarmaUtil.$$$reportNull$$$0(3);
        }
        if (startingParts == null) {
            KarmaUtil.$$$reportNull$$$0(4);
        }
        for (String startingPart : startingParts) {
            if (startingPart.length() >= filename.length() || !CharArrayUtil.regionMatches((CharSequence)filename, (int)0, (CharSequence)startingPart) || NAME_PART_DELIMITERS.indexOf(filename.charAt(startingPart.length())) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathUnderContentRoots(@NotNull Project project, @NotNull NodePackage pkg) {
        VirtualFile file;
        if (project == null) {
            KarmaUtil.$$$reportNull$$$0(5);
        }
        if (pkg == null) {
            KarmaUtil.$$$reportNull$$$0(6);
        }
        if ((file = LocalFileFinder.findFile((String)pkg.getSystemIndependentPath())) == null || !file.isValid()) {
            return false;
        }
        VirtualFile contentRoot = JSLibraryUtil.getContentRootForFile((Project)project, (VirtualFile)file);
        return contentRoot != null;
    }

    @NotNull
    public static RunContentDescriptor createDefaultDescriptor(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        ExecutionConsole console;
        if (executionResult == null) {
            KarmaUtil.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            KarmaUtil.$$$reportNull$$$0(8);
        }
        KarmaServer server = (console = executionResult.getExecutionConsole()) instanceof KarmaConsoleView ? ((KarmaConsoleView)console).getKarmaServer() : null;
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, environment);
        RunContentDescriptor descriptor = contentBuilder.showRunContent(environment.getContentToReuse());
        RunContentDescriptor runContentDescriptor = KarmaUtil.withReusePolicy(descriptor, server);
        if (runContentDescriptor == null) {
            KarmaUtil.$$$reportNull$$$0(9);
        }
        return runContentDescriptor;
    }

    @NotNull
    public static RunContentDescriptor withReusePolicy(@NotNull RunContentDescriptor descriptor, final @Nullable KarmaServer karmaServer) {
        if (descriptor == null) {
            KarmaUtil.$$$reportNull$$$0(10);
        }
        descriptor.setReusePolicy(new RunContentDescriptorReusePolicy(){

            public boolean canBeReusedBy(@NotNull RunContentDescriptor newDescriptor) {
                if (newDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (karmaServer == null || karmaServer.getProcessHandler().isProcessTerminated()) {
                    return true;
                }
                KarmaConsoleView newConsole = (KarmaConsoleView)((Object)ObjectUtils.tryCast((Object)newDescriptor.getExecutionConsole(), KarmaConsoleView.class));
                return newConsole != null && newConsole.getKarmaServer().equals(karmaServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDescriptor", "com/intellij/javascript/karma/util/KarmaUtil$1", "canBeReusedBy"));
            }
        });
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            KarmaUtil.$$$reportNull$$$0(11);
        }
        return runContentDescriptor;
    }

    public static boolean isAngularCliPkg(@NotNull NodePackage pkg) {
        if (pkg == null) {
            KarmaUtil.$$$reportNull$$$0(12);
        }
        return pkg.getSystemIndependentPath().endsWith("/@angular/cli");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/util/KarmaUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingParts";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/util/KarmaUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withReusePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isKarmaConfigFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStartingPartMatched";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPathUnderContentRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withReusePolicy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAngularCliPkg";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

