try {
  if (hasInspectArg()) {
    return;
  }

  let port = findAvailablePort();
  if (!port) {
    console.error("Error in JetBrains node debug connector: Failed to detect opened port");
    return;
  }

  let fs = require("fs");
  let portsFile = process.env["JB_DEBUG_FILE"];
  fs.appendFileSync(portsFile, port + "\n")

  let inspector = require("inspector");
  inspector.open(port, undefined, true);
}
catch (e) {
  console.error("Error in JetBrains node debug connector: ", e)
}

function hasInspectArg() {
  return process.execArgv.find(
      arg => arg === "--inspect" || arg === "--inspect-brk" || arg.startsWith("--inspect-brk=") || arg.startsWith("--inspect=")
  );
}

function findAvailablePort() {
  let net = require("net");
  let server = net.createServer().listen(0);
  let port;
  try {
    let startTime = Date.now();
    do {
      let address = server.address();
      if (address) {
        port = address.port;
      }
    } while (!port && (Date.now() - startTime < 500));
  }
  finally {
    server.close();
  }
  return port;
}