using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class ActionsModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<ActionExecuteRequest> Execute { get { return _Execute; }}
    [NotNull] public RdEndpoint<ActionUpdateRequest, PresentationModel> Update { get { return _Update; }}
    [NotNull] public IRdProperty<bool> EscapeAvailability { get { return _EscapeAvailability; }}
    [NotNull] public IRdProperty<bool> DotMemoryUnitAvailability { get { return _DotMemoryUnitAvailability; }}
    [NotNull] public IViewableMap<string, ActionDescriptionBaseModel> TransferredActionGroups { get { return _TransferredActionGroups; }}
    
    //private fields
    [NotNull] private readonly RdProperty<ActionExecuteRequest> _Execute;
    [NotNull] private readonly RdEndpoint<ActionUpdateRequest, PresentationModel> _Update;
    [NotNull] private readonly RdProperty<bool> _EscapeAvailability;
    [NotNull] private readonly RdProperty<bool> _DotMemoryUnitAvailability;
    [NotNull] private readonly RdMap<string, ActionDescriptionBaseModel> _TransferredActionGroups;
    
    //primary constructor
    private ActionsModel(
      [NotNull] RdProperty<ActionExecuteRequest> execute,
      [NotNull] RdEndpoint<ActionUpdateRequest, PresentationModel> update,
      [NotNull] RdProperty<bool> escapeAvailability,
      [NotNull] RdProperty<bool> dotMemoryUnitAvailability,
      [NotNull] RdMap<string, ActionDescriptionBaseModel> transferredActionGroups
    )
    {
      if (execute == null) throw new ArgumentNullException("execute");
      if (update == null) throw new ArgumentNullException("update");
      if (escapeAvailability == null) throw new ArgumentNullException("escapeAvailability");
      if (dotMemoryUnitAvailability == null) throw new ArgumentNullException("dotMemoryUnitAvailability");
      if (transferredActionGroups == null) throw new ArgumentNullException("transferredActionGroups");
      
      _Execute = execute;
      _Update = update;
      _EscapeAvailability = escapeAvailability;
      _DotMemoryUnitAvailability = dotMemoryUnitAvailability;
      _TransferredActionGroups = transferredActionGroups;
      _EscapeAvailability.OptimizeNested = true;
      _DotMemoryUnitAvailability.OptimizeNested = true;
      _TransferredActionGroups.OptimizeNested = true;
      _Update.Async = true;
      _Execute.ValueCanBeNull = true;
      _Update.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("execute", _Execute));
      BindableChildren.Add(new KeyValuePair<string, object>("update", _Update));
      BindableChildren.Add(new KeyValuePair<string, object>("escapeAvailability", _EscapeAvailability));
      BindableChildren.Add(new KeyValuePair<string, object>("dotMemoryUnitAvailability", _DotMemoryUnitAvailability));
      BindableChildren.Add(new KeyValuePair<string, object>("transferredActionGroups", _TransferredActionGroups));
    }
    //secondary constructor
    private ActionsModel (
    ) : this (
      new RdProperty<ActionExecuteRequest>(ReadActionExecuteRequestNullable, WriteActionExecuteRequestNullable),
      new RdEndpoint<ActionUpdateRequest, PresentationModel>(ActionUpdateRequest.Read, ActionUpdateRequest.Write, ReadPresentationModelNullable, WritePresentationModelNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdMap<string, ActionDescriptionBaseModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ActionDescriptionBaseModel.Read, ActionDescriptionBaseModel.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<ActionExecuteRequest> ReadActionExecuteRequestNullable = ActionExecuteRequest.Read.NullableClass();
    public static CtxReadDelegate<PresentationModel> ReadPresentationModelNullable = PresentationModel.Read.NullableClass();
    
    public static CtxWriteDelegate<ActionExecuteRequest> WriteActionExecuteRequestNullable = ActionExecuteRequest.Write.NullableClass();
    public static CtxWriteDelegate<PresentationModel> WritePresentationModelNullable = PresentationModel.Write.NullableClass();
    
    protected override long SerializationHash => -5962708909840516126L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(TextControlConstant.Read, TextControlConstant.Write);
      serializers.Register(ClipboardTextConstant.Read, ClipboardTextConstant.Write);
      serializers.Register(SelectedItemsConstant.Read, SelectedItemsConstant.Write);
      serializers.Register(RdFileStructureConstant.Read, RdFileStructureConstant.Write);
      serializers.Register(ActionExecuteSyncHandshake.Read, ActionExecuteSyncHandshake.Write);
      serializers.Register(ActionExecuteRequest.Read, ActionExecuteRequest.Write);
      serializers.Register(PresentationModel.Read, PresentationModel.Write);
      serializers.Register(ActionUpdateRequest.Read, ActionUpdateRequest.Write);
      serializers.Register(ActionSeparatorModel.Read, ActionSeparatorModel.Write);
      serializers.Register(ActionDescriptionModel.Read, ActionDescriptionModel.Write);
      serializers.Register(ActionDescriptionActionGroup.Read, ActionDescriptionActionGroup.Write);
      serializers.Register(RdDataConstant_Unknown.Read, RdDataConstant_Unknown.Write);
      serializers.Register(ActionDescriptionBaseModel_Unknown.Read, ActionDescriptionBaseModel_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public ActionsModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionsModel (");
      using (printer.IndentCookie()) {
        printer.Print("execute = "); _Execute.PrintEx(printer); printer.Println();
        printer.Print("update = "); _Update.PrintEx(printer); printer.Println();
        printer.Print("escapeAvailability = "); _EscapeAvailability.PrintEx(printer); printer.Println();
        printer.Print("dotMemoryUnitAvailability = "); _DotMemoryUnitAvailability.PrintEx(printer); printer.Println();
        printer.Print("transferredActionGroups = "); _TransferredActionGroups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionDescriptionActionGroup : ActionDescriptionBaseModel
  {
    //fields
    //public fields
    [NotNull] public string ActionId {get; private set;}
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Description {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<ActionDescriptionBaseModel> SubItems {get; private set;}
    
    //private fields
    //primary constructor
    public ActionDescriptionActionGroup(
      [NotNull] string actionId,
      [NotNull] string name,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<ActionDescriptionBaseModel> subItems
    )
    {
      if (actionId == null) throw new ArgumentNullException("actionId");
      if (name == null) throw new ArgumentNullException("name");
      if (description == null) throw new ArgumentNullException("description");
      if (subItems == null) throw new ArgumentNullException("subItems");
      
      ActionId = actionId;
      Name = name;
      Description = description;
      Icon = icon;
      SubItems = subItems;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ActionDescriptionActionGroup> Read = (ctx, reader) => 
    {
      var actionId = reader.ReadString();
      var name = reader.ReadString();
      var description = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var subItems = ReadActionDescriptionBaseModelList(ctx, reader);
      return new ActionDescriptionActionGroup(actionId, name, description, icon, subItems);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<ActionDescriptionBaseModel>> ReadActionDescriptionBaseModelList = ActionDescriptionBaseModel.Read.List();
    
    public static new CtxWriteDelegate<ActionDescriptionActionGroup> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ActionId);
      writer.Write(value.Name);
      writer.Write(value.Description);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteActionDescriptionBaseModelList(ctx, writer, value.SubItems);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<ActionDescriptionBaseModel>> WriteActionDescriptionBaseModelList = ActionDescriptionBaseModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ActionDescriptionActionGroup) obj);
    }
    public bool Equals(ActionDescriptionActionGroup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ActionId == other.ActionId && Name == other.Name && Description == other.Description && Equals(Icon, other.Icon) && SubItems.SequenceEqual(other.SubItems);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ActionId.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Description.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(SubItems);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ActionDescriptionActionGroup (");
      using (printer.IndentCookie()) {
        printer.Print("actionId = "); ActionId.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("subItems = "); SubItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ActionDescriptionBaseModel{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ActionDescriptionBaseModel> Read = Polymorphic<ActionDescriptionBaseModel>.ReadAbstract(ActionDescriptionBaseModel_Unknown.Read);
    
    public static CtxWriteDelegate<ActionDescriptionBaseModel> Write = Polymorphic<ActionDescriptionBaseModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class ActionDescriptionBaseModel_Unknown : ActionDescriptionBaseModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ActionDescriptionBaseModel_Unknown> Read = (ctx, reader) => 
    {
      return new ActionDescriptionBaseModel_Unknown();
    };
    
    public static new CtxWriteDelegate<ActionDescriptionBaseModel_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ActionDescriptionBaseModel_Unknown) obj);
    }
    public bool Equals(ActionDescriptionBaseModel_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ActionDescriptionBaseModel_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionDescriptionModel : ActionDescriptionBaseModel
  {
    //fields
    //public fields
    [NotNull] public string ActionId {get; private set;}
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Description {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string DefaultShortcutText {get; private set;}
    
    //private fields
    //primary constructor
    public ActionDescriptionModel(
      [NotNull] string actionId,
      [NotNull] string name,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string defaultShortcutText
    )
    {
      if (actionId == null) throw new ArgumentNullException("actionId");
      if (name == null) throw new ArgumentNullException("name");
      if (description == null) throw new ArgumentNullException("description");
      if (defaultShortcutText == null) throw new ArgumentNullException("defaultShortcutText");
      
      ActionId = actionId;
      Name = name;
      Description = description;
      Icon = icon;
      DefaultShortcutText = defaultShortcutText;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ActionDescriptionModel> Read = (ctx, reader) => 
    {
      var actionId = reader.ReadString();
      var name = reader.ReadString();
      var description = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var defaultShortcutText = reader.ReadString();
      return new ActionDescriptionModel(actionId, name, description, icon, defaultShortcutText);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<ActionDescriptionModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ActionId);
      writer.Write(value.Name);
      writer.Write(value.Description);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.DefaultShortcutText);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ActionDescriptionModel) obj);
    }
    public bool Equals(ActionDescriptionModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ActionId == other.ActionId && Name == other.Name && Description == other.Description && Equals(Icon, other.Icon) && DefaultShortcutText == other.DefaultShortcutText;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ActionId.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Description.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + DefaultShortcutText.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ActionDescriptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("actionId = "); ActionId.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("defaultShortcutText = "); DefaultShortcutText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionExecuteRequest : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<RdDataConstant> DataContext {get; private set;}
    [NotNull] public string ActionId {get; private set;}
    [NotNull] public IRdProperty<ActionExecuteSyncHandshake> Handshake { get { return _Handshake; }}
    [NotNull] public IRdProperty<bool?> Result { get { return _Result; }}
    
    //private fields
    [NotNull] private readonly RdProperty<ActionExecuteSyncHandshake> _Handshake;
    [NotNull] private readonly RdProperty<bool?> _Result;
    
    //primary constructor
    private ActionExecuteRequest(
      [NotNull] List<RdDataConstant> dataContext,
      [NotNull] string actionId,
      [NotNull] RdProperty<ActionExecuteSyncHandshake> handshake,
      [NotNull] RdProperty<bool?> result
    )
    {
      if (dataContext == null) throw new ArgumentNullException("dataContext");
      if (actionId == null) throw new ArgumentNullException("actionId");
      if (handshake == null) throw new ArgumentNullException("handshake");
      if (result == null) throw new ArgumentNullException("result");
      
      DataContext = dataContext;
      ActionId = actionId;
      _Handshake = handshake;
      _Result = result;
      _Result.OptimizeNested = true;
      _Handshake.ValueCanBeNull = true;
      _Result.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("handshake", _Handshake));
      BindableChildren.Add(new KeyValuePair<string, object>("result", _Result));
    }
    //secondary constructor
    public ActionExecuteRequest (
      [NotNull] List<RdDataConstant> dataContext,
      [NotNull] string actionId
    ) : this (
      dataContext,
      actionId,
      new RdProperty<ActionExecuteSyncHandshake>(ReadActionExecuteSyncHandshakeNullable, WriteActionExecuteSyncHandshakeNullable),
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<ActionExecuteRequest> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var dataContext = ReadRdDataConstantList(ctx, reader);
      var actionId = reader.ReadString();
      var handshake = RdProperty<ActionExecuteSyncHandshake>.Read(ctx, reader, ReadActionExecuteSyncHandshakeNullable, WriteActionExecuteSyncHandshakeNullable);
      var result = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      return new ActionExecuteRequest(dataContext, actionId, handshake, result).WithId(_id);
    };
    public static CtxReadDelegate<List<RdDataConstant>> ReadRdDataConstantList = RdDataConstant.Read.List();
    public static CtxReadDelegate<ActionExecuteSyncHandshake> ReadActionExecuteSyncHandshakeNullable = ActionExecuteSyncHandshake.Read.NullableClass();
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static CtxWriteDelegate<ActionExecuteRequest> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdDataConstantList(ctx, writer, value.DataContext);
      writer.Write(value.ActionId);
      RdProperty<ActionExecuteSyncHandshake>.Write(ctx, writer, value._Handshake);
      RdProperty<bool?>.Write(ctx, writer, value._Result);
    };
    public static CtxWriteDelegate<List<RdDataConstant>> WriteRdDataConstantList = RdDataConstant.Write.List();
    public static CtxWriteDelegate<ActionExecuteSyncHandshake> WriteActionExecuteSyncHandshakeNullable = ActionExecuteSyncHandshake.Write.NullableClass();
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionExecuteRequest (");
      using (printer.IndentCookie()) {
        printer.Print("dataContext = "); DataContext.PrintEx(printer); printer.Println();
        printer.Print("actionId = "); ActionId.PrintEx(printer); printer.Println();
        printer.Print("handshake = "); _Handshake.PrintEx(printer); printer.Println();
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionExecuteSyncHandshake : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public ISink<RdVoid> Result { get { return _Result; }}
    [NotNull] public ISource<RdVoid> BackendResult { get { return _BackendResult; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Result;
    [NotNull] private readonly RdSignal<RdVoid> _BackendResult;
    
    //primary constructor
    private ActionExecuteSyncHandshake(
      [NotNull] RdSignal<RdVoid> result,
      [NotNull] RdSignal<RdVoid> backendResult
    )
    {
      if (result == null) throw new ArgumentNullException("result");
      if (backendResult == null) throw new ArgumentNullException("backendResult");
      
      _Result = result;
      _BackendResult = backendResult;
      BindableChildren.Add(new KeyValuePair<string, object>("result", _Result));
      BindableChildren.Add(new KeyValuePair<string, object>("backendResult", _BackendResult));
    }
    //secondary constructor
    public ActionExecuteSyncHandshake (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<ActionExecuteSyncHandshake> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var result = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var backendResult = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new ActionExecuteSyncHandshake(result, backendResult).WithId(_id);
    };
    
    public static CtxWriteDelegate<ActionExecuteSyncHandshake> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._Result);
      RdSignal<RdVoid>.Write(ctx, writer, value._BackendResult);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionExecuteSyncHandshake (");
      using (printer.IndentCookie()) {
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
        printer.Print("backendResult = "); _BackendResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionSeparatorModel : ActionDescriptionBaseModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ActionSeparatorModel> Read = (ctx, reader) => 
    {
      return new ActionSeparatorModel();
    };
    
    public static new CtxWriteDelegate<ActionSeparatorModel> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ActionSeparatorModel) obj);
    }
    public bool Equals(ActionSeparatorModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ActionSeparatorModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionUpdateRequest : IPrintable, IEquatable<ActionUpdateRequest>
  {
    //fields
    //public fields
    [NotNull] public string Place {get; private set;}
    [NotNull] public List<RdDataConstant> DataContext {get; private set;}
    [NotNull] public string ActionId {get; private set;}
    public bool UpdateImmediately {get; private set;}
    
    //private fields
    //primary constructor
    public ActionUpdateRequest(
      [NotNull] string place,
      [NotNull] List<RdDataConstant> dataContext,
      [NotNull] string actionId,
      bool updateImmediately
    )
    {
      if (place == null) throw new ArgumentNullException("place");
      if (dataContext == null) throw new ArgumentNullException("dataContext");
      if (actionId == null) throw new ArgumentNullException("actionId");
      
      Place = place;
      DataContext = dataContext;
      ActionId = actionId;
      UpdateImmediately = updateImmediately;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ActionUpdateRequest> Read = (ctx, reader) => 
    {
      var place = reader.ReadString();
      var dataContext = ReadRdDataConstantList(ctx, reader);
      var actionId = reader.ReadString();
      var updateImmediately = reader.ReadBool();
      return new ActionUpdateRequest(place, dataContext, actionId, updateImmediately);
    };
    public static CtxReadDelegate<List<RdDataConstant>> ReadRdDataConstantList = RdDataConstant.Read.List();
    
    public static CtxWriteDelegate<ActionUpdateRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Place);
      WriteRdDataConstantList(ctx, writer, value.DataContext);
      writer.Write(value.ActionId);
      writer.Write(value.UpdateImmediately);
    };
    public static CtxWriteDelegate<List<RdDataConstant>> WriteRdDataConstantList = RdDataConstant.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ActionUpdateRequest) obj);
    }
    public bool Equals(ActionUpdateRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Place == other.Place && DataContext.SequenceEqual(other.DataContext) && ActionId == other.ActionId && UpdateImmediately == other.UpdateImmediately;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Place.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(DataContext);
        hash = hash * 31 + ActionId.GetHashCode();
        hash = hash * 31 + UpdateImmediately.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ActionUpdateRequest (");
      using (printer.IndentCookie()) {
        printer.Print("place = "); Place.PrintEx(printer); printer.Println();
        printer.Print("dataContext = "); DataContext.PrintEx(printer); printer.Println();
        printer.Print("actionId = "); ActionId.PrintEx(printer); printer.Println();
        printer.Print("updateImmediately = "); UpdateImmediately.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ClipboardTextConstant : RdDataConstant
  {
    //fields
    //public fields
    [CanBeNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public ClipboardTextConstant(
      [CanBeNull] string text
    )
    {
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ClipboardTextConstant> Read = (ctx, reader) => 
    {
      var text = ReadStringNullable(ctx, reader);
      return new ClipboardTextConstant(text);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<ClipboardTextConstant> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Text);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ClipboardTextConstant) obj);
    }
    public bool Equals(ClipboardTextConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Text, other.Text);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Text != null ?Text.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ClipboardTextConstant (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PresentationModel : IPrintable, IEquatable<PresentationModel>
  {
    //fields
    //public fields
    public bool IsEnabled {get; private set;}
    public bool IsVisible {get; private set;}
    [CanBeNull] public string Text {get; private set;}
    [CanBeNull] public string Description {get; private set;}
    
    //private fields
    //primary constructor
    public PresentationModel(
      bool isEnabled,
      bool isVisible,
      [CanBeNull] string text,
      [CanBeNull] string description
    )
    {
      IsEnabled = isEnabled;
      IsVisible = isVisible;
      Text = text;
      Description = description;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PresentationModel> Read = (ctx, reader) => 
    {
      var isEnabled = reader.ReadBool();
      var isVisible = reader.ReadBool();
      var text = ReadStringNullable(ctx, reader);
      var description = ReadStringNullable(ctx, reader);
      return new PresentationModel(isEnabled, isVisible, text, description);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<PresentationModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsEnabled);
      writer.Write(value.IsVisible);
      WriteStringNullable(ctx, writer, value.Text);
      WriteStringNullable(ctx, writer, value.Description);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((PresentationModel) obj);
    }
    public bool Equals(PresentationModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsEnabled == other.IsEnabled && IsVisible == other.IsVisible && Equals(Text, other.Text) && Equals(Description, other.Description);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsEnabled.GetHashCode();
        hash = hash * 31 + IsVisible.GetHashCode();
        hash = hash * 31 + (Text != null ?Text.GetHashCode() : 0);
        hash = hash * 31 + (Description != null ?Description.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("PresentationModel (");
      using (printer.IndentCookie()) {
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isVisible = "); IsVisible.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdDataConstant{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDataConstant> Read = Polymorphic<RdDataConstant>.ReadAbstract(RdDataConstant_Unknown.Read);
    
    public static CtxWriteDelegate<RdDataConstant> Write = Polymorphic<RdDataConstant>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdDataConstant_Unknown : RdDataConstant
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdDataConstant_Unknown> Read = (ctx, reader) => 
    {
      return new RdDataConstant_Unknown();
    };
    
    public static new CtxWriteDelegate<RdDataConstant_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDataConstant_Unknown) obj);
    }
    public bool Equals(RdDataConstant_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDataConstant_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFileStructureConstant : RdDataConstant
  {
    //fields
    //public fields
    public int SelectedIndex {get; private set;}
    
    //private fields
    //primary constructor
    public RdFileStructureConstant(
      int selectedIndex
    )
    {
      SelectedIndex = selectedIndex;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdFileStructureConstant> Read = (ctx, reader) => 
    {
      var selectedIndex = reader.ReadInt();
      return new RdFileStructureConstant(selectedIndex);
    };
    
    public static new CtxWriteDelegate<RdFileStructureConstant> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SelectedIndex);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFileStructureConstant) obj);
    }
    public bool Equals(RdFileStructureConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SelectedIndex == other.SelectedIndex;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SelectedIndex.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFileStructureConstant (");
      using (printer.IndentCookie()) {
        printer.Print("selectedIndex = "); SelectedIndex.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SelectedItemsConstant : RdDataConstant
  {
    //fields
    //public fields
    [NotNull] public List<int> Items {get; private set;}
    
    //private fields
    //primary constructor
    public SelectedItemsConstant(
      [NotNull] List<int> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SelectedItemsConstant> Read = (ctx, reader) => 
    {
      var items = ReadIntList(ctx, reader);
      return new SelectedItemsConstant(items);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static new CtxWriteDelegate<SelectedItemsConstant> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SelectedItemsConstant) obj);
    }
    public bool Equals(SelectedItemsConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SelectedItemsConstant (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlConstant : RdDataConstant
  {
    //fields
    //public fields
    [CanBeNull] public TextControlId Id {get; private set;}
    
    //private fields
    //primary constructor
    public TextControlConstant(
      [CanBeNull] TextControlId id
    )
    {
      Id = id;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<TextControlConstant> Read = (ctx, reader) => 
    {
      var id = ReadTextControlIdNullable(ctx, reader);
      return new TextControlConstant(id);
    };
    public static CtxReadDelegate<TextControlId> ReadTextControlIdNullable = TextControlId.Read.NullableClass();
    
    public static new CtxWriteDelegate<TextControlConstant> Write = (ctx, writer, value) => 
    {
      WriteTextControlIdNullable(ctx, writer, value.Id);
    };
    public static CtxWriteDelegate<TextControlId> WriteTextControlIdNullable = TextControlId.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextControlConstant) obj);
    }
    public bool Equals(TextControlConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Id, other.Id);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Id != null ?Id.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlConstant (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
