using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class AltEnterModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Popups.IRdPopupMenuModel> AltEnterPopup { get { return _AltEnterPopup; }}
    [NotNull] public IRdProperty<bool> AltEnterPopupRequested { get { return _AltEnterPopupRequested; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Popups.IRdPopupMenuModel> _AltEnterPopup;
    [NotNull] private readonly RdProperty<bool> _AltEnterPopupRequested;
    
    //primary constructor
    private AltEnterModel(
      [NotNull] RdProperty<JetBrains.Rider.Model.Popups.IRdPopupMenuModel> altEnterPopup,
      [NotNull] RdProperty<bool> altEnterPopupRequested
    )
    {
      if (altEnterPopup == null) throw new ArgumentNullException("altEnterPopup");
      if (altEnterPopupRequested == null) throw new ArgumentNullException("altEnterPopupRequested");
      
      _AltEnterPopup = altEnterPopup;
      _AltEnterPopupRequested = altEnterPopupRequested;
      _AltEnterPopupRequested.OptimizeNested = true;
      _AltEnterPopupRequested.Async = true;
      _AltEnterPopup.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("altEnterPopup", _AltEnterPopup));
      BindableChildren.Add(new KeyValuePair<string, object>("altEnterPopupRequested", _AltEnterPopupRequested));
    }
    //secondary constructor
    internal AltEnterModel (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.Popups.IRdPopupMenuModel>(ReadIRdPopupMenuModelNullable, WriteIRdPopupMenuModelNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Popups.IRdPopupMenuModel> ReadIRdPopupMenuModelNullable = JetBrains.Rider.Model.Popups.IRdPopupMenuModel.Read.NullableClass();
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Popups.IRdPopupMenuModel> WriteIRdPopupMenuModelNullable = JetBrains.Rider.Model.Popups.IRdPopupMenuModel.Write.NullableClass();
    
    protected override long SerializationHash => 2209839084465745223L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AltEnterModel (");
      using (printer.IndentCookie()) {
        printer.Print("altEnterPopup = "); _AltEnterPopup.PrintEx(printer); printer.Println();
        printer.Print("altEnterPopupRequested = "); _AltEnterPopupRequested.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionAltEnterModelEx
   {
    public static AltEnterModel GetAltEnterModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("altEnterModel", () => new AltEnterModel());
    }
  }
}
