using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class AssemblyExplorerModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdAssemblyExplorerItem> Items { get { return _Items; }}
    [NotNull] public ISource<int?> UpdateView { get { return _UpdateView; }}
    [NotNull] public ISource<RdSelectRequest> Select { get { return _Select; }}
    [NotNull] public IRdProperty<string> ExternalSourceDirectory { get { return _ExternalSourceDirectory; }}
    [NotNull] public IRdProperty<bool> Ready { get { return _Ready; }}
    [NotNull] public RdEndpoint<RdVoid, RdVoid> Show { get { return _Show; }}
    [NotNull] public RdEndpoint<int, RdVoid> Expand { get { return _Expand; }}
    [NotNull] public RdEndpoint<RdNavigateRequest, RdVoid> Navigate { get { return _Navigate; }}
    [NotNull] public RdEndpoint<RdNavigateToFileRequest, RdVoid> NavigateToFile { get { return _NavigateToFile; }}
    [NotNull] public RdEndpoint<List<string>, RdVoid> AddFromFiles { get { return _AddFromFiles; }}
    [NotNull] public RdEndpoint<int, RdVoid> AddFromProjectModel { get { return _AddFromProjectModel; }}
    [NotNull] public IViewableMap<int, RdAddLibrarySession> AddLibrarySessions { get { return _AddLibrarySessions; }}
    [NotNull] public RdEndpoint<string, RdVoid> OpenList { get { return _OpenList; }}
    [NotNull] public RdEndpoint<string, RdVoid> SaveList { get { return _SaveList; }}
    [NotNull] public RdEndpoint<int, RdVoid> Remove { get { return _Remove; }}
    [NotNull] public RdEndpoint<RdVoid, RdVoid> Clear { get { return _Clear; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdAssemblyExplorerItem> _Items;
    [NotNull] private readonly RdSignal<int?> _UpdateView;
    [NotNull] private readonly RdSignal<RdSelectRequest> _Select;
    [NotNull] private readonly RdProperty<string> _ExternalSourceDirectory;
    [NotNull] private readonly RdProperty<bool> _Ready;
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _Show;
    [NotNull] private readonly RdEndpoint<int, RdVoid> _Expand;
    [NotNull] private readonly RdEndpoint<RdNavigateRequest, RdVoid> _Navigate;
    [NotNull] private readonly RdEndpoint<RdNavigateToFileRequest, RdVoid> _NavigateToFile;
    [NotNull] private readonly RdEndpoint<List<string>, RdVoid> _AddFromFiles;
    [NotNull] private readonly RdEndpoint<int, RdVoid> _AddFromProjectModel;
    [NotNull] private readonly RdMap<int, RdAddLibrarySession> _AddLibrarySessions;
    [NotNull] private readonly RdEndpoint<string, RdVoid> _OpenList;
    [NotNull] private readonly RdEndpoint<string, RdVoid> _SaveList;
    [NotNull] private readonly RdEndpoint<int, RdVoid> _Remove;
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _Clear;
    
    //primary constructor
    private AssemblyExplorerModel(
      [NotNull] RdMap<int, RdAssemblyExplorerItem> items,
      [NotNull] RdSignal<int?> updateView,
      [NotNull] RdSignal<RdSelectRequest> select,
      [NotNull] RdProperty<string> externalSourceDirectory,
      [NotNull] RdProperty<bool> ready,
      [NotNull] RdEndpoint<RdVoid, RdVoid> show,
      [NotNull] RdEndpoint<int, RdVoid> expand,
      [NotNull] RdEndpoint<RdNavigateRequest, RdVoid> navigate,
      [NotNull] RdEndpoint<RdNavigateToFileRequest, RdVoid> navigateToFile,
      [NotNull] RdEndpoint<List<string>, RdVoid> addFromFiles,
      [NotNull] RdEndpoint<int, RdVoid> addFromProjectModel,
      [NotNull] RdMap<int, RdAddLibrarySession> addLibrarySessions,
      [NotNull] RdEndpoint<string, RdVoid> openList,
      [NotNull] RdEndpoint<string, RdVoid> saveList,
      [NotNull] RdEndpoint<int, RdVoid> remove,
      [NotNull] RdEndpoint<RdVoid, RdVoid> clear
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      if (updateView == null) throw new ArgumentNullException("updateView");
      if (select == null) throw new ArgumentNullException("select");
      if (externalSourceDirectory == null) throw new ArgumentNullException("externalSourceDirectory");
      if (ready == null) throw new ArgumentNullException("ready");
      if (show == null) throw new ArgumentNullException("show");
      if (expand == null) throw new ArgumentNullException("expand");
      if (navigate == null) throw new ArgumentNullException("navigate");
      if (navigateToFile == null) throw new ArgumentNullException("navigateToFile");
      if (addFromFiles == null) throw new ArgumentNullException("addFromFiles");
      if (addFromProjectModel == null) throw new ArgumentNullException("addFromProjectModel");
      if (addLibrarySessions == null) throw new ArgumentNullException("addLibrarySessions");
      if (openList == null) throw new ArgumentNullException("openList");
      if (saveList == null) throw new ArgumentNullException("saveList");
      if (remove == null) throw new ArgumentNullException("remove");
      if (clear == null) throw new ArgumentNullException("clear");
      
      _Items = items;
      _UpdateView = updateView;
      _Select = select;
      _ExternalSourceDirectory = externalSourceDirectory;
      _Ready = ready;
      _Show = show;
      _Expand = expand;
      _Navigate = navigate;
      _NavigateToFile = navigateToFile;
      _AddFromFiles = addFromFiles;
      _AddFromProjectModel = addFromProjectModel;
      _AddLibrarySessions = addLibrarySessions;
      _OpenList = openList;
      _SaveList = saveList;
      _Remove = remove;
      _Clear = clear;
      _Items.OptimizeNested = true;
      _ExternalSourceDirectory.OptimizeNested = true;
      _Ready.OptimizeNested = true;
      _UpdateView.ValueCanBeNull = true;
      _ExternalSourceDirectory.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
      BindableChildren.Add(new KeyValuePair<string, object>("updateView", _UpdateView));
      BindableChildren.Add(new KeyValuePair<string, object>("select", _Select));
      BindableChildren.Add(new KeyValuePair<string, object>("externalSourceDirectory", _ExternalSourceDirectory));
      BindableChildren.Add(new KeyValuePair<string, object>("ready", _Ready));
      BindableChildren.Add(new KeyValuePair<string, object>("show", _Show));
      BindableChildren.Add(new KeyValuePair<string, object>("expand", _Expand));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateToFile", _NavigateToFile));
      BindableChildren.Add(new KeyValuePair<string, object>("addFromFiles", _AddFromFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("addFromProjectModel", _AddFromProjectModel));
      BindableChildren.Add(new KeyValuePair<string, object>("addLibrarySessions", _AddLibrarySessions));
      BindableChildren.Add(new KeyValuePair<string, object>("openList", _OpenList));
      BindableChildren.Add(new KeyValuePair<string, object>("saveList", _SaveList));
      BindableChildren.Add(new KeyValuePair<string, object>("remove", _Remove));
      BindableChildren.Add(new KeyValuePair<string, object>("clear", _Clear));
    }
    //secondary constructor
    internal AssemblyExplorerModel (
    ) : this (
      new RdMap<int, RdAssemblyExplorerItem>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdAssemblyExplorerItem.Read, RdAssemblyExplorerItem.Write),
      new RdSignal<int?>(ReadIntNullable, WriteIntNullable),
      new RdSignal<RdSelectRequest>(RdSelectRequest.Read, RdSelectRequest.Write),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<int, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdNavigateRequest, RdVoid>(RdNavigateRequest.Read, RdNavigateRequest.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdNavigateToFileRequest, RdVoid>(RdNavigateToFileRequest.Read, RdNavigateToFileRequest.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<List<string>, RdVoid>(ReadStringList, WriteStringList, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<int, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdMap<int, RdAddLibrarySession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdAddLibrarySession.Read, RdAddLibrarySession.Write),
      new RdEndpoint<string, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<string, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<int, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    
    protected override long SerializationHash => 1159506090031833541L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdAssemblyExplorerItemDescriptor.Read, RdAssemblyExplorerItemDescriptor.Write);
      serializers.Register(RdAssemblyExplorerEmptyDescriptor.Read, RdAssemblyExplorerEmptyDescriptor.Write);
      serializers.Register(RdAssemblyExplorerItem.Read, RdAssemblyExplorerItem.Write);
      serializers.Register(RdAddLibrarySession.Read, RdAddLibrarySession.Write);
      serializers.Register(RdSelectRequest.Read, RdSelectRequest.Write);
      serializers.Register(RdNavigateRequest.Read, RdNavigateRequest.Write);
      serializers.Register(RdNavigateToFileRequest.Read, RdNavigateToFileRequest.Write);
      serializers.Register(RdAssemblyExplorerDescriptorBase_Unknown.Read, RdAssemblyExplorerDescriptorBase_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AssemblyExplorerModel (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("updateView = "); _UpdateView.PrintEx(printer); printer.Println();
        printer.Print("select = "); _Select.PrintEx(printer); printer.Println();
        printer.Print("externalSourceDirectory = "); _ExternalSourceDirectory.PrintEx(printer); printer.Println();
        printer.Print("ready = "); _Ready.PrintEx(printer); printer.Println();
        printer.Print("show = "); _Show.PrintEx(printer); printer.Println();
        printer.Print("expand = "); _Expand.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("navigateToFile = "); _NavigateToFile.PrintEx(printer); printer.Println();
        printer.Print("addFromFiles = "); _AddFromFiles.PrintEx(printer); printer.Println();
        printer.Print("addFromProjectModel = "); _AddFromProjectModel.PrintEx(printer); printer.Println();
        printer.Print("addLibrarySessions = "); _AddLibrarySessions.PrintEx(printer); printer.Println();
        printer.Print("openList = "); _OpenList.PrintEx(printer); printer.Println();
        printer.Print("saveList = "); _SaveList.PrintEx(printer); printer.Println();
        printer.Print("remove = "); _Remove.PrintEx(printer); printer.Println();
        printer.Print("clear = "); _Clear.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionAssemblyExplorerModelEx
   {
    public static AssemblyExplorerModel GetAssemblyExplorerModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("assemblyExplorerModel", () => new AssemblyExplorerModel());
    }
  }
  
  
  public class RdAddLibrarySession : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<string>> LibraryPaths { get { return _LibraryPaths; }}
    [NotNull] public RdEndpoint<List<string>, RdVoid> Add { get { return _Add; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<string>> _LibraryPaths;
    [NotNull] private readonly RdEndpoint<List<string>, RdVoid> _Add;
    
    //primary constructor
    private RdAddLibrarySession(
      [NotNull] RdProperty<List<string>> libraryPaths,
      [NotNull] RdEndpoint<List<string>, RdVoid> add
    )
    {
      if (libraryPaths == null) throw new ArgumentNullException("libraryPaths");
      if (add == null) throw new ArgumentNullException("add");
      
      _LibraryPaths = libraryPaths;
      _Add = add;
      _LibraryPaths.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("libraryPaths", _LibraryPaths));
      BindableChildren.Add(new KeyValuePair<string, object>("add", _Add));
    }
    //secondary constructor
    public RdAddLibrarySession (
    ) : this (
      new RdProperty<List<string>>(ReadStringList, WriteStringList),
      new RdEndpoint<List<string>, RdVoid>(ReadStringList, WriteStringList, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdAddLibrarySession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var libraryPaths = RdProperty<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      var add = RdEndpoint<List<string>, RdVoid>.Read(ctx, reader, ReadStringList, WriteStringList, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdAddLibrarySession(libraryPaths, add).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdAddLibrarySession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<List<string>>.Write(ctx, writer, value._LibraryPaths);
      RdEndpoint<List<string>, RdVoid>.Write(ctx, writer, value._Add);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddLibrarySession (");
      using (printer.IndentCookie()) {
        printer.Print("libraryPaths = "); _LibraryPaths.PrintEx(printer); printer.Println();
        printer.Print("add = "); _Add.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdAssemblyExplorerDescriptorBase{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdAssemblyExplorerDescriptorBase> Read = Polymorphic<RdAssemblyExplorerDescriptorBase>.ReadAbstract(RdAssemblyExplorerDescriptorBase_Unknown.Read);
    
    public static CtxWriteDelegate<RdAssemblyExplorerDescriptorBase> Write = Polymorphic<RdAssemblyExplorerDescriptorBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdAssemblyExplorerDescriptorBase_Unknown : RdAssemblyExplorerDescriptorBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdAssemblyExplorerDescriptorBase_Unknown> Read = (ctx, reader) => 
    {
      return new RdAssemblyExplorerDescriptorBase_Unknown();
    };
    
    public static new CtxWriteDelegate<RdAssemblyExplorerDescriptorBase_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAssemblyExplorerDescriptorBase_Unknown) obj);
    }
    public bool Equals(RdAssemblyExplorerDescriptorBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAssemblyExplorerDescriptorBase_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAssemblyExplorerEmptyDescriptor : RdAssemblyExplorerDescriptorBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdAssemblyExplorerEmptyDescriptor> Read = (ctx, reader) => 
    {
      return new RdAssemblyExplorerEmptyDescriptor();
    };
    
    public static new CtxWriteDelegate<RdAssemblyExplorerEmptyDescriptor> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAssemblyExplorerEmptyDescriptor) obj);
    }
    public bool Equals(RdAssemblyExplorerEmptyDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAssemblyExplorerEmptyDescriptor (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAssemblyExplorerItem : IPrintable, IEquatable<RdAssemblyExplorerItem>
  {
    //fields
    //public fields
    [CanBeNull] public int? ParentId {get; private set;}
    [NotNull] public RdAssemblyExplorerDescriptorBase Descriptor {get; private set;}
    
    //private fields
    //primary constructor
    public RdAssemblyExplorerItem(
      [CanBeNull] int? parentId,
      [NotNull] RdAssemblyExplorerDescriptorBase descriptor
    )
    {
      if (descriptor == null) throw new ArgumentNullException("descriptor");
      
      ParentId = parentId;
      Descriptor = descriptor;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdAssemblyExplorerItem> Read = (ctx, reader) => 
    {
      var parentId = ReadIntNullable(ctx, reader);
      var descriptor = RdAssemblyExplorerDescriptorBase.Read(ctx, reader);
      return new RdAssemblyExplorerItem(parentId, descriptor);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<RdAssemblyExplorerItem> Write = (ctx, writer, value) => 
    {
      WriteIntNullable(ctx, writer, value.ParentId);
      RdAssemblyExplorerDescriptorBase.Write(ctx, writer, value.Descriptor);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAssemblyExplorerItem) obj);
    }
    public bool Equals(RdAssemblyExplorerItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ParentId, other.ParentId) && Equals(Descriptor, other.Descriptor);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (ParentId != null ?ParentId.GetHashCode() : 0);
        hash = hash * 31 + Descriptor.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAssemblyExplorerItem (");
      using (printer.IndentCookie()) {
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("descriptor = "); Descriptor.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAssemblyExplorerItemDescriptor : RdAssemblyExplorerDescriptorBase
  {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [CanBeNull] public string Path {get; private set;}
    public int SortKey {get; private set;}
    public bool CanNavigate {get; private set;}
    public bool IsAssemblyReference {get; private set;}
    public bool IsAssemblyFile {get; private set;}
    public bool HasChildren {get; private set;}
    
    //private fields
    //primary constructor
    public RdAssemblyExplorerItemDescriptor(
      [NotNull] string name,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [CanBeNull] string path,
      int sortKey,
      bool canNavigate,
      bool isAssemblyReference,
      bool isAssemblyFile,
      bool hasChildren
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      
      Name = name;
      Icon = icon;
      Path = path;
      SortKey = sortKey;
      CanNavigate = canNavigate;
      IsAssemblyReference = isAssemblyReference;
      IsAssemblyFile = isAssemblyFile;
      HasChildren = hasChildren;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdAssemblyExplorerItemDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var path = ReadStringNullable(ctx, reader);
      var sortKey = reader.ReadInt();
      var canNavigate = reader.ReadBool();
      var isAssemblyReference = reader.ReadBool();
      var isAssemblyFile = reader.ReadBool();
      var hasChildren = reader.ReadBool();
      return new RdAssemblyExplorerItemDescriptor(name, icon, path, sortKey, canNavigate, isAssemblyReference, isAssemblyFile, hasChildren);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdAssemblyExplorerItemDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteStringNullable(ctx, writer, value.Path);
      writer.Write(value.SortKey);
      writer.Write(value.CanNavigate);
      writer.Write(value.IsAssemblyReference);
      writer.Write(value.IsAssemblyFile);
      writer.Write(value.HasChildren);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAssemblyExplorerItemDescriptor) obj);
    }
    public bool Equals(RdAssemblyExplorerItemDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Icon, other.Icon) && Equals(Path, other.Path) && SortKey == other.SortKey && CanNavigate == other.CanNavigate && IsAssemblyReference == other.IsAssemblyReference && IsAssemblyFile == other.IsAssemblyFile && HasChildren == other.HasChildren;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + (Path != null ?Path.GetHashCode() : 0);
        hash = hash * 31 + SortKey.GetHashCode();
        hash = hash * 31 + CanNavigate.GetHashCode();
        hash = hash * 31 + IsAssemblyReference.GetHashCode();
        hash = hash * 31 + IsAssemblyFile.GetHashCode();
        hash = hash * 31 + HasChildren.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAssemblyExplorerItemDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("sortKey = "); SortKey.PrintEx(printer); printer.Println();
        printer.Print("canNavigate = "); CanNavigate.PrintEx(printer); printer.Println();
        printer.Print("isAssemblyReference = "); IsAssemblyReference.PrintEx(printer); printer.Println();
        printer.Print("isAssemblyFile = "); IsAssemblyFile.PrintEx(printer); printer.Println();
        printer.Print("hasChildren = "); HasChildren.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNavigateRequest : IPrintable, IEquatable<RdNavigateRequest>
  {
    //fields
    //public fields
    public int Id {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdNavigateRequest(
      int id,
      bool requestFocus
    )
    {
      Id = id;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNavigateRequest> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdNavigateRequest(id, requestFocus);
    };
    
    public static CtxWriteDelegate<RdNavigateRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNavigateRequest) obj);
    }
    public bool Equals(RdNavigateRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNavigateRequest (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNavigateToFileRequest : IPrintable, IEquatable<RdNavigateToFileRequest>
  {
    //fields
    //public fields
    [NotNull] public string Path {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdNavigateToFileRequest(
      [NotNull] string path,
      bool requestFocus
    )
    {
      if (path == null) throw new ArgumentNullException("path");
      
      Path = path;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNavigateToFileRequest> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      var requestFocus = reader.ReadBool();
      return new RdNavigateToFileRequest(path, requestFocus);
    };
    
    public static CtxWriteDelegate<RdNavigateToFileRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNavigateToFileRequest) obj);
    }
    public bool Equals(RdNavigateToFileRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Path == other.Path && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Path.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNavigateToFileRequest (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSelectRequest : IPrintable, IEquatable<RdSelectRequest>
  {
    //fields
    //public fields
    public int Id {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdSelectRequest(
      int id,
      bool requestFocus
    )
    {
      Id = id;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSelectRequest> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdSelectRequest(id, requestFocus);
    };
    
    public static CtxWriteDelegate<RdSelectRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSelectRequest) obj);
    }
    public bool Equals(RdSelectRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSelectRequest (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
