using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class BuildModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Ready { get { return _Ready; }}
    [NotNull] public IRdProperty<BuildArgs> Request { get { return _Request; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.BuildSession> BuildSession { get { return _BuildSession; }}
    [NotNull] public RdEndpoint<bool, RdVoid> SetIncrementalBuildAvailability { get { return _SetIncrementalBuildAvailability; }}
    [NotNull] public RdEndpoint<RdVoid, string> DumpSolutionBuilderState { get { return _DumpSolutionBuilderState; }}
    [NotNull] public RdEndpoint<RdVoid, string> DumpBuildReasons { get { return _DumpBuildReasons; }}
    [NotNull] public IRdProperty<bool> IncrementalBuildInConsistentState { get { return _IncrementalBuildInConsistentState; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Ready;
    [NotNull] private readonly RdProperty<BuildArgs> _Request;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.BuildSession> _BuildSession;
    [NotNull] private readonly RdEndpoint<bool, RdVoid> _SetIncrementalBuildAvailability;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DumpSolutionBuilderState;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DumpBuildReasons;
    [NotNull] private readonly RdProperty<bool> _IncrementalBuildInConsistentState;
    
    //primary constructor
    private BuildModel(
      [NotNull] RdProperty<bool> ready,
      [NotNull] RdProperty<BuildArgs> request,
      [NotNull] RdProperty<JetBrains.Rider.Model.BuildSession> buildSession,
      [NotNull] RdEndpoint<bool, RdVoid> setIncrementalBuildAvailability,
      [NotNull] RdEndpoint<RdVoid, string> dumpSolutionBuilderState,
      [NotNull] RdEndpoint<RdVoid, string> dumpBuildReasons,
      [NotNull] RdProperty<bool> incrementalBuildInConsistentState
    )
    {
      if (ready == null) throw new ArgumentNullException("ready");
      if (request == null) throw new ArgumentNullException("request");
      if (buildSession == null) throw new ArgumentNullException("buildSession");
      if (setIncrementalBuildAvailability == null) throw new ArgumentNullException("setIncrementalBuildAvailability");
      if (dumpSolutionBuilderState == null) throw new ArgumentNullException("dumpSolutionBuilderState");
      if (dumpBuildReasons == null) throw new ArgumentNullException("dumpBuildReasons");
      if (incrementalBuildInConsistentState == null) throw new ArgumentNullException("incrementalBuildInConsistentState");
      
      _Ready = ready;
      _Request = request;
      _BuildSession = buildSession;
      _SetIncrementalBuildAvailability = setIncrementalBuildAvailability;
      _DumpSolutionBuilderState = dumpSolutionBuilderState;
      _DumpBuildReasons = dumpBuildReasons;
      _IncrementalBuildInConsistentState = incrementalBuildInConsistentState;
      _Ready.OptimizeNested = true;
      _Request.OptimizeNested = true;
      _IncrementalBuildInConsistentState.OptimizeNested = true;
      _Request.ValueCanBeNull = true;
      _BuildSession.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("ready", _Ready));
      BindableChildren.Add(new KeyValuePair<string, object>("request", _Request));
      BindableChildren.Add(new KeyValuePair<string, object>("buildSession", _BuildSession));
      BindableChildren.Add(new KeyValuePair<string, object>("setIncrementalBuildAvailability", _SetIncrementalBuildAvailability));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpSolutionBuilderState", _DumpSolutionBuilderState));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpBuildReasons", _DumpBuildReasons));
      BindableChildren.Add(new KeyValuePair<string, object>("incrementalBuildInConsistentState", _IncrementalBuildInConsistentState));
    }
    //secondary constructor
    private BuildModel (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<BuildArgs>(ReadBuildArgsNullable, WriteBuildArgsNullable),
      new RdProperty<JetBrains.Rider.Model.BuildSession>(ReadBuildSessionNullable, WriteBuildSessionNullable),
      new RdEndpoint<bool, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<BuildArgs> ReadBuildArgsNullable = BuildArgs.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.BuildSession> ReadBuildSessionNullable = JetBrains.Rider.Model.BuildSession.Read.NullableClass();
    
    public static CtxWriteDelegate<BuildArgs> WriteBuildArgsNullable = BuildArgs.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.BuildSession> WriteBuildSessionNullable = JetBrains.Rider.Model.BuildSession.Write.NullableClass();
    
    protected override long SerializationHash => -3462202362453256823L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<BuildEventKind>();
      serializers.RegisterEnum<BuildResultKind>();
      serializers.Register(BuildTarget.Read, BuildTarget.Write);
      serializers.Register(RebuildTarget.Read, RebuildTarget.Write);
      serializers.Register(CleanTarget.Read, CleanTarget.Write);
      serializers.Register(CustomTarget.Read, CustomTarget.Write);
      serializers.Register(CustomTargetWithExtraProperties.Read, CustomTargetWithExtraProperties.Write);
      serializers.Register(BuildEvent.Read, BuildEvent.Write);
      serializers.Register(ProjectId.Read, ProjectId.Write);
      serializers.Register(ConsoleBuildEvent.Read, ConsoleBuildEvent.Write);
      serializers.RegisterEnum<BuildMessageKind>();
      serializers.Register(MessageBuildEvent.Read, MessageBuildEvent.Write);
      serializers.Register(WarningBuildEvent.Read, WarningBuildEvent.Write);
      serializers.Register(ErrorBuildEvent.Read, ErrorBuildEvent.Write);
      serializers.Register(BuildResult.Read, BuildResult.Write);
      serializers.Register(BuildSessionOutput.Read, BuildSessionOutput.Write);
      serializers.Register(JetBrains.Rider.Model.BuildSession.Read, JetBrains.Rider.Model.BuildSession.Write);
      serializers.Register(BuildArgs.Read, BuildArgs.Write);
      serializers.Register(CustomTargetExtraProperty.Read, CustomTargetExtraProperty.Write);
      serializers.Register(BuildTargetBase_Unknown.Read, BuildTargetBase_Unknown.Write);
      serializers.Register(BuildEventBase_Unknown.Read, BuildEventBase_Unknown.Write);
      serializers.Register(BuildEventForProjectBase_Unknown.Read, BuildEventForProjectBase_Unknown.Write);
      serializers.Register(ImportantBuildEvent_Unknown.Read, ImportantBuildEvent_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public BuildModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BuildModel (");
      using (printer.IndentCookie()) {
        printer.Print("ready = "); _Ready.PrintEx(printer); printer.Println();
        printer.Print("request = "); _Request.PrintEx(printer); printer.Println();
        printer.Print("buildSession = "); _BuildSession.PrintEx(printer); printer.Println();
        printer.Print("setIncrementalBuildAvailability = "); _SetIncrementalBuildAvailability.PrintEx(printer); printer.Println();
        printer.Print("dumpSolutionBuilderState = "); _DumpSolutionBuilderState.PrintEx(printer); printer.Println();
        printer.Print("dumpBuildReasons = "); _DumpBuildReasons.PrintEx(printer); printer.Println();
        printer.Print("incrementalBuildInConsistentState = "); _IncrementalBuildInConsistentState.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BuildArgs : IPrintable, IEquatable<BuildArgs>
  {
    //fields
    //public fields
    [NotNull] public BuildTargetBase Operation {get; private set;}
    [NotNull] public List<string> SelectedProjects {get; private set;}
    public bool DiagnosticsMode {get; private set;}
    public bool SilentMode {get; private set;}
    public bool WithoutDependencies {get; private set;}
    
    //private fields
    //primary constructor
    public BuildArgs(
      [NotNull] BuildTargetBase operation,
      [NotNull] List<string> selectedProjects,
      bool diagnosticsMode,
      bool silentMode,
      bool withoutDependencies
    )
    {
      if (operation == null) throw new ArgumentNullException("operation");
      if (selectedProjects == null) throw new ArgumentNullException("selectedProjects");
      
      Operation = operation;
      SelectedProjects = selectedProjects;
      DiagnosticsMode = diagnosticsMode;
      SilentMode = silentMode;
      WithoutDependencies = withoutDependencies;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BuildArgs> Read = (ctx, reader) => 
    {
      var operation = BuildTargetBase.Read(ctx, reader);
      var selectedProjects = ReadStringList(ctx, reader);
      var diagnosticsMode = reader.ReadBool();
      var silentMode = reader.ReadBool();
      var withoutDependencies = reader.ReadBool();
      return new BuildArgs(operation, selectedProjects, diagnosticsMode, silentMode, withoutDependencies);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<BuildArgs> Write = (ctx, writer, value) => 
    {
      BuildTargetBase.Write(ctx, writer, value.Operation);
      WriteStringList(ctx, writer, value.SelectedProjects);
      writer.Write(value.DiagnosticsMode);
      writer.Write(value.SilentMode);
      writer.Write(value.WithoutDependencies);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildArgs) obj);
    }
    public bool Equals(BuildArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Operation, other.Operation) && SelectedProjects.SequenceEqual(other.SelectedProjects) && DiagnosticsMode == other.DiagnosticsMode && SilentMode == other.SilentMode && WithoutDependencies == other.WithoutDependencies;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Operation.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(SelectedProjects);
        hash = hash * 31 + DiagnosticsMode.GetHashCode();
        hash = hash * 31 + SilentMode.GetHashCode();
        hash = hash * 31 + WithoutDependencies.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildArgs (");
      using (printer.IndentCookie()) {
        printer.Print("operation = "); Operation.PrintEx(printer); printer.Println();
        printer.Print("selectedProjects = "); SelectedProjects.PrintEx(printer); printer.Println();
        printer.Print("diagnosticsMode = "); DiagnosticsMode.PrintEx(printer); printer.Println();
        printer.Print("silentMode = "); SilentMode.PrintEx(printer); printer.Println();
        printer.Print("withoutDependencies = "); WithoutDependencies.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BuildEvent : IPrintable, IEquatable<BuildEvent>
  {
    //fields
    //public fields
    public BuildEventKind Kind {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    [CanBeNull] public string Code {get; private set;}
    [CanBeNull] public int? ProjectId {get; private set;}
    [CanBeNull] public string FilePath {get; private set;}
    [CanBeNull] public int? Line {get; private set;}
    [CanBeNull] public int? Column {get; private set;}
    
    //private fields
    //primary constructor
    public BuildEvent(
      BuildEventKind kind,
      [CanBeNull] string message,
      [CanBeNull] string code,
      [CanBeNull] int? projectId,
      [CanBeNull] string filePath,
      [CanBeNull] int? line,
      [CanBeNull] int? column
    )
    {
      Kind = kind;
      Message = message;
      Code = code;
      ProjectId = projectId;
      FilePath = filePath;
      Line = line;
      Column = column;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BuildEvent> Read = (ctx, reader) => 
    {
      var kind = (BuildEventKind)reader.ReadInt();
      var message = ReadStringNullable(ctx, reader);
      var code = ReadStringNullable(ctx, reader);
      var projectId = ReadIntNullable(ctx, reader);
      var filePath = ReadStringNullable(ctx, reader);
      var line = ReadIntNullable(ctx, reader);
      var column = ReadIntNullable(ctx, reader);
      return new BuildEvent(kind, message, code, projectId, filePath, line, column);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<BuildEvent> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteStringNullable(ctx, writer, value.Message);
      WriteStringNullable(ctx, writer, value.Code);
      WriteIntNullable(ctx, writer, value.ProjectId);
      WriteStringNullable(ctx, writer, value.FilePath);
      WriteIntNullable(ctx, writer, value.Line);
      WriteIntNullable(ctx, writer, value.Column);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildEvent) obj);
    }
    public bool Equals(BuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(Message, other.Message) && Equals(Code, other.Code) && Equals(ProjectId, other.ProjectId) && Equals(FilePath, other.FilePath) && Equals(Line, other.Line) && Equals(Column, other.Column);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + (Message != null ?Message.GetHashCode() : 0);
        hash = hash * 31 + (Code != null ?Code.GetHashCode() : 0);
        hash = hash * 31 + (ProjectId != null ?ProjectId.GetHashCode() : 0);
        hash = hash * 31 + (FilePath != null ?FilePath.GetHashCode() : 0);
        hash = hash * 31 + (Line != null ?Line.GetHashCode() : 0);
        hash = hash * 31 + (Column != null ?Column.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("code = "); Code.PrintEx(printer); printer.Println();
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("column = "); Column.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BuildEventBase{
    //fields
    //public fields
    [NotNull] public string Message {get; private set;}
    
    //private fields
    //primary constructor
    protected BuildEventBase(
      [NotNull] string message
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BuildEventBase> Read = Polymorphic<BuildEventBase>.ReadAbstract(BuildEventBase_Unknown.Read);
    
    public static CtxWriteDelegate<BuildEventBase> Write = Polymorphic<BuildEventBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BuildEventBase_Unknown : BuildEventBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public BuildEventBase_Unknown(
      [NotNull] string message
    ) : base (
      message
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BuildEventBase_Unknown> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      return new BuildEventBase_Unknown(message);
    };
    
    public static new CtxWriteDelegate<BuildEventBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildEventBase_Unknown) obj);
    }
    public bool Equals(BuildEventBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildEventBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BuildEventForProjectBase : BuildEventBase
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.ProjectId ProjectId {get; private set;}
    
    //private fields
    //primary constructor
    protected BuildEventForProjectBase(
      [NotNull] JetBrains.Rider.Model.ProjectId projectId,
      [NotNull] string message
    ) : base (
      message
     ) 
    {
      if (projectId == null) throw new ArgumentNullException("projectId");
      
      ProjectId = projectId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BuildEventForProjectBase> Read = Polymorphic<BuildEventForProjectBase>.ReadAbstract(BuildEventForProjectBase_Unknown.Read);
    
    public static new CtxWriteDelegate<BuildEventForProjectBase> Write = Polymorphic<BuildEventForProjectBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BuildEventForProjectBase_Unknown : BuildEventForProjectBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public BuildEventForProjectBase_Unknown(
      [NotNull] JetBrains.Rider.Model.ProjectId projectId,
      [NotNull] string message
    ) : base (
      projectId,
      message
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BuildEventForProjectBase_Unknown> Read = (ctx, reader) => 
    {
      var projectId = JetBrains.Rider.Model.ProjectId.Read(ctx, reader);
      var message = reader.ReadString();
      return new BuildEventForProjectBase_Unknown(projectId, message);
    };
    
    public static new CtxWriteDelegate<BuildEventForProjectBase_Unknown> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.ProjectId.Write(ctx, writer, value.ProjectId);
      writer.Write(value.Message);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildEventForProjectBase_Unknown) obj);
    }
    public bool Equals(BuildEventForProjectBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ProjectId, other.ProjectId) && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildEventForProjectBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BuildEventKind {
    Error,
    Warning
  }
  
  
  public enum BuildMessageKind {
    Message,
    Success,
    Warning,
    Error
  }
  
  
  public class BuildResult : IPrintable, IEquatable<BuildResult>
  {
    //fields
    //public fields
    public BuildResultKind Kind {get; private set;}
    public bool ShowNotification {get; private set;}
    
    //private fields
    //primary constructor
    public BuildResult(
      BuildResultKind kind,
      bool showNotification
    )
    {
      Kind = kind;
      ShowNotification = showNotification;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BuildResult> Read = (ctx, reader) => 
    {
      var kind = (BuildResultKind)reader.ReadInt();
      var showNotification = reader.ReadBool();
      return new BuildResult(kind, showNotification);
    };
    
    public static CtxWriteDelegate<BuildResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      writer.Write(value.ShowNotification);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildResult) obj);
    }
    public bool Equals(BuildResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && ShowNotification == other.ShowNotification;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + ShowNotification.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildResult (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("showNotification = "); ShowNotification.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BuildResultKind {
    HasErrors,
    HasWarnings,
    Successful,
    Canceled,
    Crashed
  }
  
  
  public class BuildSession : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public BuildTargetBase Operation {get; private set;}
    public bool AlwaysHidden {get; private set;}
    [NotNull] public ISink<RdVoid> Cancel { get { return _Cancel; }}
    [NotNull] public IRdProperty<double> Progress { get { return _Progress; }}
    [NotNull] public IRdProperty<string> ActiveProjectName { get { return _ActiveProjectName; }}
    public bool ActivateBuildResultsWindow {get; private set;}
    [NotNull] public IRdProperty<bool> OpenLogAfterBuild { get { return _OpenLogAfterBuild; }}
    [NotNull] public IRdProperty<string> LogFileName { get { return _LogFileName; }}
    [NotNull] public ISource<BuildResult> Result { get { return _Result; }}
    [NotNull] public ISource<List<BuildEvent>> BuildEvents { get { return _BuildEvents; }}
    [NotNull] public BuildSessionOutput Output {get; private set;}
    [NotNull] public string ProgressTitle {get; private set;}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Cancel;
    [NotNull] private readonly RdProperty<double> _Progress;
    [NotNull] private readonly RdProperty<string> _ActiveProjectName;
    [NotNull] private readonly RdProperty<bool> _OpenLogAfterBuild;
    [NotNull] private readonly RdProperty<string> _LogFileName;
    [NotNull] private readonly RdSignal<BuildResult> _Result;
    [NotNull] private readonly RdSignal<List<BuildEvent>> _BuildEvents;
    
    //primary constructor
    private BuildSession(
      [NotNull] BuildTargetBase operation,
      bool alwaysHidden,
      [NotNull] RdSignal<RdVoid> cancel,
      [NotNull] RdProperty<double> progress,
      [NotNull] RdProperty<string> activeProjectName,
      bool activateBuildResultsWindow,
      [NotNull] RdProperty<bool> openLogAfterBuild,
      [NotNull] RdProperty<string> logFileName,
      [NotNull] RdSignal<BuildResult> result,
      [NotNull] RdSignal<List<BuildEvent>> buildEvents,
      [NotNull] BuildSessionOutput output,
      [NotNull] string progressTitle
    )
    {
      if (operation == null) throw new ArgumentNullException("operation");
      if (cancel == null) throw new ArgumentNullException("cancel");
      if (progress == null) throw new ArgumentNullException("progress");
      if (activeProjectName == null) throw new ArgumentNullException("activeProjectName");
      if (openLogAfterBuild == null) throw new ArgumentNullException("openLogAfterBuild");
      if (logFileName == null) throw new ArgumentNullException("logFileName");
      if (result == null) throw new ArgumentNullException("result");
      if (buildEvents == null) throw new ArgumentNullException("buildEvents");
      if (output == null) throw new ArgumentNullException("output");
      if (progressTitle == null) throw new ArgumentNullException("progressTitle");
      
      Operation = operation;
      AlwaysHidden = alwaysHidden;
      _Cancel = cancel;
      _Progress = progress;
      _ActiveProjectName = activeProjectName;
      ActivateBuildResultsWindow = activateBuildResultsWindow;
      _OpenLogAfterBuild = openLogAfterBuild;
      _LogFileName = logFileName;
      _Result = result;
      _BuildEvents = buildEvents;
      Output = output;
      ProgressTitle = progressTitle;
      _Progress.OptimizeNested = true;
      _ActiveProjectName.OptimizeNested = true;
      _OpenLogAfterBuild.OptimizeNested = true;
      _LogFileName.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("cancel", _Cancel));
      BindableChildren.Add(new KeyValuePair<string, object>("progress", _Progress));
      BindableChildren.Add(new KeyValuePair<string, object>("activeProjectName", _ActiveProjectName));
      BindableChildren.Add(new KeyValuePair<string, object>("openLogAfterBuild", _OpenLogAfterBuild));
      BindableChildren.Add(new KeyValuePair<string, object>("logFileName", _LogFileName));
      BindableChildren.Add(new KeyValuePair<string, object>("result", _Result));
      BindableChildren.Add(new KeyValuePair<string, object>("buildEvents", _BuildEvents));
      BindableChildren.Add(new KeyValuePair<string, object>("output", Output));
    }
    //secondary constructor
    public BuildSession (
      [NotNull] BuildTargetBase operation,
      bool alwaysHidden,
      bool activateBuildResultsWindow,
      [NotNull] string progressTitle
    ) : this (
      operation,
      alwaysHidden,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble, 0.0),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      activateBuildResultsWindow,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<BuildResult>(BuildResult.Read, BuildResult.Write),
      new RdSignal<List<BuildEvent>>(ReadBuildEventList, WriteBuildEventList),
      new BuildSessionOutput(),
      progressTitle
    ) {}
    //statics
    
    public static CtxReadDelegate<BuildSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var operation = BuildTargetBase.Read(ctx, reader);
      var alwaysHidden = reader.ReadBool();
      var cancel = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var progress = RdProperty<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      var activeProjectName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var activateBuildResultsWindow = reader.ReadBool();
      var openLogAfterBuild = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var logFileName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var result = RdSignal<BuildResult>.Read(ctx, reader, BuildResult.Read, BuildResult.Write);
      var buildEvents = RdSignal<List<BuildEvent>>.Read(ctx, reader, ReadBuildEventList, WriteBuildEventList);
      var output = BuildSessionOutput.Read(ctx, reader);
      var progressTitle = reader.ReadString();
      return new BuildSession(operation, alwaysHidden, cancel, progress, activeProjectName, activateBuildResultsWindow, openLogAfterBuild, logFileName, result, buildEvents, output, progressTitle).WithId(_id);
    };
    public static CtxReadDelegate<List<BuildEvent>> ReadBuildEventList = BuildEvent.Read.List();
    
    public static CtxWriteDelegate<BuildSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BuildTargetBase.Write(ctx, writer, value.Operation);
      writer.Write(value.AlwaysHidden);
      RdSignal<RdVoid>.Write(ctx, writer, value._Cancel);
      RdProperty<double>.Write(ctx, writer, value._Progress);
      RdProperty<string>.Write(ctx, writer, value._ActiveProjectName);
      writer.Write(value.ActivateBuildResultsWindow);
      RdProperty<bool>.Write(ctx, writer, value._OpenLogAfterBuild);
      RdProperty<string>.Write(ctx, writer, value._LogFileName);
      RdSignal<BuildResult>.Write(ctx, writer, value._Result);
      RdSignal<List<BuildEvent>>.Write(ctx, writer, value._BuildEvents);
      BuildSessionOutput.Write(ctx, writer, value.Output);
      writer.Write(value.ProgressTitle);
    };
    public static CtxWriteDelegate<List<BuildEvent>> WriteBuildEventList = BuildEvent.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BuildSession (");
      using (printer.IndentCookie()) {
        printer.Print("operation = "); Operation.PrintEx(printer); printer.Println();
        printer.Print("alwaysHidden = "); AlwaysHidden.PrintEx(printer); printer.Println();
        printer.Print("cancel = "); _Cancel.PrintEx(printer); printer.Println();
        printer.Print("progress = "); _Progress.PrintEx(printer); printer.Println();
        printer.Print("activeProjectName = "); _ActiveProjectName.PrintEx(printer); printer.Println();
        printer.Print("activateBuildResultsWindow = "); ActivateBuildResultsWindow.PrintEx(printer); printer.Println();
        printer.Print("openLogAfterBuild = "); _OpenLogAfterBuild.PrintEx(printer); printer.Println();
        printer.Print("logFileName = "); _LogFileName.PrintEx(printer); printer.Println();
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
        printer.Print("buildEvents = "); _BuildEvents.PrintEx(printer); printer.Println();
        printer.Print("output = "); Output.PrintEx(printer); printer.Println();
        printer.Print("progressTitle = "); ProgressTitle.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BuildSessionOutput : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public ISource<List<BuildEventBase>> Message { get { return _Message; }}
    [NotNull] public IViewableMap<ProjectId, string> ProjectsDirectories { get { return _ProjectsDirectories; }}
    
    //private fields
    [NotNull] private readonly RdSignal<List<BuildEventBase>> _Message;
    [NotNull] private readonly RdMap<ProjectId, string> _ProjectsDirectories;
    
    //primary constructor
    private BuildSessionOutput(
      [NotNull] RdSignal<List<BuildEventBase>> message,
      [NotNull] RdMap<ProjectId, string> projectsDirectories
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      if (projectsDirectories == null) throw new ArgumentNullException("projectsDirectories");
      
      _Message = message;
      _ProjectsDirectories = projectsDirectories;
      _ProjectsDirectories.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("message", _Message));
      BindableChildren.Add(new KeyValuePair<string, object>("projectsDirectories", _ProjectsDirectories));
    }
    //secondary constructor
    public BuildSessionOutput (
    ) : this (
      new RdSignal<List<BuildEventBase>>(ReadBuildEventBaseList, WriteBuildEventBaseList),
      new RdMap<ProjectId, string>(ProjectId.Read, ProjectId.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<BuildSessionOutput> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var message = RdSignal<List<BuildEventBase>>.Read(ctx, reader, ReadBuildEventBaseList, WriteBuildEventBaseList);
      var projectsDirectories = RdMap<ProjectId, string>.Read(ctx, reader, ProjectId.Read, ProjectId.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new BuildSessionOutput(message, projectsDirectories).WithId(_id);
    };
    public static CtxReadDelegate<List<BuildEventBase>> ReadBuildEventBaseList = BuildEventBase.Read.List();
    
    public static CtxWriteDelegate<BuildSessionOutput> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<List<BuildEventBase>>.Write(ctx, writer, value._Message);
      RdMap<ProjectId, string>.Write(ctx, writer, value._ProjectsDirectories);
    };
    public static CtxWriteDelegate<List<BuildEventBase>> WriteBuildEventBaseList = BuildEventBase.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BuildSessionOutput (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); _Message.PrintEx(printer); printer.Println();
        printer.Print("projectsDirectories = "); _ProjectsDirectories.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BuildTarget : BuildTargetBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BuildTarget> Read = (ctx, reader) => 
    {
      return new BuildTarget();
    };
    
    public static new CtxWriteDelegate<BuildTarget> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildTarget) obj);
    }
    public bool Equals(BuildTarget other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildTarget (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BuildTargetBase{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BuildTargetBase> Read = Polymorphic<BuildTargetBase>.ReadAbstract(BuildTargetBase_Unknown.Read);
    
    public static CtxWriteDelegate<BuildTargetBase> Write = Polymorphic<BuildTargetBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BuildTargetBase_Unknown : BuildTargetBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BuildTargetBase_Unknown> Read = (ctx, reader) => 
    {
      return new BuildTargetBase_Unknown();
    };
    
    public static new CtxWriteDelegate<BuildTargetBase_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildTargetBase_Unknown) obj);
    }
    public bool Equals(BuildTargetBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildTargetBase_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CleanTarget : BuildTargetBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CleanTarget> Read = (ctx, reader) => 
    {
      return new CleanTarget();
    };
    
    public static new CtxWriteDelegate<CleanTarget> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CleanTarget) obj);
    }
    public bool Equals(CleanTarget other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CleanTarget (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConsoleBuildEvent : BuildEventBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public ConsoleBuildEvent(
      [NotNull] string message
    ) : base (
      message
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ConsoleBuildEvent> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      return new ConsoleBuildEvent(message);
    };
    
    public static new CtxWriteDelegate<ConsoleBuildEvent> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ConsoleBuildEvent) obj);
    }
    public bool Equals(ConsoleBuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ConsoleBuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CustomTarget : BuildTargetBase
  {
    //fields
    //public fields
    [NotNull] public string TargetName {get; private set;}
    
    //private fields
    //primary constructor
    public CustomTarget(
      [NotNull] string targetName
    )
    {
      if (targetName == null) throw new ArgumentNullException("targetName");
      
      TargetName = targetName;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CustomTarget> Read = (ctx, reader) => 
    {
      var targetName = reader.ReadString();
      return new CustomTarget(targetName);
    };
    
    public static new CtxWriteDelegate<CustomTarget> Write = (ctx, writer, value) => 
    {
      writer.Write(value.TargetName);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CustomTarget) obj);
    }
    public bool Equals(CustomTarget other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return TargetName == other.TargetName;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TargetName.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CustomTarget (");
      using (printer.IndentCookie()) {
        printer.Print("targetName = "); TargetName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CustomTargetExtraProperty : IPrintable, IEquatable<CustomTargetExtraProperty>
  {
    //fields
    //public fields
    [NotNull] public string Key {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public CustomTargetExtraProperty(
      [NotNull] string key,
      [NotNull] string value
    )
    {
      if (key == null) throw new ArgumentNullException("key");
      if (value == null) throw new ArgumentNullException("value");
      
      Key = key;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CustomTargetExtraProperty> Read = (ctx, reader) => 
    {
      var key = reader.ReadString();
      var value = reader.ReadString();
      return new CustomTargetExtraProperty(key, value);
    };
    
    public static CtxWriteDelegate<CustomTargetExtraProperty> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Key);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CustomTargetExtraProperty) obj);
    }
    public bool Equals(CustomTargetExtraProperty other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Key == other.Key && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Key.GetHashCode();
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CustomTargetExtraProperty (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CustomTargetWithExtraProperties : BuildTargetBase
  {
    //fields
    //public fields
    [NotNull] public string TargetName {get; private set;}
    [NotNull] public List<CustomTargetExtraProperty> ExtraProperties {get; private set;}
    
    //private fields
    //primary constructor
    public CustomTargetWithExtraProperties(
      [NotNull] string targetName,
      [NotNull] List<CustomTargetExtraProperty> extraProperties
    )
    {
      if (targetName == null) throw new ArgumentNullException("targetName");
      if (extraProperties == null) throw new ArgumentNullException("extraProperties");
      
      TargetName = targetName;
      ExtraProperties = extraProperties;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CustomTargetWithExtraProperties> Read = (ctx, reader) => 
    {
      var targetName = reader.ReadString();
      var extraProperties = ReadCustomTargetExtraPropertyList(ctx, reader);
      return new CustomTargetWithExtraProperties(targetName, extraProperties);
    };
    public static CtxReadDelegate<List<CustomTargetExtraProperty>> ReadCustomTargetExtraPropertyList = CustomTargetExtraProperty.Read.List();
    
    public static new CtxWriteDelegate<CustomTargetWithExtraProperties> Write = (ctx, writer, value) => 
    {
      writer.Write(value.TargetName);
      WriteCustomTargetExtraPropertyList(ctx, writer, value.ExtraProperties);
    };
    public static CtxWriteDelegate<List<CustomTargetExtraProperty>> WriteCustomTargetExtraPropertyList = CustomTargetExtraProperty.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CustomTargetWithExtraProperties) obj);
    }
    public bool Equals(CustomTargetWithExtraProperties other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return TargetName == other.TargetName && ExtraProperties.SequenceEqual(other.ExtraProperties);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TargetName.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ExtraProperties);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CustomTargetWithExtraProperties (");
      using (printer.IndentCookie()) {
        printer.Print("targetName = "); TargetName.PrintEx(printer); printer.Println();
        printer.Print("extraProperties = "); ExtraProperties.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ErrorBuildEvent : ImportantBuildEvent
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public ErrorBuildEvent(
      [CanBeNull] string file,
      [CanBeNull] string subcategory,
      int lineNumber,
      int endLineNumber,
      int columnNumber,
      int endColumnNumber,
      [CanBeNull] string code,
      [NotNull] JetBrains.Rider.Model.ProjectId projectId,
      [NotNull] string message
    ) : base (
      file,
      subcategory,
      lineNumber,
      endLineNumber,
      columnNumber,
      endColumnNumber,
      code,
      projectId,
      message
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ErrorBuildEvent> Read = (ctx, reader) => 
    {
      var file = ReadStringNullable(ctx, reader);
      var subcategory = ReadStringNullable(ctx, reader);
      var lineNumber = reader.ReadInt();
      var endLineNumber = reader.ReadInt();
      var columnNumber = reader.ReadInt();
      var endColumnNumber = reader.ReadInt();
      var code = ReadStringNullable(ctx, reader);
      var projectId = JetBrains.Rider.Model.ProjectId.Read(ctx, reader);
      var message = reader.ReadString();
      return new ErrorBuildEvent(file, subcategory, lineNumber, endLineNumber, columnNumber, endColumnNumber, code, projectId, message);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<ErrorBuildEvent> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.File);
      WriteStringNullable(ctx, writer, value.Subcategory);
      writer.Write(value.LineNumber);
      writer.Write(value.EndLineNumber);
      writer.Write(value.ColumnNumber);
      writer.Write(value.EndColumnNumber);
      WriteStringNullable(ctx, writer, value.Code);
      JetBrains.Rider.Model.ProjectId.Write(ctx, writer, value.ProjectId);
      writer.Write(value.Message);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ErrorBuildEvent) obj);
    }
    public bool Equals(ErrorBuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(File, other.File) && Equals(Subcategory, other.Subcategory) && LineNumber == other.LineNumber && EndLineNumber == other.EndLineNumber && ColumnNumber == other.ColumnNumber && EndColumnNumber == other.EndColumnNumber && Equals(Code, other.Code) && Equals(ProjectId, other.ProjectId) && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (File != null ?File.GetHashCode() : 0);
        hash = hash * 31 + (Subcategory != null ?Subcategory.GetHashCode() : 0);
        hash = hash * 31 + LineNumber.GetHashCode();
        hash = hash * 31 + EndLineNumber.GetHashCode();
        hash = hash * 31 + ColumnNumber.GetHashCode();
        hash = hash * 31 + EndColumnNumber.GetHashCode();
        hash = hash * 31 + (Code != null ?Code.GetHashCode() : 0);
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ErrorBuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("file = "); File.PrintEx(printer); printer.Println();
        printer.Print("subcategory = "); Subcategory.PrintEx(printer); printer.Println();
        printer.Print("lineNumber = "); LineNumber.PrintEx(printer); printer.Println();
        printer.Print("endLineNumber = "); EndLineNumber.PrintEx(printer); printer.Println();
        printer.Print("columnNumber = "); ColumnNumber.PrintEx(printer); printer.Println();
        printer.Print("endColumnNumber = "); EndColumnNumber.PrintEx(printer); printer.Println();
        printer.Print("code = "); Code.PrintEx(printer); printer.Println();
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ImportantBuildEvent : BuildEventForProjectBase
  {
    //fields
    //public fields
    [CanBeNull] public string File {get; private set;}
    [CanBeNull] public string Subcategory {get; private set;}
    public int LineNumber {get; private set;}
    public int EndLineNumber {get; private set;}
    public int ColumnNumber {get; private set;}
    public int EndColumnNumber {get; private set;}
    [CanBeNull] public string Code {get; private set;}
    
    //private fields
    //primary constructor
    protected ImportantBuildEvent(
      [CanBeNull] string file,
      [CanBeNull] string subcategory,
      int lineNumber,
      int endLineNumber,
      int columnNumber,
      int endColumnNumber,
      [CanBeNull] string code,
      [NotNull] JetBrains.Rider.Model.ProjectId projectId,
      [NotNull] string message
    ) : base (
      projectId,
      message
     ) 
    {
      File = file;
      Subcategory = subcategory;
      LineNumber = lineNumber;
      EndLineNumber = endLineNumber;
      ColumnNumber = columnNumber;
      EndColumnNumber = endColumnNumber;
      Code = code;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ImportantBuildEvent> Read = Polymorphic<ImportantBuildEvent>.ReadAbstract(ImportantBuildEvent_Unknown.Read);
    
    public static new CtxWriteDelegate<ImportantBuildEvent> Write = Polymorphic<ImportantBuildEvent>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class ImportantBuildEvent_Unknown : ImportantBuildEvent
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public ImportantBuildEvent_Unknown(
      [CanBeNull] string file,
      [CanBeNull] string subcategory,
      int lineNumber,
      int endLineNumber,
      int columnNumber,
      int endColumnNumber,
      [CanBeNull] string code,
      [NotNull] JetBrains.Rider.Model.ProjectId projectId,
      [NotNull] string message
    ) : base (
      file,
      subcategory,
      lineNumber,
      endLineNumber,
      columnNumber,
      endColumnNumber,
      code,
      projectId,
      message
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ImportantBuildEvent_Unknown> Read = (ctx, reader) => 
    {
      var file = ReadStringNullable(ctx, reader);
      var subcategory = ReadStringNullable(ctx, reader);
      var lineNumber = reader.ReadInt();
      var endLineNumber = reader.ReadInt();
      var columnNumber = reader.ReadInt();
      var endColumnNumber = reader.ReadInt();
      var code = ReadStringNullable(ctx, reader);
      var projectId = JetBrains.Rider.Model.ProjectId.Read(ctx, reader);
      var message = reader.ReadString();
      return new ImportantBuildEvent_Unknown(file, subcategory, lineNumber, endLineNumber, columnNumber, endColumnNumber, code, projectId, message);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<ImportantBuildEvent_Unknown> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.File);
      WriteStringNullable(ctx, writer, value.Subcategory);
      writer.Write(value.LineNumber);
      writer.Write(value.EndLineNumber);
      writer.Write(value.ColumnNumber);
      writer.Write(value.EndColumnNumber);
      WriteStringNullable(ctx, writer, value.Code);
      JetBrains.Rider.Model.ProjectId.Write(ctx, writer, value.ProjectId);
      writer.Write(value.Message);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ImportantBuildEvent_Unknown) obj);
    }
    public bool Equals(ImportantBuildEvent_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(File, other.File) && Equals(Subcategory, other.Subcategory) && LineNumber == other.LineNumber && EndLineNumber == other.EndLineNumber && ColumnNumber == other.ColumnNumber && EndColumnNumber == other.EndColumnNumber && Equals(Code, other.Code) && Equals(ProjectId, other.ProjectId) && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (File != null ?File.GetHashCode() : 0);
        hash = hash * 31 + (Subcategory != null ?Subcategory.GetHashCode() : 0);
        hash = hash * 31 + LineNumber.GetHashCode();
        hash = hash * 31 + EndLineNumber.GetHashCode();
        hash = hash * 31 + ColumnNumber.GetHashCode();
        hash = hash * 31 + EndColumnNumber.GetHashCode();
        hash = hash * 31 + (Code != null ?Code.GetHashCode() : 0);
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ImportantBuildEvent_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("file = "); File.PrintEx(printer); printer.Println();
        printer.Print("subcategory = "); Subcategory.PrintEx(printer); printer.Println();
        printer.Print("lineNumber = "); LineNumber.PrintEx(printer); printer.Println();
        printer.Print("endLineNumber = "); EndLineNumber.PrintEx(printer); printer.Println();
        printer.Print("columnNumber = "); ColumnNumber.PrintEx(printer); printer.Println();
        printer.Print("endColumnNumber = "); EndColumnNumber.PrintEx(printer); printer.Println();
        printer.Print("code = "); Code.PrintEx(printer); printer.Println();
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MessageBuildEvent : BuildEventBase
  {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.ProjectId ProjectId {get; private set;}
    public BuildMessageKind Kind {get; private set;}
    
    //private fields
    //primary constructor
    public MessageBuildEvent(
      [CanBeNull] JetBrains.Rider.Model.ProjectId projectId,
      BuildMessageKind kind,
      [NotNull] string message
    ) : base (
      message
     ) 
    {
      ProjectId = projectId;
      Kind = kind;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<MessageBuildEvent> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      var projectId = ReadProjectIdNullable(ctx, reader);
      var kind = (BuildMessageKind)reader.ReadInt();
      return new MessageBuildEvent(projectId, kind, message);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.ProjectId> ReadProjectIdNullable = JetBrains.Rider.Model.ProjectId.Read.NullableClass();
    
    public static new CtxWriteDelegate<MessageBuildEvent> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
      WriteProjectIdNullable(ctx, writer, value.ProjectId);
      writer.Write((int)value.Kind);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.ProjectId> WriteProjectIdNullable = JetBrains.Rider.Model.ProjectId.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MessageBuildEvent) obj);
    }
    public bool Equals(MessageBuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ProjectId, other.ProjectId) && Kind == other.Kind && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (ProjectId != null ?ProjectId.GetHashCode() : 0);
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MessageBuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProjectId : IPrintable, IEquatable<ProjectId>
  {
    //fields
    //public fields
    public int Id {get; private set;}
    
    //private fields
    //primary constructor
    public ProjectId(
      int id
    )
    {
      Id = id;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectId> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      return new ProjectId(id);
    };
    
    public static CtxWriteDelegate<ProjectId> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectId) obj);
    }
    public bool Equals(ProjectId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectId (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RebuildTarget : BuildTargetBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RebuildTarget> Read = (ctx, reader) => 
    {
      return new RebuildTarget();
    };
    
    public static new CtxWriteDelegate<RebuildTarget> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RebuildTarget) obj);
    }
    public bool Equals(RebuildTarget other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RebuildTarget (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class WarningBuildEvent : ImportantBuildEvent
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public WarningBuildEvent(
      [CanBeNull] string file,
      [CanBeNull] string subcategory,
      int lineNumber,
      int endLineNumber,
      int columnNumber,
      int endColumnNumber,
      [CanBeNull] string code,
      [NotNull] JetBrains.Rider.Model.ProjectId projectId,
      [NotNull] string message
    ) : base (
      file,
      subcategory,
      lineNumber,
      endLineNumber,
      columnNumber,
      endColumnNumber,
      code,
      projectId,
      message
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<WarningBuildEvent> Read = (ctx, reader) => 
    {
      var file = ReadStringNullable(ctx, reader);
      var subcategory = ReadStringNullable(ctx, reader);
      var lineNumber = reader.ReadInt();
      var endLineNumber = reader.ReadInt();
      var columnNumber = reader.ReadInt();
      var endColumnNumber = reader.ReadInt();
      var code = ReadStringNullable(ctx, reader);
      var projectId = JetBrains.Rider.Model.ProjectId.Read(ctx, reader);
      var message = reader.ReadString();
      return new WarningBuildEvent(file, subcategory, lineNumber, endLineNumber, columnNumber, endColumnNumber, code, projectId, message);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<WarningBuildEvent> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.File);
      WriteStringNullable(ctx, writer, value.Subcategory);
      writer.Write(value.LineNumber);
      writer.Write(value.EndLineNumber);
      writer.Write(value.ColumnNumber);
      writer.Write(value.EndColumnNumber);
      WriteStringNullable(ctx, writer, value.Code);
      JetBrains.Rider.Model.ProjectId.Write(ctx, writer, value.ProjectId);
      writer.Write(value.Message);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((WarningBuildEvent) obj);
    }
    public bool Equals(WarningBuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(File, other.File) && Equals(Subcategory, other.Subcategory) && LineNumber == other.LineNumber && EndLineNumber == other.EndLineNumber && ColumnNumber == other.ColumnNumber && EndColumnNumber == other.EndColumnNumber && Equals(Code, other.Code) && Equals(ProjectId, other.ProjectId) && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (File != null ?File.GetHashCode() : 0);
        hash = hash * 31 + (Subcategory != null ?Subcategory.GetHashCode() : 0);
        hash = hash * 31 + LineNumber.GetHashCode();
        hash = hash * 31 + EndLineNumber.GetHashCode();
        hash = hash * 31 + ColumnNumber.GetHashCode();
        hash = hash * 31 + EndColumnNumber.GetHashCode();
        hash = hash * 31 + (Code != null ?Code.GetHashCode() : 0);
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("WarningBuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("file = "); File.PrintEx(printer); printer.Println();
        printer.Print("subcategory = "); Subcategory.PrintEx(printer); printer.Println();
        printer.Print("lineNumber = "); LineNumber.PrintEx(printer); printer.Println();
        printer.Print("endLineNumber = "); EndLineNumber.PrintEx(printer); printer.Println();
        printer.Print("columnNumber = "); ColumnNumber.PrintEx(printer); printer.Println();
        printer.Print("endColumnNumber = "); EndColumnNumber.PrintEx(printer); printer.Println();
        printer.Print("code = "); Code.PrintEx(printer); printer.Println();
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
