using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class CodeCleanupSettingsModel : RdExtBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private CodeCleanupSettingsModel(
    )
    {
    }
    //secondary constructor
    //statics
    
    
    
    protected override long SerializationHash => -8291498317148175150L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(PsiLanguageTypeModel.Read, PsiLanguageTypeModel.Write);
      serializers.Register(ProfileBoolSubActionModel.Read, ProfileBoolSubActionModel.Write);
      serializers.Register(ProfileStringSubActionModel.Read, ProfileStringSubActionModel.Write);
      serializers.Register(ProfileBoolActionModel.Read, ProfileBoolActionModel.Write);
      serializers.Register(ProfileComplexActionModel.Read, ProfileComplexActionModel.Write);
      serializers.Register(CleanupProfileModel.Read, CleanupProfileModel.Write);
      serializers.Register(ProfileSubActionModel_Unknown.Read, ProfileSubActionModel_Unknown.Write);
      serializers.Register(ProfileActionModel_Unknown.Read, ProfileActionModel_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public CodeCleanupSettingsModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeCleanupSettingsModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CleanupProfileModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Uid {get; private set;}
    [NotNull] public IRdProperty<string> ProfileName { get { return _ProfileName; }}
    public bool IsRecentlyUsed {get; private set;}
    public bool IsReadOnly {get; private set;}
    [NotNull] public IRdProperty<bool> IsDefaultFroSilentCleanup { get { return _IsDefaultFroSilentCleanup; }}
    [NotNull] public ProfileActionModel[] Actions {get; private set;}
    [NotNull] public string InitialIdeaCounterpartProfile {get; private set;}
    [NotNull] public RdEndpoint<string, bool> SetNewIdeaCounterpartProfile { get { return _SetNewIdeaCounterpartProfile; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _ProfileName;
    [NotNull] private readonly RdProperty<bool> _IsDefaultFroSilentCleanup;
    [NotNull] private readonly RdEndpoint<string, bool> _SetNewIdeaCounterpartProfile;
    
    //primary constructor
    private CleanupProfileModel(
      [NotNull] string uid,
      [NotNull] RdProperty<string> profileName,
      bool isRecentlyUsed,
      bool isReadOnly,
      [NotNull] RdProperty<bool> isDefaultFroSilentCleanup,
      [NotNull] ProfileActionModel[] actions,
      [NotNull] string initialIdeaCounterpartProfile,
      [NotNull] RdEndpoint<string, bool> setNewIdeaCounterpartProfile
    )
    {
      if (uid == null) throw new ArgumentNullException("uid");
      if (profileName == null) throw new ArgumentNullException("profileName");
      if (isDefaultFroSilentCleanup == null) throw new ArgumentNullException("isDefaultFroSilentCleanup");
      if (actions == null) throw new ArgumentNullException("actions");
      if (initialIdeaCounterpartProfile == null) throw new ArgumentNullException("initialIdeaCounterpartProfile");
      if (setNewIdeaCounterpartProfile == null) throw new ArgumentNullException("setNewIdeaCounterpartProfile");
      
      Uid = uid;
      _ProfileName = profileName;
      IsRecentlyUsed = isRecentlyUsed;
      IsReadOnly = isReadOnly;
      _IsDefaultFroSilentCleanup = isDefaultFroSilentCleanup;
      Actions = actions;
      InitialIdeaCounterpartProfile = initialIdeaCounterpartProfile;
      _SetNewIdeaCounterpartProfile = setNewIdeaCounterpartProfile;
      _ProfileName.OptimizeNested = true;
      _IsDefaultFroSilentCleanup.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("profileName", _ProfileName));
      BindableChildren.Add(new KeyValuePair<string, object>("isDefaultFroSilentCleanup", _IsDefaultFroSilentCleanup));
      BindableChildren.Add(new KeyValuePair<string, object>("actions", Actions));
      BindableChildren.Add(new KeyValuePair<string, object>("setNewIdeaCounterpartProfile", _SetNewIdeaCounterpartProfile));
    }
    //secondary constructor
    public CleanupProfileModel (
      [NotNull] string uid,
      bool isRecentlyUsed,
      bool isReadOnly,
      [NotNull] ProfileActionModel[] actions,
      [NotNull] string initialIdeaCounterpartProfile
    ) : this (
      uid,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      isRecentlyUsed,
      isReadOnly,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      actions,
      initialIdeaCounterpartProfile,
      new RdEndpoint<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<CleanupProfileModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var uid = reader.ReadString();
      var profileName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isRecentlyUsed = reader.ReadBool();
      var isReadOnly = reader.ReadBool();
      var isDefaultFroSilentCleanup = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var actions = ReadProfileActionModelArray(ctx, reader);
      var initialIdeaCounterpartProfile = reader.ReadString();
      var setNewIdeaCounterpartProfile = RdEndpoint<string, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new CleanupProfileModel(uid, profileName, isRecentlyUsed, isReadOnly, isDefaultFroSilentCleanup, actions, initialIdeaCounterpartProfile, setNewIdeaCounterpartProfile).WithId(_id);
    };
    public static CtxReadDelegate<ProfileActionModel[]> ReadProfileActionModelArray = ProfileActionModel.Read.Array();
    
    public static CtxWriteDelegate<CleanupProfileModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Uid);
      RdProperty<string>.Write(ctx, writer, value._ProfileName);
      writer.Write(value.IsRecentlyUsed);
      writer.Write(value.IsReadOnly);
      RdProperty<bool>.Write(ctx, writer, value._IsDefaultFroSilentCleanup);
      WriteProfileActionModelArray(ctx, writer, value.Actions);
      writer.Write(value.InitialIdeaCounterpartProfile);
      RdEndpoint<string, bool>.Write(ctx, writer, value._SetNewIdeaCounterpartProfile);
    };
    public static CtxWriteDelegate<ProfileActionModel[]> WriteProfileActionModelArray = ProfileActionModel.Write.Array();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CleanupProfileModel (");
      using (printer.IndentCookie()) {
        printer.Print("uid = "); Uid.PrintEx(printer); printer.Println();
        printer.Print("profileName = "); _ProfileName.PrintEx(printer); printer.Println();
        printer.Print("isRecentlyUsed = "); IsRecentlyUsed.PrintEx(printer); printer.Println();
        printer.Print("isReadOnly = "); IsReadOnly.PrintEx(printer); printer.Println();
        printer.Print("isDefaultFroSilentCleanup = "); _IsDefaultFroSilentCleanup.PrintEx(printer); printer.Println();
        printer.Print("actions = "); Actions.PrintEx(printer); printer.Println();
        printer.Print("initialIdeaCounterpartProfile = "); InitialIdeaCounterpartProfile.PrintEx(printer); printer.Println();
        printer.Print("setNewIdeaCounterpartProfile = "); _SetNewIdeaCounterpartProfile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ProfileActionModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string ActionName {get; private set;}
    [NotNull] public PsiLanguageTypeModel Language {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool> _IsEnabled;
    
    //primary constructor
    protected ProfileActionModel(
      [NotNull] string actionName,
      [NotNull] PsiLanguageTypeModel language,
      [NotNull] RdProperty<bool> isEnabled
    )
    {
      if (actionName == null) throw new ArgumentNullException("actionName");
      if (language == null) throw new ArgumentNullException("language");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      
      ActionName = actionName;
      Language = language;
      _IsEnabled = isEnabled;
      _IsEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProfileActionModel> Read = Polymorphic<ProfileActionModel>.ReadAbstract(ProfileActionModel_Unknown.Read);
    
    public static CtxWriteDelegate<ProfileActionModel> Write = Polymorphic<ProfileActionModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class ProfileActionModel_Unknown : ProfileActionModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private ProfileActionModel_Unknown(
      [NotNull] string actionName,
      [NotNull] PsiLanguageTypeModel language,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      actionName,
      language,
      isEnabled
     ) 
    {
    }
    //secondary constructor
    public ProfileActionModel_Unknown (
      [NotNull] string actionName,
      [NotNull] PsiLanguageTypeModel language
    ) : this (
      actionName,
      language,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ProfileActionModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actionName = reader.ReadString();
      var language = PsiLanguageTypeModel.Read(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new ProfileActionModel_Unknown(actionName, language, isEnabled).WithId(_id);
    };
    
    public static new CtxWriteDelegate<ProfileActionModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ActionName);
      PsiLanguageTypeModel.Write(ctx, writer, value.Language);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProfileActionModel_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProfileBoolActionModel : ProfileActionModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private ProfileBoolActionModel(
      [NotNull] string actionName,
      [NotNull] PsiLanguageTypeModel language,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      actionName,
      language,
      isEnabled
     ) 
    {
    }
    //secondary constructor
    public ProfileBoolActionModel (
      [NotNull] string actionName,
      [NotNull] PsiLanguageTypeModel language
    ) : this (
      actionName,
      language,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ProfileBoolActionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actionName = reader.ReadString();
      var language = PsiLanguageTypeModel.Read(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new ProfileBoolActionModel(actionName, language, isEnabled).WithId(_id);
    };
    
    public static new CtxWriteDelegate<ProfileBoolActionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ActionName);
      PsiLanguageTypeModel.Write(ctx, writer, value.Language);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProfileBoolActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProfileBoolSubActionModel : ProfileSubActionModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    
    //primary constructor
    private ProfileBoolSubActionModel(
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] string actionName
    ) : base (
      actionName
     ) 
    {
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      
      _IsEnabled = isEnabled;
      _IsEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
    }
    //secondary constructor
    public ProfileBoolSubActionModel (
      [NotNull] string actionName
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      actionName
    ) {}
    //statics
    
    public static new CtxReadDelegate<ProfileBoolSubActionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actionName = reader.ReadString();
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new ProfileBoolSubActionModel(isEnabled, actionName).WithId(_id);
    };
    
    public static new CtxWriteDelegate<ProfileBoolSubActionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ActionName);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProfileBoolSubActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProfileComplexActionModel : ProfileActionModel
  {
    //fields
    //public fields
    [NotNull] public ProfileSubActionModel[] SubActions {get; private set;}
    
    //private fields
    //primary constructor
    private ProfileComplexActionModel(
      [NotNull] ProfileSubActionModel[] subActions,
      [NotNull] string actionName,
      [NotNull] PsiLanguageTypeModel language,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      actionName,
      language,
      isEnabled
     ) 
    {
      if (subActions == null) throw new ArgumentNullException("subActions");
      
      SubActions = subActions;
      BindableChildren.Add(new KeyValuePair<string, object>("subActions", SubActions));
    }
    //secondary constructor
    public ProfileComplexActionModel (
      [NotNull] ProfileSubActionModel[] subActions,
      [NotNull] string actionName,
      [NotNull] PsiLanguageTypeModel language
    ) : this (
      subActions,
      actionName,
      language,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ProfileComplexActionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actionName = reader.ReadString();
      var language = PsiLanguageTypeModel.Read(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var subActions = ReadProfileSubActionModelArray(ctx, reader);
      return new ProfileComplexActionModel(subActions, actionName, language, isEnabled).WithId(_id);
    };
    public static CtxReadDelegate<ProfileSubActionModel[]> ReadProfileSubActionModelArray = ProfileSubActionModel.Read.Array();
    
    public static new CtxWriteDelegate<ProfileComplexActionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ActionName);
      PsiLanguageTypeModel.Write(ctx, writer, value.Language);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      WriteProfileSubActionModelArray(ctx, writer, value.SubActions);
    };
    public static CtxWriteDelegate<ProfileSubActionModel[]> WriteProfileSubActionModelArray = ProfileSubActionModel.Write.Array();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProfileComplexActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("subActions = "); SubActions.PrintEx(printer); printer.Println();
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProfileStringSubActionModel : ProfileSubActionModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private ProfileStringSubActionModel(
      [NotNull] RdProperty<string> value,
      [NotNull] string actionName
    ) : base (
      actionName
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public ProfileStringSubActionModel (
      [NotNull] string actionName
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      actionName
    ) {}
    //statics
    
    public static new CtxReadDelegate<ProfileStringSubActionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actionName = reader.ReadString();
      var value = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new ProfileStringSubActionModel(value, actionName).WithId(_id);
    };
    
    public static new CtxWriteDelegate<ProfileStringSubActionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ActionName);
      RdProperty<string>.Write(ctx, writer, value._Value);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProfileStringSubActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ProfileSubActionModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string ActionName {get; private set;}
    
    //private fields
    //primary constructor
    protected ProfileSubActionModel(
      [NotNull] string actionName
    )
    {
      if (actionName == null) throw new ArgumentNullException("actionName");
      
      ActionName = actionName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProfileSubActionModel> Read = Polymorphic<ProfileSubActionModel>.ReadAbstract(ProfileSubActionModel_Unknown.Read);
    
    public static CtxWriteDelegate<ProfileSubActionModel> Write = Polymorphic<ProfileSubActionModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class ProfileSubActionModel_Unknown : ProfileSubActionModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public ProfileSubActionModel_Unknown(
      [NotNull] string actionName
    ) : base (
      actionName
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ProfileSubActionModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actionName = reader.ReadString();
      return new ProfileSubActionModel_Unknown(actionName).WithId(_id);
    };
    
    public static new CtxWriteDelegate<ProfileSubActionModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ActionName);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProfileSubActionModel_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PsiLanguageTypeModel : IPrintable, IEquatable<PsiLanguageTypeModel>
  {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string DisplayName {get; private set;}
    
    //private fields
    //primary constructor
    public PsiLanguageTypeModel(
      [NotNull] string name,
      [NotNull] string displayName
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (displayName == null) throw new ArgumentNullException("displayName");
      
      Name = name;
      DisplayName = displayName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PsiLanguageTypeModel> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var displayName = reader.ReadString();
      return new PsiLanguageTypeModel(name, displayName);
    };
    
    public static CtxWriteDelegate<PsiLanguageTypeModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.DisplayName);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((PsiLanguageTypeModel) obj);
    }
    public bool Equals(PsiLanguageTypeModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && DisplayName == other.DisplayName;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + DisplayName.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("PsiLanguageTypeModel (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
