using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class CodeLensModel : RdExtBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    internal CodeLensModel(
    )
    {
    }
    //secondary constructor
    //statics
    
    
    
    protected override long SerializationHash => -1294488033803024446L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(TextCodeLensEntry.Read, TextCodeLensEntry.Write);
      serializers.Register(CounterCodeLensEntry.Read, CounterCodeLensEntry.Write);
      serializers.Register(RichTextCodeLensEntry.Read, RichTextCodeLensEntry.Write);
      serializers.Register(CodeLensHighlighterModel.Read, CodeLensHighlighterModel.Write);
      serializers.Register(CodeLensVcsRangeHighlighterModel.Read, CodeLensVcsRangeHighlighterModel.Write);
      serializers.Register(CodeLensEntryExtraActionModel.Read, CodeLensEntryExtraActionModel.Write);
      serializers.Register(CodeLensEntryBase_Unknown.Read, CodeLensEntryBase_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeLensModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class EditableEntityCodeLensModelEx
   {
    public static CodeLensModel GetCodeLensModel(this EditableEntity editableEntity)
    {
      return editableEntity.GetOrCreateExtension("codeLensModel", () => new CodeLensModel());
    }
  }
  
  
  public abstract class CodeLensEntryBase{
    //fields
    //public fields
    
    /// <summary>
    /// The provider ID of this entry
    /// </summary>
    [NotNull] public string ProviderId {get; private set;}
    
    /// <summary>
    /// Icon to show near this entry in editor
    /// </summary>
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    /// <summary>
    /// The text in 'More' menu
    /// </summary>
    [NotNull] public string LongPresentation {get; private set;}
    
    /// <summary>
    /// Extra actions for this lens
    /// </summary>
    [NotNull] public List<CodeLensEntryExtraActionModel> ExtraActions {get; private set;}
    
    //private fields
    //primary constructor
    protected CodeLensEntryBase(
      [NotNull] string providerId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string longPresentation,
      [NotNull] List<CodeLensEntryExtraActionModel> extraActions
    )
    {
      if (providerId == null) throw new ArgumentNullException("providerId");
      if (longPresentation == null) throw new ArgumentNullException("longPresentation");
      if (extraActions == null) throw new ArgumentNullException("extraActions");
      
      ProviderId = providerId;
      Icon = icon;
      LongPresentation = longPresentation;
      ExtraActions = extraActions;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeLensEntryBase> Read = Polymorphic<CodeLensEntryBase>.ReadAbstract(CodeLensEntryBase_Unknown.Read);
    
    public static CtxWriteDelegate<CodeLensEntryBase> Write = Polymorphic<CodeLensEntryBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class CodeLensEntryBase_Unknown : CodeLensEntryBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public CodeLensEntryBase_Unknown(
      [NotNull] string providerId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string longPresentation,
      [NotNull] List<CodeLensEntryExtraActionModel> extraActions
    ) : base (
      providerId,
      icon,
      longPresentation,
      extraActions
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeLensEntryBase_Unknown> Read = (ctx, reader) => 
    {
      var providerId = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var longPresentation = reader.ReadString();
      var extraActions = ReadCodeLensEntryExtraActionModelList(ctx, reader);
      return new CodeLensEntryBase_Unknown(providerId, icon, longPresentation, extraActions);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<CodeLensEntryExtraActionModel>> ReadCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Read.List();
    
    public static new CtxWriteDelegate<CodeLensEntryBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProviderId);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.LongPresentation);
      WriteCodeLensEntryExtraActionModelList(ctx, writer, value.ExtraActions);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<CodeLensEntryExtraActionModel>> WriteCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeLensEntryBase_Unknown) obj);
    }
    public bool Equals(CodeLensEntryBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProviderId == other.ProviderId && Equals(Icon, other.Icon) && LongPresentation == other.LongPresentation && ExtraActions.SequenceEqual(other.ExtraActions);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProviderId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + LongPresentation.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ExtraActions);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeLensEntryBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("providerId = "); ProviderId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("longPresentation = "); LongPresentation.PrintEx(printer); printer.Println();
        printer.Print("extraActions = "); ExtraActions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeLensEntryExtraActionModel : IPrintable, IEquatable<CodeLensEntryExtraActionModel>
  {
    //fields
    //public fields
    
    /// <summary>
    /// Text that will be displayed in the UI
    /// </summary>
    [NotNull] public string DisplayText {get; private set;}
    
    /// <summary>
    /// Action ID passed to provider when this action is invoked. null for non-clicable line
    /// </summary>
    [CanBeNull] public string ActionId {get; private set;}
    
    //private fields
    //primary constructor
    public CodeLensEntryExtraActionModel(
      [NotNull] string displayText,
      [CanBeNull] string actionId
    )
    {
      if (displayText == null) throw new ArgumentNullException("displayText");
      
      DisplayText = displayText;
      ActionId = actionId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeLensEntryExtraActionModel> Read = (ctx, reader) => 
    {
      var displayText = reader.ReadString();
      var actionId = ReadStringNullable(ctx, reader);
      return new CodeLensEntryExtraActionModel(displayText, actionId);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<CodeLensEntryExtraActionModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DisplayText);
      WriteStringNullable(ctx, writer, value.ActionId);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeLensEntryExtraActionModel) obj);
    }
    public bool Equals(CodeLensEntryExtraActionModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DisplayText == other.DisplayText && Equals(ActionId, other.ActionId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DisplayText.GetHashCode();
        hash = hash * 31 + (ActionId != null ?ActionId.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeLensEntryExtraActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("displayText = "); DisplayText.PrintEx(printer); printer.Println();
        printer.Print("actionId = "); ActionId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeLensHighlighterModel : HighlighterModel
  {
    //fields
    //public fields
    [NotNull] public CodeLensEntryBase CodeLensEntry {get; private set;}
    
    //private fields
    //primary constructor
    public CodeLensHighlighterModel(
      [NotNull] CodeLensEntryBase codeLensEntry,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      if (codeLensEntry == null) throw new ArgumentNullException("codeLensEntry");
      
      CodeLensEntry = codeLensEntry;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeLensHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var codeLensEntry = CodeLensEntryBase.Read(ctx, reader);
      return new CodeLensHighlighterModel(codeLensEntry, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<CodeLensHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      CodeLensEntryBase.Write(ctx, writer, value.CodeLensEntry);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeLensHighlighterModel) obj);
    }
    public bool Equals(CodeLensHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(CodeLensEntry, other.CodeLensEntry) && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + CodeLensEntry.GetHashCode();
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeLensHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("codeLensEntry = "); CodeLensEntry.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeLensVcsRangeHighlighterModel : HighlighterModel
  {
    //fields
    //public fields
    public int PairingId {get; private set;}
    public bool IsBody {get; private set;}
    
    //private fields
    //primary constructor
    public CodeLensVcsRangeHighlighterModel(
      int pairingId,
      bool isBody,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      PairingId = pairingId;
      IsBody = isBody;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeLensVcsRangeHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var pairingId = reader.ReadInt();
      var isBody = reader.ReadBool();
      return new CodeLensVcsRangeHighlighterModel(pairingId, isBody, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<CodeLensVcsRangeHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write(value.PairingId);
      writer.Write(value.IsBody);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeLensVcsRangeHighlighterModel) obj);
    }
    public bool Equals(CodeLensVcsRangeHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return PairingId == other.PairingId && IsBody == other.IsBody && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + PairingId.GetHashCode();
        hash = hash * 31 + IsBody.GetHashCode();
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeLensVcsRangeHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("pairingId = "); PairingId.PrintEx(printer); printer.Println();
        printer.Print("isBody = "); IsBody.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CounterCodeLensEntry : CodeLensEntryBase
  {
    //fields
    //public fields
    public int Count {get; private set;}
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public CounterCodeLensEntry(
      int count,
      [NotNull] string text,
      [NotNull] string providerId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string longPresentation,
      [NotNull] List<CodeLensEntryExtraActionModel> extraActions
    ) : base (
      providerId,
      icon,
      longPresentation,
      extraActions
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Count = count;
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CounterCodeLensEntry> Read = (ctx, reader) => 
    {
      var providerId = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var longPresentation = reader.ReadString();
      var extraActions = ReadCodeLensEntryExtraActionModelList(ctx, reader);
      var count = reader.ReadInt();
      var text = reader.ReadString();
      return new CounterCodeLensEntry(count, text, providerId, icon, longPresentation, extraActions);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<CodeLensEntryExtraActionModel>> ReadCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Read.List();
    
    public static new CtxWriteDelegate<CounterCodeLensEntry> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProviderId);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.LongPresentation);
      WriteCodeLensEntryExtraActionModelList(ctx, writer, value.ExtraActions);
      writer.Write(value.Count);
      writer.Write(value.Text);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<CodeLensEntryExtraActionModel>> WriteCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CounterCodeLensEntry) obj);
    }
    public bool Equals(CounterCodeLensEntry other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Count == other.Count && Text == other.Text && ProviderId == other.ProviderId && Equals(Icon, other.Icon) && LongPresentation == other.LongPresentation && ExtraActions.SequenceEqual(other.ExtraActions);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Count.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + ProviderId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + LongPresentation.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ExtraActions);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CounterCodeLensEntry (");
      using (printer.IndentCookie()) {
        printer.Print("count = "); Count.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("providerId = "); ProviderId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("longPresentation = "); LongPresentation.PrintEx(printer); printer.Println();
        printer.Print("extraActions = "); ExtraActions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RichTextCodeLensEntry : CodeLensEntryBase
  {
    //fields
    //public fields
    [NotNull] public ModelRichText Text {get; private set;}
    
    //private fields
    //primary constructor
    public RichTextCodeLensEntry(
      [NotNull] ModelRichText text,
      [NotNull] string providerId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string longPresentation,
      [NotNull] List<CodeLensEntryExtraActionModel> extraActions
    ) : base (
      providerId,
      icon,
      longPresentation,
      extraActions
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RichTextCodeLensEntry> Read = (ctx, reader) => 
    {
      var providerId = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var longPresentation = reader.ReadString();
      var extraActions = ReadCodeLensEntryExtraActionModelList(ctx, reader);
      var text = ModelRichText.Read(ctx, reader);
      return new RichTextCodeLensEntry(text, providerId, icon, longPresentation, extraActions);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<CodeLensEntryExtraActionModel>> ReadCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Read.List();
    
    public static new CtxWriteDelegate<RichTextCodeLensEntry> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProviderId);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.LongPresentation);
      WriteCodeLensEntryExtraActionModelList(ctx, writer, value.ExtraActions);
      ModelRichText.Write(ctx, writer, value.Text);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<CodeLensEntryExtraActionModel>> WriteCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RichTextCodeLensEntry) obj);
    }
    public bool Equals(RichTextCodeLensEntry other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Text, other.Text) && ProviderId == other.ProviderId && Equals(Icon, other.Icon) && LongPresentation == other.LongPresentation && ExtraActions.SequenceEqual(other.ExtraActions);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + ProviderId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + LongPresentation.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ExtraActions);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RichTextCodeLensEntry (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("providerId = "); ProviderId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("longPresentation = "); LongPresentation.PrintEx(printer); printer.Println();
        printer.Print("extraActions = "); ExtraActions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextCodeLensEntry : CodeLensEntryBase
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public TextCodeLensEntry(
      [NotNull] string text,
      [NotNull] string providerId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string longPresentation,
      [NotNull] List<CodeLensEntryExtraActionModel> extraActions
    ) : base (
      providerId,
      icon,
      longPresentation,
      extraActions
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<TextCodeLensEntry> Read = (ctx, reader) => 
    {
      var providerId = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var longPresentation = reader.ReadString();
      var extraActions = ReadCodeLensEntryExtraActionModelList(ctx, reader);
      var text = reader.ReadString();
      return new TextCodeLensEntry(text, providerId, icon, longPresentation, extraActions);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<CodeLensEntryExtraActionModel>> ReadCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Read.List();
    
    public static new CtxWriteDelegate<TextCodeLensEntry> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProviderId);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.LongPresentation);
      WriteCodeLensEntryExtraActionModelList(ctx, writer, value.ExtraActions);
      writer.Write(value.Text);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<CodeLensEntryExtraActionModel>> WriteCodeLensEntryExtraActionModelList = CodeLensEntryExtraActionModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextCodeLensEntry) obj);
    }
    public bool Equals(TextCodeLensEntry other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && ProviderId == other.ProviderId && Equals(Icon, other.Icon) && LongPresentation == other.LongPresentation && ExtraActions.SequenceEqual(other.ExtraActions);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + ProviderId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + LongPresentation.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ExtraActions);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextCodeLensEntry (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("providerId = "); ProviderId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("longPresentation = "); LongPresentation.PrintEx(printer); printer.Println();
        printer.Print("extraActions = "); ExtraActions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
