using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class ColorChooserModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableList<ColorChooserSession> ColorChooserSessions { get { return _ColorChooserSessions; }}
    
    //private fields
    [NotNull] private readonly RdList<ColorChooserSession> _ColorChooserSessions;
    
    //primary constructor
    private ColorChooserModel(
      [NotNull] RdList<ColorChooserSession> colorChooserSessions
    )
    {
      if (colorChooserSessions == null) throw new ArgumentNullException("colorChooserSessions");
      
      _ColorChooserSessions = colorChooserSessions;
      BindableChildren.Add(new KeyValuePair<string, object>("colorChooserSessions", _ColorChooserSessions));
    }
    //secondary constructor
    internal ColorChooserModel (
    ) : this (
      new RdList<ColorChooserSession>(ColorChooserSession.Read, ColorChooserSession.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 1463673527303369946L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(ColorChooserParam.Read, ColorChooserParam.Write);
      serializers.Register(ColorChooserSession.Read, ColorChooserSession.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ColorChooserModel (");
      using (printer.IndentCookie()) {
        printer.Print("colorChooserSessions = "); _ColorChooserSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionColorChooserModelEx
   {
    public static ColorChooserModel GetColorChooserModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("colorChooserModel", () => new ColorChooserModel());
    }
  }
  
  
  public class ColorChooserParam : IPrintable, IEquatable<ColorChooserParam>
  {
    //fields
    //public fields
    [CanBeNull] public string Caption {get; private set;}
    [CanBeNull] public RgbaColor PreselectedColor {get; private set;}
    public bool EnableOpacity {get; private set;}
    public bool OpacityInPercent {get; private set;}
    
    //private fields
    //primary constructor
    public ColorChooserParam(
      [CanBeNull] string caption,
      [CanBeNull] RgbaColor preselectedColor,
      bool enableOpacity,
      bool opacityInPercent
    )
    {
      Caption = caption;
      PreselectedColor = preselectedColor;
      EnableOpacity = enableOpacity;
      OpacityInPercent = opacityInPercent;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ColorChooserParam> Read = (ctx, reader) => 
    {
      var caption = ReadStringNullable(ctx, reader);
      var preselectedColor = ReadRgbaColorNullable(ctx, reader);
      var enableOpacity = reader.ReadBool();
      var opacityInPercent = reader.ReadBool();
      return new ColorChooserParam(caption, preselectedColor, enableOpacity, opacityInPercent);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RgbaColor> ReadRgbaColorNullable = RgbaColor.Read.NullableClass();
    
    public static CtxWriteDelegate<ColorChooserParam> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Caption);
      WriteRgbaColorNullable(ctx, writer, value.PreselectedColor);
      writer.Write(value.EnableOpacity);
      writer.Write(value.OpacityInPercent);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RgbaColor> WriteRgbaColorNullable = RgbaColor.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ColorChooserParam) obj);
    }
    public bool Equals(ColorChooserParam other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Caption, other.Caption) && Equals(PreselectedColor, other.PreselectedColor) && EnableOpacity == other.EnableOpacity && OpacityInPercent == other.OpacityInPercent;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Caption != null ?Caption.GetHashCode() : 0);
        hash = hash * 31 + (PreselectedColor != null ?PreselectedColor.GetHashCode() : 0);
        hash = hash * 31 + EnableOpacity.GetHashCode();
        hash = hash * 31 + OpacityInPercent.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ColorChooserParam (");
      using (printer.IndentCookie()) {
        printer.Print("caption = "); Caption.PrintEx(printer); printer.Println();
        printer.Print("preselectedColor = "); PreselectedColor.PrintEx(printer); printer.Println();
        printer.Print("enableOpacity = "); EnableOpacity.PrintEx(printer); printer.Println();
        printer.Print("opacityInPercent = "); OpacityInPercent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ColorChooserSession : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public ColorChooserParam Param {get; private set;}
    [NotNull] public IRdSignal<RgbaColor> ColorChanged { get { return _ColorChanged; }}
    [NotNull] public IRdSignal<RgbaColor> Closed { get { return _Closed; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RgbaColor> _ColorChanged;
    [NotNull] private readonly RdSignal<RgbaColor> _Closed;
    
    //primary constructor
    private ColorChooserSession(
      [NotNull] ColorChooserParam param,
      [NotNull] RdSignal<RgbaColor> colorChanged,
      [NotNull] RdSignal<RgbaColor> closed
    )
    {
      if (param == null) throw new ArgumentNullException("param");
      if (colorChanged == null) throw new ArgumentNullException("colorChanged");
      if (closed == null) throw new ArgumentNullException("closed");
      
      Param = param;
      _ColorChanged = colorChanged;
      _Closed = closed;
      _ColorChanged.ValueCanBeNull = true;
      _Closed.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("colorChanged", _ColorChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("closed", _Closed));
    }
    //secondary constructor
    public ColorChooserSession (
      [NotNull] ColorChooserParam param
    ) : this (
      param,
      new RdSignal<RgbaColor>(ReadRgbaColorNullable, WriteRgbaColorNullable),
      new RdSignal<RgbaColor>(ReadRgbaColorNullable, WriteRgbaColorNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<ColorChooserSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var param = ColorChooserParam.Read(ctx, reader);
      var colorChanged = RdSignal<RgbaColor>.Read(ctx, reader, ReadRgbaColorNullable, WriteRgbaColorNullable);
      var closed = RdSignal<RgbaColor>.Read(ctx, reader, ReadRgbaColorNullable, WriteRgbaColorNullable);
      return new ColorChooserSession(param, colorChanged, closed).WithId(_id);
    };
    public static CtxReadDelegate<RgbaColor> ReadRgbaColorNullable = RgbaColor.Read.NullableClass();
    
    public static CtxWriteDelegate<ColorChooserSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      ColorChooserParam.Write(ctx, writer, value.Param);
      RdSignal<RgbaColor>.Write(ctx, writer, value._ColorChanged);
      RdSignal<RgbaColor>.Write(ctx, writer, value._Closed);
    };
    public static CtxWriteDelegate<RgbaColor> WriteRgbaColorNullable = RgbaColor.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ColorChooserSession (");
      using (printer.IndentCookie()) {
        printer.Print("param = "); Param.PrintEx(printer); printer.Println();
        printer.Print("colorChanged = "); _ColorChanged.PrintEx(printer); printer.Println();
        printer.Print("closed = "); _Closed.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
