using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class ConfigurationParametersAccessModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<SetPropertyArgs, RdVoid> TrySetPropertyInActiveConfiguration { get { return _TrySetPropertyInActiveConfiguration; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<SetPropertyArgs, RdVoid> _TrySetPropertyInActiveConfiguration;
    
    //primary constructor
    private ConfigurationParametersAccessModel(
      [NotNull] RdEndpoint<SetPropertyArgs, RdVoid> trySetPropertyInActiveConfiguration
    )
    {
      if (trySetPropertyInActiveConfiguration == null) throw new ArgumentNullException("trySetPropertyInActiveConfiguration");
      
      _TrySetPropertyInActiveConfiguration = trySetPropertyInActiveConfiguration;
      BindableChildren.Add(new KeyValuePair<string, object>("trySetPropertyInActiveConfiguration", _TrySetPropertyInActiveConfiguration));
    }
    //secondary constructor
    internal ConfigurationParametersAccessModel (
    ) : this (
      new RdEndpoint<SetPropertyArgs, RdVoid>(SetPropertyArgs.Read, SetPropertyArgs.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 3041381775989962639L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(SetPropertyArgs.Read, SetPropertyArgs.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConfigurationParametersAccessModel (");
      using (printer.IndentCookie()) {
        printer.Print("trySetPropertyInActiveConfiguration = "); _TrySetPropertyInActiveConfiguration.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionConfigurationParametersAccessModelEx
   {
    public static ConfigurationParametersAccessModel GetConfigurationParametersAccessModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("configurationParametersAccessModel", () => new ConfigurationParametersAccessModel());
    }
  }
  
  
  public class SetPropertyArgs : IPrintable, IEquatable<SetPropertyArgs>
  {
    //fields
    //public fields
    [NotNull] public string ProjectFilePath {get; private set;}
    [NotNull] public string PropertyKey {get; private set;}
    [NotNull] public string PropertyValue {get; private set;}
    
    //private fields
    //primary constructor
    public SetPropertyArgs(
      [NotNull] string projectFilePath,
      [NotNull] string propertyKey,
      [NotNull] string propertyValue
    )
    {
      if (projectFilePath == null) throw new ArgumentNullException("projectFilePath");
      if (propertyKey == null) throw new ArgumentNullException("propertyKey");
      if (propertyValue == null) throw new ArgumentNullException("propertyValue");
      
      ProjectFilePath = projectFilePath;
      PropertyKey = propertyKey;
      PropertyValue = propertyValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SetPropertyArgs> Read = (ctx, reader) => 
    {
      var projectFilePath = reader.ReadString();
      var propertyKey = reader.ReadString();
      var propertyValue = reader.ReadString();
      return new SetPropertyArgs(projectFilePath, propertyKey, propertyValue);
    };
    
    public static CtxWriteDelegate<SetPropertyArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectFilePath);
      writer.Write(value.PropertyKey);
      writer.Write(value.PropertyValue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SetPropertyArgs) obj);
    }
    public bool Equals(SetPropertyArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectFilePath == other.ProjectFilePath && PropertyKey == other.PropertyKey && PropertyValue == other.PropertyValue;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        hash = hash * 31 + PropertyKey.GetHashCode();
        hash = hash * 31 + PropertyValue.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SetPropertyArgs (");
      using (printer.IndentCookie()) {
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
        printer.Print("propertyKey = "); PropertyKey.PrintEx(printer); printer.Println();
        printer.Print("propertyValue = "); PropertyValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
