using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.DebuggerHostToWorker
{
  
  
  public class DebuggerWorkerToHostModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> HostConnected { get { return _HostConnected; }}
    [NotNull] public RdEndpoint<ResolveTypeArg, string> ResolveType { get { return _ResolveType; }}
    [NotNull] public RdEndpoint<GetTypeDebugInfoForTokenArg, GetTypeDebugInfoResult> GetTypeDebugInfoForToken { get { return _GetTypeDebugInfoForToken; }}
    [NotNull] public RdEndpoint<JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg, GetTypeDebugInfoResult> GetTypeDebugInfoForDocumentArg { get { return _GetTypeDebugInfoForDocumentArg; }}
    [NotNull] public RdEndpoint<RdVoid, string> GetDebugDataCacheDirectory { get { return _GetDebugDataCacheDirectory; }}
    [NotNull] public RdEndpoint<GetExpressionForILRangeArg, string> GetExpressionForILRange { get { return _GetExpressionForILRange; }}
    [NotNull] public RdEndpoint<GetExpressionListForILRangeArg, List<GetExpressionListForILRangeResult>> GetExpressionListForILRange { get { return _GetExpressionListForILRange; }}
    [NotNull] public RdEndpoint<GetExpressionRangeForStartOffsetArg, GetExpressionRangeForStartOffsetResult> GetExpressionRangeForStartOffset { get { return _GetExpressionRangeForStartOffset; }}
    [NotNull] public RdEndpoint<RdVoid, GetOutputAssembliesInfoResult> GetOutputAssembliesInfo { get { return _GetOutputAssembliesInfo; }}
    [NotNull] public IViewableMap<string, ModuleInfo> Modules { get { return _Modules; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _HostConnected;
    [NotNull] private readonly RdEndpoint<ResolveTypeArg, string> _ResolveType;
    [NotNull] private readonly RdEndpoint<GetTypeDebugInfoForTokenArg, GetTypeDebugInfoResult> _GetTypeDebugInfoForToken;
    [NotNull] private readonly RdEndpoint<JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg, GetTypeDebugInfoResult> _GetTypeDebugInfoForDocumentArg;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _GetDebugDataCacheDirectory;
    [NotNull] private readonly RdEndpoint<GetExpressionForILRangeArg, string> _GetExpressionForILRange;
    [NotNull] private readonly RdEndpoint<GetExpressionListForILRangeArg, List<GetExpressionListForILRangeResult>> _GetExpressionListForILRange;
    [NotNull] private readonly RdEndpoint<GetExpressionRangeForStartOffsetArg, GetExpressionRangeForStartOffsetResult> _GetExpressionRangeForStartOffset;
    [NotNull] private readonly RdEndpoint<RdVoid, GetOutputAssembliesInfoResult> _GetOutputAssembliesInfo;
    [NotNull] private readonly RdMap<string, ModuleInfo> _Modules;
    
    //primary constructor
    private DebuggerWorkerToHostModel(
      [NotNull] RdProperty<bool> hostConnected,
      [NotNull] RdEndpoint<ResolveTypeArg, string> resolveType,
      [NotNull] RdEndpoint<GetTypeDebugInfoForTokenArg, GetTypeDebugInfoResult> getTypeDebugInfoForToken,
      [NotNull] RdEndpoint<JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg, GetTypeDebugInfoResult> getTypeDebugInfoForDocumentArg,
      [NotNull] RdEndpoint<RdVoid, string> getDebugDataCacheDirectory,
      [NotNull] RdEndpoint<GetExpressionForILRangeArg, string> getExpressionForILRange,
      [NotNull] RdEndpoint<GetExpressionListForILRangeArg, List<GetExpressionListForILRangeResult>> getExpressionListForILRange,
      [NotNull] RdEndpoint<GetExpressionRangeForStartOffsetArg, GetExpressionRangeForStartOffsetResult> getExpressionRangeForStartOffset,
      [NotNull] RdEndpoint<RdVoid, GetOutputAssembliesInfoResult> getOutputAssembliesInfo,
      [NotNull] RdMap<string, ModuleInfo> modules
    )
    {
      if (hostConnected == null) throw new ArgumentNullException("hostConnected");
      if (resolveType == null) throw new ArgumentNullException("resolveType");
      if (getTypeDebugInfoForToken == null) throw new ArgumentNullException("getTypeDebugInfoForToken");
      if (getTypeDebugInfoForDocumentArg == null) throw new ArgumentNullException("getTypeDebugInfoForDocumentArg");
      if (getDebugDataCacheDirectory == null) throw new ArgumentNullException("getDebugDataCacheDirectory");
      if (getExpressionForILRange == null) throw new ArgumentNullException("getExpressionForILRange");
      if (getExpressionListForILRange == null) throw new ArgumentNullException("getExpressionListForILRange");
      if (getExpressionRangeForStartOffset == null) throw new ArgumentNullException("getExpressionRangeForStartOffset");
      if (getOutputAssembliesInfo == null) throw new ArgumentNullException("getOutputAssembliesInfo");
      if (modules == null) throw new ArgumentNullException("modules");
      
      _HostConnected = hostConnected;
      _ResolveType = resolveType;
      _GetTypeDebugInfoForToken = getTypeDebugInfoForToken;
      _GetTypeDebugInfoForDocumentArg = getTypeDebugInfoForDocumentArg;
      _GetDebugDataCacheDirectory = getDebugDataCacheDirectory;
      _GetExpressionForILRange = getExpressionForILRange;
      _GetExpressionListForILRange = getExpressionListForILRange;
      _GetExpressionRangeForStartOffset = getExpressionRangeForStartOffset;
      _GetOutputAssembliesInfo = getOutputAssembliesInfo;
      _Modules = modules;
      _HostConnected.OptimizeNested = true;
      _Modules.OptimizeNested = true;
      _ResolveType.Async = true;
      _GetTypeDebugInfoForToken.Async = true;
      _GetTypeDebugInfoForDocumentArg.Async = true;
      _GetDebugDataCacheDirectory.Async = true;
      _GetExpressionForILRange.Async = true;
      _GetExpressionListForILRange.Async = true;
      _GetExpressionRangeForStartOffset.Async = true;
      _GetOutputAssembliesInfo.Async = true;
      _ResolveType.ValueCanBeNull = true;
      _GetExpressionForILRange.ValueCanBeNull = true;
      _GetExpressionListForILRange.ValueCanBeNull = true;
      _GetExpressionRangeForStartOffset.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("hostConnected", _HostConnected));
      BindableChildren.Add(new KeyValuePair<string, object>("resolveType", _ResolveType));
      BindableChildren.Add(new KeyValuePair<string, object>("getTypeDebugInfoForToken", _GetTypeDebugInfoForToken));
      BindableChildren.Add(new KeyValuePair<string, object>("getTypeDebugInfoForDocumentArg", _GetTypeDebugInfoForDocumentArg));
      BindableChildren.Add(new KeyValuePair<string, object>("getDebugDataCacheDirectory", _GetDebugDataCacheDirectory));
      BindableChildren.Add(new KeyValuePair<string, object>("getExpressionForILRange", _GetExpressionForILRange));
      BindableChildren.Add(new KeyValuePair<string, object>("getExpressionListForILRange", _GetExpressionListForILRange));
      BindableChildren.Add(new KeyValuePair<string, object>("getExpressionRangeForStartOffset", _GetExpressionRangeForStartOffset));
      BindableChildren.Add(new KeyValuePair<string, object>("getOutputAssembliesInfo", _GetOutputAssembliesInfo));
      BindableChildren.Add(new KeyValuePair<string, object>("modules", _Modules));
    }
    //secondary constructor
    private DebuggerWorkerToHostModel (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<ResolveTypeArg, string>(ResolveTypeArg.Read, ResolveTypeArg.Write, ReadStringNullable, WriteStringNullable),
      new RdEndpoint<GetTypeDebugInfoForTokenArg, GetTypeDebugInfoResult>(GetTypeDebugInfoForTokenArg.Read, GetTypeDebugInfoForTokenArg.Write, GetTypeDebugInfoResult.Read, GetTypeDebugInfoResult.Write),
      new RdEndpoint<JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg, GetTypeDebugInfoResult>(JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg.Read, JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg.Write, GetTypeDebugInfoResult.Read, GetTypeDebugInfoResult.Write),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<GetExpressionForILRangeArg, string>(GetExpressionForILRangeArg.Read, GetExpressionForILRangeArg.Write, ReadStringNullable, WriteStringNullable),
      new RdEndpoint<GetExpressionListForILRangeArg, List<GetExpressionListForILRangeResult>>(GetExpressionListForILRangeArg.Read, GetExpressionListForILRangeArg.Write, ReadGetExpressionListForILRangeResultListNullable, WriteGetExpressionListForILRangeResultListNullable),
      new RdEndpoint<GetExpressionRangeForStartOffsetArg, GetExpressionRangeForStartOffsetResult>(GetExpressionRangeForStartOffsetArg.Read, GetExpressionRangeForStartOffsetArg.Write, ReadGetExpressionRangeForStartOffsetResultNullable, WriteGetExpressionRangeForStartOffsetResultNullable),
      new RdEndpoint<RdVoid, GetOutputAssembliesInfoResult>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, GetOutputAssembliesInfoResult.Read, GetOutputAssembliesInfoResult.Write),
      new RdMap<string, ModuleInfo>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ModuleInfo.Read, ModuleInfo.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<GetExpressionListForILRangeResult>> ReadGetExpressionListForILRangeResultListNullable = GetExpressionListForILRangeResult.Read.List().NullableClass();
    public static CtxReadDelegate<GetExpressionRangeForStartOffsetResult> ReadGetExpressionRangeForStartOffsetResultNullable = GetExpressionRangeForStartOffsetResult.Read.NullableClass();
    
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<GetExpressionListForILRangeResult>> WriteGetExpressionListForILRangeResultListNullable = GetExpressionListForILRangeResult.Write.List().NullableClass();
    public static CtxWriteDelegate<GetExpressionRangeForStartOffsetResult> WriteGetExpressionRangeForStartOffsetResultNullable = GetExpressionRangeForStartOffsetResult.Write.NullableClass();
    
    protected override long SerializationHash => -5024461683964841388L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(ResolveTypeArg.Read, ResolveTypeArg.Write);
      serializers.Register(GetTypeDebugInfoForTokenArg.Read, GetTypeDebugInfoForTokenArg.Write);
      serializers.Register(JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg.Read, JetBrains.Rider.Model.DebuggerHostToWorker.GetTypeDebugInfoForDocumentArg.Write);
      serializers.Register(GetTypeDebugInfoResult.Read, GetTypeDebugInfoResult.Write);
      serializers.Register(ModuleInfo.Read, ModuleInfo.Write);
      serializers.Register(GetExpressionForILRangeArg.Read, GetExpressionForILRangeArg.Write);
      serializers.Register(GetExpressionListForILRangeArg.Read, GetExpressionListForILRangeArg.Write);
      serializers.Register(GetExpressionListForILRangeResult.Read, GetExpressionListForILRangeResult.Write);
      serializers.Register(GetExpressionRangeForStartOffsetArg.Read, GetExpressionRangeForStartOffsetArg.Write);
      serializers.Register(GetExpressionRangeForStartOffsetResult.Read, GetExpressionRangeForStartOffsetResult.Write);
      serializers.Register(OutputAssembliesInfo.Read, OutputAssembliesInfo.Write);
      serializers.Register(GetOutputAssembliesInfoResult.Read, GetOutputAssembliesInfoResult.Write);
      serializers.RegisterEnum<DebugDataOrigin>();
      
      serializers.RegisterToplevelOnce(typeof(DebuggerWorkerToHostModel), DebuggerWorkerToHostModel.RegisterDeclaredTypesSerializers);
    }
    
    public DebuggerWorkerToHostModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebuggerWorkerToHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("hostConnected = "); _HostConnected.PrintEx(printer); printer.Println();
        printer.Print("resolveType = "); _ResolveType.PrintEx(printer); printer.Println();
        printer.Print("getTypeDebugInfoForToken = "); _GetTypeDebugInfoForToken.PrintEx(printer); printer.Println();
        printer.Print("getTypeDebugInfoForDocumentArg = "); _GetTypeDebugInfoForDocumentArg.PrintEx(printer); printer.Println();
        printer.Print("getDebugDataCacheDirectory = "); _GetDebugDataCacheDirectory.PrintEx(printer); printer.Println();
        printer.Print("getExpressionForILRange = "); _GetExpressionForILRange.PrintEx(printer); printer.Println();
        printer.Print("getExpressionListForILRange = "); _GetExpressionListForILRange.PrintEx(printer); printer.Println();
        printer.Print("getExpressionRangeForStartOffset = "); _GetExpressionRangeForStartOffset.PrintEx(printer); printer.Println();
        printer.Print("getOutputAssembliesInfo = "); _GetOutputAssembliesInfo.PrintEx(printer); printer.Println();
        printer.Print("modules = "); _Modules.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum DebugDataOrigin {
    Internal,
    External,
    Decompiled
  }
  
  
  public class GetExpressionForILRangeArg : IPrintable, IEquatable<GetExpressionForILRangeArg>
  {
    //fields
    //public fields
    [NotNull] public string FilePath {get; private set;}
    public int StartLine {get; private set;}
    public int StartCol {get; private set;}
    public int EndLine {get; private set;}
    public int EndCol {get; private set;}
    public int CallIndex {get; private set;}
    [NotNull] public string CallableName {get; private set;}
    
    //private fields
    //primary constructor
    public GetExpressionForILRangeArg(
      [NotNull] string filePath,
      int startLine,
      int startCol,
      int endLine,
      int endCol,
      int callIndex,
      [NotNull] string callableName
    )
    {
      if (filePath == null) throw new ArgumentNullException("filePath");
      if (callableName == null) throw new ArgumentNullException("callableName");
      
      FilePath = filePath;
      StartLine = startLine;
      StartCol = startCol;
      EndLine = endLine;
      EndCol = endCol;
      CallIndex = callIndex;
      CallableName = callableName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetExpressionForILRangeArg> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var startLine = reader.ReadInt();
      var startCol = reader.ReadInt();
      var endLine = reader.ReadInt();
      var endCol = reader.ReadInt();
      var callIndex = reader.ReadInt();
      var callableName = reader.ReadString();
      return new GetExpressionForILRangeArg(filePath, startLine, startCol, endLine, endCol, callIndex, callableName);
    };
    
    public static CtxWriteDelegate<GetExpressionForILRangeArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.StartLine);
      writer.Write(value.StartCol);
      writer.Write(value.EndLine);
      writer.Write(value.EndCol);
      writer.Write(value.CallIndex);
      writer.Write(value.CallableName);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetExpressionForILRangeArg) obj);
    }
    public bool Equals(GetExpressionForILRangeArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FilePath == other.FilePath && StartLine == other.StartLine && StartCol == other.StartCol && EndLine == other.EndLine && EndCol == other.EndCol && CallIndex == other.CallIndex && CallableName == other.CallableName;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FilePath.GetHashCode();
        hash = hash * 31 + StartLine.GetHashCode();
        hash = hash * 31 + StartCol.GetHashCode();
        hash = hash * 31 + EndLine.GetHashCode();
        hash = hash * 31 + EndCol.GetHashCode();
        hash = hash * 31 + CallIndex.GetHashCode();
        hash = hash * 31 + CallableName.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetExpressionForILRangeArg (");
      using (printer.IndentCookie()) {
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("startLine = "); StartLine.PrintEx(printer); printer.Println();
        printer.Print("startCol = "); StartCol.PrintEx(printer); printer.Println();
        printer.Print("endLine = "); EndLine.PrintEx(printer); printer.Println();
        printer.Print("endCol = "); EndCol.PrintEx(printer); printer.Println();
        printer.Print("callIndex = "); CallIndex.PrintEx(printer); printer.Println();
        printer.Print("callableName = "); CallableName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetExpressionListForILRangeArg : IPrintable, IEquatable<GetExpressionListForILRangeArg>
  {
    //fields
    //public fields
    [NotNull] public string FilePath {get; private set;}
    public int StartLine {get; private set;}
    public int StartCol {get; private set;}
    public int EndLine {get; private set;}
    public int EndCol {get; private set;}
    
    //private fields
    //primary constructor
    public GetExpressionListForILRangeArg(
      [NotNull] string filePath,
      int startLine,
      int startCol,
      int endLine,
      int endCol
    )
    {
      if (filePath == null) throw new ArgumentNullException("filePath");
      
      FilePath = filePath;
      StartLine = startLine;
      StartCol = startCol;
      EndLine = endLine;
      EndCol = endCol;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetExpressionListForILRangeArg> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var startLine = reader.ReadInt();
      var startCol = reader.ReadInt();
      var endLine = reader.ReadInt();
      var endCol = reader.ReadInt();
      return new GetExpressionListForILRangeArg(filePath, startLine, startCol, endLine, endCol);
    };
    
    public static CtxWriteDelegate<GetExpressionListForILRangeArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.StartLine);
      writer.Write(value.StartCol);
      writer.Write(value.EndLine);
      writer.Write(value.EndCol);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetExpressionListForILRangeArg) obj);
    }
    public bool Equals(GetExpressionListForILRangeArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FilePath == other.FilePath && StartLine == other.StartLine && StartCol == other.StartCol && EndLine == other.EndLine && EndCol == other.EndCol;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FilePath.GetHashCode();
        hash = hash * 31 + StartLine.GetHashCode();
        hash = hash * 31 + StartCol.GetHashCode();
        hash = hash * 31 + EndLine.GetHashCode();
        hash = hash * 31 + EndCol.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetExpressionListForILRangeArg (");
      using (printer.IndentCookie()) {
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("startLine = "); StartLine.PrintEx(printer); printer.Println();
        printer.Print("startCol = "); StartCol.PrintEx(printer); printer.Println();
        printer.Print("endLine = "); EndLine.PrintEx(printer); printer.Println();
        printer.Print("endCol = "); EndCol.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetExpressionListForILRangeResult : IPrintable, IEquatable<GetExpressionListForILRangeResult>
  {
    //fields
    //public fields
    public int DocumentStartOffset {get; private set;}
    public int DocumentEndOffset {get; private set;}
    [NotNull] public string MetadataName {get; private set;}
    [NotNull] public string ExpressionText {get; private set;}
    
    //private fields
    //primary constructor
    public GetExpressionListForILRangeResult(
      int documentStartOffset,
      int documentEndOffset,
      [NotNull] string metadataName,
      [NotNull] string expressionText
    )
    {
      if (metadataName == null) throw new ArgumentNullException("metadataName");
      if (expressionText == null) throw new ArgumentNullException("expressionText");
      
      DocumentStartOffset = documentStartOffset;
      DocumentEndOffset = documentEndOffset;
      MetadataName = metadataName;
      ExpressionText = expressionText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetExpressionListForILRangeResult> Read = (ctx, reader) => 
    {
      var documentStartOffset = reader.ReadInt();
      var documentEndOffset = reader.ReadInt();
      var metadataName = reader.ReadString();
      var expressionText = reader.ReadString();
      return new GetExpressionListForILRangeResult(documentStartOffset, documentEndOffset, metadataName, expressionText);
    };
    
    public static CtxWriteDelegate<GetExpressionListForILRangeResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DocumentStartOffset);
      writer.Write(value.DocumentEndOffset);
      writer.Write(value.MetadataName);
      writer.Write(value.ExpressionText);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetExpressionListForILRangeResult) obj);
    }
    public bool Equals(GetExpressionListForILRangeResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DocumentStartOffset == other.DocumentStartOffset && DocumentEndOffset == other.DocumentEndOffset && MetadataName == other.MetadataName && ExpressionText == other.ExpressionText;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DocumentStartOffset.GetHashCode();
        hash = hash * 31 + DocumentEndOffset.GetHashCode();
        hash = hash * 31 + MetadataName.GetHashCode();
        hash = hash * 31 + ExpressionText.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetExpressionListForILRangeResult (");
      using (printer.IndentCookie()) {
        printer.Print("documentStartOffset = "); DocumentStartOffset.PrintEx(printer); printer.Println();
        printer.Print("documentEndOffset = "); DocumentEndOffset.PrintEx(printer); printer.Println();
        printer.Print("metadataName = "); MetadataName.PrintEx(printer); printer.Println();
        printer.Print("expressionText = "); ExpressionText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetExpressionRangeForStartOffsetArg : IPrintable, IEquatable<GetExpressionRangeForStartOffsetArg>
  {
    //fields
    //public fields
    [NotNull] public string FilePath {get; private set;}
    public int StartLine {get; private set;}
    public int StartCol {get; private set;}
    
    //private fields
    //primary constructor
    public GetExpressionRangeForStartOffsetArg(
      [NotNull] string filePath,
      int startLine,
      int startCol
    )
    {
      if (filePath == null) throw new ArgumentNullException("filePath");
      
      FilePath = filePath;
      StartLine = startLine;
      StartCol = startCol;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetExpressionRangeForStartOffsetArg> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var startLine = reader.ReadInt();
      var startCol = reader.ReadInt();
      return new GetExpressionRangeForStartOffsetArg(filePath, startLine, startCol);
    };
    
    public static CtxWriteDelegate<GetExpressionRangeForStartOffsetArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.StartLine);
      writer.Write(value.StartCol);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetExpressionRangeForStartOffsetArg) obj);
    }
    public bool Equals(GetExpressionRangeForStartOffsetArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FilePath == other.FilePath && StartLine == other.StartLine && StartCol == other.StartCol;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FilePath.GetHashCode();
        hash = hash * 31 + StartLine.GetHashCode();
        hash = hash * 31 + StartCol.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetExpressionRangeForStartOffsetArg (");
      using (printer.IndentCookie()) {
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("startLine = "); StartLine.PrintEx(printer); printer.Println();
        printer.Print("startCol = "); StartCol.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetExpressionRangeForStartOffsetResult : IPrintable, IEquatable<GetExpressionRangeForStartOffsetResult>
  {
    //fields
    //public fields
    public int StartLine {get; private set;}
    public int StartCol {get; private set;}
    public int EndLine {get; private set;}
    public int EndCol {get; private set;}
    
    //private fields
    //primary constructor
    public GetExpressionRangeForStartOffsetResult(
      int startLine,
      int startCol,
      int endLine,
      int endCol
    )
    {
      StartLine = startLine;
      StartCol = startCol;
      EndLine = endLine;
      EndCol = endCol;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetExpressionRangeForStartOffsetResult> Read = (ctx, reader) => 
    {
      var startLine = reader.ReadInt();
      var startCol = reader.ReadInt();
      var endLine = reader.ReadInt();
      var endCol = reader.ReadInt();
      return new GetExpressionRangeForStartOffsetResult(startLine, startCol, endLine, endCol);
    };
    
    public static CtxWriteDelegate<GetExpressionRangeForStartOffsetResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartLine);
      writer.Write(value.StartCol);
      writer.Write(value.EndLine);
      writer.Write(value.EndCol);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetExpressionRangeForStartOffsetResult) obj);
    }
    public bool Equals(GetExpressionRangeForStartOffsetResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartLine == other.StartLine && StartCol == other.StartCol && EndLine == other.EndLine && EndCol == other.EndCol;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + StartLine.GetHashCode();
        hash = hash * 31 + StartCol.GetHashCode();
        hash = hash * 31 + EndLine.GetHashCode();
        hash = hash * 31 + EndCol.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetExpressionRangeForStartOffsetResult (");
      using (printer.IndentCookie()) {
        printer.Print("startLine = "); StartLine.PrintEx(printer); printer.Println();
        printer.Print("startCol = "); StartCol.PrintEx(printer); printer.Println();
        printer.Print("endLine = "); EndLine.PrintEx(printer); printer.Println();
        printer.Print("endCol = "); EndCol.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetOutputAssembliesInfoResult : IPrintable, IEquatable<GetOutputAssembliesInfoResult>
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.DebuggerHostToWorker.OutputAssembliesInfo[] OutputAssembliesInfo {get; private set;}
    
    //private fields
    //primary constructor
    public GetOutputAssembliesInfoResult(
      [NotNull] JetBrains.Rider.Model.DebuggerHostToWorker.OutputAssembliesInfo[] outputAssembliesInfo
    )
    {
      if (outputAssembliesInfo == null) throw new ArgumentNullException("outputAssembliesInfo");
      
      OutputAssembliesInfo = outputAssembliesInfo;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetOutputAssembliesInfoResult> Read = (ctx, reader) => 
    {
      var outputAssembliesInfo = ReadOutputAssembliesInfoArray(ctx, reader);
      return new GetOutputAssembliesInfoResult(outputAssembliesInfo);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.DebuggerHostToWorker.OutputAssembliesInfo[]> ReadOutputAssembliesInfoArray = JetBrains.Rider.Model.DebuggerHostToWorker.OutputAssembliesInfo.Read.Array();
    
    public static CtxWriteDelegate<GetOutputAssembliesInfoResult> Write = (ctx, writer, value) => 
    {
      WriteOutputAssembliesInfoArray(ctx, writer, value.OutputAssembliesInfo);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.DebuggerHostToWorker.OutputAssembliesInfo[]> WriteOutputAssembliesInfoArray = JetBrains.Rider.Model.DebuggerHostToWorker.OutputAssembliesInfo.Write.Array();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetOutputAssembliesInfoResult) obj);
    }
    public bool Equals(GetOutputAssembliesInfoResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return OutputAssembliesInfo.SequenceEqual(other.OutputAssembliesInfo);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(OutputAssembliesInfo);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetOutputAssembliesInfoResult (");
      using (printer.IndentCookie()) {
        printer.Print("outputAssembliesInfo = "); OutputAssembliesInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetTypeDebugInfoForDocumentArg : IPrintable, IEquatable<GetTypeDebugInfoForDocumentArg>
  {
    //fields
    //public fields
    [NotNull] public string DocumentPath {get; private set;}
    
    //private fields
    //primary constructor
    public GetTypeDebugInfoForDocumentArg(
      [NotNull] string documentPath
    )
    {
      if (documentPath == null) throw new ArgumentNullException("documentPath");
      
      DocumentPath = documentPath;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetTypeDebugInfoForDocumentArg> Read = (ctx, reader) => 
    {
      var documentPath = reader.ReadString();
      return new GetTypeDebugInfoForDocumentArg(documentPath);
    };
    
    public static CtxWriteDelegate<GetTypeDebugInfoForDocumentArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DocumentPath);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetTypeDebugInfoForDocumentArg) obj);
    }
    public bool Equals(GetTypeDebugInfoForDocumentArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DocumentPath == other.DocumentPath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DocumentPath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetTypeDebugInfoForDocumentArg (");
      using (printer.IndentCookie()) {
        printer.Print("documentPath = "); DocumentPath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetTypeDebugInfoForTokenArg : IPrintable, IEquatable<GetTypeDebugInfoForTokenArg>
  {
    //fields
    //public fields
    [NotNull] public string AssemblyPath {get; private set;}
    public int Token {get; private set;}
    
    //private fields
    //primary constructor
    public GetTypeDebugInfoForTokenArg(
      [NotNull] string assemblyPath,
      int token
    )
    {
      if (assemblyPath == null) throw new ArgumentNullException("assemblyPath");
      
      AssemblyPath = assemblyPath;
      Token = token;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetTypeDebugInfoForTokenArg> Read = (ctx, reader) => 
    {
      var assemblyPath = reader.ReadString();
      var token = reader.ReadInt();
      return new GetTypeDebugInfoForTokenArg(assemblyPath, token);
    };
    
    public static CtxWriteDelegate<GetTypeDebugInfoForTokenArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.AssemblyPath);
      writer.Write(value.Token);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetTypeDebugInfoForTokenArg) obj);
    }
    public bool Equals(GetTypeDebugInfoForTokenArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AssemblyPath == other.AssemblyPath && Token == other.Token;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AssemblyPath.GetHashCode();
        hash = hash * 31 + Token.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetTypeDebugInfoForTokenArg (");
      using (printer.IndentCookie()) {
        printer.Print("assemblyPath = "); AssemblyPath.PrintEx(printer); printer.Println();
        printer.Print("token = "); Token.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetTypeDebugInfoResult : IPrintable, IEquatable<GetTypeDebugInfoResult>
  {
    //fields
    //public fields
    [NotNull] public byte[] Data {get; private set;}
    public Guid Mvid {get; private set;}
    [NotNull] public string AssemblyPath {get; private set;}
    [NotNull] public string AssemblyFullName {get; private set;}
    public JetBrains.Rider.Model.DebuggerHostToWorker.DebugDataOrigin DebugDataOrigin {get; private set;}
    
    //private fields
    //primary constructor
    public GetTypeDebugInfoResult(
      [NotNull] byte[] data,
      Guid mvid,
      [NotNull] string assemblyPath,
      [NotNull] string assemblyFullName,
      JetBrains.Rider.Model.DebuggerHostToWorker.DebugDataOrigin debugDataOrigin
    )
    {
      if (data == null) throw new ArgumentNullException("data");
      if (assemblyPath == null) throw new ArgumentNullException("assemblyPath");
      if (assemblyFullName == null) throw new ArgumentNullException("assemblyFullName");
      
      Data = data;
      Mvid = mvid;
      AssemblyPath = assemblyPath;
      AssemblyFullName = assemblyFullName;
      DebugDataOrigin = debugDataOrigin;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetTypeDebugInfoResult> Read = (ctx, reader) => 
    {
      var data = JetBrains.Platform.RdFramework.Impl.Serializers.ReadByteArray(ctx, reader);
      var mvid = reader.ReadGuid();
      var assemblyPath = reader.ReadString();
      var assemblyFullName = reader.ReadString();
      var debugDataOrigin = (JetBrains.Rider.Model.DebuggerHostToWorker.DebugDataOrigin)reader.ReadInt();
      return new GetTypeDebugInfoResult(data, mvid, assemblyPath, assemblyFullName, debugDataOrigin);
    };
    
    public static CtxWriteDelegate<GetTypeDebugInfoResult> Write = (ctx, writer, value) => 
    {
      JetBrains.Platform.RdFramework.Impl.Serializers.WriteByteArray(ctx, writer, value.Data);
      writer.Write(value.Mvid);
      writer.Write(value.AssemblyPath);
      writer.Write(value.AssemblyFullName);
      writer.Write((int)value.DebugDataOrigin);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetTypeDebugInfoResult) obj);
    }
    public bool Equals(GetTypeDebugInfoResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Data.SequenceEqual(other.Data) && Mvid == other.Mvid && AssemblyPath == other.AssemblyPath && AssemblyFullName == other.AssemblyFullName && DebugDataOrigin == other.DebugDataOrigin;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Data);
        hash = hash * 31 + Mvid.GetHashCode();
        hash = hash * 31 + AssemblyPath.GetHashCode();
        hash = hash * 31 + AssemblyFullName.GetHashCode();
        hash = hash * 31 + (int) DebugDataOrigin;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetTypeDebugInfoResult (");
      using (printer.IndentCookie()) {
        printer.Print("data = "); Data.PrintEx(printer); printer.Println();
        printer.Print("mvid = "); Mvid.PrintEx(printer); printer.Println();
        printer.Print("assemblyPath = "); AssemblyPath.PrintEx(printer); printer.Println();
        printer.Print("assemblyFullName = "); AssemblyFullName.PrintEx(printer); printer.Println();
        printer.Print("debugDataOrigin = "); DebugDataOrigin.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ModuleInfo : IPrintable, IEquatable<ModuleInfo>
  {
    //fields
    //public fields
    [NotNull] public string AssemblyName {get; private set;}
    [CanBeNull] public string Location {get; private set;}
    
    //private fields
    //primary constructor
    public ModuleInfo(
      [NotNull] string assemblyName,
      [CanBeNull] string location
    )
    {
      if (assemblyName == null) throw new ArgumentNullException("assemblyName");
      
      AssemblyName = assemblyName;
      Location = location;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ModuleInfo> Read = (ctx, reader) => 
    {
      var assemblyName = reader.ReadString();
      var location = ReadStringNullable(ctx, reader);
      return new ModuleInfo(assemblyName, location);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<ModuleInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.AssemblyName);
      WriteStringNullable(ctx, writer, value.Location);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ModuleInfo) obj);
    }
    public bool Equals(ModuleInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AssemblyName == other.AssemblyName && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AssemblyName.GetHashCode();
        hash = hash * 31 + (Location != null ?Location.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ModuleInfo (");
      using (printer.IndentCookie()) {
        printer.Print("assemblyName = "); AssemblyName.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OutputAssembliesInfo : IPrintable, IEquatable<OutputAssembliesInfo>
  {
    //fields
    //public fields
    [NotNull] public string AssemblyName {get; private set;}
    [NotNull] public string CsprojDirectory {get; private set;}
    [NotNull] public string Location {get; private set;}
    
    //private fields
    //primary constructor
    public OutputAssembliesInfo(
      [NotNull] string assemblyName,
      [NotNull] string csprojDirectory,
      [NotNull] string location
    )
    {
      if (assemblyName == null) throw new ArgumentNullException("assemblyName");
      if (csprojDirectory == null) throw new ArgumentNullException("csprojDirectory");
      if (location == null) throw new ArgumentNullException("location");
      
      AssemblyName = assemblyName;
      CsprojDirectory = csprojDirectory;
      Location = location;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<OutputAssembliesInfo> Read = (ctx, reader) => 
    {
      var assemblyName = reader.ReadString();
      var csprojDirectory = reader.ReadString();
      var location = reader.ReadString();
      return new OutputAssembliesInfo(assemblyName, csprojDirectory, location);
    };
    
    public static CtxWriteDelegate<OutputAssembliesInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.AssemblyName);
      writer.Write(value.CsprojDirectory);
      writer.Write(value.Location);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((OutputAssembliesInfo) obj);
    }
    public bool Equals(OutputAssembliesInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AssemblyName == other.AssemblyName && CsprojDirectory == other.CsprojDirectory && Location == other.Location;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AssemblyName.GetHashCode();
        hash = hash * 31 + CsprojDirectory.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("OutputAssembliesInfo (");
      using (printer.IndentCookie()) {
        printer.Print("assemblyName = "); AssemblyName.PrintEx(printer); printer.Println();
        printer.Print("csprojDirectory = "); CsprojDirectory.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveTypeArg : IPrintable, IEquatable<ResolveTypeArg>
  {
    //fields
    //public fields
    [NotNull] public string Identifier {get; private set;}
    [NotNull] public string Filename {get; private set;}
    public int Line {get; private set;}
    public int Column {get; private set;}
    
    //private fields
    //primary constructor
    public ResolveTypeArg(
      [NotNull] string identifier,
      [NotNull] string filename,
      int line,
      int column
    )
    {
      if (identifier == null) throw new ArgumentNullException("identifier");
      if (filename == null) throw new ArgumentNullException("filename");
      
      Identifier = identifier;
      Filename = filename;
      Line = line;
      Column = column;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveTypeArg> Read = (ctx, reader) => 
    {
      var identifier = reader.ReadString();
      var filename = reader.ReadString();
      var line = reader.ReadInt();
      var column = reader.ReadInt();
      return new ResolveTypeArg(identifier, filename, line, column);
    };
    
    public static CtxWriteDelegate<ResolveTypeArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Identifier);
      writer.Write(value.Filename);
      writer.Write(value.Line);
      writer.Write(value.Column);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveTypeArg) obj);
    }
    public bool Equals(ResolveTypeArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Identifier == other.Identifier && Filename == other.Filename && Line == other.Line && Column == other.Column;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Identifier.GetHashCode();
        hash = hash * 31 + Filename.GetHashCode();
        hash = hash * 31 + Line.GetHashCode();
        hash = hash * 31 + Column.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveTypeArg (");
      using (printer.IndentCookie()) {
        printer.Print("identifier = "); Identifier.PrintEx(printer); printer.Println();
        printer.Print("filename = "); Filename.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("column = "); Column.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
