using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DeploymentHost : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<DeploymentArgsBase, DeploymentResultBase> Deploy { get { return _Deploy; }}
    [NotNull] public IRdProperty<DeploymentSession> NextDeployRequestWithProgress { get { return _NextDeployRequestWithProgress; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<DeploymentArgsBase, DeploymentResultBase> _Deploy;
    [NotNull] private readonly RdProperty<DeploymentSession> _NextDeployRequestWithProgress;
    
    //primary constructor
    private DeploymentHost(
      [NotNull] RdEndpoint<DeploymentArgsBase, DeploymentResultBase> deploy,
      [NotNull] RdProperty<DeploymentSession> nextDeployRequestWithProgress
    )
    {
      if (deploy == null) throw new ArgumentNullException("deploy");
      if (nextDeployRequestWithProgress == null) throw new ArgumentNullException("nextDeployRequestWithProgress");
      
      _Deploy = deploy;
      _NextDeployRequestWithProgress = nextDeployRequestWithProgress;
      _NextDeployRequestWithProgress.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("deploy", _Deploy));
      BindableChildren.Add(new KeyValuePair<string, object>("nextDeployRequestWithProgress", _NextDeployRequestWithProgress));
    }
    //secondary constructor
    internal DeploymentHost (
    ) : this (
      new RdEndpoint<DeploymentArgsBase, DeploymentResultBase>(DeploymentArgsBase.Read, DeploymentArgsBase.Write, DeploymentResultBase.Read, DeploymentResultBase.Write),
      new RdProperty<DeploymentSession>(ReadDeploymentSessionNullable, WriteDeploymentSessionNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<DeploymentSession> ReadDeploymentSessionNullable = DeploymentSession.Read.NullableClass();
    
    public static CtxWriteDelegate<DeploymentSession> WriteDeploymentSessionNullable = DeploymentSession.Write.NullableClass();
    
    protected override long SerializationHash => -7563430172059359741L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(XamarinAndroidDeploymentArgs.Read, XamarinAndroidDeploymentArgs.Write);
      serializers.Register(XamarinIOSDeploymentArgs.Read, XamarinIOSDeploymentArgs.Write);
      serializers.Register(UwpDeploymentArgs.Read, UwpDeploymentArgs.Write);
      serializers.RegisterEnum<DeploymentResultStatus>();
      serializers.Register(FailedDeploymentResult.Read, FailedDeploymentResult.Write);
      serializers.Register(DeploymentSession.Read, DeploymentSession.Write);
      serializers.Register(XamarinAndroidDeploymentResult.Read, XamarinAndroidDeploymentResult.Write);
      serializers.Register(XamarinIOSDeploymentResult.Read, XamarinIOSDeploymentResult.Write);
      serializers.Register(UwpDeploymentResult.Read, UwpDeploymentResult.Write);
      serializers.Register(OutputMessage.Read, OutputMessage.Write);
      serializers.RegisterEnum<DeployMessageKind>();
      serializers.Register(DeploymentArgsBase_Unknown.Read, DeploymentArgsBase_Unknown.Write);
      serializers.Register(DeploymentResultBase_Unknown.Read, DeploymentResultBase_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DeploymentHost (");
      using (printer.IndentCookie()) {
        printer.Print("deploy = "); _Deploy.PrintEx(printer); printer.Println();
        printer.Print("nextDeployRequestWithProgress = "); _NextDeployRequestWithProgress.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDeploymentHostEx
   {
    public static DeploymentHost GetDeploymentHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("deploymentHost", () => new DeploymentHost());
    }
  }
  
  
  public enum DeployMessageKind {
    Info,
    Error,
    Warning
  }
  
  
  public abstract class DeploymentArgsBase{
    //fields
    //public fields
    public RunnableProjectKind ProjectKind {get; private set;}
    [NotNull] public string ProjectFilePath {get; private set;}
    
    //private fields
    //primary constructor
    protected DeploymentArgsBase(
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    )
    {
      if (projectFilePath == null) throw new ArgumentNullException("projectFilePath");
      
      ProjectKind = projectKind;
      ProjectFilePath = projectFilePath;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DeploymentArgsBase> Read = Polymorphic<DeploymentArgsBase>.ReadAbstract(DeploymentArgsBase_Unknown.Read);
    
    public static CtxWriteDelegate<DeploymentArgsBase> Write = Polymorphic<DeploymentArgsBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class DeploymentArgsBase_Unknown : DeploymentArgsBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public DeploymentArgsBase_Unknown(
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    ) : base (
      projectKind,
      projectFilePath
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DeploymentArgsBase_Unknown> Read = (ctx, reader) => 
    {
      var projectKind = (RunnableProjectKind)reader.ReadInt();
      var projectFilePath = reader.ReadString();
      return new DeploymentArgsBase_Unknown(projectKind, projectFilePath);
    };
    
    public static new CtxWriteDelegate<DeploymentArgsBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ProjectKind);
      writer.Write(value.ProjectFilePath);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DeploymentArgsBase_Unknown) obj);
    }
    public bool Equals(DeploymentArgsBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectKind == other.ProjectKind && ProjectFilePath == other.ProjectFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) ProjectKind;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DeploymentArgsBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("projectKind = "); ProjectKind.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class DeploymentResultBase{
    //fields
    //public fields
    public DeploymentResultStatus Status {get; private set;}
    
    //private fields
    //primary constructor
    protected DeploymentResultBase(
      DeploymentResultStatus status
    )
    {
      Status = status;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DeploymentResultBase> Read = Polymorphic<DeploymentResultBase>.ReadAbstract(DeploymentResultBase_Unknown.Read);
    
    public static CtxWriteDelegate<DeploymentResultBase> Write = Polymorphic<DeploymentResultBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class DeploymentResultBase_Unknown : DeploymentResultBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public DeploymentResultBase_Unknown(
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DeploymentResultBase_Unknown> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      return new DeploymentResultBase_Unknown(status);
    };
    
    public static new CtxWriteDelegate<DeploymentResultBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DeploymentResultBase_Unknown) obj);
    }
    public bool Equals(DeploymentResultBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DeploymentResultBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum DeploymentResultStatus {
    Success,
    Failed,
    Cancelled
  }
  
  
  public class DeploymentSession : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public DeploymentArgsBase Args {get; private set;}
    [NotNull] public IRdProperty<DeploymentResultBase> Result { get { return _Result; }}
    [NotNull] public ISource<OutputMessage> OutputAdded { get { return _OutputAdded; }}
    [NotNull] public ISource<string> StatusChanged { get { return _StatusChanged; }}
    [NotNull] public IRdProperty<double> Progress { get { return _Progress; }}
    
    //private fields
    [NotNull] private readonly RdProperty<DeploymentResultBase> _Result;
    [NotNull] private readonly RdSignal<OutputMessage> _OutputAdded;
    [NotNull] private readonly RdSignal<string> _StatusChanged;
    [NotNull] private readonly RdProperty<double> _Progress;
    
    //primary constructor
    private DeploymentSession(
      [NotNull] DeploymentArgsBase args,
      [NotNull] RdProperty<DeploymentResultBase> result,
      [NotNull] RdSignal<OutputMessage> outputAdded,
      [NotNull] RdSignal<string> statusChanged,
      [NotNull] RdProperty<double> progress
    )
    {
      if (args == null) throw new ArgumentNullException("args");
      if (result == null) throw new ArgumentNullException("result");
      if (outputAdded == null) throw new ArgumentNullException("outputAdded");
      if (statusChanged == null) throw new ArgumentNullException("statusChanged");
      if (progress == null) throw new ArgumentNullException("progress");
      
      Args = args;
      _Result = result;
      _OutputAdded = outputAdded;
      _StatusChanged = statusChanged;
      _Progress = progress;
      _Result.OptimizeNested = true;
      _Progress.OptimizeNested = true;
      _OutputAdded.Async = true;
      _StatusChanged.Async = true;
      _Progress.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("result", _Result));
      BindableChildren.Add(new KeyValuePair<string, object>("outputAdded", _OutputAdded));
      BindableChildren.Add(new KeyValuePair<string, object>("statusChanged", _StatusChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("progress", _Progress));
    }
    //secondary constructor
    public DeploymentSession (
      [NotNull] DeploymentArgsBase args
    ) : this (
      args,
      new RdProperty<DeploymentResultBase>(DeploymentResultBase.Read, DeploymentResultBase.Write),
      new RdSignal<OutputMessage>(OutputMessage.Read, OutputMessage.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble, 0.0)
    ) {}
    //statics
    
    public static CtxReadDelegate<DeploymentSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var args = DeploymentArgsBase.Read(ctx, reader);
      var result = RdProperty<DeploymentResultBase>.Read(ctx, reader, DeploymentResultBase.Read, DeploymentResultBase.Write);
      var outputAdded = RdSignal<OutputMessage>.Read(ctx, reader, OutputMessage.Read, OutputMessage.Write);
      var statusChanged = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var progress = RdProperty<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      return new DeploymentSession(args, result, outputAdded, statusChanged, progress).WithId(_id);
    };
    
    public static CtxWriteDelegate<DeploymentSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      DeploymentArgsBase.Write(ctx, writer, value.Args);
      RdProperty<DeploymentResultBase>.Write(ctx, writer, value._Result);
      RdSignal<OutputMessage>.Write(ctx, writer, value._OutputAdded);
      RdSignal<string>.Write(ctx, writer, value._StatusChanged);
      RdProperty<double>.Write(ctx, writer, value._Progress);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DeploymentSession (");
      using (printer.IndentCookie()) {
        printer.Print("args = "); Args.PrintEx(printer); printer.Println();
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
        printer.Print("outputAdded = "); _OutputAdded.PrintEx(printer); printer.Println();
        printer.Print("statusChanged = "); _StatusChanged.PrintEx(printer); printer.Println();
        printer.Print("progress = "); _Progress.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FailedDeploymentResult : DeploymentResultBase
  {
    //fields
    //public fields
    [NotNull] public string Reason {get; private set;}
    
    //private fields
    //primary constructor
    public FailedDeploymentResult(
      [NotNull] string reason,
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
      if (reason == null) throw new ArgumentNullException("reason");
      
      Reason = reason;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<FailedDeploymentResult> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      var reason = reader.ReadString();
      return new FailedDeploymentResult(reason, status);
    };
    
    public static new CtxWriteDelegate<FailedDeploymentResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
      writer.Write(value.Reason);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FailedDeploymentResult) obj);
    }
    public bool Equals(FailedDeploymentResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Reason == other.Reason && Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Reason.GetHashCode();
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FailedDeploymentResult (");
      using (printer.IndentCookie()) {
        printer.Print("reason = "); Reason.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OutputMessage : IPrintable, IEquatable<OutputMessage>
  {
    //fields
    //public fields
    [NotNull] public string Message {get; private set;}
    public DeployMessageKind Kind {get; private set;}
    
    //private fields
    //primary constructor
    public OutputMessage(
      [NotNull] string message,
      DeployMessageKind kind
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      
      Message = message;
      Kind = kind;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<OutputMessage> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      var kind = (DeployMessageKind)reader.ReadInt();
      return new OutputMessage(message, kind);
    };
    
    public static CtxWriteDelegate<OutputMessage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
      writer.Write((int)value.Kind);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((OutputMessage) obj);
    }
    public bool Equals(OutputMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Message == other.Message && Kind == other.Kind;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Message.GetHashCode();
        hash = hash * 31 + (int) Kind;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("OutputMessage (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class UwpDeploymentArgs : DeploymentArgsBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public UwpDeploymentArgs(
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    ) : base (
      projectKind,
      projectFilePath
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<UwpDeploymentArgs> Read = (ctx, reader) => 
    {
      var projectKind = (RunnableProjectKind)reader.ReadInt();
      var projectFilePath = reader.ReadString();
      return new UwpDeploymentArgs(projectKind, projectFilePath);
    };
    
    public static new CtxWriteDelegate<UwpDeploymentArgs> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ProjectKind);
      writer.Write(value.ProjectFilePath);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((UwpDeploymentArgs) obj);
    }
    public bool Equals(UwpDeploymentArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectKind == other.ProjectKind && ProjectFilePath == other.ProjectFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) ProjectKind;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("UwpDeploymentArgs (");
      using (printer.IndentCookie()) {
        printer.Print("projectKind = "); ProjectKind.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class UwpDeploymentResult : DeploymentResultBase
  {
    //fields
    //public fields
    [NotNull] public string AppUserModelId {get; private set;}
    
    //private fields
    //primary constructor
    public UwpDeploymentResult(
      [NotNull] string appUserModelId,
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
      if (appUserModelId == null) throw new ArgumentNullException("appUserModelId");
      
      AppUserModelId = appUserModelId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<UwpDeploymentResult> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      var appUserModelId = reader.ReadString();
      return new UwpDeploymentResult(appUserModelId, status);
    };
    
    public static new CtxWriteDelegate<UwpDeploymentResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
      writer.Write(value.AppUserModelId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((UwpDeploymentResult) obj);
    }
    public bool Equals(UwpDeploymentResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AppUserModelId == other.AppUserModelId && Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AppUserModelId.GetHashCode();
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("UwpDeploymentResult (");
      using (printer.IndentCookie()) {
        printer.Print("appUserModelId = "); AppUserModelId.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinAndroidDeploymentArgs : DeploymentArgsBase
  {
    //fields
    //public fields
    public bool Debug {get; private set;}
    [NotNull] public string DeviceName {get; private set;}
    
    //private fields
    //primary constructor
    public XamarinAndroidDeploymentArgs(
      bool debug,
      [NotNull] string deviceName,
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    ) : base (
      projectKind,
      projectFilePath
     ) 
    {
      if (deviceName == null) throw new ArgumentNullException("deviceName");
      
      Debug = debug;
      DeviceName = deviceName;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinAndroidDeploymentArgs> Read = (ctx, reader) => 
    {
      var projectKind = (RunnableProjectKind)reader.ReadInt();
      var projectFilePath = reader.ReadString();
      var debug = reader.ReadBool();
      var deviceName = reader.ReadString();
      return new XamarinAndroidDeploymentArgs(debug, deviceName, projectKind, projectFilePath);
    };
    
    public static new CtxWriteDelegate<XamarinAndroidDeploymentArgs> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ProjectKind);
      writer.Write(value.ProjectFilePath);
      writer.Write(value.Debug);
      writer.Write(value.DeviceName);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinAndroidDeploymentArgs) obj);
    }
    public bool Equals(XamarinAndroidDeploymentArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Debug == other.Debug && DeviceName == other.DeviceName && ProjectKind == other.ProjectKind && ProjectFilePath == other.ProjectFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Debug.GetHashCode();
        hash = hash * 31 + DeviceName.GetHashCode();
        hash = hash * 31 + (int) ProjectKind;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinAndroidDeploymentArgs (");
      using (printer.IndentCookie()) {
        printer.Print("debug = "); Debug.PrintEx(printer); printer.Println();
        printer.Print("deviceName = "); DeviceName.PrintEx(printer); printer.Println();
        printer.Print("projectKind = "); ProjectKind.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinAndroidDeploymentResult : DeploymentResultBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public XamarinAndroidDeploymentResult(
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinAndroidDeploymentResult> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      return new XamarinAndroidDeploymentResult(status);
    };
    
    public static new CtxWriteDelegate<XamarinAndroidDeploymentResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinAndroidDeploymentResult) obj);
    }
    public bool Equals(XamarinAndroidDeploymentResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinAndroidDeploymentResult (");
      using (printer.IndentCookie()) {
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinIOSDeploymentArgs : DeploymentArgsBase
  {
    //fields
    //public fields
    [NotNull] public string Address {get; private set;}
    [NotNull] public string User {get; private set;}
    
    //private fields
    //primary constructor
    public XamarinIOSDeploymentArgs(
      [NotNull] string address,
      [NotNull] string user,
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    ) : base (
      projectKind,
      projectFilePath
     ) 
    {
      if (address == null) throw new ArgumentNullException("address");
      if (user == null) throw new ArgumentNullException("user");
      
      Address = address;
      User = user;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinIOSDeploymentArgs> Read = (ctx, reader) => 
    {
      var projectKind = (RunnableProjectKind)reader.ReadInt();
      var projectFilePath = reader.ReadString();
      var address = reader.ReadString();
      var user = reader.ReadString();
      return new XamarinIOSDeploymentArgs(address, user, projectKind, projectFilePath);
    };
    
    public static new CtxWriteDelegate<XamarinIOSDeploymentArgs> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ProjectKind);
      writer.Write(value.ProjectFilePath);
      writer.Write(value.Address);
      writer.Write(value.User);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinIOSDeploymentArgs) obj);
    }
    public bool Equals(XamarinIOSDeploymentArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Address == other.Address && User == other.User && ProjectKind == other.ProjectKind && ProjectFilePath == other.ProjectFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Address.GetHashCode();
        hash = hash * 31 + User.GetHashCode();
        hash = hash * 31 + (int) ProjectKind;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinIOSDeploymentArgs (");
      using (printer.IndentCookie()) {
        printer.Print("address = "); Address.PrintEx(printer); printer.Println();
        printer.Print("user = "); User.PrintEx(printer); printer.Println();
        printer.Print("projectKind = "); ProjectKind.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinIOSDeploymentResult : DeploymentResultBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public XamarinIOSDeploymentResult(
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinIOSDeploymentResult> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      return new XamarinIOSDeploymentResult(status);
    };
    
    public static new CtxWriteDelegate<XamarinIOSDeploymentResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinIOSDeploymentResult) obj);
    }
    public bool Equals(XamarinIOSDeploymentResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinIOSDeploymentResult (");
      using (printer.IndentCookie()) {
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
