using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DotTraceHost : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableList<OpenedSnapshot> OpenedSnapshots { get { return _OpenedSnapshots; }}
    [NotNull] public IRdProperty<string> OpenedSnapshotPath { get { return _OpenedSnapshotPath; }}
    [NotNull] public ISink<string> CloseSnapshotByPathRequest { get { return _CloseSnapshotByPathRequest; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.SnapshotsView> SnapshotsView { get { return _SnapshotsView; }}
    [NotNull] public RdEndpoint<RdVoid, List<RdProfilingCore>> UpdateProcessesListRequest { get { return _UpdateProcessesListRequest; }}
    [NotNull] public ISink<DotTraceAttachRequest> AttachRequest { get { return _AttachRequest; }}
    [NotNull] public IRdProperty<DotTraceProfilingConfiguration> ProfilingConfiguration { get { return _ProfilingConfiguration; }}
    [NotNull] public IRdProperty<string> CoreLogOptions { get { return _CoreLogOptions; }}
    [NotNull] public ISink<DotTraceProfileRequest> ProfileRequest { get { return _ProfileRequest; }}
    [NotNull] public IRdProperty<bool> CanStartProfiling { get { return _CanStartProfiling; }}
    [NotNull] public IRdProperty<DotTraceActiveSession> ActiveSession { get { return _ActiveSession; }}
    [NotNull] public ISource<bool> ActivateToolWindow { get { return _ActivateToolWindow; }}
    [NotNull] public IRdProperty<bool> DisableProfiling { get { return _DisableProfiling; }}
    
    //private fields
    [NotNull] private readonly RdList<OpenedSnapshot> _OpenedSnapshots;
    [NotNull] private readonly RdProperty<string> _OpenedSnapshotPath;
    [NotNull] private readonly RdSignal<string> _CloseSnapshotByPathRequest;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.SnapshotsView> _SnapshotsView;
    [NotNull] private readonly RdEndpoint<RdVoid, List<RdProfilingCore>> _UpdateProcessesListRequest;
    [NotNull] private readonly RdSignal<DotTraceAttachRequest> _AttachRequest;
    [NotNull] private readonly RdProperty<DotTraceProfilingConfiguration> _ProfilingConfiguration;
    [NotNull] private readonly RdProperty<string> _CoreLogOptions;
    [NotNull] private readonly RdSignal<DotTraceProfileRequest> _ProfileRequest;
    [NotNull] private readonly RdProperty<bool> _CanStartProfiling;
    [NotNull] private readonly RdProperty<DotTraceActiveSession> _ActiveSession;
    [NotNull] private readonly RdSignal<bool> _ActivateToolWindow;
    [NotNull] private readonly RdProperty<bool> _DisableProfiling;
    
    //primary constructor
    private DotTraceHost(
      [NotNull] RdList<OpenedSnapshot> openedSnapshots,
      [NotNull] RdProperty<string> openedSnapshotPath,
      [NotNull] RdSignal<string> closeSnapshotByPathRequest,
      [NotNull] RdProperty<JetBrains.Rider.Model.SnapshotsView> snapshotsView,
      [NotNull] RdEndpoint<RdVoid, List<RdProfilingCore>> updateProcessesListRequest,
      [NotNull] RdSignal<DotTraceAttachRequest> attachRequest,
      [NotNull] RdProperty<DotTraceProfilingConfiguration> profilingConfiguration,
      [NotNull] RdProperty<string> coreLogOptions,
      [NotNull] RdSignal<DotTraceProfileRequest> profileRequest,
      [NotNull] RdProperty<bool> canStartProfiling,
      [NotNull] RdProperty<DotTraceActiveSession> activeSession,
      [NotNull] RdSignal<bool> activateToolWindow,
      [NotNull] RdProperty<bool> disableProfiling
    )
    {
      if (openedSnapshots == null) throw new ArgumentNullException("openedSnapshots");
      if (openedSnapshotPath == null) throw new ArgumentNullException("openedSnapshotPath");
      if (closeSnapshotByPathRequest == null) throw new ArgumentNullException("closeSnapshotByPathRequest");
      if (snapshotsView == null) throw new ArgumentNullException("snapshotsView");
      if (updateProcessesListRequest == null) throw new ArgumentNullException("updateProcessesListRequest");
      if (attachRequest == null) throw new ArgumentNullException("attachRequest");
      if (profilingConfiguration == null) throw new ArgumentNullException("profilingConfiguration");
      if (coreLogOptions == null) throw new ArgumentNullException("coreLogOptions");
      if (profileRequest == null) throw new ArgumentNullException("profileRequest");
      if (canStartProfiling == null) throw new ArgumentNullException("canStartProfiling");
      if (activeSession == null) throw new ArgumentNullException("activeSession");
      if (activateToolWindow == null) throw new ArgumentNullException("activateToolWindow");
      if (disableProfiling == null) throw new ArgumentNullException("disableProfiling");
      
      _OpenedSnapshots = openedSnapshots;
      _OpenedSnapshotPath = openedSnapshotPath;
      _CloseSnapshotByPathRequest = closeSnapshotByPathRequest;
      _SnapshotsView = snapshotsView;
      _UpdateProcessesListRequest = updateProcessesListRequest;
      _AttachRequest = attachRequest;
      _ProfilingConfiguration = profilingConfiguration;
      _CoreLogOptions = coreLogOptions;
      _ProfileRequest = profileRequest;
      _CanStartProfiling = canStartProfiling;
      _ActiveSession = activeSession;
      _ActivateToolWindow = activateToolWindow;
      _DisableProfiling = disableProfiling;
      _OpenedSnapshotPath.OptimizeNested = true;
      _ProfilingConfiguration.OptimizeNested = true;
      _CoreLogOptions.OptimizeNested = true;
      _CanStartProfiling.OptimizeNested = true;
      _DisableProfiling.OptimizeNested = true;
      _UpdateProcessesListRequest.Async = true;
      _OpenedSnapshotPath.ValueCanBeNull = true;
      _ProfilingConfiguration.ValueCanBeNull = true;
      _ActiveSession.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("openedSnapshots", _OpenedSnapshots));
      BindableChildren.Add(new KeyValuePair<string, object>("openedSnapshotPath", _OpenedSnapshotPath));
      BindableChildren.Add(new KeyValuePair<string, object>("closeSnapshotByPathRequest", _CloseSnapshotByPathRequest));
      BindableChildren.Add(new KeyValuePair<string, object>("snapshotsView", _SnapshotsView));
      BindableChildren.Add(new KeyValuePair<string, object>("updateProcessesListRequest", _UpdateProcessesListRequest));
      BindableChildren.Add(new KeyValuePair<string, object>("attachRequest", _AttachRequest));
      BindableChildren.Add(new KeyValuePair<string, object>("profilingConfiguration", _ProfilingConfiguration));
      BindableChildren.Add(new KeyValuePair<string, object>("coreLogOptions", _CoreLogOptions));
      BindableChildren.Add(new KeyValuePair<string, object>("profileRequest", _ProfileRequest));
      BindableChildren.Add(new KeyValuePair<string, object>("canStartProfiling", _CanStartProfiling));
      BindableChildren.Add(new KeyValuePair<string, object>("activeSession", _ActiveSession));
      BindableChildren.Add(new KeyValuePair<string, object>("activateToolWindow", _ActivateToolWindow));
      BindableChildren.Add(new KeyValuePair<string, object>("disableProfiling", _DisableProfiling));
    }
    //secondary constructor
    internal DotTraceHost (
    ) : this (
      new RdList<OpenedSnapshot>(OpenedSnapshot.Read, OpenedSnapshot.Write),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<JetBrains.Rider.Model.SnapshotsView>(JetBrains.Rider.Model.SnapshotsView.Read, JetBrains.Rider.Model.SnapshotsView.Write),
      new RdEndpoint<RdVoid, List<RdProfilingCore>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadRdProfilingCoreList, WriteRdProfilingCoreList),
      new RdSignal<DotTraceAttachRequest>(DotTraceAttachRequest.Read, DotTraceAttachRequest.Write),
      new RdProperty<DotTraceProfilingConfiguration>(ReadDotTraceProfilingConfigurationNullable, WriteDotTraceProfilingConfigurationNullable),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<DotTraceProfileRequest>(DotTraceProfileRequest.Read, DotTraceProfileRequest.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<DotTraceActiveSession>(ReadDotTraceActiveSessionNullable, WriteDotTraceActiveSessionNullable),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdProfilingCore>> ReadRdProfilingCoreList = RdProfilingCore.Read.List();
    public static CtxReadDelegate<DotTraceProfilingConfiguration> ReadDotTraceProfilingConfigurationNullable = DotTraceProfilingConfiguration.Read.NullableClass();
    public static CtxReadDelegate<DotTraceActiveSession> ReadDotTraceActiveSessionNullable = DotTraceActiveSession.Read.NullableClass();
    
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdProfilingCore>> WriteRdProfilingCoreList = RdProfilingCore.Write.List();
    public static CtxWriteDelegate<DotTraceProfilingConfiguration> WriteDotTraceProfilingConfigurationNullable = DotTraceProfilingConfiguration.Write.NullableClass();
    public static CtxWriteDelegate<DotTraceActiveSession> WriteDotTraceActiveSessionNullable = DotTraceActiveSession.Write.NullableClass();
    
    protected override long SerializationHash => -1931976442910487652L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(DotTraceSnapshotListItem.Read, DotTraceSnapshotListItem.Write);
      serializers.Register(ControllerResourcesHost.Read, ControllerResourcesHost.Write);
      serializers.RegisterEnum<ProfilerCoreCommand>();
      serializers.Register(RdSnapshotCreated.Read, RdSnapshotCreated.Write);
      serializers.Register(RdSnapshotInProcessItem.Read, RdSnapshotInProcessItem.Write);
      serializers.Register(RdSnapshotDone.Read, RdSnapshotDone.Write);
      serializers.Register(RdSnapshotRemoved.Read, RdSnapshotRemoved.Write);
      serializers.Register(RdProfilingCore.Read, RdProfilingCore.Write);
      serializers.Register(DotTraceAttachRequest.Read, DotTraceAttachRequest.Write);
      serializers.Register(DotTraceProfilingConfiguration.Read, DotTraceProfilingConfiguration.Write);
      serializers.Register(BeSnapshot.Read, BeSnapshot.Write);
      serializers.Register(BeProcessing.Read, BeProcessing.Write);
      serializers.Register(OpenedSnapshot.Read, OpenedSnapshot.Write);
      serializers.Register(BeProgressBar.Read, BeProgressBar.Write);
      serializers.Register(ProjectProperties.Read, ProjectProperties.Write);
      serializers.Register(JetBrains.Rider.Model.SnapshotsView.Read, JetBrains.Rider.Model.SnapshotsView.Write);
      serializers.Register(BeBorder.Read, BeBorder.Write);
      serializers.Register(FilterButton.Read, FilterButton.Write);
      serializers.Register(EnumFilterButton.Read, EnumFilterButton.Write);
      serializers.Register(DotTraceProfileRequest.Read, DotTraceProfileRequest.Write);
      serializers.Register(DotTraceActiveSession.Read, DotTraceActiveSession.Write);
      serializers.RegisterEnum<MeasureType>();
      serializers.RegisterEnum<MeterKind>();
      serializers.Register(OnClick.Read, OnClick.Write);
      serializers.Register(AppliedValue.Read, AppliedValue.Write);
      serializers.Register(CommandDef.Read, CommandDef.Write);
      serializers.Register(CoreSelectedPid.Read, CoreSelectedPid.Write);
      serializers.Register(RdDotTraceOperationsState.Read, RdDotTraceOperationsState.Write);
      serializers.Register(RdDotTraceCoreRemovedState.Read, RdDotTraceCoreRemovedState.Write);
      serializers.Register(RdDotTraceMessage.Read, RdDotTraceMessage.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceHost (");
      using (printer.IndentCookie()) {
        printer.Print("openedSnapshots = "); _OpenedSnapshots.PrintEx(printer); printer.Println();
        printer.Print("openedSnapshotPath = "); _OpenedSnapshotPath.PrintEx(printer); printer.Println();
        printer.Print("closeSnapshotByPathRequest = "); _CloseSnapshotByPathRequest.PrintEx(printer); printer.Println();
        printer.Print("snapshotsView = "); _SnapshotsView.PrintEx(printer); printer.Println();
        printer.Print("updateProcessesListRequest = "); _UpdateProcessesListRequest.PrintEx(printer); printer.Println();
        printer.Print("attachRequest = "); _AttachRequest.PrintEx(printer); printer.Println();
        printer.Print("profilingConfiguration = "); _ProfilingConfiguration.PrintEx(printer); printer.Println();
        printer.Print("coreLogOptions = "); _CoreLogOptions.PrintEx(printer); printer.Println();
        printer.Print("profileRequest = "); _ProfileRequest.PrintEx(printer); printer.Println();
        printer.Print("canStartProfiling = "); _CanStartProfiling.PrintEx(printer); printer.Println();
        printer.Print("activeSession = "); _ActiveSession.PrintEx(printer); printer.Println();
        printer.Print("activateToolWindow = "); _ActivateToolWindow.PrintEx(printer); printer.Println();
        printer.Print("disableProfiling = "); _DisableProfiling.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDotTraceHostEx
   {
    public static DotTraceHost GetDotTraceHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("dotTraceHost", () => new DotTraceHost());
    }
  }
  
  
  public class AppliedValue : IPrintable, IEquatable<AppliedValue>
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public bool IsBold {get; private set;}
    public bool IsEnabled {get; private set;}
    
    //private fields
    //primary constructor
    public AppliedValue(
      [NotNull] string text,
      bool isBold,
      bool isEnabled
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      IsBold = isBold;
      IsEnabled = isEnabled;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AppliedValue> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var isBold = reader.ReadBool();
      var isEnabled = reader.ReadBool();
      return new AppliedValue(text, isBold, isEnabled);
    };
    
    public static CtxWriteDelegate<AppliedValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.IsBold);
      writer.Write(value.IsEnabled);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AppliedValue) obj);
    }
    public bool Equals(AppliedValue other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && IsBold == other.IsBold && IsEnabled == other.IsEnabled;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + IsBold.GetHashCode();
        hash = hash * 31 + IsEnabled.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AppliedValue (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isBold = "); IsBold.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeBorder : JetBrains.Rider.Model.UIAutomation.BeControl
  {
    //fields
    //public fields
    public JetBrains.Rider.Model.UIAutomation.BeShowBorders ShowBorders {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> Content { get { return _Content; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> _Content;
    
    //primary constructor
    private BeBorder(
      JetBrains.Rider.Model.UIAutomation.BeShowBorders showBorders,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> content,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      
      ShowBorders = showBorders;
      _Content = content;
      _Content.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
    }
    //secondary constructor
    public BeBorder (
      JetBrains.Rider.Model.UIAutomation.BeShowBorders showBorders = JetBrains.Rider.Model.UIAutomation.BeShowBorders.All
    ) : this (
      showBorders,
      new RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl>(ReadBeControlNullable, WriteBeControlNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeBorder> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var showBorders = (JetBrains.Rider.Model.UIAutomation.BeShowBorders)reader.ReadInt();
      var content = RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl>.Read(ctx, reader, ReadBeControlNullable, WriteBeControlNullable);
      return new BeBorder(showBorders, content, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.BeControl> ReadBeControlNullable = JetBrains.Rider.Model.UIAutomation.BeControl.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<BeBorder> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      writer.Write((int)value.ShowBorders);
      RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl>.Write(ctx, writer, value._Content);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.BeControl> WriteBeControlNullable = JetBrains.Rider.Model.UIAutomation.BeControl.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeBorder (");
      using (printer.IndentCookie()) {
        printer.Print("showBorders = "); ShowBorders.PrintEx(printer); printer.Println();
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeProcessing : JetBrains.Rider.Model.UIAutomation.BeControl
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.UIAutomation.BeControl Toolbar {get; private set;}
    [NotNull] public JetBrains.Rider.Model.UIAutomation.BeControl View {get; private set;}
    
    //private fields
    //primary constructor
    private BeProcessing(
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl toolbar,
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl view,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (toolbar == null) throw new ArgumentNullException("toolbar");
      if (view == null) throw new ArgumentNullException("view");
      
      Toolbar = toolbar;
      View = view;
      BindableChildren.Add(new KeyValuePair<string, object>("toolbar", Toolbar));
      BindableChildren.Add(new KeyValuePair<string, object>("view", View));
    }
    //secondary constructor
    public BeProcessing (
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl toolbar,
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl view
    ) : this (
      toolbar,
      view,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeProcessing> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var toolbar = JetBrains.Rider.Model.UIAutomation.BeControl.Read(ctx, reader);
      var view = JetBrains.Rider.Model.UIAutomation.BeControl.Read(ctx, reader);
      return new BeProcessing(toolbar, view, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<BeProcessing> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      JetBrains.Rider.Model.UIAutomation.BeControl.Write(ctx, writer, value.Toolbar);
      JetBrains.Rider.Model.UIAutomation.BeControl.Write(ctx, writer, value.View);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeProcessing (");
      using (printer.IndentCookie()) {
        printer.Print("toolbar = "); Toolbar.PrintEx(printer); printer.Println();
        printer.Print("view = "); View.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeProgressBar : JetBrains.Rider.Model.UIAutomation.BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<double> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<double> _Value;
    
    //primary constructor
    private BeProgressBar(
      [NotNull] RdProperty<double> value,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public BeProgressBar (
    ) : this (
      new RdProperty<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeProgressBar> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var value = RdProperty<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      return new BeProgressBar(value, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<BeProgressBar> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<double>.Write(ctx, writer, value._Value);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeProgressBar (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSnapshot : JetBrains.Rider.Model.UIAutomation.BeControl
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.UIAutomation.BeControl TopMethodsView {get; private set;}
    [NotNull] public JetBrains.Rider.Model.UIAutomation.BeControl CallTreeView {get; private set;}
    [NotNull] public JetBrains.Rider.Model.UIAutomation.BeControl FiltersPanel {get; private set;}
    
    //private fields
    //primary constructor
    private BeSnapshot(
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl topMethodsView,
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl callTreeView,
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl filtersPanel,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (topMethodsView == null) throw new ArgumentNullException("topMethodsView");
      if (callTreeView == null) throw new ArgumentNullException("callTreeView");
      if (filtersPanel == null) throw new ArgumentNullException("filtersPanel");
      
      TopMethodsView = topMethodsView;
      CallTreeView = callTreeView;
      FiltersPanel = filtersPanel;
      BindableChildren.Add(new KeyValuePair<string, object>("topMethodsView", TopMethodsView));
      BindableChildren.Add(new KeyValuePair<string, object>("callTreeView", CallTreeView));
      BindableChildren.Add(new KeyValuePair<string, object>("filtersPanel", FiltersPanel));
    }
    //secondary constructor
    public BeSnapshot (
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl topMethodsView,
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl callTreeView,
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl filtersPanel
    ) : this (
      topMethodsView,
      callTreeView,
      filtersPanel,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSnapshot> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var topMethodsView = JetBrains.Rider.Model.UIAutomation.BeControl.Read(ctx, reader);
      var callTreeView = JetBrains.Rider.Model.UIAutomation.BeControl.Read(ctx, reader);
      var filtersPanel = JetBrains.Rider.Model.UIAutomation.BeControl.Read(ctx, reader);
      return new BeSnapshot(topMethodsView, callTreeView, filtersPanel, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSnapshot> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      JetBrains.Rider.Model.UIAutomation.BeControl.Write(ctx, writer, value.TopMethodsView);
      JetBrains.Rider.Model.UIAutomation.BeControl.Write(ctx, writer, value.CallTreeView);
      JetBrains.Rider.Model.UIAutomation.BeControl.Write(ctx, writer, value.FiltersPanel);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSnapshot (");
      using (printer.IndentCookie()) {
        printer.Print("topMethodsView = "); TopMethodsView.PrintEx(printer); printer.Println();
        printer.Print("callTreeView = "); CallTreeView.PrintEx(printer); printer.Println();
        printer.Print("filtersPanel = "); FiltersPanel.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CommandDef : IPrintable, IEquatable<CommandDef>
  {
    //fields
    //public fields
    public ProfilerCoreCommand Command {get; private set;}
    [NotNull] public string CoreId {get; private set;}
    
    //private fields
    //primary constructor
    public CommandDef(
      ProfilerCoreCommand command,
      [NotNull] string coreId
    )
    {
      if (coreId == null) throw new ArgumentNullException("coreId");
      
      Command = command;
      CoreId = coreId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CommandDef> Read = (ctx, reader) => 
    {
      var command = (ProfilerCoreCommand)reader.ReadInt();
      var coreId = reader.ReadString();
      return new CommandDef(command, coreId);
    };
    
    public static CtxWriteDelegate<CommandDef> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Command);
      writer.Write(value.CoreId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CommandDef) obj);
    }
    public bool Equals(CommandDef other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Command == other.Command && CoreId == other.CoreId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Command;
        hash = hash * 31 + CoreId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CommandDef (");
      using (printer.IndentCookie()) {
        printer.Print("command = "); Command.PrintEx(printer); printer.Println();
        printer.Print("coreId = "); CoreId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ControllerResourcesHost : IPrintable, IEquatable<ControllerResourcesHost>
  {
    //fields
    //public fields
    [CanBeNull] public Icon StartIcon {get; private set;}
    [CanBeNull] public Icon GetIcon {get; private set;}
    [CanBeNull] public Icon SplitIcon {get; private set;}
    [CanBeNull] public Icon DropIcon {get; private set;}
    [CanBeNull] public Icon RestartIcon {get; private set;}
    [CanBeNull] public Icon DetachIcon {get; private set;}
    [CanBeNull] public Icon KillIcon {get; private set;}
    [CanBeNull] public Icon InactiveProcessIcon {get; private set;}
    [NotNull] public string WatingForText {get; private set;}
    
    //private fields
    //primary constructor
    public ControllerResourcesHost(
      [CanBeNull] Icon startIcon,
      [CanBeNull] Icon getIcon,
      [CanBeNull] Icon splitIcon,
      [CanBeNull] Icon dropIcon,
      [CanBeNull] Icon restartIcon,
      [CanBeNull] Icon detachIcon,
      [CanBeNull] Icon killIcon,
      [CanBeNull] Icon inactiveProcessIcon,
      [NotNull] string watingForText
    )
    {
      if (watingForText == null) throw new ArgumentNullException("watingForText");
      
      StartIcon = startIcon;
      GetIcon = getIcon;
      SplitIcon = splitIcon;
      DropIcon = dropIcon;
      RestartIcon = restartIcon;
      DetachIcon = detachIcon;
      KillIcon = killIcon;
      InactiveProcessIcon = inactiveProcessIcon;
      WatingForText = watingForText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ControllerResourcesHost> Read = (ctx, reader) => 
    {
      var startIcon = ReadIconNullable(ctx, reader);
      var getIcon = ReadIconNullable(ctx, reader);
      var splitIcon = ReadIconNullable(ctx, reader);
      var dropIcon = ReadIconNullable(ctx, reader);
      var restartIcon = ReadIconNullable(ctx, reader);
      var detachIcon = ReadIconNullable(ctx, reader);
      var killIcon = ReadIconNullable(ctx, reader);
      var inactiveProcessIcon = ReadIconNullable(ctx, reader);
      var watingForText = reader.ReadString();
      return new ControllerResourcesHost(startIcon, getIcon, splitIcon, dropIcon, restartIcon, detachIcon, killIcon, inactiveProcessIcon, watingForText);
    };
    public static CtxReadDelegate<Icon> ReadIconNullable = Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<ControllerResourcesHost> Write = (ctx, writer, value) => 
    {
      WriteIconNullable(ctx, writer, value.StartIcon);
      WriteIconNullable(ctx, writer, value.GetIcon);
      WriteIconNullable(ctx, writer, value.SplitIcon);
      WriteIconNullable(ctx, writer, value.DropIcon);
      WriteIconNullable(ctx, writer, value.RestartIcon);
      WriteIconNullable(ctx, writer, value.DetachIcon);
      WriteIconNullable(ctx, writer, value.KillIcon);
      WriteIconNullable(ctx, writer, value.InactiveProcessIcon);
      writer.Write(value.WatingForText);
    };
    public static CtxWriteDelegate<Icon> WriteIconNullable = Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ControllerResourcesHost) obj);
    }
    public bool Equals(ControllerResourcesHost other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(StartIcon, other.StartIcon) && Equals(GetIcon, other.GetIcon) && Equals(SplitIcon, other.SplitIcon) && Equals(DropIcon, other.DropIcon) && Equals(RestartIcon, other.RestartIcon) && Equals(DetachIcon, other.DetachIcon) && Equals(KillIcon, other.KillIcon) && Equals(InactiveProcessIcon, other.InactiveProcessIcon) && WatingForText == other.WatingForText;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (StartIcon != null ?StartIcon.GetHashCode() : 0);
        hash = hash * 31 + (GetIcon != null ?GetIcon.GetHashCode() : 0);
        hash = hash * 31 + (SplitIcon != null ?SplitIcon.GetHashCode() : 0);
        hash = hash * 31 + (DropIcon != null ?DropIcon.GetHashCode() : 0);
        hash = hash * 31 + (RestartIcon != null ?RestartIcon.GetHashCode() : 0);
        hash = hash * 31 + (DetachIcon != null ?DetachIcon.GetHashCode() : 0);
        hash = hash * 31 + (KillIcon != null ?KillIcon.GetHashCode() : 0);
        hash = hash * 31 + (InactiveProcessIcon != null ?InactiveProcessIcon.GetHashCode() : 0);
        hash = hash * 31 + WatingForText.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ControllerResourcesHost (");
      using (printer.IndentCookie()) {
        printer.Print("startIcon = "); StartIcon.PrintEx(printer); printer.Println();
        printer.Print("getIcon = "); GetIcon.PrintEx(printer); printer.Println();
        printer.Print("splitIcon = "); SplitIcon.PrintEx(printer); printer.Println();
        printer.Print("dropIcon = "); DropIcon.PrintEx(printer); printer.Println();
        printer.Print("restartIcon = "); RestartIcon.PrintEx(printer); printer.Println();
        printer.Print("detachIcon = "); DetachIcon.PrintEx(printer); printer.Println();
        printer.Print("killIcon = "); KillIcon.PrintEx(printer); printer.Println();
        printer.Print("inactiveProcessIcon = "); InactiveProcessIcon.PrintEx(printer); printer.Println();
        printer.Print("watingForText = "); WatingForText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CoreSelectedPid : IPrintable, IEquatable<CoreSelectedPid>
  {
    //fields
    //public fields
    public int Pid {get; private set;}
    
    //private fields
    //primary constructor
    public CoreSelectedPid(
      int pid
    )
    {
      Pid = pid;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CoreSelectedPid> Read = (ctx, reader) => 
    {
      var pid = reader.ReadInt();
      return new CoreSelectedPid(pid);
    };
    
    public static CtxWriteDelegate<CoreSelectedPid> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Pid);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CoreSelectedPid) obj);
    }
    public bool Equals(CoreSelectedPid other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Pid == other.Pid;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Pid.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CoreSelectedPid (");
      using (printer.IndentCookie()) {
        printer.Print("pid = "); Pid.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceActiveSession : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public ISink<ProfilerCoreCommand> SessionCommand { get { return _SessionCommand; }}
    [NotNull] public ISink<CommandDef> CoreCommand { get { return _CoreCommand; }}
    [NotNull] public RdEndpoint<RdVoid, RdVoid> TerminateSession { get { return _TerminateSession; }}
    [NotNull] public ISource<bool> SessionIsFinished { get { return _SessionIsFinished; }}
    [NotNull] public ControllerResourcesHost ResourcesHost {get; private set;}
    [NotNull] public ISink<CoreSelectedPid> CoreSelected { get { return _CoreSelected; }}
    [NotNull] public ISource<RdDotTraceOperationsState> CoreStateChanged { get { return _CoreStateChanged; }}
    [NotNull] public ISource<RdProfilingCore> CoreAdded { get { return _CoreAdded; }}
    [NotNull] public ISource<RdDotTraceCoreRemovedState> CoreRemoved { get { return _CoreRemoved; }}
    [NotNull] public ISource<RdSnapshotCreated> SnapshotCreated { get { return _SnapshotCreated; }}
    [NotNull] public ISource<RdSnapshotInProcessItem> SnapshotStatusChanged { get { return _SnapshotStatusChanged; }}
    [NotNull] public ISource<RdSnapshotDone> SnapshotDone { get { return _SnapshotDone; }}
    [NotNull] public ISource<RdSnapshotRemoved> SnapshotRemoved { get { return _SnapshotRemoved; }}
    [NotNull] public IViewableList<string> ErrorMessages { get { return _ErrorMessages; }}
    [NotNull] public ISource<RdDotTraceMessage> CoreMessageReceived { get { return _CoreMessageReceived; }}
    [NotNull] public ISink<string> OpenSnapshot { get { return _OpenSnapshot; }}
    
    //private fields
    [NotNull] private readonly RdSignal<ProfilerCoreCommand> _SessionCommand;
    [NotNull] private readonly RdSignal<CommandDef> _CoreCommand;
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _TerminateSession;
    [NotNull] private readonly RdSignal<bool> _SessionIsFinished;
    [NotNull] private readonly RdSignal<CoreSelectedPid> _CoreSelected;
    [NotNull] private readonly RdSignal<RdDotTraceOperationsState> _CoreStateChanged;
    [NotNull] private readonly RdSignal<RdProfilingCore> _CoreAdded;
    [NotNull] private readonly RdSignal<RdDotTraceCoreRemovedState> _CoreRemoved;
    [NotNull] private readonly RdSignal<RdSnapshotCreated> _SnapshotCreated;
    [NotNull] private readonly RdSignal<RdSnapshotInProcessItem> _SnapshotStatusChanged;
    [NotNull] private readonly RdSignal<RdSnapshotDone> _SnapshotDone;
    [NotNull] private readonly RdSignal<RdSnapshotRemoved> _SnapshotRemoved;
    [NotNull] private readonly RdList<string> _ErrorMessages;
    [NotNull] private readonly RdSignal<RdDotTraceMessage> _CoreMessageReceived;
    [NotNull] private readonly RdSignal<string> _OpenSnapshot;
    
    //primary constructor
    private DotTraceActiveSession(
      [NotNull] RdSignal<ProfilerCoreCommand> sessionCommand,
      [NotNull] RdSignal<CommandDef> coreCommand,
      [NotNull] RdEndpoint<RdVoid, RdVoid> terminateSession,
      [NotNull] RdSignal<bool> sessionIsFinished,
      [NotNull] ControllerResourcesHost resourcesHost,
      [NotNull] RdSignal<CoreSelectedPid> coreSelected,
      [NotNull] RdSignal<RdDotTraceOperationsState> coreStateChanged,
      [NotNull] RdSignal<RdProfilingCore> coreAdded,
      [NotNull] RdSignal<RdDotTraceCoreRemovedState> coreRemoved,
      [NotNull] RdSignal<RdSnapshotCreated> snapshotCreated,
      [NotNull] RdSignal<RdSnapshotInProcessItem> snapshotStatusChanged,
      [NotNull] RdSignal<RdSnapshotDone> snapshotDone,
      [NotNull] RdSignal<RdSnapshotRemoved> snapshotRemoved,
      [NotNull] RdList<string> errorMessages,
      [NotNull] RdSignal<RdDotTraceMessage> coreMessageReceived,
      [NotNull] RdSignal<string> openSnapshot
    )
    {
      if (sessionCommand == null) throw new ArgumentNullException("sessionCommand");
      if (coreCommand == null) throw new ArgumentNullException("coreCommand");
      if (terminateSession == null) throw new ArgumentNullException("terminateSession");
      if (sessionIsFinished == null) throw new ArgumentNullException("sessionIsFinished");
      if (resourcesHost == null) throw new ArgumentNullException("resourcesHost");
      if (coreSelected == null) throw new ArgumentNullException("coreSelected");
      if (coreStateChanged == null) throw new ArgumentNullException("coreStateChanged");
      if (coreAdded == null) throw new ArgumentNullException("coreAdded");
      if (coreRemoved == null) throw new ArgumentNullException("coreRemoved");
      if (snapshotCreated == null) throw new ArgumentNullException("snapshotCreated");
      if (snapshotStatusChanged == null) throw new ArgumentNullException("snapshotStatusChanged");
      if (snapshotDone == null) throw new ArgumentNullException("snapshotDone");
      if (snapshotRemoved == null) throw new ArgumentNullException("snapshotRemoved");
      if (errorMessages == null) throw new ArgumentNullException("errorMessages");
      if (coreMessageReceived == null) throw new ArgumentNullException("coreMessageReceived");
      if (openSnapshot == null) throw new ArgumentNullException("openSnapshot");
      
      _SessionCommand = sessionCommand;
      _CoreCommand = coreCommand;
      _TerminateSession = terminateSession;
      _SessionIsFinished = sessionIsFinished;
      ResourcesHost = resourcesHost;
      _CoreSelected = coreSelected;
      _CoreStateChanged = coreStateChanged;
      _CoreAdded = coreAdded;
      _CoreRemoved = coreRemoved;
      _SnapshotCreated = snapshotCreated;
      _SnapshotStatusChanged = snapshotStatusChanged;
      _SnapshotDone = snapshotDone;
      _SnapshotRemoved = snapshotRemoved;
      _ErrorMessages = errorMessages;
      _CoreMessageReceived = coreMessageReceived;
      _OpenSnapshot = openSnapshot;
      _ErrorMessages.OptimizeNested = true;
      _TerminateSession.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("sessionCommand", _SessionCommand));
      BindableChildren.Add(new KeyValuePair<string, object>("coreCommand", _CoreCommand));
      BindableChildren.Add(new KeyValuePair<string, object>("terminateSession", _TerminateSession));
      BindableChildren.Add(new KeyValuePair<string, object>("sessionIsFinished", _SessionIsFinished));
      BindableChildren.Add(new KeyValuePair<string, object>("coreSelected", _CoreSelected));
      BindableChildren.Add(new KeyValuePair<string, object>("coreStateChanged", _CoreStateChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("coreAdded", _CoreAdded));
      BindableChildren.Add(new KeyValuePair<string, object>("coreRemoved", _CoreRemoved));
      BindableChildren.Add(new KeyValuePair<string, object>("snapshotCreated", _SnapshotCreated));
      BindableChildren.Add(new KeyValuePair<string, object>("snapshotStatusChanged", _SnapshotStatusChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("snapshotDone", _SnapshotDone));
      BindableChildren.Add(new KeyValuePair<string, object>("snapshotRemoved", _SnapshotRemoved));
      BindableChildren.Add(new KeyValuePair<string, object>("errorMessages", _ErrorMessages));
      BindableChildren.Add(new KeyValuePair<string, object>("coreMessageReceived", _CoreMessageReceived));
      BindableChildren.Add(new KeyValuePair<string, object>("openSnapshot", _OpenSnapshot));
    }
    //secondary constructor
    public DotTraceActiveSession (
      [NotNull] ControllerResourcesHost resourcesHost
    ) : this (
      new RdSignal<ProfilerCoreCommand>(ReadProfilerCoreCommand, WriteProfilerCoreCommand),
      new RdSignal<CommandDef>(CommandDef.Read, CommandDef.Write),
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      resourcesHost,
      new RdSignal<CoreSelectedPid>(CoreSelectedPid.Read, CoreSelectedPid.Write),
      new RdSignal<RdDotTraceOperationsState>(RdDotTraceOperationsState.Read, RdDotTraceOperationsState.Write),
      new RdSignal<RdProfilingCore>(RdProfilingCore.Read, RdProfilingCore.Write),
      new RdSignal<RdDotTraceCoreRemovedState>(RdDotTraceCoreRemovedState.Read, RdDotTraceCoreRemovedState.Write),
      new RdSignal<RdSnapshotCreated>(RdSnapshotCreated.Read, RdSnapshotCreated.Write),
      new RdSignal<RdSnapshotInProcessItem>(RdSnapshotInProcessItem.Read, RdSnapshotInProcessItem.Write),
      new RdSignal<RdSnapshotDone>(RdSnapshotDone.Read, RdSnapshotDone.Write),
      new RdSignal<RdSnapshotRemoved>(RdSnapshotRemoved.Read, RdSnapshotRemoved.Write),
      new RdList<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<RdDotTraceMessage>(RdDotTraceMessage.Read, RdDotTraceMessage.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<DotTraceActiveSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var sessionCommand = RdSignal<ProfilerCoreCommand>.Read(ctx, reader, ReadProfilerCoreCommand, WriteProfilerCoreCommand);
      var coreCommand = RdSignal<CommandDef>.Read(ctx, reader, CommandDef.Read, CommandDef.Write);
      var terminateSession = RdEndpoint<RdVoid, RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var sessionIsFinished = RdSignal<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var resourcesHost = ControllerResourcesHost.Read(ctx, reader);
      var coreSelected = RdSignal<CoreSelectedPid>.Read(ctx, reader, CoreSelectedPid.Read, CoreSelectedPid.Write);
      var coreStateChanged = RdSignal<RdDotTraceOperationsState>.Read(ctx, reader, RdDotTraceOperationsState.Read, RdDotTraceOperationsState.Write);
      var coreAdded = RdSignal<RdProfilingCore>.Read(ctx, reader, RdProfilingCore.Read, RdProfilingCore.Write);
      var coreRemoved = RdSignal<RdDotTraceCoreRemovedState>.Read(ctx, reader, RdDotTraceCoreRemovedState.Read, RdDotTraceCoreRemovedState.Write);
      var snapshotCreated = RdSignal<RdSnapshotCreated>.Read(ctx, reader, RdSnapshotCreated.Read, RdSnapshotCreated.Write);
      var snapshotStatusChanged = RdSignal<RdSnapshotInProcessItem>.Read(ctx, reader, RdSnapshotInProcessItem.Read, RdSnapshotInProcessItem.Write);
      var snapshotDone = RdSignal<RdSnapshotDone>.Read(ctx, reader, RdSnapshotDone.Read, RdSnapshotDone.Write);
      var snapshotRemoved = RdSignal<RdSnapshotRemoved>.Read(ctx, reader, RdSnapshotRemoved.Read, RdSnapshotRemoved.Write);
      var errorMessages = RdList<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var coreMessageReceived = RdSignal<RdDotTraceMessage>.Read(ctx, reader, RdDotTraceMessage.Read, RdDotTraceMessage.Write);
      var openSnapshot = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new DotTraceActiveSession(sessionCommand, coreCommand, terminateSession, sessionIsFinished, resourcesHost, coreSelected, coreStateChanged, coreAdded, coreRemoved, snapshotCreated, snapshotStatusChanged, snapshotDone, snapshotRemoved, errorMessages, coreMessageReceived, openSnapshot).WithId(_id);
    };
    public static CtxReadDelegate<ProfilerCoreCommand> ReadProfilerCoreCommand = new CtxReadDelegate<ProfilerCoreCommand>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ProfilerCoreCommand>);
    
    public static CtxWriteDelegate<DotTraceActiveSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<ProfilerCoreCommand>.Write(ctx, writer, value._SessionCommand);
      RdSignal<CommandDef>.Write(ctx, writer, value._CoreCommand);
      RdEndpoint<RdVoid, RdVoid>.Write(ctx, writer, value._TerminateSession);
      RdSignal<bool>.Write(ctx, writer, value._SessionIsFinished);
      ControllerResourcesHost.Write(ctx, writer, value.ResourcesHost);
      RdSignal<CoreSelectedPid>.Write(ctx, writer, value._CoreSelected);
      RdSignal<RdDotTraceOperationsState>.Write(ctx, writer, value._CoreStateChanged);
      RdSignal<RdProfilingCore>.Write(ctx, writer, value._CoreAdded);
      RdSignal<RdDotTraceCoreRemovedState>.Write(ctx, writer, value._CoreRemoved);
      RdSignal<RdSnapshotCreated>.Write(ctx, writer, value._SnapshotCreated);
      RdSignal<RdSnapshotInProcessItem>.Write(ctx, writer, value._SnapshotStatusChanged);
      RdSignal<RdSnapshotDone>.Write(ctx, writer, value._SnapshotDone);
      RdSignal<RdSnapshotRemoved>.Write(ctx, writer, value._SnapshotRemoved);
      RdList<string>.Write(ctx, writer, value._ErrorMessages);
      RdSignal<RdDotTraceMessage>.Write(ctx, writer, value._CoreMessageReceived);
      RdSignal<string>.Write(ctx, writer, value._OpenSnapshot);
    };
    public static CtxWriteDelegate<ProfilerCoreCommand> WriteProfilerCoreCommand = new CtxWriteDelegate<ProfilerCoreCommand>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ProfilerCoreCommand>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceActiveSession (");
      using (printer.IndentCookie()) {
        printer.Print("sessionCommand = "); _SessionCommand.PrintEx(printer); printer.Println();
        printer.Print("coreCommand = "); _CoreCommand.PrintEx(printer); printer.Println();
        printer.Print("terminateSession = "); _TerminateSession.PrintEx(printer); printer.Println();
        printer.Print("sessionIsFinished = "); _SessionIsFinished.PrintEx(printer); printer.Println();
        printer.Print("resourcesHost = "); ResourcesHost.PrintEx(printer); printer.Println();
        printer.Print("coreSelected = "); _CoreSelected.PrintEx(printer); printer.Println();
        printer.Print("coreStateChanged = "); _CoreStateChanged.PrintEx(printer); printer.Println();
        printer.Print("coreAdded = "); _CoreAdded.PrintEx(printer); printer.Println();
        printer.Print("coreRemoved = "); _CoreRemoved.PrintEx(printer); printer.Println();
        printer.Print("snapshotCreated = "); _SnapshotCreated.PrintEx(printer); printer.Println();
        printer.Print("snapshotStatusChanged = "); _SnapshotStatusChanged.PrintEx(printer); printer.Println();
        printer.Print("snapshotDone = "); _SnapshotDone.PrintEx(printer); printer.Println();
        printer.Print("snapshotRemoved = "); _SnapshotRemoved.PrintEx(printer); printer.Println();
        printer.Print("errorMessages = "); _ErrorMessages.PrintEx(printer); printer.Println();
        printer.Print("coreMessageReceived = "); _CoreMessageReceived.PrintEx(printer); printer.Println();
        printer.Print("openSnapshot = "); _OpenSnapshot.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceAttachRequest : IPrintable, IEquatable<DotTraceAttachRequest>
  {
    //fields
    //public fields
    public int Pid {get; private set;}
    [NotNull] public string Exe {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceAttachRequest(
      int pid,
      [NotNull] string exe
    )
    {
      if (exe == null) throw new ArgumentNullException("exe");
      
      Pid = pid;
      Exe = exe;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceAttachRequest> Read = (ctx, reader) => 
    {
      var pid = reader.ReadInt();
      var exe = reader.ReadString();
      return new DotTraceAttachRequest(pid, exe);
    };
    
    public static CtxWriteDelegate<DotTraceAttachRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Pid);
      writer.Write(value.Exe);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceAttachRequest) obj);
    }
    public bool Equals(DotTraceAttachRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Pid == other.Pid && Exe == other.Exe;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Pid.GetHashCode();
        hash = hash * 31 + Exe.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceAttachRequest (");
      using (printer.IndentCookie()) {
        printer.Print("pid = "); Pid.PrintEx(printer); printer.Println();
        printer.Print("exe = "); Exe.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceProfileRequest : IPrintable, IEquatable<DotTraceProfileRequest>
  {
    //fields
    //public fields
    [NotNull] public string Path {get; private set;}
    [NotNull] public string WorkDir {get; private set;}
    [NotNull] public string Arguments {get; private set;}
    public bool IsMonoRuntime {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.ProjectProperties ProjectProperties {get; private set;}
    [NotNull] public List<EnvironmentVariable> EnvironmentVariables {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceProfileRequest(
      [NotNull] string path,
      [NotNull] string workDir,
      [NotNull] string arguments,
      bool isMonoRuntime,
      [CanBeNull] JetBrains.Rider.Model.ProjectProperties projectProperties,
      [NotNull] List<EnvironmentVariable> environmentVariables
    )
    {
      if (path == null) throw new ArgumentNullException("path");
      if (workDir == null) throw new ArgumentNullException("workDir");
      if (arguments == null) throw new ArgumentNullException("arguments");
      if (environmentVariables == null) throw new ArgumentNullException("environmentVariables");
      
      Path = path;
      WorkDir = workDir;
      Arguments = arguments;
      IsMonoRuntime = isMonoRuntime;
      ProjectProperties = projectProperties;
      EnvironmentVariables = environmentVariables;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceProfileRequest> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      var workDir = reader.ReadString();
      var arguments = reader.ReadString();
      var isMonoRuntime = reader.ReadBool();
      var projectProperties = ReadProjectPropertiesNullable(ctx, reader);
      var environmentVariables = ReadEnvironmentVariableList(ctx, reader);
      return new DotTraceProfileRequest(path, workDir, arguments, isMonoRuntime, projectProperties, environmentVariables);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.ProjectProperties> ReadProjectPropertiesNullable = JetBrains.Rider.Model.ProjectProperties.Read.NullableClass();
    public static CtxReadDelegate<List<EnvironmentVariable>> ReadEnvironmentVariableList = EnvironmentVariable.Read.List();
    
    public static CtxWriteDelegate<DotTraceProfileRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
      writer.Write(value.WorkDir);
      writer.Write(value.Arguments);
      writer.Write(value.IsMonoRuntime);
      WriteProjectPropertiesNullable(ctx, writer, value.ProjectProperties);
      WriteEnvironmentVariableList(ctx, writer, value.EnvironmentVariables);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.ProjectProperties> WriteProjectPropertiesNullable = JetBrains.Rider.Model.ProjectProperties.Write.NullableClass();
    public static CtxWriteDelegate<List<EnvironmentVariable>> WriteEnvironmentVariableList = EnvironmentVariable.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceProfileRequest) obj);
    }
    public bool Equals(DotTraceProfileRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Path == other.Path && WorkDir == other.WorkDir && Arguments == other.Arguments && IsMonoRuntime == other.IsMonoRuntime && Equals(ProjectProperties, other.ProjectProperties) && EnvironmentVariables.SequenceEqual(other.EnvironmentVariables);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Path.GetHashCode();
        hash = hash * 31 + WorkDir.GetHashCode();
        hash = hash * 31 + Arguments.GetHashCode();
        hash = hash * 31 + IsMonoRuntime.GetHashCode();
        hash = hash * 31 + (ProjectProperties != null ?ProjectProperties.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(EnvironmentVariables);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceProfileRequest (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("workDir = "); WorkDir.PrintEx(printer); printer.Println();
        printer.Print("arguments = "); Arguments.PrintEx(printer); printer.Println();
        printer.Print("isMonoRuntime = "); IsMonoRuntime.PrintEx(printer); printer.Println();
        printer.Print("projectProperties = "); ProjectProperties.PrintEx(printer); printer.Println();
        printer.Print("environmentVariables = "); EnvironmentVariables.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceProfilingConfiguration : IPrintable, IEquatable<DotTraceProfilingConfiguration>
  {
    //fields
    //public fields
    public JetBrains.Rider.Model.MeasureType MeasureType {get; private set;}
    public JetBrains.Rider.Model.MeterKind MeterKind {get; private set;}
    public bool StartImmediately {get; private set;}
    public bool ProfileChildProcesses {get; private set;}
    public bool ReuseSameNameThreads {get; private set;}
    public bool PrecisionMode {get; private set;}
    public bool EnableJitInlining {get; private set;}
    public bool EnableNativeAllocations {get; private set;}
    public bool EnableDebugOutput {get; private set;}
    public bool EnableTpl {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceProfilingConfiguration(
      JetBrains.Rider.Model.MeasureType measureType,
      JetBrains.Rider.Model.MeterKind meterKind,
      bool startImmediately,
      bool profileChildProcesses,
      bool reuseSameNameThreads,
      bool precisionMode,
      bool enableJitInlining,
      bool enableNativeAllocations,
      bool enableDebugOutput,
      bool enableTpl
    )
    {
      MeasureType = measureType;
      MeterKind = meterKind;
      StartImmediately = startImmediately;
      ProfileChildProcesses = profileChildProcesses;
      ReuseSameNameThreads = reuseSameNameThreads;
      PrecisionMode = precisionMode;
      EnableJitInlining = enableJitInlining;
      EnableNativeAllocations = enableNativeAllocations;
      EnableDebugOutput = enableDebugOutput;
      EnableTpl = enableTpl;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceProfilingConfiguration> Read = (ctx, reader) => 
    {
      var measureType = (JetBrains.Rider.Model.MeasureType)reader.ReadInt();
      var meterKind = (JetBrains.Rider.Model.MeterKind)reader.ReadInt();
      var startImmediately = reader.ReadBool();
      var profileChildProcesses = reader.ReadBool();
      var reuseSameNameThreads = reader.ReadBool();
      var precisionMode = reader.ReadBool();
      var enableJitInlining = reader.ReadBool();
      var enableNativeAllocations = reader.ReadBool();
      var enableDebugOutput = reader.ReadBool();
      var enableTpl = reader.ReadBool();
      return new DotTraceProfilingConfiguration(measureType, meterKind, startImmediately, profileChildProcesses, reuseSameNameThreads, precisionMode, enableJitInlining, enableNativeAllocations, enableDebugOutput, enableTpl);
    };
    
    public static CtxWriteDelegate<DotTraceProfilingConfiguration> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.MeasureType);
      writer.Write((int)value.MeterKind);
      writer.Write(value.StartImmediately);
      writer.Write(value.ProfileChildProcesses);
      writer.Write(value.ReuseSameNameThreads);
      writer.Write(value.PrecisionMode);
      writer.Write(value.EnableJitInlining);
      writer.Write(value.EnableNativeAllocations);
      writer.Write(value.EnableDebugOutput);
      writer.Write(value.EnableTpl);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceProfilingConfiguration) obj);
    }
    public bool Equals(DotTraceProfilingConfiguration other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return MeasureType == other.MeasureType && MeterKind == other.MeterKind && StartImmediately == other.StartImmediately && ProfileChildProcesses == other.ProfileChildProcesses && ReuseSameNameThreads == other.ReuseSameNameThreads && PrecisionMode == other.PrecisionMode && EnableJitInlining == other.EnableJitInlining && EnableNativeAllocations == other.EnableNativeAllocations && EnableDebugOutput == other.EnableDebugOutput && EnableTpl == other.EnableTpl;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) MeasureType;
        hash = hash * 31 + (int) MeterKind;
        hash = hash * 31 + StartImmediately.GetHashCode();
        hash = hash * 31 + ProfileChildProcesses.GetHashCode();
        hash = hash * 31 + ReuseSameNameThreads.GetHashCode();
        hash = hash * 31 + PrecisionMode.GetHashCode();
        hash = hash * 31 + EnableJitInlining.GetHashCode();
        hash = hash * 31 + EnableNativeAllocations.GetHashCode();
        hash = hash * 31 + EnableDebugOutput.GetHashCode();
        hash = hash * 31 + EnableTpl.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceProfilingConfiguration (");
      using (printer.IndentCookie()) {
        printer.Print("measureType = "); MeasureType.PrintEx(printer); printer.Println();
        printer.Print("meterKind = "); MeterKind.PrintEx(printer); printer.Println();
        printer.Print("startImmediately = "); StartImmediately.PrintEx(printer); printer.Println();
        printer.Print("profileChildProcesses = "); ProfileChildProcesses.PrintEx(printer); printer.Println();
        printer.Print("reuseSameNameThreads = "); ReuseSameNameThreads.PrintEx(printer); printer.Println();
        printer.Print("precisionMode = "); PrecisionMode.PrintEx(printer); printer.Println();
        printer.Print("enableJitInlining = "); EnableJitInlining.PrintEx(printer); printer.Println();
        printer.Print("enableNativeAllocations = "); EnableNativeAllocations.PrintEx(printer); printer.Println();
        printer.Print("enableDebugOutput = "); EnableDebugOutput.PrintEx(printer); printer.Println();
        printer.Print("enableTpl = "); EnableTpl.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceSnapshotListItem : IPrintable, IEquatable<DotTraceSnapshotListItem>
  {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    public DateTime Date {get; private set;}
    [NotNull] public string Path {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string Application {get; private set;}
    [NotNull] public string SnapshotType {get; private set;}
    public long Size {get; private set;}
    [NotNull] public string SizeString {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceSnapshotListItem(
      [NotNull] string id,
      DateTime date,
      [NotNull] string path,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string application,
      [NotNull] string snapshotType,
      long size,
      [NotNull] string sizeString
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (path == null) throw new ArgumentNullException("path");
      if (application == null) throw new ArgumentNullException("application");
      if (snapshotType == null) throw new ArgumentNullException("snapshotType");
      if (sizeString == null) throw new ArgumentNullException("sizeString");
      
      Id = id;
      Date = date;
      Path = path;
      Icon = icon;
      Application = application;
      SnapshotType = snapshotType;
      Size = size;
      SizeString = sizeString;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceSnapshotListItem> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var date = reader.ReadDateTime();
      var path = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var application = reader.ReadString();
      var snapshotType = reader.ReadString();
      var size = reader.ReadLong();
      var sizeString = reader.ReadString();
      return new DotTraceSnapshotListItem(id, date, path, icon, application, snapshotType, size, sizeString);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<DotTraceSnapshotListItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Date);
      writer.Write(value.Path);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.Application);
      writer.Write(value.SnapshotType);
      writer.Write(value.Size);
      writer.Write(value.SizeString);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceSnapshotListItem) obj);
    }
    public bool Equals(DotTraceSnapshotListItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Date == other.Date && Path == other.Path && Equals(Icon, other.Icon) && Application == other.Application && SnapshotType == other.SnapshotType && Size == other.Size && SizeString == other.SizeString;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Date.GetHashCode();
        hash = hash * 31 + Path.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Application.GetHashCode();
        hash = hash * 31 + SnapshotType.GetHashCode();
        hash = hash * 31 + Size.GetHashCode();
        hash = hash * 31 + SizeString.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceSnapshotListItem (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("date = "); Date.PrintEx(printer); printer.Println();
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("application = "); Application.PrintEx(printer); printer.Println();
        printer.Print("snapshotType = "); SnapshotType.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
        printer.Print("sizeString = "); SizeString.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EnumFilterButton : JetBrains.Rider.Model.UIAutomation.BeControl
  {
    //fields
    //public fields
    [NotNull] public ISink<JetBrains.Rider.Model.OnClick> OnClick { get { return _OnClick; }}
    [NotNull] public string Name {get; private set;}
    public bool ShowsPopup {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.AppliedValue> AppliedValue { get { return _AppliedValue; }}
    [NotNull] public IRdProperty<string> Tooltip { get { return _Tooltip; }}
    
    //private fields
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.OnClick> _OnClick;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.AppliedValue> _AppliedValue;
    [NotNull] private readonly RdProperty<string> _Tooltip;
    
    //primary constructor
    private EnumFilterButton(
      [NotNull] RdSignal<JetBrains.Rider.Model.OnClick> onClick,
      [NotNull] string name,
      bool showsPopup,
      [NotNull] RdProperty<JetBrains.Rider.Model.AppliedValue> appliedValue,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (onClick == null) throw new ArgumentNullException("onClick");
      if (name == null) throw new ArgumentNullException("name");
      if (appliedValue == null) throw new ArgumentNullException("appliedValue");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      
      _OnClick = onClick;
      Name = name;
      ShowsPopup = showsPopup;
      _AppliedValue = appliedValue;
      _Tooltip = tooltip;
      _AppliedValue.OptimizeNested = true;
      _Tooltip.OptimizeNested = true;
      _Tooltip.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("onClick", _OnClick));
      BindableChildren.Add(new KeyValuePair<string, object>("appliedValue", _AppliedValue));
      BindableChildren.Add(new KeyValuePair<string, object>("tooltip", _Tooltip));
    }
    //secondary constructor
    public EnumFilterButton (
      [NotNull] string name,
      bool showsPopup
    ) : this (
      new RdSignal<JetBrains.Rider.Model.OnClick>(JetBrains.Rider.Model.OnClick.Read, JetBrains.Rider.Model.OnClick.Write),
      name,
      showsPopup,
      new RdProperty<JetBrains.Rider.Model.AppliedValue>(JetBrains.Rider.Model.AppliedValue.Read, JetBrains.Rider.Model.AppliedValue.Write),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<EnumFilterButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var onClick = RdSignal<JetBrains.Rider.Model.OnClick>.Read(ctx, reader, JetBrains.Rider.Model.OnClick.Read, JetBrains.Rider.Model.OnClick.Write);
      var name = reader.ReadString();
      var showsPopup = reader.ReadBool();
      var appliedValue = RdProperty<JetBrains.Rider.Model.AppliedValue>.Read(ctx, reader, JetBrains.Rider.Model.AppliedValue.Read, JetBrains.Rider.Model.AppliedValue.Write);
      var tooltip = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      return new EnumFilterButton(onClick, name, showsPopup, appliedValue, tooltip, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<EnumFilterButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      RdSignal<JetBrains.Rider.Model.OnClick>.Write(ctx, writer, value._OnClick);
      writer.Write(value.Name);
      writer.Write(value.ShowsPopup);
      RdProperty<JetBrains.Rider.Model.AppliedValue>.Write(ctx, writer, value._AppliedValue);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EnumFilterButton (");
      using (printer.IndentCookie()) {
        printer.Print("onClick = "); _OnClick.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("showsPopup = "); ShowsPopup.PrintEx(printer); printer.Println();
        printer.Print("appliedValue = "); _AppliedValue.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FilterButton : JetBrains.Rider.Model.UIAutomation.BeControl
  {
    //fields
    //public fields
    public bool ShowText {get; private set;}
    [NotNull] public ISink<RdVoid> OnClick { get { return _OnClick; }}
    [NotNull] public IRdProperty<bool> IsMouseOver { get { return _IsMouseOver; }}
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    [NotNull] public IRdProperty<string> Tooltip { get { return _Tooltip; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _OnClick;
    [NotNull] private readonly RdProperty<bool> _IsMouseOver;
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    [NotNull] private readonly RdProperty<string> _Tooltip;
    
    //primary constructor
    private FilterButton(
      bool showText,
      [NotNull] RdSignal<RdVoid> onClick,
      [NotNull] RdProperty<bool> isMouseOver,
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (onClick == null) throw new ArgumentNullException("onClick");
      if (isMouseOver == null) throw new ArgumentNullException("isMouseOver");
      if (text == null) throw new ArgumentNullException("text");
      if (icon == null) throw new ArgumentNullException("icon");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      
      ShowText = showText;
      _OnClick = onClick;
      _IsMouseOver = isMouseOver;
      _Text = text;
      _Icon = icon;
      _Tooltip = tooltip;
      _IsMouseOver.OptimizeNested = true;
      _Text.OptimizeNested = true;
      _Icon.OptimizeNested = true;
      _Tooltip.OptimizeNested = true;
      _Text.ValueCanBeNull = true;
      _Icon.ValueCanBeNull = true;
      _Tooltip.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("onClick", _OnClick));
      BindableChildren.Add(new KeyValuePair<string, object>("isMouseOver", _IsMouseOver));
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
      BindableChildren.Add(new KeyValuePair<string, object>("tooltip", _Tooltip));
    }
    //secondary constructor
    public FilterButton (
      bool showText
    ) : this (
      showText,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<FilterButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var showText = reader.ReadBool();
      var onClick = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var isMouseOver = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var text = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      var tooltip = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      return new FilterButton(showText, onClick, isMouseOver, text, icon, tooltip, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<FilterButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      writer.Write(value.ShowText);
      RdSignal<RdVoid>.Write(ctx, writer, value._OnClick);
      RdProperty<bool>.Write(ctx, writer, value._IsMouseOver);
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FilterButton (");
      using (printer.IndentCookie()) {
        printer.Print("showText = "); ShowText.PrintEx(printer); printer.Println();
        printer.Print("onClick = "); _OnClick.PrintEx(printer); printer.Println();
        printer.Print("isMouseOver = "); _IsMouseOver.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MeasureType {
    Sampling,
    Tracing,
    TracingInject,
    Timeline
  }
  
  
  public enum MeterKind {
    None,
    PerformanceCounter,
    ThreadTime,
    Rdtsc,
    ThreadCycleTime
  }
  
  
  public class OnClick : IPrintable, IEquatable<OnClick>
  {
    //fields
    //public fields
    [CanBeNull] public string ComponentAnchorId {get; private set;}
    
    //private fields
    //primary constructor
    public OnClick(
      [CanBeNull] string componentAnchorId
    )
    {
      ComponentAnchorId = componentAnchorId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<OnClick> Read = (ctx, reader) => 
    {
      var componentAnchorId = ReadStringNullable(ctx, reader);
      return new OnClick(componentAnchorId);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<OnClick> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.ComponentAnchorId);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((OnClick) obj);
    }
    public bool Equals(OnClick other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ComponentAnchorId, other.ComponentAnchorId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (ComponentAnchorId != null ?ComponentAnchorId.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("OnClick (");
      using (printer.IndentCookie()) {
        printer.Print("componentAnchorId = "); ComponentAnchorId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OpenedSnapshot : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Path {get; private set;}
    [NotNull] public IRdProperty<string> TabName { get { return _TabName; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> View { get { return _View; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _TabName;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> _View;
    
    //primary constructor
    private OpenedSnapshot(
      [NotNull] string path,
      [NotNull] RdProperty<string> tabName,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> view
    )
    {
      if (path == null) throw new ArgumentNullException("path");
      if (tabName == null) throw new ArgumentNullException("tabName");
      if (view == null) throw new ArgumentNullException("view");
      
      Path = path;
      _TabName = tabName;
      _View = view;
      _TabName.OptimizeNested = true;
      _View.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("tabName", _TabName));
      BindableChildren.Add(new KeyValuePair<string, object>("view", _View));
    }
    //secondary constructor
    public OpenedSnapshot (
      [NotNull] string path
    ) : this (
      path,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl>(ReadBeControlNullable, WriteBeControlNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<OpenedSnapshot> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var path = reader.ReadString();
      var tabName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var view = RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl>.Read(ctx, reader, ReadBeControlNullable, WriteBeControlNullable);
      return new OpenedSnapshot(path, tabName, view).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.BeControl> ReadBeControlNullable = JetBrains.Rider.Model.UIAutomation.BeControl.Read.NullableClass();
    
    public static CtxWriteDelegate<OpenedSnapshot> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Path);
      RdProperty<string>.Write(ctx, writer, value._TabName);
      RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl>.Write(ctx, writer, value._View);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.BeControl> WriteBeControlNullable = JetBrains.Rider.Model.UIAutomation.BeControl.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OpenedSnapshot (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("tabName = "); _TabName.PrintEx(printer); printer.Println();
        printer.Print("view = "); _View.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ProfilerCoreCommand {
    Start,
    StopSave,
    StopSaveStart,
    Drop,
    DropStart,
    Detach,
    Close,
    Throw
  }
  
  
  public class ProjectProperties : IPrintable, IEquatable<ProjectProperties>
  {
    //fields
    //public fields
    public JetBrains.Rider.Model.RunnableProjectKind RunnableProjectKind {get; private set;}
    [NotNull] public string TargetFramework {get; private set;}
    [NotNull] public string Url {get; private set;}
    public bool RunBrowser {get; private set;}
    
    //private fields
    //primary constructor
    public ProjectProperties(
      JetBrains.Rider.Model.RunnableProjectKind runnableProjectKind,
      [NotNull] string targetFramework,
      [NotNull] string url,
      bool runBrowser
    )
    {
      if (targetFramework == null) throw new ArgumentNullException("targetFramework");
      if (url == null) throw new ArgumentNullException("url");
      
      RunnableProjectKind = runnableProjectKind;
      TargetFramework = targetFramework;
      Url = url;
      RunBrowser = runBrowser;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectProperties> Read = (ctx, reader) => 
    {
      var runnableProjectKind = (JetBrains.Rider.Model.RunnableProjectKind)reader.ReadInt();
      var targetFramework = reader.ReadString();
      var url = reader.ReadString();
      var runBrowser = reader.ReadBool();
      return new ProjectProperties(runnableProjectKind, targetFramework, url, runBrowser);
    };
    
    public static CtxWriteDelegate<ProjectProperties> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.RunnableProjectKind);
      writer.Write(value.TargetFramework);
      writer.Write(value.Url);
      writer.Write(value.RunBrowser);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectProperties) obj);
    }
    public bool Equals(ProjectProperties other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return RunnableProjectKind == other.RunnableProjectKind && TargetFramework == other.TargetFramework && Url == other.Url && RunBrowser == other.RunBrowser;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) RunnableProjectKind;
        hash = hash * 31 + TargetFramework.GetHashCode();
        hash = hash * 31 + Url.GetHashCode();
        hash = hash * 31 + RunBrowser.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectProperties (");
      using (printer.IndentCookie()) {
        printer.Print("runnableProjectKind = "); RunnableProjectKind.PrintEx(printer); printer.Println();
        printer.Print("targetFramework = "); TargetFramework.PrintEx(printer); printer.Println();
        printer.Print("url = "); Url.PrintEx(printer); printer.Println();
        printer.Print("runBrowser = "); RunBrowser.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotTraceCoreRemovedState : IPrintable, IEquatable<RdDotTraceCoreRemovedState>
  {
    //fields
    //public fields
    public int ProcessPid {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotTraceCoreRemovedState(
      int processPid
    )
    {
      ProcessPid = processPid;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDotTraceCoreRemovedState> Read = (ctx, reader) => 
    {
      var processPid = reader.ReadInt();
      return new RdDotTraceCoreRemovedState(processPid);
    };
    
    public static CtxWriteDelegate<RdDotTraceCoreRemovedState> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProcessPid);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotTraceCoreRemovedState) obj);
    }
    public bool Equals(RdDotTraceCoreRemovedState other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProcessPid == other.ProcessPid;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProcessPid.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotTraceCoreRemovedState (");
      using (printer.IndentCookie()) {
        printer.Print("processPid = "); ProcessPid.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotTraceMessage : IPrintable, IEquatable<RdDotTraceMessage>
  {
    //fields
    //public fields
    public int Pid {get; private set;}
    [NotNull] public string Message {get; private set;}
    public bool Critical {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotTraceMessage(
      int pid,
      [NotNull] string message,
      bool critical
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      
      Pid = pid;
      Message = message;
      Critical = critical;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDotTraceMessage> Read = (ctx, reader) => 
    {
      var pid = reader.ReadInt();
      var message = reader.ReadString();
      var critical = reader.ReadBool();
      return new RdDotTraceMessage(pid, message, critical);
    };
    
    public static CtxWriteDelegate<RdDotTraceMessage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Pid);
      writer.Write(value.Message);
      writer.Write(value.Critical);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotTraceMessage) obj);
    }
    public bool Equals(RdDotTraceMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Pid == other.Pid && Message == other.Message && Critical == other.Critical;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Pid.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        hash = hash * 31 + Critical.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotTraceMessage (");
      using (printer.IndentCookie()) {
        printer.Print("pid = "); Pid.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("critical = "); Critical.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotTraceOperationsState : IPrintable, IEquatable<RdDotTraceOperationsState>
  {
    //fields
    //public fields
    public bool IsStartEnabled {get; private set;}
    public bool IsGetEnabled {get; private set;}
    public bool IsDetachEnabled {get; private set;}
    public bool IsKillEnabled {get; private set;}
    public bool IsUnderAPI {get; private set;}
    public int Pid {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotTraceOperationsState(
      bool isStartEnabled,
      bool isGetEnabled,
      bool isDetachEnabled,
      bool isKillEnabled,
      bool isUnderAPI,
      int pid
    )
    {
      IsStartEnabled = isStartEnabled;
      IsGetEnabled = isGetEnabled;
      IsDetachEnabled = isDetachEnabled;
      IsKillEnabled = isKillEnabled;
      IsUnderAPI = isUnderAPI;
      Pid = pid;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDotTraceOperationsState> Read = (ctx, reader) => 
    {
      var isStartEnabled = reader.ReadBool();
      var isGetEnabled = reader.ReadBool();
      var isDetachEnabled = reader.ReadBool();
      var isKillEnabled = reader.ReadBool();
      var isUnderAPI = reader.ReadBool();
      var pid = reader.ReadInt();
      return new RdDotTraceOperationsState(isStartEnabled, isGetEnabled, isDetachEnabled, isKillEnabled, isUnderAPI, pid);
    };
    
    public static CtxWriteDelegate<RdDotTraceOperationsState> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsStartEnabled);
      writer.Write(value.IsGetEnabled);
      writer.Write(value.IsDetachEnabled);
      writer.Write(value.IsKillEnabled);
      writer.Write(value.IsUnderAPI);
      writer.Write(value.Pid);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotTraceOperationsState) obj);
    }
    public bool Equals(RdDotTraceOperationsState other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsStartEnabled == other.IsStartEnabled && IsGetEnabled == other.IsGetEnabled && IsDetachEnabled == other.IsDetachEnabled && IsKillEnabled == other.IsKillEnabled && IsUnderAPI == other.IsUnderAPI && Pid == other.Pid;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsStartEnabled.GetHashCode();
        hash = hash * 31 + IsGetEnabled.GetHashCode();
        hash = hash * 31 + IsDetachEnabled.GetHashCode();
        hash = hash * 31 + IsKillEnabled.GetHashCode();
        hash = hash * 31 + IsUnderAPI.GetHashCode();
        hash = hash * 31 + Pid.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotTraceOperationsState (");
      using (printer.IndentCookie()) {
        printer.Print("isStartEnabled = "); IsStartEnabled.PrintEx(printer); printer.Println();
        printer.Print("isGetEnabled = "); IsGetEnabled.PrintEx(printer); printer.Println();
        printer.Print("isDetachEnabled = "); IsDetachEnabled.PrintEx(printer); printer.Println();
        printer.Print("isKillEnabled = "); IsKillEnabled.PrintEx(printer); printer.Println();
        printer.Print("isUnderAPI = "); IsUnderAPI.PrintEx(printer); printer.Println();
        printer.Print("pid = "); Pid.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProfilingCore : IPrintable, IEquatable<RdProfilingCore>
  {
    //fields
    //public fields
    [NotNull] public string ProcessName {get; private set;}
    [NotNull] public string CommandLine {get; private set;}
    public int Pid {get; private set;}
    [NotNull] public string CoreId {get; private set;}
    [NotNull] public string Version {get; private set;}
    
    //private fields
    //primary constructor
    public RdProfilingCore(
      [NotNull] string processName,
      [NotNull] string commandLine,
      int pid,
      [NotNull] string coreId,
      [NotNull] string version
    )
    {
      if (processName == null) throw new ArgumentNullException("processName");
      if (commandLine == null) throw new ArgumentNullException("commandLine");
      if (coreId == null) throw new ArgumentNullException("coreId");
      if (version == null) throw new ArgumentNullException("version");
      
      ProcessName = processName;
      CommandLine = commandLine;
      Pid = pid;
      CoreId = coreId;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProfilingCore> Read = (ctx, reader) => 
    {
      var processName = reader.ReadString();
      var commandLine = reader.ReadString();
      var pid = reader.ReadInt();
      var coreId = reader.ReadString();
      var version = reader.ReadString();
      return new RdProfilingCore(processName, commandLine, pid, coreId, version);
    };
    
    public static CtxWriteDelegate<RdProfilingCore> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProcessName);
      writer.Write(value.CommandLine);
      writer.Write(value.Pid);
      writer.Write(value.CoreId);
      writer.Write(value.Version);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProfilingCore) obj);
    }
    public bool Equals(RdProfilingCore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProcessName == other.ProcessName && CommandLine == other.CommandLine && Pid == other.Pid && CoreId == other.CoreId && Version == other.Version;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProcessName.GetHashCode();
        hash = hash * 31 + CommandLine.GetHashCode();
        hash = hash * 31 + Pid.GetHashCode();
        hash = hash * 31 + CoreId.GetHashCode();
        hash = hash * 31 + Version.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProfilingCore (");
      using (printer.IndentCookie()) {
        printer.Print("processName = "); ProcessName.PrintEx(printer); printer.Println();
        printer.Print("commandLine = "); CommandLine.PrintEx(printer); printer.Println();
        printer.Print("pid = "); Pid.PrintEx(printer); printer.Println();
        printer.Print("coreId = "); CoreId.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSnapshotCreated : IPrintable, IEquatable<RdSnapshotCreated>
  {
    //fields
    //public fields
    [NotNull] public string CoreId {get; private set;}
    public DateTime Timestamp {get; private set;}
    [NotNull] public string Process {get; private set;}
    
    //private fields
    //primary constructor
    public RdSnapshotCreated(
      [NotNull] string coreId,
      DateTime timestamp,
      [NotNull] string process
    )
    {
      if (coreId == null) throw new ArgumentNullException("coreId");
      if (process == null) throw new ArgumentNullException("process");
      
      CoreId = coreId;
      Timestamp = timestamp;
      Process = process;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSnapshotCreated> Read = (ctx, reader) => 
    {
      var coreId = reader.ReadString();
      var timestamp = reader.ReadDateTime();
      var process = reader.ReadString();
      return new RdSnapshotCreated(coreId, timestamp, process);
    };
    
    public static CtxWriteDelegate<RdSnapshotCreated> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CoreId);
      writer.Write(value.Timestamp);
      writer.Write(value.Process);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSnapshotCreated) obj);
    }
    public bool Equals(RdSnapshotCreated other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return CoreId == other.CoreId && Timestamp == other.Timestamp && Process == other.Process;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + CoreId.GetHashCode();
        hash = hash * 31 + Timestamp.GetHashCode();
        hash = hash * 31 + Process.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSnapshotCreated (");
      using (printer.IndentCookie()) {
        printer.Print("coreId = "); CoreId.PrintEx(printer); printer.Println();
        printer.Print("timestamp = "); Timestamp.PrintEx(printer); printer.Println();
        printer.Print("process = "); Process.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSnapshotDone : IPrintable, IEquatable<RdSnapshotDone>
  {
    //fields
    //public fields
    [NotNull] public string CoreId {get; private set;}
    [NotNull] public string Path {get; private set;}
    [NotNull] public string Size {get; private set;}
    
    //private fields
    //primary constructor
    public RdSnapshotDone(
      [NotNull] string coreId,
      [NotNull] string path,
      [NotNull] string size
    )
    {
      if (coreId == null) throw new ArgumentNullException("coreId");
      if (path == null) throw new ArgumentNullException("path");
      if (size == null) throw new ArgumentNullException("size");
      
      CoreId = coreId;
      Path = path;
      Size = size;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSnapshotDone> Read = (ctx, reader) => 
    {
      var coreId = reader.ReadString();
      var path = reader.ReadString();
      var size = reader.ReadString();
      return new RdSnapshotDone(coreId, path, size);
    };
    
    public static CtxWriteDelegate<RdSnapshotDone> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CoreId);
      writer.Write(value.Path);
      writer.Write(value.Size);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSnapshotDone) obj);
    }
    public bool Equals(RdSnapshotDone other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return CoreId == other.CoreId && Path == other.Path && Size == other.Size;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + CoreId.GetHashCode();
        hash = hash * 31 + Path.GetHashCode();
        hash = hash * 31 + Size.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSnapshotDone (");
      using (printer.IndentCookie()) {
        printer.Print("coreId = "); CoreId.PrintEx(printer); printer.Println();
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSnapshotInProcessItem : IPrintable, IEquatable<RdSnapshotInProcessItem>
  {
    //fields
    //public fields
    [NotNull] public string CoreId {get; private set;}
    [NotNull] public string Status {get; private set;}
    [NotNull] public string Size {get; private set;}
    public int Progress {get; private set;}
    
    //private fields
    //primary constructor
    public RdSnapshotInProcessItem(
      [NotNull] string coreId,
      [NotNull] string status,
      [NotNull] string size,
      int progress
    )
    {
      if (coreId == null) throw new ArgumentNullException("coreId");
      if (status == null) throw new ArgumentNullException("status");
      if (size == null) throw new ArgumentNullException("size");
      
      CoreId = coreId;
      Status = status;
      Size = size;
      Progress = progress;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSnapshotInProcessItem> Read = (ctx, reader) => 
    {
      var coreId = reader.ReadString();
      var status = reader.ReadString();
      var size = reader.ReadString();
      var progress = reader.ReadInt();
      return new RdSnapshotInProcessItem(coreId, status, size, progress);
    };
    
    public static CtxWriteDelegate<RdSnapshotInProcessItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CoreId);
      writer.Write(value.Status);
      writer.Write(value.Size);
      writer.Write(value.Progress);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSnapshotInProcessItem) obj);
    }
    public bool Equals(RdSnapshotInProcessItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return CoreId == other.CoreId && Status == other.Status && Size == other.Size && Progress == other.Progress;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + CoreId.GetHashCode();
        hash = hash * 31 + Status.GetHashCode();
        hash = hash * 31 + Size.GetHashCode();
        hash = hash * 31 + Progress.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSnapshotInProcessItem (");
      using (printer.IndentCookie()) {
        printer.Print("coreId = "); CoreId.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
        printer.Print("progress = "); Progress.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSnapshotRemoved : IPrintable, IEquatable<RdSnapshotRemoved>
  {
    //fields
    //public fields
    [NotNull] public string CoreId {get; private set;}
    
    //private fields
    //primary constructor
    public RdSnapshotRemoved(
      [NotNull] string coreId
    )
    {
      if (coreId == null) throw new ArgumentNullException("coreId");
      
      CoreId = coreId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSnapshotRemoved> Read = (ctx, reader) => 
    {
      var coreId = reader.ReadString();
      return new RdSnapshotRemoved(coreId);
    };
    
    public static CtxWriteDelegate<RdSnapshotRemoved> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CoreId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSnapshotRemoved) obj);
    }
    public bool Equals(RdSnapshotRemoved other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return CoreId == other.CoreId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + CoreId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSnapshotRemoved (");
      using (printer.IndentCookie()) {
        printer.Print("coreId = "); CoreId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SnapshotsView : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IViewableList<DotTraceSnapshotListItem> Items { get { return _Items; }}
    [NotNull] public string EnclosingControlId {get; private set;}
    [NotNull] public string ResharperGroupId {get; private set;}
    [NotNull] public IRdProperty<bool> FilterBySolution { get { return _FilterBySolution; }}
    
    //private fields
    [NotNull] private readonly RdList<DotTraceSnapshotListItem> _Items;
    [NotNull] private readonly RdProperty<bool> _FilterBySolution;
    
    //primary constructor
    private SnapshotsView(
      [NotNull] RdList<DotTraceSnapshotListItem> items,
      [NotNull] string enclosingControlId,
      [NotNull] string resharperGroupId,
      [NotNull] RdProperty<bool> filterBySolution
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      if (enclosingControlId == null) throw new ArgumentNullException("enclosingControlId");
      if (resharperGroupId == null) throw new ArgumentNullException("resharperGroupId");
      if (filterBySolution == null) throw new ArgumentNullException("filterBySolution");
      
      _Items = items;
      EnclosingControlId = enclosingControlId;
      ResharperGroupId = resharperGroupId;
      _FilterBySolution = filterBySolution;
      _Items.OptimizeNested = true;
      _FilterBySolution.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
      BindableChildren.Add(new KeyValuePair<string, object>("filterBySolution", _FilterBySolution));
    }
    //secondary constructor
    public SnapshotsView (
      [NotNull] string enclosingControlId,
      [NotNull] string resharperGroupId
    ) : this (
      new RdList<DotTraceSnapshotListItem>(DotTraceSnapshotListItem.Read, DotTraceSnapshotListItem.Write),
      enclosingControlId,
      resharperGroupId,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<SnapshotsView> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = RdList<DotTraceSnapshotListItem>.Read(ctx, reader, DotTraceSnapshotListItem.Read, DotTraceSnapshotListItem.Write);
      var enclosingControlId = reader.ReadString();
      var resharperGroupId = reader.ReadString();
      var filterBySolution = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new SnapshotsView(items, enclosingControlId, resharperGroupId, filterBySolution).WithId(_id);
    };
    
    public static CtxWriteDelegate<SnapshotsView> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdList<DotTraceSnapshotListItem>.Write(ctx, writer, value._Items);
      writer.Write(value.EnclosingControlId);
      writer.Write(value.ResharperGroupId);
      RdProperty<bool>.Write(ctx, writer, value._FilterBySolution);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SnapshotsView (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("enclosingControlId = "); EnclosingControlId.PrintEx(printer); printer.Println();
        printer.Print("resharperGroupId = "); ResharperGroupId.PrintEx(printer); printer.Println();
        printer.Print("filterBySolution = "); _FilterBySolution.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
