using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Refactorings
{
  
  
  public class GenerateViewProviderModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<GenerateWindowModel> GenerateWindow { get { return _GenerateWindow; }}
    
    //private fields
    [NotNull] private readonly RdProperty<GenerateWindowModel> _GenerateWindow;
    
    //primary constructor
    private GenerateViewProviderModel(
      [NotNull] RdProperty<GenerateWindowModel> generateWindow
    )
    {
      if (generateWindow == null) throw new ArgumentNullException("generateWindow");
      
      _GenerateWindow = generateWindow;
      _GenerateWindow.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("generateWindow", _GenerateWindow));
    }
    //secondary constructor
    private GenerateViewProviderModel (
    ) : this (
      new RdProperty<GenerateWindowModel>(ReadGenerateWindowModelNullable, WriteGenerateWindowModelNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<GenerateWindowModel> ReadGenerateWindowModelNullable = GenerateWindowModel.Read.NullableClass();
    
    public static CtxWriteDelegate<GenerateWindowModel> WriteGenerateWindowModelNullable = GenerateWindowModel.Write.NullableClass();
    
    protected override long SerializationHash => -8094877506926529497L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(GenerateWindowTextOptionModel.Read, GenerateWindowTextOptionModel.Write);
      serializers.Register(GenerateWindowComboOptionModel.Read, GenerateWindowComboOptionModel.Write);
      serializers.Register(GenerateWindowBoolOptionModel.Read, GenerateWindowBoolOptionModel.Write);
      serializers.Register(GenerateWindowModel.Read, GenerateWindowModel.Write);
      serializers.Register(GenerateWindowElementModel.Read, GenerateWindowElementModel.Write);
      serializers.Register(GenerateWindowGroupingObjectModel.Read, GenerateWindowGroupingObjectModel.Write);
      serializers.Register(GenerateWindowOptionModel_Unknown.Read, GenerateWindowOptionModel_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public GenerateViewProviderModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateViewProviderModel (");
      using (printer.IndentCookie()) {
        printer.Print("generateWindow = "); _GenerateWindow.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowBoolOptionModel : GenerateWindowOptionModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Value;
    
    //primary constructor
    private GenerateWindowBoolOptionModel(
      [NotNull] RdProperty<bool> value,
      [NotNull] string label
    ) : base (
      label
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public GenerateWindowBoolOptionModel (
      [NotNull] string label
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      label
    ) {}
    //statics
    
    public static new CtxReadDelegate<GenerateWindowBoolOptionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var label = reader.ReadString();
      var value = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new GenerateWindowBoolOptionModel(value, label).WithId(_id);
    };
    
    public static new CtxWriteDelegate<GenerateWindowBoolOptionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Label);
      RdProperty<bool>.Write(ctx, writer, value._Value);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowBoolOptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowComboOptionModel : GenerateWindowOptionModel
  {
    //fields
    //public fields
    [NotNull] public List<string> Options {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private GenerateWindowComboOptionModel(
      [NotNull] List<string> options,
      [NotNull] RdProperty<string> value,
      [NotNull] string label
    ) : base (
      label
     ) 
    {
      if (options == null) throw new ArgumentNullException("options");
      if (value == null) throw new ArgumentNullException("value");
      
      Options = options;
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public GenerateWindowComboOptionModel (
      [NotNull] List<string> options,
      [NotNull] string label
    ) : this (
      options,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      label
    ) {}
    //statics
    
    public static new CtxReadDelegate<GenerateWindowComboOptionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var label = reader.ReadString();
      var options = ReadStringList(ctx, reader);
      var value = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new GenerateWindowComboOptionModel(options, value, label).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<GenerateWindowComboOptionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Label);
      WriteStringList(ctx, writer, value.Options);
      RdProperty<string>.Write(ctx, writer, value._Value);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowComboOptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowElementModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<int> GroupingObjects {get; private set;}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] public IRdProperty<int> IndexInList { get { return _IndexInList; }}
    [NotNull] public IRdProperty<List<JetBrains.Rider.Model.ModelRichText>> Description { get { return _Description; }}
    [NotNull] public ISink<RdVoid> MoveUp { get { return _MoveUp; }}
    [NotNull] public ISink<RdVoid> MoveDown { get { return _MoveDown; }}
    [NotNull] public IRdProperty<bool> RequestDescription { get { return _RequestDescription; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Enabled;
    [NotNull] private readonly RdProperty<int> _IndexInList;
    [NotNull] private readonly RdProperty<List<JetBrains.Rider.Model.ModelRichText>> _Description;
    [NotNull] private readonly RdSignal<RdVoid> _MoveUp;
    [NotNull] private readonly RdSignal<RdVoid> _MoveDown;
    [NotNull] private readonly RdProperty<bool> _RequestDescription;
    
    //primary constructor
    private GenerateWindowElementModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<int> groupingObjects,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<int> indexInList,
      [NotNull] RdProperty<List<JetBrains.Rider.Model.ModelRichText>> description,
      [NotNull] RdSignal<RdVoid> moveUp,
      [NotNull] RdSignal<RdVoid> moveDown,
      [NotNull] RdProperty<bool> requestDescription
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (groupingObjects == null) throw new ArgumentNullException("groupingObjects");
      if (enabled == null) throw new ArgumentNullException("enabled");
      if (indexInList == null) throw new ArgumentNullException("indexInList");
      if (description == null) throw new ArgumentNullException("description");
      if (moveUp == null) throw new ArgumentNullException("moveUp");
      if (moveDown == null) throw new ArgumentNullException("moveDown");
      if (requestDescription == null) throw new ArgumentNullException("requestDescription");
      
      Text = text;
      Icon = icon;
      GroupingObjects = groupingObjects;
      _Enabled = enabled;
      _IndexInList = indexInList;
      _Description = description;
      _MoveUp = moveUp;
      _MoveDown = moveDown;
      _RequestDescription = requestDescription;
      _Enabled.OptimizeNested = true;
      _IndexInList.OptimizeNested = true;
      _Description.OptimizeNested = true;
      _RequestDescription.OptimizeNested = true;
      _Description.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
      BindableChildren.Add(new KeyValuePair<string, object>("indexInList", _IndexInList));
      BindableChildren.Add(new KeyValuePair<string, object>("description", _Description));
      BindableChildren.Add(new KeyValuePair<string, object>("moveUp", _MoveUp));
      BindableChildren.Add(new KeyValuePair<string, object>("moveDown", _MoveDown));
      BindableChildren.Add(new KeyValuePair<string, object>("requestDescription", _RequestDescription));
    }
    //secondary constructor
    public GenerateWindowElementModel (
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<int> groupingObjects
    ) : this (
      text,
      icon,
      groupingObjects,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<List<JetBrains.Rider.Model.ModelRichText>>(ReadModelRichTextListNullable, WriteModelRichTextListNullable),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<GenerateWindowElementModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var groupingObjects = ReadIntList(ctx, reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indexInList = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var description = RdProperty<List<JetBrains.Rider.Model.ModelRichText>>.Read(ctx, reader, ReadModelRichTextListNullable, WriteModelRichTextListNullable);
      var moveUp = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var moveDown = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var requestDescription = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new GenerateWindowElementModel(text, icon, groupingObjects, enabled, indexInList, description, moveUp, moveDown, requestDescription).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    public static CtxReadDelegate<List<JetBrains.Rider.Model.ModelRichText>> ReadModelRichTextListNullable = JetBrains.Rider.Model.ModelRichText.Read.List().NullableClass();
    
    public static CtxWriteDelegate<GenerateWindowElementModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteIntList(ctx, writer, value.GroupingObjects);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<int>.Write(ctx, writer, value._IndexInList);
      RdProperty<List<JetBrains.Rider.Model.ModelRichText>>.Write(ctx, writer, value._Description);
      RdSignal<RdVoid>.Write(ctx, writer, value._MoveUp);
      RdSignal<RdVoid>.Write(ctx, writer, value._MoveDown);
      RdProperty<bool>.Write(ctx, writer, value._RequestDescription);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.ModelRichText>> WriteModelRichTextListNullable = JetBrains.Rider.Model.ModelRichText.Write.List().NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groupingObjects = "); GroupingObjects.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("indexInList = "); _IndexInList.PrintEx(printer); printer.Println();
        printer.Print("description = "); _Description.PrintEx(printer); printer.Println();
        printer.Print("moveUp = "); _MoveUp.PrintEx(printer); printer.Println();
        printer.Print("moveDown = "); _MoveDown.PrintEx(printer); printer.Println();
        printer.Print("requestDescription = "); _RequestDescription.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowGroupingObjectModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public GenerateWindowGroupingObjectModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GenerateWindowGroupingObjectModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new GenerateWindowGroupingObjectModel(text, icon).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<GenerateWindowGroupingObjectModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowGroupingObjectModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public bool AllowGrouping {get; private set;}
    public bool ForceGrouping {get; private set;}
    public bool AllowSorting {get; private set;}
    public bool AllowMoving {get; private set;}
    public bool CanHaveDescriptions {get; private set;}
    [NotNull] public List<GenerateWindowElementModel> Elements {get; private set;}
    [NotNull] public List<GenerateWindowGroupingObjectModel> GroupingObjects {get; private set;}
    [NotNull] public List<GenerateWindowOptionModel> Options {get; private set;}
    [NotNull] public ISink<RdVoid> OkClicked { get { return _OkClicked; }}
    [NotNull] public ISink<RdVoid> CancelClicked { get { return _CancelClicked; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _OkClicked;
    [NotNull] private readonly RdSignal<RdVoid> _CancelClicked;
    
    //primary constructor
    private GenerateWindowModel(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      bool allowGrouping,
      bool forceGrouping,
      bool allowSorting,
      bool allowMoving,
      bool canHaveDescriptions,
      [NotNull] List<GenerateWindowElementModel> elements,
      [NotNull] List<GenerateWindowGroupingObjectModel> groupingObjects,
      [NotNull] List<GenerateWindowOptionModel> options,
      [NotNull] RdSignal<RdVoid> okClicked,
      [NotNull] RdSignal<RdVoid> cancelClicked
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (description == null) throw new ArgumentNullException("description");
      if (icon == null) throw new ArgumentNullException("icon");
      if (elements == null) throw new ArgumentNullException("elements");
      if (groupingObjects == null) throw new ArgumentNullException("groupingObjects");
      if (options == null) throw new ArgumentNullException("options");
      if (okClicked == null) throw new ArgumentNullException("okClicked");
      if (cancelClicked == null) throw new ArgumentNullException("cancelClicked");
      
      Title = title;
      Description = description;
      Icon = icon;
      AllowGrouping = allowGrouping;
      ForceGrouping = forceGrouping;
      AllowSorting = allowSorting;
      AllowMoving = allowMoving;
      CanHaveDescriptions = canHaveDescriptions;
      Elements = elements;
      GroupingObjects = groupingObjects;
      Options = options;
      _OkClicked = okClicked;
      _CancelClicked = cancelClicked;
      BindableChildren.Add(new KeyValuePair<string, object>("elements", Elements));
      BindableChildren.Add(new KeyValuePair<string, object>("groupingObjects", GroupingObjects));
      BindableChildren.Add(new KeyValuePair<string, object>("options", Options));
      BindableChildren.Add(new KeyValuePair<string, object>("okClicked", _OkClicked));
      BindableChildren.Add(new KeyValuePair<string, object>("cancelClicked", _CancelClicked));
    }
    //secondary constructor
    public GenerateWindowModel (
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      bool allowGrouping,
      bool forceGrouping,
      bool allowSorting,
      bool allowMoving,
      bool canHaveDescriptions,
      [NotNull] List<GenerateWindowElementModel> elements,
      [NotNull] List<GenerateWindowGroupingObjectModel> groupingObjects,
      [NotNull] List<GenerateWindowOptionModel> options
    ) : this (
      title,
      description,
      icon,
      allowGrouping,
      forceGrouping,
      allowSorting,
      allowMoving,
      canHaveDescriptions,
      elements,
      groupingObjects,
      options,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<GenerateWindowModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var allowGrouping = reader.ReadBool();
      var forceGrouping = reader.ReadBool();
      var allowSorting = reader.ReadBool();
      var allowMoving = reader.ReadBool();
      var canHaveDescriptions = reader.ReadBool();
      var elements = ReadGenerateWindowElementModelList(ctx, reader);
      var groupingObjects = ReadGenerateWindowGroupingObjectModelList(ctx, reader);
      var options = ReadGenerateWindowOptionModelList(ctx, reader);
      var okClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var cancelClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new GenerateWindowModel(title, description, icon, allowGrouping, forceGrouping, allowSorting, allowMoving, canHaveDescriptions, elements, groupingObjects, options, okClicked, cancelClicked).WithId(_id);
    };
    public static CtxReadDelegate<List<GenerateWindowElementModel>> ReadGenerateWindowElementModelList = GenerateWindowElementModel.Read.List();
    public static CtxReadDelegate<List<GenerateWindowGroupingObjectModel>> ReadGenerateWindowGroupingObjectModelList = GenerateWindowGroupingObjectModel.Read.List();
    public static CtxReadDelegate<List<GenerateWindowOptionModel>> ReadGenerateWindowOptionModelList = GenerateWindowOptionModel.Read.List();
    
    public static CtxWriteDelegate<GenerateWindowModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      writer.Write(value.AllowGrouping);
      writer.Write(value.ForceGrouping);
      writer.Write(value.AllowSorting);
      writer.Write(value.AllowMoving);
      writer.Write(value.CanHaveDescriptions);
      WriteGenerateWindowElementModelList(ctx, writer, value.Elements);
      WriteGenerateWindowGroupingObjectModelList(ctx, writer, value.GroupingObjects);
      WriteGenerateWindowOptionModelList(ctx, writer, value.Options);
      RdSignal<RdVoid>.Write(ctx, writer, value._OkClicked);
      RdSignal<RdVoid>.Write(ctx, writer, value._CancelClicked);
    };
    public static CtxWriteDelegate<List<GenerateWindowElementModel>> WriteGenerateWindowElementModelList = GenerateWindowElementModel.Write.List();
    public static CtxWriteDelegate<List<GenerateWindowGroupingObjectModel>> WriteGenerateWindowGroupingObjectModelList = GenerateWindowGroupingObjectModel.Write.List();
    public static CtxWriteDelegate<List<GenerateWindowOptionModel>> WriteGenerateWindowOptionModelList = GenerateWindowOptionModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowModel (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("allowGrouping = "); AllowGrouping.PrintEx(printer); printer.Println();
        printer.Print("forceGrouping = "); ForceGrouping.PrintEx(printer); printer.Println();
        printer.Print("allowSorting = "); AllowSorting.PrintEx(printer); printer.Println();
        printer.Print("allowMoving = "); AllowMoving.PrintEx(printer); printer.Println();
        printer.Print("canHaveDescriptions = "); CanHaveDescriptions.PrintEx(printer); printer.Println();
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
        printer.Print("groupingObjects = "); GroupingObjects.PrintEx(printer); printer.Println();
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
        printer.Print("okClicked = "); _OkClicked.PrintEx(printer); printer.Println();
        printer.Print("cancelClicked = "); _CancelClicked.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class GenerateWindowOptionModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Label {get; private set;}
    
    //private fields
    //primary constructor
    protected GenerateWindowOptionModel(
      [NotNull] string label
    )
    {
      if (label == null) throw new ArgumentNullException("label");
      
      Label = label;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GenerateWindowOptionModel> Read = Polymorphic<GenerateWindowOptionModel>.ReadAbstract(GenerateWindowOptionModel_Unknown.Read);
    
    public static CtxWriteDelegate<GenerateWindowOptionModel> Write = Polymorphic<GenerateWindowOptionModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class GenerateWindowOptionModel_Unknown : GenerateWindowOptionModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public GenerateWindowOptionModel_Unknown(
      [NotNull] string label
    ) : base (
      label
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<GenerateWindowOptionModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var label = reader.ReadString();
      return new GenerateWindowOptionModel_Unknown(label).WithId(_id);
    };
    
    public static new CtxWriteDelegate<GenerateWindowOptionModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Label);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowOptionModel_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowTextOptionModel : GenerateWindowOptionModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private GenerateWindowTextOptionModel(
      [NotNull] RdProperty<string> value,
      [NotNull] string label
    ) : base (
      label
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public GenerateWindowTextOptionModel (
      [NotNull] string label
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      label
    ) {}
    //statics
    
    public static new CtxReadDelegate<GenerateWindowTextOptionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var label = reader.ReadString();
      var value = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new GenerateWindowTextOptionModel(value, label).WithId(_id);
    };
    
    public static new CtxWriteDelegate<GenerateWindowTextOptionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Label);
      RdProperty<string>.Write(ctx, writer, value._Value);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowTextOptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
