using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class GotoModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<GotoKind, SearchPopup> SearchPopups { get { return _SearchPopups; }}
    
    //private fields
    [NotNull] private readonly RdMap<GotoKind, SearchPopup> _SearchPopups;
    
    //primary constructor
    private GotoModel(
      [NotNull] RdMap<GotoKind, SearchPopup> searchPopups
    )
    {
      if (searchPopups == null) throw new ArgumentNullException("searchPopups");
      
      _SearchPopups = searchPopups;
      BindableChildren.Add(new KeyValuePair<string, object>("searchPopups", _SearchPopups));
    }
    //secondary constructor
    internal GotoModel (
    ) : this (
      new RdMap<GotoKind, SearchPopup>(ReadGotoKind, WriteGotoKind, SearchPopup.Read, SearchPopup.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<GotoKind> ReadGotoKind = new CtxReadDelegate<GotoKind>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<GotoKind>);
    
    public static CtxWriteDelegate<GotoKind> WriteGotoKind = new CtxWriteDelegate<GotoKind>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<GotoKind>);
    
    protected override long SerializationHash => -5129761407011252556L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(SearchItemData.Read, SearchItemData.Write);
      serializers.Register(GotoResultList.Read, GotoResultList.Write);
      serializers.RegisterEnum<GotoKind>();
      serializers.Register(SearchPopup.Read, SearchPopup.Write);
      serializers.Register(GotoInput.Read, GotoInput.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GotoModel (");
      using (printer.IndentCookie()) {
        printer.Print("searchPopups = "); _SearchPopups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionGotoModelEx
   {
    public static GotoModel GetGotoModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("gotoModel", () => new GotoModel());
    }
  }
  
  
  public class GotoInput : IPrintable, IEquatable<GotoInput>
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public bool Scope {get; private set;}
    public int RequestId {get; private set;}
    
    //private fields
    //primary constructor
    public GotoInput(
      [NotNull] string text,
      bool scope,
      int requestId
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      Scope = scope;
      RequestId = requestId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GotoInput> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var scope = reader.ReadBool();
      var requestId = reader.ReadInt();
      return new GotoInput(text, scope, requestId);
    };
    
    public static CtxWriteDelegate<GotoInput> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.Scope);
      writer.Write(value.RequestId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GotoInput) obj);
    }
    public bool Equals(GotoInput other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && Scope == other.Scope && RequestId == other.RequestId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + Scope.GetHashCode();
        hash = hash * 31 + RequestId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GotoInput (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("scope = "); Scope.PrintEx(printer); printer.Println();
        printer.Print("requestId = "); RequestId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum GotoKind {
    Unknown,
    None,
    GotoType,
    GotoSymbol,
    SearchEverywhere,
    FileMember,
    Exception,
    Snapshot
  }
  
  
  public class GotoResultList : IPrintable, IEquatable<GotoResultList>
  {
    //fields
    //public fields
    [NotNull] public string RequestText {get; private set;}
    public bool RequestScope {get; private set;}
    [NotNull] public List<SearchItemData> Items {get; private set;}
    
    //private fields
    //primary constructor
    public GotoResultList(
      [NotNull] string requestText,
      bool requestScope,
      [NotNull] List<SearchItemData> items
    )
    {
      if (requestText == null) throw new ArgumentNullException("requestText");
      if (items == null) throw new ArgumentNullException("items");
      
      RequestText = requestText;
      RequestScope = requestScope;
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GotoResultList> Read = (ctx, reader) => 
    {
      var requestText = reader.ReadString();
      var requestScope = reader.ReadBool();
      var items = ReadSearchItemDataList(ctx, reader);
      return new GotoResultList(requestText, requestScope, items);
    };
    public static CtxReadDelegate<List<SearchItemData>> ReadSearchItemDataList = SearchItemData.Read.List();
    
    public static CtxWriteDelegate<GotoResultList> Write = (ctx, writer, value) => 
    {
      writer.Write(value.RequestText);
      writer.Write(value.RequestScope);
      WriteSearchItemDataList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<SearchItemData>> WriteSearchItemDataList = SearchItemData.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GotoResultList) obj);
    }
    public bool Equals(GotoResultList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return RequestText == other.RequestText && RequestScope == other.RequestScope && Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + RequestText.GetHashCode();
        hash = hash * 31 + RequestScope.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GotoResultList (");
      using (printer.IndentCookie()) {
        printer.Print("requestText = "); RequestText.PrintEx(printer); printer.Println();
        printer.Print("requestScope = "); RequestScope.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SearchItemData : IPrintable, IEquatable<SearchItemData>
  {
    //fields
    //public fields
    [NotNull] public Icon IconId {get; private set;}
    public int Id {get; private set;}
    [NotNull] public string ShortName {get; private set;}
    [CanBeNull] public EditableEntityId FileId {get; private set;}
    [NotNull] public ModelRichText DisplayText {get; private set;}
    [CanBeNull] public string GlyphText {get; private set;}
    [CanBeNull] public Icon GlyphIconId {get; private set;}
    
    //private fields
    //primary constructor
    public SearchItemData(
      [NotNull] Icon iconId,
      int id,
      [NotNull] string shortName,
      [CanBeNull] EditableEntityId fileId,
      [NotNull] ModelRichText displayText,
      [CanBeNull] string glyphText,
      [CanBeNull] Icon glyphIconId
    )
    {
      if (iconId == null) throw new ArgumentNullException("iconId");
      if (shortName == null) throw new ArgumentNullException("shortName");
      if (displayText == null) throw new ArgumentNullException("displayText");
      
      IconId = iconId;
      Id = id;
      ShortName = shortName;
      FileId = fileId;
      DisplayText = displayText;
      GlyphText = glyphText;
      GlyphIconId = glyphIconId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SearchItemData> Read = (ctx, reader) => 
    {
      var iconId = Icon.Read(ctx, reader);
      var id = reader.ReadInt();
      var shortName = reader.ReadString();
      var fileId = ReadEditableEntityIdNullable(ctx, reader);
      var displayText = ModelRichText.Read(ctx, reader);
      var glyphText = ReadStringNullable(ctx, reader);
      var glyphIconId = ReadIconNullable(ctx, reader);
      return new SearchItemData(iconId, id, shortName, fileId, displayText, glyphText, glyphIconId);
    };
    public static CtxReadDelegate<EditableEntityId> ReadEditableEntityIdNullable = EditableEntityId.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<Icon> ReadIconNullable = Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<SearchItemData> Write = (ctx, writer, value) => 
    {
      Icon.Write(ctx, writer, value.IconId);
      writer.Write(value.Id);
      writer.Write(value.ShortName);
      WriteEditableEntityIdNullable(ctx, writer, value.FileId);
      ModelRichText.Write(ctx, writer, value.DisplayText);
      WriteStringNullable(ctx, writer, value.GlyphText);
      WriteIconNullable(ctx, writer, value.GlyphIconId);
    };
    public static CtxWriteDelegate<EditableEntityId> WriteEditableEntityIdNullable = EditableEntityId.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<Icon> WriteIconNullable = Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SearchItemData) obj);
    }
    public bool Equals(SearchItemData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(IconId, other.IconId) && Id == other.Id && ShortName == other.ShortName && Equals(FileId, other.FileId) && Equals(DisplayText, other.DisplayText) && Equals(GlyphText, other.GlyphText) && Equals(GlyphIconId, other.GlyphIconId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IconId.GetHashCode();
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + ShortName.GetHashCode();
        hash = hash * 31 + (FileId != null ?FileId.GetHashCode() : 0);
        hash = hash * 31 + DisplayText.GetHashCode();
        hash = hash * 31 + (GlyphText != null ?GlyphText.GetHashCode() : 0);
        hash = hash * 31 + (GlyphIconId != null ?GlyphIconId.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SearchItemData (");
      using (printer.IndentCookie()) {
        printer.Print("iconId = "); IconId.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("shortName = "); ShortName.PrintEx(printer); printer.Println();
        printer.Print("fileId = "); FileId.PrintEx(printer); printer.Println();
        printer.Print("displayText = "); DisplayText.PrintEx(printer); printer.Println();
        printer.Print("glyphText = "); GlyphText.PrintEx(printer); printer.Println();
        printer.Print("glyphIconId = "); GlyphIconId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SearchPopup : RdBindableBase
  {
    //fields
    //public fields
    public GotoKind CurrentPopupKind {get; private set;}
    [NotNull] public ISink<SearchItemData> ItemExecutedSignal { get { return _ItemExecutedSignal; }}
    [NotNull] public IRdProperty<GotoInput> Input { get { return _Input; }}
    [NotNull] public ISource<GotoResultList> GetItemsTask { get { return _GetItemsTask; }}
    [NotNull] public RdEndpoint<RdVoid, int> CreateUsagesSession { get { return _CreateUsagesSession; }}
    
    //private fields
    [NotNull] private readonly RdSignal<SearchItemData> _ItemExecutedSignal;
    [NotNull] private readonly RdProperty<GotoInput> _Input;
    [NotNull] private readonly RdSignal<GotoResultList> _GetItemsTask;
    [NotNull] private readonly RdEndpoint<RdVoid, int> _CreateUsagesSession;
    
    //primary constructor
    private SearchPopup(
      GotoKind currentPopupKind,
      [NotNull] RdSignal<SearchItemData> itemExecutedSignal,
      [NotNull] RdProperty<GotoInput> input,
      [NotNull] RdSignal<GotoResultList> getItemsTask,
      [NotNull] RdEndpoint<RdVoid, int> createUsagesSession
    )
    {
      if (itemExecutedSignal == null) throw new ArgumentNullException("itemExecutedSignal");
      if (input == null) throw new ArgumentNullException("input");
      if (getItemsTask == null) throw new ArgumentNullException("getItemsTask");
      if (createUsagesSession == null) throw new ArgumentNullException("createUsagesSession");
      
      CurrentPopupKind = currentPopupKind;
      _ItemExecutedSignal = itemExecutedSignal;
      _Input = input;
      _GetItemsTask = getItemsTask;
      _CreateUsagesSession = createUsagesSession;
      _Input.OptimizeNested = true;
      _Input.Async = true;
      _GetItemsTask.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("itemExecutedSignal", _ItemExecutedSignal));
      BindableChildren.Add(new KeyValuePair<string, object>("input", _Input));
      BindableChildren.Add(new KeyValuePair<string, object>("getItemsTask", _GetItemsTask));
      BindableChildren.Add(new KeyValuePair<string, object>("createUsagesSession", _CreateUsagesSession));
    }
    //secondary constructor
    public SearchPopup (
      GotoKind currentPopupKind
    ) : this (
      currentPopupKind,
      new RdSignal<SearchItemData>(SearchItemData.Read, SearchItemData.Write),
      new RdProperty<GotoInput>(GotoInput.Read, GotoInput.Write),
      new RdSignal<GotoResultList>(GotoResultList.Read, GotoResultList.Write),
      new RdEndpoint<RdVoid, int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    public static CtxReadDelegate<SearchPopup> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var currentPopupKind = (GotoKind)reader.ReadInt();
      var itemExecutedSignal = RdSignal<SearchItemData>.Read(ctx, reader, SearchItemData.Read, SearchItemData.Write);
      var input = RdProperty<GotoInput>.Read(ctx, reader, GotoInput.Read, GotoInput.Write);
      var getItemsTask = RdSignal<GotoResultList>.Read(ctx, reader, GotoResultList.Read, GotoResultList.Write);
      var createUsagesSession = RdEndpoint<RdVoid, int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new SearchPopup(currentPopupKind, itemExecutedSignal, input, getItemsTask, createUsagesSession).WithId(_id);
    };
    
    public static CtxWriteDelegate<SearchPopup> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write((int)value.CurrentPopupKind);
      RdSignal<SearchItemData>.Write(ctx, writer, value._ItemExecutedSignal);
      RdProperty<GotoInput>.Write(ctx, writer, value._Input);
      RdSignal<GotoResultList>.Write(ctx, writer, value._GetItemsTask);
      RdEndpoint<RdVoid, int>.Write(ctx, writer, value._CreateUsagesSession);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SearchPopup (");
      using (printer.IndentCookie()) {
        printer.Print("currentPopupKind = "); CurrentPopupKind.PrintEx(printer); printer.Println();
        printer.Print("itemExecutedSignal = "); _ItemExecutedSignal.PrintEx(printer); printer.Println();
        printer.Print("input = "); _Input.PrintEx(printer); printer.Println();
        printer.Print("getItemsTask = "); _GetItemsTask.PrintEx(printer); printer.Println();
        printer.Print("createUsagesSession = "); _CreateUsagesSession.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
