using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Inspections
{
  
  
  public class InspectionsModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdCall<ShowSeveritySelectionDialogModel, ShowSeveritySelectionDialogResultModel> ShowSeverityDialog { get { return _ShowSeverityDialog; }}
    [NotNull] public IViewableMap<int, InspectionResultsModel> InspectionsResultSessions { get { return _InspectionsResultSessions; }}
    [NotNull] public IRdProperty<CustomInspectionScopeDialogArguments> ShowCustomInspectionScopeDialog { get { return _ShowCustomInspectionScopeDialog; }}
    [NotNull] public RdEndpoint<RdVoid, RiderGetRunnableInspectionsCallResult> GetRunnableInspections { get { return _GetRunnableInspections; }}
    [NotNull] public ISink<RiderRunSingleInspectionArgs> RunSingleInspection { get { return _RunSingleInspection; }}
    [NotNull] public IRdProperty<bool> PowerSaveEnabled { get { return _PowerSaveEnabled; }}
    [NotNull] public IViewableMap<int, RdTrackingSession> TrackingSessions { get { return _TrackingSessions; }}
    
    //private fields
    [NotNull] private readonly RdCall<ShowSeveritySelectionDialogModel, ShowSeveritySelectionDialogResultModel> _ShowSeverityDialog;
    [NotNull] private readonly RdMap<int, InspectionResultsModel> _InspectionsResultSessions;
    [NotNull] private readonly RdProperty<CustomInspectionScopeDialogArguments> _ShowCustomInspectionScopeDialog;
    [NotNull] private readonly RdEndpoint<RdVoid, RiderGetRunnableInspectionsCallResult> _GetRunnableInspections;
    [NotNull] private readonly RdSignal<RiderRunSingleInspectionArgs> _RunSingleInspection;
    [NotNull] private readonly RdProperty<bool> _PowerSaveEnabled;
    [NotNull] private readonly RdMap<int, RdTrackingSession> _TrackingSessions;
    
    //primary constructor
    private InspectionsModel(
      [NotNull] RdCall<ShowSeveritySelectionDialogModel, ShowSeveritySelectionDialogResultModel> showSeverityDialog,
      [NotNull] RdMap<int, InspectionResultsModel> inspectionsResultSessions,
      [NotNull] RdProperty<CustomInspectionScopeDialogArguments> showCustomInspectionScopeDialog,
      [NotNull] RdEndpoint<RdVoid, RiderGetRunnableInspectionsCallResult> getRunnableInspections,
      [NotNull] RdSignal<RiderRunSingleInspectionArgs> runSingleInspection,
      [NotNull] RdProperty<bool> powerSaveEnabled,
      [NotNull] RdMap<int, RdTrackingSession> trackingSessions
    )
    {
      if (showSeverityDialog == null) throw new ArgumentNullException("showSeverityDialog");
      if (inspectionsResultSessions == null) throw new ArgumentNullException("inspectionsResultSessions");
      if (showCustomInspectionScopeDialog == null) throw new ArgumentNullException("showCustomInspectionScopeDialog");
      if (getRunnableInspections == null) throw new ArgumentNullException("getRunnableInspections");
      if (runSingleInspection == null) throw new ArgumentNullException("runSingleInspection");
      if (powerSaveEnabled == null) throw new ArgumentNullException("powerSaveEnabled");
      if (trackingSessions == null) throw new ArgumentNullException("trackingSessions");
      
      _ShowSeverityDialog = showSeverityDialog;
      _InspectionsResultSessions = inspectionsResultSessions;
      _ShowCustomInspectionScopeDialog = showCustomInspectionScopeDialog;
      _GetRunnableInspections = getRunnableInspections;
      _RunSingleInspection = runSingleInspection;
      _PowerSaveEnabled = powerSaveEnabled;
      _TrackingSessions = trackingSessions;
      _PowerSaveEnabled.OptimizeNested = true;
      _GetRunnableInspections.Async = true;
      _ShowCustomInspectionScopeDialog.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("showSeverityDialog", _ShowSeverityDialog));
      BindableChildren.Add(new KeyValuePair<string, object>("inspectionsResultSessions", _InspectionsResultSessions));
      BindableChildren.Add(new KeyValuePair<string, object>("showCustomInspectionScopeDialog", _ShowCustomInspectionScopeDialog));
      BindableChildren.Add(new KeyValuePair<string, object>("getRunnableInspections", _GetRunnableInspections));
      BindableChildren.Add(new KeyValuePair<string, object>("runSingleInspection", _RunSingleInspection));
      BindableChildren.Add(new KeyValuePair<string, object>("powerSaveEnabled", _PowerSaveEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("trackingSessions", _TrackingSessions));
    }
    //secondary constructor
    private InspectionsModel (
    ) : this (
      new RdCall<ShowSeveritySelectionDialogModel, ShowSeveritySelectionDialogResultModel>(ShowSeveritySelectionDialogModel.Read, ShowSeveritySelectionDialogModel.Write, ShowSeveritySelectionDialogResultModel.Read, ShowSeveritySelectionDialogResultModel.Write),
      new RdMap<int, InspectionResultsModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, InspectionResultsModel.Read, InspectionResultsModel.Write),
      new RdProperty<CustomInspectionScopeDialogArguments>(ReadCustomInspectionScopeDialogArgumentsNullable, WriteCustomInspectionScopeDialogArgumentsNullable),
      new RdEndpoint<RdVoid, RiderGetRunnableInspectionsCallResult>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, RiderGetRunnableInspectionsCallResult.Read, RiderGetRunnableInspectionsCallResult.Write),
      new RdSignal<RiderRunSingleInspectionArgs>(RiderRunSingleInspectionArgs.Read, RiderRunSingleInspectionArgs.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdMap<int, RdTrackingSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdTrackingSession.Read, RdTrackingSession.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<CustomInspectionScopeDialogArguments> ReadCustomInspectionScopeDialogArgumentsNullable = CustomInspectionScopeDialogArguments.Read.NullableClass();
    
    public static CtxWriteDelegate<CustomInspectionScopeDialogArguments> WriteCustomInspectionScopeDialogArgumentsNullable = CustomInspectionScopeDialogArguments.Write.NullableClass();
    
    protected override long SerializationHash => -2381174581994793158L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(ShowSeveritySelectionDialogModel.Read, ShowSeveritySelectionDialogModel.Write);
      serializers.Register(ShowSeveritySelectionDialogResultModel.Read, ShowSeveritySelectionDialogResultModel.Write);
      serializers.Register(RdTrackingTreeNode.Read, RdTrackingTreeNode.Write);
      serializers.Register(InspectionResultsModel.Read, InspectionResultsModel.Write);
      serializers.Register(CustomInspectionScopeDialogArguments.Read, CustomInspectionScopeDialogArguments.Write);
      serializers.Register(RiderGetRunnableInspectionsCallResult.Read, RiderGetRunnableInspectionsCallResult.Write);
      serializers.Register(RiderRunSingleInspectionArgs.Read, RiderRunSingleInspectionArgs.Write);
      serializers.Register(RdTrackingSession.Read, RdTrackingSession.Write);
      serializers.Register(IssueModel.Read, IssueModel.Write);
      serializers.Register(InspectionResultNavigateTo.Read, InspectionResultNavigateTo.Write);
      serializers.Register(IssueGroupingObjectModel.Read, IssueGroupingObjectModel.Write);
      serializers.RegisterEnum<RiderInspectionScopeModel>();
      serializers.Register(RiderRunnableInspectionModel.Read, RiderRunnableInspectionModel.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public InspectionsModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InspectionsModel (");
      using (printer.IndentCookie()) {
        printer.Print("showSeverityDialog = "); _ShowSeverityDialog.PrintEx(printer); printer.Println();
        printer.Print("inspectionsResultSessions = "); _InspectionsResultSessions.PrintEx(printer); printer.Println();
        printer.Print("showCustomInspectionScopeDialog = "); _ShowCustomInspectionScopeDialog.PrintEx(printer); printer.Println();
        printer.Print("getRunnableInspections = "); _GetRunnableInspections.PrintEx(printer); printer.Println();
        printer.Print("runSingleInspection = "); _RunSingleInspection.PrintEx(printer); printer.Println();
        printer.Print("powerSaveEnabled = "); _PowerSaveEnabled.PrintEx(printer); printer.Println();
        printer.Print("trackingSessions = "); _TrackingSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CustomInspectionScopeDialogArguments : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public IRdProperty<RiderInspectionScopeModel> SelectedScope { get { return _SelectedScope; }}
    [CanBeNull] public string CurrentProjectName {get; private set;}
    [NotNull] public IRdProperty<string> ScopeText { get { return _ScopeText; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Refactorings.RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> ValidationResult { get { return _ValidationResult; }}
    [NotNull] public ISink<RdVoid> OkClicked { get { return _OkClicked; }}
    [NotNull] public ISink<RdVoid> CancelClicked { get { return _CancelClicked; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RiderInspectionScopeModel> _SelectedScope;
    [NotNull] private readonly RdProperty<string> _ScopeText;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Refactorings.RefactoringCompletionList> _CompletionList;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> _ValidationResult;
    [NotNull] private readonly RdSignal<RdVoid> _OkClicked;
    [NotNull] private readonly RdSignal<RdVoid> _CancelClicked;
    
    //primary constructor
    private CustomInspectionScopeDialogArguments(
      [NotNull] string title,
      [NotNull] RdProperty<RiderInspectionScopeModel> selectedScope,
      [CanBeNull] string currentProjectName,
      [NotNull] RdProperty<string> scopeText,
      [NotNull] RdProperty<JetBrains.Rider.Model.Refactorings.RefactoringCompletionList> completionList,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdSignal<RdVoid> okClicked,
      [NotNull] RdSignal<RdVoid> cancelClicked
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (selectedScope == null) throw new ArgumentNullException("selectedScope");
      if (scopeText == null) throw new ArgumentNullException("scopeText");
      if (completionList == null) throw new ArgumentNullException("completionList");
      if (validationResult == null) throw new ArgumentNullException("validationResult");
      if (okClicked == null) throw new ArgumentNullException("okClicked");
      if (cancelClicked == null) throw new ArgumentNullException("cancelClicked");
      
      Title = title;
      _SelectedScope = selectedScope;
      CurrentProjectName = currentProjectName;
      _ScopeText = scopeText;
      _CompletionList = completionList;
      _ValidationResult = validationResult;
      _OkClicked = okClicked;
      _CancelClicked = cancelClicked;
      _SelectedScope.OptimizeNested = true;
      _ScopeText.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("selectedScope", _SelectedScope));
      BindableChildren.Add(new KeyValuePair<string, object>("scopeText", _ScopeText));
      BindableChildren.Add(new KeyValuePair<string, object>("completionList", _CompletionList));
      BindableChildren.Add(new KeyValuePair<string, object>("validationResult", _ValidationResult));
      BindableChildren.Add(new KeyValuePair<string, object>("okClicked", _OkClicked));
      BindableChildren.Add(new KeyValuePair<string, object>("cancelClicked", _CancelClicked));
    }
    //secondary constructor
    public CustomInspectionScopeDialogArguments (
      [NotNull] string title,
      [CanBeNull] string currentProjectName
    ) : this (
      title,
      new RdProperty<RiderInspectionScopeModel>(ReadRiderInspectionScopeModel, WriteRiderInspectionScopeModel),
      currentProjectName,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<JetBrains.Rider.Model.Refactorings.RefactoringCompletionList>(JetBrains.Rider.Model.Refactorings.RefactoringCompletionList.Read, JetBrains.Rider.Model.Refactorings.RefactoringCompletionList.Write),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<CustomInspectionScopeDialogArguments> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var selectedScope = RdProperty<RiderInspectionScopeModel>.Read(ctx, reader, ReadRiderInspectionScopeModel, WriteRiderInspectionScopeModel);
      var currentProjectName = ReadStringNullable(ctx, reader);
      var scopeText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var completionList = RdProperty<JetBrains.Rider.Model.Refactorings.RefactoringCompletionList>.Read(ctx, reader, JetBrains.Rider.Model.Refactorings.RefactoringCompletionList.Read, JetBrains.Rider.Model.Refactorings.RefactoringCompletionList.Write);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var okClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var cancelClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new CustomInspectionScopeDialogArguments(title, selectedScope, currentProjectName, scopeText, completionList, validationResult, okClicked, cancelClicked).WithId(_id);
    };
    public static CtxReadDelegate<RiderInspectionScopeModel> ReadRiderInspectionScopeModel = new CtxReadDelegate<RiderInspectionScopeModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RiderInspectionScopeModel>);
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<CustomInspectionScopeDialogArguments> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      RdProperty<RiderInspectionScopeModel>.Write(ctx, writer, value._SelectedScope);
      WriteStringNullable(ctx, writer, value.CurrentProjectName);
      RdProperty<string>.Write(ctx, writer, value._ScopeText);
      RdProperty<JetBrains.Rider.Model.Refactorings.RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSignal<RdVoid>.Write(ctx, writer, value._OkClicked);
      RdSignal<RdVoid>.Write(ctx, writer, value._CancelClicked);
    };
    public static CtxWriteDelegate<RiderInspectionScopeModel> WriteRiderInspectionScopeModel = new CtxWriteDelegate<RiderInspectionScopeModel>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RiderInspectionScopeModel>);
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CustomInspectionScopeDialogArguments (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("selectedScope = "); _SelectedScope.PrintEx(printer); printer.Println();
        printer.Print("currentProjectName = "); CurrentProjectName.PrintEx(printer); printer.Println();
        printer.Print("scopeText = "); _ScopeText.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("okClicked = "); _OkClicked.PrintEx(printer); printer.Println();
        printer.Print("cancelClicked = "); _CancelClicked.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InspectionResultNavigateTo : IPrintable, IEquatable<InspectionResultNavigateTo>
  {
    //fields
    //public fields
    public int Index {get; private set;}
    public bool Activate {get; private set;}
    
    //private fields
    //primary constructor
    public InspectionResultNavigateTo(
      int index,
      bool activate
    )
    {
      Index = index;
      Activate = activate;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<InspectionResultNavigateTo> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var activate = reader.ReadBool();
      return new InspectionResultNavigateTo(index, activate);
    };
    
    public static CtxWriteDelegate<InspectionResultNavigateTo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      writer.Write(value.Activate);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((InspectionResultNavigateTo) obj);
    }
    public bool Equals(InspectionResultNavigateTo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Index == other.Index && Activate == other.Activate;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Index.GetHashCode();
        hash = hash * 31 + Activate.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("InspectionResultNavigateTo (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("activate = "); Activate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InspectionResultsModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string SearchLabel {get; private set;}
    [NotNull] public IViewableList<IssueModel> Issues { get { return _Issues; }}
    [NotNull] public IRdProperty<bool> IsCalculating { get { return _IsCalculating; }}
    [NotNull] public ISink<InspectionResultNavigateTo> NavigateTo { get { return _NavigateTo; }}
    [NotNull] public ISink<JetBrains.Rider.Model.RdUsageGroupNavigationData> NavigateToGroup { get { return _NavigateToGroup; }}
    [NotNull] public ISink<RdVoid> Close { get { return _Close; }}
    
    //private fields
    [NotNull] private readonly RdList<IssueModel> _Issues;
    [NotNull] private readonly RdProperty<bool> _IsCalculating;
    [NotNull] private readonly RdSignal<InspectionResultNavigateTo> _NavigateTo;
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.RdUsageGroupNavigationData> _NavigateToGroup;
    [NotNull] private readonly RdSignal<RdVoid> _Close;
    
    private SerializationCtx mySerializationContext;
    public override SerializationCtx SerializationContext { get { return mySerializationContext; } }
    //primary constructor
    private InspectionResultsModel(
      [NotNull] string searchLabel,
      [NotNull] RdList<IssueModel> issues,
      [NotNull] RdProperty<bool> isCalculating,
      [NotNull] RdSignal<InspectionResultNavigateTo> navigateTo,
      [NotNull] RdSignal<JetBrains.Rider.Model.RdUsageGroupNavigationData> navigateToGroup,
      [NotNull] RdSignal<RdVoid> close
    )
    {
      if (searchLabel == null) throw new ArgumentNullException("searchLabel");
      if (issues == null) throw new ArgumentNullException("issues");
      if (isCalculating == null) throw new ArgumentNullException("isCalculating");
      if (navigateTo == null) throw new ArgumentNullException("navigateTo");
      if (navigateToGroup == null) throw new ArgumentNullException("navigateToGroup");
      if (close == null) throw new ArgumentNullException("close");
      
      SearchLabel = searchLabel;
      _Issues = issues;
      _IsCalculating = isCalculating;
      _NavigateTo = navigateTo;
      _NavigateToGroup = navigateToGroup;
      _Close = close;
      _Issues.OptimizeNested = true;
      _IsCalculating.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("issues", _Issues));
      BindableChildren.Add(new KeyValuePair<string, object>("isCalculating", _IsCalculating));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateTo", _NavigateTo));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateToGroup", _NavigateToGroup));
      BindableChildren.Add(new KeyValuePair<string, object>("close", _Close));
    }
    //secondary constructor
    public InspectionResultsModel (
      [NotNull] string searchLabel
    ) : this (
      searchLabel,
      new RdList<IssueModel>(IssueModel.Read, IssueModel.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<InspectionResultNavigateTo>(InspectionResultNavigateTo.Read, InspectionResultNavigateTo.Write),
      new RdSignal<JetBrains.Rider.Model.RdUsageGroupNavigationData>(JetBrains.Rider.Model.RdUsageGroupNavigationData.Read, JetBrains.Rider.Model.RdUsageGroupNavigationData.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<InspectionResultsModel> Read = (ctx, reader) => 
    {
      ctx = ctx.WithInternRootHere(false);
      var _id = RdId.Read(reader);
      var searchLabel = reader.ReadString();
      var issues = RdList<IssueModel>.Read(ctx, reader, IssueModel.Read, IssueModel.Write);
      var isCalculating = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigateTo = RdSignal<InspectionResultNavigateTo>.Read(ctx, reader, InspectionResultNavigateTo.Read, InspectionResultNavigateTo.Write);
      var navigateToGroup = RdSignal<JetBrains.Rider.Model.RdUsageGroupNavigationData>.Read(ctx, reader, JetBrains.Rider.Model.RdUsageGroupNavigationData.Read, JetBrains.Rider.Model.RdUsageGroupNavigationData.Write);
      var close = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new InspectionResultsModel(searchLabel, issues, isCalculating, navigateTo, navigateToGroup, close) { mySerializationContext = ctx }.WithId(_id);
    };
    
    public static CtxWriteDelegate<InspectionResultsModel> Write = (ctx, writer, value) => 
    {
      ctx = ctx.WithInternRootHere(true);
      value.mySerializationContext = ctx;
      value.RdId.Write(writer);
      writer.Write(value.SearchLabel);
      RdList<IssueModel>.Write(ctx, writer, value._Issues);
      RdProperty<bool>.Write(ctx, writer, value._IsCalculating);
      RdSignal<InspectionResultNavigateTo>.Write(ctx, writer, value._NavigateTo);
      RdSignal<JetBrains.Rider.Model.RdUsageGroupNavigationData>.Write(ctx, writer, value._NavigateToGroup);
      RdSignal<RdVoid>.Write(ctx, writer, value._Close);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InspectionResultsModel (");
      using (printer.IndentCookie()) {
        printer.Print("searchLabel = "); SearchLabel.PrintEx(printer); printer.Println();
        printer.Print("issues = "); _Issues.PrintEx(printer); printer.Println();
        printer.Print("isCalculating = "); _IsCalculating.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("navigateToGroup = "); _NavigateToGroup.PrintEx(printer); printer.Println();
        printer.Print("close = "); _Close.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IssueGroupingObjectModel : IPrintable, IEquatable<IssueGroupingObjectModel>
  {
    //fields
    //public fields
    [NotNull] public string GroupName {get; private set;}
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public IssueGroupingObjectModel(
      [NotNull] string groupName,
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (groupName == null) throw new ArgumentNullException("groupName");
      if (text == null) throw new ArgumentNullException("text");
      
      GroupName = groupName;
      Text = text;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<IssueGroupingObjectModel> Read = (ctx, reader) => 
    {
      var groupName = reader.ReadString();
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new IssueGroupingObjectModel(groupName, text, icon);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<IssueGroupingObjectModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.GroupName);
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IssueGroupingObjectModel) obj);
    }
    public bool Equals(IssueGroupingObjectModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return GroupName == other.GroupName && Text == other.Text && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + GroupName.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IssueGroupingObjectModel (");
      using (printer.IndentCookie()) {
        printer.Print("groupName = "); GroupName.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IssueModel : IPrintable, IEquatable<IssueModel>
  {
    //fields
    //public fields
    public int Index {get; private set;}
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<IssueGroupingObjectModel> Groups {get; private set;}
    
    //private fields
    //primary constructor
    public IssueModel(
      int index,
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<IssueGroupingObjectModel> groups
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (groups == null) throw new ArgumentNullException("groups");
      
      Index = index;
      Text = text;
      Icon = icon;
      Groups = groups;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<IssueModel> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var text = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var icon = ReadIconNullable(ctx, reader);
      var groups = ReadIssueGroupingObjectModelInternedList(ctx, reader);
      return new IssueModel(index, text, icon, groups);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<IssueGroupingObjectModel>> ReadIssueGroupingObjectModelInternedList = IssueGroupingObjectModel.Read.Interned().List();
    
    public static CtxWriteDelegate<IssueModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      ctx.WriteInterned(writer, value.Text, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteIssueGroupingObjectModelInternedList(ctx, writer, value.Groups);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<IssueGroupingObjectModel>> WriteIssueGroupingObjectModelInternedList = IssueGroupingObjectModel.Write.Interned().List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IssueModel) obj);
    }
    public bool Equals(IssueModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Index == other.Index && Equals(Text, other.Text) && Equals(Icon, other.Icon) && Groups.SequenceEqual(other.Groups);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Index.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(Groups);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IssueModel (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTrackingSession : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public IRdProperty<RdTrackingTreeNode> TreeRoot { get { return _TreeRoot; }}
    [NotNull] public ISink<RdVoid> Close { get { return _Close; }}
    [NotNull] public List<string> PossibleQualifiers {get; private set;}
    [NotNull] public IRdProperty<int> SelectedQualifier { get { return _SelectedQualifier; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdTrackingTreeNode> _TreeRoot;
    [NotNull] private readonly RdSignal<RdVoid> _Close;
    [NotNull] private readonly RdProperty<int> _SelectedQualifier;
    
    //primary constructor
    private RdTrackingSession(
      [NotNull] string title,
      [NotNull] RdProperty<RdTrackingTreeNode> treeRoot,
      [NotNull] RdSignal<RdVoid> close,
      [NotNull] List<string> possibleQualifiers,
      [NotNull] RdProperty<int> selectedQualifier
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (treeRoot == null) throw new ArgumentNullException("treeRoot");
      if (close == null) throw new ArgumentNullException("close");
      if (possibleQualifiers == null) throw new ArgumentNullException("possibleQualifiers");
      if (selectedQualifier == null) throw new ArgumentNullException("selectedQualifier");
      
      Title = title;
      _TreeRoot = treeRoot;
      _Close = close;
      PossibleQualifiers = possibleQualifiers;
      _SelectedQualifier = selectedQualifier;
      _SelectedQualifier.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("treeRoot", _TreeRoot));
      BindableChildren.Add(new KeyValuePair<string, object>("close", _Close));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedQualifier", _SelectedQualifier));
    }
    //secondary constructor
    public RdTrackingSession (
      [NotNull] string title,
      [NotNull] List<string> possibleQualifiers
    ) : this (
      title,
      new RdProperty<RdTrackingTreeNode>(RdTrackingTreeNode.Read, RdTrackingTreeNode.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      possibleQualifiers,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdTrackingSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var treeRoot = RdProperty<RdTrackingTreeNode>.Read(ctx, reader, RdTrackingTreeNode.Read, RdTrackingTreeNode.Write);
      var close = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var possibleQualifiers = ReadStringList(ctx, reader);
      var selectedQualifier = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new RdTrackingSession(title, treeRoot, close, possibleQualifiers, selectedQualifier).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdTrackingSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      RdProperty<RdTrackingTreeNode>.Write(ctx, writer, value._TreeRoot);
      RdSignal<RdVoid>.Write(ctx, writer, value._Close);
      WriteStringList(ctx, writer, value.PossibleQualifiers);
      RdProperty<int>.Write(ctx, writer, value._SelectedQualifier);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTrackingSession (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("treeRoot = "); _TreeRoot.PrintEx(printer); printer.Println();
        printer.Print("close = "); _Close.PrintEx(printer); printer.Println();
        printer.Print("possibleQualifiers = "); PossibleQualifiers.PrintEx(printer); printer.Println();
        printer.Print("selectedQualifier = "); _SelectedQualifier.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTrackingTreeNode : RdBindableBase
  {
    //fields
    //public fields
    public int IndexOnInsertion {get; private set;}
    [NotNull] public List<JetBrains.Rider.Model.Icon> Icons {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.ModelRichText> Text { get { return _Text; }}
    public bool HasChildren {get; private set;}
    public bool IsCalculatingNode {get; private set;}
    [NotNull] public IRdProperty<bool> IsExpanded { get { return _IsExpanded; }}
    [NotNull] public ISink<bool> NavigateTo { get { return _NavigateTo; }}
    [NotNull] public IRdProperty<List<RdTrackingTreeNode>> Children { get { return _Children; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.ModelRichText> _Text;
    [NotNull] private readonly RdProperty<bool> _IsExpanded;
    [NotNull] private readonly RdSignal<bool> _NavigateTo;
    [NotNull] private readonly RdProperty<List<RdTrackingTreeNode>> _Children;
    
    //primary constructor
    private RdTrackingTreeNode(
      int indexOnInsertion,
      [NotNull] List<JetBrains.Rider.Model.Icon> icons,
      [NotNull] RdProperty<JetBrains.Rider.Model.ModelRichText> text,
      bool hasChildren,
      bool isCalculatingNode,
      [NotNull] RdProperty<bool> isExpanded,
      [NotNull] RdSignal<bool> navigateTo,
      [NotNull] RdProperty<List<RdTrackingTreeNode>> children
    )
    {
      if (icons == null) throw new ArgumentNullException("icons");
      if (text == null) throw new ArgumentNullException("text");
      if (isExpanded == null) throw new ArgumentNullException("isExpanded");
      if (navigateTo == null) throw new ArgumentNullException("navigateTo");
      if (children == null) throw new ArgumentNullException("children");
      
      IndexOnInsertion = indexOnInsertion;
      Icons = icons;
      _Text = text;
      HasChildren = hasChildren;
      IsCalculatingNode = isCalculatingNode;
      _IsExpanded = isExpanded;
      _NavigateTo = navigateTo;
      _Children = children;
      _Text.OptimizeNested = true;
      _IsExpanded.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("isExpanded", _IsExpanded));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateTo", _NavigateTo));
      BindableChildren.Add(new KeyValuePair<string, object>("children", _Children));
    }
    //secondary constructor
    public RdTrackingTreeNode (
      int indexOnInsertion,
      [NotNull] List<JetBrains.Rider.Model.Icon> icons,
      bool hasChildren,
      bool isCalculatingNode
    ) : this (
      indexOnInsertion,
      icons,
      new RdProperty<JetBrains.Rider.Model.ModelRichText>(JetBrains.Rider.Model.ModelRichText.Read, JetBrains.Rider.Model.ModelRichText.Write),
      hasChildren,
      isCalculatingNode,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<List<RdTrackingTreeNode>>(ReadRdTrackingTreeNodeList, WriteRdTrackingTreeNodeList)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdTrackingTreeNode> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var indexOnInsertion = reader.ReadInt();
      var icons = ReadIconList(ctx, reader);
      var text = RdProperty<JetBrains.Rider.Model.ModelRichText>.Read(ctx, reader, JetBrains.Rider.Model.ModelRichText.Read, JetBrains.Rider.Model.ModelRichText.Write);
      var hasChildren = reader.ReadBool();
      var isCalculatingNode = reader.ReadBool();
      var isExpanded = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigateTo = RdSignal<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var children = RdProperty<List<RdTrackingTreeNode>>.Read(ctx, reader, ReadRdTrackingTreeNodeList, WriteRdTrackingTreeNodeList);
      return new RdTrackingTreeNode(indexOnInsertion, icons, text, hasChildren, isCalculatingNode, isExpanded, navigateTo, children).WithId(_id);
    };
    public static CtxReadDelegate<List<JetBrains.Rider.Model.Icon>> ReadIconList = JetBrains.Rider.Model.Icon.Read.List();
    public static CtxReadDelegate<List<RdTrackingTreeNode>> ReadRdTrackingTreeNodeList = RdTrackingTreeNode.Read.List();
    
    public static CtxWriteDelegate<RdTrackingTreeNode> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.IndexOnInsertion);
      WriteIconList(ctx, writer, value.Icons);
      RdProperty<JetBrains.Rider.Model.ModelRichText>.Write(ctx, writer, value._Text);
      writer.Write(value.HasChildren);
      writer.Write(value.IsCalculatingNode);
      RdProperty<bool>.Write(ctx, writer, value._IsExpanded);
      RdSignal<bool>.Write(ctx, writer, value._NavigateTo);
      RdProperty<List<RdTrackingTreeNode>>.Write(ctx, writer, value._Children);
    };
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.Icon>> WriteIconList = JetBrains.Rider.Model.Icon.Write.List();
    public static CtxWriteDelegate<List<RdTrackingTreeNode>> WriteRdTrackingTreeNodeList = RdTrackingTreeNode.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTrackingTreeNode (");
      using (printer.IndentCookie()) {
        printer.Print("indexOnInsertion = "); IndexOnInsertion.PrintEx(printer); printer.Println();
        printer.Print("icons = "); Icons.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("hasChildren = "); HasChildren.PrintEx(printer); printer.Println();
        printer.Print("isCalculatingNode = "); IsCalculatingNode.PrintEx(printer); printer.Println();
        printer.Print("isExpanded = "); _IsExpanded.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("children = "); _Children.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RiderGetRunnableInspectionsCallResult : IPrintable, IEquatable<RiderGetRunnableInspectionsCallResult>
  {
    //fields
    //public fields
    [NotNull] public List<RiderRunnableInspectionModel> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RiderGetRunnableInspectionsCallResult(
      [NotNull] List<RiderRunnableInspectionModel> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderGetRunnableInspectionsCallResult> Read = (ctx, reader) => 
    {
      var items = ReadRiderRunnableInspectionModelList(ctx, reader);
      return new RiderGetRunnableInspectionsCallResult(items);
    };
    public static CtxReadDelegate<List<RiderRunnableInspectionModel>> ReadRiderRunnableInspectionModelList = RiderRunnableInspectionModel.Read.List();
    
    public static CtxWriteDelegate<RiderGetRunnableInspectionsCallResult> Write = (ctx, writer, value) => 
    {
      WriteRiderRunnableInspectionModelList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RiderRunnableInspectionModel>> WriteRiderRunnableInspectionModelList = RiderRunnableInspectionModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderGetRunnableInspectionsCallResult) obj);
    }
    public bool Equals(RiderGetRunnableInspectionsCallResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderGetRunnableInspectionsCallResult (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RiderInspectionScopeModel {
    Solution,
    Project,
    Custom
  }
  
  
  public class RiderRunSingleInspectionArgs : IPrintable, IEquatable<RiderRunSingleInspectionArgs>
  {
    //fields
    //public fields
    public int InspectionId {get; private set;}
    public int ProjectModelId {get; private set;}
    
    //private fields
    //primary constructor
    public RiderRunSingleInspectionArgs(
      int inspectionId,
      int projectModelId
    )
    {
      InspectionId = inspectionId;
      ProjectModelId = projectModelId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderRunSingleInspectionArgs> Read = (ctx, reader) => 
    {
      var inspectionId = reader.ReadInt();
      var projectModelId = reader.ReadInt();
      return new RiderRunSingleInspectionArgs(inspectionId, projectModelId);
    };
    
    public static CtxWriteDelegate<RiderRunSingleInspectionArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.InspectionId);
      writer.Write(value.ProjectModelId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderRunSingleInspectionArgs) obj);
    }
    public bool Equals(RiderRunSingleInspectionArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return InspectionId == other.InspectionId && ProjectModelId == other.ProjectModelId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + InspectionId.GetHashCode();
        hash = hash * 31 + ProjectModelId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderRunSingleInspectionArgs (");
      using (printer.IndentCookie()) {
        printer.Print("inspectionId = "); InspectionId.PrintEx(printer); printer.Println();
        printer.Print("projectModelId = "); ProjectModelId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RiderRunnableInspectionModel : IPrintable, IEquatable<RiderRunnableInspectionModel>
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [NotNull] public List<JetBrains.Rider.Model.RdLanguage> Languages {get; private set;}
    [NotNull] public string CategoryText {get; private set;}
    
    //private fields
    //primary constructor
    public RiderRunnableInspectionModel(
      [NotNull] string text,
      [NotNull] List<JetBrains.Rider.Model.RdLanguage> languages,
      [NotNull] string categoryText
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (languages == null) throw new ArgumentNullException("languages");
      if (categoryText == null) throw new ArgumentNullException("categoryText");
      
      Text = text;
      Languages = languages;
      CategoryText = categoryText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderRunnableInspectionModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var languages = ReadRdLanguageList(ctx, reader);
      var categoryText = reader.ReadString();
      return new RiderRunnableInspectionModel(text, languages, categoryText);
    };
    public static CtxReadDelegate<List<JetBrains.Rider.Model.RdLanguage>> ReadRdLanguageList = JetBrains.Rider.Model.RdLanguage.Read.List();
    
    public static CtxWriteDelegate<RiderRunnableInspectionModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      WriteRdLanguageList(ctx, writer, value.Languages);
      writer.Write(value.CategoryText);
    };
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.RdLanguage>> WriteRdLanguageList = JetBrains.Rider.Model.RdLanguage.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderRunnableInspectionModel) obj);
    }
    public bool Equals(RiderRunnableInspectionModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && Languages.SequenceEqual(other.Languages) && CategoryText == other.CategoryText;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Languages);
        hash = hash * 31 + CategoryText.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderRunnableInspectionModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("languages = "); Languages.PrintEx(printer); printer.Println();
        printer.Print("categoryText = "); CategoryText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ShowSeveritySelectionDialogModel : IPrintable, IEquatable<ShowSeveritySelectionDialogModel>
  {
    //fields
    //public fields
    [NotNull] public string HeaderText {get; private set;}
    [NotNull] public List<JetBrains.Rider.Model.SeverityElement> Severities {get; private set;}
    [NotNull] public List<JetBrains.Rider.Model.SettingsLayer> Layers {get; private set;}
    public int SelectedSeverity {get; private set;}
    
    //private fields
    //primary constructor
    public ShowSeveritySelectionDialogModel(
      [NotNull] string headerText,
      [NotNull] List<JetBrains.Rider.Model.SeverityElement> severities,
      [NotNull] List<JetBrains.Rider.Model.SettingsLayer> layers,
      int selectedSeverity
    )
    {
      if (headerText == null) throw new ArgumentNullException("headerText");
      if (severities == null) throw new ArgumentNullException("severities");
      if (layers == null) throw new ArgumentNullException("layers");
      
      HeaderText = headerText;
      Severities = severities;
      Layers = layers;
      SelectedSeverity = selectedSeverity;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ShowSeveritySelectionDialogModel> Read = (ctx, reader) => 
    {
      var headerText = reader.ReadString();
      var severities = ReadSeverityElementList(ctx, reader);
      var layers = ReadSettingsLayerList(ctx, reader);
      var selectedSeverity = reader.ReadInt();
      return new ShowSeveritySelectionDialogModel(headerText, severities, layers, selectedSeverity);
    };
    public static CtxReadDelegate<List<JetBrains.Rider.Model.SeverityElement>> ReadSeverityElementList = JetBrains.Rider.Model.SeverityElement.Read.List();
    public static CtxReadDelegate<List<JetBrains.Rider.Model.SettingsLayer>> ReadSettingsLayerList = JetBrains.Rider.Model.SettingsLayer.Read.List();
    
    public static CtxWriteDelegate<ShowSeveritySelectionDialogModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.HeaderText);
      WriteSeverityElementList(ctx, writer, value.Severities);
      WriteSettingsLayerList(ctx, writer, value.Layers);
      writer.Write(value.SelectedSeverity);
    };
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.SeverityElement>> WriteSeverityElementList = JetBrains.Rider.Model.SeverityElement.Write.List();
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.SettingsLayer>> WriteSettingsLayerList = JetBrains.Rider.Model.SettingsLayer.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ShowSeveritySelectionDialogModel) obj);
    }
    public bool Equals(ShowSeveritySelectionDialogModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return HeaderText == other.HeaderText && Severities.SequenceEqual(other.Severities) && Layers.SequenceEqual(other.Layers) && SelectedSeverity == other.SelectedSeverity;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + HeaderText.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Severities);
        hash = hash * 31 + Collections.GetHashCode(Layers);
        hash = hash * 31 + SelectedSeverity.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ShowSeveritySelectionDialogModel (");
      using (printer.IndentCookie()) {
        printer.Print("headerText = "); HeaderText.PrintEx(printer); printer.Println();
        printer.Print("severities = "); Severities.PrintEx(printer); printer.Println();
        printer.Print("layers = "); Layers.PrintEx(printer); printer.Println();
        printer.Print("selectedSeverity = "); SelectedSeverity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ShowSeveritySelectionDialogResultModel : IPrintable, IEquatable<ShowSeveritySelectionDialogResultModel>
  {
    //fields
    //public fields
    [CanBeNull] public int? SelectedSeverity {get; private set;}
    [CanBeNull] public int? SelectedLayer {get; private set;}
    
    //private fields
    //primary constructor
    public ShowSeveritySelectionDialogResultModel(
      [CanBeNull] int? selectedSeverity,
      [CanBeNull] int? selectedLayer
    )
    {
      SelectedSeverity = selectedSeverity;
      SelectedLayer = selectedLayer;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ShowSeveritySelectionDialogResultModel> Read = (ctx, reader) => 
    {
      var selectedSeverity = ReadIntNullable(ctx, reader);
      var selectedLayer = ReadIntNullable(ctx, reader);
      return new ShowSeveritySelectionDialogResultModel(selectedSeverity, selectedLayer);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<ShowSeveritySelectionDialogResultModel> Write = (ctx, writer, value) => 
    {
      WriteIntNullable(ctx, writer, value.SelectedSeverity);
      WriteIntNullable(ctx, writer, value.SelectedLayer);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ShowSeveritySelectionDialogResultModel) obj);
    }
    public bool Equals(ShowSeveritySelectionDialogResultModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(SelectedSeverity, other.SelectedSeverity) && Equals(SelectedLayer, other.SelectedLayer);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (SelectedSeverity != null ?SelectedSeverity.GetHashCode() : 0);
        hash = hash * 31 + (SelectedLayer != null ?SelectedLayer.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ShowSeveritySelectionDialogResultModel (");
      using (printer.IndentCookie()) {
        printer.Print("selectedSeverity = "); SelectedSeverity.PrintEx(printer); printer.Println();
        printer.Print("selectedLayer = "); SelectedLayer.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
