using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.MsBuildLogger
{
  
  
  public class MsBuildExeLoggerModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<MsBuildExeBuildModelInitialized> BuildModelInitialized { get { return _BuildModelInitialized; }}
    
    //private fields
    [NotNull] private readonly RdProperty<MsBuildExeBuildModelInitialized> _BuildModelInitialized;
    
    //primary constructor
    private MsBuildExeLoggerModel(
      [NotNull] RdProperty<MsBuildExeBuildModelInitialized> buildModelInitialized
    )
    {
      if (buildModelInitialized == null) throw new ArgumentNullException("buildModelInitialized");
      
      _BuildModelInitialized = buildModelInitialized;
      BindableChildren.Add(new KeyValuePair<string, object>("buildModelInitialized", _BuildModelInitialized));
    }
    //secondary constructor
    private MsBuildExeLoggerModel (
    ) : this (
      new RdProperty<MsBuildExeBuildModelInitialized>(MsBuildExeBuildModelInitialized.Read, MsBuildExeBuildModelInitialized.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 7170550044135728384L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<MsBuildExeEventKind>();
      serializers.Register(MsBuildExeBuildEvent.Read, MsBuildExeBuildEvent.Write);
      serializers.Register(MsBuildExeBuildOutputMessage.Read, MsBuildExeBuildOutputMessage.Write);
      serializers.Register(MsBuildExeBuildResult.Read, MsBuildExeBuildResult.Write);
      serializers.Register(MsBuildExeBuildModelWithParameters.Read, MsBuildExeBuildModelWithParameters.Write);
      serializers.RegisterEnum<MsBuildExeLogEntryType>();
      serializers.Register(MsBuildExeLogEntry.Read, MsBuildExeLogEntry.Write);
      serializers.Register(MsBuildExeBuildModelInitialized.Read, MsBuildExeBuildModelInitialized.Write);
      
      serializers.RegisterToplevelOnce(typeof(MsBuildExeLoggerModel), MsBuildExeLoggerModel.RegisterDeclaredTypesSerializers);
    }
    
    public MsBuildExeLoggerModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeLoggerModel (");
      using (printer.IndentCookie()) {
        printer.Print("buildModelInitialized = "); _BuildModelInitialized.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildEvent : IPrintable, IEquatable<MsBuildExeBuildEvent>
  {
    //fields
    //public fields
    public MsBuildExeEventKind Kind {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    [CanBeNull] public string Code {get; private set;}
    [CanBeNull] public string ProjectPath {get; private set;}
    [CanBeNull] public string FilePath {get; private set;}
    [CanBeNull] public int? Line {get; private set;}
    [CanBeNull] public int? Column {get; private set;}
    
    //private fields
    //primary constructor
    public MsBuildExeBuildEvent(
      MsBuildExeEventKind kind,
      [CanBeNull] string message,
      [CanBeNull] string code,
      [CanBeNull] string projectPath,
      [CanBeNull] string filePath,
      [CanBeNull] int? line,
      [CanBeNull] int? column
    )
    {
      Kind = kind;
      Message = message;
      Code = code;
      ProjectPath = projectPath;
      FilePath = filePath;
      Line = line;
      Column = column;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildEvent> Read = (ctx, reader) => 
    {
      var kind = (MsBuildExeEventKind)reader.ReadInt();
      var message = ReadStringNullable(ctx, reader);
      var code = ReadStringNullable(ctx, reader);
      var projectPath = ReadStringNullable(ctx, reader);
      var filePath = ReadStringNullable(ctx, reader);
      var line = ReadIntNullable(ctx, reader);
      var column = ReadIntNullable(ctx, reader);
      return new MsBuildExeBuildEvent(kind, message, code, projectPath, filePath, line, column);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<MsBuildExeBuildEvent> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteStringNullable(ctx, writer, value.Message);
      WriteStringNullable(ctx, writer, value.Code);
      WriteStringNullable(ctx, writer, value.ProjectPath);
      WriteStringNullable(ctx, writer, value.FilePath);
      WriteIntNullable(ctx, writer, value.Line);
      WriteIntNullable(ctx, writer, value.Column);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeBuildEvent) obj);
    }
    public bool Equals(MsBuildExeBuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(Message, other.Message) && Equals(Code, other.Code) && Equals(ProjectPath, other.ProjectPath) && Equals(FilePath, other.FilePath) && Equals(Line, other.Line) && Equals(Column, other.Column);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + (Message != null ?Message.GetHashCode() : 0);
        hash = hash * 31 + (Code != null ?Code.GetHashCode() : 0);
        hash = hash * 31 + (ProjectPath != null ?ProjectPath.GetHashCode() : 0);
        hash = hash * 31 + (FilePath != null ?FilePath.GetHashCode() : 0);
        hash = hash * 31 + (Line != null ?Line.GetHashCode() : 0);
        hash = hash * 31 + (Column != null ?Column.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("code = "); Code.PrintEx(printer); printer.Println();
        printer.Print("projectPath = "); ProjectPath.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("column = "); Column.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildModelInitialized : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<MsBuildExeBuildModelWithParameters> BuildModelWithParameters { get { return _BuildModelWithParameters; }}
    [NotNull] public ISink<MsBuildExeLogEntry> Log { get { return _Log; }}
    
    //private fields
    [NotNull] private readonly RdProperty<MsBuildExeBuildModelWithParameters> _BuildModelWithParameters;
    [NotNull] private readonly RdSignal<MsBuildExeLogEntry> _Log;
    
    //primary constructor
    private MsBuildExeBuildModelInitialized(
      [NotNull] RdProperty<MsBuildExeBuildModelWithParameters> buildModelWithParameters,
      [NotNull] RdSignal<MsBuildExeLogEntry> log
    )
    {
      if (buildModelWithParameters == null) throw new ArgumentNullException("buildModelWithParameters");
      if (log == null) throw new ArgumentNullException("log");
      
      _BuildModelWithParameters = buildModelWithParameters;
      _Log = log;
      BindableChildren.Add(new KeyValuePair<string, object>("buildModelWithParameters", _BuildModelWithParameters));
      BindableChildren.Add(new KeyValuePair<string, object>("log", _Log));
    }
    //secondary constructor
    public MsBuildExeBuildModelInitialized (
    ) : this (
      new RdProperty<MsBuildExeBuildModelWithParameters>(MsBuildExeBuildModelWithParameters.Read, MsBuildExeBuildModelWithParameters.Write),
      new RdSignal<MsBuildExeLogEntry>(MsBuildExeLogEntry.Read, MsBuildExeLogEntry.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildModelInitialized> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var buildModelWithParameters = RdProperty<MsBuildExeBuildModelWithParameters>.Read(ctx, reader, MsBuildExeBuildModelWithParameters.Read, MsBuildExeBuildModelWithParameters.Write);
      var log = RdSignal<MsBuildExeLogEntry>.Read(ctx, reader, MsBuildExeLogEntry.Read, MsBuildExeLogEntry.Write);
      return new MsBuildExeBuildModelInitialized(buildModelWithParameters, log).WithId(_id);
    };
    
    public static CtxWriteDelegate<MsBuildExeBuildModelInitialized> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<MsBuildExeBuildModelWithParameters>.Write(ctx, writer, value._BuildModelWithParameters);
      RdSignal<MsBuildExeLogEntry>.Write(ctx, writer, value._Log);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildModelInitialized (");
      using (printer.IndentCookie()) {
        printer.Print("buildModelWithParameters = "); _BuildModelWithParameters.PrintEx(printer); printer.Println();
        printer.Print("log = "); _Log.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildModelWithParameters : RdBindableBase
  {
    //fields
    //public fields
    public bool IsMsBuild {get; private set;}
    [NotNull] public List<string> LoadedProjectPaths {get; private set;}
    [NotNull] public ISink<MsBuildExeBuildEvent> Events { get { return _Events; }}
    [NotNull] public ISink<MsBuildExeBuildOutputMessage> Output { get { return _Output; }}
    [NotNull] public ISink<MsBuildExeBuildResult> BuildDone { get { return _BuildDone; }}
    [NotNull] public ISink<string> ProjectFinished { get { return _ProjectFinished; }}
    [NotNull] public ISink<string> ProjectStarted { get { return _ProjectStarted; }}
    
    //private fields
    [NotNull] private readonly RdSignal<MsBuildExeBuildEvent> _Events;
    [NotNull] private readonly RdSignal<MsBuildExeBuildOutputMessage> _Output;
    [NotNull] private readonly RdSignal<MsBuildExeBuildResult> _BuildDone;
    [NotNull] private readonly RdSignal<string> _ProjectFinished;
    [NotNull] private readonly RdSignal<string> _ProjectStarted;
    
    //primary constructor
    private MsBuildExeBuildModelWithParameters(
      bool isMsBuild,
      [NotNull] List<string> loadedProjectPaths,
      [NotNull] RdSignal<MsBuildExeBuildEvent> events,
      [NotNull] RdSignal<MsBuildExeBuildOutputMessage> output,
      [NotNull] RdSignal<MsBuildExeBuildResult> buildDone,
      [NotNull] RdSignal<string> projectFinished,
      [NotNull] RdSignal<string> projectStarted
    )
    {
      if (loadedProjectPaths == null) throw new ArgumentNullException("loadedProjectPaths");
      if (events == null) throw new ArgumentNullException("events");
      if (output == null) throw new ArgumentNullException("output");
      if (buildDone == null) throw new ArgumentNullException("buildDone");
      if (projectFinished == null) throw new ArgumentNullException("projectFinished");
      if (projectStarted == null) throw new ArgumentNullException("projectStarted");
      
      IsMsBuild = isMsBuild;
      LoadedProjectPaths = loadedProjectPaths;
      _Events = events;
      _Output = output;
      _BuildDone = buildDone;
      _ProjectFinished = projectFinished;
      _ProjectStarted = projectStarted;
      BindableChildren.Add(new KeyValuePair<string, object>("events", _Events));
      BindableChildren.Add(new KeyValuePair<string, object>("output", _Output));
      BindableChildren.Add(new KeyValuePair<string, object>("buildDone", _BuildDone));
      BindableChildren.Add(new KeyValuePair<string, object>("projectFinished", _ProjectFinished));
      BindableChildren.Add(new KeyValuePair<string, object>("projectStarted", _ProjectStarted));
    }
    //secondary constructor
    public MsBuildExeBuildModelWithParameters (
      bool isMsBuild,
      [NotNull] List<string> loadedProjectPaths
    ) : this (
      isMsBuild,
      loadedProjectPaths,
      new RdSignal<MsBuildExeBuildEvent>(MsBuildExeBuildEvent.Read, MsBuildExeBuildEvent.Write),
      new RdSignal<MsBuildExeBuildOutputMessage>(MsBuildExeBuildOutputMessage.Read, MsBuildExeBuildOutputMessage.Write),
      new RdSignal<MsBuildExeBuildResult>(MsBuildExeBuildResult.Read, MsBuildExeBuildResult.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildModelWithParameters> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var isMsBuild = reader.ReadBool();
      var loadedProjectPaths = ReadStringList(ctx, reader);
      var events = RdSignal<MsBuildExeBuildEvent>.Read(ctx, reader, MsBuildExeBuildEvent.Read, MsBuildExeBuildEvent.Write);
      var output = RdSignal<MsBuildExeBuildOutputMessage>.Read(ctx, reader, MsBuildExeBuildOutputMessage.Read, MsBuildExeBuildOutputMessage.Write);
      var buildDone = RdSignal<MsBuildExeBuildResult>.Read(ctx, reader, MsBuildExeBuildResult.Read, MsBuildExeBuildResult.Write);
      var projectFinished = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var projectStarted = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new MsBuildExeBuildModelWithParameters(isMsBuild, loadedProjectPaths, events, output, buildDone, projectFinished, projectStarted).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<MsBuildExeBuildModelWithParameters> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.IsMsBuild);
      WriteStringList(ctx, writer, value.LoadedProjectPaths);
      RdSignal<MsBuildExeBuildEvent>.Write(ctx, writer, value._Events);
      RdSignal<MsBuildExeBuildOutputMessage>.Write(ctx, writer, value._Output);
      RdSignal<MsBuildExeBuildResult>.Write(ctx, writer, value._BuildDone);
      RdSignal<string>.Write(ctx, writer, value._ProjectFinished);
      RdSignal<string>.Write(ctx, writer, value._ProjectStarted);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildModelWithParameters (");
      using (printer.IndentCookie()) {
        printer.Print("isMsBuild = "); IsMsBuild.PrintEx(printer); printer.Println();
        printer.Print("loadedProjectPaths = "); LoadedProjectPaths.PrintEx(printer); printer.Println();
        printer.Print("events = "); _Events.PrintEx(printer); printer.Println();
        printer.Print("output = "); _Output.PrintEx(printer); printer.Println();
        printer.Print("buildDone = "); _BuildDone.PrintEx(printer); printer.Println();
        printer.Print("projectFinished = "); _ProjectFinished.PrintEx(printer); printer.Println();
        printer.Print("projectStarted = "); _ProjectStarted.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildOutputMessage : IPrintable, IEquatable<MsBuildExeBuildOutputMessage>
  {
    //fields
    //public fields
    [NotNull] public string Message {get; private set;}
    public MsBuildExeEventKind Kind {get; private set;}
    public int Indent {get; private set;}
    
    //private fields
    //primary constructor
    public MsBuildExeBuildOutputMessage(
      [NotNull] string message,
      MsBuildExeEventKind kind,
      int indent
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      
      Message = message;
      Kind = kind;
      Indent = indent;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildOutputMessage> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      var kind = (MsBuildExeEventKind)reader.ReadInt();
      var indent = reader.ReadInt();
      return new MsBuildExeBuildOutputMessage(message, kind, indent);
    };
    
    public static CtxWriteDelegate<MsBuildExeBuildOutputMessage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
      writer.Write((int)value.Kind);
      writer.Write(value.Indent);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeBuildOutputMessage) obj);
    }
    public bool Equals(MsBuildExeBuildOutputMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Message == other.Message && Kind == other.Kind && Indent == other.Indent;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Message.GetHashCode();
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + Indent.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildOutputMessage (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildResult : IPrintable, IEquatable<MsBuildExeBuildResult>
  {
    //fields
    //public fields
    public bool Success {get; private set;}
    
    //private fields
    //primary constructor
    public MsBuildExeBuildResult(
      bool success
    )
    {
      Success = success;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildResult> Read = (ctx, reader) => 
    {
      var success = reader.ReadBool();
      return new MsBuildExeBuildResult(success);
    };
    
    public static CtxWriteDelegate<MsBuildExeBuildResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Success);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeBuildResult) obj);
    }
    public bool Equals(MsBuildExeBuildResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Success == other.Success;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Success.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildResult (");
      using (printer.IndentCookie()) {
        printer.Print("success = "); Success.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MsBuildExeEventKind {
    Error,
    Warning,
    Other
  }
  
  
  public class MsBuildExeLogEntry : IPrintable, IEquatable<MsBuildExeLogEntry>
  {
    //fields
    //public fields
    [NotNull] public string LogMessage {get; private set;}
    public MsBuildExeLogEntryType Severity {get; private set;}
    
    //private fields
    //primary constructor
    public MsBuildExeLogEntry(
      [NotNull] string logMessage,
      MsBuildExeLogEntryType severity
    )
    {
      if (logMessage == null) throw new ArgumentNullException("logMessage");
      
      LogMessage = logMessage;
      Severity = severity;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MsBuildExeLogEntry> Read = (ctx, reader) => 
    {
      var logMessage = reader.ReadString();
      var severity = (MsBuildExeLogEntryType)reader.ReadInt();
      return new MsBuildExeLogEntry(logMessage, severity);
    };
    
    public static CtxWriteDelegate<MsBuildExeLogEntry> Write = (ctx, writer, value) => 
    {
      writer.Write(value.LogMessage);
      writer.Write((int)value.Severity);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeLogEntry) obj);
    }
    public bool Equals(MsBuildExeLogEntry other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return LogMessage == other.LogMessage && Severity == other.Severity;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + LogMessage.GetHashCode();
        hash = hash * 31 + (int) Severity;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeLogEntry (");
      using (printer.IndentCookie()) {
        printer.Print("logMessage = "); LogMessage.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MsBuildExeLogEntryType {
    ERROR,
    WARN,
    INFO,
    VERBOSE,
    TRACE
  }
}
