using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Popups
{
  
  
  public class PopupInteractionModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdPopupMenuModel> Popups { get { return _Popups; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdPopupMenuModel> _Popups;
    
    //primary constructor
    private PopupInteractionModel(
      [NotNull] RdMap<int, RdPopupMenuModel> popups
    )
    {
      if (popups == null) throw new ArgumentNullException("popups");
      
      _Popups = popups;
      BindableChildren.Add(new KeyValuePair<string, object>("popups", _Popups));
    }
    //secondary constructor
    private PopupInteractionModel (
    ) : this (
      new RdMap<int, RdPopupMenuModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdPopupMenuModel.Read, RdPopupMenuModel.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 6807019328293149969L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<RdPopupMenuItemKind>();
      serializers.Register(RdPopupMenuModelItem.Read, RdPopupMenuModelItem.Write);
      serializers.Register(RdDefaultPopupWindowContext.Read, RdDefaultPopupWindowContext.Write);
      serializers.Register(RdMainWindowCenteredPopupWindowContext.Read, RdMainWindowCenteredPopupWindowContext.Write);
      serializers.Register(RdGutterMarkPopupWindowContext.Read, RdGutterMarkPopupWindowContext.Write);
      serializers.Register(RdFrontendComponentWindowContext.Read, RdFrontendComponentWindowContext.Write);
      serializers.Register(RdRichTextMultiLineViewModel.Read, RdRichTextMultiLineViewModel.Write);
      serializers.Register(RdThemedIconViewModel.Read, RdThemedIconViewModel.Write);
      serializers.Register(RdPresentableItemViewModel.Read, RdPresentableItemViewModel.Write);
      serializers.Register(RdRichTextWithProgressViewModel.Read, RdRichTextWithProgressViewModel.Write);
      serializers.Register(RdButtonViewModel.Read, RdButtonViewModel.Write);
      serializers.Register(ButtonCollection.Read, ButtonCollection.Write);
      serializers.Register(RdTitleModel.Read, RdTitleModel.Write);
      serializers.Register(RdFilterModel.Read, RdFilterModel.Write);
      serializers.Register(RdPopupSelection.Read, RdPopupSelection.Write);
      serializers.Register(CanceledPopupMenuMarker.Read, CanceledPopupMenuMarker.Write);
      serializers.Register(RdEmptyPopupMenuModel.Read, RdEmptyPopupMenuModel.Write);
      serializers.Register(RdExpandSubmenuRequest.Read, RdExpandSubmenuRequest.Write);
      serializers.Register(RdPopupSubmenuModel.Read, RdPopupSubmenuModel.Write);
      serializers.Register(RdPopupMenuModel.Read, RdPopupMenuModel.Write);
      serializers.Register(RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write);
      serializers.Register(RdPopupWindowContextBase_Unknown.Read, RdPopupWindowContextBase_Unknown.Write);
      serializers.Register(ProtoViewModel_Unknown.Read, ProtoViewModel_Unknown.Write);
      serializers.Register(IRdPopupMenuModel_Unknown.Read, IRdPopupMenuModel_Unknown.Write);
      serializers.Register(RdPopupMenuModelBase_Unknown.Read, RdPopupMenuModelBase_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public PopupInteractionModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PopupInteractionModel (");
      using (printer.IndentCookie()) {
        printer.Print("popups = "); _Popups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ButtonCollection : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<RdButtonViewModel> Buttons {get; private set;}
    
    //private fields
    //primary constructor
    public ButtonCollection(
      [NotNull] List<RdButtonViewModel> buttons
    )
    {
      if (buttons == null) throw new ArgumentNullException("buttons");
      
      Buttons = buttons;
      BindableChildren.Add(new KeyValuePair<string, object>("buttons", Buttons));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ButtonCollection> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var buttons = ReadRdButtonViewModelList(ctx, reader);
      return new ButtonCollection(buttons).WithId(_id);
    };
    public static CtxReadDelegate<List<RdButtonViewModel>> ReadRdButtonViewModelList = RdButtonViewModel.Read.List();
    
    public static CtxWriteDelegate<ButtonCollection> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdButtonViewModelList(ctx, writer, value.Buttons);
    };
    public static CtxWriteDelegate<List<RdButtonViewModel>> WriteRdButtonViewModelList = RdButtonViewModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ButtonCollection (");
      using (printer.IndentCookie()) {
        printer.Print("buttons = "); Buttons.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CanceledPopupMenuMarker : IRdPopupMenuModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CanceledPopupMenuMarker> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new CanceledPopupMenuMarker().WithId(_id);
    };
    
    public static new CtxWriteDelegate<CanceledPopupMenuMarker> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CanceledPopupMenuMarker (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class IRdPopupMenuModel : RdBindableBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<IRdPopupMenuModel> Read = Polymorphic<IRdPopupMenuModel>.ReadAbstract(IRdPopupMenuModel_Unknown.Read);
    
    public static CtxWriteDelegate<IRdPopupMenuModel> Write = Polymorphic<IRdPopupMenuModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class IRdPopupMenuModel_Unknown : IRdPopupMenuModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<IRdPopupMenuModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new IRdPopupMenuModel_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<IRdPopupMenuModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IRdPopupMenuModel_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ProtoViewModel : RdBindableBase, JetBrains.Application.UI.UIAutomation.IAutomation
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProtoViewModel> Read = Polymorphic<ProtoViewModel>.ReadAbstract(ProtoViewModel_Unknown.Read);
    
    public static CtxWriteDelegate<ProtoViewModel> Write = Polymorphic<ProtoViewModel>.Write;
    //custom body
    public event System.ComponentModel.PropertyChangedEventHandler PropertyChanged;
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class ProtoViewModel_Unknown : ProtoViewModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ProtoViewModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new ProtoViewModel_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<ProtoViewModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProtoViewModel_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdButtonViewModel : ProtoViewModel
  {
    //fields
    //public fields
    [CanBeNull] public string Tooltip {get; private set;}
    [CanBeNull] public string Shortcut {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public ISink<RdVoid> Execute { get { return _Execute; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Execute;
    
    //primary constructor
    private RdButtonViewModel(
      [CanBeNull] string tooltip,
      [CanBeNull] string shortcut,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdSignal<RdVoid> execute
    )
    {
      if (execute == null) throw new ArgumentNullException("execute");
      
      Tooltip = tooltip;
      Shortcut = shortcut;
      Icon = icon;
      _Execute = execute;
      BindableChildren.Add(new KeyValuePair<string, object>("execute", _Execute));
    }
    //secondary constructor
    public RdButtonViewModel (
      [CanBeNull] string tooltip,
      [CanBeNull] string shortcut,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      tooltip,
      shortcut,
      icon,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdButtonViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var tooltip = ReadStringNullable(ctx, reader);
      var shortcut = ReadStringNullable(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var execute = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdButtonViewModel(tooltip, shortcut, icon, execute).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdButtonViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Tooltip);
      WriteStringNullable(ctx, writer, value.Shortcut);
      WriteIconNullable(ctx, writer, value.Icon);
      RdSignal<RdVoid>.Write(ctx, writer, value._Execute);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdButtonViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("shortcut = "); Shortcut.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("execute = "); _Execute.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDefaultPopupWindowContext : RdPopupWindowContextBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdDefaultPopupWindowContext> Read = (ctx, reader) => 
    {
      return new RdDefaultPopupWindowContext();
    };
    
    public static new CtxWriteDelegate<RdDefaultPopupWindowContext> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDefaultPopupWindowContext) obj);
    }
    public bool Equals(RdDefaultPopupWindowContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDefaultPopupWindowContext (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEmptyPopupMenuModel : IRdPopupMenuModel
  {
    //fields
    //public fields
    [NotNull] public List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps {get; private set;}
    
    //private fields
    //primary constructor
    public RdEmptyPopupMenuModel(
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps
    )
    {
      if (timestamps == null) throw new ArgumentNullException("timestamps");
      
      Timestamps = timestamps;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEmptyPopupMenuModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var timestamps = ReadContextPairList(ctx, reader);
      return new RdEmptyPopupMenuModel(timestamps).WithId(_id);
    };
    public static CtxReadDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> ReadContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Read.List();
    
    public static new CtxWriteDelegate<RdEmptyPopupMenuModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteContextPairList(ctx, writer, value.Timestamps);
    };
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> WriteContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEmptyPopupMenuModel (");
      using (printer.IndentCookie()) {
        printer.Print("timestamps = "); Timestamps.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExpandSubmenuRequest : RdBindableBase
  {
    //fields
    //public fields
    public int ExpandedItem {get; private set;}
    [NotNull] public IRdProperty<RdPopupMenuModelBase> Submenu { get { return _Submenu; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdPopupMenuModelBase> _Submenu;
    
    //primary constructor
    private RdExpandSubmenuRequest(
      int expandedItem,
      [NotNull] RdProperty<RdPopupMenuModelBase> submenu
    )
    {
      if (submenu == null) throw new ArgumentNullException("submenu");
      
      ExpandedItem = expandedItem;
      _Submenu = submenu;
      BindableChildren.Add(new KeyValuePair<string, object>("submenu", _Submenu));
    }
    //secondary constructor
    public RdExpandSubmenuRequest (
      int expandedItem
    ) : this (
      expandedItem,
      new RdProperty<RdPopupMenuModelBase>(RdPopupMenuModelBase.Read, RdPopupMenuModelBase.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdExpandSubmenuRequest> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var expandedItem = reader.ReadInt();
      var submenu = RdProperty<RdPopupMenuModelBase>.Read(ctx, reader, RdPopupMenuModelBase.Read, RdPopupMenuModelBase.Write);
      return new RdExpandSubmenuRequest(expandedItem, submenu).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdExpandSubmenuRequest> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ExpandedItem);
      RdProperty<RdPopupMenuModelBase>.Write(ctx, writer, value._Submenu);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdExpandSubmenuRequest (");
      using (printer.IndentCookie()) {
        printer.Print("expandedItem = "); ExpandedItem.PrintEx(printer); printer.Println();
        printer.Print("submenu = "); _Submenu.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFilterModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> SearchString { get { return _SearchString; }}
    [NotNull] public IRdProperty<bool> IsValid { get { return _IsValid; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _SearchString;
    [NotNull] private readonly RdProperty<bool> _IsValid;
    
    //primary constructor
    private RdFilterModel(
      [NotNull] RdProperty<string> searchString,
      [NotNull] RdProperty<bool> isValid
    )
    {
      if (searchString == null) throw new ArgumentNullException("searchString");
      if (isValid == null) throw new ArgumentNullException("isValid");
      
      _SearchString = searchString;
      _IsValid = isValid;
      _SearchString.OptimizeNested = true;
      _IsValid.OptimizeNested = true;
      _SearchString.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("searchString", _SearchString));
      BindableChildren.Add(new KeyValuePair<string, object>("isValid", _IsValid));
    }
    //secondary constructor
    public RdFilterModel (
    ) : this (
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdFilterModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var searchString = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var isValid = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdFilterModel(searchString, isValid).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdFilterModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._SearchString);
      RdProperty<bool>.Write(ctx, writer, value._IsValid);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFilterModel (");
      using (printer.IndentCookie()) {
        printer.Print("searchString = "); _SearchString.PrintEx(printer); printer.Println();
        printer.Print("isValid = "); _IsValid.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFrontendComponentWindowContext : RdPopupWindowContextBase
  {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    
    //private fields
    //primary constructor
    public RdFrontendComponentWindowContext(
      [NotNull] string id
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      
      Id = id;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdFrontendComponentWindowContext> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      return new RdFrontendComponentWindowContext(id);
    };
    
    public static new CtxWriteDelegate<RdFrontendComponentWindowContext> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFrontendComponentWindowContext) obj);
    }
    public bool Equals(RdFrontendComponentWindowContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFrontendComponentWindowContext (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGutterMarkPopupWindowContext : RdPopupWindowContextBase
  {
    //fields
    //public fields
    public int DocOffset {get; private set;}
    
    //private fields
    //primary constructor
    public RdGutterMarkPopupWindowContext(
      int docOffset
    )
    {
      DocOffset = docOffset;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdGutterMarkPopupWindowContext> Read = (ctx, reader) => 
    {
      var docOffset = reader.ReadInt();
      return new RdGutterMarkPopupWindowContext(docOffset);
    };
    
    public static new CtxWriteDelegate<RdGutterMarkPopupWindowContext> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DocOffset);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGutterMarkPopupWindowContext) obj);
    }
    public bool Equals(RdGutterMarkPopupWindowContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DocOffset == other.DocOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DocOffset.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGutterMarkPopupWindowContext (");
      using (printer.IndentCookie()) {
        printer.Print("docOffset = "); DocOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMainWindowCenteredPopupWindowContext : RdPopupWindowContextBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdMainWindowCenteredPopupWindowContext> Read = (ctx, reader) => 
    {
      return new RdMainWindowCenteredPopupWindowContext();
    };
    
    public static new CtxWriteDelegate<RdMainWindowCenteredPopupWindowContext> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdMainWindowCenteredPopupWindowContext) obj);
    }
    public bool Equals(RdMainWindowCenteredPopupWindowContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdMainWindowCenteredPopupWindowContext (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdPopupMenuItemKind {
    ErrorFix,
    InspectionFix,
    Intention,
    Gutter,
    Notification,
    Other
  }
  
  
  public class RdPopupMenuModel : RdPopupMenuModelBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdExpandSubmenuRequest> ExpandSubmenu { get { return _ExpandSubmenu; }}
    [NotNull] public List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps {get; private set;}
    [NotNull] public RdPopupWindowContextBase Context {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<RdExpandSubmenuRequest> _ExpandSubmenu;
    
    //primary constructor
    private RdPopupMenuModel(
      [NotNull] RdProperty<RdExpandSubmenuRequest> expandSubmenu,
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps,
      [NotNull] RdPopupWindowContextBase context,
      [NotNull] RdProperty<RdPopupMenuModelItems> items,
      [NotNull] RdEndpoint<int, bool> executeItem,
      [NotNull] RdProperty<RdPopupSelection> selectedItem,
      [NotNull] RdTitleModel toolbar,
      [NotNull] RdFilterModel filter,
      [CanBeNull] string footer,
      bool modal,
      bool useProtocolSearch,
      [NotNull] RdProperty<bool> isPrepared
    ) : base (
      items,
      executeItem,
      selectedItem,
      toolbar,
      filter,
      footer,
      modal,
      useProtocolSearch,
      isPrepared
     ) 
    {
      if (expandSubmenu == null) throw new ArgumentNullException("expandSubmenu");
      if (timestamps == null) throw new ArgumentNullException("timestamps");
      if (context == null) throw new ArgumentNullException("context");
      
      _ExpandSubmenu = expandSubmenu;
      Timestamps = timestamps;
      Context = context;
      _ExpandSubmenu.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("expandSubmenu", _ExpandSubmenu));
    }
    //secondary constructor
    public RdPopupMenuModel (
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps,
      [NotNull] RdPopupWindowContextBase context,
      [CanBeNull] string footer,
      bool modal,
      bool useProtocolSearch
    ) : this (
      new RdProperty<RdExpandSubmenuRequest>(ReadRdExpandSubmenuRequestNullable, WriteRdExpandSubmenuRequestNullable),
      timestamps,
      context,
      new RdProperty<RdPopupMenuModelItems>(RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write),
      new RdEndpoint<int, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<RdPopupSelection>(RdPopupSelection.Read, RdPopupSelection.Write),
      new RdTitleModel(),
      new RdFilterModel(),
      footer,
      modal,
      useProtocolSearch,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdPopupMenuModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = RdProperty<RdPopupMenuModelItems>.Read(ctx, reader, RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write);
      var executeItem = RdEndpoint<int, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var selectedItem = RdProperty<RdPopupSelection>.Read(ctx, reader, RdPopupSelection.Read, RdPopupSelection.Write);
      var toolbar = RdTitleModel.Read(ctx, reader);
      var filter = RdFilterModel.Read(ctx, reader);
      var footer = ReadStringNullable(ctx, reader);
      var modal = reader.ReadBool();
      var useProtocolSearch = reader.ReadBool();
      var isPrepared = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var expandSubmenu = RdProperty<RdExpandSubmenuRequest>.Read(ctx, reader, ReadRdExpandSubmenuRequestNullable, WriteRdExpandSubmenuRequestNullable);
      var timestamps = ReadContextPairList(ctx, reader);
      var context = RdPopupWindowContextBase.Read(ctx, reader);
      return new RdPopupMenuModel(expandSubmenu, timestamps, context, items, executeItem, selectedItem, toolbar, filter, footer, modal, useProtocolSearch, isPrepared).WithId(_id);
    };
    public static CtxReadDelegate<RdExpandSubmenuRequest> ReadRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Read.NullableClass();
    public static CtxReadDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> ReadContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Read.List();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdPopupMenuModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<RdPopupMenuModelItems>.Write(ctx, writer, value._Items);
      RdEndpoint<int, bool>.Write(ctx, writer, value._ExecuteItem);
      RdProperty<RdPopupSelection>.Write(ctx, writer, value._SelectedItem);
      RdTitleModel.Write(ctx, writer, value.Toolbar);
      RdFilterModel.Write(ctx, writer, value.Filter);
      WriteStringNullable(ctx, writer, value.Footer);
      writer.Write(value.Modal);
      writer.Write(value.UseProtocolSearch);
      RdProperty<bool>.Write(ctx, writer, value._IsPrepared);
      RdProperty<RdExpandSubmenuRequest>.Write(ctx, writer, value._ExpandSubmenu);
      WriteContextPairList(ctx, writer, value.Timestamps);
      RdPopupWindowContextBase.Write(ctx, writer, value.Context);
    };
    public static CtxWriteDelegate<RdExpandSubmenuRequest> WriteRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Write.NullableClass();
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> WriteContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Write.List();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupMenuModel (");
      using (printer.IndentCookie()) {
        printer.Print("expandSubmenu = "); _ExpandSubmenu.PrintEx(printer); printer.Println();
        printer.Print("timestamps = "); Timestamps.PrintEx(printer); printer.Println();
        printer.Print("context = "); Context.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("executeItem = "); _ExecuteItem.PrintEx(printer); printer.Println();
        printer.Print("selectedItem = "); _SelectedItem.PrintEx(printer); printer.Println();
        printer.Print("toolbar = "); Toolbar.PrintEx(printer); printer.Println();
        printer.Print("filter = "); Filter.PrintEx(printer); printer.Println();
        printer.Print("footer = "); Footer.PrintEx(printer); printer.Println();
        printer.Print("modal = "); Modal.PrintEx(printer); printer.Println();
        printer.Print("useProtocolSearch = "); UseProtocolSearch.PrintEx(printer); printer.Println();
        printer.Print("isPrepared = "); _IsPrepared.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdPopupMenuModelBase : IRdPopupMenuModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdPopupMenuModelItems> Items { get { return _Items; }}
    [NotNull] public RdEndpoint<int, bool> ExecuteItem { get { return _ExecuteItem; }}
    [NotNull] public IRdProperty<RdPopupSelection> SelectedItem { get { return _SelectedItem; }}
    [NotNull] public RdTitleModel Toolbar {get; private set;}
    [NotNull] public RdFilterModel Filter {get; private set;}
    [CanBeNull] public string Footer {get; private set;}
    public bool Modal {get; private set;}
    public bool UseProtocolSearch {get; private set;}
    [NotNull] public IRdProperty<bool> IsPrepared { get { return _IsPrepared; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<RdPopupMenuModelItems> _Items;
    [NotNull] protected readonly RdEndpoint<int, bool> _ExecuteItem;
    [NotNull] protected readonly RdProperty<RdPopupSelection> _SelectedItem;
    [NotNull] protected readonly RdProperty<bool> _IsPrepared;
    
    //primary constructor
    protected RdPopupMenuModelBase(
      [NotNull] RdProperty<RdPopupMenuModelItems> items,
      [NotNull] RdEndpoint<int, bool> executeItem,
      [NotNull] RdProperty<RdPopupSelection> selectedItem,
      [NotNull] RdTitleModel toolbar,
      [NotNull] RdFilterModel filter,
      [CanBeNull] string footer,
      bool modal,
      bool useProtocolSearch,
      [NotNull] RdProperty<bool> isPrepared
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      if (executeItem == null) throw new ArgumentNullException("executeItem");
      if (selectedItem == null) throw new ArgumentNullException("selectedItem");
      if (toolbar == null) throw new ArgumentNullException("toolbar");
      if (filter == null) throw new ArgumentNullException("filter");
      if (isPrepared == null) throw new ArgumentNullException("isPrepared");
      
      _Items = items;
      _ExecuteItem = executeItem;
      _SelectedItem = selectedItem;
      Toolbar = toolbar;
      Filter = filter;
      Footer = footer;
      Modal = modal;
      UseProtocolSearch = useProtocolSearch;
      _IsPrepared = isPrepared;
      _IsPrepared.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
      BindableChildren.Add(new KeyValuePair<string, object>("executeItem", _ExecuteItem));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedItem", _SelectedItem));
      BindableChildren.Add(new KeyValuePair<string, object>("toolbar", Toolbar));
      BindableChildren.Add(new KeyValuePair<string, object>("filter", Filter));
      BindableChildren.Add(new KeyValuePair<string, object>("isPrepared", _IsPrepared));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdPopupMenuModelBase> Read = Polymorphic<RdPopupMenuModelBase>.ReadAbstract(RdPopupMenuModelBase_Unknown.Read);
    
    public static new CtxWriteDelegate<RdPopupMenuModelBase> Write = Polymorphic<RdPopupMenuModelBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdPopupMenuModelBase_Unknown : RdPopupMenuModelBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private RdPopupMenuModelBase_Unknown(
      [NotNull] RdProperty<RdPopupMenuModelItems> items,
      [NotNull] RdEndpoint<int, bool> executeItem,
      [NotNull] RdProperty<RdPopupSelection> selectedItem,
      [NotNull] RdTitleModel toolbar,
      [NotNull] RdFilterModel filter,
      [CanBeNull] string footer,
      bool modal,
      bool useProtocolSearch,
      [NotNull] RdProperty<bool> isPrepared
    ) : base (
      items,
      executeItem,
      selectedItem,
      toolbar,
      filter,
      footer,
      modal,
      useProtocolSearch,
      isPrepared
     ) 
    {
    }
    //secondary constructor
    public RdPopupMenuModelBase_Unknown (
      [CanBeNull] string footer,
      bool modal,
      bool useProtocolSearch
    ) : this (
      new RdProperty<RdPopupMenuModelItems>(RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write),
      new RdEndpoint<int, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<RdPopupSelection>(RdPopupSelection.Read, RdPopupSelection.Write),
      new RdTitleModel(),
      new RdFilterModel(),
      footer,
      modal,
      useProtocolSearch,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdPopupMenuModelBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = RdProperty<RdPopupMenuModelItems>.Read(ctx, reader, RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write);
      var executeItem = RdEndpoint<int, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var selectedItem = RdProperty<RdPopupSelection>.Read(ctx, reader, RdPopupSelection.Read, RdPopupSelection.Write);
      var toolbar = RdTitleModel.Read(ctx, reader);
      var filter = RdFilterModel.Read(ctx, reader);
      var footer = ReadStringNullable(ctx, reader);
      var modal = reader.ReadBool();
      var useProtocolSearch = reader.ReadBool();
      var isPrepared = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdPopupMenuModelBase_Unknown(items, executeItem, selectedItem, toolbar, filter, footer, modal, useProtocolSearch, isPrepared).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdPopupMenuModelBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<RdPopupMenuModelItems>.Write(ctx, writer, value._Items);
      RdEndpoint<int, bool>.Write(ctx, writer, value._ExecuteItem);
      RdProperty<RdPopupSelection>.Write(ctx, writer, value._SelectedItem);
      RdTitleModel.Write(ctx, writer, value.Toolbar);
      RdFilterModel.Write(ctx, writer, value.Filter);
      WriteStringNullable(ctx, writer, value.Footer);
      writer.Write(value.Modal);
      writer.Write(value.UseProtocolSearch);
      RdProperty<bool>.Write(ctx, writer, value._IsPrepared);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupMenuModelBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("executeItem = "); _ExecuteItem.PrintEx(printer); printer.Println();
        printer.Print("selectedItem = "); _SelectedItem.PrintEx(printer); printer.Println();
        printer.Print("toolbar = "); Toolbar.PrintEx(printer); printer.Println();
        printer.Print("filter = "); Filter.PrintEx(printer); printer.Println();
        printer.Print("footer = "); Footer.PrintEx(printer); printer.Println();
        printer.Print("modal = "); Modal.PrintEx(printer); printer.Println();
        printer.Print("useProtocolSearch = "); UseProtocolSearch.PrintEx(printer); printer.Println();
        printer.Print("isPrepared = "); _IsPrepared.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupMenuModelItem : IPrintable, IEquatable<RdPopupMenuModelItem>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon OptionalIcon {get; private set;}
    [NotNull] public JetBrains.Rider.Model.ModelRichText Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.ModelRichText OptionalText {get; private set;}
    [CanBeNull] public string ActionId {get; private set;}
    [CanBeNull] public string Tooltip {get; private set;}
    public bool IsSeparator {get; private set;}
    public bool IsEnabled {get; private set;}
    public bool CanExpand {get; private set;}
    public bool IsGroupHeader {get; private set;}
    [CanBeNull] public List<RdPopupMenuModelItem> SubItems {get; private set;}
    public RdPopupMenuItemKind Kind {get; private set;}
    
    //private fields
    //primary constructor
    public RdPopupMenuModelItem(
      int itemId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [CanBeNull] JetBrains.Rider.Model.Icon optionalIcon,
      [NotNull] JetBrains.Rider.Model.ModelRichText text,
      [CanBeNull] JetBrains.Rider.Model.ModelRichText optionalText,
      [CanBeNull] string actionId,
      [CanBeNull] string tooltip,
      bool isSeparator,
      bool isEnabled,
      bool canExpand,
      bool isGroupHeader,
      [CanBeNull] List<RdPopupMenuModelItem> subItems,
      RdPopupMenuItemKind kind
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      ItemId = itemId;
      Icon = icon;
      OptionalIcon = optionalIcon;
      Text = text;
      OptionalText = optionalText;
      ActionId = actionId;
      Tooltip = tooltip;
      IsSeparator = isSeparator;
      IsEnabled = isEnabled;
      CanExpand = canExpand;
      IsGroupHeader = isGroupHeader;
      SubItems = subItems;
      Kind = kind;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdPopupMenuModelItem> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var icon = ReadIconNullable(ctx, reader);
      var optionalIcon = ReadIconNullable(ctx, reader);
      var text = JetBrains.Rider.Model.ModelRichText.Read(ctx, reader);
      var optionalText = ReadModelRichTextNullable(ctx, reader);
      var actionId = ReadStringNullable(ctx, reader);
      var tooltip = ReadStringNullable(ctx, reader);
      var isSeparator = reader.ReadBool();
      var isEnabled = reader.ReadBool();
      var canExpand = reader.ReadBool();
      var isGroupHeader = reader.ReadBool();
      var subItems = ReadRdPopupMenuModelItemListNullable(ctx, reader);
      var kind = (RdPopupMenuItemKind)reader.ReadInt();
      return new RdPopupMenuModelItem(itemId, icon, optionalIcon, text, optionalText, actionId, tooltip, isSeparator, isEnabled, canExpand, isGroupHeader, subItems, kind);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.ModelRichText> ReadModelRichTextNullable = JetBrains.Rider.Model.ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdPopupMenuModelItem>> ReadRdPopupMenuModelItemListNullable = RdPopupMenuModelItem.Read.List().NullableClass();
    
    public static CtxWriteDelegate<RdPopupMenuModelItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteIconNullable(ctx, writer, value.OptionalIcon);
      JetBrains.Rider.Model.ModelRichText.Write(ctx, writer, value.Text);
      WriteModelRichTextNullable(ctx, writer, value.OptionalText);
      WriteStringNullable(ctx, writer, value.ActionId);
      WriteStringNullable(ctx, writer, value.Tooltip);
      writer.Write(value.IsSeparator);
      writer.Write(value.IsEnabled);
      writer.Write(value.CanExpand);
      writer.Write(value.IsGroupHeader);
      WriteRdPopupMenuModelItemListNullable(ctx, writer, value.SubItems);
      writer.Write((int)value.Kind);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.ModelRichText> WriteModelRichTextNullable = JetBrains.Rider.Model.ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdPopupMenuModelItem>> WriteRdPopupMenuModelItemListNullable = RdPopupMenuModelItem.Write.List().NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdPopupMenuModelItem) obj);
    }
    public bool Equals(RdPopupMenuModelItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && Equals(Icon, other.Icon) && Equals(OptionalIcon, other.OptionalIcon) && Equals(Text, other.Text) && Equals(OptionalText, other.OptionalText) && Equals(ActionId, other.ActionId) && Equals(Tooltip, other.Tooltip) && IsSeparator == other.IsSeparator && IsEnabled == other.IsEnabled && CanExpand == other.CanExpand && IsGroupHeader == other.IsGroupHeader && Equals(SubItems, other.SubItems) && Kind == other.Kind;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + (OptionalIcon != null ?OptionalIcon.GetHashCode() : 0);
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + (OptionalText != null ?OptionalText.GetHashCode() : 0);
        hash = hash * 31 + (ActionId != null ?ActionId.GetHashCode() : 0);
        hash = hash * 31 + (Tooltip != null ?Tooltip.GetHashCode() : 0);
        hash = hash * 31 + IsSeparator.GetHashCode();
        hash = hash * 31 + IsEnabled.GetHashCode();
        hash = hash * 31 + CanExpand.GetHashCode();
        hash = hash * 31 + IsGroupHeader.GetHashCode();
        hash = hash * 31 + (SubItems != null ?Collections.GetHashCode(SubItems) : 0);
        hash = hash * 31 + (int) Kind;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupMenuModelItem (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("optionalIcon = "); OptionalIcon.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("optionalText = "); OptionalText.PrintEx(printer); printer.Println();
        printer.Print("actionId = "); ActionId.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("isSeparator = "); IsSeparator.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("canExpand = "); CanExpand.PrintEx(printer); printer.Println();
        printer.Print("isGroupHeader = "); IsGroupHeader.PrintEx(printer); printer.Println();
        printer.Print("subItems = "); SubItems.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupMenuModelItems : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<RdPopupMenuModelItem> Value {get; private set;}
    public int SelectedIndex {get; private set;}
    public int Version {get; private set;}
    
    //private fields
    //primary constructor
    public RdPopupMenuModelItems(
      [NotNull] List<RdPopupMenuModelItem> value,
      int selectedIndex,
      int version
    )
    {
      if (value == null) throw new ArgumentNullException("value");
      
      Value = value;
      SelectedIndex = selectedIndex;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdPopupMenuModelItems> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var value = ReadRdPopupMenuModelItemList(ctx, reader);
      var selectedIndex = reader.ReadInt();
      var version = reader.ReadInt();
      return new RdPopupMenuModelItems(value, selectedIndex, version).WithId(_id);
    };
    public static CtxReadDelegate<List<RdPopupMenuModelItem>> ReadRdPopupMenuModelItemList = RdPopupMenuModelItem.Read.List();
    
    public static CtxWriteDelegate<RdPopupMenuModelItems> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdPopupMenuModelItemList(ctx, writer, value.Value);
      writer.Write(value.SelectedIndex);
      writer.Write(value.Version);
    };
    public static CtxWriteDelegate<List<RdPopupMenuModelItem>> WriteRdPopupMenuModelItemList = RdPopupMenuModelItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupMenuModelItems (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupSelection : RdBindableBase
  {
    //fields
    //public fields
    [CanBeNull] public int? ItemId {get; private set;}
    public int Version {get; private set;}
    
    //private fields
    //primary constructor
    public RdPopupSelection(
      [CanBeNull] int? itemId,
      int version
    )
    {
      ItemId = itemId;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdPopupSelection> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var itemId = ReadIntNullable(ctx, reader);
      var version = reader.ReadInt();
      return new RdPopupSelection(itemId, version).WithId(_id);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<RdPopupSelection> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteIntNullable(ctx, writer, value.ItemId);
      writer.Write(value.Version);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupSelection (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupSubmenuModel : RdPopupMenuModelBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdExpandSubmenuRequest> ExpandSubmenu { get { return _ExpandSubmenu; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdExpandSubmenuRequest> _ExpandSubmenu;
    
    //primary constructor
    private RdPopupSubmenuModel(
      [NotNull] RdProperty<RdExpandSubmenuRequest> expandSubmenu,
      [NotNull] RdProperty<RdPopupMenuModelItems> items,
      [NotNull] RdEndpoint<int, bool> executeItem,
      [NotNull] RdProperty<RdPopupSelection> selectedItem,
      [NotNull] RdTitleModel toolbar,
      [NotNull] RdFilterModel filter,
      [CanBeNull] string footer,
      bool modal,
      bool useProtocolSearch,
      [NotNull] RdProperty<bool> isPrepared
    ) : base (
      items,
      executeItem,
      selectedItem,
      toolbar,
      filter,
      footer,
      modal,
      useProtocolSearch,
      isPrepared
     ) 
    {
      if (expandSubmenu == null) throw new ArgumentNullException("expandSubmenu");
      
      _ExpandSubmenu = expandSubmenu;
      _ExpandSubmenu.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("expandSubmenu", _ExpandSubmenu));
    }
    //secondary constructor
    public RdPopupSubmenuModel (
      [CanBeNull] string footer,
      bool modal,
      bool useProtocolSearch
    ) : this (
      new RdProperty<RdExpandSubmenuRequest>(ReadRdExpandSubmenuRequestNullable, WriteRdExpandSubmenuRequestNullable),
      new RdProperty<RdPopupMenuModelItems>(RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write),
      new RdEndpoint<int, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<RdPopupSelection>(RdPopupSelection.Read, RdPopupSelection.Write),
      new RdTitleModel(),
      new RdFilterModel(),
      footer,
      modal,
      useProtocolSearch,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdPopupSubmenuModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = RdProperty<RdPopupMenuModelItems>.Read(ctx, reader, RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write);
      var executeItem = RdEndpoint<int, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var selectedItem = RdProperty<RdPopupSelection>.Read(ctx, reader, RdPopupSelection.Read, RdPopupSelection.Write);
      var toolbar = RdTitleModel.Read(ctx, reader);
      var filter = RdFilterModel.Read(ctx, reader);
      var footer = ReadStringNullable(ctx, reader);
      var modal = reader.ReadBool();
      var useProtocolSearch = reader.ReadBool();
      var isPrepared = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var expandSubmenu = RdProperty<RdExpandSubmenuRequest>.Read(ctx, reader, ReadRdExpandSubmenuRequestNullable, WriteRdExpandSubmenuRequestNullable);
      return new RdPopupSubmenuModel(expandSubmenu, items, executeItem, selectedItem, toolbar, filter, footer, modal, useProtocolSearch, isPrepared).WithId(_id);
    };
    public static CtxReadDelegate<RdExpandSubmenuRequest> ReadRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdPopupSubmenuModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<RdPopupMenuModelItems>.Write(ctx, writer, value._Items);
      RdEndpoint<int, bool>.Write(ctx, writer, value._ExecuteItem);
      RdProperty<RdPopupSelection>.Write(ctx, writer, value._SelectedItem);
      RdTitleModel.Write(ctx, writer, value.Toolbar);
      RdFilterModel.Write(ctx, writer, value.Filter);
      WriteStringNullable(ctx, writer, value.Footer);
      writer.Write(value.Modal);
      writer.Write(value.UseProtocolSearch);
      RdProperty<bool>.Write(ctx, writer, value._IsPrepared);
      RdProperty<RdExpandSubmenuRequest>.Write(ctx, writer, value._ExpandSubmenu);
    };
    public static CtxWriteDelegate<RdExpandSubmenuRequest> WriteRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupSubmenuModel (");
      using (printer.IndentCookie()) {
        printer.Print("expandSubmenu = "); _ExpandSubmenu.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("executeItem = "); _ExecuteItem.PrintEx(printer); printer.Println();
        printer.Print("selectedItem = "); _SelectedItem.PrintEx(printer); printer.Println();
        printer.Print("toolbar = "); Toolbar.PrintEx(printer); printer.Println();
        printer.Print("filter = "); Filter.PrintEx(printer); printer.Println();
        printer.Print("footer = "); Footer.PrintEx(printer); printer.Println();
        printer.Print("modal = "); Modal.PrintEx(printer); printer.Println();
        printer.Print("useProtocolSearch = "); UseProtocolSearch.PrintEx(printer); printer.Println();
        printer.Print("isPrepared = "); _IsPrepared.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdPopupWindowContextBase{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdPopupWindowContextBase> Read = Polymorphic<RdPopupWindowContextBase>.ReadAbstract(RdPopupWindowContextBase_Unknown.Read);
    
    public static CtxWriteDelegate<RdPopupWindowContextBase> Write = Polymorphic<RdPopupWindowContextBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdPopupWindowContextBase_Unknown : RdPopupWindowContextBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdPopupWindowContextBase_Unknown> Read = (ctx, reader) => 
    {
      return new RdPopupWindowContextBase_Unknown();
    };
    
    public static new CtxWriteDelegate<RdPopupWindowContextBase_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdPopupWindowContextBase_Unknown) obj);
    }
    public bool Equals(RdPopupWindowContextBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupWindowContextBase_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPresentableItemViewModel : ProtoViewModel
  {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public JetBrains.Rider.Model.ModelRichText Title {get; private set;}
    
    //private fields
    //primary constructor
    public RdPresentableItemViewModel(
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] JetBrains.Rider.Model.ModelRichText title
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      
      Icon = icon;
      Title = title;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdPresentableItemViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var icon = ReadIconNullable(ctx, reader);
      var title = JetBrains.Rider.Model.ModelRichText.Read(ctx, reader);
      return new RdPresentableItemViewModel(icon, title).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdPresentableItemViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteIconNullable(ctx, writer, value.Icon);
      JetBrains.Rider.Model.ModelRichText.Write(ctx, writer, value.Title);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPresentableItemViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRichTextMultiLineViewModel : ProtoViewModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> HtmlTextBlock { get { return _HtmlTextBlock; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _HtmlTextBlock;
    
    //primary constructor
    private RdRichTextMultiLineViewModel(
      [NotNull] RdProperty<string> htmlTextBlock
    )
    {
      if (htmlTextBlock == null) throw new ArgumentNullException("htmlTextBlock");
      
      _HtmlTextBlock = htmlTextBlock;
      _HtmlTextBlock.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("htmlTextBlock", _HtmlTextBlock));
    }
    //secondary constructor
    public RdRichTextMultiLineViewModel (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdRichTextMultiLineViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var htmlTextBlock = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RdRichTextMultiLineViewModel(htmlTextBlock).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdRichTextMultiLineViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._HtmlTextBlock);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdRichTextMultiLineViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("htmlTextBlock = "); _HtmlTextBlock.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRichTextWithProgressViewModel : ProtoViewModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> HtmlTextBlock { get { return _HtmlTextBlock; }}
    [NotNull] public IRdProperty<double> Fraction { get { return _Fraction; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _HtmlTextBlock;
    [NotNull] private readonly RdProperty<double> _Fraction;
    
    //primary constructor
    private RdRichTextWithProgressViewModel(
      [NotNull] RdProperty<string> htmlTextBlock,
      [NotNull] RdProperty<double> fraction
    )
    {
      if (htmlTextBlock == null) throw new ArgumentNullException("htmlTextBlock");
      if (fraction == null) throw new ArgumentNullException("fraction");
      
      _HtmlTextBlock = htmlTextBlock;
      _Fraction = fraction;
      _HtmlTextBlock.OptimizeNested = true;
      _Fraction.OptimizeNested = true;
      _HtmlTextBlock.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("htmlTextBlock", _HtmlTextBlock));
      BindableChildren.Add(new KeyValuePair<string, object>("fraction", _Fraction));
    }
    //secondary constructor
    public RdRichTextWithProgressViewModel (
    ) : this (
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdRichTextWithProgressViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var htmlTextBlock = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var fraction = RdProperty<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      return new RdRichTextWithProgressViewModel(htmlTextBlock, fraction).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdRichTextWithProgressViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._HtmlTextBlock);
      RdProperty<double>.Write(ctx, writer, value._Fraction);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdRichTextWithProgressViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("htmlTextBlock = "); _HtmlTextBlock.PrintEx(printer); printer.Println();
        printer.Print("fraction = "); _Fraction.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdThemedIconViewModel : ProtoViewModel
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdThemedIconViewModel(
      [NotNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (icon == null) throw new ArgumentNullException("icon");
      
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdThemedIconViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      return new RdThemedIconViewModel(icon).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdThemedIconViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdThemedIconViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTitleModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<ProtoViewModel> Caption { get { return _Caption; }}
    [NotNull] public IRdProperty<ButtonCollection> Buttons { get { return _Buttons; }}
    
    //private fields
    [NotNull] private readonly RdProperty<ProtoViewModel> _Caption;
    [NotNull] private readonly RdProperty<ButtonCollection> _Buttons;
    
    //primary constructor
    private RdTitleModel(
      [NotNull] RdProperty<ProtoViewModel> caption,
      [NotNull] RdProperty<ButtonCollection> buttons
    )
    {
      if (caption == null) throw new ArgumentNullException("caption");
      if (buttons == null) throw new ArgumentNullException("buttons");
      
      _Caption = caption;
      _Buttons = buttons;
      _Caption.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("caption", _Caption));
      BindableChildren.Add(new KeyValuePair<string, object>("buttons", _Buttons));
    }
    //secondary constructor
    public RdTitleModel (
    ) : this (
      new RdProperty<ProtoViewModel>(ReadProtoViewModelNullable, WriteProtoViewModelNullable),
      new RdProperty<ButtonCollection>(ButtonCollection.Read, ButtonCollection.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdTitleModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var caption = RdProperty<ProtoViewModel>.Read(ctx, reader, ReadProtoViewModelNullable, WriteProtoViewModelNullable);
      var buttons = RdProperty<ButtonCollection>.Read(ctx, reader, ButtonCollection.Read, ButtonCollection.Write);
      return new RdTitleModel(caption, buttons).WithId(_id);
    };
    public static CtxReadDelegate<ProtoViewModel> ReadProtoViewModelNullable = ProtoViewModel.Read.NullableClass();
    
    public static CtxWriteDelegate<RdTitleModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<ProtoViewModel>.Write(ctx, writer, value._Caption);
      RdProperty<ButtonCollection>.Write(ctx, writer, value._Buttons);
    };
    public static CtxWriteDelegate<ProtoViewModel> WriteProtoViewModelNullable = ProtoViewModel.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTitleModel (");
      using (printer.IndentCookie()) {
        printer.Print("caption = "); _Caption.PrintEx(printer); printer.Println();
        printer.Print("buttons = "); _Buttons.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
