using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class ProjectModelTasks : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<RdAddItemCommand, ProjectModelTaskResult> AddItem { get { return _AddItem; }}
    [NotNull] public RdEndpoint<AddProjectCommand, ProjectModelTaskResult> AddProject { get { return _AddProject; }}
    [NotNull] public RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult> AddSolutionFolder { get { return _AddSolutionFolder; }}
    [NotNull] public RdEndpoint<RdCopyItemsCommand, ProjectModelTaskResult> Copy { get { return _Copy; }}
    [NotNull] public RdEndpoint<RdMoveItemsCommand, ProjectModelTaskResult> Move { get { return _Move; }}
    [NotNull] public RdEndpoint<RemoveCommand, ProjectModelTaskResult> Remove { get { return _Remove; }}
    [NotNull] public RdEndpoint<RdRenameItemsCommand, ProjectModelTaskResult> Rename { get { return _Rename; }}
    [NotNull] public RdEndpoint<ExcludeCommand, ProjectModelTaskResult> Exclude { get { return _Exclude; }}
    [NotNull] public RdEndpoint<RdUpdateItemPropertiesCommand, ProjectModelTaskResult> UpdateItemProperties { get { return _UpdateItemProperties; }}
    [NotNull] public RdEndpoint<UnloadCommand, RdVoid> UnloadProjects { get { return _UnloadProjects; }}
    [NotNull] public RdEndpoint<ReloadCommand, RdVoid> ReloadProjects { get { return _ReloadProjects; }}
    [NotNull] public RdEndpoint<ReloadAndShowLogCommand, RdVoid> ReloadProjectAndShowLog { get { return _ReloadProjectAndShowLog; }}
    [NotNull] public RdEndpoint<RdExecuteCustomToolCommand, RdVoid> ExecuteCustomTool { get { return _ExecuteCustomTool; }}
    [NotNull] public RdEndpoint<RdChangeProjectPropertiesCommand, RdVoid> ChangeProjectProperties { get { return _ChangeProjectProperties; }}
    [NotNull] public IViewableMap<int, RdEditPropertiesSession> EditPropertiesSessions { get { return _EditPropertiesSessions; }}
    [NotNull] public IViewableMap<int, RdAddReferenceSession> AddReferenceSessions { get { return _AddReferenceSessions; }}
    [NotNull] public IViewableMap<int, RdAddWebReferenceSession> AddWebReferenceSessions { get { return _AddWebReferenceSessions; }}
    [NotNull] public IViewableMap<int, RdProjectTargetFramework> TargetFrameworks { get { return _TargetFrameworks; }}
    [NotNull] public RdEndpoint<RdProjectModelDumpParams, string> DumpProjectModel { get { return _DumpProjectModel; }}
    [NotNull] public RdEndpoint<RdVoid, string> DumpAssemblies { get { return _DumpAssemblies; }}
    [NotNull] public RdEndpoint<RdVoid, string> DumpPsiModules { get { return _DumpPsiModules; }}
    [NotNull] public RdEndpoint<RdVoid, string> DumpTargetFrameworkIds { get { return _DumpTargetFrameworkIds; }}
    [NotNull] public RdEndpoint<RdVoid, string> DumpPlatforms { get { return _DumpPlatforms; }}
    [NotNull] public RdEndpoint<RdVoid, int> GetSolutionReloadCounter { get { return _GetSolutionReloadCounter; }}
    [NotNull] public ISource<RdRenameProjectEvent> ProjectRenamed { get { return _ProjectRenamed; }}
    [NotNull] public RdDotNetCoreTasks DotNetCoreTasks {get; private set;}
    [NotNull] public IRdProperty<bool> DotNetCoreReloading { get { return _DotNetCoreReloading; }}
    [NotNull] public IRdProperty<bool> SyncExecuteCustomTool { get { return _SyncExecuteCustomTool; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<RdAddItemCommand, ProjectModelTaskResult> _AddItem;
    [NotNull] private readonly RdEndpoint<AddProjectCommand, ProjectModelTaskResult> _AddProject;
    [NotNull] private readonly RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult> _AddSolutionFolder;
    [NotNull] private readonly RdEndpoint<RdCopyItemsCommand, ProjectModelTaskResult> _Copy;
    [NotNull] private readonly RdEndpoint<RdMoveItemsCommand, ProjectModelTaskResult> _Move;
    [NotNull] private readonly RdEndpoint<RemoveCommand, ProjectModelTaskResult> _Remove;
    [NotNull] private readonly RdEndpoint<RdRenameItemsCommand, ProjectModelTaskResult> _Rename;
    [NotNull] private readonly RdEndpoint<ExcludeCommand, ProjectModelTaskResult> _Exclude;
    [NotNull] private readonly RdEndpoint<RdUpdateItemPropertiesCommand, ProjectModelTaskResult> _UpdateItemProperties;
    [NotNull] private readonly RdEndpoint<UnloadCommand, RdVoid> _UnloadProjects;
    [NotNull] private readonly RdEndpoint<ReloadCommand, RdVoid> _ReloadProjects;
    [NotNull] private readonly RdEndpoint<ReloadAndShowLogCommand, RdVoid> _ReloadProjectAndShowLog;
    [NotNull] private readonly RdEndpoint<RdExecuteCustomToolCommand, RdVoid> _ExecuteCustomTool;
    [NotNull] private readonly RdEndpoint<RdChangeProjectPropertiesCommand, RdVoid> _ChangeProjectProperties;
    [NotNull] private readonly RdMap<int, RdEditPropertiesSession> _EditPropertiesSessions;
    [NotNull] private readonly RdMap<int, RdAddReferenceSession> _AddReferenceSessions;
    [NotNull] private readonly RdMap<int, RdAddWebReferenceSession> _AddWebReferenceSessions;
    [NotNull] private readonly RdMap<int, RdProjectTargetFramework> _TargetFrameworks;
    [NotNull] private readonly RdEndpoint<RdProjectModelDumpParams, string> _DumpProjectModel;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DumpAssemblies;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DumpPsiModules;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DumpTargetFrameworkIds;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DumpPlatforms;
    [NotNull] private readonly RdEndpoint<RdVoid, int> _GetSolutionReloadCounter;
    [NotNull] private readonly RdSignal<RdRenameProjectEvent> _ProjectRenamed;
    [NotNull] private readonly RdProperty<bool> _DotNetCoreReloading;
    [NotNull] private readonly RdProperty<bool> _SyncExecuteCustomTool;
    
    //primary constructor
    private ProjectModelTasks(
      [NotNull] RdEndpoint<RdAddItemCommand, ProjectModelTaskResult> addItem,
      [NotNull] RdEndpoint<AddProjectCommand, ProjectModelTaskResult> addProject,
      [NotNull] RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult> addSolutionFolder,
      [NotNull] RdEndpoint<RdCopyItemsCommand, ProjectModelTaskResult> copy,
      [NotNull] RdEndpoint<RdMoveItemsCommand, ProjectModelTaskResult> move,
      [NotNull] RdEndpoint<RemoveCommand, ProjectModelTaskResult> remove,
      [NotNull] RdEndpoint<RdRenameItemsCommand, ProjectModelTaskResult> rename,
      [NotNull] RdEndpoint<ExcludeCommand, ProjectModelTaskResult> exclude,
      [NotNull] RdEndpoint<RdUpdateItemPropertiesCommand, ProjectModelTaskResult> updateItemProperties,
      [NotNull] RdEndpoint<UnloadCommand, RdVoid> unloadProjects,
      [NotNull] RdEndpoint<ReloadCommand, RdVoid> reloadProjects,
      [NotNull] RdEndpoint<ReloadAndShowLogCommand, RdVoid> reloadProjectAndShowLog,
      [NotNull] RdEndpoint<RdExecuteCustomToolCommand, RdVoid> executeCustomTool,
      [NotNull] RdEndpoint<RdChangeProjectPropertiesCommand, RdVoid> changeProjectProperties,
      [NotNull] RdMap<int, RdEditPropertiesSession> editPropertiesSessions,
      [NotNull] RdMap<int, RdAddReferenceSession> addReferenceSessions,
      [NotNull] RdMap<int, RdAddWebReferenceSession> addWebReferenceSessions,
      [NotNull] RdMap<int, RdProjectTargetFramework> targetFrameworks,
      [NotNull] RdEndpoint<RdProjectModelDumpParams, string> dumpProjectModel,
      [NotNull] RdEndpoint<RdVoid, string> dumpAssemblies,
      [NotNull] RdEndpoint<RdVoid, string> dumpPsiModules,
      [NotNull] RdEndpoint<RdVoid, string> dumpTargetFrameworkIds,
      [NotNull] RdEndpoint<RdVoid, string> dumpPlatforms,
      [NotNull] RdEndpoint<RdVoid, int> getSolutionReloadCounter,
      [NotNull] RdSignal<RdRenameProjectEvent> projectRenamed,
      [NotNull] RdDotNetCoreTasks dotNetCoreTasks,
      [NotNull] RdProperty<bool> dotNetCoreReloading,
      [NotNull] RdProperty<bool> syncExecuteCustomTool
    )
    {
      if (addItem == null) throw new ArgumentNullException("addItem");
      if (addProject == null) throw new ArgumentNullException("addProject");
      if (addSolutionFolder == null) throw new ArgumentNullException("addSolutionFolder");
      if (copy == null) throw new ArgumentNullException("copy");
      if (move == null) throw new ArgumentNullException("move");
      if (remove == null) throw new ArgumentNullException("remove");
      if (rename == null) throw new ArgumentNullException("rename");
      if (exclude == null) throw new ArgumentNullException("exclude");
      if (updateItemProperties == null) throw new ArgumentNullException("updateItemProperties");
      if (unloadProjects == null) throw new ArgumentNullException("unloadProjects");
      if (reloadProjects == null) throw new ArgumentNullException("reloadProjects");
      if (reloadProjectAndShowLog == null) throw new ArgumentNullException("reloadProjectAndShowLog");
      if (executeCustomTool == null) throw new ArgumentNullException("executeCustomTool");
      if (changeProjectProperties == null) throw new ArgumentNullException("changeProjectProperties");
      if (editPropertiesSessions == null) throw new ArgumentNullException("editPropertiesSessions");
      if (addReferenceSessions == null) throw new ArgumentNullException("addReferenceSessions");
      if (addWebReferenceSessions == null) throw new ArgumentNullException("addWebReferenceSessions");
      if (targetFrameworks == null) throw new ArgumentNullException("targetFrameworks");
      if (dumpProjectModel == null) throw new ArgumentNullException("dumpProjectModel");
      if (dumpAssemblies == null) throw new ArgumentNullException("dumpAssemblies");
      if (dumpPsiModules == null) throw new ArgumentNullException("dumpPsiModules");
      if (dumpTargetFrameworkIds == null) throw new ArgumentNullException("dumpTargetFrameworkIds");
      if (dumpPlatforms == null) throw new ArgumentNullException("dumpPlatforms");
      if (getSolutionReloadCounter == null) throw new ArgumentNullException("getSolutionReloadCounter");
      if (projectRenamed == null) throw new ArgumentNullException("projectRenamed");
      if (dotNetCoreTasks == null) throw new ArgumentNullException("dotNetCoreTasks");
      if (dotNetCoreReloading == null) throw new ArgumentNullException("dotNetCoreReloading");
      if (syncExecuteCustomTool == null) throw new ArgumentNullException("syncExecuteCustomTool");
      
      _AddItem = addItem;
      _AddProject = addProject;
      _AddSolutionFolder = addSolutionFolder;
      _Copy = copy;
      _Move = move;
      _Remove = remove;
      _Rename = rename;
      _Exclude = exclude;
      _UpdateItemProperties = updateItemProperties;
      _UnloadProjects = unloadProjects;
      _ReloadProjects = reloadProjects;
      _ReloadProjectAndShowLog = reloadProjectAndShowLog;
      _ExecuteCustomTool = executeCustomTool;
      _ChangeProjectProperties = changeProjectProperties;
      _EditPropertiesSessions = editPropertiesSessions;
      _AddReferenceSessions = addReferenceSessions;
      _AddWebReferenceSessions = addWebReferenceSessions;
      _TargetFrameworks = targetFrameworks;
      _DumpProjectModel = dumpProjectModel;
      _DumpAssemblies = dumpAssemblies;
      _DumpPsiModules = dumpPsiModules;
      _DumpTargetFrameworkIds = dumpTargetFrameworkIds;
      _DumpPlatforms = dumpPlatforms;
      _GetSolutionReloadCounter = getSolutionReloadCounter;
      _ProjectRenamed = projectRenamed;
      DotNetCoreTasks = dotNetCoreTasks;
      _DotNetCoreReloading = dotNetCoreReloading;
      _SyncExecuteCustomTool = syncExecuteCustomTool;
      _DotNetCoreReloading.OptimizeNested = true;
      _SyncExecuteCustomTool.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("addItem", _AddItem));
      BindableChildren.Add(new KeyValuePair<string, object>("addProject", _AddProject));
      BindableChildren.Add(new KeyValuePair<string, object>("addSolutionFolder", _AddSolutionFolder));
      BindableChildren.Add(new KeyValuePair<string, object>("copy", _Copy));
      BindableChildren.Add(new KeyValuePair<string, object>("move", _Move));
      BindableChildren.Add(new KeyValuePair<string, object>("remove", _Remove));
      BindableChildren.Add(new KeyValuePair<string, object>("rename", _Rename));
      BindableChildren.Add(new KeyValuePair<string, object>("exclude", _Exclude));
      BindableChildren.Add(new KeyValuePair<string, object>("updateItemProperties", _UpdateItemProperties));
      BindableChildren.Add(new KeyValuePair<string, object>("unloadProjects", _UnloadProjects));
      BindableChildren.Add(new KeyValuePair<string, object>("reloadProjects", _ReloadProjects));
      BindableChildren.Add(new KeyValuePair<string, object>("reloadProjectAndShowLog", _ReloadProjectAndShowLog));
      BindableChildren.Add(new KeyValuePair<string, object>("executeCustomTool", _ExecuteCustomTool));
      BindableChildren.Add(new KeyValuePair<string, object>("changeProjectProperties", _ChangeProjectProperties));
      BindableChildren.Add(new KeyValuePair<string, object>("editPropertiesSessions", _EditPropertiesSessions));
      BindableChildren.Add(new KeyValuePair<string, object>("addReferenceSessions", _AddReferenceSessions));
      BindableChildren.Add(new KeyValuePair<string, object>("addWebReferenceSessions", _AddWebReferenceSessions));
      BindableChildren.Add(new KeyValuePair<string, object>("targetFrameworks", _TargetFrameworks));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpProjectModel", _DumpProjectModel));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpAssemblies", _DumpAssemblies));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpPsiModules", _DumpPsiModules));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpTargetFrameworkIds", _DumpTargetFrameworkIds));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpPlatforms", _DumpPlatforms));
      BindableChildren.Add(new KeyValuePair<string, object>("getSolutionReloadCounter", _GetSolutionReloadCounter));
      BindableChildren.Add(new KeyValuePair<string, object>("projectRenamed", _ProjectRenamed));
      BindableChildren.Add(new KeyValuePair<string, object>("dotNetCoreTasks", DotNetCoreTasks));
      BindableChildren.Add(new KeyValuePair<string, object>("dotNetCoreReloading", _DotNetCoreReloading));
      BindableChildren.Add(new KeyValuePair<string, object>("syncExecuteCustomTool", _SyncExecuteCustomTool));
    }
    //secondary constructor
    internal ProjectModelTasks (
    ) : this (
      new RdEndpoint<RdAddItemCommand, ProjectModelTaskResult>(RdAddItemCommand.Read, RdAddItemCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<AddProjectCommand, ProjectModelTaskResult>(AddProjectCommand.Read, AddProjectCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult>(AddSolutionFolderCommand.Read, AddSolutionFolderCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<RdCopyItemsCommand, ProjectModelTaskResult>(RdCopyItemsCommand.Read, RdCopyItemsCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<RdMoveItemsCommand, ProjectModelTaskResult>(RdMoveItemsCommand.Read, RdMoveItemsCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<RemoveCommand, ProjectModelTaskResult>(RemoveCommand.Read, RemoveCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<RdRenameItemsCommand, ProjectModelTaskResult>(RdRenameItemsCommand.Read, RdRenameItemsCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<ExcludeCommand, ProjectModelTaskResult>(ExcludeCommand.Read, ExcludeCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<RdUpdateItemPropertiesCommand, ProjectModelTaskResult>(RdUpdateItemPropertiesCommand.Read, RdUpdateItemPropertiesCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<UnloadCommand, RdVoid>(UnloadCommand.Read, UnloadCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<ReloadCommand, RdVoid>(ReloadCommand.Read, ReloadCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<ReloadAndShowLogCommand, RdVoid>(ReloadAndShowLogCommand.Read, ReloadAndShowLogCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdExecuteCustomToolCommand, RdVoid>(RdExecuteCustomToolCommand.Read, RdExecuteCustomToolCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdChangeProjectPropertiesCommand, RdVoid>(RdChangeProjectPropertiesCommand.Read, RdChangeProjectPropertiesCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdMap<int, RdEditPropertiesSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdEditPropertiesSession.Read, RdEditPropertiesSession.Write),
      new RdMap<int, RdAddReferenceSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdAddReferenceSession.Read, RdAddReferenceSession.Write),
      new RdMap<int, RdAddWebReferenceSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdAddWebReferenceSession.Read, RdAddWebReferenceSession.Write),
      new RdMap<int, RdProjectTargetFramework>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdProjectTargetFramework.Read, RdProjectTargetFramework.Write),
      new RdEndpoint<RdProjectModelDumpParams, string>(RdProjectModelDumpParams.Read, RdProjectModelDumpParams.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<RdVoid, int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<RdRenameProjectEvent>(RdRenameProjectEvent.Read, RdRenameProjectEvent.Write),
      new RdDotNetCoreTasks(),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -7840494043372056008L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdProjectModelDumpParams.Read, RdProjectModelDumpParams.Write);
      serializers.Register(ProjectModelTaskResult.Read, ProjectModelTaskResult.Write);
      serializers.Register(RdCommandRelativeToAfter.Read, RdCommandRelativeToAfter.Write);
      serializers.Register(RdCommandRelativeToBefore.Read, RdCommandRelativeToBefore.Write);
      serializers.Register(RdCommandRelativeToInside.Read, RdCommandRelativeToInside.Write);
      serializers.Register(AddProjectCommand.Read, AddProjectCommand.Write);
      serializers.Register(AddSolutionFolderCommand.Read, AddSolutionFolderCommand.Write);
      serializers.Register(RdAddItemCommand.Read, RdAddItemCommand.Write);
      serializers.Register(RemoveCommand.Read, RemoveCommand.Write);
      serializers.Register(ExcludeCommand.Read, ExcludeCommand.Write);
      serializers.Register(RdCopyItemData.Read, RdCopyItemData.Write);
      serializers.Register(RdCopyItemsCommand.Read, RdCopyItemsCommand.Write);
      serializers.Register(RdMoveItemData.Read, RdMoveItemData.Write);
      serializers.Register(RdMoveItemsCommand.Read, RdMoveItemsCommand.Write);
      serializers.Register(RdUpdatePropertyData.Read, RdUpdatePropertyData.Write);
      serializers.Register(RdUpdateItemPropertiesCommand.Read, RdUpdateItemPropertiesCommand.Write);
      serializers.Register(UnloadCommand.Read, UnloadCommand.Write);
      serializers.Register(ReloadCommand.Read, ReloadCommand.Write);
      serializers.Register(ReloadAndShowLogCommand.Read, ReloadAndShowLogCommand.Write);
      serializers.Register(RdRenameItemData.Read, RdRenameItemData.Write);
      serializers.Register(RdRenameItemsCommand.Read, RdRenameItemsCommand.Write);
      serializers.Register(RdCreatedItemResult.Read, RdCreatedItemResult.Write);
      serializers.Register(RdExecuteCustomToolCommand.Read, RdExecuteCustomToolCommand.Write);
      serializers.Register(RdChangeProjectProperty.Read, RdChangeProjectProperty.Write);
      serializers.Register(RdChangeProjectPropertiesCommand.Read, RdChangeProjectPropertiesCommand.Write);
      serializers.Register(RdEditPropertiesSession.Read, RdEditPropertiesSession.Write);
      serializers.Register(RdEditPropertyVisibleBinding.Read, RdEditPropertyVisibleBinding.Write);
      serializers.Register(RdEditPropertyEnableBinding.Read, RdEditPropertyEnableBinding.Write);
      serializers.Register(RdEditPropertyCompoundBinding.Read, RdEditPropertyCompoundBinding.Write);
      serializers.Register(RdEditPropertySeparator.Read, RdEditPropertySeparator.Write);
      serializers.Register(RdEditPropertyItemLabel.Read, RdEditPropertyItemLabel.Write);
      serializers.Register(RdEditPropertyItemText.Read, RdEditPropertyItemText.Write);
      serializers.Register(RdEditPropertyItemCheck.Read, RdEditPropertyItemCheck.Write);
      serializers.Register(RdEditPropertyItemTextBox.Read, RdEditPropertyItemTextBox.Write);
      serializers.Register(RdEditPropertyItemCheckBox.Read, RdEditPropertyItemCheckBox.Write);
      serializers.Register(RdEditPropertyItemComboBoxValue.Read, RdEditPropertyItemComboBoxValue.Write);
      serializers.Register(RdEditPropertyItemComboBox.Read, RdEditPropertyItemComboBox.Write);
      serializers.Register(RdEditPropertyMultiList.Read, RdEditPropertyMultiList.Write);
      serializers.Register(RdEditPropertySection.Read, RdEditPropertySection.Write);
      serializers.Register(RdEditProjectItemPropertiesContent.Read, RdEditProjectItemPropertiesContent.Write);
      serializers.Register(RdEditPropertiesMessageContent.Read, RdEditPropertiesMessageContent.Write);
      serializers.Register(RdEditConfigurationTableRow.Read, RdEditConfigurationTableRow.Write);
      serializers.Register(RdEditConfigurationTable.Read, RdEditConfigurationTable.Write);
      serializers.Register(RdEditConfigurationProject.Read, RdEditConfigurationProject.Write);
      serializers.Register(RdEditConfigurationView.Read, RdEditConfigurationView.Write);
      serializers.Register(RdEditSolutionPropertiesContent.Read, RdEditSolutionPropertiesContent.Write);
      serializers.Register(RdEditProjectPropertySectionsTab.Read, RdEditProjectPropertySectionsTab.Write);
      serializers.Register(RdEditProjectPropertyTableTab.Read, RdEditProjectPropertyTableTab.Write);
      serializers.Register(RdEditProjectPropertyTabGroup.Read, RdEditProjectPropertyTabGroup.Write);
      serializers.Register(RdEditProjectPropertiesContent.Read, RdEditProjectPropertiesContent.Write);
      serializers.Register(RdAddReferenceItemGroup.Read, RdAddReferenceItemGroup.Write);
      serializers.Register(RdAddReferenceItem.Read, RdAddReferenceItem.Write);
      serializers.Register(RdAddReferenceSessionItems.Read, RdAddReferenceSessionItems.Write);
      serializers.Register(RdAddReferenceSession.Read, RdAddReferenceSession.Write);
      serializers.Register(RdAddWebReferenceSession.Read, RdAddWebReferenceSession.Write);
      serializers.Register(RdRenameProjectEvent.Read, RdRenameProjectEvent.Write);
      serializers.Register(RdProjectTargetFramework.Read, RdProjectTargetFramework.Write);
      serializers.Register(RdDotNetCoreTasks.Read, RdDotNetCoreTasks.Write);
      serializers.RegisterEnum<RdProjectModelDumpFlags>();
      serializers.RegisterEnum<ProjectModelTaskResultKind>();
      serializers.Register(RdEditConfigurationProjectInfo.Read, RdEditConfigurationProjectInfo.Write);
      serializers.Register(RdEditPropertyTableRow.Read, RdEditPropertyTableRow.Write);
      serializers.Register(ProjectModelTaskResultContent_Unknown.Read, ProjectModelTaskResultContent_Unknown.Write);
      serializers.Register(RdCommandRelativeTo_Unknown.Read, RdCommandRelativeTo_Unknown.Write);
      serializers.Register(RdEditPropertiesSessionContent_Unknown.Read, RdEditPropertiesSessionContent_Unknown.Write);
      serializers.Register(RdEditPropertyBinding_Unknown.Read, RdEditPropertyBinding_Unknown.Write);
      serializers.Register(RdEditPropertyItem_Unknown.Read, RdEditPropertyItem_Unknown.Write);
      serializers.Register(RdEditProjectPropertyTab_Unknown.Read, RdEditProjectPropertyTab_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModelTasks (");
      using (printer.IndentCookie()) {
        printer.Print("addItem = "); _AddItem.PrintEx(printer); printer.Println();
        printer.Print("addProject = "); _AddProject.PrintEx(printer); printer.Println();
        printer.Print("addSolutionFolder = "); _AddSolutionFolder.PrintEx(printer); printer.Println();
        printer.Print("copy = "); _Copy.PrintEx(printer); printer.Println();
        printer.Print("move = "); _Move.PrintEx(printer); printer.Println();
        printer.Print("remove = "); _Remove.PrintEx(printer); printer.Println();
        printer.Print("rename = "); _Rename.PrintEx(printer); printer.Println();
        printer.Print("exclude = "); _Exclude.PrintEx(printer); printer.Println();
        printer.Print("updateItemProperties = "); _UpdateItemProperties.PrintEx(printer); printer.Println();
        printer.Print("unloadProjects = "); _UnloadProjects.PrintEx(printer); printer.Println();
        printer.Print("reloadProjects = "); _ReloadProjects.PrintEx(printer); printer.Println();
        printer.Print("reloadProjectAndShowLog = "); _ReloadProjectAndShowLog.PrintEx(printer); printer.Println();
        printer.Print("executeCustomTool = "); _ExecuteCustomTool.PrintEx(printer); printer.Println();
        printer.Print("changeProjectProperties = "); _ChangeProjectProperties.PrintEx(printer); printer.Println();
        printer.Print("editPropertiesSessions = "); _EditPropertiesSessions.PrintEx(printer); printer.Println();
        printer.Print("addReferenceSessions = "); _AddReferenceSessions.PrintEx(printer); printer.Println();
        printer.Print("addWebReferenceSessions = "); _AddWebReferenceSessions.PrintEx(printer); printer.Println();
        printer.Print("targetFrameworks = "); _TargetFrameworks.PrintEx(printer); printer.Println();
        printer.Print("dumpProjectModel = "); _DumpProjectModel.PrintEx(printer); printer.Println();
        printer.Print("dumpAssemblies = "); _DumpAssemblies.PrintEx(printer); printer.Println();
        printer.Print("dumpPsiModules = "); _DumpPsiModules.PrintEx(printer); printer.Println();
        printer.Print("dumpTargetFrameworkIds = "); _DumpTargetFrameworkIds.PrintEx(printer); printer.Println();
        printer.Print("dumpPlatforms = "); _DumpPlatforms.PrintEx(printer); printer.Println();
        printer.Print("getSolutionReloadCounter = "); _GetSolutionReloadCounter.PrintEx(printer); printer.Println();
        printer.Print("projectRenamed = "); _ProjectRenamed.PrintEx(printer); printer.Println();
        printer.Print("dotNetCoreTasks = "); DotNetCoreTasks.PrintEx(printer); printer.Println();
        printer.Print("dotNetCoreReloading = "); _DotNetCoreReloading.PrintEx(printer); printer.Println();
        printer.Print("syncExecuteCustomTool = "); _SyncExecuteCustomTool.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionProjectModelTasksEx
   {
    public static ProjectModelTasks GetProjectModelTasks(this Solution solution)
    {
      return solution.GetOrCreateExtension("projectModelTasks", () => new ProjectModelTasks());
    }
  }
  
  
  public class AddProjectCommand : IPrintable, IEquatable<AddProjectCommand>
  {
    //fields
    //public fields
    public int ParentId {get; private set;}
    [NotNull] public List<string> ProjectFiles {get; private set;}
    [NotNull] public List<RdFileToOpen> FilesToOpen {get; private set;}
    public bool RestorePackages {get; private set;}
    public bool Reformat {get; private set;}
    
    //private fields
    //primary constructor
    public AddProjectCommand(
      int parentId,
      [NotNull] List<string> projectFiles,
      [NotNull] List<RdFileToOpen> filesToOpen,
      bool restorePackages,
      bool reformat
    )
    {
      if (projectFiles == null) throw new ArgumentNullException("projectFiles");
      if (filesToOpen == null) throw new ArgumentNullException("filesToOpen");
      
      ParentId = parentId;
      ProjectFiles = projectFiles;
      FilesToOpen = filesToOpen;
      RestorePackages = restorePackages;
      Reformat = reformat;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddProjectCommand> Read = (ctx, reader) => 
    {
      var parentId = reader.ReadInt();
      var projectFiles = ReadStringList(ctx, reader);
      var filesToOpen = ReadRdFileToOpenList(ctx, reader);
      var restorePackages = reader.ReadBool();
      var reformat = reader.ReadBool();
      return new AddProjectCommand(parentId, projectFiles, filesToOpen, restorePackages, reformat);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<RdFileToOpen>> ReadRdFileToOpenList = RdFileToOpen.Read.List();
    
    public static CtxWriteDelegate<AddProjectCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ParentId);
      WriteStringList(ctx, writer, value.ProjectFiles);
      WriteRdFileToOpenList(ctx, writer, value.FilesToOpen);
      writer.Write(value.RestorePackages);
      writer.Write(value.Reformat);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<RdFileToOpen>> WriteRdFileToOpenList = RdFileToOpen.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddProjectCommand) obj);
    }
    public bool Equals(AddProjectCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ParentId == other.ParentId && ProjectFiles.SequenceEqual(other.ProjectFiles) && FilesToOpen.SequenceEqual(other.FilesToOpen) && RestorePackages == other.RestorePackages && Reformat == other.Reformat;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ParentId.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ProjectFiles);
        hash = hash * 31 + Collections.GetHashCode(FilesToOpen);
        hash = hash * 31 + RestorePackages.GetHashCode();
        hash = hash * 31 + Reformat.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddProjectCommand (");
      using (printer.IndentCookie()) {
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("projectFiles = "); ProjectFiles.PrintEx(printer); printer.Println();
        printer.Print("filesToOpen = "); FilesToOpen.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
        printer.Print("reformat = "); Reformat.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AddSolutionFolderCommand : IPrintable, IEquatable<AddSolutionFolderCommand>
  {
    //fields
    //public fields
    [NotNull] public string SolutionFolderName {get; private set;}
    public int ParentId {get; private set;}
    
    //private fields
    //primary constructor
    public AddSolutionFolderCommand(
      [NotNull] string solutionFolderName,
      int parentId
    )
    {
      if (solutionFolderName == null) throw new ArgumentNullException("solutionFolderName");
      
      SolutionFolderName = solutionFolderName;
      ParentId = parentId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddSolutionFolderCommand> Read = (ctx, reader) => 
    {
      var solutionFolderName = reader.ReadString();
      var parentId = reader.ReadInt();
      return new AddSolutionFolderCommand(solutionFolderName, parentId);
    };
    
    public static CtxWriteDelegate<AddSolutionFolderCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SolutionFolderName);
      writer.Write(value.ParentId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddSolutionFolderCommand) obj);
    }
    public bool Equals(AddSolutionFolderCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SolutionFolderName == other.SolutionFolderName && ParentId == other.ParentId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SolutionFolderName.GetHashCode();
        hash = hash * 31 + ParentId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddSolutionFolderCommand (");
      using (printer.IndentCookie()) {
        printer.Print("solutionFolderName = "); SolutionFolderName.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExcludeCommand : IPrintable, IEquatable<ExcludeCommand>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    
    //private fields
    //primary constructor
    public ExcludeCommand(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ExcludeCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new ExcludeCommand(itemId);
    };
    
    public static CtxWriteDelegate<ExcludeCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ExcludeCommand) obj);
    }
    public bool Equals(ExcludeCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ExcludeCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProjectModelTaskResult : IPrintable, IEquatable<ProjectModelTaskResult>
  {
    //fields
    //public fields
    public ProjectModelTaskResultKind Result {get; private set;}
    [CanBeNull] public string ErrorMessage {get; private set;}
    [CanBeNull] public ProjectModelTaskResultContent Content {get; private set;}
    
    //private fields
    //primary constructor
    public ProjectModelTaskResult(
      ProjectModelTaskResultKind result,
      [CanBeNull] string errorMessage,
      [CanBeNull] ProjectModelTaskResultContent content
    )
    {
      Result = result;
      ErrorMessage = errorMessage;
      Content = content;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectModelTaskResult> Read = (ctx, reader) => 
    {
      var result = (ProjectModelTaskResultKind)reader.ReadInt();
      var errorMessage = ReadStringNullable(ctx, reader);
      var content = ReadProjectModelTaskResultContentNullable(ctx, reader);
      return new ProjectModelTaskResult(result, errorMessage, content);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<ProjectModelTaskResultContent> ReadProjectModelTaskResultContentNullable = ProjectModelTaskResultContent.Read.NullableClass();
    
    public static CtxWriteDelegate<ProjectModelTaskResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Result);
      WriteStringNullable(ctx, writer, value.ErrorMessage);
      WriteProjectModelTaskResultContentNullable(ctx, writer, value.Content);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<ProjectModelTaskResultContent> WriteProjectModelTaskResultContentNullable = ProjectModelTaskResultContent.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectModelTaskResult) obj);
    }
    public bool Equals(ProjectModelTaskResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Result == other.Result && Equals(ErrorMessage, other.ErrorMessage) && Equals(Content, other.Content);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Result;
        hash = hash * 31 + (ErrorMessage != null ?ErrorMessage.GetHashCode() : 0);
        hash = hash * 31 + (Content != null ?Content.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModelTaskResult (");
      using (printer.IndentCookie()) {
        printer.Print("result = "); Result.PrintEx(printer); printer.Println();
        printer.Print("errorMessage = "); ErrorMessage.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ProjectModelTaskResultContent{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectModelTaskResultContent> Read = Polymorphic<ProjectModelTaskResultContent>.ReadAbstract(ProjectModelTaskResultContent_Unknown.Read);
    
    public static CtxWriteDelegate<ProjectModelTaskResultContent> Write = Polymorphic<ProjectModelTaskResultContent>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class ProjectModelTaskResultContent_Unknown : ProjectModelTaskResultContent
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ProjectModelTaskResultContent_Unknown> Read = (ctx, reader) => 
    {
      return new ProjectModelTaskResultContent_Unknown();
    };
    
    public static new CtxWriteDelegate<ProjectModelTaskResultContent_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectModelTaskResultContent_Unknown) obj);
    }
    public bool Equals(ProjectModelTaskResultContent_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModelTaskResultContent_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ProjectModelTaskResultKind {
    Complete,
    Error
  }
  
  
  public class RdAddItemCommand : IPrintable, IEquatable<RdAddItemCommand>
  {
    //fields
    //public fields
    [NotNull] public string ItemLocation {get; private set;}
    public int ParentId {get; private set;}
    [CanBeNull] public RdCommandRelativeTo RelativeTo {get; private set;}
    
    //private fields
    //primary constructor
    public RdAddItemCommand(
      [NotNull] string itemLocation,
      int parentId,
      [CanBeNull] RdCommandRelativeTo relativeTo
    )
    {
      if (itemLocation == null) throw new ArgumentNullException("itemLocation");
      
      ItemLocation = itemLocation;
      ParentId = parentId;
      RelativeTo = relativeTo;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdAddItemCommand> Read = (ctx, reader) => 
    {
      var itemLocation = reader.ReadString();
      var parentId = reader.ReadInt();
      var relativeTo = ReadRdCommandRelativeToNullable(ctx, reader);
      return new RdAddItemCommand(itemLocation, parentId, relativeTo);
    };
    public static CtxReadDelegate<RdCommandRelativeTo> ReadRdCommandRelativeToNullable = RdCommandRelativeTo.Read.NullableClass();
    
    public static CtxWriteDelegate<RdAddItemCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemLocation);
      writer.Write(value.ParentId);
      WriteRdCommandRelativeToNullable(ctx, writer, value.RelativeTo);
    };
    public static CtxWriteDelegate<RdCommandRelativeTo> WriteRdCommandRelativeToNullable = RdCommandRelativeTo.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAddItemCommand) obj);
    }
    public bool Equals(RdAddItemCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemLocation == other.ItemLocation && ParentId == other.ParentId && Equals(RelativeTo, other.RelativeTo);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemLocation.GetHashCode();
        hash = hash * 31 + ParentId.GetHashCode();
        hash = hash * 31 + (RelativeTo != null ?RelativeTo.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddItemCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemLocation = "); ItemLocation.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("relativeTo = "); RelativeTo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAddReferenceItem : IPrintable, IEquatable<RdAddReferenceItem>
  {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public string Presentation {get; private set;}
    [NotNull] public string Comment {get; private set;}
    [NotNull] public string Tooltip {get; private set;}
    public int GroupId {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdAddReferenceItem(
      int id,
      [NotNull] string presentation,
      [NotNull] string comment,
      [NotNull] string tooltip,
      int groupId,
      [NotNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (presentation == null) throw new ArgumentNullException("presentation");
      if (comment == null) throw new ArgumentNullException("comment");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      if (icon == null) throw new ArgumentNullException("icon");
      
      Id = id;
      Presentation = presentation;
      Comment = comment;
      Tooltip = tooltip;
      GroupId = groupId;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdAddReferenceItem> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var presentation = reader.ReadString();
      var comment = reader.ReadString();
      var tooltip = reader.ReadString();
      var groupId = reader.ReadInt();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      return new RdAddReferenceItem(id, presentation, comment, tooltip, groupId, icon);
    };
    
    public static CtxWriteDelegate<RdAddReferenceItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Presentation);
      writer.Write(value.Comment);
      writer.Write(value.Tooltip);
      writer.Write(value.GroupId);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAddReferenceItem) obj);
    }
    public bool Equals(RdAddReferenceItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Presentation == other.Presentation && Comment == other.Comment && Tooltip == other.Tooltip && GroupId == other.GroupId && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Presentation.GetHashCode();
        hash = hash * 31 + Comment.GetHashCode();
        hash = hash * 31 + Tooltip.GetHashCode();
        hash = hash * 31 + GroupId.GetHashCode();
        hash = hash * 31 + Icon.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddReferenceItem (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("presentation = "); Presentation.PrintEx(printer); printer.Println();
        printer.Print("comment = "); Comment.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("groupId = "); GroupId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAddReferenceItemGroup : IPrintable, IEquatable<RdAddReferenceItemGroup>
  {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public string PresentationName {get; private set;}
    public int Priority {get; private set;}
    
    //private fields
    //primary constructor
    public RdAddReferenceItemGroup(
      int id,
      [NotNull] string presentationName,
      int priority
    )
    {
      if (presentationName == null) throw new ArgumentNullException("presentationName");
      
      Id = id;
      PresentationName = presentationName;
      Priority = priority;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdAddReferenceItemGroup> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var presentationName = reader.ReadString();
      var priority = reader.ReadInt();
      return new RdAddReferenceItemGroup(id, presentationName, priority);
    };
    
    public static CtxWriteDelegate<RdAddReferenceItemGroup> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.PresentationName);
      writer.Write(value.Priority);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAddReferenceItemGroup) obj);
    }
    public bool Equals(RdAddReferenceItemGroup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && PresentationName == other.PresentationName && Priority == other.Priority;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + PresentationName.GetHashCode();
        hash = hash * 31 + Priority.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddReferenceItemGroup (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("presentationName = "); PresentationName.PrintEx(printer); printer.Println();
        printer.Print("priority = "); Priority.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAddReferenceSession : RdBindableBase
  {
    //fields
    //public fields
    public int ProjectId {get; private set;}
    [NotNull] public IRdProperty<RdAddReferenceSessionItems> PossibleReferences { get { return _PossibleReferences; }}
    [NotNull] public IRdProperty<string> Message { get { return _Message; }}
    [NotNull] public RdEndpoint<List<int>, ProjectModelTaskResult> Add { get { return _Add; }}
    [NotNull] public RdEndpoint<List<string>, ProjectModelTaskResult> AddByPath { get { return _AddByPath; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdAddReferenceSessionItems> _PossibleReferences;
    [NotNull] private readonly RdProperty<string> _Message;
    [NotNull] private readonly RdEndpoint<List<int>, ProjectModelTaskResult> _Add;
    [NotNull] private readonly RdEndpoint<List<string>, ProjectModelTaskResult> _AddByPath;
    
    //primary constructor
    private RdAddReferenceSession(
      int projectId,
      [NotNull] RdProperty<RdAddReferenceSessionItems> possibleReferences,
      [NotNull] RdProperty<string> message,
      [NotNull] RdEndpoint<List<int>, ProjectModelTaskResult> add,
      [NotNull] RdEndpoint<List<string>, ProjectModelTaskResult> addByPath
    )
    {
      if (possibleReferences == null) throw new ArgumentNullException("possibleReferences");
      if (message == null) throw new ArgumentNullException("message");
      if (add == null) throw new ArgumentNullException("add");
      if (addByPath == null) throw new ArgumentNullException("addByPath");
      
      ProjectId = projectId;
      _PossibleReferences = possibleReferences;
      _Message = message;
      _Add = add;
      _AddByPath = addByPath;
      _PossibleReferences.OptimizeNested = true;
      _Message.OptimizeNested = true;
      _Message.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("possibleReferences", _PossibleReferences));
      BindableChildren.Add(new KeyValuePair<string, object>("message", _Message));
      BindableChildren.Add(new KeyValuePair<string, object>("add", _Add));
      BindableChildren.Add(new KeyValuePair<string, object>("addByPath", _AddByPath));
    }
    //secondary constructor
    public RdAddReferenceSession (
      int projectId
    ) : this (
      projectId,
      new RdProperty<RdAddReferenceSessionItems>(RdAddReferenceSessionItems.Read, RdAddReferenceSessionItems.Write),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdEndpoint<List<int>, ProjectModelTaskResult>(ReadIntList, WriteIntList, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<List<string>, ProjectModelTaskResult>(ReadStringList, WriteStringList, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdAddReferenceSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var projectId = reader.ReadInt();
      var possibleReferences = RdProperty<RdAddReferenceSessionItems>.Read(ctx, reader, RdAddReferenceSessionItems.Read, RdAddReferenceSessionItems.Write);
      var message = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var add = RdEndpoint<List<int>, ProjectModelTaskResult>.Read(ctx, reader, ReadIntList, WriteIntList, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write);
      var addByPath = RdEndpoint<List<string>, ProjectModelTaskResult>.Read(ctx, reader, ReadStringList, WriteStringList, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write);
      return new RdAddReferenceSession(projectId, possibleReferences, message, add, addByPath).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdAddReferenceSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ProjectId);
      RdProperty<RdAddReferenceSessionItems>.Write(ctx, writer, value._PossibleReferences);
      RdProperty<string>.Write(ctx, writer, value._Message);
      RdEndpoint<List<int>, ProjectModelTaskResult>.Write(ctx, writer, value._Add);
      RdEndpoint<List<string>, ProjectModelTaskResult>.Write(ctx, writer, value._AddByPath);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddReferenceSession (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("possibleReferences = "); _PossibleReferences.PrintEx(printer); printer.Println();
        printer.Print("message = "); _Message.PrintEx(printer); printer.Println();
        printer.Print("add = "); _Add.PrintEx(printer); printer.Println();
        printer.Print("addByPath = "); _AddByPath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAddReferenceSessionItems : IPrintable, IEquatable<RdAddReferenceSessionItems>
  {
    //fields
    //public fields
    [NotNull] public List<RdAddReferenceItemGroup> Groups {get; private set;}
    [NotNull] public List<RdAddReferenceItem> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RdAddReferenceSessionItems(
      [NotNull] List<RdAddReferenceItemGroup> groups,
      [NotNull] List<RdAddReferenceItem> items
    )
    {
      if (groups == null) throw new ArgumentNullException("groups");
      if (items == null) throw new ArgumentNullException("items");
      
      Groups = groups;
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdAddReferenceSessionItems> Read = (ctx, reader) => 
    {
      var groups = ReadRdAddReferenceItemGroupList(ctx, reader);
      var items = ReadRdAddReferenceItemList(ctx, reader);
      return new RdAddReferenceSessionItems(groups, items);
    };
    public static CtxReadDelegate<List<RdAddReferenceItemGroup>> ReadRdAddReferenceItemGroupList = RdAddReferenceItemGroup.Read.List();
    public static CtxReadDelegate<List<RdAddReferenceItem>> ReadRdAddReferenceItemList = RdAddReferenceItem.Read.List();
    
    public static CtxWriteDelegate<RdAddReferenceSessionItems> Write = (ctx, writer, value) => 
    {
      WriteRdAddReferenceItemGroupList(ctx, writer, value.Groups);
      WriteRdAddReferenceItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RdAddReferenceItemGroup>> WriteRdAddReferenceItemGroupList = RdAddReferenceItemGroup.Write.List();
    public static CtxWriteDelegate<List<RdAddReferenceItem>> WriteRdAddReferenceItemList = RdAddReferenceItem.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAddReferenceSessionItems) obj);
    }
    public bool Equals(RdAddReferenceSessionItems other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Groups.SequenceEqual(other.Groups) && Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Groups);
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddReferenceSessionItems (");
      using (printer.IndentCookie()) {
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAddWebReferenceSession : RdBindableBase
  {
    //fields
    //public fields
    public int ProjectId {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.BeDialog> Content { get { return _Content; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.UIAutomation.BeDialog> _Content;
    
    //primary constructor
    private RdAddWebReferenceSession(
      int projectId,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.BeDialog> content
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      
      ProjectId = projectId;
      _Content = content;
      _Content.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
    }
    //secondary constructor
    public RdAddWebReferenceSession (
      int projectId
    ) : this (
      projectId,
      new RdProperty<JetBrains.Rider.Model.UIAutomation.BeDialog>(ReadBeDialogNullable, WriteBeDialogNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdAddWebReferenceSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var projectId = reader.ReadInt();
      var content = RdProperty<JetBrains.Rider.Model.UIAutomation.BeDialog>.Read(ctx, reader, ReadBeDialogNullable, WriteBeDialogNullable);
      return new RdAddWebReferenceSession(projectId, content).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.BeDialog> ReadBeDialogNullable = JetBrains.Rider.Model.UIAutomation.BeDialog.Read.NullableClass();
    
    public static CtxWriteDelegate<RdAddWebReferenceSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ProjectId);
      RdProperty<JetBrains.Rider.Model.UIAutomation.BeDialog>.Write(ctx, writer, value._Content);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.BeDialog> WriteBeDialogNullable = JetBrains.Rider.Model.UIAutomation.BeDialog.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddWebReferenceSession (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdChangeProjectPropertiesCommand : IPrintable, IEquatable<RdChangeProjectPropertiesCommand>
  {
    //fields
    //public fields
    public int ProjectId {get; private set;}
    [NotNull] public List<RdChangeProjectProperty> Properties {get; private set;}
    
    //private fields
    //primary constructor
    public RdChangeProjectPropertiesCommand(
      int projectId,
      [NotNull] List<RdChangeProjectProperty> properties
    )
    {
      if (properties == null) throw new ArgumentNullException("properties");
      
      ProjectId = projectId;
      Properties = properties;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdChangeProjectPropertiesCommand> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      var properties = ReadRdChangeProjectPropertyList(ctx, reader);
      return new RdChangeProjectPropertiesCommand(projectId, properties);
    };
    public static CtxReadDelegate<List<RdChangeProjectProperty>> ReadRdChangeProjectPropertyList = RdChangeProjectProperty.Read.List();
    
    public static CtxWriteDelegate<RdChangeProjectPropertiesCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
      WriteRdChangeProjectPropertyList(ctx, writer, value.Properties);
    };
    public static CtxWriteDelegate<List<RdChangeProjectProperty>> WriteRdChangeProjectPropertyList = RdChangeProjectProperty.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdChangeProjectPropertiesCommand) obj);
    }
    public bool Equals(RdChangeProjectPropertiesCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectId == other.ProjectId && Properties.SequenceEqual(other.Properties);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Properties);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdChangeProjectPropertiesCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("properties = "); Properties.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdChangeProjectProperty : IPrintable, IEquatable<RdChangeProjectProperty>
  {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [CanBeNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public RdChangeProjectProperty(
      [NotNull] string name,
      [CanBeNull] string value
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      
      Name = name;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdChangeProjectProperty> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var value = ReadStringNullable(ctx, reader);
      return new RdChangeProjectProperty(name, value);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdChangeProjectProperty> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteStringNullable(ctx, writer, value.Value);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdChangeProjectProperty) obj);
    }
    public bool Equals(RdChangeProjectProperty other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Value, other.Value);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + (Value != null ?Value.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdChangeProjectProperty (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdCommandRelativeTo{
    //fields
    //public fields
    public int RelativeToId {get; private set;}
    
    //private fields
    //primary constructor
    protected RdCommandRelativeTo(
      int relativeToId
    )
    {
      RelativeToId = relativeToId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCommandRelativeTo> Read = Polymorphic<RdCommandRelativeTo>.ReadAbstract(RdCommandRelativeTo_Unknown.Read);
    
    public static CtxWriteDelegate<RdCommandRelativeTo> Write = Polymorphic<RdCommandRelativeTo>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdCommandRelativeToAfter : RdCommandRelativeTo
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdCommandRelativeToAfter(
      int relativeToId
    ) : base (
      relativeToId
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdCommandRelativeToAfter> Read = (ctx, reader) => 
    {
      var relativeToId = reader.ReadInt();
      return new RdCommandRelativeToAfter(relativeToId);
    };
    
    public static new CtxWriteDelegate<RdCommandRelativeToAfter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.RelativeToId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCommandRelativeToAfter) obj);
    }
    public bool Equals(RdCommandRelativeToAfter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return RelativeToId == other.RelativeToId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + RelativeToId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCommandRelativeToAfter (");
      using (printer.IndentCookie()) {
        printer.Print("relativeToId = "); RelativeToId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCommandRelativeToBefore : RdCommandRelativeTo
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdCommandRelativeToBefore(
      int relativeToId
    ) : base (
      relativeToId
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdCommandRelativeToBefore> Read = (ctx, reader) => 
    {
      var relativeToId = reader.ReadInt();
      return new RdCommandRelativeToBefore(relativeToId);
    };
    
    public static new CtxWriteDelegate<RdCommandRelativeToBefore> Write = (ctx, writer, value) => 
    {
      writer.Write(value.RelativeToId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCommandRelativeToBefore) obj);
    }
    public bool Equals(RdCommandRelativeToBefore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return RelativeToId == other.RelativeToId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + RelativeToId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCommandRelativeToBefore (");
      using (printer.IndentCookie()) {
        printer.Print("relativeToId = "); RelativeToId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCommandRelativeToInside : RdCommandRelativeTo
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdCommandRelativeToInside(
      int relativeToId
    ) : base (
      relativeToId
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdCommandRelativeToInside> Read = (ctx, reader) => 
    {
      var relativeToId = reader.ReadInt();
      return new RdCommandRelativeToInside(relativeToId);
    };
    
    public static new CtxWriteDelegate<RdCommandRelativeToInside> Write = (ctx, writer, value) => 
    {
      writer.Write(value.RelativeToId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCommandRelativeToInside) obj);
    }
    public bool Equals(RdCommandRelativeToInside other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return RelativeToId == other.RelativeToId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + RelativeToId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCommandRelativeToInside (");
      using (printer.IndentCookie()) {
        printer.Print("relativeToId = "); RelativeToId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCommandRelativeTo_Unknown : RdCommandRelativeTo
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdCommandRelativeTo_Unknown(
      int relativeToId
    ) : base (
      relativeToId
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdCommandRelativeTo_Unknown> Read = (ctx, reader) => 
    {
      var relativeToId = reader.ReadInt();
      return new RdCommandRelativeTo_Unknown(relativeToId);
    };
    
    public static new CtxWriteDelegate<RdCommandRelativeTo_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.RelativeToId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCommandRelativeTo_Unknown) obj);
    }
    public bool Equals(RdCommandRelativeTo_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return RelativeToId == other.RelativeToId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + RelativeToId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCommandRelativeTo_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("relativeToId = "); RelativeToId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCopyItemData : IPrintable, IEquatable<RdCopyItemData>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    [CanBeNull] public string CustomName {get; private set;}
    
    //private fields
    //primary constructor
    public RdCopyItemData(
      int itemId,
      [CanBeNull] string customName
    )
    {
      ItemId = itemId;
      CustomName = customName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCopyItemData> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var customName = ReadStringNullable(ctx, reader);
      return new RdCopyItemData(itemId, customName);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdCopyItemData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      WriteStringNullable(ctx, writer, value.CustomName);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCopyItemData) obj);
    }
    public bool Equals(RdCopyItemData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && Equals(CustomName, other.CustomName);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        hash = hash * 31 + (CustomName != null ?CustomName.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCopyItemData (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("customName = "); CustomName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCopyItemsCommand : IPrintable, IEquatable<RdCopyItemsCommand>
  {
    //fields
    //public fields
    [NotNull] public List<RdCopyItemData> Items {get; private set;}
    public int ParentId {get; private set;}
    [CanBeNull] public RdCommandRelativeTo RelativeTo {get; private set;}
    
    //private fields
    //primary constructor
    public RdCopyItemsCommand(
      [NotNull] List<RdCopyItemData> items,
      int parentId,
      [CanBeNull] RdCommandRelativeTo relativeTo
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      ParentId = parentId;
      RelativeTo = relativeTo;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCopyItemsCommand> Read = (ctx, reader) => 
    {
      var items = ReadRdCopyItemDataList(ctx, reader);
      var parentId = reader.ReadInt();
      var relativeTo = ReadRdCommandRelativeToNullable(ctx, reader);
      return new RdCopyItemsCommand(items, parentId, relativeTo);
    };
    public static CtxReadDelegate<List<RdCopyItemData>> ReadRdCopyItemDataList = RdCopyItemData.Read.List();
    public static CtxReadDelegate<RdCommandRelativeTo> ReadRdCommandRelativeToNullable = RdCommandRelativeTo.Read.NullableClass();
    
    public static CtxWriteDelegate<RdCopyItemsCommand> Write = (ctx, writer, value) => 
    {
      WriteRdCopyItemDataList(ctx, writer, value.Items);
      writer.Write(value.ParentId);
      WriteRdCommandRelativeToNullable(ctx, writer, value.RelativeTo);
    };
    public static CtxWriteDelegate<List<RdCopyItemData>> WriteRdCopyItemDataList = RdCopyItemData.Write.List();
    public static CtxWriteDelegate<RdCommandRelativeTo> WriteRdCommandRelativeToNullable = RdCommandRelativeTo.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCopyItemsCommand) obj);
    }
    public bool Equals(RdCopyItemsCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items) && ParentId == other.ParentId && Equals(RelativeTo, other.RelativeTo);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        hash = hash * 31 + ParentId.GetHashCode();
        hash = hash * 31 + (RelativeTo != null ?RelativeTo.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCopyItemsCommand (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("relativeTo = "); RelativeTo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCreatedItemResult : ProjectModelTaskResultContent
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    
    //private fields
    //primary constructor
    public RdCreatedItemResult(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdCreatedItemResult> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new RdCreatedItemResult(itemId);
    };
    
    public static new CtxWriteDelegate<RdCreatedItemResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCreatedItemResult) obj);
    }
    public bool Equals(RdCreatedItemResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCreatedItemResult (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotNetCoreTasks : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> MigrationRequired { get { return _MigrationRequired; }}
    [NotNull] public RdEndpoint<RdVoid, RdVoid> RunMigration { get { return _RunMigration; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _MigrationRequired;
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _RunMigration;
    
    //primary constructor
    private RdDotNetCoreTasks(
      [NotNull] RdProperty<bool> migrationRequired,
      [NotNull] RdEndpoint<RdVoid, RdVoid> runMigration
    )
    {
      if (migrationRequired == null) throw new ArgumentNullException("migrationRequired");
      if (runMigration == null) throw new ArgumentNullException("runMigration");
      
      _MigrationRequired = migrationRequired;
      _RunMigration = runMigration;
      _MigrationRequired.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("migrationRequired", _MigrationRequired));
      BindableChildren.Add(new KeyValuePair<string, object>("runMigration", _RunMigration));
    }
    //secondary constructor
    public RdDotNetCoreTasks (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDotNetCoreTasks> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var migrationRequired = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var runMigration = RdEndpoint<RdVoid, RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdDotNetCoreTasks(migrationRequired, runMigration).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdDotNetCoreTasks> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._MigrationRequired);
      RdEndpoint<RdVoid, RdVoid>.Write(ctx, writer, value._RunMigration);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotNetCoreTasks (");
      using (printer.IndentCookie()) {
        printer.Print("migrationRequired = "); _MigrationRequired.PrintEx(printer); printer.Println();
        printer.Print("runMigration = "); _RunMigration.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditConfigurationProject : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string ProjectName {get; private set;}
    public bool IsLoaded {get; private set;}
    [NotNull] public IViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> ProjectConfigurationsAndPlatforms { get { return _ProjectConfigurationsAndPlatforms; }}
    
    //private fields
    [NotNull] private readonly RdMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> _ProjectConfigurationsAndPlatforms;
    
    //primary constructor
    private RdEditConfigurationProject(
      [NotNull] string projectName,
      bool isLoaded,
      [NotNull] RdMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> projectConfigurationsAndPlatforms
    )
    {
      if (projectName == null) throw new ArgumentNullException("projectName");
      if (projectConfigurationsAndPlatforms == null) throw new ArgumentNullException("projectConfigurationsAndPlatforms");
      
      ProjectName = projectName;
      IsLoaded = isLoaded;
      _ProjectConfigurationsAndPlatforms = projectConfigurationsAndPlatforms;
      _ProjectConfigurationsAndPlatforms.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("projectConfigurationsAndPlatforms", _ProjectConfigurationsAndPlatforms));
    }
    //secondary constructor
    public RdEditConfigurationProject (
      [NotNull] string projectName,
      bool isLoaded
    ) : this (
      projectName,
      isLoaded,
      new RdMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo>(RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write, RdEditConfigurationProjectInfo.Read, RdEditConfigurationProjectInfo.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEditConfigurationProject> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var projectName = reader.ReadString();
      var isLoaded = reader.ReadBool();
      var projectConfigurationsAndPlatforms = RdMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo>.Read(ctx, reader, RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write, RdEditConfigurationProjectInfo.Read, RdEditConfigurationProjectInfo.Write);
      return new RdEditConfigurationProject(projectName, isLoaded, projectConfigurationsAndPlatforms).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdEditConfigurationProject> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ProjectName);
      writer.Write(value.IsLoaded);
      RdMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo>.Write(ctx, writer, value._ProjectConfigurationsAndPlatforms);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditConfigurationProject (");
      using (printer.IndentCookie()) {
        printer.Print("projectName = "); ProjectName.PrintEx(printer); printer.Println();
        printer.Print("isLoaded = "); IsLoaded.PrintEx(printer); printer.Println();
        printer.Print("projectConfigurationsAndPlatforms = "); _ProjectConfigurationsAndPlatforms.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditConfigurationProjectInfo : IPrintable, IEquatable<RdEditConfigurationProjectInfo>
  {
    //fields
    //public fields
    [CanBeNull] public RdConfigurationAndPlatform BaseConfigurationAndPlatform {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditConfigurationProjectInfo(
      [CanBeNull] RdConfigurationAndPlatform baseConfigurationAndPlatform
    )
    {
      BaseConfigurationAndPlatform = baseConfigurationAndPlatform;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditConfigurationProjectInfo> Read = (ctx, reader) => 
    {
      var baseConfigurationAndPlatform = ReadRdConfigurationAndPlatformNullable(ctx, reader);
      return new RdEditConfigurationProjectInfo(baseConfigurationAndPlatform);
    };
    public static CtxReadDelegate<RdConfigurationAndPlatform> ReadRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Read.NullableClass();
    
    public static CtxWriteDelegate<RdEditConfigurationProjectInfo> Write = (ctx, writer, value) => 
    {
      WriteRdConfigurationAndPlatformNullable(ctx, writer, value.BaseConfigurationAndPlatform);
    };
    public static CtxWriteDelegate<RdConfigurationAndPlatform> WriteRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEditConfigurationProjectInfo) obj);
    }
    public bool Equals(RdEditConfigurationProjectInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(BaseConfigurationAndPlatform, other.BaseConfigurationAndPlatform);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (BaseConfigurationAndPlatform != null ?BaseConfigurationAndPlatform.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditConfigurationProjectInfo (");
      using (printer.IndentCookie()) {
        printer.Print("baseConfigurationAndPlatform = "); BaseConfigurationAndPlatform.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditConfigurationTable : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdEditConfigurationTableRow> Rows { get { return _Rows; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdEditConfigurationTableRow> _Rows;
    
    //primary constructor
    private RdEditConfigurationTable(
      [NotNull] RdMap<int, RdEditConfigurationTableRow> rows
    )
    {
      if (rows == null) throw new ArgumentNullException("rows");
      
      _Rows = rows;
      BindableChildren.Add(new KeyValuePair<string, object>("rows", _Rows));
    }
    //secondary constructor
    public RdEditConfigurationTable (
    ) : this (
      new RdMap<int, RdEditConfigurationTableRow>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdEditConfigurationTableRow.Read, RdEditConfigurationTableRow.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEditConfigurationTable> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var rows = RdMap<int, RdEditConfigurationTableRow>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdEditConfigurationTableRow.Read, RdEditConfigurationTableRow.Write);
      return new RdEditConfigurationTable(rows).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdEditConfigurationTable> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdMap<int, RdEditConfigurationTableRow>.Write(ctx, writer, value._Rows);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditConfigurationTable (");
      using (printer.IndentCookie()) {
        printer.Print("rows = "); _Rows.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditConfigurationTableRow : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdConfigurationAndPlatform> ConfigurationAndPlatform { get { return _ConfigurationAndPlatform; }}
    [NotNull] public IRdProperty<bool> ShouldBuild { get { return _ShouldBuild; }}
    [NotNull] public IRdProperty<bool> ShouldDeploy { get { return _ShouldDeploy; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdConfigurationAndPlatform> _ConfigurationAndPlatform;
    [NotNull] private readonly RdProperty<bool> _ShouldBuild;
    [NotNull] private readonly RdProperty<bool> _ShouldDeploy;
    
    //primary constructor
    private RdEditConfigurationTableRow(
      [NotNull] RdProperty<RdConfigurationAndPlatform> configurationAndPlatform,
      [NotNull] RdProperty<bool> shouldBuild,
      [NotNull] RdProperty<bool> shouldDeploy
    )
    {
      if (configurationAndPlatform == null) throw new ArgumentNullException("configurationAndPlatform");
      if (shouldBuild == null) throw new ArgumentNullException("shouldBuild");
      if (shouldDeploy == null) throw new ArgumentNullException("shouldDeploy");
      
      _ConfigurationAndPlatform = configurationAndPlatform;
      _ShouldBuild = shouldBuild;
      _ShouldDeploy = shouldDeploy;
      _ConfigurationAndPlatform.OptimizeNested = true;
      _ShouldBuild.OptimizeNested = true;
      _ShouldDeploy.OptimizeNested = true;
      _ConfigurationAndPlatform.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("configurationAndPlatform", _ConfigurationAndPlatform));
      BindableChildren.Add(new KeyValuePair<string, object>("shouldBuild", _ShouldBuild));
      BindableChildren.Add(new KeyValuePair<string, object>("shouldDeploy", _ShouldDeploy));
    }
    //secondary constructor
    public RdEditConfigurationTableRow (
    ) : this (
      new RdProperty<RdConfigurationAndPlatform>(ReadRdConfigurationAndPlatformNullable, WriteRdConfigurationAndPlatformNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEditConfigurationTableRow> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var configurationAndPlatform = RdProperty<RdConfigurationAndPlatform>.Read(ctx, reader, ReadRdConfigurationAndPlatformNullable, WriteRdConfigurationAndPlatformNullable);
      var shouldBuild = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var shouldDeploy = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdEditConfigurationTableRow(configurationAndPlatform, shouldBuild, shouldDeploy).WithId(_id);
    };
    public static CtxReadDelegate<RdConfigurationAndPlatform> ReadRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Read.NullableClass();
    
    public static CtxWriteDelegate<RdEditConfigurationTableRow> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<RdConfigurationAndPlatform>.Write(ctx, writer, value._ConfigurationAndPlatform);
      RdProperty<bool>.Write(ctx, writer, value._ShouldBuild);
      RdProperty<bool>.Write(ctx, writer, value._ShouldDeploy);
    };
    public static CtxWriteDelegate<RdConfigurationAndPlatform> WriteRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditConfigurationTableRow (");
      using (printer.IndentCookie()) {
        printer.Print("configurationAndPlatform = "); _ConfigurationAndPlatform.PrintEx(printer); printer.Println();
        printer.Print("shouldBuild = "); _ShouldBuild.PrintEx(printer); printer.Println();
        printer.Print("shouldDeploy = "); _ShouldDeploy.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditConfigurationView : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdEditConfigurationProject> Projects { get { return _Projects; }}
    [NotNull] public IViewableMap<RdConfigurationAndPlatform, RdEditConfigurationTable> Tables { get { return _Tables; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdEditConfigurationProject> _Projects;
    [NotNull] private readonly RdMap<RdConfigurationAndPlatform, RdEditConfigurationTable> _Tables;
    
    //primary constructor
    private RdEditConfigurationView(
      [NotNull] RdMap<int, RdEditConfigurationProject> projects,
      [NotNull] RdMap<RdConfigurationAndPlatform, RdEditConfigurationTable> tables
    )
    {
      if (projects == null) throw new ArgumentNullException("projects");
      if (tables == null) throw new ArgumentNullException("tables");
      
      _Projects = projects;
      _Tables = tables;
      BindableChildren.Add(new KeyValuePair<string, object>("projects", _Projects));
      BindableChildren.Add(new KeyValuePair<string, object>("tables", _Tables));
    }
    //secondary constructor
    public RdEditConfigurationView (
    ) : this (
      new RdMap<int, RdEditConfigurationProject>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdEditConfigurationProject.Read, RdEditConfigurationProject.Write),
      new RdMap<RdConfigurationAndPlatform, RdEditConfigurationTable>(RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write, RdEditConfigurationTable.Read, RdEditConfigurationTable.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEditConfigurationView> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var projects = RdMap<int, RdEditConfigurationProject>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdEditConfigurationProject.Read, RdEditConfigurationProject.Write);
      var tables = RdMap<RdConfigurationAndPlatform, RdEditConfigurationTable>.Read(ctx, reader, RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write, RdEditConfigurationTable.Read, RdEditConfigurationTable.Write);
      return new RdEditConfigurationView(projects, tables).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdEditConfigurationView> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdMap<int, RdEditConfigurationProject>.Write(ctx, writer, value._Projects);
      RdMap<RdConfigurationAndPlatform, RdEditConfigurationTable>.Write(ctx, writer, value._Tables);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditConfigurationView (");
      using (printer.IndentCookie()) {
        printer.Print("projects = "); _Projects.PrintEx(printer); printer.Println();
        printer.Print("tables = "); _Tables.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditProjectItemPropertiesContent : RdEditPropertiesSessionContent
  {
    //fields
    //public fields
    [NotNull] public List<RdEditPropertySection> Sections {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditProjectItemPropertiesContent(
      [NotNull] List<RdEditPropertySection> sections
    )
    {
      if (sections == null) throw new ArgumentNullException("sections");
      
      Sections = sections;
      BindableChildren.Add(new KeyValuePair<string, object>("sections", Sections));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditProjectItemPropertiesContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var sections = ReadRdEditPropertySectionList(ctx, reader);
      return new RdEditProjectItemPropertiesContent(sections).WithId(_id);
    };
    public static CtxReadDelegate<List<RdEditPropertySection>> ReadRdEditPropertySectionList = RdEditPropertySection.Read.List();
    
    public static new CtxWriteDelegate<RdEditProjectItemPropertiesContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdEditPropertySectionList(ctx, writer, value.Sections);
    };
    public static CtxWriteDelegate<List<RdEditPropertySection>> WriteRdEditPropertySectionList = RdEditPropertySection.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditProjectItemPropertiesContent (");
      using (printer.IndentCookie()) {
        printer.Print("sections = "); Sections.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditProjectPropertiesContent : RdEditPropertiesSessionContent
  {
    //fields
    //public fields
    [NotNull] public List<RdEditProjectPropertyTabGroup> TabGroups {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditProjectPropertiesContent(
      [NotNull] List<RdEditProjectPropertyTabGroup> tabGroups
    )
    {
      if (tabGroups == null) throw new ArgumentNullException("tabGroups");
      
      TabGroups = tabGroups;
      BindableChildren.Add(new KeyValuePair<string, object>("tabGroups", TabGroups));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditProjectPropertiesContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var tabGroups = ReadRdEditProjectPropertyTabGroupList(ctx, reader);
      return new RdEditProjectPropertiesContent(tabGroups).WithId(_id);
    };
    public static CtxReadDelegate<List<RdEditProjectPropertyTabGroup>> ReadRdEditProjectPropertyTabGroupList = RdEditProjectPropertyTabGroup.Read.List();
    
    public static new CtxWriteDelegate<RdEditProjectPropertiesContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdEditProjectPropertyTabGroupList(ctx, writer, value.TabGroups);
    };
    public static CtxWriteDelegate<List<RdEditProjectPropertyTabGroup>> WriteRdEditProjectPropertyTabGroupList = RdEditProjectPropertyTabGroup.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditProjectPropertiesContent (");
      using (printer.IndentCookie()) {
        printer.Print("tabGroups = "); TabGroups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditProjectPropertySectionsTab : RdEditProjectPropertyTab
  {
    //fields
    //public fields
    [NotNull] public List<RdEditPropertySection> Sections {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditProjectPropertySectionsTab(
      [NotNull] List<RdEditPropertySection> sections,
      [NotNull] string title
    ) : base (
      title
     ) 
    {
      if (sections == null) throw new ArgumentNullException("sections");
      
      Sections = sections;
      BindableChildren.Add(new KeyValuePair<string, object>("sections", Sections));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditProjectPropertySectionsTab> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var sections = ReadRdEditPropertySectionList(ctx, reader);
      return new RdEditProjectPropertySectionsTab(sections, title).WithId(_id);
    };
    public static CtxReadDelegate<List<RdEditPropertySection>> ReadRdEditPropertySectionList = RdEditPropertySection.Read.List();
    
    public static new CtxWriteDelegate<RdEditProjectPropertySectionsTab> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      WriteRdEditPropertySectionList(ctx, writer, value.Sections);
    };
    public static CtxWriteDelegate<List<RdEditPropertySection>> WriteRdEditPropertySectionList = RdEditPropertySection.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditProjectPropertySectionsTab (");
      using (printer.IndentCookie()) {
        printer.Print("sections = "); Sections.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdEditProjectPropertyTab : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    
    //private fields
    //primary constructor
    protected RdEditProjectPropertyTab(
      [NotNull] string title
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      
      Title = title;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditProjectPropertyTab> Read = Polymorphic<RdEditProjectPropertyTab>.ReadAbstract(RdEditProjectPropertyTab_Unknown.Read);
    
    public static CtxWriteDelegate<RdEditProjectPropertyTab> Write = Polymorphic<RdEditProjectPropertyTab>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEditProjectPropertyTabGroup : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public List<RdEditProjectPropertyTab> Tabs {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditProjectPropertyTabGroup(
      [NotNull] string title,
      [NotNull] List<RdEditProjectPropertyTab> tabs
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (tabs == null) throw new ArgumentNullException("tabs");
      
      Title = title;
      Tabs = tabs;
      BindableChildren.Add(new KeyValuePair<string, object>("tabs", Tabs));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditProjectPropertyTabGroup> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var tabs = ReadRdEditProjectPropertyTabList(ctx, reader);
      return new RdEditProjectPropertyTabGroup(title, tabs).WithId(_id);
    };
    public static CtxReadDelegate<List<RdEditProjectPropertyTab>> ReadRdEditProjectPropertyTabList = RdEditProjectPropertyTab.Read.List();
    
    public static CtxWriteDelegate<RdEditProjectPropertyTabGroup> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      WriteRdEditProjectPropertyTabList(ctx, writer, value.Tabs);
    };
    public static CtxWriteDelegate<List<RdEditProjectPropertyTab>> WriteRdEditProjectPropertyTabList = RdEditProjectPropertyTab.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditProjectPropertyTabGroup (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("tabs = "); Tabs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditProjectPropertyTab_Unknown : RdEditProjectPropertyTab
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdEditProjectPropertyTab_Unknown(
      [NotNull] string title
    ) : base (
      title
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditProjectPropertyTab_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      return new RdEditProjectPropertyTab_Unknown(title).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdEditProjectPropertyTab_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditProjectPropertyTab_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditProjectPropertyTableTab : RdEditProjectPropertyTab
  {
    //fields
    //public fields
    [NotNull] public List<string> Columns {get; private set;}
    [NotNull] public List<RdEditPropertyTableRow> Values {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditProjectPropertyTableTab(
      [NotNull] List<string> columns,
      [NotNull] List<RdEditPropertyTableRow> values,
      [NotNull] string title
    ) : base (
      title
     ) 
    {
      if (columns == null) throw new ArgumentNullException("columns");
      if (values == null) throw new ArgumentNullException("values");
      
      Columns = columns;
      Values = values;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditProjectPropertyTableTab> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var columns = ReadStringList(ctx, reader);
      var values = ReadRdEditPropertyTableRowList(ctx, reader);
      return new RdEditProjectPropertyTableTab(columns, values, title).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<RdEditPropertyTableRow>> ReadRdEditPropertyTableRowList = RdEditPropertyTableRow.Read.List();
    
    public static new CtxWriteDelegate<RdEditProjectPropertyTableTab> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      WriteStringList(ctx, writer, value.Columns);
      WriteRdEditPropertyTableRowList(ctx, writer, value.Values);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<RdEditPropertyTableRow>> WriteRdEditPropertyTableRowList = RdEditPropertyTableRow.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditProjectPropertyTableTab (");
      using (printer.IndentCookie()) {
        printer.Print("columns = "); Columns.PrintEx(printer); printer.Println();
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertiesMessageContent : RdEditPropertiesSessionContent
  {
    //fields
    //public fields
    [NotNull] public string Message {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertiesMessageContent(
      [NotNull] string message
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertiesMessageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var message = reader.ReadString();
      return new RdEditPropertiesMessageContent(message).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdEditPropertiesMessageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Message);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertiesMessageContent (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertiesSession : RdBindableBase
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    [NotNull] public IRdProperty<RdEditPropertiesSessionContent> Content { get { return _Content; }}
    [NotNull] public IRdProperty<bool> ContentInitialized { get { return _ContentInitialized; }}
    [NotNull] public ISink<RdVoid> Save { get { return _Save; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdEditPropertiesSessionContent> _Content;
    [NotNull] private readonly RdProperty<bool> _ContentInitialized;
    [NotNull] private readonly RdSignal<RdVoid> _Save;
    
    //primary constructor
    private RdEditPropertiesSession(
      int itemId,
      [NotNull] RdProperty<RdEditPropertiesSessionContent> content,
      [NotNull] RdProperty<bool> contentInitialized,
      [NotNull] RdSignal<RdVoid> save
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      if (contentInitialized == null) throw new ArgumentNullException("contentInitialized");
      if (save == null) throw new ArgumentNullException("save");
      
      ItemId = itemId;
      _Content = content;
      _ContentInitialized = contentInitialized;
      _Save = save;
      _ContentInitialized.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
      BindableChildren.Add(new KeyValuePair<string, object>("contentInitialized", _ContentInitialized));
      BindableChildren.Add(new KeyValuePair<string, object>("save", _Save));
    }
    //secondary constructor
    public RdEditPropertiesSession (
      int itemId
    ) : this (
      itemId,
      new RdProperty<RdEditPropertiesSessionContent>(RdEditPropertiesSessionContent.Read, RdEditPropertiesSessionContent.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEditPropertiesSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var itemId = reader.ReadInt();
      var content = RdProperty<RdEditPropertiesSessionContent>.Read(ctx, reader, RdEditPropertiesSessionContent.Read, RdEditPropertiesSessionContent.Write);
      var contentInitialized = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var save = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdEditPropertiesSession(itemId, content, contentInitialized, save).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdEditPropertiesSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ItemId);
      RdProperty<RdEditPropertiesSessionContent>.Write(ctx, writer, value._Content);
      RdProperty<bool>.Write(ctx, writer, value._ContentInitialized);
      RdSignal<RdVoid>.Write(ctx, writer, value._Save);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertiesSession (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
        printer.Print("contentInitialized = "); _ContentInitialized.PrintEx(printer); printer.Println();
        printer.Print("save = "); _Save.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdEditPropertiesSessionContent : RdBindableBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertiesSessionContent> Read = Polymorphic<RdEditPropertiesSessionContent>.ReadAbstract(RdEditPropertiesSessionContent_Unknown.Read);
    
    public static CtxWriteDelegate<RdEditPropertiesSessionContent> Write = Polymorphic<RdEditPropertiesSessionContent>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEditPropertiesSessionContent_Unknown : RdEditPropertiesSessionContent
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertiesSessionContent_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new RdEditPropertiesSessionContent_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdEditPropertiesSessionContent_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertiesSessionContent_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdEditPropertyBinding{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertyBinding> Read = Polymorphic<RdEditPropertyBinding>.ReadAbstract(RdEditPropertyBinding_Unknown.Read);
    
    public static CtxWriteDelegate<RdEditPropertyBinding> Write = Polymorphic<RdEditPropertyBinding>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEditPropertyBinding_Unknown : RdEditPropertyBinding
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyBinding_Unknown> Read = (ctx, reader) => 
    {
      return new RdEditPropertyBinding_Unknown();
    };
    
    public static new CtxWriteDelegate<RdEditPropertyBinding_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEditPropertyBinding_Unknown) obj);
    }
    public bool Equals(RdEditPropertyBinding_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyBinding_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyCompoundBinding : RdEditPropertyBinding
  {
    //fields
    //public fields
    [NotNull] public List<RdEditPropertyBinding> Bindings {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyCompoundBinding(
      [NotNull] List<RdEditPropertyBinding> bindings
    )
    {
      if (bindings == null) throw new ArgumentNullException("bindings");
      
      Bindings = bindings;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyCompoundBinding> Read = (ctx, reader) => 
    {
      var bindings = ReadRdEditPropertyBindingList(ctx, reader);
      return new RdEditPropertyCompoundBinding(bindings);
    };
    public static CtxReadDelegate<List<RdEditPropertyBinding>> ReadRdEditPropertyBindingList = RdEditPropertyBinding.Read.List();
    
    public static new CtxWriteDelegate<RdEditPropertyCompoundBinding> Write = (ctx, writer, value) => 
    {
      WriteRdEditPropertyBindingList(ctx, writer, value.Bindings);
    };
    public static CtxWriteDelegate<List<RdEditPropertyBinding>> WriteRdEditPropertyBindingList = RdEditPropertyBinding.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEditPropertyCompoundBinding) obj);
    }
    public bool Equals(RdEditPropertyCompoundBinding other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Bindings.SequenceEqual(other.Bindings);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Bindings);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyCompoundBinding (");
      using (printer.IndentCookie()) {
        printer.Print("bindings = "); Bindings.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyEnableBinding : RdEditPropertyBinding
  {
    //fields
    //public fields
    [NotNull] public string ElementId {get; private set;}
    [NotNull] public string EnableWhen {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyEnableBinding(
      [NotNull] string elementId,
      [NotNull] string enableWhen
    )
    {
      if (elementId == null) throw new ArgumentNullException("elementId");
      if (enableWhen == null) throw new ArgumentNullException("enableWhen");
      
      ElementId = elementId;
      EnableWhen = enableWhen;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyEnableBinding> Read = (ctx, reader) => 
    {
      var elementId = reader.ReadString();
      var enableWhen = reader.ReadString();
      return new RdEditPropertyEnableBinding(elementId, enableWhen);
    };
    
    public static new CtxWriteDelegate<RdEditPropertyEnableBinding> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementId);
      writer.Write(value.EnableWhen);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEditPropertyEnableBinding) obj);
    }
    public bool Equals(RdEditPropertyEnableBinding other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementId == other.ElementId && EnableWhen == other.EnableWhen;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ElementId.GetHashCode();
        hash = hash * 31 + EnableWhen.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyEnableBinding (");
      using (printer.IndentCookie()) {
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("enableWhen = "); EnableWhen.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdEditPropertyItem : RdBindableBase
  {
    //fields
    //public fields
    [CanBeNull] public string Id {get; private set;}
    [NotNull] public string Title {get; private set;}
    [CanBeNull] public RdEditPropertyBinding Binding {get; private set;}
    
    //private fields
    //primary constructor
    protected RdEditPropertyItem(
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      
      Id = id;
      Title = title;
      Binding = binding;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertyItem> Read = Polymorphic<RdEditPropertyItem>.ReadAbstract(RdEditPropertyItem_Unknown.Read);
    
    public static CtxWriteDelegate<RdEditPropertyItem> Write = Polymorphic<RdEditPropertyItem>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEditPropertyItemCheck : RdEditPropertyItem
  {
    //fields
    //public fields
    public bool ReadonlyValue {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyItemCheck(
      bool readonlyValue,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
      ReadonlyValue = readonlyValue;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemCheck> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      var readonlyValue = reader.ReadBool();
      return new RdEditPropertyItemCheck(readonlyValue, id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyItemCheck> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
      writer.Write(value.ReadonlyValue);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemCheck (");
      using (printer.IndentCookie()) {
        printer.Print("readonlyValue = "); ReadonlyValue.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemCheckBox : RdEditPropertyItem
  {
    //fields
    //public fields
    public bool InitialValue {get; private set;}
    [NotNull] public IRdProperty<bool> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Value;
    
    //primary constructor
    private RdEditPropertyItemCheckBox(
      bool initialValue,
      [NotNull] RdProperty<bool> value,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      InitialValue = initialValue;
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public RdEditPropertyItemCheckBox (
      bool initialValue,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : this (
      initialValue,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      id,
      title,
      binding
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemCheckBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      var initialValue = reader.ReadBool();
      var value = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdEditPropertyItemCheckBox(initialValue, value, id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyItemCheckBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
      writer.Write(value.InitialValue);
      RdProperty<bool>.Write(ctx, writer, value._Value);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemCheckBox (");
      using (printer.IndentCookie()) {
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemComboBox : RdEditPropertyItem
  {
    //fields
    //public fields
    [NotNull] public List<RdEditPropertyItemComboBoxValue> Values {get; private set;}
    [NotNull] public RdEditPropertyItemComboBoxValue InitialValue {get; private set;}
    [NotNull] public IRdProperty<RdEditPropertyItemComboBoxValue> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdEditPropertyItemComboBoxValue> _Value;
    
    //primary constructor
    private RdEditPropertyItemComboBox(
      [NotNull] List<RdEditPropertyItemComboBoxValue> values,
      [NotNull] RdEditPropertyItemComboBoxValue initialValue,
      [NotNull] RdProperty<RdEditPropertyItemComboBoxValue> value,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
      if (values == null) throw new ArgumentNullException("values");
      if (initialValue == null) throw new ArgumentNullException("initialValue");
      if (value == null) throw new ArgumentNullException("value");
      
      Values = values;
      InitialValue = initialValue;
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public RdEditPropertyItemComboBox (
      [NotNull] List<RdEditPropertyItemComboBoxValue> values,
      [NotNull] RdEditPropertyItemComboBoxValue initialValue,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : this (
      values,
      initialValue,
      new RdProperty<RdEditPropertyItemComboBoxValue>(RdEditPropertyItemComboBoxValue.Read, RdEditPropertyItemComboBoxValue.Write),
      id,
      title,
      binding
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemComboBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      var values = ReadRdEditPropertyItemComboBoxValueList(ctx, reader);
      var initialValue = RdEditPropertyItemComboBoxValue.Read(ctx, reader);
      var value = RdProperty<RdEditPropertyItemComboBoxValue>.Read(ctx, reader, RdEditPropertyItemComboBoxValue.Read, RdEditPropertyItemComboBoxValue.Write);
      return new RdEditPropertyItemComboBox(values, initialValue, value, id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<List<RdEditPropertyItemComboBoxValue>> ReadRdEditPropertyItemComboBoxValueList = RdEditPropertyItemComboBoxValue.Read.List();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyItemComboBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
      WriteRdEditPropertyItemComboBoxValueList(ctx, writer, value.Values);
      RdEditPropertyItemComboBoxValue.Write(ctx, writer, value.InitialValue);
      RdProperty<RdEditPropertyItemComboBoxValue>.Write(ctx, writer, value._Value);
    };
    public static CtxWriteDelegate<List<RdEditPropertyItemComboBoxValue>> WriteRdEditPropertyItemComboBoxValueList = RdEditPropertyItemComboBoxValue.Write.List();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemComboBox (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemComboBoxValue : IPrintable, IEquatable<RdEditPropertyItemComboBoxValue>
  {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyItemComboBoxValue(
      [NotNull] string id,
      [NotNull] string text
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (text == null) throw new ArgumentNullException("text");
      
      Id = id;
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertyItemComboBoxValue> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var text = reader.ReadString();
      return new RdEditPropertyItemComboBoxValue(id, text);
    };
    
    public static CtxWriteDelegate<RdEditPropertyItemComboBoxValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Text);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEditPropertyItemComboBoxValue) obj);
    }
    public bool Equals(RdEditPropertyItemComboBoxValue other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Text == other.Text;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemComboBoxValue (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemLabel : RdEditPropertyItem
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyItemLabel(
      [NotNull] string text,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemLabel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      var text = reader.ReadString();
      return new RdEditPropertyItemLabel(text, id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyItemLabel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
      writer.Write(value.Text);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemLabel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemText : RdEditPropertyItem
  {
    //fields
    //public fields
    [NotNull] public string ReadonlyValue {get; private set;}
    public bool Multiline {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyItemText(
      [NotNull] string readonlyValue,
      bool multiline,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
      if (readonlyValue == null) throw new ArgumentNullException("readonlyValue");
      
      ReadonlyValue = readonlyValue;
      Multiline = multiline;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemText> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      var readonlyValue = reader.ReadString();
      var multiline = reader.ReadBool();
      return new RdEditPropertyItemText(readonlyValue, multiline, id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyItemText> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
      writer.Write(value.ReadonlyValue);
      writer.Write(value.Multiline);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemText (");
      using (printer.IndentCookie()) {
        printer.Print("readonlyValue = "); ReadonlyValue.PrintEx(printer); printer.Println();
        printer.Print("multiline = "); Multiline.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemTextBox : RdEditPropertyItem
  {
    //fields
    //public fields
    [NotNull] public string InitialValue {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    public bool Multiline {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private RdEditPropertyItemTextBox(
      [NotNull] string initialValue,
      [NotNull] RdProperty<string> value,
      bool multiline,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
      if (initialValue == null) throw new ArgumentNullException("initialValue");
      if (value == null) throw new ArgumentNullException("value");
      
      InitialValue = initialValue;
      _Value = value;
      Multiline = multiline;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public RdEditPropertyItemTextBox (
      [NotNull] string initialValue,
      bool multiline,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : this (
      initialValue,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      multiline,
      id,
      title,
      binding
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemTextBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      var initialValue = reader.ReadString();
      var value = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var multiline = reader.ReadBool();
      return new RdEditPropertyItemTextBox(initialValue, value, multiline, id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyItemTextBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
      writer.Write(value.InitialValue);
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.Multiline);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemTextBox (");
      using (printer.IndentCookie()) {
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("multiline = "); Multiline.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItem_Unknown : RdEditPropertyItem
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdEditPropertyItem_Unknown(
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItem_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      return new RdEditPropertyItem_Unknown(id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyItem_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItem_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyMultiList : RdEditPropertyItem
  {
    //fields
    //public fields
    [NotNull] public List<RdEditPropertyItemComboBoxValue> AllValues {get; private set;}
    [NotNull] public List<RdEditPropertyItemComboBoxValue> InitialValues {get; private set;}
    [NotNull] public IRdProperty<List<RdEditPropertyItemComboBoxValue>> Values { get { return _Values; }}
    [CanBeNull] public string EditMessage {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<RdEditPropertyItemComboBoxValue>> _Values;
    
    //primary constructor
    private RdEditPropertyMultiList(
      [NotNull] List<RdEditPropertyItemComboBoxValue> allValues,
      [NotNull] List<RdEditPropertyItemComboBoxValue> initialValues,
      [NotNull] RdProperty<List<RdEditPropertyItemComboBoxValue>> values,
      [CanBeNull] string editMessage,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
      if (allValues == null) throw new ArgumentNullException("allValues");
      if (initialValues == null) throw new ArgumentNullException("initialValues");
      if (values == null) throw new ArgumentNullException("values");
      
      AllValues = allValues;
      InitialValues = initialValues;
      _Values = values;
      EditMessage = editMessage;
      _Values.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("values", _Values));
    }
    //secondary constructor
    public RdEditPropertyMultiList (
      [NotNull] List<RdEditPropertyItemComboBoxValue> allValues,
      [NotNull] List<RdEditPropertyItemComboBoxValue> initialValues,
      [CanBeNull] string editMessage,
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : this (
      allValues,
      initialValues,
      new RdProperty<List<RdEditPropertyItemComboBoxValue>>(ReadRdEditPropertyItemComboBoxValueList, WriteRdEditPropertyItemComboBoxValueList),
      editMessage,
      id,
      title,
      binding
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyMultiList> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      var allValues = ReadRdEditPropertyItemComboBoxValueList(ctx, reader);
      var initialValues = ReadRdEditPropertyItemComboBoxValueList(ctx, reader);
      var values = RdProperty<List<RdEditPropertyItemComboBoxValue>>.Read(ctx, reader, ReadRdEditPropertyItemComboBoxValueList, WriteRdEditPropertyItemComboBoxValueList);
      var editMessage = ReadStringNullable(ctx, reader);
      return new RdEditPropertyMultiList(allValues, initialValues, values, editMessage, id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<List<RdEditPropertyItemComboBoxValue>> ReadRdEditPropertyItemComboBoxValueList = RdEditPropertyItemComboBoxValue.Read.List();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertyMultiList> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
      WriteRdEditPropertyItemComboBoxValueList(ctx, writer, value.AllValues);
      WriteRdEditPropertyItemComboBoxValueList(ctx, writer, value.InitialValues);
      RdProperty<List<RdEditPropertyItemComboBoxValue>>.Write(ctx, writer, value._Values);
      WriteStringNullable(ctx, writer, value.EditMessage);
    };
    public static CtxWriteDelegate<List<RdEditPropertyItemComboBoxValue>> WriteRdEditPropertyItemComboBoxValueList = RdEditPropertyItemComboBoxValue.Write.List();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyMultiList (");
      using (printer.IndentCookie()) {
        printer.Print("allValues = "); AllValues.PrintEx(printer); printer.Println();
        printer.Print("initialValues = "); InitialValues.PrintEx(printer); printer.Println();
        printer.Print("values = "); _Values.PrintEx(printer); printer.Println();
        printer.Print("editMessage = "); EditMessage.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertySection : RdBindableBase
  {
    //fields
    //public fields
    [CanBeNull] public string Title {get; private set;}
    [NotNull] public List<RdEditPropertyItem> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertySection(
      [CanBeNull] string title,
      [NotNull] List<RdEditPropertyItem> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Title = title;
      Items = items;
      BindableChildren.Add(new KeyValuePair<string, object>("items", Items));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertySection> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = ReadStringNullable(ctx, reader);
      var items = ReadRdEditPropertyItemList(ctx, reader);
      return new RdEditPropertySection(title, items).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdEditPropertyItem>> ReadRdEditPropertyItemList = RdEditPropertyItem.Read.List();
    
    public static CtxWriteDelegate<RdEditPropertySection> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Title);
      WriteRdEditPropertyItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdEditPropertyItem>> WriteRdEditPropertyItemList = RdEditPropertyItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertySection (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertySeparator : RdEditPropertyItem
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdEditPropertySeparator(
      [CanBeNull] string id,
      [NotNull] string title,
      [CanBeNull] RdEditPropertyBinding binding
    ) : base (
      id,
      title,
      binding
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertySeparator> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = ReadStringNullable(ctx, reader);
      var title = reader.ReadString();
      var binding = ReadRdEditPropertyBindingNullable(ctx, reader);
      return new RdEditPropertySeparator(id, title, binding).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdEditPropertyBinding> ReadRdEditPropertyBindingNullable = RdEditPropertyBinding.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditPropertySeparator> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Id);
      writer.Write(value.Title);
      WriteRdEditPropertyBindingNullable(ctx, writer, value.Binding);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdEditPropertyBinding> WriteRdEditPropertyBindingNullable = RdEditPropertyBinding.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertySeparator (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("binding = "); Binding.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyTableRow : IPrintable, IEquatable<RdEditPropertyTableRow>
  {
    //fields
    //public fields
    [NotNull] public List<string> Data {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyTableRow(
      [NotNull] List<string> data
    )
    {
      if (data == null) throw new ArgumentNullException("data");
      
      Data = data;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertyTableRow> Read = (ctx, reader) => 
    {
      var data = ReadStringList(ctx, reader);
      return new RdEditPropertyTableRow(data);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdEditPropertyTableRow> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Data);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEditPropertyTableRow) obj);
    }
    public bool Equals(RdEditPropertyTableRow other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Data.SequenceEqual(other.Data);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Data);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyTableRow (");
      using (printer.IndentCookie()) {
        printer.Print("data = "); Data.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyVisibleBinding : RdEditPropertyBinding
  {
    //fields
    //public fields
    [NotNull] public string ElementId {get; private set;}
    [NotNull] public string VisibleWhen {get; private set;}
    
    //private fields
    //primary constructor
    public RdEditPropertyVisibleBinding(
      [NotNull] string elementId,
      [NotNull] string visibleWhen
    )
    {
      if (elementId == null) throw new ArgumentNullException("elementId");
      if (visibleWhen == null) throw new ArgumentNullException("visibleWhen");
      
      ElementId = elementId;
      VisibleWhen = visibleWhen;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyVisibleBinding> Read = (ctx, reader) => 
    {
      var elementId = reader.ReadString();
      var visibleWhen = reader.ReadString();
      return new RdEditPropertyVisibleBinding(elementId, visibleWhen);
    };
    
    public static new CtxWriteDelegate<RdEditPropertyVisibleBinding> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementId);
      writer.Write(value.VisibleWhen);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEditPropertyVisibleBinding) obj);
    }
    public bool Equals(RdEditPropertyVisibleBinding other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementId == other.ElementId && VisibleWhen == other.VisibleWhen;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ElementId.GetHashCode();
        hash = hash * 31 + VisibleWhen.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyVisibleBinding (");
      using (printer.IndentCookie()) {
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("visibleWhen = "); VisibleWhen.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditSolutionPropertiesContent : RdEditPropertiesSessionContent
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdConfigurationAndPlatform> ConfigurationAndPlatform { get { return _ConfigurationAndPlatform; }}
    [NotNull] public IViewableMap<int, RdConfigurationAndPlatform> ConfigurationAndPlatforms { get { return _ConfigurationAndPlatforms; }}
    [NotNull] public RdEditConfigurationView View {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<RdConfigurationAndPlatform> _ConfigurationAndPlatform;
    [NotNull] private readonly RdMap<int, RdConfigurationAndPlatform> _ConfigurationAndPlatforms;
    
    //primary constructor
    private RdEditSolutionPropertiesContent(
      [NotNull] RdProperty<RdConfigurationAndPlatform> configurationAndPlatform,
      [NotNull] RdMap<int, RdConfigurationAndPlatform> configurationAndPlatforms,
      [NotNull] RdEditConfigurationView view
    )
    {
      if (configurationAndPlatform == null) throw new ArgumentNullException("configurationAndPlatform");
      if (configurationAndPlatforms == null) throw new ArgumentNullException("configurationAndPlatforms");
      if (view == null) throw new ArgumentNullException("view");
      
      _ConfigurationAndPlatform = configurationAndPlatform;
      _ConfigurationAndPlatforms = configurationAndPlatforms;
      View = view;
      _ConfigurationAndPlatform.OptimizeNested = true;
      _ConfigurationAndPlatforms.OptimizeNested = true;
      _ConfigurationAndPlatform.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("configurationAndPlatform", _ConfigurationAndPlatform));
      BindableChildren.Add(new KeyValuePair<string, object>("configurationAndPlatforms", _ConfigurationAndPlatforms));
      BindableChildren.Add(new KeyValuePair<string, object>("view", View));
    }
    //secondary constructor
    public RdEditSolutionPropertiesContent (
    ) : this (
      new RdProperty<RdConfigurationAndPlatform>(ReadRdConfigurationAndPlatformNullable, WriteRdConfigurationAndPlatformNullable),
      new RdMap<int, RdConfigurationAndPlatform>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write),
      new RdEditConfigurationView()
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditSolutionPropertiesContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var configurationAndPlatform = RdProperty<RdConfigurationAndPlatform>.Read(ctx, reader, ReadRdConfigurationAndPlatformNullable, WriteRdConfigurationAndPlatformNullable);
      var configurationAndPlatforms = RdMap<int, RdConfigurationAndPlatform>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write);
      var view = RdEditConfigurationView.Read(ctx, reader);
      return new RdEditSolutionPropertiesContent(configurationAndPlatform, configurationAndPlatforms, view).WithId(_id);
    };
    public static CtxReadDelegate<RdConfigurationAndPlatform> ReadRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdEditSolutionPropertiesContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<RdConfigurationAndPlatform>.Write(ctx, writer, value._ConfigurationAndPlatform);
      RdMap<int, RdConfigurationAndPlatform>.Write(ctx, writer, value._ConfigurationAndPlatforms);
      RdEditConfigurationView.Write(ctx, writer, value.View);
    };
    public static CtxWriteDelegate<RdConfigurationAndPlatform> WriteRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditSolutionPropertiesContent (");
      using (printer.IndentCookie()) {
        printer.Print("configurationAndPlatform = "); _ConfigurationAndPlatform.PrintEx(printer); printer.Println();
        printer.Print("configurationAndPlatforms = "); _ConfigurationAndPlatforms.PrintEx(printer); printer.Println();
        printer.Print("view = "); View.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExecuteCustomToolCommand : IPrintable, IEquatable<RdExecuteCustomToolCommand>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    [NotNull] public RdSingleFileCustomTool CustomTool {get; private set;}
    
    //private fields
    //primary constructor
    public RdExecuteCustomToolCommand(
      int itemId,
      [NotNull] RdSingleFileCustomTool customTool
    )
    {
      if (customTool == null) throw new ArgumentNullException("customTool");
      
      ItemId = itemId;
      CustomTool = customTool;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdExecuteCustomToolCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var customTool = RdSingleFileCustomTool.Read(ctx, reader);
      return new RdExecuteCustomToolCommand(itemId, customTool);
    };
    
    public static CtxWriteDelegate<RdExecuteCustomToolCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      RdSingleFileCustomTool.Write(ctx, writer, value.CustomTool);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdExecuteCustomToolCommand) obj);
    }
    public bool Equals(RdExecuteCustomToolCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && Equals(CustomTool, other.CustomTool);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        hash = hash * 31 + CustomTool.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdExecuteCustomToolCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("customTool = "); CustomTool.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveItemData : IPrintable, IEquatable<RdMoveItemData>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    
    //private fields
    //primary constructor
    public RdMoveItemData(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdMoveItemData> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new RdMoveItemData(itemId);
    };
    
    public static CtxWriteDelegate<RdMoveItemData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdMoveItemData) obj);
    }
    public bool Equals(RdMoveItemData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveItemData (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveItemsCommand : IPrintable, IEquatable<RdMoveItemsCommand>
  {
    //fields
    //public fields
    [NotNull] public List<RdMoveItemData> Items {get; private set;}
    public int ParentId {get; private set;}
    [CanBeNull] public RdCommandRelativeTo RelativeTo {get; private set;}
    
    //private fields
    //primary constructor
    public RdMoveItemsCommand(
      [NotNull] List<RdMoveItemData> items,
      int parentId,
      [CanBeNull] RdCommandRelativeTo relativeTo
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      ParentId = parentId;
      RelativeTo = relativeTo;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdMoveItemsCommand> Read = (ctx, reader) => 
    {
      var items = ReadRdMoveItemDataList(ctx, reader);
      var parentId = reader.ReadInt();
      var relativeTo = ReadRdCommandRelativeToNullable(ctx, reader);
      return new RdMoveItemsCommand(items, parentId, relativeTo);
    };
    public static CtxReadDelegate<List<RdMoveItemData>> ReadRdMoveItemDataList = RdMoveItemData.Read.List();
    public static CtxReadDelegate<RdCommandRelativeTo> ReadRdCommandRelativeToNullable = RdCommandRelativeTo.Read.NullableClass();
    
    public static CtxWriteDelegate<RdMoveItemsCommand> Write = (ctx, writer, value) => 
    {
      WriteRdMoveItemDataList(ctx, writer, value.Items);
      writer.Write(value.ParentId);
      WriteRdCommandRelativeToNullable(ctx, writer, value.RelativeTo);
    };
    public static CtxWriteDelegate<List<RdMoveItemData>> WriteRdMoveItemDataList = RdMoveItemData.Write.List();
    public static CtxWriteDelegate<RdCommandRelativeTo> WriteRdCommandRelativeToNullable = RdCommandRelativeTo.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdMoveItemsCommand) obj);
    }
    public bool Equals(RdMoveItemsCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items) && ParentId == other.ParentId && Equals(RelativeTo, other.RelativeTo);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        hash = hash * 31 + ParentId.GetHashCode();
        hash = hash * 31 + (RelativeTo != null ?RelativeTo.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveItemsCommand (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("relativeTo = "); RelativeTo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdProjectModelDumpFlags {
    Structure,
    Full
  }
  
  
  public class RdProjectModelDumpParams : IPrintable, IEquatable<RdProjectModelDumpParams>
  {
    //fields
    //public fields
    public RdProjectModelDumpFlags Category {get; private set;}
    public bool HideMiscFilesProjectContent {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectModelDumpParams(
      RdProjectModelDumpFlags category,
      bool hideMiscFilesProjectContent
    )
    {
      Category = category;
      HideMiscFilesProjectContent = hideMiscFilesProjectContent;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectModelDumpParams> Read = (ctx, reader) => 
    {
      var category = (RdProjectModelDumpFlags)reader.ReadInt();
      var hideMiscFilesProjectContent = reader.ReadBool();
      return new RdProjectModelDumpParams(category, hideMiscFilesProjectContent);
    };
    
    public static CtxWriteDelegate<RdProjectModelDumpParams> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Category);
      writer.Write(value.HideMiscFilesProjectContent);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectModelDumpParams) obj);
    }
    public bool Equals(RdProjectModelDumpParams other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Category == other.Category && HideMiscFilesProjectContent == other.HideMiscFilesProjectContent;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Category;
        hash = hash * 31 + HideMiscFilesProjectContent.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelDumpParams (");
      using (printer.IndentCookie()) {
        printer.Print("category = "); Category.PrintEx(printer); printer.Println();
        printer.Print("hideMiscFilesProjectContent = "); HideMiscFilesProjectContent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTargetFramework : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> CurrentTargetFrameworkId { get { return _CurrentTargetFrameworkId; }}
    [NotNull] public IRdProperty<List<string>> TargetFrameworkIds { get { return _TargetFrameworkIds; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _CurrentTargetFrameworkId;
    [NotNull] private readonly RdProperty<List<string>> _TargetFrameworkIds;
    
    //primary constructor
    private RdProjectTargetFramework(
      [NotNull] RdProperty<string> currentTargetFrameworkId,
      [NotNull] RdProperty<List<string>> targetFrameworkIds
    )
    {
      if (currentTargetFrameworkId == null) throw new ArgumentNullException("currentTargetFrameworkId");
      if (targetFrameworkIds == null) throw new ArgumentNullException("targetFrameworkIds");
      
      _CurrentTargetFrameworkId = currentTargetFrameworkId;
      _TargetFrameworkIds = targetFrameworkIds;
      _CurrentTargetFrameworkId.OptimizeNested = true;
      _TargetFrameworkIds.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("currentTargetFrameworkId", _CurrentTargetFrameworkId));
      BindableChildren.Add(new KeyValuePair<string, object>("targetFrameworkIds", _TargetFrameworkIds));
    }
    //secondary constructor
    public RdProjectTargetFramework (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<List<string>>(ReadStringList, WriteStringList)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdProjectTargetFramework> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var currentTargetFrameworkId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var targetFrameworkIds = RdProperty<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      return new RdProjectTargetFramework(currentTargetFrameworkId, targetFrameworkIds).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdProjectTargetFramework> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._CurrentTargetFrameworkId);
      RdProperty<List<string>>.Write(ctx, writer, value._TargetFrameworkIds);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTargetFramework (");
      using (printer.IndentCookie()) {
        printer.Print("currentTargetFrameworkId = "); _CurrentTargetFrameworkId.PrintEx(printer); printer.Println();
        printer.Print("targetFrameworkIds = "); _TargetFrameworkIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRenameItemData : IPrintable, IEquatable<RdRenameItemData>
  {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public string Name {get; private set;}
    
    //private fields
    //primary constructor
    public RdRenameItemData(
      int id,
      [NotNull] string name
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      
      Id = id;
      Name = name;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdRenameItemData> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var name = reader.ReadString();
      return new RdRenameItemData(id, name);
    };
    
    public static CtxWriteDelegate<RdRenameItemData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Name);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdRenameItemData) obj);
    }
    public bool Equals(RdRenameItemData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdRenameItemData (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRenameItemsCommand : IPrintable, IEquatable<RdRenameItemsCommand>
  {
    //fields
    //public fields
    [NotNull] public List<RdRenameItemData> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RdRenameItemsCommand(
      [NotNull] List<RdRenameItemData> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdRenameItemsCommand> Read = (ctx, reader) => 
    {
      var items = ReadRdRenameItemDataList(ctx, reader);
      return new RdRenameItemsCommand(items);
    };
    public static CtxReadDelegate<List<RdRenameItemData>> ReadRdRenameItemDataList = RdRenameItemData.Read.List();
    
    public static CtxWriteDelegate<RdRenameItemsCommand> Write = (ctx, writer, value) => 
    {
      WriteRdRenameItemDataList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RdRenameItemData>> WriteRdRenameItemDataList = RdRenameItemData.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdRenameItemsCommand) obj);
    }
    public bool Equals(RdRenameItemsCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdRenameItemsCommand (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRenameProjectEvent : IPrintable, IEquatable<RdRenameProjectEvent>
  {
    //fields
    //public fields
    [NotNull] public string OldProjectFile {get; private set;}
    [NotNull] public string NewProjectFile {get; private set;}
    
    //private fields
    //primary constructor
    public RdRenameProjectEvent(
      [NotNull] string oldProjectFile,
      [NotNull] string newProjectFile
    )
    {
      if (oldProjectFile == null) throw new ArgumentNullException("oldProjectFile");
      if (newProjectFile == null) throw new ArgumentNullException("newProjectFile");
      
      OldProjectFile = oldProjectFile;
      NewProjectFile = newProjectFile;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdRenameProjectEvent> Read = (ctx, reader) => 
    {
      var oldProjectFile = reader.ReadString();
      var newProjectFile = reader.ReadString();
      return new RdRenameProjectEvent(oldProjectFile, newProjectFile);
    };
    
    public static CtxWriteDelegate<RdRenameProjectEvent> Write = (ctx, writer, value) => 
    {
      writer.Write(value.OldProjectFile);
      writer.Write(value.NewProjectFile);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdRenameProjectEvent) obj);
    }
    public bool Equals(RdRenameProjectEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return OldProjectFile == other.OldProjectFile && NewProjectFile == other.NewProjectFile;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + OldProjectFile.GetHashCode();
        hash = hash * 31 + NewProjectFile.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdRenameProjectEvent (");
      using (printer.IndentCookie()) {
        printer.Print("oldProjectFile = "); OldProjectFile.PrintEx(printer); printer.Println();
        printer.Print("newProjectFile = "); NewProjectFile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUpdateItemPropertiesCommand : IPrintable, IEquatable<RdUpdateItemPropertiesCommand>
  {
    //fields
    //public fields
    [NotNull] public List<RdUpdatePropertyData> Data {get; private set;}
    
    //private fields
    //primary constructor
    public RdUpdateItemPropertiesCommand(
      [NotNull] List<RdUpdatePropertyData> data
    )
    {
      if (data == null) throw new ArgumentNullException("data");
      
      Data = data;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUpdateItemPropertiesCommand> Read = (ctx, reader) => 
    {
      var data = ReadRdUpdatePropertyDataList(ctx, reader);
      return new RdUpdateItemPropertiesCommand(data);
    };
    public static CtxReadDelegate<List<RdUpdatePropertyData>> ReadRdUpdatePropertyDataList = RdUpdatePropertyData.Read.List();
    
    public static CtxWriteDelegate<RdUpdateItemPropertiesCommand> Write = (ctx, writer, value) => 
    {
      WriteRdUpdatePropertyDataList(ctx, writer, value.Data);
    };
    public static CtxWriteDelegate<List<RdUpdatePropertyData>> WriteRdUpdatePropertyDataList = RdUpdatePropertyData.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUpdateItemPropertiesCommand) obj);
    }
    public bool Equals(RdUpdateItemPropertiesCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Data.SequenceEqual(other.Data);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Data);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUpdateItemPropertiesCommand (");
      using (printer.IndentCookie()) {
        printer.Print("data = "); Data.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUpdatePropertyData : IPrintable, IEquatable<RdUpdatePropertyData>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    [NotNull] public string PropertyName {get; private set;}
    [CanBeNull] public string PropertyValue {get; private set;}
    
    //private fields
    //primary constructor
    public RdUpdatePropertyData(
      int itemId,
      [NotNull] string propertyName,
      [CanBeNull] string propertyValue
    )
    {
      if (propertyName == null) throw new ArgumentNullException("propertyName");
      
      ItemId = itemId;
      PropertyName = propertyName;
      PropertyValue = propertyValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUpdatePropertyData> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var propertyName = reader.ReadString();
      var propertyValue = ReadStringNullable(ctx, reader);
      return new RdUpdatePropertyData(itemId, propertyName, propertyValue);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdUpdatePropertyData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      writer.Write(value.PropertyName);
      WriteStringNullable(ctx, writer, value.PropertyValue);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUpdatePropertyData) obj);
    }
    public bool Equals(RdUpdatePropertyData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && PropertyName == other.PropertyName && Equals(PropertyValue, other.PropertyValue);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        hash = hash * 31 + PropertyName.GetHashCode();
        hash = hash * 31 + (PropertyValue != null ?PropertyValue.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUpdatePropertyData (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("propertyName = "); PropertyName.PrintEx(printer); printer.Println();
        printer.Print("propertyValue = "); PropertyValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ReloadAndShowLogCommand : IPrintable, IEquatable<ReloadAndShowLogCommand>
  {
    //fields
    //public fields
    public int ProjectId {get; private set;}
    
    //private fields
    //primary constructor
    public ReloadAndShowLogCommand(
      int projectId
    )
    {
      ProjectId = projectId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ReloadAndShowLogCommand> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      return new ReloadAndShowLogCommand(projectId);
    };
    
    public static CtxWriteDelegate<ReloadAndShowLogCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ReloadAndShowLogCommand) obj);
    }
    public bool Equals(ReloadAndShowLogCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectId == other.ProjectId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ReloadAndShowLogCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ReloadCommand : IPrintable, IEquatable<ReloadCommand>
  {
    //fields
    //public fields
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //private fields
    //primary constructor
    public ReloadCommand(
      [NotNull] List<int> projectIds
    )
    {
      if (projectIds == null) throw new ArgumentNullException("projectIds");
      
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ReloadCommand> Read = (ctx, reader) => 
    {
      var projectIds = ReadIntList(ctx, reader);
      return new ReloadCommand(projectIds);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<ReloadCommand> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ReloadCommand) obj);
    }
    public bool Equals(ReloadCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ProjectIds);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ReloadCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RemoveCommand : IPrintable, IEquatable<RemoveCommand>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    
    //private fields
    //primary constructor
    public RemoveCommand(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RemoveCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new RemoveCommand(itemId);
    };
    
    public static CtxWriteDelegate<RemoveCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RemoveCommand) obj);
    }
    public bool Equals(RemoveCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RemoveCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class UnloadCommand : IPrintable, IEquatable<UnloadCommand>
  {
    //fields
    //public fields
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //private fields
    //primary constructor
    public UnloadCommand(
      [NotNull] List<int> projectIds
    )
    {
      if (projectIds == null) throw new ArgumentNullException("projectIds");
      
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<UnloadCommand> Read = (ctx, reader) => 
    {
      var projectIds = ReadIntList(ctx, reader);
      return new UnloadCommand(projectIds);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<UnloadCommand> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((UnloadCommand) obj);
    }
    public bool Equals(UnloadCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ProjectIds);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("UnloadCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
