using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class ProjectModelView : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdProjectModelItem> Items { get { return _Items; }}
    [NotNull] public IRdProperty<bool> UpdateCookie { get { return _UpdateCookie; }}
    [NotNull] public ISource<int?> UpdateView { get { return _UpdateView; }}
    [NotNull] public IRdProperty<RdProjectModelSyncData> Sync { get { return _Sync; }}
    [NotNull] public RdEndpoint<int, bool> Expand { get { return _Expand; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdProjectModelItem> _Items;
    [NotNull] private readonly RdProperty<bool> _UpdateCookie;
    [NotNull] private readonly RdSignal<int?> _UpdateView;
    [NotNull] private readonly RdProperty<RdProjectModelSyncData> _Sync;
    [NotNull] private readonly RdEndpoint<int, bool> _Expand;
    
    //primary constructor
    private ProjectModelView(
      [NotNull] RdMap<int, RdProjectModelItem> items,
      [NotNull] RdProperty<bool> updateCookie,
      [NotNull] RdSignal<int?> updateView,
      [NotNull] RdProperty<RdProjectModelSyncData> sync,
      [NotNull] RdEndpoint<int, bool> expand
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      if (updateCookie == null) throw new ArgumentNullException("updateCookie");
      if (updateView == null) throw new ArgumentNullException("updateView");
      if (sync == null) throw new ArgumentNullException("sync");
      if (expand == null) throw new ArgumentNullException("expand");
      
      _Items = items;
      _UpdateCookie = updateCookie;
      _UpdateView = updateView;
      _Sync = sync;
      _Expand = expand;
      _Items.OptimizeNested = true;
      _UpdateCookie.OptimizeNested = true;
      _Sync.OptimizeNested = true;
      _UpdateView.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
      BindableChildren.Add(new KeyValuePair<string, object>("updateCookie", _UpdateCookie));
      BindableChildren.Add(new KeyValuePair<string, object>("updateView", _UpdateView));
      BindableChildren.Add(new KeyValuePair<string, object>("sync", _Sync));
      BindableChildren.Add(new KeyValuePair<string, object>("expand", _Expand));
    }
    //secondary constructor
    internal ProjectModelView (
    ) : this (
      new RdMap<int, RdProjectModelItem>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdProjectModelItem.Read, RdProjectModelItem.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<int?>(ReadIntNullable, WriteIntNullable),
      new RdProperty<RdProjectModelSyncData>(RdProjectModelSyncData.Read, RdProjectModelSyncData.Write),
      new RdEndpoint<int, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    
    protected override long SerializationHash => -2251822336779204852L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(EditableEntityModelId.Read, EditableEntityModelId.Write);
      serializers.Register(EditableEntityPersistentId.Read, EditableEntityPersistentId.Write);
      serializers.Register(SolutionExplorerNavigation.Read, SolutionExplorerNavigation.Write);
      serializers.Register(RdSingleFileCustomTool.Read, RdSingleFileCustomTool.Write);
      serializers.Register(RdNullLocation.Read, RdNullLocation.Write);
      serializers.Register(RdNameLocation.Read, RdNameLocation.Write);
      serializers.Register(RdCustomLocation.Read, RdCustomLocation.Write);
      serializers.Register(RdProjectsCount.Read, RdProjectsCount.Write);
      serializers.Register(RdSolutionDescriptor.Read, RdSolutionDescriptor.Write);
      serializers.Register(RdSolutionFolderDescriptor.Read, RdSolutionFolderDescriptor.Write);
      serializers.Register(RdProjectDescriptor.Read, RdProjectDescriptor.Write);
      serializers.Register(RdProjectFolderDescriptor.Read, RdProjectFolderDescriptor.Write);
      serializers.Register(RdProjectFileDescriptor.Read, RdProjectFileDescriptor.Write);
      serializers.Register(RdUnloadProjectDescriptor.Read, RdUnloadProjectDescriptor.Write);
      serializers.Register(RdAssemblyReferenceDescriptor.Read, RdAssemblyReferenceDescriptor.Write);
      serializers.Register(RdProjectReferenceDescriptor.Read, RdProjectReferenceDescriptor.Write);
      serializers.Register(RdWebReferenceDescriptor.Read, RdWebReferenceDescriptor.Write);
      serializers.Register(RdUnresolvedReferenceDescriptor.Read, RdUnresolvedReferenceDescriptor.Write);
      serializers.Register(RdAnalyzerReferenceDescriptor.Read, RdAnalyzerReferenceDescriptor.Write);
      serializers.Register(RdDependencyFolderDescriptor.Read, RdDependencyFolderDescriptor.Write);
      serializers.Register(RdDependencyDescriptor.Read, RdDependencyDescriptor.Write);
      serializers.Register(RdProjectModelItem.Read, RdProjectModelItem.Write);
      serializers.Register(RdProjectModelSyncData.Read, RdProjectModelSyncData.Write);
      serializers.RegisterEnum<RdSolutionState>();
      serializers.RegisterEnum<RdProjectState>();
      serializers.RegisterEnum<RdUnloadProjectState>();
      serializers.RegisterEnum<RdProjectReferenceType>();
      serializers.RegisterEnum<RdWebReferenceDescriptorType>();
      serializers.RegisterEnum<RdDependencyFolderDescriptorType>();
      serializers.RegisterEnum<RdDependencyType>();
      serializers.Register(RdProjectModelItemLocation_Unknown.Read, RdProjectModelItemLocation_Unknown.Write);
      serializers.Register(RdProjectModelItemDescriptor_Unknown.Read, RdProjectModelItemDescriptor_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModelView (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("updateCookie = "); _UpdateCookie.PrintEx(printer); printer.Println();
        printer.Print("updateView = "); _UpdateView.PrintEx(printer); printer.Println();
        printer.Print("sync = "); _Sync.PrintEx(printer); printer.Println();
        printer.Print("expand = "); _Expand.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionProjectModelViewEx
   {
    public static ProjectModelView GetProjectModelView(this Solution solution)
    {
      return solution.GetOrCreateExtension("projectModelView", () => new ProjectModelView());
    }
  }
  
  
  public class EditableEntityModelId : EditableEntityId
  {
    //fields
    //public fields
    public int ProjectModelElementId {get; private set;}
    
    //private fields
    //primary constructor
    public EditableEntityModelId(
      int projectModelElementId,
      [NotNull] string filePath
    ) : base (
      filePath
     ) 
    {
      ProjectModelElementId = projectModelElementId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<EditableEntityModelId> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var projectModelElementId = reader.ReadInt();
      return new EditableEntityModelId(projectModelElementId, filePath);
    };
    
    public static new CtxWriteDelegate<EditableEntityModelId> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.ProjectModelElementId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EditableEntityModelId) obj);
    }
    public bool Equals(EditableEntityModelId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectModelElementId == other.ProjectModelElementId && FilePath == other.FilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectModelElementId.GetHashCode();
        hash = hash * 31 + FilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntityModelId (");
      using (printer.IndentCookie()) {
        printer.Print("projectModelElementId = "); ProjectModelElementId.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditableEntityPersistentId : EditableEntityId
  {
    //fields
    //public fields
    [NotNull] public string PersistentId {get; private set;}
    
    //private fields
    //primary constructor
    public EditableEntityPersistentId(
      [NotNull] string persistentId,
      [NotNull] string filePath
    ) : base (
      filePath
     ) 
    {
      if (persistentId == null) throw new ArgumentNullException("persistentId");
      
      PersistentId = persistentId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<EditableEntityPersistentId> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var persistentId = reader.ReadString();
      return new EditableEntityPersistentId(persistentId, filePath);
    };
    
    public static new CtxWriteDelegate<EditableEntityPersistentId> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.PersistentId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EditableEntityPersistentId) obj);
    }
    public bool Equals(EditableEntityPersistentId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return PersistentId == other.PersistentId && FilePath == other.FilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + PersistentId.GetHashCode();
        hash = hash * 31 + FilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntityPersistentId (");
      using (printer.IndentCookie()) {
        printer.Print("persistentId = "); PersistentId.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAnalyzerReferenceDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdAnalyzerReferenceDescriptor(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdAnalyzerReferenceDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdAnalyzerReferenceDescriptor(name, location);
    };
    
    public static new CtxWriteDelegate<RdAnalyzerReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAnalyzerReferenceDescriptor) obj);
    }
    public bool Equals(RdAnalyzerReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAnalyzerReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAssemblyReferenceDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    [CanBeNull] public string LinkWarning {get; private set;}
    
    //private fields
    //primary constructor
    public RdAssemblyReferenceDescriptor(
      [CanBeNull] string linkWarning,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      LinkWarning = linkWarning;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdAssemblyReferenceDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var linkWarning = ReadStringNullable(ctx, reader);
      return new RdAssemblyReferenceDescriptor(linkWarning, name, location);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdAssemblyReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      WriteStringNullable(ctx, writer, value.LinkWarning);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAssemblyReferenceDescriptor) obj);
    }
    public bool Equals(RdAssemblyReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(LinkWarning, other.LinkWarning) && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (LinkWarning != null ?LinkWarning.GetHashCode() : 0);
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAssemblyReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("linkWarning = "); LinkWarning.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCustomLocation : RdProjectModelItemLocation
  {
    //fields
    //public fields
    [NotNull] public string CustomLocation {get; private set;}
    
    //private fields
    //primary constructor
    public RdCustomLocation(
      [NotNull] string customLocation
    )
    {
      if (customLocation == null) throw new ArgumentNullException("customLocation");
      
      CustomLocation = customLocation;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdCustomLocation> Read = (ctx, reader) => 
    {
      var customLocation = reader.ReadString();
      return new RdCustomLocation(customLocation);
    };
    
    public static new CtxWriteDelegate<RdCustomLocation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CustomLocation);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCustomLocation) obj);
    }
    public bool Equals(RdCustomLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return CustomLocation == other.CustomLocation;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + CustomLocation.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCustomLocation (");
      using (printer.IndentCookie()) {
        printer.Print("customLocation = "); CustomLocation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDependencyDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public RdDependencyType Type {get; private set;}
    
    //private fields
    //primary constructor
    public RdDependencyDescriptor(
      RdDependencyType type,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      Type = type;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdDependencyDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var type = (RdDependencyType)reader.ReadInt();
      return new RdDependencyDescriptor(type, name, location);
    };
    
    public static new CtxWriteDelegate<RdDependencyDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write((int)value.Type);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDependencyDescriptor) obj);
    }
    public bool Equals(RdDependencyDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Type;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDependencyDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDependencyFolderDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public RdDependencyFolderDescriptorType Type {get; private set;}
    
    //private fields
    //primary constructor
    public RdDependencyFolderDescriptor(
      RdDependencyFolderDescriptorType type,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      Type = type;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdDependencyFolderDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var type = (RdDependencyFolderDescriptorType)reader.ReadInt();
      return new RdDependencyFolderDescriptor(type, name, location);
    };
    
    public static new CtxWriteDelegate<RdDependencyFolderDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write((int)value.Type);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDependencyFolderDescriptor) obj);
    }
    public bool Equals(RdDependencyFolderDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Type;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDependencyFolderDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdDependencyFolderDescriptorType {
    Reference,
    WebReference,
    Framework,
    Hidden,
    Assemblies,
    Projects,
    Analyzers,
    Packages,
    SDK
  }
  
  
  public enum RdDependencyType {
    Dependency,
    Project,
    Package,
    UnresolvedPackage,
    SDK,
    UnresolvedSDK,
    Reference
  }
  
  
  public class RdNameLocation : RdProjectModelItemLocation
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdNameLocation> Read = (ctx, reader) => 
    {
      return new RdNameLocation();
    };
    
    public static new CtxWriteDelegate<RdNameLocation> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNameLocation) obj);
    }
    public bool Equals(RdNameLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNameLocation (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNullLocation : RdProjectModelItemLocation
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdNullLocation> Read = (ctx, reader) => 
    {
      return new RdNullLocation();
    };
    
    public static new CtxWriteDelegate<RdNullLocation> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNullLocation) obj);
    }
    public bool Equals(RdNullLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNullLocation (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public RdProjectState State {get; private set;}
    [CanBeNull] public string Subcaption {get; private set;}
    public bool DirectoryBased {get; private set;}
    public bool IsDotNetCore {get; private set;}
    public bool IsWeb {get; private set;}
    public bool ExcludedFromBuild {get; private set;}
    [CanBeNull] public string BaseDirectory {get; private set;}
    [NotNull] public List<string> KnownTargets {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectDescriptor(
      RdProjectState state,
      [CanBeNull] string subcaption,
      bool directoryBased,
      bool isDotNetCore,
      bool isWeb,
      bool excludedFromBuild,
      [CanBeNull] string baseDirectory,
      [NotNull] List<string> knownTargets,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      if (knownTargets == null) throw new ArgumentNullException("knownTargets");
      
      State = state;
      Subcaption = subcaption;
      DirectoryBased = directoryBased;
      IsDotNetCore = isDotNetCore;
      IsWeb = isWeb;
      ExcludedFromBuild = excludedFromBuild;
      BaseDirectory = baseDirectory;
      KnownTargets = knownTargets;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var state = (RdProjectState)reader.ReadInt();
      var subcaption = ReadStringNullable(ctx, reader);
      var directoryBased = reader.ReadBool();
      var isDotNetCore = reader.ReadBool();
      var isWeb = reader.ReadBool();
      var excludedFromBuild = reader.ReadBool();
      var baseDirectory = ReadStringNullable(ctx, reader);
      var knownTargets = ReadStringList(ctx, reader);
      return new RdProjectDescriptor(state, subcaption, directoryBased, isDotNetCore, isWeb, excludedFromBuild, baseDirectory, knownTargets, name, location);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<RdProjectDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write((int)value.State);
      WriteStringNullable(ctx, writer, value.Subcaption);
      writer.Write(value.DirectoryBased);
      writer.Write(value.IsDotNetCore);
      writer.Write(value.IsWeb);
      writer.Write(value.ExcludedFromBuild);
      WriteStringNullable(ctx, writer, value.BaseDirectory);
      WriteStringList(ctx, writer, value.KnownTargets);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectDescriptor) obj);
    }
    public bool Equals(RdProjectDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && Equals(Subcaption, other.Subcaption) && DirectoryBased == other.DirectoryBased && IsDotNetCore == other.IsDotNetCore && IsWeb == other.IsWeb && ExcludedFromBuild == other.ExcludedFromBuild && Equals(BaseDirectory, other.BaseDirectory) && KnownTargets.SequenceEqual(other.KnownTargets) && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) State;
        hash = hash * 31 + (Subcaption != null ?Subcaption.GetHashCode() : 0);
        hash = hash * 31 + DirectoryBased.GetHashCode();
        hash = hash * 31 + IsDotNetCore.GetHashCode();
        hash = hash * 31 + IsWeb.GetHashCode();
        hash = hash * 31 + ExcludedFromBuild.GetHashCode();
        hash = hash * 31 + (BaseDirectory != null ?BaseDirectory.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(KnownTargets);
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("subcaption = "); Subcaption.PrintEx(printer); printer.Println();
        printer.Print("directoryBased = "); DirectoryBased.PrintEx(printer); printer.Println();
        printer.Print("isDotNetCore = "); IsDotNetCore.PrintEx(printer); printer.Println();
        printer.Print("isWeb = "); IsWeb.PrintEx(printer); printer.Println();
        printer.Print("excludedFromBuild = "); ExcludedFromBuild.PrintEx(printer); printer.Println();
        printer.Print("baseDirectory = "); BaseDirectory.PrintEx(printer); printer.Println();
        printer.Print("knownTargets = "); KnownTargets.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectFileDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public bool IsInternal {get; private set;}
    public bool IsLinked {get; private set;}
    [NotNull] public string BuildAction {get; private set;}
    [CanBeNull] public List<RdSingleFileCustomTool> CustomTools {get; private set;}
    [CanBeNull] public int? SortKey {get; private set;}
    [CanBeNull] public string UserData {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectFileDescriptor(
      bool isInternal,
      bool isLinked,
      [NotNull] string buildAction,
      [CanBeNull] List<RdSingleFileCustomTool> customTools,
      [CanBeNull] int? sortKey,
      [CanBeNull] string userData,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      if (buildAction == null) throw new ArgumentNullException("buildAction");
      
      IsInternal = isInternal;
      IsLinked = isLinked;
      BuildAction = buildAction;
      CustomTools = customTools;
      SortKey = sortKey;
      UserData = userData;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectFileDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var isInternal = reader.ReadBool();
      var isLinked = reader.ReadBool();
      var buildAction = reader.ReadString();
      var customTools = ReadRdSingleFileCustomToolListNullable(ctx, reader);
      var sortKey = ReadIntNullable(ctx, reader);
      var userData = ReadStringNullable(ctx, reader);
      return new RdProjectFileDescriptor(isInternal, isLinked, buildAction, customTools, sortKey, userData, name, location);
    };
    public static CtxReadDelegate<List<RdSingleFileCustomTool>> ReadRdSingleFileCustomToolListNullable = RdSingleFileCustomTool.Read.List().NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdProjectFileDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write(value.IsInternal);
      writer.Write(value.IsLinked);
      writer.Write(value.BuildAction);
      WriteRdSingleFileCustomToolListNullable(ctx, writer, value.CustomTools);
      WriteIntNullable(ctx, writer, value.SortKey);
      WriteStringNullable(ctx, writer, value.UserData);
    };
    public static CtxWriteDelegate<List<RdSingleFileCustomTool>> WriteRdSingleFileCustomToolListNullable = RdSingleFileCustomTool.Write.List().NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectFileDescriptor) obj);
    }
    public bool Equals(RdProjectFileDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsInternal == other.IsInternal && IsLinked == other.IsLinked && BuildAction == other.BuildAction && Equals(CustomTools, other.CustomTools) && Equals(SortKey, other.SortKey) && Equals(UserData, other.UserData) && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsInternal.GetHashCode();
        hash = hash * 31 + IsLinked.GetHashCode();
        hash = hash * 31 + BuildAction.GetHashCode();
        hash = hash * 31 + (CustomTools != null ?Collections.GetHashCode(CustomTools) : 0);
        hash = hash * 31 + (SortKey != null ?SortKey.GetHashCode() : 0);
        hash = hash * 31 + (UserData != null ?UserData.GetHashCode() : 0);
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectFileDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("isInternal = "); IsInternal.PrintEx(printer); printer.Println();
        printer.Print("isLinked = "); IsLinked.PrintEx(printer); printer.Println();
        printer.Print("buildAction = "); BuildAction.PrintEx(printer); printer.Println();
        printer.Print("customTools = "); CustomTools.PrintEx(printer); printer.Println();
        printer.Print("sortKey = "); SortKey.PrintEx(printer); printer.Println();
        printer.Print("userData = "); UserData.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectFolderDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public bool IsInternal {get; private set;}
    public bool IsLinked {get; private set;}
    public bool IsAppDesigner {get; private set;}
    public bool AllowsNonExistence {get; private set;}
    [CanBeNull] public int? SortKey {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectFolderDescriptor(
      bool isInternal,
      bool isLinked,
      bool isAppDesigner,
      bool allowsNonExistence,
      [CanBeNull] int? sortKey,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      IsInternal = isInternal;
      IsLinked = isLinked;
      IsAppDesigner = isAppDesigner;
      AllowsNonExistence = allowsNonExistence;
      SortKey = sortKey;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectFolderDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var isInternal = reader.ReadBool();
      var isLinked = reader.ReadBool();
      var isAppDesigner = reader.ReadBool();
      var allowsNonExistence = reader.ReadBool();
      var sortKey = ReadIntNullable(ctx, reader);
      return new RdProjectFolderDescriptor(isInternal, isLinked, isAppDesigner, allowsNonExistence, sortKey, name, location);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static new CtxWriteDelegate<RdProjectFolderDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write(value.IsInternal);
      writer.Write(value.IsLinked);
      writer.Write(value.IsAppDesigner);
      writer.Write(value.AllowsNonExistence);
      WriteIntNullable(ctx, writer, value.SortKey);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectFolderDescriptor) obj);
    }
    public bool Equals(RdProjectFolderDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsInternal == other.IsInternal && IsLinked == other.IsLinked && IsAppDesigner == other.IsAppDesigner && AllowsNonExistence == other.AllowsNonExistence && Equals(SortKey, other.SortKey) && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsInternal.GetHashCode();
        hash = hash * 31 + IsLinked.GetHashCode();
        hash = hash * 31 + IsAppDesigner.GetHashCode();
        hash = hash * 31 + AllowsNonExistence.GetHashCode();
        hash = hash * 31 + (SortKey != null ?SortKey.GetHashCode() : 0);
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectFolderDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("isInternal = "); IsInternal.PrintEx(printer); printer.Println();
        printer.Print("isLinked = "); IsLinked.PrintEx(printer); printer.Println();
        printer.Print("isAppDesigner = "); IsAppDesigner.PrintEx(printer); printer.Println();
        printer.Print("allowsNonExistence = "); AllowsNonExistence.PrintEx(printer); printer.Println();
        printer.Print("sortKey = "); SortKey.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectModelItem : IPrintable, IEquatable<RdProjectModelItem>
  {
    //fields
    //public fields
    [CanBeNull] public int? ParentId {get; private set;}
    [NotNull] public RdProjectModelItemDescriptor Descriptor {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectModelItem(
      [CanBeNull] int? parentId,
      [NotNull] RdProjectModelItemDescriptor descriptor
    )
    {
      if (descriptor == null) throw new ArgumentNullException("descriptor");
      
      ParentId = parentId;
      Descriptor = descriptor;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectModelItem> Read = (ctx, reader) => 
    {
      var parentId = ReadIntNullable(ctx, reader);
      var descriptor = RdProjectModelItemDescriptor.Read(ctx, reader);
      return new RdProjectModelItem(parentId, descriptor);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<RdProjectModelItem> Write = (ctx, writer, value) => 
    {
      WriteIntNullable(ctx, writer, value.ParentId);
      RdProjectModelItemDescriptor.Write(ctx, writer, value.Descriptor);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectModelItem) obj);
    }
    public bool Equals(RdProjectModelItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ParentId, other.ParentId) && Equals(Descriptor, other.Descriptor);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (ParentId != null ?ParentId.GetHashCode() : 0);
        hash = hash * 31 + Descriptor.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelItem (");
      using (printer.IndentCookie()) {
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("descriptor = "); Descriptor.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdProjectModelItemDescriptor{
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public RdProjectModelItemLocation Location {get; private set;}
    
    //private fields
    //primary constructor
    protected RdProjectModelItemDescriptor(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (location == null) throw new ArgumentNullException("location");
      
      Name = name;
      Location = location;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectModelItemDescriptor> Read = Polymorphic<RdProjectModelItemDescriptor>.ReadAbstract(RdProjectModelItemDescriptor_Unknown.Read);
    
    public static CtxWriteDelegate<RdProjectModelItemDescriptor> Write = Polymorphic<RdProjectModelItemDescriptor>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdProjectModelItemDescriptor_Unknown : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdProjectModelItemDescriptor_Unknown(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectModelItemDescriptor_Unknown> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdProjectModelItemDescriptor_Unknown(name, location);
    };
    
    public static new CtxWriteDelegate<RdProjectModelItemDescriptor_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectModelItemDescriptor_Unknown) obj);
    }
    public bool Equals(RdProjectModelItemDescriptor_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelItemDescriptor_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdProjectModelItemLocation{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectModelItemLocation> Read = Polymorphic<RdProjectModelItemLocation>.ReadAbstract(RdProjectModelItemLocation_Unknown.Read);
    
    public static CtxWriteDelegate<RdProjectModelItemLocation> Write = Polymorphic<RdProjectModelItemLocation>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdProjectModelItemLocation_Unknown : RdProjectModelItemLocation
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectModelItemLocation_Unknown> Read = (ctx, reader) => 
    {
      return new RdProjectModelItemLocation_Unknown();
    };
    
    public static new CtxWriteDelegate<RdProjectModelItemLocation_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectModelItemLocation_Unknown) obj);
    }
    public bool Equals(RdProjectModelItemLocation_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelItemLocation_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectModelSyncData : IPrintable, IEquatable<RdProjectModelSyncData>
  {
    //fields
    //public fields
    [NotNull] public List<string> ExcludedPaths {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectModelSyncData(
      [NotNull] List<string> excludedPaths
    )
    {
      if (excludedPaths == null) throw new ArgumentNullException("excludedPaths");
      
      ExcludedPaths = excludedPaths;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectModelSyncData> Read = (ctx, reader) => 
    {
      var excludedPaths = ReadStringList(ctx, reader);
      return new RdProjectModelSyncData(excludedPaths);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdProjectModelSyncData> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.ExcludedPaths);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectModelSyncData) obj);
    }
    public bool Equals(RdProjectModelSyncData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ExcludedPaths.SequenceEqual(other.ExcludedPaths);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ExcludedPaths);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelSyncData (");
      using (printer.IndentCookie()) {
        printer.Print("excludedPaths = "); ExcludedPaths.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectReferenceDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    [CanBeNull] public int? TargetProjectId {get; private set;}
    public RdProjectReferenceType Type {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectReferenceDescriptor(
      [CanBeNull] int? targetProjectId,
      RdProjectReferenceType type,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      TargetProjectId = targetProjectId;
      Type = type;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectReferenceDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var targetProjectId = ReadIntNullable(ctx, reader);
      var type = (RdProjectReferenceType)reader.ReadInt();
      return new RdProjectReferenceDescriptor(targetProjectId, type, name, location);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static new CtxWriteDelegate<RdProjectReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      WriteIntNullable(ctx, writer, value.TargetProjectId);
      writer.Write((int)value.Type);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectReferenceDescriptor) obj);
    }
    public bool Equals(RdProjectReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TargetProjectId, other.TargetProjectId) && Type == other.Type && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (TargetProjectId != null ?TargetProjectId.GetHashCode() : 0);
        hash = hash * 31 + (int) Type;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("targetProjectId = "); TargetProjectId.PrintEx(printer); printer.Println();
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdProjectReferenceType {
    Regular,
    Shared,
    Inactive
  }
  
  
  public enum RdProjectState {
    Loading,
    Unloading,
    Sync,
    RestoringPackages,
    WithMissingPackages,
    WithInvalidConfiguration,
    WithErrors,
    WithWarnings,
    Ready
  }
  
  
  public class RdProjectsCount : IPrintable, IEquatable<RdProjectsCount>
  {
    //fields
    //public fields
    public int Total {get; private set;}
    public int Failed {get; private set;}
    public int Unloaded {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectsCount(
      int total,
      int failed,
      int unloaded
    )
    {
      Total = total;
      Failed = failed;
      Unloaded = unloaded;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectsCount> Read = (ctx, reader) => 
    {
      var total = reader.ReadInt();
      var failed = reader.ReadInt();
      var unloaded = reader.ReadInt();
      return new RdProjectsCount(total, failed, unloaded);
    };
    
    public static CtxWriteDelegate<RdProjectsCount> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Total);
      writer.Write(value.Failed);
      writer.Write(value.Unloaded);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectsCount) obj);
    }
    public bool Equals(RdProjectsCount other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Total == other.Total && Failed == other.Failed && Unloaded == other.Unloaded;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Total.GetHashCode();
        hash = hash * 31 + Failed.GetHashCode();
        hash = hash * 31 + Unloaded.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectsCount (");
      using (printer.IndentCookie()) {
        printer.Print("total = "); Total.PrintEx(printer); printer.Println();
        printer.Print("failed = "); Failed.PrintEx(printer); printer.Println();
        printer.Print("unloaded = "); Unloaded.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSingleFileCustomTool : IPrintable, IEquatable<RdSingleFileCustomTool>
  {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string ActionName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdSingleFileCustomTool(
      [NotNull] string name,
      [NotNull] string actionName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (actionName == null) throw new ArgumentNullException("actionName");
      
      Name = name;
      ActionName = actionName;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSingleFileCustomTool> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var actionName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new RdSingleFileCustomTool(name, actionName, icon);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdSingleFileCustomTool> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.ActionName);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSingleFileCustomTool) obj);
    }
    public bool Equals(RdSingleFileCustomTool other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && ActionName == other.ActionName && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + ActionName.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSingleFileCustomTool (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSolutionDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public RdSolutionState State {get; private set;}
    public bool IsVirtual {get; private set;}
    [NotNull] public RdProjectsCount ProjectsCount {get; private set;}
    
    //private fields
    //primary constructor
    public RdSolutionDescriptor(
      RdSolutionState state,
      bool isVirtual,
      [NotNull] RdProjectsCount projectsCount,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      if (projectsCount == null) throw new ArgumentNullException("projectsCount");
      
      State = state;
      IsVirtual = isVirtual;
      ProjectsCount = projectsCount;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdSolutionDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var state = (RdSolutionState)reader.ReadInt();
      var isVirtual = reader.ReadBool();
      var projectsCount = RdProjectsCount.Read(ctx, reader);
      return new RdSolutionDescriptor(state, isVirtual, projectsCount, name, location);
    };
    
    public static new CtxWriteDelegate<RdSolutionDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write((int)value.State);
      writer.Write(value.IsVirtual);
      RdProjectsCount.Write(ctx, writer, value.ProjectsCount);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSolutionDescriptor) obj);
    }
    public bool Equals(RdSolutionDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && IsVirtual == other.IsVirtual && Equals(ProjectsCount, other.ProjectsCount) && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) State;
        hash = hash * 31 + IsVirtual.GetHashCode();
        hash = hash * 31 + ProjectsCount.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSolutionDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("isVirtual = "); IsVirtual.PrintEx(printer); printer.Println();
        printer.Print("projectsCount = "); ProjectsCount.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSolutionFolderDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    [NotNull] public RdProjectsCount ProjectsCount {get; private set;}
    
    //private fields
    //primary constructor
    public RdSolutionFolderDescriptor(
      [NotNull] RdProjectsCount projectsCount,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      if (projectsCount == null) throw new ArgumentNullException("projectsCount");
      
      ProjectsCount = projectsCount;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdSolutionFolderDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var projectsCount = RdProjectsCount.Read(ctx, reader);
      return new RdSolutionFolderDescriptor(projectsCount, name, location);
    };
    
    public static new CtxWriteDelegate<RdSolutionFolderDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      RdProjectsCount.Write(ctx, writer, value.ProjectsCount);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSolutionFolderDescriptor) obj);
    }
    public bool Equals(RdSolutionFolderDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ProjectsCount, other.ProjectsCount) && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectsCount.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSolutionFolderDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("projectsCount = "); ProjectsCount.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdSolutionState {
    Loading,
    Sync,
    Ready,
    ReadyWithErrors,
    ReadyWithWarnings
  }
  
  
  public class RdUnloadProjectDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public RdUnloadProjectState State {get; private set;}
    public bool DirectoryBased {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnloadProjectDescriptor(
      RdUnloadProjectState state,
      bool directoryBased,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      State = state;
      DirectoryBased = directoryBased;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdUnloadProjectDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var state = (RdUnloadProjectState)reader.ReadInt();
      var directoryBased = reader.ReadBool();
      return new RdUnloadProjectDescriptor(state, directoryBased, name, location);
    };
    
    public static new CtxWriteDelegate<RdUnloadProjectDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write((int)value.State);
      writer.Write(value.DirectoryBased);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnloadProjectDescriptor) obj);
    }
    public bool Equals(RdUnloadProjectDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && DirectoryBased == other.DirectoryBased && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) State;
        hash = hash * 31 + DirectoryBased.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnloadProjectDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("directoryBased = "); DirectoryBased.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUnloadProjectState {
    LoadFailed,
    Unloaded,
    Reloading
  }
  
  
  public class RdUnresolvedReferenceDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    [NotNull] public string Reason {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnresolvedReferenceDescriptor(
      [NotNull] string reason,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      if (reason == null) throw new ArgumentNullException("reason");
      
      Reason = reason;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdUnresolvedReferenceDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var reason = reader.ReadString();
      return new RdUnresolvedReferenceDescriptor(reason, name, location);
    };
    
    public static new CtxWriteDelegate<RdUnresolvedReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write(value.Reason);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnresolvedReferenceDescriptor) obj);
    }
    public bool Equals(RdUnresolvedReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Reason == other.Reason && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Reason.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnresolvedReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("reason = "); Reason.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdWebReferenceDescriptor : RdProjectModelItemDescriptor
  {
    //fields
    //public fields
    public RdWebReferenceDescriptorType Type {get; private set;}
    
    //private fields
    //primary constructor
    public RdWebReferenceDescriptor(
      RdWebReferenceDescriptorType type,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      Type = type;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdWebReferenceDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      var type = (RdWebReferenceDescriptorType)reader.ReadInt();
      return new RdWebReferenceDescriptor(type, name, location);
    };
    
    public static new CtxWriteDelegate<RdWebReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
      writer.Write((int)value.Type);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdWebReferenceDescriptor) obj);
    }
    public bool Equals(RdWebReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Type;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdWebReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdWebReferenceDescriptorType {
    Reference,
    Metadata,
    MetadataStorage
  }
  
  
  public class SolutionExplorerNavigation : Navigation
  {
    //fields
    //public fields
    [NotNull] public string FilePath {get; private set;}
    public int ProjectModelElementId {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionExplorerNavigation(
      [NotNull] string filePath,
      int projectModelElementId
    )
    {
      if (filePath == null) throw new ArgumentNullException("filePath");
      
      FilePath = filePath;
      ProjectModelElementId = projectModelElementId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SolutionExplorerNavigation> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var projectModelElementId = reader.ReadInt();
      return new SolutionExplorerNavigation(filePath, projectModelElementId);
    };
    
    public static new CtxWriteDelegate<SolutionExplorerNavigation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.ProjectModelElementId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionExplorerNavigation) obj);
    }
    public bool Equals(SolutionExplorerNavigation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FilePath == other.FilePath && ProjectModelElementId == other.ProjectModelElementId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FilePath.GetHashCode();
        hash = hash * 31 + ProjectModelElementId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionExplorerNavigation (");
      using (printer.IndentCookie()) {
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("projectModelElementId = "); ProjectModelElementId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
