using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class PsiDebuggerHostModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult> ResolveExpression { get { return _ResolveExpression; }}
    [NotNull] public RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult> ResolveLocalSymbol { get { return _ResolveLocalSymbol; }}
    [NotNull] public RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolUsagesResult> ResolveLocalSymbolUsages { get { return _ResolveLocalSymbolUsages; }}
    [NotNull] public RdEndpoint<FindSmartStepInfoArg, List<SmartStepInfo>> FindSmartStepInfo { get { return _FindSmartStepInfo; }}
    [NotNull] public RdEndpoint<GetActiveFileMethodsOffsetsArg, List<List<RdTextRange>>> GetActiveFileMethodsOffsets { get { return _GetActiveFileMethodsOffsets; }}
    [NotNull] public ISource<AcknowledgeExtraImportInfo> AcknowledgeExtraImportsOnComplete { get { return _AcknowledgeExtraImportsOnComplete; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult> _ResolveExpression;
    [NotNull] private readonly RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult> _ResolveLocalSymbol;
    [NotNull] private readonly RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolUsagesResult> _ResolveLocalSymbolUsages;
    [NotNull] private readonly RdEndpoint<FindSmartStepInfoArg, List<SmartStepInfo>> _FindSmartStepInfo;
    [NotNull] private readonly RdEndpoint<GetActiveFileMethodsOffsetsArg, List<List<RdTextRange>>> _GetActiveFileMethodsOffsets;
    [NotNull] private readonly RdSignal<AcknowledgeExtraImportInfo> _AcknowledgeExtraImportsOnComplete;
    
    //primary constructor
    private PsiDebuggerHostModel(
      [NotNull] RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult> resolveExpression,
      [NotNull] RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult> resolveLocalSymbol,
      [NotNull] RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolUsagesResult> resolveLocalSymbolUsages,
      [NotNull] RdEndpoint<FindSmartStepInfoArg, List<SmartStepInfo>> findSmartStepInfo,
      [NotNull] RdEndpoint<GetActiveFileMethodsOffsetsArg, List<List<RdTextRange>>> getActiveFileMethodsOffsets,
      [NotNull] RdSignal<AcknowledgeExtraImportInfo> acknowledgeExtraImportsOnComplete
    )
    {
      if (resolveExpression == null) throw new ArgumentNullException("resolveExpression");
      if (resolveLocalSymbol == null) throw new ArgumentNullException("resolveLocalSymbol");
      if (resolveLocalSymbolUsages == null) throw new ArgumentNullException("resolveLocalSymbolUsages");
      if (findSmartStepInfo == null) throw new ArgumentNullException("findSmartStepInfo");
      if (getActiveFileMethodsOffsets == null) throw new ArgumentNullException("getActiveFileMethodsOffsets");
      if (acknowledgeExtraImportsOnComplete == null) throw new ArgumentNullException("acknowledgeExtraImportsOnComplete");
      
      _ResolveExpression = resolveExpression;
      _ResolveLocalSymbol = resolveLocalSymbol;
      _ResolveLocalSymbolUsages = resolveLocalSymbolUsages;
      _FindSmartStepInfo = findSmartStepInfo;
      _GetActiveFileMethodsOffsets = getActiveFileMethodsOffsets;
      _AcknowledgeExtraImportsOnComplete = acknowledgeExtraImportsOnComplete;
      _ResolveExpression.ValueCanBeNull = true;
      _ResolveLocalSymbol.ValueCanBeNull = true;
      _ResolveLocalSymbolUsages.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("resolveExpression", _ResolveExpression));
      BindableChildren.Add(new KeyValuePair<string, object>("resolveLocalSymbol", _ResolveLocalSymbol));
      BindableChildren.Add(new KeyValuePair<string, object>("resolveLocalSymbolUsages", _ResolveLocalSymbolUsages));
      BindableChildren.Add(new KeyValuePair<string, object>("findSmartStepInfo", _FindSmartStepInfo));
      BindableChildren.Add(new KeyValuePair<string, object>("getActiveFileMethodsOffsets", _GetActiveFileMethodsOffsets));
      BindableChildren.Add(new KeyValuePair<string, object>("acknowledgeExtraImportsOnComplete", _AcknowledgeExtraImportsOnComplete));
    }
    //secondary constructor
    internal PsiDebuggerHostModel (
    ) : this (
      new RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult>(ResolveExpressionArgs.Read, ResolveExpressionArgs.Write, ReadResolveExpressionResultNullable, WriteResolveExpressionResultNullable),
      new RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult>(ResolveLocalSymbolArg.Read, ResolveLocalSymbolArg.Write, ReadResolveLocalSymbolResultNullable, WriteResolveLocalSymbolResultNullable),
      new RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolUsagesResult>(ResolveLocalSymbolArg.Read, ResolveLocalSymbolArg.Write, ReadResolveLocalSymbolUsagesResultNullable, WriteResolveLocalSymbolUsagesResultNullable),
      new RdEndpoint<FindSmartStepInfoArg, List<SmartStepInfo>>(FindSmartStepInfoArg.Read, FindSmartStepInfoArg.Write, ReadSmartStepInfoList, WriteSmartStepInfoList),
      new RdEndpoint<GetActiveFileMethodsOffsetsArg, List<List<RdTextRange>>>(GetActiveFileMethodsOffsetsArg.Read, GetActiveFileMethodsOffsetsArg.Write, ReadRdTextRangeListList, WriteRdTextRangeListList),
      new RdSignal<AcknowledgeExtraImportInfo>(AcknowledgeExtraImportInfo.Read, AcknowledgeExtraImportInfo.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<ResolveExpressionResult> ReadResolveExpressionResultNullable = ResolveExpressionResult.Read.NullableClass();
    public static CtxReadDelegate<ResolveLocalSymbolResult> ReadResolveLocalSymbolResultNullable = ResolveLocalSymbolResult.Read.NullableClass();
    public static CtxReadDelegate<ResolveLocalSymbolUsagesResult> ReadResolveLocalSymbolUsagesResultNullable = ResolveLocalSymbolUsagesResult.Read.NullableClass();
    public static CtxReadDelegate<List<SmartStepInfo>> ReadSmartStepInfoList = SmartStepInfo.Read.List();
    public static CtxReadDelegate<List<List<RdTextRange>>> ReadRdTextRangeListList = RdTextRange.Read.List().List();
    
    public static CtxWriteDelegate<ResolveExpressionResult> WriteResolveExpressionResultNullable = ResolveExpressionResult.Write.NullableClass();
    public static CtxWriteDelegate<ResolveLocalSymbolResult> WriteResolveLocalSymbolResultNullable = ResolveLocalSymbolResult.Write.NullableClass();
    public static CtxWriteDelegate<ResolveLocalSymbolUsagesResult> WriteResolveLocalSymbolUsagesResultNullable = ResolveLocalSymbolUsagesResult.Write.NullableClass();
    public static CtxWriteDelegate<List<SmartStepInfo>> WriteSmartStepInfoList = SmartStepInfo.Write.List();
    public static CtxWriteDelegate<List<List<RdTextRange>>> WriteRdTextRangeListList = RdTextRange.Write.List().List();
    
    protected override long SerializationHash => 8136005333195795324L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(ResolveExpressionArgs.Read, ResolveExpressionArgs.Write);
      serializers.Register(ResolveExpressionResult.Read, ResolveExpressionResult.Write);
      serializers.Register(ResolveLocalSymbolArg.Read, ResolveLocalSymbolArg.Write);
      serializers.Register(ResolveLocalSymbolResult.Read, ResolveLocalSymbolResult.Write);
      serializers.Register(ResolveLocalSymbolUsagesResult.Read, ResolveLocalSymbolUsagesResult.Write);
      serializers.Register(FindSmartStepInfoArg.Read, FindSmartStepInfoArg.Write);
      serializers.Register(SmartStepInfo.Read, SmartStepInfo.Write);
      serializers.Register(GetActiveFileMethodsOffsetsArg.Read, GetActiveFileMethodsOffsetsArg.Write);
      serializers.Register(AcknowledgeExtraImportInfo.Read, AcknowledgeExtraImportInfo.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PsiDebuggerHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("resolveExpression = "); _ResolveExpression.PrintEx(printer); printer.Println();
        printer.Print("resolveLocalSymbol = "); _ResolveLocalSymbol.PrintEx(printer); printer.Println();
        printer.Print("resolveLocalSymbolUsages = "); _ResolveLocalSymbolUsages.PrintEx(printer); printer.Println();
        printer.Print("findSmartStepInfo = "); _FindSmartStepInfo.PrintEx(printer); printer.Println();
        printer.Print("getActiveFileMethodsOffsets = "); _GetActiveFileMethodsOffsets.PrintEx(printer); printer.Println();
        printer.Print("acknowledgeExtraImportsOnComplete = "); _AcknowledgeExtraImportsOnComplete.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionPsiDebuggerHostModelEx
   {
    public static PsiDebuggerHostModel GetPsiDebuggerHostModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("psiDebuggerHostModel", () => new PsiDebuggerHostModel());
    }
  }
  
  
  public class AcknowledgeExtraImportInfo : IPrintable, IEquatable<AcknowledgeExtraImportInfo>
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    [NotNull] public List<string> Imports {get; private set;}
    
    //private fields
    //primary constructor
    public AcknowledgeExtraImportInfo(
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId,
      [NotNull] List<string> imports
    )
    {
      if (textControlId == null) throw new ArgumentNullException("textControlId");
      if (imports == null) throw new ArgumentNullException("imports");
      
      TextControlId = textControlId;
      Imports = imports;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AcknowledgeExtraImportInfo> Read = (ctx, reader) => 
    {
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      var imports = ReadStringList(ctx, reader);
      return new AcknowledgeExtraImportInfo(textControlId, imports);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<AcknowledgeExtraImportInfo> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
      WriteStringList(ctx, writer, value.Imports);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AcknowledgeExtraImportInfo) obj);
    }
    public bool Equals(AcknowledgeExtraImportInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControlId, other.TextControlId) && Imports.SequenceEqual(other.Imports);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TextControlId.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Imports);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AcknowledgeExtraImportInfo (");
      using (printer.IndentCookie()) {
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
        printer.Print("imports = "); Imports.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FindSmartStepInfoArg : IPrintable, IEquatable<FindSmartStepInfoArg>
  {
    //fields
    //public fields
    [NotNull] public EditableEntityId DocumentId {get; private set;}
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    
    //private fields
    //primary constructor
    public FindSmartStepInfoArg(
      [NotNull] EditableEntityId documentId,
      int startOffset,
      int endOffset
    )
    {
      if (documentId == null) throw new ArgumentNullException("documentId");
      
      DocumentId = documentId;
      StartOffset = startOffset;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FindSmartStepInfoArg> Read = (ctx, reader) => 
    {
      var documentId = EditableEntityId.Read(ctx, reader);
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      return new FindSmartStepInfoArg(documentId, startOffset, endOffset);
    };
    
    public static CtxWriteDelegate<FindSmartStepInfoArg> Write = (ctx, writer, value) => 
    {
      EditableEntityId.Write(ctx, writer, value.DocumentId);
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FindSmartStepInfoArg) obj);
    }
    public bool Equals(FindSmartStepInfoArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DocumentId, other.DocumentId) && StartOffset == other.StartOffset && EndOffset == other.EndOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DocumentId.GetHashCode();
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FindSmartStepInfoArg (");
      using (printer.IndentCookie()) {
        printer.Print("documentId = "); DocumentId.PrintEx(printer); printer.Println();
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetActiveFileMethodsOffsetsArg : IPrintable, IEquatable<GetActiveFileMethodsOffsetsArg>
  {
    //fields
    //public fields
    [NotNull] public List<string> Files {get; private set;}
    
    //private fields
    //primary constructor
    public GetActiveFileMethodsOffsetsArg(
      [NotNull] List<string> files
    )
    {
      if (files == null) throw new ArgumentNullException("files");
      
      Files = files;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetActiveFileMethodsOffsetsArg> Read = (ctx, reader) => 
    {
      var files = ReadStringList(ctx, reader);
      return new GetActiveFileMethodsOffsetsArg(files);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<GetActiveFileMethodsOffsetsArg> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Files);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetActiveFileMethodsOffsetsArg) obj);
    }
    public bool Equals(GetActiveFileMethodsOffsetsArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Files.SequenceEqual(other.Files);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Files);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetActiveFileMethodsOffsetsArg (");
      using (printer.IndentCookie()) {
        printer.Print("files = "); Files.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveExpressionArgs : IPrintable, IEquatable<ResolveExpressionArgs>
  {
    //fields
    //public fields
    [NotNull] public EditableEntityId DocumentId {get; private set;}
    public int Offset {get; private set;}
    public bool SideEffectsAllowed {get; private set;}
    public bool EvaluationOfMethodsAllowed {get; private set;}
    
    //private fields
    //primary constructor
    public ResolveExpressionArgs(
      [NotNull] EditableEntityId documentId,
      int offset,
      bool sideEffectsAllowed,
      bool evaluationOfMethodsAllowed
    )
    {
      if (documentId == null) throw new ArgumentNullException("documentId");
      
      DocumentId = documentId;
      Offset = offset;
      SideEffectsAllowed = sideEffectsAllowed;
      EvaluationOfMethodsAllowed = evaluationOfMethodsAllowed;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveExpressionArgs> Read = (ctx, reader) => 
    {
      var documentId = EditableEntityId.Read(ctx, reader);
      var offset = reader.ReadInt();
      var sideEffectsAllowed = reader.ReadBool();
      var evaluationOfMethodsAllowed = reader.ReadBool();
      return new ResolveExpressionArgs(documentId, offset, sideEffectsAllowed, evaluationOfMethodsAllowed);
    };
    
    public static CtxWriteDelegate<ResolveExpressionArgs> Write = (ctx, writer, value) => 
    {
      EditableEntityId.Write(ctx, writer, value.DocumentId);
      writer.Write(value.Offset);
      writer.Write(value.SideEffectsAllowed);
      writer.Write(value.EvaluationOfMethodsAllowed);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveExpressionArgs) obj);
    }
    public bool Equals(ResolveExpressionArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DocumentId, other.DocumentId) && Offset == other.Offset && SideEffectsAllowed == other.SideEffectsAllowed && EvaluationOfMethodsAllowed == other.EvaluationOfMethodsAllowed;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DocumentId.GetHashCode();
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + SideEffectsAllowed.GetHashCode();
        hash = hash * 31 + EvaluationOfMethodsAllowed.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveExpressionArgs (");
      using (printer.IndentCookie()) {
        printer.Print("documentId = "); DocumentId.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("sideEffectsAllowed = "); SideEffectsAllowed.PrintEx(printer); printer.Println();
        printer.Print("evaluationOfMethodsAllowed = "); EvaluationOfMethodsAllowed.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveExpressionResult : IPrintable, IEquatable<ResolveExpressionResult>
  {
    //fields
    //public fields
    [NotNull] public RdTextRange TextRange {get; private set;}
    [CanBeNull] public string Expression {get; private set;}
    [CanBeNull] public string DisplayText {get; private set;}
    
    //private fields
    //primary constructor
    public ResolveExpressionResult(
      [NotNull] RdTextRange textRange,
      [CanBeNull] string expression,
      [CanBeNull] string displayText
    )
    {
      if (textRange == null) throw new ArgumentNullException("textRange");
      
      TextRange = textRange;
      Expression = expression;
      DisplayText = displayText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveExpressionResult> Read = (ctx, reader) => 
    {
      var textRange = RdTextRange.Read(ctx, reader);
      var expression = ReadStringNullable(ctx, reader);
      var displayText = ReadStringNullable(ctx, reader);
      return new ResolveExpressionResult(textRange, expression, displayText);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<ResolveExpressionResult> Write = (ctx, writer, value) => 
    {
      RdTextRange.Write(ctx, writer, value.TextRange);
      WriteStringNullable(ctx, writer, value.Expression);
      WriteStringNullable(ctx, writer, value.DisplayText);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveExpressionResult) obj);
    }
    public bool Equals(ResolveExpressionResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextRange, other.TextRange) && Equals(Expression, other.Expression) && Equals(DisplayText, other.DisplayText);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TextRange.GetHashCode();
        hash = hash * 31 + (Expression != null ?Expression.GetHashCode() : 0);
        hash = hash * 31 + (DisplayText != null ?DisplayText.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveExpressionResult (");
      using (printer.IndentCookie()) {
        printer.Print("textRange = "); TextRange.PrintEx(printer); printer.Println();
        printer.Print("expression = "); Expression.PrintEx(printer); printer.Println();
        printer.Print("displayText = "); DisplayText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveLocalSymbolArg : IPrintable, IEquatable<ResolveLocalSymbolArg>
  {
    //fields
    //public fields
    [NotNull] public EditableEntityId DocumentId {get; private set;}
    public int Offset {get; private set;}
    [NotNull] public string Name {get; private set;}
    
    //private fields
    //primary constructor
    public ResolveLocalSymbolArg(
      [NotNull] EditableEntityId documentId,
      int offset,
      [NotNull] string name
    )
    {
      if (documentId == null) throw new ArgumentNullException("documentId");
      if (name == null) throw new ArgumentNullException("name");
      
      DocumentId = documentId;
      Offset = offset;
      Name = name;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveLocalSymbolArg> Read = (ctx, reader) => 
    {
      var documentId = EditableEntityId.Read(ctx, reader);
      var offset = reader.ReadInt();
      var name = reader.ReadString();
      return new ResolveLocalSymbolArg(documentId, offset, name);
    };
    
    public static CtxWriteDelegate<ResolveLocalSymbolArg> Write = (ctx, writer, value) => 
    {
      EditableEntityId.Write(ctx, writer, value.DocumentId);
      writer.Write(value.Offset);
      writer.Write(value.Name);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveLocalSymbolArg) obj);
    }
    public bool Equals(ResolveLocalSymbolArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DocumentId, other.DocumentId) && Offset == other.Offset && Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DocumentId.GetHashCode();
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveLocalSymbolArg (");
      using (printer.IndentCookie()) {
        printer.Print("documentId = "); DocumentId.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveLocalSymbolResult : IPrintable, IEquatable<ResolveLocalSymbolResult>
  {
    //fields
    //public fields
    public int DeclarationOffset {get; private set;}
    
    //private fields
    //primary constructor
    public ResolveLocalSymbolResult(
      int declarationOffset
    )
    {
      DeclarationOffset = declarationOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveLocalSymbolResult> Read = (ctx, reader) => 
    {
      var declarationOffset = reader.ReadInt();
      return new ResolveLocalSymbolResult(declarationOffset);
    };
    
    public static CtxWriteDelegate<ResolveLocalSymbolResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DeclarationOffset);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveLocalSymbolResult) obj);
    }
    public bool Equals(ResolveLocalSymbolResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DeclarationOffset == other.DeclarationOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DeclarationOffset.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveLocalSymbolResult (");
      using (printer.IndentCookie()) {
        printer.Print("declarationOffset = "); DeclarationOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveLocalSymbolUsagesResult : IPrintable, IEquatable<ResolveLocalSymbolUsagesResult>
  {
    //fields
    //public fields
    [CanBeNull] public List<int> Lines {get; private set;}
    
    //private fields
    //primary constructor
    public ResolveLocalSymbolUsagesResult(
      [CanBeNull] List<int> lines
    )
    {
      Lines = lines;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveLocalSymbolUsagesResult> Read = (ctx, reader) => 
    {
      var lines = ReadIntListNullable(ctx, reader);
      return new ResolveLocalSymbolUsagesResult(lines);
    };
    public static CtxReadDelegate<List<int>> ReadIntListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List().NullableClass();
    
    public static CtxWriteDelegate<ResolveLocalSymbolUsagesResult> Write = (ctx, writer, value) => 
    {
      WriteIntListNullable(ctx, writer, value.Lines);
    };
    public static CtxWriteDelegate<List<int>> WriteIntListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List().NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveLocalSymbolUsagesResult) obj);
    }
    public bool Equals(ResolveLocalSymbolUsagesResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Lines, other.Lines);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Lines != null ?Collections.GetHashCode(Lines) : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveLocalSymbolUsagesResult (");
      using (printer.IndentCookie()) {
        printer.Print("lines = "); Lines.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SmartStepInfo : IPrintable, IEquatable<SmartStepInfo>
  {
    //fields
    //public fields
    [NotNull] public string Identifier {get; private set;}
    [NotNull] public string PresentableText {get; private set;}
    [NotNull] public RdTextRange Range {get; private set;}
    
    //private fields
    //primary constructor
    public SmartStepInfo(
      [NotNull] string identifier,
      [NotNull] string presentableText,
      [NotNull] RdTextRange range
    )
    {
      if (identifier == null) throw new ArgumentNullException("identifier");
      if (presentableText == null) throw new ArgumentNullException("presentableText");
      if (range == null) throw new ArgumentNullException("range");
      
      Identifier = identifier;
      PresentableText = presentableText;
      Range = range;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SmartStepInfo> Read = (ctx, reader) => 
    {
      var identifier = reader.ReadString();
      var presentableText = reader.ReadString();
      var range = RdTextRange.Read(ctx, reader);
      return new SmartStepInfo(identifier, presentableText, range);
    };
    
    public static CtxWriteDelegate<SmartStepInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Identifier);
      writer.Write(value.PresentableText);
      RdTextRange.Write(ctx, writer, value.Range);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SmartStepInfo) obj);
    }
    public bool Equals(SmartStepInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Identifier == other.Identifier && PresentableText == other.PresentableText && Equals(Range, other.Range);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Identifier.GetHashCode();
        hash = hash * 31 + PresentableText.GetHashCode();
        hash = hash * 31 + Range.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SmartStepInfo (");
      using (printer.IndentCookie()) {
        printer.Print("identifier = "); Identifier.PrintEx(printer); printer.Println();
        printer.Print("presentableText = "); PresentableText.PrintEx(printer); printer.Println();
        printer.Print("range = "); Range.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
