using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class QuickDocHostModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, QuickDocSession> QuickDocSessions { get { return _QuickDocSessions; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, QuickDocSession> _QuickDocSessions;
    
    //primary constructor
    private QuickDocHostModel(
      [NotNull] RdMap<int, QuickDocSession> quickDocSessions
    )
    {
      if (quickDocSessions == null) throw new ArgumentNullException("quickDocSessions");
      
      _QuickDocSessions = quickDocSessions;
      BindableChildren.Add(new KeyValuePair<string, object>("quickDocSessions", _QuickDocSessions));
    }
    //secondary constructor
    internal QuickDocHostModel (
    ) : this (
      new RdMap<int, QuickDocSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, QuickDocSession.Read, QuickDocSession.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -6067230932722787480L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(QuickDocElementInfo.Read, QuickDocElementInfo.Write);
      serializers.Register(QuickDocNavigationArgs.Read, QuickDocNavigationArgs.Write);
      serializers.Register(QuickDocSession.Read, QuickDocSession.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("quickDocSessions = "); _QuickDocSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionQuickDocHostModelEx
   {
    public static QuickDocHostModel GetQuickDocHostModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("quickDocHostModel", () => new QuickDocHostModel());
    }
  }
  
  
  public class QuickDocElementInfo : IPrintable, IEquatable<QuickDocElementInfo>
  {
    //fields
    //public fields
    [NotNull] public string DescriptionHtml {get; private set;}
    
    //private fields
    //primary constructor
    public QuickDocElementInfo(
      [NotNull] string descriptionHtml
    )
    {
      if (descriptionHtml == null) throw new ArgumentNullException("descriptionHtml");
      
      DescriptionHtml = descriptionHtml;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<QuickDocElementInfo> Read = (ctx, reader) => 
    {
      var descriptionHtml = reader.ReadString();
      return new QuickDocElementInfo(descriptionHtml);
    };
    
    public static CtxWriteDelegate<QuickDocElementInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DescriptionHtml);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((QuickDocElementInfo) obj);
    }
    public bool Equals(QuickDocElementInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DescriptionHtml == other.DescriptionHtml;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DescriptionHtml.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocElementInfo (");
      using (printer.IndentCookie()) {
        printer.Print("descriptionHtml = "); DescriptionHtml.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class QuickDocNavigationArgs : IPrintable, IEquatable<QuickDocNavigationArgs>
  {
    //fields
    //public fields
    [CanBeNull] public string Url {get; private set;}
    
    //private fields
    //primary constructor
    public QuickDocNavigationArgs(
      [CanBeNull] string url
    )
    {
      Url = url;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<QuickDocNavigationArgs> Read = (ctx, reader) => 
    {
      var url = ReadStringNullable(ctx, reader);
      return new QuickDocNavigationArgs(url);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<QuickDocNavigationArgs> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Url);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((QuickDocNavigationArgs) obj);
    }
    public bool Equals(QuickDocNavigationArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Url, other.Url);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Url != null ?Url.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocNavigationArgs (");
      using (printer.IndentCookie()) {
        printer.Print("url = "); Url.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class QuickDocSession : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public QuickDocElementInfo InitialInfo {get; private set;}
    [NotNull] public TextControlId TextControl {get; private set;}
    [NotNull] public RdEndpoint<string, QuickDocElementInfo> FetchInfoByLink { get { return _FetchInfoByLink; }}
    [NotNull] public ISink<QuickDocNavigationArgs> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<string, QuickDocElementInfo> _FetchInfoByLink;
    [NotNull] private readonly RdSignal<QuickDocNavigationArgs> _Navigate;
    
    //primary constructor
    private QuickDocSession(
      [NotNull] QuickDocElementInfo initialInfo,
      [NotNull] TextControlId textControl,
      [NotNull] RdEndpoint<string, QuickDocElementInfo> fetchInfoByLink,
      [NotNull] RdSignal<QuickDocNavigationArgs> navigate
    )
    {
      if (initialInfo == null) throw new ArgumentNullException("initialInfo");
      if (textControl == null) throw new ArgumentNullException("textControl");
      if (fetchInfoByLink == null) throw new ArgumentNullException("fetchInfoByLink");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      InitialInfo = initialInfo;
      TextControl = textControl;
      _FetchInfoByLink = fetchInfoByLink;
      _Navigate = navigate;
      BindableChildren.Add(new KeyValuePair<string, object>("fetchInfoByLink", _FetchInfoByLink));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public QuickDocSession (
      [NotNull] QuickDocElementInfo initialInfo,
      [NotNull] TextControlId textControl
    ) : this (
      initialInfo,
      textControl,
      new RdEndpoint<string, QuickDocElementInfo>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, QuickDocElementInfo.Read, QuickDocElementInfo.Write),
      new RdSignal<QuickDocNavigationArgs>(QuickDocNavigationArgs.Read, QuickDocNavigationArgs.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<QuickDocSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var initialInfo = QuickDocElementInfo.Read(ctx, reader);
      var textControl = TextControlId.Read(ctx, reader);
      var fetchInfoByLink = RdEndpoint<string, QuickDocElementInfo>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, QuickDocElementInfo.Read, QuickDocElementInfo.Write);
      var navigate = RdSignal<QuickDocNavigationArgs>.Read(ctx, reader, QuickDocNavigationArgs.Read, QuickDocNavigationArgs.Write);
      return new QuickDocSession(initialInfo, textControl, fetchInfoByLink, navigate).WithId(_id);
    };
    
    public static CtxWriteDelegate<QuickDocSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      QuickDocElementInfo.Write(ctx, writer, value.InitialInfo);
      TextControlId.Write(ctx, writer, value.TextControl);
      RdEndpoint<string, QuickDocElementInfo>.Write(ctx, writer, value._FetchInfoByLink);
      RdSignal<QuickDocNavigationArgs>.Write(ctx, writer, value._Navigate);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocSession (");
      using (printer.IndentCookie()) {
        printer.Print("initialInfo = "); InitialInfo.PrintEx(printer); printer.Println();
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
        printer.Print("fetchInfoByLink = "); _FetchInfoByLink.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
