using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RdCSharpInteractiveHost : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<RdVoid, RdCsiSessionInfo> RequestNewCsiSessionInfo { get { return _RequestNewCsiSessionInfo; }}
    [NotNull] public RdEndpoint<int, List<string>> RequestNodeAssemblyPaths { get { return _RequestNodeAssemblyPaths; }}
    [NotNull] public IRdProperty<bool> FocusOnOpenToolWindow { get { return _FocusOnOpenToolWindow; }}
    [NotNull] public IRdProperty<bool> FocusOnSendLineText { get { return _FocusOnSendLineText; }}
    [NotNull] public IRdProperty<bool> MoveCaretOnSendLineText { get { return _MoveCaretOnSendLineText; }}
    [NotNull] public IRdProperty<bool> BuildOnReferenceProject { get { return _BuildOnReferenceProject; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<RdVoid, RdCsiSessionInfo> _RequestNewCsiSessionInfo;
    [NotNull] private readonly RdEndpoint<int, List<string>> _RequestNodeAssemblyPaths;
    [NotNull] private readonly RdProperty<bool> _FocusOnOpenToolWindow;
    [NotNull] private readonly RdProperty<bool> _FocusOnSendLineText;
    [NotNull] private readonly RdProperty<bool> _MoveCaretOnSendLineText;
    [NotNull] private readonly RdProperty<bool> _BuildOnReferenceProject;
    
    //primary constructor
    private RdCSharpInteractiveHost(
      [NotNull] RdEndpoint<RdVoid, RdCsiSessionInfo> requestNewCsiSessionInfo,
      [NotNull] RdEndpoint<int, List<string>> requestNodeAssemblyPaths,
      [NotNull] RdProperty<bool> focusOnOpenToolWindow,
      [NotNull] RdProperty<bool> focusOnSendLineText,
      [NotNull] RdProperty<bool> moveCaretOnSendLineText,
      [NotNull] RdProperty<bool> buildOnReferenceProject
    )
    {
      if (requestNewCsiSessionInfo == null) throw new ArgumentNullException("requestNewCsiSessionInfo");
      if (requestNodeAssemblyPaths == null) throw new ArgumentNullException("requestNodeAssemblyPaths");
      if (focusOnOpenToolWindow == null) throw new ArgumentNullException("focusOnOpenToolWindow");
      if (focusOnSendLineText == null) throw new ArgumentNullException("focusOnSendLineText");
      if (moveCaretOnSendLineText == null) throw new ArgumentNullException("moveCaretOnSendLineText");
      if (buildOnReferenceProject == null) throw new ArgumentNullException("buildOnReferenceProject");
      
      _RequestNewCsiSessionInfo = requestNewCsiSessionInfo;
      _RequestNodeAssemblyPaths = requestNodeAssemblyPaths;
      _FocusOnOpenToolWindow = focusOnOpenToolWindow;
      _FocusOnSendLineText = focusOnSendLineText;
      _MoveCaretOnSendLineText = moveCaretOnSendLineText;
      _BuildOnReferenceProject = buildOnReferenceProject;
      _FocusOnOpenToolWindow.OptimizeNested = true;
      _FocusOnSendLineText.OptimizeNested = true;
      _MoveCaretOnSendLineText.OptimizeNested = true;
      _BuildOnReferenceProject.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("requestNewCsiSessionInfo", _RequestNewCsiSessionInfo));
      BindableChildren.Add(new KeyValuePair<string, object>("requestNodeAssemblyPaths", _RequestNodeAssemblyPaths));
      BindableChildren.Add(new KeyValuePair<string, object>("focusOnOpenToolWindow", _FocusOnOpenToolWindow));
      BindableChildren.Add(new KeyValuePair<string, object>("focusOnSendLineText", _FocusOnSendLineText));
      BindableChildren.Add(new KeyValuePair<string, object>("moveCaretOnSendLineText", _MoveCaretOnSendLineText));
      BindableChildren.Add(new KeyValuePair<string, object>("buildOnReferenceProject", _BuildOnReferenceProject));
    }
    //secondary constructor
    internal RdCSharpInteractiveHost (
    ) : this (
      new RdEndpoint<RdVoid, RdCsiSessionInfo>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, RdCsiSessionInfo.Read, RdCsiSessionInfo.Write),
      new RdEndpoint<int, List<string>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, ReadStringList, WriteStringList),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    
    protected override long SerializationHash => -4169538283994997221L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdCsiSessionInfo.Read, RdCsiSessionInfo.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCSharpInteractiveHost (");
      using (printer.IndentCookie()) {
        printer.Print("requestNewCsiSessionInfo = "); _RequestNewCsiSessionInfo.PrintEx(printer); printer.Println();
        printer.Print("requestNodeAssemblyPaths = "); _RequestNodeAssemblyPaths.PrintEx(printer); printer.Println();
        printer.Print("focusOnOpenToolWindow = "); _FocusOnOpenToolWindow.PrintEx(printer); printer.Println();
        printer.Print("focusOnSendLineText = "); _FocusOnSendLineText.PrintEx(printer); printer.Println();
        printer.Print("moveCaretOnSendLineText = "); _MoveCaretOnSendLineText.PrintEx(printer); printer.Println();
        printer.Print("buildOnReferenceProject = "); _BuildOnReferenceProject.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionRdCSharpInteractiveHostEx
   {
    public static RdCSharpInteractiveHost GetRdCSharpInteractiveHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("rdCSharpInteractiveHost", () => new RdCSharpInteractiveHost());
    }
  }
  
  
  public class RdCsiSessionInfo : IPrintable, IEquatable<RdCsiSessionInfo>
  {
    //fields
    //public fields
    [NotNull] public string ToolPath {get; private set;}
    [NotNull] public List<string> ToolArguments {get; private set;}
    
    //private fields
    //primary constructor
    public RdCsiSessionInfo(
      [NotNull] string toolPath,
      [NotNull] List<string> toolArguments
    )
    {
      if (toolPath == null) throw new ArgumentNullException("toolPath");
      if (toolArguments == null) throw new ArgumentNullException("toolArguments");
      
      ToolPath = toolPath;
      ToolArguments = toolArguments;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCsiSessionInfo> Read = (ctx, reader) => 
    {
      var toolPath = reader.ReadString();
      var toolArguments = ReadStringList(ctx, reader);
      return new RdCsiSessionInfo(toolPath, toolArguments);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdCsiSessionInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ToolPath);
      WriteStringList(ctx, writer, value.ToolArguments);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCsiSessionInfo) obj);
    }
    public bool Equals(RdCsiSessionInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ToolPath == other.ToolPath && ToolArguments.SequenceEqual(other.ToolArguments);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ToolPath.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ToolArguments);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCsiSessionInfo (");
      using (printer.IndentCookie()) {
        printer.Print("toolPath = "); ToolPath.PrintEx(printer); printer.Println();
        printer.Print("toolArguments = "); ToolArguments.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
