using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RdEnsureWritableHandlerModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdCall<string, bool> IsWritable { get { return _IsWritable; }}
    [NotNull] public IRdCall<MakeWritableRequest, MakeWritableResponse> MakeWritable { get { return _MakeWritable; }}
    [NotNull] public ISink<string> IsWritableChanged { get { return _IsWritableChanged; }}
    
    //private fields
    [NotNull] private readonly RdCall<string, bool> _IsWritable;
    [NotNull] private readonly RdCall<MakeWritableRequest, MakeWritableResponse> _MakeWritable;
    [NotNull] private readonly RdSignal<string> _IsWritableChanged;
    
    //primary constructor
    private RdEnsureWritableHandlerModel(
      [NotNull] RdCall<string, bool> isWritable,
      [NotNull] RdCall<MakeWritableRequest, MakeWritableResponse> makeWritable,
      [NotNull] RdSignal<string> isWritableChanged
    )
    {
      if (isWritable == null) throw new ArgumentNullException("isWritable");
      if (makeWritable == null) throw new ArgumentNullException("makeWritable");
      if (isWritableChanged == null) throw new ArgumentNullException("isWritableChanged");
      
      _IsWritable = isWritable;
      _MakeWritable = makeWritable;
      _IsWritableChanged = isWritableChanged;
      BindableChildren.Add(new KeyValuePair<string, object>("isWritable", _IsWritable));
      BindableChildren.Add(new KeyValuePair<string, object>("makeWritable", _MakeWritable));
      BindableChildren.Add(new KeyValuePair<string, object>("isWritableChanged", _IsWritableChanged));
    }
    //secondary constructor
    private RdEnsureWritableHandlerModel (
    ) : this (
      new RdCall<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdCall<MakeWritableRequest, MakeWritableResponse>(MakeWritableRequest.Read, MakeWritableRequest.Write, MakeWritableResponse.Read, MakeWritableResponse.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 6996990348448797186L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<RdMakeWritableResultKind>();
      serializers.Register(MakeWritableRequest.Read, MakeWritableRequest.Write);
      serializers.Register(MakeWritableResponse.Read, MakeWritableResponse.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public RdEnsureWritableHandlerModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEnsureWritableHandlerModel (");
      using (printer.IndentCookie()) {
        printer.Print("isWritable = "); _IsWritable.PrintEx(printer); printer.Println();
        printer.Print("makeWritable = "); _MakeWritable.PrintEx(printer); printer.Println();
        printer.Print("isWritableChanged = "); _IsWritableChanged.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeWritableRequest : IPrintable, IEquatable<MakeWritableRequest>
  {
    //fields
    //public fields
    [NotNull] public List<string> Files {get; private set;}
    
    //private fields
    //primary constructor
    public MakeWritableRequest(
      [NotNull] List<string> files
    )
    {
      if (files == null) throw new ArgumentNullException("files");
      
      Files = files;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MakeWritableRequest> Read = (ctx, reader) => 
    {
      var files = ReadStringList(ctx, reader);
      return new MakeWritableRequest(files);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<MakeWritableRequest> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Files);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MakeWritableRequest) obj);
    }
    public bool Equals(MakeWritableRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Files.SequenceEqual(other.Files);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Files);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MakeWritableRequest (");
      using (printer.IndentCookie()) {
        printer.Print("files = "); Files.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeWritableResponse : IPrintable, IEquatable<MakeWritableResponse>
  {
    //fields
    //public fields
    [CanBeNull] public string Message {get; private set;}
    public RdMakeWritableResultKind Result {get; private set;}
    
    //private fields
    //primary constructor
    public MakeWritableResponse(
      [CanBeNull] string message,
      RdMakeWritableResultKind result
    )
    {
      Message = message;
      Result = result;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MakeWritableResponse> Read = (ctx, reader) => 
    {
      var message = ReadStringNullable(ctx, reader);
      var result = (RdMakeWritableResultKind)reader.ReadInt();
      return new MakeWritableResponse(message, result);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<MakeWritableResponse> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Message);
      writer.Write((int)value.Result);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MakeWritableResponse) obj);
    }
    public bool Equals(MakeWritableResponse other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Message, other.Message) && Result == other.Result;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Message != null ?Message.GetHashCode() : 0);
        hash = hash * 31 + (int) Result;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MakeWritableResponse (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("result = "); Result.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdMakeWritableResultKind {
    SUCCESS,
    FAILURE
  }
}
