using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RdEntityFrameworkHost : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdSignal<RdEntityFrameworkResponseBase> ShowResponse { get { return _ShowResponse; }}
    [NotNull] public IRdSignal<RdVoid> NotifyAboutEntityFrameworkSupport { get { return _NotifyAboutEntityFrameworkSupport; }}
    [NotNull] public ISink<RdVoid> DoNotShowNotificationAboutEntityFrameworkSupport { get { return _DoNotShowNotificationAboutEntityFrameworkSupport; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdEntityFrameworkResponseBase> _ShowResponse;
    [NotNull] private readonly RdSignal<RdVoid> _NotifyAboutEntityFrameworkSupport;
    [NotNull] private readonly RdSignal<RdVoid> _DoNotShowNotificationAboutEntityFrameworkSupport;
    
    //primary constructor
    private RdEntityFrameworkHost(
      [NotNull] RdSignal<RdEntityFrameworkResponseBase> showResponse,
      [NotNull] RdSignal<RdVoid> notifyAboutEntityFrameworkSupport,
      [NotNull] RdSignal<RdVoid> doNotShowNotificationAboutEntityFrameworkSupport
    )
    {
      if (showResponse == null) throw new ArgumentNullException("showResponse");
      if (notifyAboutEntityFrameworkSupport == null) throw new ArgumentNullException("notifyAboutEntityFrameworkSupport");
      if (doNotShowNotificationAboutEntityFrameworkSupport == null) throw new ArgumentNullException("doNotShowNotificationAboutEntityFrameworkSupport");
      
      _ShowResponse = showResponse;
      _NotifyAboutEntityFrameworkSupport = notifyAboutEntityFrameworkSupport;
      _DoNotShowNotificationAboutEntityFrameworkSupport = doNotShowNotificationAboutEntityFrameworkSupport;
      BindableChildren.Add(new KeyValuePair<string, object>("showResponse", _ShowResponse));
      BindableChildren.Add(new KeyValuePair<string, object>("notifyAboutEntityFrameworkSupport", _NotifyAboutEntityFrameworkSupport));
      BindableChildren.Add(new KeyValuePair<string, object>("doNotShowNotificationAboutEntityFrameworkSupport", _DoNotShowNotificationAboutEntityFrameworkSupport));
    }
    //secondary constructor
    internal RdEntityFrameworkHost (
    ) : this (
      new RdSignal<RdEntityFrameworkResponseBase>(RdEntityFrameworkResponseBase.Read, RdEntityFrameworkResponseBase.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 8195007105361220817L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<RdEntityFrameworkBeControlId>();
      serializers.Register(RdEntityFrameworkEnableMigrationsRequest.Read, RdEntityFrameworkEnableMigrationsRequest.Write);
      serializers.Register(RdEntityFrameworkResponse.Read, RdEntityFrameworkResponse.Write);
      serializers.Register(RdEntityFrameworkResponseWithExtraText.Read, RdEntityFrameworkResponseWithExtraText.Write);
      serializers.RegisterEnum<RdEntityFrameworkLogLevel>();
      serializers.Register(RdEntityFrameworkRequestBase_Unknown.Read, RdEntityFrameworkRequestBase_Unknown.Write);
      serializers.Register(RdEntityFrameworkRequestWithDatabase_Unknown.Read, RdEntityFrameworkRequestWithDatabase_Unknown.Write);
      serializers.Register(RdEntityFrameworkResponseBase_Unknown.Read, RdEntityFrameworkResponseBase_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEntityFrameworkHost (");
      using (printer.IndentCookie()) {
        printer.Print("showResponse = "); _ShowResponse.PrintEx(printer); printer.Println();
        printer.Print("notifyAboutEntityFrameworkSupport = "); _NotifyAboutEntityFrameworkSupport.PrintEx(printer); printer.Println();
        printer.Print("doNotShowNotificationAboutEntityFrameworkSupport = "); _DoNotShowNotificationAboutEntityFrameworkSupport.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionRdEntityFrameworkHostEx
   {
    public static RdEntityFrameworkHost GetRdEntityFrameworkHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("rdEntityFrameworkHost", () => new RdEntityFrameworkHost());
    }
  }
  
  
  public enum RdEntityFrameworkBeControlId {
    TargetProject,
    ConfigurationProject,
    MigrationsProject
  }
  
  
  public class RdEntityFrameworkEnableMigrationsRequest : RdEntityFrameworkRequestWithDatabase
  {
    //fields
    //public fields
    public bool EnableAutomaticMigrations {get; private set;}
    [NotNull] public string MigrationsDirectory {get; private set;}
    [NotNull] public string ContextTypeFQN {get; private set;}
    
    //private fields
    //primary constructor
    public RdEntityFrameworkEnableMigrationsRequest(
      bool enableAutomaticMigrations,
      [NotNull] string migrationsDirectory,
      [NotNull] string contextTypeFQN,
      int migrationsProjectId,
      int configFileProjectId,
      [CanBeNull] string connectionName,
      [CanBeNull] string connectionString,
      [CanBeNull] string connectionProviderName,
      [CanBeNull] bool? force,
      [CanBeNull] string configurationTypeFQN,
      RdEntityFrameworkLogLevel logLevel
    ) : base (
      migrationsProjectId,
      configFileProjectId,
      connectionName,
      connectionString,
      connectionProviderName,
      force,
      configurationTypeFQN,
      logLevel
     ) 
    {
      if (migrationsDirectory == null) throw new ArgumentNullException("migrationsDirectory");
      if (contextTypeFQN == null) throw new ArgumentNullException("contextTypeFQN");
      
      EnableAutomaticMigrations = enableAutomaticMigrations;
      MigrationsDirectory = migrationsDirectory;
      ContextTypeFQN = contextTypeFQN;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEntityFrameworkEnableMigrationsRequest> Read = (ctx, reader) => 
    {
      var migrationsProjectId = reader.ReadInt();
      var configFileProjectId = reader.ReadInt();
      var connectionName = ReadStringNullable(ctx, reader);
      var connectionString = ReadStringNullable(ctx, reader);
      var connectionProviderName = ReadStringNullable(ctx, reader);
      var force = ReadBoolNullable(ctx, reader);
      var configurationTypeFQN = ReadStringNullable(ctx, reader);
      var logLevel = (RdEntityFrameworkLogLevel)reader.ReadInt();
      var enableAutomaticMigrations = reader.ReadBool();
      var migrationsDirectory = reader.ReadString();
      var contextTypeFQN = reader.ReadString();
      return new RdEntityFrameworkEnableMigrationsRequest(enableAutomaticMigrations, migrationsDirectory, contextTypeFQN, migrationsProjectId, configFileProjectId, connectionName, connectionString, connectionProviderName, force, configurationTypeFQN, logLevel);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static new CtxWriteDelegate<RdEntityFrameworkEnableMigrationsRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.MigrationsProjectId);
      writer.Write(value.ConfigFileProjectId);
      WriteStringNullable(ctx, writer, value.ConnectionName);
      WriteStringNullable(ctx, writer, value.ConnectionString);
      WriteStringNullable(ctx, writer, value.ConnectionProviderName);
      WriteBoolNullable(ctx, writer, value.Force);
      WriteStringNullable(ctx, writer, value.ConfigurationTypeFQN);
      writer.Write((int)value.LogLevel);
      writer.Write(value.EnableAutomaticMigrations);
      writer.Write(value.MigrationsDirectory);
      writer.Write(value.ContextTypeFQN);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEntityFrameworkEnableMigrationsRequest) obj);
    }
    public bool Equals(RdEntityFrameworkEnableMigrationsRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return EnableAutomaticMigrations == other.EnableAutomaticMigrations && MigrationsDirectory == other.MigrationsDirectory && ContextTypeFQN == other.ContextTypeFQN && MigrationsProjectId == other.MigrationsProjectId && ConfigFileProjectId == other.ConfigFileProjectId && Equals(ConnectionName, other.ConnectionName) && Equals(ConnectionString, other.ConnectionString) && Equals(ConnectionProviderName, other.ConnectionProviderName) && Equals(Force, other.Force) && Equals(ConfigurationTypeFQN, other.ConfigurationTypeFQN) && LogLevel == other.LogLevel;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + EnableAutomaticMigrations.GetHashCode();
        hash = hash * 31 + MigrationsDirectory.GetHashCode();
        hash = hash * 31 + ContextTypeFQN.GetHashCode();
        hash = hash * 31 + MigrationsProjectId.GetHashCode();
        hash = hash * 31 + ConfigFileProjectId.GetHashCode();
        hash = hash * 31 + (ConnectionName != null ?ConnectionName.GetHashCode() : 0);
        hash = hash * 31 + (ConnectionString != null ?ConnectionString.GetHashCode() : 0);
        hash = hash * 31 + (ConnectionProviderName != null ?ConnectionProviderName.GetHashCode() : 0);
        hash = hash * 31 + (Force != null ?Force.GetHashCode() : 0);
        hash = hash * 31 + (ConfigurationTypeFQN != null ?ConfigurationTypeFQN.GetHashCode() : 0);
        hash = hash * 31 + (int) LogLevel;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEntityFrameworkEnableMigrationsRequest (");
      using (printer.IndentCookie()) {
        printer.Print("enableAutomaticMigrations = "); EnableAutomaticMigrations.PrintEx(printer); printer.Println();
        printer.Print("migrationsDirectory = "); MigrationsDirectory.PrintEx(printer); printer.Println();
        printer.Print("contextTypeFQN = "); ContextTypeFQN.PrintEx(printer); printer.Println();
        printer.Print("migrationsProjectId = "); MigrationsProjectId.PrintEx(printer); printer.Println();
        printer.Print("configFileProjectId = "); ConfigFileProjectId.PrintEx(printer); printer.Println();
        printer.Print("connectionName = "); ConnectionName.PrintEx(printer); printer.Println();
        printer.Print("connectionString = "); ConnectionString.PrintEx(printer); printer.Println();
        printer.Print("connectionProviderName = "); ConnectionProviderName.PrintEx(printer); printer.Println();
        printer.Print("force = "); Force.PrintEx(printer); printer.Println();
        printer.Print("configurationTypeFQN = "); ConfigurationTypeFQN.PrintEx(printer); printer.Println();
        printer.Print("logLevel = "); LogLevel.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdEntityFrameworkLogLevel {
    Info,
    Verbose,
    Trace
  }
  
  
  public abstract class RdEntityFrameworkRequestBase{
    //fields
    //public fields
    public RdEntityFrameworkLogLevel LogLevel {get; private set;}
    
    //private fields
    //primary constructor
    protected RdEntityFrameworkRequestBase(
      RdEntityFrameworkLogLevel logLevel
    )
    {
      LogLevel = logLevel;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEntityFrameworkRequestBase> Read = Polymorphic<RdEntityFrameworkRequestBase>.ReadAbstract(RdEntityFrameworkRequestBase_Unknown.Read);
    
    public static CtxWriteDelegate<RdEntityFrameworkRequestBase> Write = Polymorphic<RdEntityFrameworkRequestBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEntityFrameworkRequestBase_Unknown : RdEntityFrameworkRequestBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdEntityFrameworkRequestBase_Unknown(
      RdEntityFrameworkLogLevel logLevel
    ) : base (
      logLevel
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEntityFrameworkRequestBase_Unknown> Read = (ctx, reader) => 
    {
      var logLevel = (RdEntityFrameworkLogLevel)reader.ReadInt();
      return new RdEntityFrameworkRequestBase_Unknown(logLevel);
    };
    
    public static new CtxWriteDelegate<RdEntityFrameworkRequestBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.LogLevel);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEntityFrameworkRequestBase_Unknown) obj);
    }
    public bool Equals(RdEntityFrameworkRequestBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return LogLevel == other.LogLevel;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) LogLevel;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEntityFrameworkRequestBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("logLevel = "); LogLevel.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdEntityFrameworkRequestWithDatabase : RdEntityFrameworkRequestBase
  {
    //fields
    //public fields
    public int MigrationsProjectId {get; private set;}
    public int ConfigFileProjectId {get; private set;}
    [CanBeNull] public string ConnectionName {get; private set;}
    [CanBeNull] public string ConnectionString {get; private set;}
    [CanBeNull] public string ConnectionProviderName {get; private set;}
    [CanBeNull] public bool? Force {get; private set;}
    [CanBeNull] public string ConfigurationTypeFQN {get; private set;}
    
    //private fields
    //primary constructor
    protected RdEntityFrameworkRequestWithDatabase(
      int migrationsProjectId,
      int configFileProjectId,
      [CanBeNull] string connectionName,
      [CanBeNull] string connectionString,
      [CanBeNull] string connectionProviderName,
      [CanBeNull] bool? force,
      [CanBeNull] string configurationTypeFQN,
      RdEntityFrameworkLogLevel logLevel
    ) : base (
      logLevel
     ) 
    {
      MigrationsProjectId = migrationsProjectId;
      ConfigFileProjectId = configFileProjectId;
      ConnectionName = connectionName;
      ConnectionString = connectionString;
      ConnectionProviderName = connectionProviderName;
      Force = force;
      ConfigurationTypeFQN = configurationTypeFQN;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEntityFrameworkRequestWithDatabase> Read = Polymorphic<RdEntityFrameworkRequestWithDatabase>.ReadAbstract(RdEntityFrameworkRequestWithDatabase_Unknown.Read);
    
    public static new CtxWriteDelegate<RdEntityFrameworkRequestWithDatabase> Write = Polymorphic<RdEntityFrameworkRequestWithDatabase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEntityFrameworkRequestWithDatabase_Unknown : RdEntityFrameworkRequestWithDatabase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdEntityFrameworkRequestWithDatabase_Unknown(
      int migrationsProjectId,
      int configFileProjectId,
      [CanBeNull] string connectionName,
      [CanBeNull] string connectionString,
      [CanBeNull] string connectionProviderName,
      [CanBeNull] bool? force,
      [CanBeNull] string configurationTypeFQN,
      RdEntityFrameworkLogLevel logLevel
    ) : base (
      migrationsProjectId,
      configFileProjectId,
      connectionName,
      connectionString,
      connectionProviderName,
      force,
      configurationTypeFQN,
      logLevel
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEntityFrameworkRequestWithDatabase_Unknown> Read = (ctx, reader) => 
    {
      var migrationsProjectId = reader.ReadInt();
      var configFileProjectId = reader.ReadInt();
      var connectionName = ReadStringNullable(ctx, reader);
      var connectionString = ReadStringNullable(ctx, reader);
      var connectionProviderName = ReadStringNullable(ctx, reader);
      var force = ReadBoolNullable(ctx, reader);
      var configurationTypeFQN = ReadStringNullable(ctx, reader);
      var logLevel = (RdEntityFrameworkLogLevel)reader.ReadInt();
      return new RdEntityFrameworkRequestWithDatabase_Unknown(migrationsProjectId, configFileProjectId, connectionName, connectionString, connectionProviderName, force, configurationTypeFQN, logLevel);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static new CtxWriteDelegate<RdEntityFrameworkRequestWithDatabase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.MigrationsProjectId);
      writer.Write(value.ConfigFileProjectId);
      WriteStringNullable(ctx, writer, value.ConnectionName);
      WriteStringNullable(ctx, writer, value.ConnectionString);
      WriteStringNullable(ctx, writer, value.ConnectionProviderName);
      WriteBoolNullable(ctx, writer, value.Force);
      WriteStringNullable(ctx, writer, value.ConfigurationTypeFQN);
      writer.Write((int)value.LogLevel);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEntityFrameworkRequestWithDatabase_Unknown) obj);
    }
    public bool Equals(RdEntityFrameworkRequestWithDatabase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return MigrationsProjectId == other.MigrationsProjectId && ConfigFileProjectId == other.ConfigFileProjectId && Equals(ConnectionName, other.ConnectionName) && Equals(ConnectionString, other.ConnectionString) && Equals(ConnectionProviderName, other.ConnectionProviderName) && Equals(Force, other.Force) && Equals(ConfigurationTypeFQN, other.ConfigurationTypeFQN) && LogLevel == other.LogLevel;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + MigrationsProjectId.GetHashCode();
        hash = hash * 31 + ConfigFileProjectId.GetHashCode();
        hash = hash * 31 + (ConnectionName != null ?ConnectionName.GetHashCode() : 0);
        hash = hash * 31 + (ConnectionString != null ?ConnectionString.GetHashCode() : 0);
        hash = hash * 31 + (ConnectionProviderName != null ?ConnectionProviderName.GetHashCode() : 0);
        hash = hash * 31 + (Force != null ?Force.GetHashCode() : 0);
        hash = hash * 31 + (ConfigurationTypeFQN != null ?ConfigurationTypeFQN.GetHashCode() : 0);
        hash = hash * 31 + (int) LogLevel;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEntityFrameworkRequestWithDatabase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("migrationsProjectId = "); MigrationsProjectId.PrintEx(printer); printer.Println();
        printer.Print("configFileProjectId = "); ConfigFileProjectId.PrintEx(printer); printer.Println();
        printer.Print("connectionName = "); ConnectionName.PrintEx(printer); printer.Println();
        printer.Print("connectionString = "); ConnectionString.PrintEx(printer); printer.Println();
        printer.Print("connectionProviderName = "); ConnectionProviderName.PrintEx(printer); printer.Println();
        printer.Print("force = "); Force.PrintEx(printer); printer.Println();
        printer.Print("configurationTypeFQN = "); ConfigurationTypeFQN.PrintEx(printer); printer.Println();
        printer.Print("logLevel = "); LogLevel.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEntityFrameworkResponse : RdEntityFrameworkResponseBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdEntityFrameworkResponse(
      [NotNull] string title,
      bool isSuccessful,
      [NotNull] string processLog
    ) : base (
      title,
      isSuccessful,
      processLog
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEntityFrameworkResponse> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var isSuccessful = reader.ReadBool();
      var processLog = reader.ReadString();
      return new RdEntityFrameworkResponse(title, isSuccessful, processLog);
    };
    
    public static new CtxWriteDelegate<RdEntityFrameworkResponse> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.IsSuccessful);
      writer.Write(value.ProcessLog);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEntityFrameworkResponse) obj);
    }
    public bool Equals(RdEntityFrameworkResponse other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Title == other.Title && IsSuccessful == other.IsSuccessful && ProcessLog == other.ProcessLog;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + IsSuccessful.GetHashCode();
        hash = hash * 31 + ProcessLog.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEntityFrameworkResponse (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("isSuccessful = "); IsSuccessful.PrintEx(printer); printer.Println();
        printer.Print("processLog = "); ProcessLog.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdEntityFrameworkResponseBase{
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    public bool IsSuccessful {get; private set;}
    [NotNull] public string ProcessLog {get; private set;}
    
    //private fields
    //primary constructor
    protected RdEntityFrameworkResponseBase(
      [NotNull] string title,
      bool isSuccessful,
      [NotNull] string processLog
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (processLog == null) throw new ArgumentNullException("processLog");
      
      Title = title;
      IsSuccessful = isSuccessful;
      ProcessLog = processLog;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEntityFrameworkResponseBase> Read = Polymorphic<RdEntityFrameworkResponseBase>.ReadAbstract(RdEntityFrameworkResponseBase_Unknown.Read);
    
    public static CtxWriteDelegate<RdEntityFrameworkResponseBase> Write = Polymorphic<RdEntityFrameworkResponseBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEntityFrameworkResponseBase_Unknown : RdEntityFrameworkResponseBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public RdEntityFrameworkResponseBase_Unknown(
      [NotNull] string title,
      bool isSuccessful,
      [NotNull] string processLog
    ) : base (
      title,
      isSuccessful,
      processLog
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEntityFrameworkResponseBase_Unknown> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var isSuccessful = reader.ReadBool();
      var processLog = reader.ReadString();
      return new RdEntityFrameworkResponseBase_Unknown(title, isSuccessful, processLog);
    };
    
    public static new CtxWriteDelegate<RdEntityFrameworkResponseBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.IsSuccessful);
      writer.Write(value.ProcessLog);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEntityFrameworkResponseBase_Unknown) obj);
    }
    public bool Equals(RdEntityFrameworkResponseBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Title == other.Title && IsSuccessful == other.IsSuccessful && ProcessLog == other.ProcessLog;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + IsSuccessful.GetHashCode();
        hash = hash * 31 + ProcessLog.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEntityFrameworkResponseBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("isSuccessful = "); IsSuccessful.PrintEx(printer); printer.Println();
        printer.Print("processLog = "); ProcessLog.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEntityFrameworkResponseWithExtraText : RdEntityFrameworkResponseBase
  {
    //fields
    //public fields
    [NotNull] public string ExtraText {get; private set;}
    
    //private fields
    //primary constructor
    public RdEntityFrameworkResponseWithExtraText(
      [NotNull] string extraText,
      [NotNull] string title,
      bool isSuccessful,
      [NotNull] string processLog
    ) : base (
      title,
      isSuccessful,
      processLog
     ) 
    {
      if (extraText == null) throw new ArgumentNullException("extraText");
      
      ExtraText = extraText;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEntityFrameworkResponseWithExtraText> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var isSuccessful = reader.ReadBool();
      var processLog = reader.ReadString();
      var extraText = reader.ReadString();
      return new RdEntityFrameworkResponseWithExtraText(extraText, title, isSuccessful, processLog);
    };
    
    public static new CtxWriteDelegate<RdEntityFrameworkResponseWithExtraText> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.IsSuccessful);
      writer.Write(value.ProcessLog);
      writer.Write(value.ExtraText);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdEntityFrameworkResponseWithExtraText) obj);
    }
    public bool Equals(RdEntityFrameworkResponseWithExtraText other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ExtraText == other.ExtraText && Title == other.Title && IsSuccessful == other.IsSuccessful && ProcessLog == other.ProcessLog;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ExtraText.GetHashCode();
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + IsSuccessful.GetHashCode();
        hash = hash * 31 + ProcessLog.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdEntityFrameworkResponseWithExtraText (");
      using (printer.IndentCookie()) {
        printer.Print("extraText = "); ExtraText.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("isSuccessful = "); IsSuccessful.PrintEx(printer); printer.Println();
        printer.Print("processLog = "); ProcessLog.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
