using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RdNuGetHost : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public ISink<RdVoid> ClearCache { get { return _ClearCache; }}
    [NotNull] public ISource<List<RdNuGetLogMessage>> Log { get { return _Log; }}
    [NotNull] public ISource<string> ViewModelLog { get { return _ViewModelLog; }}
    [NotNull] public ISource<RdNuGetNotification> Notify { get { return _Notify; }}
    [NotNull] public RdNuGetOperator NuGetOperator {get; private set;}
    [NotNull] public ISink<RdVoid> ZeroLatencyUpdate { get { return _ZeroLatencyUpdate; }}
    [NotNull] public ISource<RdVoid> ZeroLatencyUpdateFinished { get { return _ZeroLatencyUpdateFinished; }}
    [NotNull] public IViewableMap<int, RdNuGetProjectInfo> ProjectInfos { get { return _ProjectInfos; }}
    [NotNull] public IRdProperty<int> ContextProjectId { get { return _ContextProjectId; }}
    [NotNull] public IRdProperty<string> SearchTerm { get { return _SearchTerm; }}
    [NotNull] public IRdProperty<List<RdNuGetSmartMetadata>> FoundPackages { get { return _FoundPackages; }}
    [NotNull] public IRdProperty<string> TargetPackageId { get { return _TargetPackageId; }}
    [NotNull] public IRdProperty<string> TargetPackageVersion { get { return _TargetPackageVersion; }}
    [NotNull] public IRdProperty<string> TargetPackageFeedId { get { return _TargetPackageFeedId; }}
    [NotNull] public IRdProperty<List<RdNuGetVersionsInFeed>> ChosenPackageVersions { get { return _ChosenPackageVersions; }}
    [NotNull] public IRdProperty<RdNuGetPackageMetadata> ChosenPackageMeta { get { return _ChosenPackageMeta; }}
    [NotNull] public IRdProperty<bool> IncludePrerelease { get { return _IncludePrerelease; }}
    [NotNull] public IRdProperty<bool> IncludeUnlisted { get { return _IncludeUnlisted; }}
    [NotNull] public IRdProperty<RdNuGetDependencyBehavior> DependencyBehavior { get { return _DependencyBehavior; }}
    [NotNull] public IRdProperty<RdNuGetFileConflictAction> FileConflictAction { get { return _FileConflictAction; }}
    [NotNull] public IRdProperty<bool> RemoveDependencies { get { return _RemoveDependencies; }}
    [NotNull] public IRdProperty<bool> ForceRemove { get { return _ForceRemove; }}
    [NotNull] public IRdProperty<RdNuGetVersionConstraints> VersionConstraints { get { return _VersionConstraints; }}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] public IRdProperty<bool> GlobalSearchIsEnabled { get { return _GlobalSearchIsEnabled; }}
    [NotNull] public RdNuGetConfigManager ConfigManager {get; private set;}
    [NotNull] public ISource<string> Status { get { return _Status; }}
    [NotNull] public IRdProperty<bool> IsLoaded { get { return _IsLoaded; }}
    [NotNull] public ISource<RdNuGetFindViaToolWindowArgs> FindViaToolWindow { get { return _FindViaToolWindow; }}
    [NotNull] public IRdProperty<bool> FolderTabIsActive { get { return _FolderTabIsActive; }}
    [NotNull] public RdNuGetFolderManager FolderManager {get; private set;}
    [NotNull] public RdNuGetStateInfo StateInfo {get; private set;}
    [NotNull] public ISink<int> VerifyPackageSpecs { get { return _VerifyPackageSpecs; }}
    [NotNull] public ISource<RdNuGetVerifyPackageSpecsResult> VerifyPackageSpecsFinish { get { return _VerifyPackageSpecsFinish; }}
    [NotNull] public RdCredentialProvider CredentialProvider {get; private set;}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _ClearCache;
    [NotNull] private readonly RdSignal<List<RdNuGetLogMessage>> _Log;
    [NotNull] private readonly RdSignal<string> _ViewModelLog;
    [NotNull] private readonly RdSignal<RdNuGetNotification> _Notify;
    [NotNull] private readonly RdSignal<RdVoid> _ZeroLatencyUpdate;
    [NotNull] private readonly RdSignal<RdVoid> _ZeroLatencyUpdateFinished;
    [NotNull] private readonly RdMap<int, RdNuGetProjectInfo> _ProjectInfos;
    [NotNull] private readonly RdProperty<int> _ContextProjectId;
    [NotNull] private readonly RdProperty<string> _SearchTerm;
    [NotNull] private readonly RdProperty<List<RdNuGetSmartMetadata>> _FoundPackages;
    [NotNull] private readonly RdProperty<string> _TargetPackageId;
    [NotNull] private readonly RdProperty<string> _TargetPackageVersion;
    [NotNull] private readonly RdProperty<string> _TargetPackageFeedId;
    [NotNull] private readonly RdProperty<List<RdNuGetVersionsInFeed>> _ChosenPackageVersions;
    [NotNull] private readonly RdProperty<RdNuGetPackageMetadata> _ChosenPackageMeta;
    [NotNull] private readonly RdProperty<bool> _IncludePrerelease;
    [NotNull] private readonly RdProperty<bool> _IncludeUnlisted;
    [NotNull] private readonly RdProperty<RdNuGetDependencyBehavior> _DependencyBehavior;
    [NotNull] private readonly RdProperty<RdNuGetFileConflictAction> _FileConflictAction;
    [NotNull] private readonly RdProperty<bool> _RemoveDependencies;
    [NotNull] private readonly RdProperty<bool> _ForceRemove;
    [NotNull] private readonly RdProperty<RdNuGetVersionConstraints> _VersionConstraints;
    [NotNull] private readonly RdProperty<bool> _Enabled;
    [NotNull] private readonly RdProperty<bool> _GlobalSearchIsEnabled;
    [NotNull] private readonly RdSignal<string> _Status;
    [NotNull] private readonly RdProperty<bool> _IsLoaded;
    [NotNull] private readonly RdSignal<RdNuGetFindViaToolWindowArgs> _FindViaToolWindow;
    [NotNull] private readonly RdProperty<bool> _FolderTabIsActive;
    [NotNull] private readonly RdSignal<int> _VerifyPackageSpecs;
    [NotNull] private readonly RdSignal<RdNuGetVerifyPackageSpecsResult> _VerifyPackageSpecsFinish;
    
    //primary constructor
    private RdNuGetHost(
      [NotNull] RdSignal<RdVoid> clearCache,
      [NotNull] RdSignal<List<RdNuGetLogMessage>> log,
      [NotNull] RdSignal<string> viewModelLog,
      [NotNull] RdSignal<RdNuGetNotification> notify,
      [NotNull] RdNuGetOperator nuGetOperator,
      [NotNull] RdSignal<RdVoid> zeroLatencyUpdate,
      [NotNull] RdSignal<RdVoid> zeroLatencyUpdateFinished,
      [NotNull] RdMap<int, RdNuGetProjectInfo> projectInfos,
      [NotNull] RdProperty<int> contextProjectId,
      [NotNull] RdProperty<string> searchTerm,
      [NotNull] RdProperty<List<RdNuGetSmartMetadata>> foundPackages,
      [NotNull] RdProperty<string> targetPackageId,
      [NotNull] RdProperty<string> targetPackageVersion,
      [NotNull] RdProperty<string> targetPackageFeedId,
      [NotNull] RdProperty<List<RdNuGetVersionsInFeed>> chosenPackageVersions,
      [NotNull] RdProperty<RdNuGetPackageMetadata> chosenPackageMeta,
      [NotNull] RdProperty<bool> includePrerelease,
      [NotNull] RdProperty<bool> includeUnlisted,
      [NotNull] RdProperty<RdNuGetDependencyBehavior> dependencyBehavior,
      [NotNull] RdProperty<RdNuGetFileConflictAction> fileConflictAction,
      [NotNull] RdProperty<bool> removeDependencies,
      [NotNull] RdProperty<bool> forceRemove,
      [NotNull] RdProperty<RdNuGetVersionConstraints> versionConstraints,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> globalSearchIsEnabled,
      [NotNull] RdNuGetConfigManager configManager,
      [NotNull] RdSignal<string> status,
      [NotNull] RdProperty<bool> isLoaded,
      [NotNull] RdSignal<RdNuGetFindViaToolWindowArgs> findViaToolWindow,
      [NotNull] RdProperty<bool> folderTabIsActive,
      [NotNull] RdNuGetFolderManager folderManager,
      [NotNull] RdNuGetStateInfo stateInfo,
      [NotNull] RdSignal<int> verifyPackageSpecs,
      [NotNull] RdSignal<RdNuGetVerifyPackageSpecsResult> verifyPackageSpecsFinish,
      [NotNull] RdCredentialProvider credentialProvider
    )
    {
      if (clearCache == null) throw new ArgumentNullException("clearCache");
      if (log == null) throw new ArgumentNullException("log");
      if (viewModelLog == null) throw new ArgumentNullException("viewModelLog");
      if (notify == null) throw new ArgumentNullException("notify");
      if (nuGetOperator == null) throw new ArgumentNullException("nuGetOperator");
      if (zeroLatencyUpdate == null) throw new ArgumentNullException("zeroLatencyUpdate");
      if (zeroLatencyUpdateFinished == null) throw new ArgumentNullException("zeroLatencyUpdateFinished");
      if (projectInfos == null) throw new ArgumentNullException("projectInfos");
      if (contextProjectId == null) throw new ArgumentNullException("contextProjectId");
      if (searchTerm == null) throw new ArgumentNullException("searchTerm");
      if (foundPackages == null) throw new ArgumentNullException("foundPackages");
      if (targetPackageId == null) throw new ArgumentNullException("targetPackageId");
      if (targetPackageVersion == null) throw new ArgumentNullException("targetPackageVersion");
      if (targetPackageFeedId == null) throw new ArgumentNullException("targetPackageFeedId");
      if (chosenPackageVersions == null) throw new ArgumentNullException("chosenPackageVersions");
      if (chosenPackageMeta == null) throw new ArgumentNullException("chosenPackageMeta");
      if (includePrerelease == null) throw new ArgumentNullException("includePrerelease");
      if (includeUnlisted == null) throw new ArgumentNullException("includeUnlisted");
      if (dependencyBehavior == null) throw new ArgumentNullException("dependencyBehavior");
      if (fileConflictAction == null) throw new ArgumentNullException("fileConflictAction");
      if (removeDependencies == null) throw new ArgumentNullException("removeDependencies");
      if (forceRemove == null) throw new ArgumentNullException("forceRemove");
      if (versionConstraints == null) throw new ArgumentNullException("versionConstraints");
      if (enabled == null) throw new ArgumentNullException("enabled");
      if (globalSearchIsEnabled == null) throw new ArgumentNullException("globalSearchIsEnabled");
      if (configManager == null) throw new ArgumentNullException("configManager");
      if (status == null) throw new ArgumentNullException("status");
      if (isLoaded == null) throw new ArgumentNullException("isLoaded");
      if (findViaToolWindow == null) throw new ArgumentNullException("findViaToolWindow");
      if (folderTabIsActive == null) throw new ArgumentNullException("folderTabIsActive");
      if (folderManager == null) throw new ArgumentNullException("folderManager");
      if (stateInfo == null) throw new ArgumentNullException("stateInfo");
      if (verifyPackageSpecs == null) throw new ArgumentNullException("verifyPackageSpecs");
      if (verifyPackageSpecsFinish == null) throw new ArgumentNullException("verifyPackageSpecsFinish");
      if (credentialProvider == null) throw new ArgumentNullException("credentialProvider");
      
      _ClearCache = clearCache;
      _Log = log;
      _ViewModelLog = viewModelLog;
      _Notify = notify;
      NuGetOperator = nuGetOperator;
      _ZeroLatencyUpdate = zeroLatencyUpdate;
      _ZeroLatencyUpdateFinished = zeroLatencyUpdateFinished;
      _ProjectInfos = projectInfos;
      _ContextProjectId = contextProjectId;
      _SearchTerm = searchTerm;
      _FoundPackages = foundPackages;
      _TargetPackageId = targetPackageId;
      _TargetPackageVersion = targetPackageVersion;
      _TargetPackageFeedId = targetPackageFeedId;
      _ChosenPackageVersions = chosenPackageVersions;
      _ChosenPackageMeta = chosenPackageMeta;
      _IncludePrerelease = includePrerelease;
      _IncludeUnlisted = includeUnlisted;
      _DependencyBehavior = dependencyBehavior;
      _FileConflictAction = fileConflictAction;
      _RemoveDependencies = removeDependencies;
      _ForceRemove = forceRemove;
      _VersionConstraints = versionConstraints;
      _Enabled = enabled;
      _GlobalSearchIsEnabled = globalSearchIsEnabled;
      ConfigManager = configManager;
      _Status = status;
      _IsLoaded = isLoaded;
      _FindViaToolWindow = findViaToolWindow;
      _FolderTabIsActive = folderTabIsActive;
      FolderManager = folderManager;
      StateInfo = stateInfo;
      _VerifyPackageSpecs = verifyPackageSpecs;
      _VerifyPackageSpecsFinish = verifyPackageSpecsFinish;
      CredentialProvider = credentialProvider;
      _ContextProjectId.OptimizeNested = true;
      _SearchTerm.OptimizeNested = true;
      _FoundPackages.OptimizeNested = true;
      _TargetPackageId.OptimizeNested = true;
      _TargetPackageVersion.OptimizeNested = true;
      _TargetPackageFeedId.OptimizeNested = true;
      _ChosenPackageVersions.OptimizeNested = true;
      _ChosenPackageMeta.OptimizeNested = true;
      _IncludePrerelease.OptimizeNested = true;
      _IncludeUnlisted.OptimizeNested = true;
      _DependencyBehavior.OptimizeNested = true;
      _FileConflictAction.OptimizeNested = true;
      _RemoveDependencies.OptimizeNested = true;
      _ForceRemove.OptimizeNested = true;
      _VersionConstraints.OptimizeNested = true;
      _Enabled.OptimizeNested = true;
      _GlobalSearchIsEnabled.OptimizeNested = true;
      _IsLoaded.OptimizeNested = true;
      _FolderTabIsActive.OptimizeNested = true;
      _ChosenPackageMeta.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("clearCache", _ClearCache));
      BindableChildren.Add(new KeyValuePair<string, object>("log", _Log));
      BindableChildren.Add(new KeyValuePair<string, object>("viewModelLog", _ViewModelLog));
      BindableChildren.Add(new KeyValuePair<string, object>("notify", _Notify));
      BindableChildren.Add(new KeyValuePair<string, object>("nuGetOperator", NuGetOperator));
      BindableChildren.Add(new KeyValuePair<string, object>("zeroLatencyUpdate", _ZeroLatencyUpdate));
      BindableChildren.Add(new KeyValuePair<string, object>("zeroLatencyUpdateFinished", _ZeroLatencyUpdateFinished));
      BindableChildren.Add(new KeyValuePair<string, object>("projectInfos", _ProjectInfos));
      BindableChildren.Add(new KeyValuePair<string, object>("contextProjectId", _ContextProjectId));
      BindableChildren.Add(new KeyValuePair<string, object>("searchTerm", _SearchTerm));
      BindableChildren.Add(new KeyValuePair<string, object>("foundPackages", _FoundPackages));
      BindableChildren.Add(new KeyValuePair<string, object>("targetPackageId", _TargetPackageId));
      BindableChildren.Add(new KeyValuePair<string, object>("targetPackageVersion", _TargetPackageVersion));
      BindableChildren.Add(new KeyValuePair<string, object>("targetPackageFeedId", _TargetPackageFeedId));
      BindableChildren.Add(new KeyValuePair<string, object>("chosenPackageVersions", _ChosenPackageVersions));
      BindableChildren.Add(new KeyValuePair<string, object>("chosenPackageMeta", _ChosenPackageMeta));
      BindableChildren.Add(new KeyValuePair<string, object>("includePrerelease", _IncludePrerelease));
      BindableChildren.Add(new KeyValuePair<string, object>("includeUnlisted", _IncludeUnlisted));
      BindableChildren.Add(new KeyValuePair<string, object>("dependencyBehavior", _DependencyBehavior));
      BindableChildren.Add(new KeyValuePair<string, object>("fileConflictAction", _FileConflictAction));
      BindableChildren.Add(new KeyValuePair<string, object>("removeDependencies", _RemoveDependencies));
      BindableChildren.Add(new KeyValuePair<string, object>("forceRemove", _ForceRemove));
      BindableChildren.Add(new KeyValuePair<string, object>("versionConstraints", _VersionConstraints));
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
      BindableChildren.Add(new KeyValuePair<string, object>("globalSearchIsEnabled", _GlobalSearchIsEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("configManager", ConfigManager));
      BindableChildren.Add(new KeyValuePair<string, object>("status", _Status));
      BindableChildren.Add(new KeyValuePair<string, object>("isLoaded", _IsLoaded));
      BindableChildren.Add(new KeyValuePair<string, object>("findViaToolWindow", _FindViaToolWindow));
      BindableChildren.Add(new KeyValuePair<string, object>("folderTabIsActive", _FolderTabIsActive));
      BindableChildren.Add(new KeyValuePair<string, object>("folderManager", FolderManager));
      BindableChildren.Add(new KeyValuePair<string, object>("stateInfo", StateInfo));
      BindableChildren.Add(new KeyValuePair<string, object>("verifyPackageSpecs", _VerifyPackageSpecs));
      BindableChildren.Add(new KeyValuePair<string, object>("verifyPackageSpecsFinish", _VerifyPackageSpecsFinish));
      BindableChildren.Add(new KeyValuePair<string, object>("credentialProvider", CredentialProvider));
    }
    //secondary constructor
    internal RdNuGetHost (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<List<RdNuGetLogMessage>>(ReadRdNuGetLogMessageList, WriteRdNuGetLogMessageList),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<RdNuGetNotification>(RdNuGetNotification.Read, RdNuGetNotification.Write),
      new RdNuGetOperator(),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdMap<int, RdNuGetProjectInfo>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdNuGetProjectInfo.Read, RdNuGetProjectInfo.Write),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<List<RdNuGetSmartMetadata>>(ReadRdNuGetSmartMetadataList, WriteRdNuGetSmartMetadataList),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<List<RdNuGetVersionsInFeed>>(ReadRdNuGetVersionsInFeedList, WriteRdNuGetVersionsInFeedList),
      new RdProperty<RdNuGetPackageMetadata>(ReadRdNuGetPackageMetadataNullable, WriteRdNuGetPackageMetadataNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<RdNuGetDependencyBehavior>(ReadRdNuGetDependencyBehavior, WriteRdNuGetDependencyBehavior),
      new RdProperty<RdNuGetFileConflictAction>(ReadRdNuGetFileConflictAction, WriteRdNuGetFileConflictAction),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<RdNuGetVersionConstraints>(ReadRdNuGetVersionConstraints, WriteRdNuGetVersionConstraints),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdNuGetConfigManager(),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdNuGetFindViaToolWindowArgs>(RdNuGetFindViaToolWindowArgs.Read, RdNuGetFindViaToolWindowArgs.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdNuGetFolderManager(),
      new RdNuGetStateInfo(),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<RdNuGetVerifyPackageSpecsResult>(RdNuGetVerifyPackageSpecsResult.Read, RdNuGetVerifyPackageSpecsResult.Write),
      new RdCredentialProvider()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<RdNuGetLogMessage>> ReadRdNuGetLogMessageList = RdNuGetLogMessage.Read.List();
    public static CtxReadDelegate<List<RdNuGetSmartMetadata>> ReadRdNuGetSmartMetadataList = RdNuGetSmartMetadata.Read.List();
    public static CtxReadDelegate<List<RdNuGetVersionsInFeed>> ReadRdNuGetVersionsInFeedList = RdNuGetVersionsInFeed.Read.List();
    public static CtxReadDelegate<RdNuGetPackageMetadata> ReadRdNuGetPackageMetadataNullable = RdNuGetPackageMetadata.Read.NullableClass();
    public static CtxReadDelegate<RdNuGetDependencyBehavior> ReadRdNuGetDependencyBehavior = new CtxReadDelegate<RdNuGetDependencyBehavior>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdNuGetDependencyBehavior>);
    public static CtxReadDelegate<RdNuGetFileConflictAction> ReadRdNuGetFileConflictAction = new CtxReadDelegate<RdNuGetFileConflictAction>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdNuGetFileConflictAction>);
    public static CtxReadDelegate<RdNuGetVersionConstraints> ReadRdNuGetVersionConstraints = new CtxReadDelegate<RdNuGetVersionConstraints>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdNuGetVersionConstraints>);
    
    public static CtxWriteDelegate<List<RdNuGetLogMessage>> WriteRdNuGetLogMessageList = RdNuGetLogMessage.Write.List();
    public static CtxWriteDelegate<List<RdNuGetSmartMetadata>> WriteRdNuGetSmartMetadataList = RdNuGetSmartMetadata.Write.List();
    public static CtxWriteDelegate<List<RdNuGetVersionsInFeed>> WriteRdNuGetVersionsInFeedList = RdNuGetVersionsInFeed.Write.List();
    public static CtxWriteDelegate<RdNuGetPackageMetadata> WriteRdNuGetPackageMetadataNullable = RdNuGetPackageMetadata.Write.NullableClass();
    public static CtxWriteDelegate<RdNuGetDependencyBehavior> WriteRdNuGetDependencyBehavior = new CtxWriteDelegate<RdNuGetDependencyBehavior>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdNuGetDependencyBehavior>);
    public static CtxWriteDelegate<RdNuGetFileConflictAction> WriteRdNuGetFileConflictAction = new CtxWriteDelegate<RdNuGetFileConflictAction>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdNuGetFileConflictAction>);
    public static CtxWriteDelegate<RdNuGetVersionConstraints> WriteRdNuGetVersionConstraints = new CtxWriteDelegate<RdNuGetVersionConstraints>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdNuGetVersionConstraints>);
    
    protected override long SerializationHash => -6335553227069751587L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<RdNuGetDependencyBehavior>();
      serializers.RegisterEnum<RdNuGetFileConflictAction>();
      serializers.RegisterEnum<RdNuGetVersionConstraints>();
      serializers.Register(RdNuGetVersionRange.Read, RdNuGetVersionRange.Write);
      serializers.Register(RdNuGetPackageIdentity.Read, RdNuGetPackageIdentity.Write);
      serializers.Register(RdNuGetFramework.Read, RdNuGetFramework.Write);
      serializers.Register(RdNuGetPackageDependency.Read, RdNuGetPackageDependency.Write);
      serializers.Register(RdNuGetPackageDependencyGroup.Read, RdNuGetPackageDependencyGroup.Write);
      serializers.Register(RdNuGetPackageMetadata.Read, RdNuGetPackageMetadata.Write);
      serializers.Register(RdNuGetSmartMetadata.Read, RdNuGetSmartMetadata.Write);
      serializers.Register(RdNuGetPackageSource.Read, RdNuGetPackageSource.Write);
      serializers.Register(RdNuGetProjects.Read, RdNuGetProjects.Write);
      serializers.Register(RdNuGetInstallOneRequest.Read, RdNuGetInstallOneRequest.Write);
      serializers.RegisterEnum<RdNuGetNotificationMode>();
      serializers.RegisterEnum<RdNuGetRestoreStrategy>();
      serializers.Register(RdNuGetLogMessage.Read, RdNuGetLogMessage.Write);
      serializers.Register(RdNuGetNotification.Read, RdNuGetNotification.Write);
      serializers.Register(RdNuGetOperator.Read, RdNuGetOperator.Write);
      serializers.Register(RdNuGetProjectInfo.Read, RdNuGetProjectInfo.Write);
      serializers.Register(RdNuGetVersionsInFeed.Read, RdNuGetVersionsInFeed.Write);
      serializers.Register(RdNuGetConfigManager.Read, RdNuGetConfigManager.Write);
      serializers.Register(RdNuGetFindViaToolWindowArgs.Read, RdNuGetFindViaToolWindowArgs.Write);
      serializers.Register(RdNuGetFolderManager.Read, RdNuGetFolderManager.Write);
      serializers.Register(RdNuGetStateInfo.Read, RdNuGetStateInfo.Write);
      serializers.Register(RdNuGetVerifyPackageSpecsResult.Read, RdNuGetVerifyPackageSpecsResult.Write);
      serializers.Register(RdCredentialProvider.Read, RdCredentialProvider.Write);
      serializers.Register(RdCredentialProviderCredential.Read, RdCredentialProviderCredential.Write);
      serializers.Register(RdNuGetRemoteVersion.Read, RdNuGetRemoteVersion.Write);
      serializers.RegisterEnum<RdNuGetLogContext>();
      serializers.RegisterEnum<RdNuGetLogLevel>();
      serializers.RegisterEnum<RdNuGetNotificationStatus>();
      serializers.RegisterEnum<RdNuGetNotificationLevel>();
      serializers.RegisterEnum<RdNuGetNotificationContext>();
      serializers.Register(RdNuGetInstallRequest.Read, RdNuGetInstallRequest.Write);
      serializers.Register(RdNuGetUninstallRequest.Read, RdNuGetUninstallRequest.Write);
      serializers.Register(RdNuGetRestoreRequest.Read, RdNuGetRestoreRequest.Write);
      serializers.Register(RdNuGetFeed.Read, RdNuGetFeed.Write);
      serializers.Register(RdNuGetFeedCredentials.Read, RdNuGetFeedCredentials.Write);
      serializers.Register(RdNuGetFeedDetails.Read, RdNuGetFeedDetails.Write);
      serializers.Register(RdNuGetConfigFile.Read, RdNuGetConfigFile.Write);
      serializers.Register(RdNuGetConfigUpdateFeedArgs.Read, RdNuGetConfigUpdateFeedArgs.Write);
      serializers.Register(RdNuGetConfigDeleteFeedArgs.Read, RdNuGetConfigDeleteFeedArgs.Write);
      serializers.Register(RdNuGetConfigAddFeedArgs.Read, RdNuGetConfigAddFeedArgs.Write);
      serializers.Register(RdNuGetUltraConfig.Read, RdNuGetUltraConfig.Write);
      serializers.Register(RdNuGetFolder.Read, RdNuGetFolder.Write);
      serializers.Register(RdNuGetSetAutoClearModeArgs.Read, RdNuGetSetAutoClearModeArgs.Write);
      serializers.Register(RdCredentialProviderGetCredentialsArgs.Read, RdCredentialProviderGetCredentialsArgs.Write);
      serializers.Register(RdCredentialProviderGetCredentialsResponse.Read, RdCredentialProviderGetCredentialsResponse.Write);
      serializers.RegisterEnum<RdCredentialProviderGetCredentialStatus>();
      serializers.Register(RdNuGetRestoreConsent.Read, RdNuGetRestoreConsent.Write);
      serializers.RegisterEnum<RdNuGetFolderKind>();
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetHost (");
      using (printer.IndentCookie()) {
        printer.Print("clearCache = "); _ClearCache.PrintEx(printer); printer.Println();
        printer.Print("log = "); _Log.PrintEx(printer); printer.Println();
        printer.Print("viewModelLog = "); _ViewModelLog.PrintEx(printer); printer.Println();
        printer.Print("notify = "); _Notify.PrintEx(printer); printer.Println();
        printer.Print("nuGetOperator = "); NuGetOperator.PrintEx(printer); printer.Println();
        printer.Print("zeroLatencyUpdate = "); _ZeroLatencyUpdate.PrintEx(printer); printer.Println();
        printer.Print("zeroLatencyUpdateFinished = "); _ZeroLatencyUpdateFinished.PrintEx(printer); printer.Println();
        printer.Print("projectInfos = "); _ProjectInfos.PrintEx(printer); printer.Println();
        printer.Print("contextProjectId = "); _ContextProjectId.PrintEx(printer); printer.Println();
        printer.Print("searchTerm = "); _SearchTerm.PrintEx(printer); printer.Println();
        printer.Print("foundPackages = "); _FoundPackages.PrintEx(printer); printer.Println();
        printer.Print("targetPackageId = "); _TargetPackageId.PrintEx(printer); printer.Println();
        printer.Print("targetPackageVersion = "); _TargetPackageVersion.PrintEx(printer); printer.Println();
        printer.Print("targetPackageFeedId = "); _TargetPackageFeedId.PrintEx(printer); printer.Println();
        printer.Print("chosenPackageVersions = "); _ChosenPackageVersions.PrintEx(printer); printer.Println();
        printer.Print("chosenPackageMeta = "); _ChosenPackageMeta.PrintEx(printer); printer.Println();
        printer.Print("includePrerelease = "); _IncludePrerelease.PrintEx(printer); printer.Println();
        printer.Print("includeUnlisted = "); _IncludeUnlisted.PrintEx(printer); printer.Println();
        printer.Print("dependencyBehavior = "); _DependencyBehavior.PrintEx(printer); printer.Println();
        printer.Print("fileConflictAction = "); _FileConflictAction.PrintEx(printer); printer.Println();
        printer.Print("removeDependencies = "); _RemoveDependencies.PrintEx(printer); printer.Println();
        printer.Print("forceRemove = "); _ForceRemove.PrintEx(printer); printer.Println();
        printer.Print("versionConstraints = "); _VersionConstraints.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("globalSearchIsEnabled = "); _GlobalSearchIsEnabled.PrintEx(printer); printer.Println();
        printer.Print("configManager = "); ConfigManager.PrintEx(printer); printer.Println();
        printer.Print("status = "); _Status.PrintEx(printer); printer.Println();
        printer.Print("isLoaded = "); _IsLoaded.PrintEx(printer); printer.Println();
        printer.Print("findViaToolWindow = "); _FindViaToolWindow.PrintEx(printer); printer.Println();
        printer.Print("folderTabIsActive = "); _FolderTabIsActive.PrintEx(printer); printer.Println();
        printer.Print("folderManager = "); FolderManager.PrintEx(printer); printer.Println();
        printer.Print("stateInfo = "); StateInfo.PrintEx(printer); printer.Println();
        printer.Print("verifyPackageSpecs = "); _VerifyPackageSpecs.PrintEx(printer); printer.Println();
        printer.Print("verifyPackageSpecsFinish = "); _VerifyPackageSpecsFinish.PrintEx(printer); printer.Println();
        printer.Print("credentialProvider = "); CredentialProvider.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionRdNuGetHostEx
   {
    public static RdNuGetHost GetNuGetHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("rdNuGetHost", () => new RdNuGetHost());
    }
  }
  
  
  public class RdCredentialProvider : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdCall<RdCredentialProviderGetCredentialsArgs, RdCredentialProviderGetCredentialsResponse> GetProviderCredentials { get { return _GetProviderCredentials; }}
    
    //private fields
    [NotNull] private readonly RdCall<RdCredentialProviderGetCredentialsArgs, RdCredentialProviderGetCredentialsResponse> _GetProviderCredentials;
    
    //primary constructor
    private RdCredentialProvider(
      [NotNull] RdCall<RdCredentialProviderGetCredentialsArgs, RdCredentialProviderGetCredentialsResponse> getProviderCredentials
    )
    {
      if (getProviderCredentials == null) throw new ArgumentNullException("getProviderCredentials");
      
      _GetProviderCredentials = getProviderCredentials;
      _GetProviderCredentials.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("getProviderCredentials", _GetProviderCredentials));
    }
    //secondary constructor
    public RdCredentialProvider (
    ) : this (
      new RdCall<RdCredentialProviderGetCredentialsArgs, RdCredentialProviderGetCredentialsResponse>(RdCredentialProviderGetCredentialsArgs.Read, RdCredentialProviderGetCredentialsArgs.Write, RdCredentialProviderGetCredentialsResponse.Read, RdCredentialProviderGetCredentialsResponse.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCredentialProvider> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var getProviderCredentials = RdCall<RdCredentialProviderGetCredentialsArgs, RdCredentialProviderGetCredentialsResponse>.Read(ctx, reader, RdCredentialProviderGetCredentialsArgs.Read, RdCredentialProviderGetCredentialsArgs.Write, RdCredentialProviderGetCredentialsResponse.Read, RdCredentialProviderGetCredentialsResponse.Write);
      return new RdCredentialProvider(getProviderCredentials).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdCredentialProvider> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdCall<RdCredentialProviderGetCredentialsArgs, RdCredentialProviderGetCredentialsResponse>.Write(ctx, writer, value._GetProviderCredentials);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCredentialProvider (");
      using (printer.IndentCookie()) {
        printer.Print("getProviderCredentials = "); _GetProviderCredentials.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCredentialProviderCredential : IPrintable, IEquatable<RdCredentialProviderCredential>
  {
    //fields
    //public fields
    [NotNull] public string Username {get; private set;}
    [CanBeNull] public RdSecureString? Password {get; private set;}
    
    //private fields
    //primary constructor
    public RdCredentialProviderCredential(
      [NotNull] string username,
      [CanBeNull] RdSecureString? password
    )
    {
      if (username == null) throw new ArgumentNullException("username");
      
      Username = username;
      Password = password;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCredentialProviderCredential> Read = (ctx, reader) => 
    {
      var username = reader.ReadString();
      var password = ReadSecureStringNullable(ctx, reader);
      return new RdCredentialProviderCredential(username, password);
    };
    public static CtxReadDelegate<RdSecureString?> ReadSecureStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadSecureString.NullableStruct();
    
    public static CtxWriteDelegate<RdCredentialProviderCredential> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Username);
      WriteSecureStringNullable(ctx, writer, value.Password);
    };
    public static CtxWriteDelegate<RdSecureString?> WriteSecureStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteSecureString.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCredentialProviderCredential) obj);
    }
    public bool Equals(RdCredentialProviderCredential other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Username == other.Username && Equals(Password, other.Password);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Username.GetHashCode();
        hash = hash * 31 + (Password != null ?Password.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCredentialProviderCredential (");
      using (printer.IndentCookie()) {
        printer.Print("username = "); Username.PrintEx(printer); printer.Println();
        printer.Print("password = "); Password.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdCredentialProviderGetCredentialStatus {
    SUCCESS,
    PROVIDERNOTAPPLICABLE,
    USERCANCELED,
    ERROR
  }
  
  
  public class RdCredentialProviderGetCredentialsArgs : IPrintable, IEquatable<RdCredentialProviderGetCredentialsArgs>
  {
    //fields
    //public fields
    [NotNull] public Uri Uri {get; private set;}
    public bool IsRetry {get; private set;}
    
    //private fields
    //primary constructor
    public RdCredentialProviderGetCredentialsArgs(
      [NotNull] Uri uri,
      bool isRetry
    )
    {
      if (uri == null) throw new ArgumentNullException("uri");
      
      Uri = uri;
      IsRetry = isRetry;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCredentialProviderGetCredentialsArgs> Read = (ctx, reader) => 
    {
      var uri = reader.ReadUri();
      var isRetry = reader.ReadBool();
      return new RdCredentialProviderGetCredentialsArgs(uri, isRetry);
    };
    
    public static CtxWriteDelegate<RdCredentialProviderGetCredentialsArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Uri);
      writer.Write(value.IsRetry);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCredentialProviderGetCredentialsArgs) obj);
    }
    public bool Equals(RdCredentialProviderGetCredentialsArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Uri == other.Uri && IsRetry == other.IsRetry;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Uri.GetHashCode();
        hash = hash * 31 + IsRetry.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCredentialProviderGetCredentialsArgs (");
      using (printer.IndentCookie()) {
        printer.Print("uri = "); Uri.PrintEx(printer); printer.Println();
        printer.Print("isRetry = "); IsRetry.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCredentialProviderGetCredentialsResponse : IPrintable, IEquatable<RdCredentialProviderGetCredentialsResponse>
  {
    //fields
    //public fields
    [CanBeNull] public RdCredentialProviderCredential Credentials {get; private set;}
    public RdCredentialProviderGetCredentialStatus Status {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    
    //private fields
    //primary constructor
    public RdCredentialProviderGetCredentialsResponse(
      [CanBeNull] RdCredentialProviderCredential credentials,
      RdCredentialProviderGetCredentialStatus status,
      [CanBeNull] string message
    )
    {
      Credentials = credentials;
      Status = status;
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCredentialProviderGetCredentialsResponse> Read = (ctx, reader) => 
    {
      var credentials = ReadRdCredentialProviderCredentialNullable(ctx, reader);
      var status = (RdCredentialProviderGetCredentialStatus)reader.ReadInt();
      var message = ReadStringNullable(ctx, reader);
      return new RdCredentialProviderGetCredentialsResponse(credentials, status, message);
    };
    public static CtxReadDelegate<RdCredentialProviderCredential> ReadRdCredentialProviderCredentialNullable = RdCredentialProviderCredential.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdCredentialProviderGetCredentialsResponse> Write = (ctx, writer, value) => 
    {
      WriteRdCredentialProviderCredentialNullable(ctx, writer, value.Credentials);
      writer.Write((int)value.Status);
      WriteStringNullable(ctx, writer, value.Message);
    };
    public static CtxWriteDelegate<RdCredentialProviderCredential> WriteRdCredentialProviderCredentialNullable = RdCredentialProviderCredential.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCredentialProviderGetCredentialsResponse) obj);
    }
    public bool Equals(RdCredentialProviderGetCredentialsResponse other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Credentials, other.Credentials) && Status == other.Status && Equals(Message, other.Message);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Credentials != null ?Credentials.GetHashCode() : 0);
        hash = hash * 31 + (int) Status;
        hash = hash * 31 + (Message != null ?Message.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCredentialProviderGetCredentialsResponse (");
      using (printer.IndentCookie()) {
        printer.Print("credentials = "); Credentials.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetConfigAddFeedArgs : IPrintable, IEquatable<RdNuGetConfigAddFeedArgs>
  {
    //fields
    //public fields
    [CanBeNull] public string ConfigFilePath {get; private set;}
    [NotNull] public RdNuGetFeedDetails NewValue {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetConfigAddFeedArgs(
      [CanBeNull] string configFilePath,
      [NotNull] RdNuGetFeedDetails newValue
    )
    {
      if (newValue == null) throw new ArgumentNullException("newValue");
      
      ConfigFilePath = configFilePath;
      NewValue = newValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetConfigAddFeedArgs> Read = (ctx, reader) => 
    {
      var configFilePath = ReadStringNullable(ctx, reader);
      var newValue = RdNuGetFeedDetails.Read(ctx, reader);
      return new RdNuGetConfigAddFeedArgs(configFilePath, newValue);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdNuGetConfigAddFeedArgs> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.ConfigFilePath);
      RdNuGetFeedDetails.Write(ctx, writer, value.NewValue);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetConfigAddFeedArgs) obj);
    }
    public bool Equals(RdNuGetConfigAddFeedArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ConfigFilePath, other.ConfigFilePath) && Equals(NewValue, other.NewValue);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (ConfigFilePath != null ?ConfigFilePath.GetHashCode() : 0);
        hash = hash * 31 + NewValue.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetConfigAddFeedArgs (");
      using (printer.IndentCookie()) {
        printer.Print("configFilePath = "); ConfigFilePath.PrintEx(printer); printer.Println();
        printer.Print("newValue = "); NewValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetConfigDeleteFeedArgs : IPrintable, IEquatable<RdNuGetConfigDeleteFeedArgs>
  {
    //fields
    //public fields
    [NotNull] public string Origin {get; private set;}
    [NotNull] public RdNuGetFeedDetails OldValue {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetConfigDeleteFeedArgs(
      [NotNull] string origin,
      [NotNull] RdNuGetFeedDetails oldValue
    )
    {
      if (origin == null) throw new ArgumentNullException("origin");
      if (oldValue == null) throw new ArgumentNullException("oldValue");
      
      Origin = origin;
      OldValue = oldValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetConfigDeleteFeedArgs> Read = (ctx, reader) => 
    {
      var origin = reader.ReadString();
      var oldValue = RdNuGetFeedDetails.Read(ctx, reader);
      return new RdNuGetConfigDeleteFeedArgs(origin, oldValue);
    };
    
    public static CtxWriteDelegate<RdNuGetConfigDeleteFeedArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Origin);
      RdNuGetFeedDetails.Write(ctx, writer, value.OldValue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetConfigDeleteFeedArgs) obj);
    }
    public bool Equals(RdNuGetConfigDeleteFeedArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Origin == other.Origin && Equals(OldValue, other.OldValue);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Origin.GetHashCode();
        hash = hash * 31 + OldValue.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetConfigDeleteFeedArgs (");
      using (printer.IndentCookie()) {
        printer.Print("origin = "); Origin.PrintEx(printer); printer.Println();
        printer.Print("oldValue = "); OldValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetConfigFile : RdBindableBase
  {
    //fields
    //public fields
    [CanBeNull] public string ConfigFilePath {get; private set;}
    [NotNull] public string DisplayName {get; private set;}
    [NotNull] public string DetailedInfoHeader {get; private set;}
    [NotNull] public RdNuGetRestoreConsent RestoreConsent {get; private set;}
    [NotNull] public List<RdNuGetFeedDetails> Feeds {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetConfigFile(
      [CanBeNull] string configFilePath,
      [NotNull] string displayName,
      [NotNull] string detailedInfoHeader,
      [NotNull] RdNuGetRestoreConsent restoreConsent,
      [NotNull] List<RdNuGetFeedDetails> feeds
    )
    {
      if (displayName == null) throw new ArgumentNullException("displayName");
      if (detailedInfoHeader == null) throw new ArgumentNullException("detailedInfoHeader");
      if (restoreConsent == null) throw new ArgumentNullException("restoreConsent");
      if (feeds == null) throw new ArgumentNullException("feeds");
      
      ConfigFilePath = configFilePath;
      DisplayName = displayName;
      DetailedInfoHeader = detailedInfoHeader;
      RestoreConsent = restoreConsent;
      Feeds = feeds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetConfigFile> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var configFilePath = ReadStringNullable(ctx, reader);
      var displayName = reader.ReadString();
      var detailedInfoHeader = reader.ReadString();
      var restoreConsent = RdNuGetRestoreConsent.Read(ctx, reader);
      var feeds = ReadRdNuGetFeedDetailsList(ctx, reader);
      return new RdNuGetConfigFile(configFilePath, displayName, detailedInfoHeader, restoreConsent, feeds).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdNuGetFeedDetails>> ReadRdNuGetFeedDetailsList = RdNuGetFeedDetails.Read.List();
    
    public static CtxWriteDelegate<RdNuGetConfigFile> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.ConfigFilePath);
      writer.Write(value.DisplayName);
      writer.Write(value.DetailedInfoHeader);
      RdNuGetRestoreConsent.Write(ctx, writer, value.RestoreConsent);
      WriteRdNuGetFeedDetailsList(ctx, writer, value.Feeds);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdNuGetFeedDetails>> WriteRdNuGetFeedDetailsList = RdNuGetFeedDetails.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetConfigFile (");
      using (printer.IndentCookie()) {
        printer.Print("configFilePath = "); ConfigFilePath.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("detailedInfoHeader = "); DetailedInfoHeader.PrintEx(printer); printer.Println();
        printer.Print("restoreConsent = "); RestoreConsent.PrintEx(printer); printer.Println();
        printer.Print("feeds = "); Feeds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetConfigManager : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public ISink<RdVoid> Reload { get { return _Reload; }}
    [NotNull] public IRdProperty<string> DetailedInfo { get { return _DetailedInfo; }}
    [NotNull] public IRdProperty<List<RdNuGetFeed>> KnownFeeds { get { return _KnownFeeds; }}
    [NotNull] public IViewableMap<string, RdNuGetFeedCredentials> FeedCredentials { get { return _FeedCredentials; }}
    [NotNull] public IRdProperty<List<RdNuGetConfigFile>> ConfigFiles { get { return _ConfigFiles; }}
    [NotNull] public ISink<RdNuGetConfigUpdateFeedArgs> UpdateFeed { get { return _UpdateFeed; }}
    [NotNull] public ISink<RdNuGetConfigDeleteFeedArgs> DeleteFeed { get { return _DeleteFeed; }}
    [NotNull] public ISink<RdNuGetConfigAddFeedArgs> AddFeed { get { return _AddFeed; }}
    [NotNull] public IRdProperty<RdNuGetUltraConfig> UltraConfig { get { return _UltraConfig; }}
    [NotNull] public IRdProperty<List<string>> SelectedFeeds { get { return _SelectedFeeds; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Reload;
    [NotNull] private readonly RdProperty<string> _DetailedInfo;
    [NotNull] private readonly RdProperty<List<RdNuGetFeed>> _KnownFeeds;
    [NotNull] private readonly RdMap<string, RdNuGetFeedCredentials> _FeedCredentials;
    [NotNull] private readonly RdProperty<List<RdNuGetConfigFile>> _ConfigFiles;
    [NotNull] private readonly RdSignal<RdNuGetConfigUpdateFeedArgs> _UpdateFeed;
    [NotNull] private readonly RdSignal<RdNuGetConfigDeleteFeedArgs> _DeleteFeed;
    [NotNull] private readonly RdSignal<RdNuGetConfigAddFeedArgs> _AddFeed;
    [NotNull] private readonly RdProperty<RdNuGetUltraConfig> _UltraConfig;
    [NotNull] private readonly RdProperty<List<string>> _SelectedFeeds;
    
    //primary constructor
    private RdNuGetConfigManager(
      [NotNull] RdSignal<RdVoid> reload,
      [NotNull] RdProperty<string> detailedInfo,
      [NotNull] RdProperty<List<RdNuGetFeed>> knownFeeds,
      [NotNull] RdMap<string, RdNuGetFeedCredentials> feedCredentials,
      [NotNull] RdProperty<List<RdNuGetConfigFile>> configFiles,
      [NotNull] RdSignal<RdNuGetConfigUpdateFeedArgs> updateFeed,
      [NotNull] RdSignal<RdNuGetConfigDeleteFeedArgs> deleteFeed,
      [NotNull] RdSignal<RdNuGetConfigAddFeedArgs> addFeed,
      [NotNull] RdProperty<RdNuGetUltraConfig> ultraConfig,
      [NotNull] RdProperty<List<string>> selectedFeeds
    )
    {
      if (reload == null) throw new ArgumentNullException("reload");
      if (detailedInfo == null) throw new ArgumentNullException("detailedInfo");
      if (knownFeeds == null) throw new ArgumentNullException("knownFeeds");
      if (feedCredentials == null) throw new ArgumentNullException("feedCredentials");
      if (configFiles == null) throw new ArgumentNullException("configFiles");
      if (updateFeed == null) throw new ArgumentNullException("updateFeed");
      if (deleteFeed == null) throw new ArgumentNullException("deleteFeed");
      if (addFeed == null) throw new ArgumentNullException("addFeed");
      if (ultraConfig == null) throw new ArgumentNullException("ultraConfig");
      if (selectedFeeds == null) throw new ArgumentNullException("selectedFeeds");
      
      _Reload = reload;
      _DetailedInfo = detailedInfo;
      _KnownFeeds = knownFeeds;
      _FeedCredentials = feedCredentials;
      _ConfigFiles = configFiles;
      _UpdateFeed = updateFeed;
      _DeleteFeed = deleteFeed;
      _AddFeed = addFeed;
      _UltraConfig = ultraConfig;
      _SelectedFeeds = selectedFeeds;
      _DetailedInfo.OptimizeNested = true;
      _KnownFeeds.OptimizeNested = true;
      _FeedCredentials.OptimizeNested = true;
      _SelectedFeeds.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("reload", _Reload));
      BindableChildren.Add(new KeyValuePair<string, object>("detailedInfo", _DetailedInfo));
      BindableChildren.Add(new KeyValuePair<string, object>("knownFeeds", _KnownFeeds));
      BindableChildren.Add(new KeyValuePair<string, object>("feedCredentials", _FeedCredentials));
      BindableChildren.Add(new KeyValuePair<string, object>("configFiles", _ConfigFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("updateFeed", _UpdateFeed));
      BindableChildren.Add(new KeyValuePair<string, object>("deleteFeed", _DeleteFeed));
      BindableChildren.Add(new KeyValuePair<string, object>("addFeed", _AddFeed));
      BindableChildren.Add(new KeyValuePair<string, object>("ultraConfig", _UltraConfig));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedFeeds", _SelectedFeeds));
    }
    //secondary constructor
    public RdNuGetConfigManager (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<List<RdNuGetFeed>>(ReadRdNuGetFeedList, WriteRdNuGetFeedList),
      new RdMap<string, RdNuGetFeedCredentials>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, RdNuGetFeedCredentials.Read, RdNuGetFeedCredentials.Write),
      new RdProperty<List<RdNuGetConfigFile>>(ReadRdNuGetConfigFileList, WriteRdNuGetConfigFileList),
      new RdSignal<RdNuGetConfigUpdateFeedArgs>(RdNuGetConfigUpdateFeedArgs.Read, RdNuGetConfigUpdateFeedArgs.Write),
      new RdSignal<RdNuGetConfigDeleteFeedArgs>(RdNuGetConfigDeleteFeedArgs.Read, RdNuGetConfigDeleteFeedArgs.Write),
      new RdSignal<RdNuGetConfigAddFeedArgs>(RdNuGetConfigAddFeedArgs.Read, RdNuGetConfigAddFeedArgs.Write),
      new RdProperty<RdNuGetUltraConfig>(RdNuGetUltraConfig.Read, RdNuGetUltraConfig.Write),
      new RdProperty<List<string>>(ReadStringList, WriteStringList)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetConfigManager> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var reload = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var detailedInfo = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var knownFeeds = RdProperty<List<RdNuGetFeed>>.Read(ctx, reader, ReadRdNuGetFeedList, WriteRdNuGetFeedList);
      var feedCredentials = RdMap<string, RdNuGetFeedCredentials>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, RdNuGetFeedCredentials.Read, RdNuGetFeedCredentials.Write);
      var configFiles = RdProperty<List<RdNuGetConfigFile>>.Read(ctx, reader, ReadRdNuGetConfigFileList, WriteRdNuGetConfigFileList);
      var updateFeed = RdSignal<RdNuGetConfigUpdateFeedArgs>.Read(ctx, reader, RdNuGetConfigUpdateFeedArgs.Read, RdNuGetConfigUpdateFeedArgs.Write);
      var deleteFeed = RdSignal<RdNuGetConfigDeleteFeedArgs>.Read(ctx, reader, RdNuGetConfigDeleteFeedArgs.Read, RdNuGetConfigDeleteFeedArgs.Write);
      var addFeed = RdSignal<RdNuGetConfigAddFeedArgs>.Read(ctx, reader, RdNuGetConfigAddFeedArgs.Read, RdNuGetConfigAddFeedArgs.Write);
      var ultraConfig = RdProperty<RdNuGetUltraConfig>.Read(ctx, reader, RdNuGetUltraConfig.Read, RdNuGetUltraConfig.Write);
      var selectedFeeds = RdProperty<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      return new RdNuGetConfigManager(reload, detailedInfo, knownFeeds, feedCredentials, configFiles, updateFeed, deleteFeed, addFeed, ultraConfig, selectedFeeds).WithId(_id);
    };
    public static CtxReadDelegate<List<RdNuGetFeed>> ReadRdNuGetFeedList = RdNuGetFeed.Read.List();
    public static CtxReadDelegate<List<RdNuGetConfigFile>> ReadRdNuGetConfigFileList = RdNuGetConfigFile.Read.List();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdNuGetConfigManager> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._Reload);
      RdProperty<string>.Write(ctx, writer, value._DetailedInfo);
      RdProperty<List<RdNuGetFeed>>.Write(ctx, writer, value._KnownFeeds);
      RdMap<string, RdNuGetFeedCredentials>.Write(ctx, writer, value._FeedCredentials);
      RdProperty<List<RdNuGetConfigFile>>.Write(ctx, writer, value._ConfigFiles);
      RdSignal<RdNuGetConfigUpdateFeedArgs>.Write(ctx, writer, value._UpdateFeed);
      RdSignal<RdNuGetConfigDeleteFeedArgs>.Write(ctx, writer, value._DeleteFeed);
      RdSignal<RdNuGetConfigAddFeedArgs>.Write(ctx, writer, value._AddFeed);
      RdProperty<RdNuGetUltraConfig>.Write(ctx, writer, value._UltraConfig);
      RdProperty<List<string>>.Write(ctx, writer, value._SelectedFeeds);
    };
    public static CtxWriteDelegate<List<RdNuGetFeed>> WriteRdNuGetFeedList = RdNuGetFeed.Write.List();
    public static CtxWriteDelegate<List<RdNuGetConfigFile>> WriteRdNuGetConfigFileList = RdNuGetConfigFile.Write.List();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetConfigManager (");
      using (printer.IndentCookie()) {
        printer.Print("reload = "); _Reload.PrintEx(printer); printer.Println();
        printer.Print("detailedInfo = "); _DetailedInfo.PrintEx(printer); printer.Println();
        printer.Print("knownFeeds = "); _KnownFeeds.PrintEx(printer); printer.Println();
        printer.Print("feedCredentials = "); _FeedCredentials.PrintEx(printer); printer.Println();
        printer.Print("configFiles = "); _ConfigFiles.PrintEx(printer); printer.Println();
        printer.Print("updateFeed = "); _UpdateFeed.PrintEx(printer); printer.Println();
        printer.Print("deleteFeed = "); _DeleteFeed.PrintEx(printer); printer.Println();
        printer.Print("addFeed = "); _AddFeed.PrintEx(printer); printer.Println();
        printer.Print("ultraConfig = "); _UltraConfig.PrintEx(printer); printer.Println();
        printer.Print("selectedFeeds = "); _SelectedFeeds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetConfigUpdateFeedArgs : IPrintable, IEquatable<RdNuGetConfigUpdateFeedArgs>
  {
    //fields
    //public fields
    [NotNull] public string Origin {get; private set;}
    [NotNull] public RdNuGetFeedDetails OldValue {get; private set;}
    [NotNull] public RdNuGetFeedDetails NewValue {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetConfigUpdateFeedArgs(
      [NotNull] string origin,
      [NotNull] RdNuGetFeedDetails oldValue,
      [NotNull] RdNuGetFeedDetails newValue
    )
    {
      if (origin == null) throw new ArgumentNullException("origin");
      if (oldValue == null) throw new ArgumentNullException("oldValue");
      if (newValue == null) throw new ArgumentNullException("newValue");
      
      Origin = origin;
      OldValue = oldValue;
      NewValue = newValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetConfigUpdateFeedArgs> Read = (ctx, reader) => 
    {
      var origin = reader.ReadString();
      var oldValue = RdNuGetFeedDetails.Read(ctx, reader);
      var newValue = RdNuGetFeedDetails.Read(ctx, reader);
      return new RdNuGetConfigUpdateFeedArgs(origin, oldValue, newValue);
    };
    
    public static CtxWriteDelegate<RdNuGetConfigUpdateFeedArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Origin);
      RdNuGetFeedDetails.Write(ctx, writer, value.OldValue);
      RdNuGetFeedDetails.Write(ctx, writer, value.NewValue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetConfigUpdateFeedArgs) obj);
    }
    public bool Equals(RdNuGetConfigUpdateFeedArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Origin == other.Origin && Equals(OldValue, other.OldValue) && Equals(NewValue, other.NewValue);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Origin.GetHashCode();
        hash = hash * 31 + OldValue.GetHashCode();
        hash = hash * 31 + NewValue.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetConfigUpdateFeedArgs (");
      using (printer.IndentCookie()) {
        printer.Print("origin = "); Origin.PrintEx(printer); printer.Println();
        printer.Print("oldValue = "); OldValue.PrintEx(printer); printer.Println();
        printer.Print("newValue = "); NewValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetDependencyBehavior {
    Ignore,
    Lowest,
    HighestPatch,
    HighestMinor,
    Highest
  }
  
  
  public class RdNuGetFeed : IPrintable, IEquatable<RdNuGetFeed>
  {
    //fields
    //public fields
    [NotNull] public string FeedId {get; private set;}
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Url {get; private set;}
    [NotNull] public string Alias {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetFeed(
      [NotNull] string feedId,
      [NotNull] string name,
      [NotNull] string url,
      [NotNull] string alias
    )
    {
      if (feedId == null) throw new ArgumentNullException("feedId");
      if (name == null) throw new ArgumentNullException("name");
      if (url == null) throw new ArgumentNullException("url");
      if (alias == null) throw new ArgumentNullException("alias");
      
      FeedId = feedId;
      Name = name;
      Url = url;
      Alias = alias;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetFeed> Read = (ctx, reader) => 
    {
      var feedId = reader.ReadString();
      var name = reader.ReadString();
      var url = reader.ReadString();
      var alias = reader.ReadString();
      return new RdNuGetFeed(feedId, name, url, alias);
    };
    
    public static CtxWriteDelegate<RdNuGetFeed> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FeedId);
      writer.Write(value.Name);
      writer.Write(value.Url);
      writer.Write(value.Alias);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetFeed) obj);
    }
    public bool Equals(RdNuGetFeed other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FeedId == other.FeedId && Name == other.Name && Url == other.Url && Alias == other.Alias;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FeedId.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Url.GetHashCode();
        hash = hash * 31 + Alias.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFeed (");
      using (printer.IndentCookie()) {
        printer.Print("feedId = "); FeedId.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("url = "); Url.PrintEx(printer); printer.Println();
        printer.Print("alias = "); Alias.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetFeedCredentials : IPrintable, IEquatable<RdNuGetFeedCredentials>
  {
    //fields
    //public fields
    [NotNull] public string User {get; private set;}
    public RdSecureString Password {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetFeedCredentials(
      [NotNull] string user,
      RdSecureString password
    )
    {
      if (user == null) throw new ArgumentNullException("user");
      
      User = user;
      Password = password;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetFeedCredentials> Read = (ctx, reader) => 
    {
      var user = reader.ReadString();
      var password = reader.ReadSecureString();
      return new RdNuGetFeedCredentials(user, password);
    };
    
    public static CtxWriteDelegate<RdNuGetFeedCredentials> Write = (ctx, writer, value) => 
    {
      writer.Write(value.User);
      writer.Write(value.Password);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetFeedCredentials) obj);
    }
    public bool Equals(RdNuGetFeedCredentials other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return User == other.User && Password == other.Password;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + User.GetHashCode();
        hash = hash * 31 + Password.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFeedCredentials (");
      using (printer.IndentCookie()) {
        printer.Print("user = "); User.PrintEx(printer); printer.Println();
        printer.Print("password = "); Password.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetFeedDetails : IPrintable, IEquatable<RdNuGetFeedDetails>
  {
    //fields
    //public fields
    public bool IsEnabled {get; private set;}
    [NotNull] public string DisplayName {get; private set;}
    [CanBeNull] public string Description {get; private set;}
    [NotNull] public string Url {get; private set;}
    [NotNull] public string DetailedInfo {get; private set;}
    [CanBeNull] public string Origin {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetFeedDetails(
      bool isEnabled,
      [NotNull] string displayName,
      [CanBeNull] string description,
      [NotNull] string url,
      [NotNull] string detailedInfo,
      [CanBeNull] string origin
    )
    {
      if (displayName == null) throw new ArgumentNullException("displayName");
      if (url == null) throw new ArgumentNullException("url");
      if (detailedInfo == null) throw new ArgumentNullException("detailedInfo");
      
      IsEnabled = isEnabled;
      DisplayName = displayName;
      Description = description;
      Url = url;
      DetailedInfo = detailedInfo;
      Origin = origin;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetFeedDetails> Read = (ctx, reader) => 
    {
      var isEnabled = reader.ReadBool();
      var displayName = reader.ReadString();
      var description = ReadStringNullable(ctx, reader);
      var url = reader.ReadString();
      var detailedInfo = reader.ReadString();
      var origin = ReadStringNullable(ctx, reader);
      return new RdNuGetFeedDetails(isEnabled, displayName, description, url, detailedInfo, origin);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdNuGetFeedDetails> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsEnabled);
      writer.Write(value.DisplayName);
      WriteStringNullable(ctx, writer, value.Description);
      writer.Write(value.Url);
      writer.Write(value.DetailedInfo);
      WriteStringNullable(ctx, writer, value.Origin);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetFeedDetails) obj);
    }
    public bool Equals(RdNuGetFeedDetails other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsEnabled == other.IsEnabled && DisplayName == other.DisplayName && Equals(Description, other.Description) && Url == other.Url && DetailedInfo == other.DetailedInfo && Equals(Origin, other.Origin);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsEnabled.GetHashCode();
        hash = hash * 31 + DisplayName.GetHashCode();
        hash = hash * 31 + (Description != null ?Description.GetHashCode() : 0);
        hash = hash * 31 + Url.GetHashCode();
        hash = hash * 31 + DetailedInfo.GetHashCode();
        hash = hash * 31 + (Origin != null ?Origin.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFeedDetails (");
      using (printer.IndentCookie()) {
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("url = "); Url.PrintEx(printer); printer.Println();
        printer.Print("detailedInfo = "); DetailedInfo.PrintEx(printer); printer.Println();
        printer.Print("origin = "); Origin.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetFileConflictAction {
    Prompt,
    IgnoreAll,
    OverwriteAll
  }
  
  
  public class RdNuGetFindViaToolWindowArgs : IPrintable, IEquatable<RdNuGetFindViaToolWindowArgs>
  {
    //fields
    //public fields
    public int ProjectId {get; private set;}
    [NotNull] public string SearchTerm {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetFindViaToolWindowArgs(
      int projectId,
      [NotNull] string searchTerm
    )
    {
      if (searchTerm == null) throw new ArgumentNullException("searchTerm");
      
      ProjectId = projectId;
      SearchTerm = searchTerm;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetFindViaToolWindowArgs> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      var searchTerm = reader.ReadString();
      return new RdNuGetFindViaToolWindowArgs(projectId, searchTerm);
    };
    
    public static CtxWriteDelegate<RdNuGetFindViaToolWindowArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
      writer.Write(value.SearchTerm);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetFindViaToolWindowArgs) obj);
    }
    public bool Equals(RdNuGetFindViaToolWindowArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectId == other.ProjectId && SearchTerm == other.SearchTerm;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + SearchTerm.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFindViaToolWindowArgs (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("searchTerm = "); SearchTerm.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetFolder : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    public RdNuGetFolderKind Kind {get; private set;}
    [NotNull] public string Path {get; private set;}
    public long Size {get; private set;}
    public bool AutoClearMode {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetFolder(
      [NotNull] string title,
      RdNuGetFolderKind kind,
      [NotNull] string path,
      long size,
      bool autoClearMode
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (path == null) throw new ArgumentNullException("path");
      
      Title = title;
      Kind = kind;
      Path = path;
      Size = size;
      AutoClearMode = autoClearMode;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetFolder> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var kind = (RdNuGetFolderKind)reader.ReadInt();
      var path = reader.ReadString();
      var size = reader.ReadLong();
      var autoClearMode = reader.ReadBool();
      return new RdNuGetFolder(title, kind, path, size, autoClearMode).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdNuGetFolder> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write((int)value.Kind);
      writer.Write(value.Path);
      writer.Write(value.Size);
      writer.Write(value.AutoClearMode);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFolder (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
        printer.Print("autoClearMode = "); AutoClearMode.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetFolderKind {
    LocalPackages,
    GlobalPackages,
    HttpCache,
    PackageCache,
    Temp,
    MachineSettingsBaseDir,
    MachineConfigDir,
    UserSettings,
    NuGetHome,
    FallbackFolder
  }
  
  
  public class RdNuGetFolderManager : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<RdNuGetFolder>> Folders { get { return _Folders; }}
    [NotNull] public ISink<RdNuGetSetAutoClearModeArgs> SetAutoClearMode { get { return _SetAutoClearMode; }}
    [NotNull] public ISink<RdVoid> Recalculate { get { return _Recalculate; }}
    [NotNull] public ISink<List<string>> ForceClear { get { return _ForceClear; }}
    [NotNull] public ISink<RdVoid> GenerateReport { get { return _GenerateReport; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<RdNuGetFolder>> _Folders;
    [NotNull] private readonly RdSignal<RdNuGetSetAutoClearModeArgs> _SetAutoClearMode;
    [NotNull] private readonly RdSignal<RdVoid> _Recalculate;
    [NotNull] private readonly RdSignal<List<string>> _ForceClear;
    [NotNull] private readonly RdSignal<RdVoid> _GenerateReport;
    
    //primary constructor
    private RdNuGetFolderManager(
      [NotNull] RdProperty<List<RdNuGetFolder>> folders,
      [NotNull] RdSignal<RdNuGetSetAutoClearModeArgs> setAutoClearMode,
      [NotNull] RdSignal<RdVoid> recalculate,
      [NotNull] RdSignal<List<string>> forceClear,
      [NotNull] RdSignal<RdVoid> generateReport
    )
    {
      if (folders == null) throw new ArgumentNullException("folders");
      if (setAutoClearMode == null) throw new ArgumentNullException("setAutoClearMode");
      if (recalculate == null) throw new ArgumentNullException("recalculate");
      if (forceClear == null) throw new ArgumentNullException("forceClear");
      if (generateReport == null) throw new ArgumentNullException("generateReport");
      
      _Folders = folders;
      _SetAutoClearMode = setAutoClearMode;
      _Recalculate = recalculate;
      _ForceClear = forceClear;
      _GenerateReport = generateReport;
      BindableChildren.Add(new KeyValuePair<string, object>("folders", _Folders));
      BindableChildren.Add(new KeyValuePair<string, object>("setAutoClearMode", _SetAutoClearMode));
      BindableChildren.Add(new KeyValuePair<string, object>("recalculate", _Recalculate));
      BindableChildren.Add(new KeyValuePair<string, object>("forceClear", _ForceClear));
      BindableChildren.Add(new KeyValuePair<string, object>("generateReport", _GenerateReport));
    }
    //secondary constructor
    public RdNuGetFolderManager (
    ) : this (
      new RdProperty<List<RdNuGetFolder>>(ReadRdNuGetFolderList, WriteRdNuGetFolderList),
      new RdSignal<RdNuGetSetAutoClearModeArgs>(RdNuGetSetAutoClearModeArgs.Read, RdNuGetSetAutoClearModeArgs.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<List<string>>(ReadStringList, WriteStringList),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetFolderManager> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var folders = RdProperty<List<RdNuGetFolder>>.Read(ctx, reader, ReadRdNuGetFolderList, WriteRdNuGetFolderList);
      var setAutoClearMode = RdSignal<RdNuGetSetAutoClearModeArgs>.Read(ctx, reader, RdNuGetSetAutoClearModeArgs.Read, RdNuGetSetAutoClearModeArgs.Write);
      var recalculate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var forceClear = RdSignal<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      var generateReport = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdNuGetFolderManager(folders, setAutoClearMode, recalculate, forceClear, generateReport).WithId(_id);
    };
    public static CtxReadDelegate<List<RdNuGetFolder>> ReadRdNuGetFolderList = RdNuGetFolder.Read.List();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdNuGetFolderManager> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<List<RdNuGetFolder>>.Write(ctx, writer, value._Folders);
      RdSignal<RdNuGetSetAutoClearModeArgs>.Write(ctx, writer, value._SetAutoClearMode);
      RdSignal<RdVoid>.Write(ctx, writer, value._Recalculate);
      RdSignal<List<string>>.Write(ctx, writer, value._ForceClear);
      RdSignal<RdVoid>.Write(ctx, writer, value._GenerateReport);
    };
    public static CtxWriteDelegate<List<RdNuGetFolder>> WriteRdNuGetFolderList = RdNuGetFolder.Write.List();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFolderManager (");
      using (printer.IndentCookie()) {
        printer.Print("folders = "); _Folders.PrintEx(printer); printer.Println();
        printer.Print("setAutoClearMode = "); _SetAutoClearMode.PrintEx(printer); printer.Println();
        printer.Print("recalculate = "); _Recalculate.PrintEx(printer); printer.Println();
        printer.Print("forceClear = "); _ForceClear.PrintEx(printer); printer.Println();
        printer.Print("generateReport = "); _GenerateReport.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetFramework : IPrintable, IEquatable<RdNuGetFramework>
  {
    //fields
    //public fields
    [NotNull] public string Framework {get; private set;}
    [NotNull] public string Version {get; private set;}
    public bool HasProfile {get; private set;}
    [NotNull] public string Profile {get; private set;}
    [NotNull] public string DotNetFrameworkName {get; private set;}
    public bool IsPcl {get; private set;}
    public bool IsPackageBased {get; private set;}
    public bool AllFrameworkVersions {get; private set;}
    public bool IsUnsupported {get; private set;}
    public bool IsAgnostic {get; private set;}
    public bool IsAny {get; private set;}
    public bool IsSpecificFramework {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetFramework(
      [NotNull] string framework,
      [NotNull] string version,
      bool hasProfile,
      [NotNull] string profile,
      [NotNull] string dotNetFrameworkName,
      bool isPcl,
      bool isPackageBased,
      bool allFrameworkVersions,
      bool isUnsupported,
      bool isAgnostic,
      bool isAny,
      bool isSpecificFramework
    )
    {
      if (framework == null) throw new ArgumentNullException("framework");
      if (version == null) throw new ArgumentNullException("version");
      if (profile == null) throw new ArgumentNullException("profile");
      if (dotNetFrameworkName == null) throw new ArgumentNullException("dotNetFrameworkName");
      
      Framework = framework;
      Version = version;
      HasProfile = hasProfile;
      Profile = profile;
      DotNetFrameworkName = dotNetFrameworkName;
      IsPcl = isPcl;
      IsPackageBased = isPackageBased;
      AllFrameworkVersions = allFrameworkVersions;
      IsUnsupported = isUnsupported;
      IsAgnostic = isAgnostic;
      IsAny = isAny;
      IsSpecificFramework = isSpecificFramework;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetFramework> Read = (ctx, reader) => 
    {
      var framework = reader.ReadString();
      var version = reader.ReadString();
      var hasProfile = reader.ReadBool();
      var profile = reader.ReadString();
      var dotNetFrameworkName = reader.ReadString();
      var isPcl = reader.ReadBool();
      var isPackageBased = reader.ReadBool();
      var allFrameworkVersions = reader.ReadBool();
      var isUnsupported = reader.ReadBool();
      var isAgnostic = reader.ReadBool();
      var isAny = reader.ReadBool();
      var isSpecificFramework = reader.ReadBool();
      return new RdNuGetFramework(framework, version, hasProfile, profile, dotNetFrameworkName, isPcl, isPackageBased, allFrameworkVersions, isUnsupported, isAgnostic, isAny, isSpecificFramework);
    };
    
    public static CtxWriteDelegate<RdNuGetFramework> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Framework);
      writer.Write(value.Version);
      writer.Write(value.HasProfile);
      writer.Write(value.Profile);
      writer.Write(value.DotNetFrameworkName);
      writer.Write(value.IsPcl);
      writer.Write(value.IsPackageBased);
      writer.Write(value.AllFrameworkVersions);
      writer.Write(value.IsUnsupported);
      writer.Write(value.IsAgnostic);
      writer.Write(value.IsAny);
      writer.Write(value.IsSpecificFramework);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetFramework) obj);
    }
    public bool Equals(RdNuGetFramework other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Framework == other.Framework && Version == other.Version && HasProfile == other.HasProfile && Profile == other.Profile && DotNetFrameworkName == other.DotNetFrameworkName && IsPcl == other.IsPcl && IsPackageBased == other.IsPackageBased && AllFrameworkVersions == other.AllFrameworkVersions && IsUnsupported == other.IsUnsupported && IsAgnostic == other.IsAgnostic && IsAny == other.IsAny && IsSpecificFramework == other.IsSpecificFramework;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Framework.GetHashCode();
        hash = hash * 31 + Version.GetHashCode();
        hash = hash * 31 + HasProfile.GetHashCode();
        hash = hash * 31 + Profile.GetHashCode();
        hash = hash * 31 + DotNetFrameworkName.GetHashCode();
        hash = hash * 31 + IsPcl.GetHashCode();
        hash = hash * 31 + IsPackageBased.GetHashCode();
        hash = hash * 31 + AllFrameworkVersions.GetHashCode();
        hash = hash * 31 + IsUnsupported.GetHashCode();
        hash = hash * 31 + IsAgnostic.GetHashCode();
        hash = hash * 31 + IsAny.GetHashCode();
        hash = hash * 31 + IsSpecificFramework.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFramework (");
      using (printer.IndentCookie()) {
        printer.Print("framework = "); Framework.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
        printer.Print("hasProfile = "); HasProfile.PrintEx(printer); printer.Println();
        printer.Print("profile = "); Profile.PrintEx(printer); printer.Println();
        printer.Print("dotNetFrameworkName = "); DotNetFrameworkName.PrintEx(printer); printer.Println();
        printer.Print("isPcl = "); IsPcl.PrintEx(printer); printer.Println();
        printer.Print("isPackageBased = "); IsPackageBased.PrintEx(printer); printer.Println();
        printer.Print("allFrameworkVersions = "); AllFrameworkVersions.PrintEx(printer); printer.Println();
        printer.Print("isUnsupported = "); IsUnsupported.PrintEx(printer); printer.Println();
        printer.Print("isAgnostic = "); IsAgnostic.PrintEx(printer); printer.Println();
        printer.Print("isAny = "); IsAny.PrintEx(printer); printer.Println();
        printer.Print("isSpecificFramework = "); IsSpecificFramework.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetInstallOneRequest : IPrintable, IEquatable<RdNuGetInstallOneRequest>
  {
    //fields
    //public fields
    public int ProjectId {get; private set;}
    [NotNull] public string PackageId {get; private set;}
    [NotNull] public string PackageVersion {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetInstallOneRequest(
      int projectId,
      [NotNull] string packageId,
      [NotNull] string packageVersion
    )
    {
      if (packageId == null) throw new ArgumentNullException("packageId");
      if (packageVersion == null) throw new ArgumentNullException("packageVersion");
      
      ProjectId = projectId;
      PackageId = packageId;
      PackageVersion = packageVersion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetInstallOneRequest> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      var packageId = reader.ReadString();
      var packageVersion = reader.ReadString();
      return new RdNuGetInstallOneRequest(projectId, packageId, packageVersion);
    };
    
    public static CtxWriteDelegate<RdNuGetInstallOneRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
      writer.Write(value.PackageId);
      writer.Write(value.PackageVersion);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetInstallOneRequest) obj);
    }
    public bool Equals(RdNuGetInstallOneRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectId == other.ProjectId && PackageId == other.PackageId && PackageVersion == other.PackageVersion;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + PackageId.GetHashCode();
        hash = hash * 31 + PackageVersion.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetInstallOneRequest (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("packageId = "); PackageId.PrintEx(printer); printer.Println();
        printer.Print("packageVersion = "); PackageVersion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetInstallRequest : IPrintable, IEquatable<RdNuGetInstallRequest>
  {
    //fields
    //public fields
    [NotNull] public List<RdNuGetInstallOneRequest> SubRequests {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetInstallRequest(
      [NotNull] List<RdNuGetInstallOneRequest> subRequests
    )
    {
      if (subRequests == null) throw new ArgumentNullException("subRequests");
      
      SubRequests = subRequests;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetInstallRequest> Read = (ctx, reader) => 
    {
      var subRequests = ReadRdNuGetInstallOneRequestList(ctx, reader);
      return new RdNuGetInstallRequest(subRequests);
    };
    public static CtxReadDelegate<List<RdNuGetInstallOneRequest>> ReadRdNuGetInstallOneRequestList = RdNuGetInstallOneRequest.Read.List();
    
    public static CtxWriteDelegate<RdNuGetInstallRequest> Write = (ctx, writer, value) => 
    {
      WriteRdNuGetInstallOneRequestList(ctx, writer, value.SubRequests);
    };
    public static CtxWriteDelegate<List<RdNuGetInstallOneRequest>> WriteRdNuGetInstallOneRequestList = RdNuGetInstallOneRequest.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetInstallRequest) obj);
    }
    public bool Equals(RdNuGetInstallRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SubRequests.SequenceEqual(other.SubRequests);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(SubRequests);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetInstallRequest (");
      using (printer.IndentCookie()) {
        printer.Print("subRequests = "); SubRequests.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetLogContext {
    NuGet,
    Rider,
    Build
  }
  
  
  public enum RdNuGetLogLevel {
    Debug,
    Verbose,
    Information,
    Minimal,
    Warning,
    Error
  }
  
  
  public class RdNuGetLogMessage : IPrintable, IEquatable<RdNuGetLogMessage>
  {
    //fields
    //public fields
    public DateTime Timestamp {get; private set;}
    public RdNuGetLogContext Context {get; private set;}
    public RdNuGetLogLevel Level {get; private set;}
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetLogMessage(
      DateTime timestamp,
      RdNuGetLogContext context,
      RdNuGetLogLevel level,
      [NotNull] string text
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Timestamp = timestamp;
      Context = context;
      Level = level;
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetLogMessage> Read = (ctx, reader) => 
    {
      var timestamp = reader.ReadDateTime();
      var context = (RdNuGetLogContext)reader.ReadInt();
      var level = (RdNuGetLogLevel)reader.ReadInt();
      var text = reader.ReadString();
      return new RdNuGetLogMessage(timestamp, context, level, text);
    };
    
    public static CtxWriteDelegate<RdNuGetLogMessage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Timestamp);
      writer.Write((int)value.Context);
      writer.Write((int)value.Level);
      writer.Write(value.Text);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetLogMessage) obj);
    }
    public bool Equals(RdNuGetLogMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Timestamp == other.Timestamp && Context == other.Context && Level == other.Level && Text == other.Text;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Timestamp.GetHashCode();
        hash = hash * 31 + (int) Context;
        hash = hash * 31 + (int) Level;
        hash = hash * 31 + Text.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetLogMessage (");
      using (printer.IndentCookie()) {
        printer.Print("timestamp = "); Timestamp.PrintEx(printer); printer.Println();
        printer.Print("context = "); Context.PrintEx(printer); printer.Println();
        printer.Print("level = "); Level.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetNotification : IPrintable, IEquatable<RdNuGetNotification>
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Message {get; private set;}
    public RdNuGetNotificationStatus Status {get; private set;}
    public RdNuGetNotificationLevel Level {get; private set;}
    public RdNuGetNotificationContext Context {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetNotification(
      [NotNull] string title,
      [NotNull] string message,
      RdNuGetNotificationStatus status,
      RdNuGetNotificationLevel level,
      RdNuGetNotificationContext context
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (message == null) throw new ArgumentNullException("message");
      
      Title = title;
      Message = message;
      Status = status;
      Level = level;
      Context = context;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetNotification> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var message = reader.ReadString();
      var status = (RdNuGetNotificationStatus)reader.ReadInt();
      var level = (RdNuGetNotificationLevel)reader.ReadInt();
      var context = (RdNuGetNotificationContext)reader.ReadInt();
      return new RdNuGetNotification(title, message, status, level, context);
    };
    
    public static CtxWriteDelegate<RdNuGetNotification> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.Message);
      writer.Write((int)value.Status);
      writer.Write((int)value.Level);
      writer.Write((int)value.Context);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetNotification) obj);
    }
    public bool Equals(RdNuGetNotification other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Title == other.Title && Message == other.Message && Status == other.Status && Level == other.Level && Context == other.Context;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        hash = hash * 31 + (int) Status;
        hash = hash * 31 + (int) Level;
        hash = hash * 31 + (int) Context;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetNotification (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
        printer.Print("level = "); Level.PrintEx(printer); printer.Println();
        printer.Print("context = "); Context.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetNotificationContext {
    Restore,
    Install,
    Uninstall,
    Read,
    Search,
    Modify
  }
  
  
  public enum RdNuGetNotificationLevel {
    Info,
    Warning,
    Error,
    Exception
  }
  
  
  public enum RdNuGetNotificationMode {
    Always,
    ErrorOnly,
    Silent
  }
  
  
  public enum RdNuGetNotificationStatus {
    Fail,
    Success,
    Skip
  }
  
  
  public class RdNuGetOperator : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsBusy { get { return _IsBusy; }}
    [NotNull] public ISink<RdNuGetInstallRequest> Install { get { return _Install; }}
    [NotNull] public ISink<RdNuGetUninstallRequest> Uninstall { get { return _Uninstall; }}
    [NotNull] public ISink<RdNuGetRestoreRequest> Restore { get { return _Restore; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsBusy;
    [NotNull] private readonly RdSignal<RdNuGetInstallRequest> _Install;
    [NotNull] private readonly RdSignal<RdNuGetUninstallRequest> _Uninstall;
    [NotNull] private readonly RdSignal<RdNuGetRestoreRequest> _Restore;
    
    //primary constructor
    private RdNuGetOperator(
      [NotNull] RdProperty<bool> isBusy,
      [NotNull] RdSignal<RdNuGetInstallRequest> install,
      [NotNull] RdSignal<RdNuGetUninstallRequest> uninstall,
      [NotNull] RdSignal<RdNuGetRestoreRequest> restore
    )
    {
      if (isBusy == null) throw new ArgumentNullException("isBusy");
      if (install == null) throw new ArgumentNullException("install");
      if (uninstall == null) throw new ArgumentNullException("uninstall");
      if (restore == null) throw new ArgumentNullException("restore");
      
      _IsBusy = isBusy;
      _Install = install;
      _Uninstall = uninstall;
      _Restore = restore;
      _IsBusy.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isBusy", _IsBusy));
      BindableChildren.Add(new KeyValuePair<string, object>("install", _Install));
      BindableChildren.Add(new KeyValuePair<string, object>("uninstall", _Uninstall));
      BindableChildren.Add(new KeyValuePair<string, object>("restore", _Restore));
    }
    //secondary constructor
    public RdNuGetOperator (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdNuGetInstallRequest>(RdNuGetInstallRequest.Read, RdNuGetInstallRequest.Write),
      new RdSignal<RdNuGetUninstallRequest>(RdNuGetUninstallRequest.Read, RdNuGetUninstallRequest.Write),
      new RdSignal<RdNuGetRestoreRequest>(RdNuGetRestoreRequest.Read, RdNuGetRestoreRequest.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetOperator> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var isBusy = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var install = RdSignal<RdNuGetInstallRequest>.Read(ctx, reader, RdNuGetInstallRequest.Read, RdNuGetInstallRequest.Write);
      var uninstall = RdSignal<RdNuGetUninstallRequest>.Read(ctx, reader, RdNuGetUninstallRequest.Read, RdNuGetUninstallRequest.Write);
      var restore = RdSignal<RdNuGetRestoreRequest>.Read(ctx, reader, RdNuGetRestoreRequest.Read, RdNuGetRestoreRequest.Write);
      return new RdNuGetOperator(isBusy, install, uninstall, restore).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdNuGetOperator> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._IsBusy);
      RdSignal<RdNuGetInstallRequest>.Write(ctx, writer, value._Install);
      RdSignal<RdNuGetUninstallRequest>.Write(ctx, writer, value._Uninstall);
      RdSignal<RdNuGetRestoreRequest>.Write(ctx, writer, value._Restore);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetOperator (");
      using (printer.IndentCookie()) {
        printer.Print("isBusy = "); _IsBusy.PrintEx(printer); printer.Println();
        printer.Print("install = "); _Install.PrintEx(printer); printer.Println();
        printer.Print("uninstall = "); _Uninstall.PrintEx(printer); printer.Println();
        printer.Print("restore = "); _Restore.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageDependency : IPrintable, IEquatable<RdNuGetPackageDependency>
  {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [CanBeNull] public RdNuGetVersionRange VersionRange {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetPackageDependency(
      [NotNull] string id,
      [CanBeNull] RdNuGetVersionRange versionRange
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      
      Id = id;
      VersionRange = versionRange;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageDependency> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var versionRange = ReadRdNuGetVersionRangeNullable(ctx, reader);
      return new RdNuGetPackageDependency(id, versionRange);
    };
    public static CtxReadDelegate<RdNuGetVersionRange> ReadRdNuGetVersionRangeNullable = RdNuGetVersionRange.Read.NullableClass();
    
    public static CtxWriteDelegate<RdNuGetPackageDependency> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteRdNuGetVersionRangeNullable(ctx, writer, value.VersionRange);
    };
    public static CtxWriteDelegate<RdNuGetVersionRange> WriteRdNuGetVersionRangeNullable = RdNuGetVersionRange.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageDependency) obj);
    }
    public bool Equals(RdNuGetPackageDependency other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(VersionRange, other.VersionRange);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + (VersionRange != null ?VersionRange.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageDependency (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("versionRange = "); VersionRange.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageDependencyGroup : IPrintable, IEquatable<RdNuGetPackageDependencyGroup>
  {
    //fields
    //public fields
    [NotNull] public RdNuGetFramework TargetFramework {get; private set;}
    [NotNull] public List<RdNuGetPackageDependency> Packages {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetPackageDependencyGroup(
      [NotNull] RdNuGetFramework targetFramework,
      [NotNull] List<RdNuGetPackageDependency> packages
    )
    {
      if (targetFramework == null) throw new ArgumentNullException("targetFramework");
      if (packages == null) throw new ArgumentNullException("packages");
      
      TargetFramework = targetFramework;
      Packages = packages;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageDependencyGroup> Read = (ctx, reader) => 
    {
      var targetFramework = RdNuGetFramework.Read(ctx, reader);
      var packages = ReadRdNuGetPackageDependencyList(ctx, reader);
      return new RdNuGetPackageDependencyGroup(targetFramework, packages);
    };
    public static CtxReadDelegate<List<RdNuGetPackageDependency>> ReadRdNuGetPackageDependencyList = RdNuGetPackageDependency.Read.List();
    
    public static CtxWriteDelegate<RdNuGetPackageDependencyGroup> Write = (ctx, writer, value) => 
    {
      RdNuGetFramework.Write(ctx, writer, value.TargetFramework);
      WriteRdNuGetPackageDependencyList(ctx, writer, value.Packages);
    };
    public static CtxWriteDelegate<List<RdNuGetPackageDependency>> WriteRdNuGetPackageDependencyList = RdNuGetPackageDependency.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageDependencyGroup) obj);
    }
    public bool Equals(RdNuGetPackageDependencyGroup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TargetFramework, other.TargetFramework) && Packages.SequenceEqual(other.Packages);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TargetFramework.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Packages);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageDependencyGroup (");
      using (printer.IndentCookie()) {
        printer.Print("targetFramework = "); TargetFramework.PrintEx(printer); printer.Println();
        printer.Print("packages = "); Packages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageIdentity : IPrintable, IEquatable<RdNuGetPackageIdentity>
  {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Version {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetPackageIdentity(
      [NotNull] string id,
      [NotNull] string version
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (version == null) throw new ArgumentNullException("version");
      
      Id = id;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageIdentity> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var version = reader.ReadString();
      return new RdNuGetPackageIdentity(id, version);
    };
    
    public static CtxWriteDelegate<RdNuGetPackageIdentity> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Version);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageIdentity) obj);
    }
    public bool Equals(RdNuGetPackageIdentity other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Version == other.Version;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Version.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageIdentity (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageMetadata : IPrintable, IEquatable<RdNuGetPackageMetadata>
  {
    //fields
    //public fields
    [NotNull] public RdNuGetPackageIdentity Identity {get; private set;}
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Summary {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public string Authors {get; private set;}
    [NotNull] public string Owners {get; private set;}
    [CanBeNull] public Uri IconUrl {get; private set;}
    public bool PrefixReserved {get; private set;}
    [CanBeNull] public Uri LicenseUrl {get; private set;}
    [CanBeNull] public Uri ProjectUrl {get; private set;}
    [CanBeNull] public Uri ReportAbuseUrl {get; private set;}
    [NotNull] public string Tags {get; private set;}
    [CanBeNull] public long? DownloadCount {get; private set;}
    [NotNull] public List<RdNuGetPackageDependencyGroup> DependencySets {get; private set;}
    public bool RequireLicenseAcceptance {get; private set;}
    public bool AutoReferenced {get; private set;}
    [NotNull] public List<string> InstallationPaths {get; private set;}
    [NotNull] public string FullVersion {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetPackageMetadata(
      [NotNull] RdNuGetPackageIdentity identity,
      [NotNull] string title,
      [NotNull] string summary,
      [NotNull] string description,
      [NotNull] string authors,
      [NotNull] string owners,
      [CanBeNull] Uri iconUrl,
      bool prefixReserved,
      [CanBeNull] Uri licenseUrl,
      [CanBeNull] Uri projectUrl,
      [CanBeNull] Uri reportAbuseUrl,
      [NotNull] string tags,
      [CanBeNull] long? downloadCount,
      [NotNull] List<RdNuGetPackageDependencyGroup> dependencySets,
      bool requireLicenseAcceptance,
      bool autoReferenced,
      [NotNull] List<string> installationPaths,
      [NotNull] string fullVersion
    )
    {
      if (identity == null) throw new ArgumentNullException("identity");
      if (title == null) throw new ArgumentNullException("title");
      if (summary == null) throw new ArgumentNullException("summary");
      if (description == null) throw new ArgumentNullException("description");
      if (authors == null) throw new ArgumentNullException("authors");
      if (owners == null) throw new ArgumentNullException("owners");
      if (tags == null) throw new ArgumentNullException("tags");
      if (dependencySets == null) throw new ArgumentNullException("dependencySets");
      if (installationPaths == null) throw new ArgumentNullException("installationPaths");
      if (fullVersion == null) throw new ArgumentNullException("fullVersion");
      
      Identity = identity;
      Title = title;
      Summary = summary;
      Description = description;
      Authors = authors;
      Owners = owners;
      IconUrl = iconUrl;
      PrefixReserved = prefixReserved;
      LicenseUrl = licenseUrl;
      ProjectUrl = projectUrl;
      ReportAbuseUrl = reportAbuseUrl;
      Tags = tags;
      DownloadCount = downloadCount;
      DependencySets = dependencySets;
      RequireLicenseAcceptance = requireLicenseAcceptance;
      AutoReferenced = autoReferenced;
      InstallationPaths = installationPaths;
      FullVersion = fullVersion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageMetadata> Read = (ctx, reader) => 
    {
      var identity = RdNuGetPackageIdentity.Read(ctx, reader);
      var title = reader.ReadString();
      var summary = reader.ReadString();
      var description = reader.ReadString();
      var authors = reader.ReadString();
      var owners = reader.ReadString();
      var iconUrl = ReadUriNullable(ctx, reader);
      var prefixReserved = reader.ReadBool();
      var licenseUrl = ReadUriNullable(ctx, reader);
      var projectUrl = ReadUriNullable(ctx, reader);
      var reportAbuseUrl = ReadUriNullable(ctx, reader);
      var tags = reader.ReadString();
      var downloadCount = ReadLongNullable(ctx, reader);
      var dependencySets = ReadRdNuGetPackageDependencyGroupList(ctx, reader);
      var requireLicenseAcceptance = reader.ReadBool();
      var autoReferenced = reader.ReadBool();
      var installationPaths = ReadStringList(ctx, reader);
      var fullVersion = reader.ReadString();
      return new RdNuGetPackageMetadata(identity, title, summary, description, authors, owners, iconUrl, prefixReserved, licenseUrl, projectUrl, reportAbuseUrl, tags, downloadCount, dependencySets, requireLicenseAcceptance, autoReferenced, installationPaths, fullVersion);
    };
    public static CtxReadDelegate<Uri> ReadUriNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadUri.NullableClass();
    public static CtxReadDelegate<long?> ReadLongNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong.NullableStruct();
    public static CtxReadDelegate<List<RdNuGetPackageDependencyGroup>> ReadRdNuGetPackageDependencyGroupList = RdNuGetPackageDependencyGroup.Read.List();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdNuGetPackageMetadata> Write = (ctx, writer, value) => 
    {
      RdNuGetPackageIdentity.Write(ctx, writer, value.Identity);
      writer.Write(value.Title);
      writer.Write(value.Summary);
      writer.Write(value.Description);
      writer.Write(value.Authors);
      writer.Write(value.Owners);
      WriteUriNullable(ctx, writer, value.IconUrl);
      writer.Write(value.PrefixReserved);
      WriteUriNullable(ctx, writer, value.LicenseUrl);
      WriteUriNullable(ctx, writer, value.ProjectUrl);
      WriteUriNullable(ctx, writer, value.ReportAbuseUrl);
      writer.Write(value.Tags);
      WriteLongNullable(ctx, writer, value.DownloadCount);
      WriteRdNuGetPackageDependencyGroupList(ctx, writer, value.DependencySets);
      writer.Write(value.RequireLicenseAcceptance);
      writer.Write(value.AutoReferenced);
      WriteStringList(ctx, writer, value.InstallationPaths);
      writer.Write(value.FullVersion);
    };
    public static CtxWriteDelegate<Uri> WriteUriNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteUri.NullableClass();
    public static CtxWriteDelegate<long?> WriteLongNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong.NullableStruct();
    public static CtxWriteDelegate<List<RdNuGetPackageDependencyGroup>> WriteRdNuGetPackageDependencyGroupList = RdNuGetPackageDependencyGroup.Write.List();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageMetadata) obj);
    }
    public bool Equals(RdNuGetPackageMetadata other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Identity, other.Identity) && Title == other.Title && Summary == other.Summary && Description == other.Description && Authors == other.Authors && Owners == other.Owners && Equals(IconUrl, other.IconUrl) && PrefixReserved == other.PrefixReserved && Equals(LicenseUrl, other.LicenseUrl) && Equals(ProjectUrl, other.ProjectUrl) && Equals(ReportAbuseUrl, other.ReportAbuseUrl) && Tags == other.Tags && Equals(DownloadCount, other.DownloadCount) && DependencySets.SequenceEqual(other.DependencySets) && RequireLicenseAcceptance == other.RequireLicenseAcceptance && AutoReferenced == other.AutoReferenced && InstallationPaths.SequenceEqual(other.InstallationPaths) && FullVersion == other.FullVersion;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Identity.GetHashCode();
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + Summary.GetHashCode();
        hash = hash * 31 + Description.GetHashCode();
        hash = hash * 31 + Authors.GetHashCode();
        hash = hash * 31 + Owners.GetHashCode();
        hash = hash * 31 + (IconUrl != null ?IconUrl.GetHashCode() : 0);
        hash = hash * 31 + PrefixReserved.GetHashCode();
        hash = hash * 31 + (LicenseUrl != null ?LicenseUrl.GetHashCode() : 0);
        hash = hash * 31 + (ProjectUrl != null ?ProjectUrl.GetHashCode() : 0);
        hash = hash * 31 + (ReportAbuseUrl != null ?ReportAbuseUrl.GetHashCode() : 0);
        hash = hash * 31 + Tags.GetHashCode();
        hash = hash * 31 + (DownloadCount != null ?DownloadCount.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(DependencySets);
        hash = hash * 31 + RequireLicenseAcceptance.GetHashCode();
        hash = hash * 31 + AutoReferenced.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(InstallationPaths);
        hash = hash * 31 + FullVersion.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageMetadata (");
      using (printer.IndentCookie()) {
        printer.Print("identity = "); Identity.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("summary = "); Summary.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("authors = "); Authors.PrintEx(printer); printer.Println();
        printer.Print("owners = "); Owners.PrintEx(printer); printer.Println();
        printer.Print("iconUrl = "); IconUrl.PrintEx(printer); printer.Println();
        printer.Print("prefixReserved = "); PrefixReserved.PrintEx(printer); printer.Println();
        printer.Print("licenseUrl = "); LicenseUrl.PrintEx(printer); printer.Println();
        printer.Print("projectUrl = "); ProjectUrl.PrintEx(printer); printer.Println();
        printer.Print("reportAbuseUrl = "); ReportAbuseUrl.PrintEx(printer); printer.Println();
        printer.Print("tags = "); Tags.PrintEx(printer); printer.Println();
        printer.Print("downloadCount = "); DownloadCount.PrintEx(printer); printer.Println();
        printer.Print("dependencySets = "); DependencySets.PrintEx(printer); printer.Println();
        printer.Print("requireLicenseAcceptance = "); RequireLicenseAcceptance.PrintEx(printer); printer.Println();
        printer.Print("autoReferenced = "); AutoReferenced.PrintEx(printer); printer.Println();
        printer.Print("installationPaths = "); InstallationPaths.PrintEx(printer); printer.Println();
        printer.Print("fullVersion = "); FullVersion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageSource : IPrintable, IEquatable<RdNuGetPackageSource>
  {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Source {get; private set;}
    public bool IsOfficial {get; private set;}
    public bool IsMachineWide {get; private set;}
    public bool IsEnabled {get; private set;}
    [CanBeNull] public string UserName {get; private set;}
    [CanBeNull] public RdSecureString? Password {get; private set;}
    public bool IsPasswordClearText {get; private set;}
    public int ProtocolVersion {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetPackageSource(
      [NotNull] string name,
      [NotNull] string source,
      bool isOfficial,
      bool isMachineWide,
      bool isEnabled,
      [CanBeNull] string userName,
      [CanBeNull] RdSecureString? password,
      bool isPasswordClearText,
      int protocolVersion
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (source == null) throw new ArgumentNullException("source");
      
      Name = name;
      Source = source;
      IsOfficial = isOfficial;
      IsMachineWide = isMachineWide;
      IsEnabled = isEnabled;
      UserName = userName;
      Password = password;
      IsPasswordClearText = isPasswordClearText;
      ProtocolVersion = protocolVersion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageSource> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var source = reader.ReadString();
      var isOfficial = reader.ReadBool();
      var isMachineWide = reader.ReadBool();
      var isEnabled = reader.ReadBool();
      var userName = ReadStringNullable(ctx, reader);
      var password = ReadSecureStringNullable(ctx, reader);
      var isPasswordClearText = reader.ReadBool();
      var protocolVersion = reader.ReadInt();
      return new RdNuGetPackageSource(name, source, isOfficial, isMachineWide, isEnabled, userName, password, isPasswordClearText, protocolVersion);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdSecureString?> ReadSecureStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadSecureString.NullableStruct();
    
    public static CtxWriteDelegate<RdNuGetPackageSource> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.Source);
      writer.Write(value.IsOfficial);
      writer.Write(value.IsMachineWide);
      writer.Write(value.IsEnabled);
      WriteStringNullable(ctx, writer, value.UserName);
      WriteSecureStringNullable(ctx, writer, value.Password);
      writer.Write(value.IsPasswordClearText);
      writer.Write(value.ProtocolVersion);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdSecureString?> WriteSecureStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteSecureString.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageSource) obj);
    }
    public bool Equals(RdNuGetPackageSource other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Source == other.Source && IsOfficial == other.IsOfficial && IsMachineWide == other.IsMachineWide && IsEnabled == other.IsEnabled && Equals(UserName, other.UserName) && Equals(Password, other.Password) && IsPasswordClearText == other.IsPasswordClearText && ProtocolVersion == other.ProtocolVersion;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Source.GetHashCode();
        hash = hash * 31 + IsOfficial.GetHashCode();
        hash = hash * 31 + IsMachineWide.GetHashCode();
        hash = hash * 31 + IsEnabled.GetHashCode();
        hash = hash * 31 + (UserName != null ?UserName.GetHashCode() : 0);
        hash = hash * 31 + (Password != null ?Password.GetHashCode() : 0);
        hash = hash * 31 + IsPasswordClearText.GetHashCode();
        hash = hash * 31 + ProtocolVersion.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageSource (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("source = "); Source.PrintEx(printer); printer.Println();
        printer.Print("isOfficial = "); IsOfficial.PrintEx(printer); printer.Println();
        printer.Print("isMachineWide = "); IsMachineWide.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("userName = "); UserName.PrintEx(printer); printer.Println();
        printer.Print("password = "); Password.PrintEx(printer); printer.Println();
        printer.Print("isPasswordClearText = "); IsPasswordClearText.PrintEx(printer); printer.Println();
        printer.Print("protocolVersion = "); ProtocolVersion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetProjectInfo : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<RdNuGetPackageIdentity> Packages {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetProjectInfo(
      [NotNull] List<RdNuGetPackageIdentity> packages
    )
    {
      if (packages == null) throw new ArgumentNullException("packages");
      
      Packages = packages;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetProjectInfo> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var packages = ReadRdNuGetPackageIdentityList(ctx, reader);
      return new RdNuGetProjectInfo(packages).WithId(_id);
    };
    public static CtxReadDelegate<List<RdNuGetPackageIdentity>> ReadRdNuGetPackageIdentityList = RdNuGetPackageIdentity.Read.List();
    
    public static CtxWriteDelegate<RdNuGetProjectInfo> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdNuGetPackageIdentityList(ctx, writer, value.Packages);
    };
    public static CtxWriteDelegate<List<RdNuGetPackageIdentity>> WriteRdNuGetPackageIdentityList = RdNuGetPackageIdentity.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetProjectInfo (");
      using (printer.IndentCookie()) {
        printer.Print("packages = "); Packages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetProjects : IPrintable, IEquatable<RdNuGetProjects>
  {
    //fields
    //public fields
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetProjects(
      [NotNull] List<int> projectIds
    )
    {
      if (projectIds == null) throw new ArgumentNullException("projectIds");
      
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetProjects> Read = (ctx, reader) => 
    {
      var projectIds = ReadIntList(ctx, reader);
      return new RdNuGetProjects(projectIds);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<RdNuGetProjects> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetProjects) obj);
    }
    public bool Equals(RdNuGetProjects other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ProjectIds);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetProjects (");
      using (printer.IndentCookie()) {
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetRemoteVersion : IPrintable, IEquatable<RdNuGetRemoteVersion>
  {
    //fields
    //public fields
    [NotNull] public string FeedId {get; private set;}
    [NotNull] public string Version {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetRemoteVersion(
      [NotNull] string feedId,
      [NotNull] string version
    )
    {
      if (feedId == null) throw new ArgumentNullException("feedId");
      if (version == null) throw new ArgumentNullException("version");
      
      FeedId = feedId;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetRemoteVersion> Read = (ctx, reader) => 
    {
      var feedId = reader.ReadString();
      var version = reader.ReadString();
      return new RdNuGetRemoteVersion(feedId, version);
    };
    
    public static CtxWriteDelegate<RdNuGetRemoteVersion> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FeedId);
      writer.Write(value.Version);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetRemoteVersion) obj);
    }
    public bool Equals(RdNuGetRemoteVersion other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FeedId == other.FeedId && Version == other.Version;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FeedId.GetHashCode();
        hash = hash * 31 + Version.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetRemoteVersion (");
      using (printer.IndentCookie()) {
        printer.Print("feedId = "); FeedId.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetRestoreConsent : IPrintable, IEquatable<RdNuGetRestoreConsent>
  {
    //fields
    //public fields
    public bool IsGranted {get; private set;}
    public bool IsGrantedInSettings {get; private set;}
    public bool IsAutomatic {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetRestoreConsent(
      bool isGranted,
      bool isGrantedInSettings,
      bool isAutomatic
    )
    {
      IsGranted = isGranted;
      IsGrantedInSettings = isGrantedInSettings;
      IsAutomatic = isAutomatic;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetRestoreConsent> Read = (ctx, reader) => 
    {
      var isGranted = reader.ReadBool();
      var isGrantedInSettings = reader.ReadBool();
      var isAutomatic = reader.ReadBool();
      return new RdNuGetRestoreConsent(isGranted, isGrantedInSettings, isAutomatic);
    };
    
    public static CtxWriteDelegate<RdNuGetRestoreConsent> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsGranted);
      writer.Write(value.IsGrantedInSettings);
      writer.Write(value.IsAutomatic);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetRestoreConsent) obj);
    }
    public bool Equals(RdNuGetRestoreConsent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsGranted == other.IsGranted && IsGrantedInSettings == other.IsGrantedInSettings && IsAutomatic == other.IsAutomatic;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsGranted.GetHashCode();
        hash = hash * 31 + IsGrantedInSettings.GetHashCode();
        hash = hash * 31 + IsAutomatic.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetRestoreConsent (");
      using (printer.IndentCookie()) {
        printer.Print("isGranted = "); IsGranted.PrintEx(printer); printer.Println();
        printer.Print("isGrantedInSettings = "); IsGrantedInSettings.PrintEx(printer); printer.Println();
        printer.Print("isAutomatic = "); IsAutomatic.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetRestoreRequest : IPrintable, IEquatable<RdNuGetRestoreRequest>
  {
    //fields
    //public fields
    public RdNuGetNotificationMode Mode {get; private set;}
    public RdNuGetRestoreStrategy Strategy {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetRestoreRequest(
      RdNuGetNotificationMode mode,
      RdNuGetRestoreStrategy strategy
    )
    {
      Mode = mode;
      Strategy = strategy;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetRestoreRequest> Read = (ctx, reader) => 
    {
      var mode = (RdNuGetNotificationMode)reader.ReadInt();
      var strategy = (RdNuGetRestoreStrategy)reader.ReadInt();
      return new RdNuGetRestoreRequest(mode, strategy);
    };
    
    public static CtxWriteDelegate<RdNuGetRestoreRequest> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Mode);
      writer.Write((int)value.Strategy);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetRestoreRequest) obj);
    }
    public bool Equals(RdNuGetRestoreRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Mode == other.Mode && Strategy == other.Strategy;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Mode;
        hash = hash * 31 + (int) Strategy;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetRestoreRequest (");
      using (printer.IndentCookie()) {
        printer.Print("mode = "); Mode.PrintEx(printer); printer.Println();
        printer.Print("strategy = "); Strategy.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetRestoreStrategy {
    Default,
    Force
  }
  
  
  public class RdNuGetSetAutoClearModeArgs : IPrintable, IEquatable<RdNuGetSetAutoClearModeArgs>
  {
    //fields
    //public fields
    [NotNull] public string Folder {get; private set;}
    public bool Value {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetSetAutoClearModeArgs(
      [NotNull] string folder,
      bool value
    )
    {
      if (folder == null) throw new ArgumentNullException("folder");
      
      Folder = folder;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetSetAutoClearModeArgs> Read = (ctx, reader) => 
    {
      var folder = reader.ReadString();
      var value = reader.ReadBool();
      return new RdNuGetSetAutoClearModeArgs(folder, value);
    };
    
    public static CtxWriteDelegate<RdNuGetSetAutoClearModeArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Folder);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetSetAutoClearModeArgs) obj);
    }
    public bool Equals(RdNuGetSetAutoClearModeArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Folder == other.Folder && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Folder.GetHashCode();
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetSetAutoClearModeArgs (");
      using (printer.IndentCookie()) {
        printer.Print("folder = "); Folder.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetSmartMetadata : IPrintable, IEquatable<RdNuGetSmartMetadata>
  {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [CanBeNull] public Uri IconUrl {get; private set;}
    public bool PrefixReserved {get; private set;}
    [NotNull] public List<string> InstalledVersions {get; private set;}
    [NotNull] public List<RdNuGetRemoteVersion> AvailableVersions {get; private set;}
    public long TotalDownloads {get; private set;}
    public bool IsSuperPopular {get; private set;}
    public bool CanBeUpdated {get; private set;}
    public bool AutoReferenced {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetSmartMetadata(
      [NotNull] string id,
      [CanBeNull] Uri iconUrl,
      bool prefixReserved,
      [NotNull] List<string> installedVersions,
      [NotNull] List<RdNuGetRemoteVersion> availableVersions,
      long totalDownloads,
      bool isSuperPopular,
      bool canBeUpdated,
      bool autoReferenced
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (installedVersions == null) throw new ArgumentNullException("installedVersions");
      if (availableVersions == null) throw new ArgumentNullException("availableVersions");
      
      Id = id;
      IconUrl = iconUrl;
      PrefixReserved = prefixReserved;
      InstalledVersions = installedVersions;
      AvailableVersions = availableVersions;
      TotalDownloads = totalDownloads;
      IsSuperPopular = isSuperPopular;
      CanBeUpdated = canBeUpdated;
      AutoReferenced = autoReferenced;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetSmartMetadata> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var iconUrl = ReadUriNullable(ctx, reader);
      var prefixReserved = reader.ReadBool();
      var installedVersions = ReadStringList(ctx, reader);
      var availableVersions = ReadRdNuGetRemoteVersionList(ctx, reader);
      var totalDownloads = reader.ReadLong();
      var isSuperPopular = reader.ReadBool();
      var canBeUpdated = reader.ReadBool();
      var autoReferenced = reader.ReadBool();
      return new RdNuGetSmartMetadata(id, iconUrl, prefixReserved, installedVersions, availableVersions, totalDownloads, isSuperPopular, canBeUpdated, autoReferenced);
    };
    public static CtxReadDelegate<Uri> ReadUriNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadUri.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<RdNuGetRemoteVersion>> ReadRdNuGetRemoteVersionList = RdNuGetRemoteVersion.Read.List();
    
    public static CtxWriteDelegate<RdNuGetSmartMetadata> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteUriNullable(ctx, writer, value.IconUrl);
      writer.Write(value.PrefixReserved);
      WriteStringList(ctx, writer, value.InstalledVersions);
      WriteRdNuGetRemoteVersionList(ctx, writer, value.AvailableVersions);
      writer.Write(value.TotalDownloads);
      writer.Write(value.IsSuperPopular);
      writer.Write(value.CanBeUpdated);
      writer.Write(value.AutoReferenced);
    };
    public static CtxWriteDelegate<Uri> WriteUriNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteUri.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<RdNuGetRemoteVersion>> WriteRdNuGetRemoteVersionList = RdNuGetRemoteVersion.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetSmartMetadata) obj);
    }
    public bool Equals(RdNuGetSmartMetadata other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(IconUrl, other.IconUrl) && PrefixReserved == other.PrefixReserved && InstalledVersions.SequenceEqual(other.InstalledVersions) && AvailableVersions.SequenceEqual(other.AvailableVersions) && TotalDownloads == other.TotalDownloads && IsSuperPopular == other.IsSuperPopular && CanBeUpdated == other.CanBeUpdated && AutoReferenced == other.AutoReferenced;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + (IconUrl != null ?IconUrl.GetHashCode() : 0);
        hash = hash * 31 + PrefixReserved.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(InstalledVersions);
        hash = hash * 31 + Collections.GetHashCode(AvailableVersions);
        hash = hash * 31 + TotalDownloads.GetHashCode();
        hash = hash * 31 + IsSuperPopular.GetHashCode();
        hash = hash * 31 + CanBeUpdated.GetHashCode();
        hash = hash * 31 + AutoReferenced.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetSmartMetadata (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("iconUrl = "); IconUrl.PrintEx(printer); printer.Println();
        printer.Print("prefixReserved = "); PrefixReserved.PrintEx(printer); printer.Println();
        printer.Print("installedVersions = "); InstalledVersions.PrintEx(printer); printer.Println();
        printer.Print("availableVersions = "); AvailableVersions.PrintEx(printer); printer.Println();
        printer.Print("totalDownloads = "); TotalDownloads.PrintEx(printer); printer.Println();
        printer.Print("isSuperPopular = "); IsSuperPopular.PrintEx(printer); printer.Println();
        printer.Print("canBeUpdated = "); CanBeUpdated.PrintEx(printer); printer.Println();
        printer.Print("autoReferenced = "); AutoReferenced.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetStateInfo : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsFetching { get { return _IsFetching; }}
    [NotNull] public IRdProperty<bool> OperatorIsBusy { get { return _OperatorIsBusy; }}
    [NotNull] public IRdProperty<bool> PackageReferenceTrackerIsBusy { get { return _PackageReferenceTrackerIsBusy; }}
    [NotNull] public IRdProperty<double> Progress { get { return _Progress; }}
    [NotNull] public IRdProperty<int> TotalFetched { get { return _TotalFetched; }}
    [NotNull] public ISink<RdVoid> RequestStatistics { get { return _RequestStatistics; }}
    [NotNull] public IRdProperty<string> Statistics { get { return _Statistics; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsFetching;
    [NotNull] private readonly RdProperty<bool> _OperatorIsBusy;
    [NotNull] private readonly RdProperty<bool> _PackageReferenceTrackerIsBusy;
    [NotNull] private readonly RdProperty<double> _Progress;
    [NotNull] private readonly RdProperty<int> _TotalFetched;
    [NotNull] private readonly RdSignal<RdVoid> _RequestStatistics;
    [NotNull] private readonly RdProperty<string> _Statistics;
    
    //primary constructor
    private RdNuGetStateInfo(
      [NotNull] RdProperty<bool> isFetching,
      [NotNull] RdProperty<bool> operatorIsBusy,
      [NotNull] RdProperty<bool> packageReferenceTrackerIsBusy,
      [NotNull] RdProperty<double> progress,
      [NotNull] RdProperty<int> totalFetched,
      [NotNull] RdSignal<RdVoid> requestStatistics,
      [NotNull] RdProperty<string> statistics
    )
    {
      if (isFetching == null) throw new ArgumentNullException("isFetching");
      if (operatorIsBusy == null) throw new ArgumentNullException("operatorIsBusy");
      if (packageReferenceTrackerIsBusy == null) throw new ArgumentNullException("packageReferenceTrackerIsBusy");
      if (progress == null) throw new ArgumentNullException("progress");
      if (totalFetched == null) throw new ArgumentNullException("totalFetched");
      if (requestStatistics == null) throw new ArgumentNullException("requestStatistics");
      if (statistics == null) throw new ArgumentNullException("statistics");
      
      _IsFetching = isFetching;
      _OperatorIsBusy = operatorIsBusy;
      _PackageReferenceTrackerIsBusy = packageReferenceTrackerIsBusy;
      _Progress = progress;
      _TotalFetched = totalFetched;
      _RequestStatistics = requestStatistics;
      _Statistics = statistics;
      _IsFetching.OptimizeNested = true;
      _OperatorIsBusy.OptimizeNested = true;
      _PackageReferenceTrackerIsBusy.OptimizeNested = true;
      _Progress.OptimizeNested = true;
      _TotalFetched.OptimizeNested = true;
      _Statistics.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isFetching", _IsFetching));
      BindableChildren.Add(new KeyValuePair<string, object>("operatorIsBusy", _OperatorIsBusy));
      BindableChildren.Add(new KeyValuePair<string, object>("packageReferenceTrackerIsBusy", _PackageReferenceTrackerIsBusy));
      BindableChildren.Add(new KeyValuePair<string, object>("progress", _Progress));
      BindableChildren.Add(new KeyValuePair<string, object>("totalFetched", _TotalFetched));
      BindableChildren.Add(new KeyValuePair<string, object>("requestStatistics", _RequestStatistics));
      BindableChildren.Add(new KeyValuePair<string, object>("statistics", _Statistics));
    }
    //secondary constructor
    public RdNuGetStateInfo (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetStateInfo> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var isFetching = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var operatorIsBusy = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var packageReferenceTrackerIsBusy = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var progress = RdProperty<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      var totalFetched = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var requestStatistics = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var statistics = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RdNuGetStateInfo(isFetching, operatorIsBusy, packageReferenceTrackerIsBusy, progress, totalFetched, requestStatistics, statistics).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdNuGetStateInfo> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._IsFetching);
      RdProperty<bool>.Write(ctx, writer, value._OperatorIsBusy);
      RdProperty<bool>.Write(ctx, writer, value._PackageReferenceTrackerIsBusy);
      RdProperty<double>.Write(ctx, writer, value._Progress);
      RdProperty<int>.Write(ctx, writer, value._TotalFetched);
      RdSignal<RdVoid>.Write(ctx, writer, value._RequestStatistics);
      RdProperty<string>.Write(ctx, writer, value._Statistics);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetStateInfo (");
      using (printer.IndentCookie()) {
        printer.Print("isFetching = "); _IsFetching.PrintEx(printer); printer.Println();
        printer.Print("operatorIsBusy = "); _OperatorIsBusy.PrintEx(printer); printer.Println();
        printer.Print("packageReferenceTrackerIsBusy = "); _PackageReferenceTrackerIsBusy.PrintEx(printer); printer.Println();
        printer.Print("progress = "); _Progress.PrintEx(printer); printer.Println();
        printer.Print("totalFetched = "); _TotalFetched.PrintEx(printer); printer.Println();
        printer.Print("requestStatistics = "); _RequestStatistics.PrintEx(printer); printer.Println();
        printer.Print("statistics = "); _Statistics.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetUltraConfig : RdBindableBase
  {
    //fields
    //public fields
    [CanBeNull] public string ErrorMessage {get; private set;}
    [NotNull] public List<string> UltraFeedIds {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetUltraConfig(
      [CanBeNull] string errorMessage,
      [NotNull] List<string> ultraFeedIds
    )
    {
      if (ultraFeedIds == null) throw new ArgumentNullException("ultraFeedIds");
      
      ErrorMessage = errorMessage;
      UltraFeedIds = ultraFeedIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetUltraConfig> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var errorMessage = ReadStringNullable(ctx, reader);
      var ultraFeedIds = ReadStringList(ctx, reader);
      return new RdNuGetUltraConfig(errorMessage, ultraFeedIds).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdNuGetUltraConfig> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.ErrorMessage);
      WriteStringList(ctx, writer, value.UltraFeedIds);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetUltraConfig (");
      using (printer.IndentCookie()) {
        printer.Print("errorMessage = "); ErrorMessage.PrintEx(printer); printer.Println();
        printer.Print("ultraFeedIds = "); UltraFeedIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetUninstallRequest : IPrintable, IEquatable<RdNuGetUninstallRequest>
  {
    //fields
    //public fields
    [NotNull] public RdNuGetProjects Projects {get; private set;}
    [NotNull] public string PackageId {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetUninstallRequest(
      [NotNull] RdNuGetProjects projects,
      [NotNull] string packageId
    )
    {
      if (projects == null) throw new ArgumentNullException("projects");
      if (packageId == null) throw new ArgumentNullException("packageId");
      
      Projects = projects;
      PackageId = packageId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetUninstallRequest> Read = (ctx, reader) => 
    {
      var projects = RdNuGetProjects.Read(ctx, reader);
      var packageId = reader.ReadString();
      return new RdNuGetUninstallRequest(projects, packageId);
    };
    
    public static CtxWriteDelegate<RdNuGetUninstallRequest> Write = (ctx, writer, value) => 
    {
      RdNuGetProjects.Write(ctx, writer, value.Projects);
      writer.Write(value.PackageId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetUninstallRequest) obj);
    }
    public bool Equals(RdNuGetUninstallRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Projects, other.Projects) && PackageId == other.PackageId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Projects.GetHashCode();
        hash = hash * 31 + PackageId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetUninstallRequest (");
      using (printer.IndentCookie()) {
        printer.Print("projects = "); Projects.PrintEx(printer); printer.Println();
        printer.Print("packageId = "); PackageId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetVerifyPackageSpecsResult : IPrintable, IEquatable<RdNuGetVerifyPackageSpecsResult>
  {
    //fields
    //public fields
    public bool IsEqual {get; private set;}
    [NotNull] public string RiderSpecs {get; private set;}
    [NotNull] public string CliSpecs {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetVerifyPackageSpecsResult(
      bool isEqual,
      [NotNull] string riderSpecs,
      [NotNull] string cliSpecs
    )
    {
      if (riderSpecs == null) throw new ArgumentNullException("riderSpecs");
      if (cliSpecs == null) throw new ArgumentNullException("cliSpecs");
      
      IsEqual = isEqual;
      RiderSpecs = riderSpecs;
      CliSpecs = cliSpecs;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetVerifyPackageSpecsResult> Read = (ctx, reader) => 
    {
      var isEqual = reader.ReadBool();
      var riderSpecs = reader.ReadString();
      var cliSpecs = reader.ReadString();
      return new RdNuGetVerifyPackageSpecsResult(isEqual, riderSpecs, cliSpecs);
    };
    
    public static CtxWriteDelegate<RdNuGetVerifyPackageSpecsResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsEqual);
      writer.Write(value.RiderSpecs);
      writer.Write(value.CliSpecs);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetVerifyPackageSpecsResult) obj);
    }
    public bool Equals(RdNuGetVerifyPackageSpecsResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsEqual == other.IsEqual && RiderSpecs == other.RiderSpecs && CliSpecs == other.CliSpecs;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsEqual.GetHashCode();
        hash = hash * 31 + RiderSpecs.GetHashCode();
        hash = hash * 31 + CliSpecs.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetVerifyPackageSpecsResult (");
      using (printer.IndentCookie()) {
        printer.Print("isEqual = "); IsEqual.PrintEx(printer); printer.Println();
        printer.Print("riderSpecs = "); RiderSpecs.PrintEx(printer); printer.Println();
        printer.Print("cliSpecs = "); CliSpecs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetVersionConstraints {
    None,
    ExactMajor,
    ExactMinor,
    ExactPatch,
    ExactRelease
  }
  
  
  public class RdNuGetVersionRange : IPrintable, IEquatable<RdNuGetVersionRange>
  {
    //fields
    //public fields
    [CanBeNull] public string MinVersion {get; private set;}
    [CanBeNull] public string MaxVersion {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetVersionRange(
      [CanBeNull] string minVersion,
      [CanBeNull] string maxVersion
    )
    {
      MinVersion = minVersion;
      MaxVersion = maxVersion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetVersionRange> Read = (ctx, reader) => 
    {
      var minVersion = ReadStringNullable(ctx, reader);
      var maxVersion = ReadStringNullable(ctx, reader);
      return new RdNuGetVersionRange(minVersion, maxVersion);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdNuGetVersionRange> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.MinVersion);
      WriteStringNullable(ctx, writer, value.MaxVersion);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetVersionRange) obj);
    }
    public bool Equals(RdNuGetVersionRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(MinVersion, other.MinVersion) && Equals(MaxVersion, other.MaxVersion);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (MinVersion != null ?MinVersion.GetHashCode() : 0);
        hash = hash * 31 + (MaxVersion != null ?MaxVersion.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetVersionRange (");
      using (printer.IndentCookie()) {
        printer.Print("minVersion = "); MinVersion.PrintEx(printer); printer.Println();
        printer.Print("maxVersion = "); MaxVersion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetVersionsInFeed : IPrintable, IEquatable<RdNuGetVersionsInFeed>
  {
    //fields
    //public fields
    [NotNull] public string FeedId {get; private set;}
    [NotNull] public List<string> Versions {get; private set;}
    
    //private fields
    //primary constructor
    public RdNuGetVersionsInFeed(
      [NotNull] string feedId,
      [NotNull] List<string> versions
    )
    {
      if (feedId == null) throw new ArgumentNullException("feedId");
      if (versions == null) throw new ArgumentNullException("versions");
      
      FeedId = feedId;
      Versions = versions;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetVersionsInFeed> Read = (ctx, reader) => 
    {
      var feedId = reader.ReadString();
      var versions = ReadStringList(ctx, reader);
      return new RdNuGetVersionsInFeed(feedId, versions);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdNuGetVersionsInFeed> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FeedId);
      WriteStringList(ctx, writer, value.Versions);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetVersionsInFeed) obj);
    }
    public bool Equals(RdNuGetVersionsInFeed other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FeedId == other.FeedId && Versions.SequenceEqual(other.Versions);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FeedId.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Versions);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetVersionsInFeed (");
      using (printer.IndentCookie()) {
        printer.Print("feedId = "); FeedId.PrintEx(printer); printer.Println();
        printer.Print("versions = "); Versions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
