using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RdShellModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<ExpectedMemoryUsage, long> GetTotalMemory { get { return _GetTotalMemory; }}
    [NotNull] public RdEndpoint<int, int> GetZombieSolutionCount { get { return _GetZombieSolutionCount; }}
    [NotNull] public RdEndpoint<string, bool> MakeDotMemorySnapshot { get { return _MakeDotMemorySnapshot; }}
    [NotNull] public RdEndpoint<RdVoid, RdVoid> ClearStaticCaches { get { return _ClearStaticCaches; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.ProfilingSession> ProfilingSession { get { return _ProfilingSession; }}
    [NotNull] public IViewableMap<int, int> RiderInternalProcesses { get { return _RiderInternalProcesses; }}
    [NotNull] public IRdProperty<bool> Initialized { get { return _Initialized; }}
    [NotNull] public IRdProperty<bool> ShutdownRequest { get { return _ShutdownRequest; }}
    [NotNull] public ISink<RdVoid> AfterCloseSolution { get { return _AfterCloseSolution; }}
    [NotNull] public IRdProperty<bool> CachesCorrupted { get { return _CachesCorrupted; }}
    [NotNull] public IViewableMap<int, string> IconStrings { get { return _IconStrings; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.LookAndFeelTheme> LookAndFeelTheme { get { return _LookAndFeelTheme; }}
    [NotNull] public IRdProperty<bool> PersistSolutionCaches { get { return _PersistSolutionCaches; }}
    [NotNull] public RdEndpoint<RdVoid, RdVoid> LogException { get { return _LogException; }}
    [NotNull] public RdEndpoint<RdVoid, string> StartMonitoring { get { return _StartMonitoring; }}
    [NotNull] public IRdProperty<string> WaveMarketingName { get { return _WaveMarketingName; }}
    [NotNull] public IRdProperty<bool> IsApplicationActive { get { return _IsApplicationActive; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<ExpectedMemoryUsage, long> _GetTotalMemory;
    [NotNull] private readonly RdEndpoint<int, int> _GetZombieSolutionCount;
    [NotNull] private readonly RdEndpoint<string, bool> _MakeDotMemorySnapshot;
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _ClearStaticCaches;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.ProfilingSession> _ProfilingSession;
    [NotNull] private readonly RdMap<int, int> _RiderInternalProcesses;
    [NotNull] private readonly RdProperty<bool> _Initialized;
    [NotNull] private readonly RdProperty<bool> _ShutdownRequest;
    [NotNull] private readonly RdSignal<RdVoid> _AfterCloseSolution;
    [NotNull] private readonly RdProperty<bool> _CachesCorrupted;
    [NotNull] private readonly RdMap<int, string> _IconStrings;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.LookAndFeelTheme> _LookAndFeelTheme;
    [NotNull] private readonly RdProperty<bool> _PersistSolutionCaches;
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _LogException;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _StartMonitoring;
    [NotNull] private readonly RdProperty<string> _WaveMarketingName;
    [NotNull] private readonly RdProperty<bool> _IsApplicationActive;
    
    //primary constructor
    private RdShellModel(
      [NotNull] RdEndpoint<ExpectedMemoryUsage, long> getTotalMemory,
      [NotNull] RdEndpoint<int, int> getZombieSolutionCount,
      [NotNull] RdEndpoint<string, bool> makeDotMemorySnapshot,
      [NotNull] RdEndpoint<RdVoid, RdVoid> clearStaticCaches,
      [NotNull] RdProperty<JetBrains.Rider.Model.ProfilingSession> profilingSession,
      [NotNull] RdMap<int, int> riderInternalProcesses,
      [NotNull] RdProperty<bool> initialized,
      [NotNull] RdProperty<bool> shutdownRequest,
      [NotNull] RdSignal<RdVoid> afterCloseSolution,
      [NotNull] RdProperty<bool> cachesCorrupted,
      [NotNull] RdMap<int, string> iconStrings,
      [NotNull] RdProperty<JetBrains.Rider.Model.LookAndFeelTheme> lookAndFeelTheme,
      [NotNull] RdProperty<bool> persistSolutionCaches,
      [NotNull] RdEndpoint<RdVoid, RdVoid> logException,
      [NotNull] RdEndpoint<RdVoid, string> startMonitoring,
      [NotNull] RdProperty<string> waveMarketingName,
      [NotNull] RdProperty<bool> isApplicationActive
    )
    {
      if (getTotalMemory == null) throw new ArgumentNullException("getTotalMemory");
      if (getZombieSolutionCount == null) throw new ArgumentNullException("getZombieSolutionCount");
      if (makeDotMemorySnapshot == null) throw new ArgumentNullException("makeDotMemorySnapshot");
      if (clearStaticCaches == null) throw new ArgumentNullException("clearStaticCaches");
      if (profilingSession == null) throw new ArgumentNullException("profilingSession");
      if (riderInternalProcesses == null) throw new ArgumentNullException("riderInternalProcesses");
      if (initialized == null) throw new ArgumentNullException("initialized");
      if (shutdownRequest == null) throw new ArgumentNullException("shutdownRequest");
      if (afterCloseSolution == null) throw new ArgumentNullException("afterCloseSolution");
      if (cachesCorrupted == null) throw new ArgumentNullException("cachesCorrupted");
      if (iconStrings == null) throw new ArgumentNullException("iconStrings");
      if (lookAndFeelTheme == null) throw new ArgumentNullException("lookAndFeelTheme");
      if (persistSolutionCaches == null) throw new ArgumentNullException("persistSolutionCaches");
      if (logException == null) throw new ArgumentNullException("logException");
      if (startMonitoring == null) throw new ArgumentNullException("startMonitoring");
      if (waveMarketingName == null) throw new ArgumentNullException("waveMarketingName");
      if (isApplicationActive == null) throw new ArgumentNullException("isApplicationActive");
      
      _GetTotalMemory = getTotalMemory;
      _GetZombieSolutionCount = getZombieSolutionCount;
      _MakeDotMemorySnapshot = makeDotMemorySnapshot;
      _ClearStaticCaches = clearStaticCaches;
      _ProfilingSession = profilingSession;
      _RiderInternalProcesses = riderInternalProcesses;
      _Initialized = initialized;
      _ShutdownRequest = shutdownRequest;
      _AfterCloseSolution = afterCloseSolution;
      _CachesCorrupted = cachesCorrupted;
      _IconStrings = iconStrings;
      _LookAndFeelTheme = lookAndFeelTheme;
      _PersistSolutionCaches = persistSolutionCaches;
      _LogException = logException;
      _StartMonitoring = startMonitoring;
      _WaveMarketingName = waveMarketingName;
      _IsApplicationActive = isApplicationActive;
      _RiderInternalProcesses.OptimizeNested = true;
      _Initialized.OptimizeNested = true;
      _ShutdownRequest.OptimizeNested = true;
      _CachesCorrupted.OptimizeNested = true;
      _IconStrings.OptimizeNested = true;
      _LookAndFeelTheme.OptimizeNested = true;
      _PersistSolutionCaches.OptimizeNested = true;
      _WaveMarketingName.OptimizeNested = true;
      _IsApplicationActive.OptimizeNested = true;
      _CachesCorrupted.Async = true;
      _IconStrings.Async = true;
      _ProfilingSession.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("getTotalMemory", _GetTotalMemory));
      BindableChildren.Add(new KeyValuePair<string, object>("getZombieSolutionCount", _GetZombieSolutionCount));
      BindableChildren.Add(new KeyValuePair<string, object>("makeDotMemorySnapshot", _MakeDotMemorySnapshot));
      BindableChildren.Add(new KeyValuePair<string, object>("clearStaticCaches", _ClearStaticCaches));
      BindableChildren.Add(new KeyValuePair<string, object>("profilingSession", _ProfilingSession));
      BindableChildren.Add(new KeyValuePair<string, object>("riderInternalProcesses", _RiderInternalProcesses));
      BindableChildren.Add(new KeyValuePair<string, object>("initialized", _Initialized));
      BindableChildren.Add(new KeyValuePair<string, object>("shutdownRequest", _ShutdownRequest));
      BindableChildren.Add(new KeyValuePair<string, object>("afterCloseSolution", _AfterCloseSolution));
      BindableChildren.Add(new KeyValuePair<string, object>("cachesCorrupted", _CachesCorrupted));
      BindableChildren.Add(new KeyValuePair<string, object>("iconStrings", _IconStrings));
      BindableChildren.Add(new KeyValuePair<string, object>("lookAndFeelTheme", _LookAndFeelTheme));
      BindableChildren.Add(new KeyValuePair<string, object>("persistSolutionCaches", _PersistSolutionCaches));
      BindableChildren.Add(new KeyValuePair<string, object>("logException", _LogException));
      BindableChildren.Add(new KeyValuePair<string, object>("startMonitoring", _StartMonitoring));
      BindableChildren.Add(new KeyValuePair<string, object>("waveMarketingName", _WaveMarketingName));
      BindableChildren.Add(new KeyValuePair<string, object>("isApplicationActive", _IsApplicationActive));
    }
    //secondary constructor
    private RdShellModel (
    ) : this (
      new RdEndpoint<ExpectedMemoryUsage, long>(ExpectedMemoryUsage.Read, ExpectedMemoryUsage.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong),
      new RdEndpoint<int, int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdEndpoint<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.ProfilingSession>(ReadProfilingSessionNullable, WriteProfilingSessionNullable),
      new RdMap<int, int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdMap<int, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<JetBrains.Rider.Model.LookAndFeelTheme>(ReadLookAndFeelTheme, WriteLookAndFeelTheme),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.ProfilingSession> ReadProfilingSessionNullable = JetBrains.Rider.Model.ProfilingSession.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.LookAndFeelTheme> ReadLookAndFeelTheme = new CtxReadDelegate<JetBrains.Rider.Model.LookAndFeelTheme>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.LookAndFeelTheme>);
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.ProfilingSession> WriteProfilingSessionNullable = JetBrains.Rider.Model.ProfilingSession.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.LookAndFeelTheme> WriteLookAndFeelTheme = new CtxWriteDelegate<JetBrains.Rider.Model.LookAndFeelTheme>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.LookAndFeelTheme>);
    
    protected override long SerializationHash => 7872282067991635938L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<JetBrains.Rider.Model.LookAndFeelTheme>();
      serializers.Register(ExpectedMemoryUsage.Read, ExpectedMemoryUsage.Write);
      serializers.Register(JetBrains.Rider.Model.ProfilingSession.Read, JetBrains.Rider.Model.ProfilingSession.Write);
      serializers.RegisterEnum<SnapshotKind>();
      serializers.RegisterEnum<ProfilingSessionStatus>();
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public RdShellModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdShellModel (");
      using (printer.IndentCookie()) {
        printer.Print("getTotalMemory = "); _GetTotalMemory.PrintEx(printer); printer.Println();
        printer.Print("getZombieSolutionCount = "); _GetZombieSolutionCount.PrintEx(printer); printer.Println();
        printer.Print("makeDotMemorySnapshot = "); _MakeDotMemorySnapshot.PrintEx(printer); printer.Println();
        printer.Print("clearStaticCaches = "); _ClearStaticCaches.PrintEx(printer); printer.Println();
        printer.Print("profilingSession = "); _ProfilingSession.PrintEx(printer); printer.Println();
        printer.Print("riderInternalProcesses = "); _RiderInternalProcesses.PrintEx(printer); printer.Println();
        printer.Print("initialized = "); _Initialized.PrintEx(printer); printer.Println();
        printer.Print("shutdownRequest = "); _ShutdownRequest.PrintEx(printer); printer.Println();
        printer.Print("afterCloseSolution = "); _AfterCloseSolution.PrintEx(printer); printer.Println();
        printer.Print("cachesCorrupted = "); _CachesCorrupted.PrintEx(printer); printer.Println();
        printer.Print("iconStrings = "); _IconStrings.PrintEx(printer); printer.Println();
        printer.Print("lookAndFeelTheme = "); _LookAndFeelTheme.PrintEx(printer); printer.Println();
        printer.Print("persistSolutionCaches = "); _PersistSolutionCaches.PrintEx(printer); printer.Println();
        printer.Print("logException = "); _LogException.PrintEx(printer); printer.Println();
        printer.Print("startMonitoring = "); _StartMonitoring.PrintEx(printer); printer.Println();
        printer.Print("waveMarketingName = "); _WaveMarketingName.PrintEx(printer); printer.Println();
        printer.Print("isApplicationActive = "); _IsApplicationActive.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExpectedMemoryUsage : IPrintable, IEquatable<ExpectedMemoryUsage>
  {
    //fields
    //public fields
    public int From {get; private set;}
    public int To {get; private set;}
    
    //private fields
    //primary constructor
    public ExpectedMemoryUsage(
      int from,
      int to
    )
    {
      From = from;
      To = to;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ExpectedMemoryUsage> Read = (ctx, reader) => 
    {
      var from = reader.ReadInt();
      var to = reader.ReadInt();
      return new ExpectedMemoryUsage(from, to);
    };
    
    public static CtxWriteDelegate<ExpectedMemoryUsage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.From);
      writer.Write(value.To);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ExpectedMemoryUsage) obj);
    }
    public bool Equals(ExpectedMemoryUsage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return From == other.From && To == other.To;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + From.GetHashCode();
        hash = hash * 31 + To.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ExpectedMemoryUsage (");
      using (printer.IndentCookie()) {
        printer.Print("from = "); From.PrintEx(printer); printer.Println();
        printer.Print("to = "); To.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum LookAndFeelTheme {
    Darcula,
    IntelliJ,
    Windows
  }
  
  
  public class ProfilingSession : RdBindableBase
  {
    //fields
    //public fields
    public JetBrains.Rider.Model.SnapshotKind SnapshotKind {get; private set;}
    [NotNull] public IAsyncRdSignal<RdVoid> Stop { get { return _Stop; }}
    [NotNull] public IRdProperty<ProfilingSessionStatus> Status { get { return _Status; }}
    [NotNull] public IRdProperty<string> Result { get { return _Result; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Stop;
    [NotNull] private readonly RdProperty<ProfilingSessionStatus> _Status;
    [NotNull] private readonly RdProperty<string> _Result;
    
    //primary constructor
    private ProfilingSession(
      JetBrains.Rider.Model.SnapshotKind snapshotKind,
      [NotNull] RdSignal<RdVoid> stop,
      [NotNull] RdProperty<ProfilingSessionStatus> status,
      [NotNull] RdProperty<string> result
    )
    {
      if (stop == null) throw new ArgumentNullException("stop");
      if (status == null) throw new ArgumentNullException("status");
      if (result == null) throw new ArgumentNullException("result");
      
      SnapshotKind = snapshotKind;
      _Stop = stop;
      _Status = status;
      _Result = result;
      _Status.OptimizeNested = true;
      _Result.OptimizeNested = true;
      _Stop.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("stop", _Stop));
      BindableChildren.Add(new KeyValuePair<string, object>("status", _Status));
      BindableChildren.Add(new KeyValuePair<string, object>("result", _Result));
    }
    //secondary constructor
    public ProfilingSession (
      JetBrains.Rider.Model.SnapshotKind snapshotKind
    ) : this (
      snapshotKind,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ProfilingSessionStatus>(ReadProfilingSessionStatus, WriteProfilingSessionStatus),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<ProfilingSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var snapshotKind = (JetBrains.Rider.Model.SnapshotKind)reader.ReadInt();
      var stop = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var status = RdProperty<ProfilingSessionStatus>.Read(ctx, reader, ReadProfilingSessionStatus, WriteProfilingSessionStatus);
      var result = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new ProfilingSession(snapshotKind, stop, status, result).WithId(_id);
    };
    public static CtxReadDelegate<ProfilingSessionStatus> ReadProfilingSessionStatus = new CtxReadDelegate<ProfilingSessionStatus>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ProfilingSessionStatus>);
    
    public static CtxWriteDelegate<ProfilingSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write((int)value.SnapshotKind);
      RdSignal<RdVoid>.Write(ctx, writer, value._Stop);
      RdProperty<ProfilingSessionStatus>.Write(ctx, writer, value._Status);
      RdProperty<string>.Write(ctx, writer, value._Result);
    };
    public static CtxWriteDelegate<ProfilingSessionStatus> WriteProfilingSessionStatus = new CtxWriteDelegate<ProfilingSessionStatus>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ProfilingSessionStatus>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProfilingSession (");
      using (printer.IndentCookie()) {
        printer.Print("snapshotKind = "); SnapshotKind.PrintEx(printer); printer.Println();
        printer.Print("stop = "); _Stop.PrintEx(printer); printer.Println();
        printer.Print("status = "); _Status.PrintEx(printer); printer.Println();
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ProfilingSessionStatus {
    Initialized,
    Attached,
    Started,
    Stopped,
    Detached,
    Failed
  }
  
  
  public enum SnapshotKind {
    Memory,
    Sampling,
    Timeline
  }
}
