using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RiderSolutionLifecycle : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsProjectModelReady { get { return _IsProjectModelReady; }}
    [NotNull] public IRdProperty<bool> SolutionBuilderReady { get { return _SolutionBuilderReady; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsProjectModelReady;
    [NotNull] private readonly RdProperty<bool> _SolutionBuilderReady;
    
    //primary constructor
    private RiderSolutionLifecycle(
      [NotNull] RdProperty<bool> isProjectModelReady,
      [NotNull] RdProperty<bool> solutionBuilderReady
    )
    {
      if (isProjectModelReady == null) throw new ArgumentNullException("isProjectModelReady");
      if (solutionBuilderReady == null) throw new ArgumentNullException("solutionBuilderReady");
      
      _IsProjectModelReady = isProjectModelReady;
      _SolutionBuilderReady = solutionBuilderReady;
      _IsProjectModelReady.OptimizeNested = true;
      _SolutionBuilderReady.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isProjectModelReady", _IsProjectModelReady));
      BindableChildren.Add(new KeyValuePair<string, object>("solutionBuilderReady", _SolutionBuilderReady));
    }
    //secondary constructor
    internal RiderSolutionLifecycle (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 6829755031730723356L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RiderSolutionLifecycle (");
      using (printer.IndentCookie()) {
        printer.Print("isProjectModelReady = "); _IsProjectModelReady.PrintEx(printer); printer.Println();
        printer.Print("solutionBuilderReady = "); _SolutionBuilderReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionRiderSolutionLifecycleEx
   {
    public static RiderSolutionLifecycle GetRiderSolutionLifecycle(this Solution solution)
    {
      return solution.GetOrCreateExtension("riderSolutionLifecycle", () => new RiderSolutionLifecycle());
    }
  }
}
