using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RoslynFrontendModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> AnalyzersPresent { get { return _AnalyzersPresent; }}
    [NotNull] public IRdProperty<bool> RoslynEnabled { get { return _RoslynEnabled; }}
    [NotNull] public IRdProperty<bool> RoslynReady { get { return _RoslynReady; }}
    [NotNull] public ISink<bool> SetRoslynEnabled { get { return _SetRoslynEnabled; }}
    [NotNull] public IRdProperty<bool> TransferErrors { get { return _TransferErrors; }}
    [NotNull] public IViewableList<RoslynBackendToFrontendError> RoslynErrors { get { return _RoslynErrors; }}
    [NotNull] public IRdProperty<RoslynStatusIcon> StatusBarIcon { get { return _StatusBarIcon; }}
    [NotNull] public IRdProperty<string> LastPerformedAction { get { return _LastPerformedAction; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _AnalyzersPresent;
    [NotNull] private readonly RdProperty<bool> _RoslynEnabled;
    [NotNull] private readonly RdProperty<bool> _RoslynReady;
    [NotNull] private readonly RdSignal<bool> _SetRoslynEnabled;
    [NotNull] private readonly RdProperty<bool> _TransferErrors;
    [NotNull] private readonly RdList<RoslynBackendToFrontendError> _RoslynErrors;
    [NotNull] private readonly RdProperty<RoslynStatusIcon> _StatusBarIcon;
    [NotNull] private readonly RdProperty<string> _LastPerformedAction;
    
    //primary constructor
    private RoslynFrontendModel(
      [NotNull] RdProperty<bool> analyzersPresent,
      [NotNull] RdProperty<bool> roslynEnabled,
      [NotNull] RdProperty<bool> roslynReady,
      [NotNull] RdSignal<bool> setRoslynEnabled,
      [NotNull] RdProperty<bool> transferErrors,
      [NotNull] RdList<RoslynBackendToFrontendError> roslynErrors,
      [NotNull] RdProperty<RoslynStatusIcon> statusBarIcon,
      [NotNull] RdProperty<string> lastPerformedAction
    )
    {
      if (analyzersPresent == null) throw new ArgumentNullException("analyzersPresent");
      if (roslynEnabled == null) throw new ArgumentNullException("roslynEnabled");
      if (roslynReady == null) throw new ArgumentNullException("roslynReady");
      if (setRoslynEnabled == null) throw new ArgumentNullException("setRoslynEnabled");
      if (transferErrors == null) throw new ArgumentNullException("transferErrors");
      if (roslynErrors == null) throw new ArgumentNullException("roslynErrors");
      if (statusBarIcon == null) throw new ArgumentNullException("statusBarIcon");
      if (lastPerformedAction == null) throw new ArgumentNullException("lastPerformedAction");
      
      _AnalyzersPresent = analyzersPresent;
      _RoslynEnabled = roslynEnabled;
      _RoslynReady = roslynReady;
      _SetRoslynEnabled = setRoslynEnabled;
      _TransferErrors = transferErrors;
      _RoslynErrors = roslynErrors;
      _StatusBarIcon = statusBarIcon;
      _LastPerformedAction = lastPerformedAction;
      _AnalyzersPresent.OptimizeNested = true;
      _RoslynEnabled.OptimizeNested = true;
      _RoslynReady.OptimizeNested = true;
      _TransferErrors.OptimizeNested = true;
      _RoslynErrors.OptimizeNested = true;
      _StatusBarIcon.OptimizeNested = true;
      _LastPerformedAction.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("analyzersPresent", _AnalyzersPresent));
      BindableChildren.Add(new KeyValuePair<string, object>("roslynEnabled", _RoslynEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("roslynReady", _RoslynReady));
      BindableChildren.Add(new KeyValuePair<string, object>("setRoslynEnabled", _SetRoslynEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("transferErrors", _TransferErrors));
      BindableChildren.Add(new KeyValuePair<string, object>("roslynErrors", _RoslynErrors));
      BindableChildren.Add(new KeyValuePair<string, object>("statusBarIcon", _StatusBarIcon));
      BindableChildren.Add(new KeyValuePair<string, object>("lastPerformedAction", _LastPerformedAction));
    }
    //secondary constructor
    internal RoslynFrontendModel (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdList<RoslynBackendToFrontendError>(RoslynBackendToFrontendError.Read, RoslynBackendToFrontendError.Write),
      new RdProperty<RoslynStatusIcon>(RoslynStatusIcon.Read, RoslynStatusIcon.Write),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -8388479790704116989L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RoslynSettingsTreeModel.Read, RoslynSettingsTreeModel.Write);
      serializers.Register(RoslynBackendToFrontendError.Read, RoslynBackendToFrontendError.Write);
      serializers.Register(RoslynStatusIcon.Read, RoslynStatusIcon.Write);
      serializers.Register(RoslynInspectionInSettings.Read, RoslynInspectionInSettings.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RoslynFrontendModel (");
      using (printer.IndentCookie()) {
        printer.Print("analyzersPresent = "); _AnalyzersPresent.PrintEx(printer); printer.Println();
        printer.Print("roslynEnabled = "); _RoslynEnabled.PrintEx(printer); printer.Println();
        printer.Print("roslynReady = "); _RoslynReady.PrintEx(printer); printer.Println();
        printer.Print("setRoslynEnabled = "); _SetRoslynEnabled.PrintEx(printer); printer.Println();
        printer.Print("transferErrors = "); _TransferErrors.PrintEx(printer); printer.Println();
        printer.Print("roslynErrors = "); _RoslynErrors.PrintEx(printer); printer.Println();
        printer.Print("statusBarIcon = "); _StatusBarIcon.PrintEx(printer); printer.Println();
        printer.Print("lastPerformedAction = "); _LastPerformedAction.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionRoslynFrontendModelEx
   {
    public static RoslynFrontendModel GetRoslynFrontendModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("roslynFrontendModel", () => new RoslynFrontendModel());
    }
  }
  
  
  public class RoslynBackendToFrontendError : IPrintable, IEquatable<RoslynBackendToFrontendError>
  {
    //fields
    //public fields
    [NotNull] public string ProjectName {get; private set;}
    [NotNull] public string Text {get; private set;}
    public bool IsError {get; private set;}
    
    //private fields
    //primary constructor
    public RoslynBackendToFrontendError(
      [NotNull] string projectName,
      [NotNull] string text,
      bool isError
    )
    {
      if (projectName == null) throw new ArgumentNullException("projectName");
      if (text == null) throw new ArgumentNullException("text");
      
      ProjectName = projectName;
      Text = text;
      IsError = isError;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RoslynBackendToFrontendError> Read = (ctx, reader) => 
    {
      var projectName = reader.ReadString();
      var text = reader.ReadString();
      var isError = reader.ReadBool();
      return new RoslynBackendToFrontendError(projectName, text, isError);
    };
    
    public static CtxWriteDelegate<RoslynBackendToFrontendError> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectName);
      writer.Write(value.Text);
      writer.Write(value.IsError);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RoslynBackendToFrontendError) obj);
    }
    public bool Equals(RoslynBackendToFrontendError other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectName == other.ProjectName && Text == other.Text && IsError == other.IsError;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectName.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + IsError.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RoslynBackendToFrontendError (");
      using (printer.IndentCookie()) {
        printer.Print("projectName = "); ProjectName.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isError = "); IsError.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RoslynInspectionInSettings : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Category {get; private set;}
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] public JetBrains.Rider.Model.Severity Severity {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    
    //primary constructor
    private RoslynInspectionInSettings(
      [NotNull] string title,
      [NotNull] string category,
      [NotNull] RdProperty<bool> isSelected,
      [NotNull] JetBrains.Rider.Model.Severity severity
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (category == null) throw new ArgumentNullException("category");
      if (isSelected == null) throw new ArgumentNullException("isSelected");
      if (severity == null) throw new ArgumentNullException("severity");
      
      Title = title;
      Category = category;
      _IsSelected = isSelected;
      Severity = severity;
      _IsSelected.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isSelected", _IsSelected));
      BindableChildren.Add(new KeyValuePair<string, object>("severity", Severity));
    }
    //secondary constructor
    public RoslynInspectionInSettings (
      [NotNull] string title,
      [NotNull] string category,
      [NotNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      title,
      category,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      severity
    ) {}
    //statics
    
    public static CtxReadDelegate<RoslynInspectionInSettings> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var category = reader.ReadString();
      var isSelected = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var severity = JetBrains.Rider.Model.Severity.Read(ctx, reader);
      return new RoslynInspectionInSettings(title, category, isSelected, severity).WithId(_id);
    };
    
    public static CtxWriteDelegate<RoslynInspectionInSettings> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Category);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
      JetBrains.Rider.Model.Severity.Write(ctx, writer, value.Severity);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RoslynInspectionInSettings (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("category = "); Category.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RoslynSettingsTreeModel : JetBrains.Rider.Model.UIAutomation.BeControl
  {
    //fields
    //public fields
    [NotNull] public IViewableList<RoslynInspectionInSettings> Inspections { get { return _Inspections; }}
    [NotNull] public IRdProperty<string> DescriptionText { get { return _DescriptionText; }}
    
    //private fields
    [NotNull] private readonly RdList<RoslynInspectionInSettings> _Inspections;
    [NotNull] private readonly RdProperty<string> _DescriptionText;
    
    //primary constructor
    private RoslynSettingsTreeModel(
      [NotNull] RdList<RoslynInspectionInSettings> inspections,
      [NotNull] RdProperty<string> descriptionText,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (inspections == null) throw new ArgumentNullException("inspections");
      if (descriptionText == null) throw new ArgumentNullException("descriptionText");
      
      _Inspections = inspections;
      _DescriptionText = descriptionText;
      _DescriptionText.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("inspections", _Inspections));
      BindableChildren.Add(new KeyValuePair<string, object>("descriptionText", _DescriptionText));
    }
    //secondary constructor
    public RoslynSettingsTreeModel (
    ) : this (
      new RdList<RoslynInspectionInSettings>(RoslynInspectionInSettings.Read, RoslynInspectionInSettings.Write),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RoslynSettingsTreeModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var inspections = RdList<RoslynInspectionInSettings>.Read(ctx, reader, RoslynInspectionInSettings.Read, RoslynInspectionInSettings.Write);
      var descriptionText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RoslynSettingsTreeModel(inspections, descriptionText, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<RoslynSettingsTreeModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      RdList<RoslynInspectionInSettings>.Write(ctx, writer, value._Inspections);
      RdProperty<string>.Write(ctx, writer, value._DescriptionText);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RoslynSettingsTreeModel (");
      using (printer.IndentCookie()) {
        printer.Print("inspections = "); _Inspections.PrintEx(printer); printer.Println();
        printer.Print("descriptionText = "); _DescriptionText.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RoslynStatusIcon : IPrintable, IEquatable<RoslynStatusIcon>
  {
    //fields
    //public fields
    public bool IsWorking {get; private set;}
    public bool HasIssues {get; private set;}
    [NotNull] public string Tooltip {get; private set;}
    
    //private fields
    //primary constructor
    public RoslynStatusIcon(
      bool isWorking,
      bool hasIssues,
      [NotNull] string tooltip
    )
    {
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      
      IsWorking = isWorking;
      HasIssues = hasIssues;
      Tooltip = tooltip;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RoslynStatusIcon> Read = (ctx, reader) => 
    {
      var isWorking = reader.ReadBool();
      var hasIssues = reader.ReadBool();
      var tooltip = reader.ReadString();
      return new RoslynStatusIcon(isWorking, hasIssues, tooltip);
    };
    
    public static CtxWriteDelegate<RoslynStatusIcon> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsWorking);
      writer.Write(value.HasIssues);
      writer.Write(value.Tooltip);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RoslynStatusIcon) obj);
    }
    public bool Equals(RoslynStatusIcon other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsWorking == other.IsWorking && HasIssues == other.HasIssues && Tooltip == other.Tooltip;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsWorking.GetHashCode();
        hash = hash * 31 + HasIssues.GetHashCode();
        hash = hash * 31 + Tooltip.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RoslynStatusIcon (");
      using (printer.IndentCookie()) {
        printer.Print("isWorking = "); IsWorking.PrintEx(printer); printer.Println();
        printer.Print("hasIssues = "); HasIssues.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
