using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RunnableProjectsModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<RunnableProject>> Projects { get { return _Projects; }}
    [NotNull] public RdEndpoint<GetProjectPropertiesArgs, List<GetProjectPropertyResult>> GetProjectProperties { get { return _GetProjectProperties; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<RunnableProject>> _Projects;
    [NotNull] private readonly RdEndpoint<GetProjectPropertiesArgs, List<GetProjectPropertyResult>> _GetProjectProperties;
    
    //primary constructor
    private RunnableProjectsModel(
      [NotNull] RdProperty<List<RunnableProject>> projects,
      [NotNull] RdEndpoint<GetProjectPropertiesArgs, List<GetProjectPropertyResult>> getProjectProperties
    )
    {
      if (projects == null) throw new ArgumentNullException("projects");
      if (getProjectProperties == null) throw new ArgumentNullException("getProjectProperties");
      
      _Projects = projects;
      _GetProjectProperties = getProjectProperties;
      _Projects.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("projects", _Projects));
      BindableChildren.Add(new KeyValuePair<string, object>("getProjectProperties", _GetProjectProperties));
    }
    //secondary constructor
    internal RunnableProjectsModel (
    ) : this (
      new RdProperty<List<RunnableProject>>(ReadRunnableProjectList, WriteRunnableProjectList),
      new RdEndpoint<GetProjectPropertiesArgs, List<GetProjectPropertyResult>>(GetProjectPropertiesArgs.Read, GetProjectPropertiesArgs.Write, ReadGetProjectPropertyResultList, WriteGetProjectPropertyResultList)
    ) {}
    //statics
    
    public static CtxReadDelegate<List<RunnableProject>> ReadRunnableProjectList = RunnableProject.Read.List();
    public static CtxReadDelegate<List<GetProjectPropertyResult>> ReadGetProjectPropertyResultList = GetProjectPropertyResult.Read.List();
    
    public static CtxWriteDelegate<List<RunnableProject>> WriteRunnableProjectList = RunnableProject.Write.List();
    public static CtxWriteDelegate<List<GetProjectPropertyResult>> WriteGetProjectPropertyResultList = GetProjectPropertyResult.Write.List();
    
    protected override long SerializationHash => 5576434116864211105L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<RunnableProjectKind>();
      serializers.Register(ProjectOutput.Read, ProjectOutput.Write);
      serializers.RegisterEnum<Key>();
      serializers.Register(CustomAttribute.Read, CustomAttribute.Write);
      serializers.Register(RunnableProject.Read, RunnableProject.Write);
      serializers.Register(GetProjectPropertiesArgs.Read, GetProjectPropertiesArgs.Write);
      serializers.Register(GetProjectPropertyResult.Read, GetProjectPropertyResult.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RunnableProjectsModel (");
      using (printer.IndentCookie()) {
        printer.Print("projects = "); _Projects.PrintEx(printer); printer.Println();
        printer.Print("getProjectProperties = "); _GetProjectProperties.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionRunnableProjectsModelEx
   {
    public static RunnableProjectsModel GetRunnableProjectsModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("runnableProjectsModel", () => new RunnableProjectsModel());
    }
  }
  
  
  public class CustomAttribute : IPrintable, IEquatable<CustomAttribute>
  {
    //fields
    //public fields
    public JetBrains.Rider.Model.Key Key {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public CustomAttribute(
      JetBrains.Rider.Model.Key key,
      [NotNull] string value
    )
    {
      if (value == null) throw new ArgumentNullException("value");
      
      Key = key;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CustomAttribute> Read = (ctx, reader) => 
    {
      var key = (JetBrains.Rider.Model.Key)reader.ReadInt();
      var value = reader.ReadString();
      return new CustomAttribute(key, value);
    };
    
    public static CtxWriteDelegate<CustomAttribute> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Key);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CustomAttribute) obj);
    }
    public bool Equals(CustomAttribute other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Key == other.Key && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Key;
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CustomAttribute (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetProjectPropertiesArgs : IPrintable, IEquatable<GetProjectPropertiesArgs>
  {
    //fields
    //public fields
    [NotNull] public string ProjectFilePath {get; private set;}
    [NotNull] public List<string> PropertyNames {get; private set;}
    
    //private fields
    //primary constructor
    public GetProjectPropertiesArgs(
      [NotNull] string projectFilePath,
      [NotNull] List<string> propertyNames
    )
    {
      if (projectFilePath == null) throw new ArgumentNullException("projectFilePath");
      if (propertyNames == null) throw new ArgumentNullException("propertyNames");
      
      ProjectFilePath = projectFilePath;
      PropertyNames = propertyNames;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetProjectPropertiesArgs> Read = (ctx, reader) => 
    {
      var projectFilePath = reader.ReadString();
      var propertyNames = ReadStringList(ctx, reader);
      return new GetProjectPropertiesArgs(projectFilePath, propertyNames);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<GetProjectPropertiesArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectFilePath);
      WriteStringList(ctx, writer, value.PropertyNames);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetProjectPropertiesArgs) obj);
    }
    public bool Equals(GetProjectPropertiesArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectFilePath == other.ProjectFilePath && PropertyNames.SequenceEqual(other.PropertyNames);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(PropertyNames);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetProjectPropertiesArgs (");
      using (printer.IndentCookie()) {
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
        printer.Print("propertyNames = "); PropertyNames.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GetProjectPropertyResult : IPrintable, IEquatable<GetProjectPropertyResult>
  {
    //fields
    //public fields
    [NotNull] public string PropertyName {get; private set;}
    [NotNull] public string PropertyValue {get; private set;}
    
    //private fields
    //primary constructor
    public GetProjectPropertyResult(
      [NotNull] string propertyName,
      [NotNull] string propertyValue
    )
    {
      if (propertyName == null) throw new ArgumentNullException("propertyName");
      if (propertyValue == null) throw new ArgumentNullException("propertyValue");
      
      PropertyName = propertyName;
      PropertyValue = propertyValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GetProjectPropertyResult> Read = (ctx, reader) => 
    {
      var propertyName = reader.ReadString();
      var propertyValue = reader.ReadString();
      return new GetProjectPropertyResult(propertyName, propertyValue);
    };
    
    public static CtxWriteDelegate<GetProjectPropertyResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.PropertyName);
      writer.Write(value.PropertyValue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GetProjectPropertyResult) obj);
    }
    public bool Equals(GetProjectPropertyResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return PropertyName == other.PropertyName && PropertyValue == other.PropertyValue;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + PropertyName.GetHashCode();
        hash = hash * 31 + PropertyValue.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GetProjectPropertyResult (");
      using (printer.IndentCookie()) {
        printer.Print("propertyName = "); PropertyName.PrintEx(printer); printer.Println();
        printer.Print("propertyValue = "); PropertyValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum Key {
    StartBrowserUrl,
    InfoPlistPath,
    MTouchArch,
    IOSDebuggerPort,
    IOSDebugOverWiFi,
    CodesignKey,
    LaunchBrowser,
    AssemblyName,
    AndroidTargetApiLevel,
    AndroidManifestRelativePath,
    AndroidResourcesRelativePath,
    AndroidAssetsRelativePath
  }
  
  
  public class ProjectOutput : IPrintable, IEquatable<ProjectOutput>
  {
    //fields
    //public fields
    [NotNull] public string Tfm {get; private set;}
    [NotNull] public string ExePath {get; private set;}
    [NotNull] public List<string> DefaultArguments {get; private set;}
    [NotNull] public string WorkingDirectory {get; private set;}
    [NotNull] public string DotNetCorePlatformRoot {get; private set;}
    
    //private fields
    //primary constructor
    public ProjectOutput(
      [NotNull] string tfm,
      [NotNull] string exePath,
      [NotNull] List<string> defaultArguments,
      [NotNull] string workingDirectory,
      [NotNull] string dotNetCorePlatformRoot
    )
    {
      if (tfm == null) throw new ArgumentNullException("tfm");
      if (exePath == null) throw new ArgumentNullException("exePath");
      if (defaultArguments == null) throw new ArgumentNullException("defaultArguments");
      if (workingDirectory == null) throw new ArgumentNullException("workingDirectory");
      if (dotNetCorePlatformRoot == null) throw new ArgumentNullException("dotNetCorePlatformRoot");
      
      Tfm = tfm;
      ExePath = exePath;
      DefaultArguments = defaultArguments;
      WorkingDirectory = workingDirectory;
      DotNetCorePlatformRoot = dotNetCorePlatformRoot;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectOutput> Read = (ctx, reader) => 
    {
      var tfm = reader.ReadString();
      var exePath = reader.ReadString();
      var defaultArguments = ReadStringList(ctx, reader);
      var workingDirectory = reader.ReadString();
      var dotNetCorePlatformRoot = reader.ReadString();
      return new ProjectOutput(tfm, exePath, defaultArguments, workingDirectory, dotNetCorePlatformRoot);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<ProjectOutput> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Tfm);
      writer.Write(value.ExePath);
      WriteStringList(ctx, writer, value.DefaultArguments);
      writer.Write(value.WorkingDirectory);
      writer.Write(value.DotNetCorePlatformRoot);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectOutput) obj);
    }
    public bool Equals(ProjectOutput other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Tfm == other.Tfm && ExePath == other.ExePath && DefaultArguments.SequenceEqual(other.DefaultArguments) && WorkingDirectory == other.WorkingDirectory && DotNetCorePlatformRoot == other.DotNetCorePlatformRoot;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Tfm.GetHashCode();
        hash = hash * 31 + ExePath.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(DefaultArguments);
        hash = hash * 31 + WorkingDirectory.GetHashCode();
        hash = hash * 31 + DotNetCorePlatformRoot.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectOutput (");
      using (printer.IndentCookie()) {
        printer.Print("tfm = "); Tfm.PrintEx(printer); printer.Println();
        printer.Print("exePath = "); ExePath.PrintEx(printer); printer.Println();
        printer.Print("defaultArguments = "); DefaultArguments.PrintEx(printer); printer.Println();
        printer.Print("workingDirectory = "); WorkingDirectory.PrintEx(printer); printer.Println();
        printer.Print("dotNetCorePlatformRoot = "); DotNetCorePlatformRoot.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RunnableProject : IPrintable, IEquatable<RunnableProject>
  {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string FullName {get; private set;}
    [NotNull] public string ProjectFilePath {get; private set;}
    public RunnableProjectKind Kind {get; private set;}
    [NotNull] public List<ProjectOutput> ProjectOutputs {get; private set;}
    [NotNull] public List<EnvironmentVariable> EnvironmentVariables {get; private set;}
    [CanBeNull] public string Problems {get; private set;}
    [NotNull] public List<CustomAttribute> CustomAttributes {get; private set;}
    
    //private fields
    //primary constructor
    public RunnableProject(
      [NotNull] string name,
      [NotNull] string fullName,
      [NotNull] string projectFilePath,
      RunnableProjectKind kind,
      [NotNull] List<ProjectOutput> projectOutputs,
      [NotNull] List<EnvironmentVariable> environmentVariables,
      [CanBeNull] string problems,
      [NotNull] List<CustomAttribute> customAttributes
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (fullName == null) throw new ArgumentNullException("fullName");
      if (projectFilePath == null) throw new ArgumentNullException("projectFilePath");
      if (projectOutputs == null) throw new ArgumentNullException("projectOutputs");
      if (environmentVariables == null) throw new ArgumentNullException("environmentVariables");
      if (customAttributes == null) throw new ArgumentNullException("customAttributes");
      
      Name = name;
      FullName = fullName;
      ProjectFilePath = projectFilePath;
      Kind = kind;
      ProjectOutputs = projectOutputs;
      EnvironmentVariables = environmentVariables;
      Problems = problems;
      CustomAttributes = customAttributes;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RunnableProject> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var fullName = reader.ReadString();
      var projectFilePath = reader.ReadString();
      var kind = (RunnableProjectKind)reader.ReadInt();
      var projectOutputs = ReadProjectOutputList(ctx, reader);
      var environmentVariables = ReadEnvironmentVariableList(ctx, reader);
      var problems = ReadStringNullable(ctx, reader);
      var customAttributes = ReadCustomAttributeList(ctx, reader);
      return new RunnableProject(name, fullName, projectFilePath, kind, projectOutputs, environmentVariables, problems, customAttributes);
    };
    public static CtxReadDelegate<List<ProjectOutput>> ReadProjectOutputList = ProjectOutput.Read.List();
    public static CtxReadDelegate<List<EnvironmentVariable>> ReadEnvironmentVariableList = EnvironmentVariable.Read.List();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<CustomAttribute>> ReadCustomAttributeList = CustomAttribute.Read.List();
    
    public static CtxWriteDelegate<RunnableProject> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.FullName);
      writer.Write(value.ProjectFilePath);
      writer.Write((int)value.Kind);
      WriteProjectOutputList(ctx, writer, value.ProjectOutputs);
      WriteEnvironmentVariableList(ctx, writer, value.EnvironmentVariables);
      WriteStringNullable(ctx, writer, value.Problems);
      WriteCustomAttributeList(ctx, writer, value.CustomAttributes);
    };
    public static CtxWriteDelegate<List<ProjectOutput>> WriteProjectOutputList = ProjectOutput.Write.List();
    public static CtxWriteDelegate<List<EnvironmentVariable>> WriteEnvironmentVariableList = EnvironmentVariable.Write.List();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<CustomAttribute>> WriteCustomAttributeList = CustomAttribute.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RunnableProject) obj);
    }
    public bool Equals(RunnableProject other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && FullName == other.FullName && ProjectFilePath == other.ProjectFilePath && Kind == other.Kind && ProjectOutputs.SequenceEqual(other.ProjectOutputs) && EnvironmentVariables.SequenceEqual(other.EnvironmentVariables) && Equals(Problems, other.Problems) && CustomAttributes.SequenceEqual(other.CustomAttributes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + FullName.GetHashCode();
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + Collections.GetHashCode(ProjectOutputs);
        hash = hash * 31 + Collections.GetHashCode(EnvironmentVariables);
        hash = hash * 31 + (Problems != null ?Problems.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(CustomAttributes);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RunnableProject (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("fullName = "); FullName.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("projectOutputs = "); ProjectOutputs.PrintEx(printer); printer.Println();
        printer.Print("environmentVariables = "); EnvironmentVariables.PrintEx(printer); printer.Println();
        printer.Print("problems = "); Problems.PrintEx(printer); printer.Println();
        printer.Print("customAttributes = "); CustomAttributes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RunnableProjectKind {
    None,
    Console,
    DotNetCore,
    LaunchSettings,
    Web,
    WcfService,
    XamarinAndroid,
    XamarinIOS,
    XamarinWatchOS,
    XamarinTvOS,
    XamarinMacOS,
    Unloaded,
    Uwp
  }
}
