using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class SandboxExt : RdExtBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private SandboxExt(
    )
    {
    }
    //secondary constructor
    //statics
    
    
    
    protected override long SerializationHash => 4007372014781936576L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<SandboxLanguage>();
      serializers.Register(SandboxInfo.Read, SandboxInfo.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public SandboxExt(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SandboxExt (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SandboxInfo : AbstractSandboxInfo
  {
    //fields
    //public fields
    [CanBeNull] public EditableEntityId CloneFrom {get; private set;}
    [CanBeNull] public string FullText {get; private set;}
    [CanBeNull] public RdTextRange Range {get; private set;}
    [NotNull] public List<string> ExtraImports {get; private set;}
    [NotNull] public List<string> ExtraModules {get; private set;}
    public bool DisableAltEnter {get; private set;}
    [NotNull] public List<char> DisableTypingAssists {get; private set;}
    public bool DisableTypingActions {get; private set;}
    public JetBrains.Rider.Model.SandboxLanguage SandboxLanguage {get; private set;}
    
    //private fields
    //primary constructor
    public SandboxInfo(
      [CanBeNull] EditableEntityId cloneFrom,
      [CanBeNull] string fullText,
      [CanBeNull] RdTextRange range,
      [NotNull] List<string> extraImports,
      [NotNull] List<string> extraModules,
      bool disableAltEnter,
      [NotNull] List<char> disableTypingAssists,
      bool disableTypingActions,
      JetBrains.Rider.Model.SandboxLanguage sandboxLanguage
    )
    {
      if (extraImports == null) throw new ArgumentNullException("extraImports");
      if (extraModules == null) throw new ArgumentNullException("extraModules");
      if (disableTypingAssists == null) throw new ArgumentNullException("disableTypingAssists");
      
      CloneFrom = cloneFrom;
      FullText = fullText;
      Range = range;
      ExtraImports = extraImports;
      ExtraModules = extraModules;
      DisableAltEnter = disableAltEnter;
      DisableTypingAssists = disableTypingAssists;
      DisableTypingActions = disableTypingActions;
      SandboxLanguage = sandboxLanguage;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SandboxInfo> Read = (ctx, reader) => 
    {
      var cloneFrom = ReadEditableEntityIdNullable(ctx, reader);
      var fullText = ReadStringNullable(ctx, reader);
      var range = ReadRdTextRangeNullable(ctx, reader);
      var extraImports = ReadStringList(ctx, reader);
      var extraModules = ReadStringList(ctx, reader);
      var disableAltEnter = reader.ReadBool();
      var disableTypingAssists = ReadCharList(ctx, reader);
      var disableTypingActions = reader.ReadBool();
      var sandboxLanguage = (JetBrains.Rider.Model.SandboxLanguage)reader.ReadInt();
      return new SandboxInfo(cloneFrom, fullText, range, extraImports, extraModules, disableAltEnter, disableTypingAssists, disableTypingActions, sandboxLanguage);
    };
    public static CtxReadDelegate<EditableEntityId> ReadEditableEntityIdNullable = EditableEntityId.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdTextRange> ReadRdTextRangeNullable = RdTextRange.Read.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<char>> ReadCharList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadChar.List();
    
    public static new CtxWriteDelegate<SandboxInfo> Write = (ctx, writer, value) => 
    {
      WriteEditableEntityIdNullable(ctx, writer, value.CloneFrom);
      WriteStringNullable(ctx, writer, value.FullText);
      WriteRdTextRangeNullable(ctx, writer, value.Range);
      WriteStringList(ctx, writer, value.ExtraImports);
      WriteStringList(ctx, writer, value.ExtraModules);
      writer.Write(value.DisableAltEnter);
      WriteCharList(ctx, writer, value.DisableTypingAssists);
      writer.Write(value.DisableTypingActions);
      writer.Write((int)value.SandboxLanguage);
    };
    public static CtxWriteDelegate<EditableEntityId> WriteEditableEntityIdNullable = EditableEntityId.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdTextRange> WriteRdTextRangeNullable = RdTextRange.Write.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<char>> WriteCharList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteChar.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SandboxInfo) obj);
    }
    public bool Equals(SandboxInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(CloneFrom, other.CloneFrom) && Equals(FullText, other.FullText) && Equals(Range, other.Range) && ExtraImports.SequenceEqual(other.ExtraImports) && ExtraModules.SequenceEqual(other.ExtraModules) && DisableAltEnter == other.DisableAltEnter && DisableTypingAssists.SequenceEqual(other.DisableTypingAssists) && DisableTypingActions == other.DisableTypingActions && SandboxLanguage == other.SandboxLanguage;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (CloneFrom != null ?CloneFrom.GetHashCode() : 0);
        hash = hash * 31 + (FullText != null ?FullText.GetHashCode() : 0);
        hash = hash * 31 + (Range != null ?Range.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(ExtraImports);
        hash = hash * 31 + Collections.GetHashCode(ExtraModules);
        hash = hash * 31 + DisableAltEnter.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(DisableTypingAssists);
        hash = hash * 31 + DisableTypingActions.GetHashCode();
        hash = hash * 31 + (int) SandboxLanguage;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SandboxInfo (");
      using (printer.IndentCookie()) {
        printer.Print("cloneFrom = "); CloneFrom.PrintEx(printer); printer.Println();
        printer.Print("fullText = "); FullText.PrintEx(printer); printer.Println();
        printer.Print("range = "); Range.PrintEx(printer); printer.Println();
        printer.Print("extraImports = "); ExtraImports.PrintEx(printer); printer.Println();
        printer.Print("extraModules = "); ExtraModules.PrintEx(printer); printer.Println();
        printer.Print("disableAltEnter = "); DisableAltEnter.PrintEx(printer); printer.Println();
        printer.Print("disableTypingAssists = "); DisableTypingAssists.PrintEx(printer); printer.Println();
        printer.Print("disableTypingActions = "); DisableTypingActions.PrintEx(printer); printer.Println();
        printer.Print("sandboxLanguage = "); SandboxLanguage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SandboxLanguage {
    CSharp,
    FSharp
  }
}
