using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class ServicesUtils : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public ISource<string> SetTextToClipboard { get { return _SetTextToClipboard; }}
    
    //private fields
    [NotNull] private readonly RdSignal<string> _SetTextToClipboard;
    
    //primary constructor
    private ServicesUtils(
      [NotNull] RdSignal<string> setTextToClipboard
    )
    {
      if (setTextToClipboard == null) throw new ArgumentNullException("setTextToClipboard");
      
      _SetTextToClipboard = setTextToClipboard;
      BindableChildren.Add(new KeyValuePair<string, object>("setTextToClipboard", _SetTextToClipboard));
    }
    //secondary constructor
    private ServicesUtils (
    ) : this (
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -763584159616661243L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public ServicesUtils(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ServicesUtils (");
      using (printer.IndentCookie()) {
        printer.Print("setTextToClipboard = "); _SetTextToClipboard.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
