using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class SettingsHelperModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] public IRdProperty<SessionModel> Session { get { return _Session; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsReady;
    [NotNull] private readonly RdProperty<SessionModel> _Session;
    
    //primary constructor
    private SettingsHelperModel(
      [NotNull] RdProperty<bool> isReady,
      [NotNull] RdProperty<SessionModel> session
    )
    {
      if (isReady == null) throw new ArgumentNullException("isReady");
      if (session == null) throw new ArgumentNullException("session");
      
      _IsReady = isReady;
      _Session = session;
      _IsReady.OptimizeNested = true;
      _Session.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isReady", _IsReady));
      BindableChildren.Add(new KeyValuePair<string, object>("session", _Session));
    }
    //secondary constructor
    private SettingsHelperModel (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<SessionModel>(ReadSessionModelNullable, WriteSessionModelNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<SessionModel> ReadSessionModelNullable = SessionModel.Read.NullableClass();
    
    public static CtxWriteDelegate<SessionModel> WriteSessionModelNullable = SessionModel.Write.NullableClass();
    
    protected override long SerializationHash => -2729874151364928354L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(SettingsCategory.Read, SettingsCategory.Write);
      serializers.Register(ExportSessionModel.Read, ExportSessionModel.Write);
      serializers.Register(ImportSessionModel.Read, ImportSessionModel.Write);
      serializers.Register(SessionModel_Unknown.Read, SessionModel_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public SettingsHelperModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsHelperModel (");
      using (printer.IndentCookie()) {
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
        printer.Print("session = "); _Session.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExportSessionModel : SessionModel
  {
    //fields
    //public fields
    [NotNull] public string LayerId {get; private set;}
    [NotNull] public RdEndpoint<List<string>, string> WriteToTempFile { get { return _WriteToTempFile; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<List<string>, string> _WriteToTempFile;
    
    //primary constructor
    private ExportSessionModel(
      [NotNull] string layerId,
      [NotNull] RdEndpoint<List<string>, string> writeToTempFile,
      [NotNull] RdEndpoint<RdVoid, List<SettingsCategory>> getAvailableSettingsCategory
    ) : base (
      getAvailableSettingsCategory
     ) 
    {
      if (layerId == null) throw new ArgumentNullException("layerId");
      if (writeToTempFile == null) throw new ArgumentNullException("writeToTempFile");
      
      LayerId = layerId;
      _WriteToTempFile = writeToTempFile;
      BindableChildren.Add(new KeyValuePair<string, object>("writeToTempFile", _WriteToTempFile));
    }
    //secondary constructor
    public ExportSessionModel (
      [NotNull] string layerId
    ) : this (
      layerId,
      new RdEndpoint<List<string>, string>(ReadStringList, WriteStringList, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<RdVoid, List<SettingsCategory>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadSettingsCategoryList, WriteSettingsCategoryList)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ExportSessionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var getAvailableSettingsCategory = RdEndpoint<RdVoid, List<SettingsCategory>>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadSettingsCategoryList, WriteSettingsCategoryList);
      var layerId = reader.ReadString();
      var writeToTempFile = RdEndpoint<List<string>, string>.Read(ctx, reader, ReadStringList, WriteStringList, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new ExportSessionModel(layerId, writeToTempFile, getAvailableSettingsCategory).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<SettingsCategory>> ReadSettingsCategoryList = SettingsCategory.Read.List();
    
    public static new CtxWriteDelegate<ExportSessionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdEndpoint<RdVoid, List<SettingsCategory>>.Write(ctx, writer, value._GetAvailableSettingsCategory);
      writer.Write(value.LayerId);
      RdEndpoint<List<string>, string>.Write(ctx, writer, value._WriteToTempFile);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<SettingsCategory>> WriteSettingsCategoryList = SettingsCategory.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExportSessionModel (");
      using (printer.IndentCookie()) {
        printer.Print("layerId = "); LayerId.PrintEx(printer); printer.Println();
        printer.Print("writeToTempFile = "); _WriteToTempFile.PrintEx(printer); printer.Println();
        printer.Print("getAvailableSettingsCategory = "); _GetAvailableSettingsCategory.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ImportSessionModel : SessionModel
  {
    //fields
    //public fields
    [NotNull] public string ExternalFile {get; private set;}
    [NotNull] public RdEndpoint<List<string>, bool> WriteToLayer { get { return _WriteToLayer; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<List<string>, bool> _WriteToLayer;
    
    //primary constructor
    private ImportSessionModel(
      [NotNull] string externalFile,
      [NotNull] RdEndpoint<List<string>, bool> writeToLayer,
      [NotNull] RdEndpoint<RdVoid, List<SettingsCategory>> getAvailableSettingsCategory
    ) : base (
      getAvailableSettingsCategory
     ) 
    {
      if (externalFile == null) throw new ArgumentNullException("externalFile");
      if (writeToLayer == null) throw new ArgumentNullException("writeToLayer");
      
      ExternalFile = externalFile;
      _WriteToLayer = writeToLayer;
      BindableChildren.Add(new KeyValuePair<string, object>("writeToLayer", _WriteToLayer));
    }
    //secondary constructor
    public ImportSessionModel (
      [NotNull] string externalFile
    ) : this (
      externalFile,
      new RdEndpoint<List<string>, bool>(ReadStringList, WriteStringList, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<RdVoid, List<SettingsCategory>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadSettingsCategoryList, WriteSettingsCategoryList)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ImportSessionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var getAvailableSettingsCategory = RdEndpoint<RdVoid, List<SettingsCategory>>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadSettingsCategoryList, WriteSettingsCategoryList);
      var externalFile = reader.ReadString();
      var writeToLayer = RdEndpoint<List<string>, bool>.Read(ctx, reader, ReadStringList, WriteStringList, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new ImportSessionModel(externalFile, writeToLayer, getAvailableSettingsCategory).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<SettingsCategory>> ReadSettingsCategoryList = SettingsCategory.Read.List();
    
    public static new CtxWriteDelegate<ImportSessionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdEndpoint<RdVoid, List<SettingsCategory>>.Write(ctx, writer, value._GetAvailableSettingsCategory);
      writer.Write(value.ExternalFile);
      RdEndpoint<List<string>, bool>.Write(ctx, writer, value._WriteToLayer);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<SettingsCategory>> WriteSettingsCategoryList = SettingsCategory.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ImportSessionModel (");
      using (printer.IndentCookie()) {
        printer.Print("externalFile = "); ExternalFile.PrintEx(printer); printer.Println();
        printer.Print("writeToLayer = "); _WriteToLayer.PrintEx(printer); printer.Println();
        printer.Print("getAvailableSettingsCategory = "); _GetAvailableSettingsCategory.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class SessionModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<RdVoid, List<SettingsCategory>> GetAvailableSettingsCategory { get { return _GetAvailableSettingsCategory; }}
    
    //private fields
    [NotNull] protected readonly RdEndpoint<RdVoid, List<SettingsCategory>> _GetAvailableSettingsCategory;
    
    //primary constructor
    protected SessionModel(
      [NotNull] RdEndpoint<RdVoid, List<SettingsCategory>> getAvailableSettingsCategory
    )
    {
      if (getAvailableSettingsCategory == null) throw new ArgumentNullException("getAvailableSettingsCategory");
      
      _GetAvailableSettingsCategory = getAvailableSettingsCategory;
      BindableChildren.Add(new KeyValuePair<string, object>("getAvailableSettingsCategory", _GetAvailableSettingsCategory));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SessionModel> Read = Polymorphic<SessionModel>.ReadAbstract(SessionModel_Unknown.Read);
    
    public static CtxWriteDelegate<SessionModel> Write = Polymorphic<SessionModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class SessionModel_Unknown : SessionModel
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private SessionModel_Unknown(
      [NotNull] RdEndpoint<RdVoid, List<SettingsCategory>> getAvailableSettingsCategory
    ) : base (
      getAvailableSettingsCategory
     ) 
    {
    }
    //secondary constructor
    public SessionModel_Unknown (
    ) : this (
      new RdEndpoint<RdVoid, List<SettingsCategory>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadSettingsCategoryList, WriteSettingsCategoryList)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SessionModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var getAvailableSettingsCategory = RdEndpoint<RdVoid, List<SettingsCategory>>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadSettingsCategoryList, WriteSettingsCategoryList);
      return new SessionModel_Unknown(getAvailableSettingsCategory).WithId(_id);
    };
    public static CtxReadDelegate<List<SettingsCategory>> ReadSettingsCategoryList = SettingsCategory.Read.List();
    
    public static new CtxWriteDelegate<SessionModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdEndpoint<RdVoid, List<SettingsCategory>>.Write(ctx, writer, value._GetAvailableSettingsCategory);
    };
    public static CtxWriteDelegate<List<SettingsCategory>> WriteSettingsCategoryList = SettingsCategory.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SessionModel_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("getAvailableSettingsCategory = "); _GetAvailableSettingsCategory.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsCategory : IPrintable, IEquatable<SettingsCategory>
  {
    //fields
    //public fields
    [NotNull] public string Key {get; private set;}
    [CanBeNull] public List<string> RelatedIdeaConfigs {get; private set;}
    
    //private fields
    //primary constructor
    public SettingsCategory(
      [NotNull] string key,
      [CanBeNull] List<string> relatedIdeaConfigs
    )
    {
      if (key == null) throw new ArgumentNullException("key");
      
      Key = key;
      RelatedIdeaConfigs = relatedIdeaConfigs;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SettingsCategory> Read = (ctx, reader) => 
    {
      var key = reader.ReadString();
      var relatedIdeaConfigs = ReadStringListNullable(ctx, reader);
      return new SettingsCategory(key, relatedIdeaConfigs);
    };
    public static CtxReadDelegate<List<string>> ReadStringListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List().NullableClass();
    
    public static CtxWriteDelegate<SettingsCategory> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Key);
      WriteStringListNullable(ctx, writer, value.RelatedIdeaConfigs);
    };
    public static CtxWriteDelegate<List<string>> WriteStringListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List().NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SettingsCategory) obj);
    }
    public bool Equals(SettingsCategory other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Key == other.Key && Equals(RelatedIdeaConfigs, other.RelatedIdeaConfigs);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Key.GetHashCode();
        hash = hash * 31 + (RelatedIdeaConfigs != null ?Collections.GetHashCode(RelatedIdeaConfigs) : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsCategory (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("relatedIdeaConfigs = "); RelatedIdeaConfigs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
