using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class SettingsViewModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.OptionsDialog> OptionsDialog { get { return _OptionsDialog; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.OptionsDialog> KeywordsDialog { get { return _KeywordsDialog; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.OptionsDialog> _OptionsDialog;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.OptionsDialog> _KeywordsDialog;
    
    //primary constructor
    private SettingsViewModel(
      [NotNull] RdProperty<JetBrains.Rider.Model.OptionsDialog> optionsDialog,
      [NotNull] RdProperty<JetBrains.Rider.Model.OptionsDialog> keywordsDialog
    )
    {
      if (optionsDialog == null) throw new ArgumentNullException("optionsDialog");
      if (keywordsDialog == null) throw new ArgumentNullException("keywordsDialog");
      
      _OptionsDialog = optionsDialog;
      _KeywordsDialog = keywordsDialog;
      BindableChildren.Add(new KeyValuePair<string, object>("optionsDialog", _OptionsDialog));
      BindableChildren.Add(new KeyValuePair<string, object>("keywordsDialog", _KeywordsDialog));
    }
    //secondary constructor
    private SettingsViewModel (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.OptionsDialog>(JetBrains.Rider.Model.OptionsDialog.Read, JetBrains.Rider.Model.OptionsDialog.Write),
      new RdProperty<JetBrains.Rider.Model.OptionsDialog>(JetBrains.Rider.Model.OptionsDialog.Read, JetBrains.Rider.Model.OptionsDialog.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 5443360919730804679L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(BoolOptionItem.Read, BoolOptionItem.Write);
      serializers.Register(IntOptionItem.Read, IntOptionItem.Write);
      serializers.Register(StringOptionItem.Read, StringOptionItem.Write);
      serializers.Register(RichTextOptionItem.Read, RichTextOptionItem.Write);
      serializers.Register(ComboOptionItem.Read, ComboOptionItem.Write);
      serializers.RegisterEnum<PathChooserType>();
      serializers.Register(StringSetOptionItem.Read, StringSetOptionItem.Write);
      serializers.Register(FileAndFolderSetOptionItem.Read, FileAndFolderSetOptionItem.Write);
      serializers.Register(TwoSidedOptionItem.Read, TwoSidedOptionItem.Write);
      serializers.Register(PathChooserOptionItem.Read, PathChooserOptionItem.Write);
      serializers.Register(RadioButtonOptionItem.Read, RadioButtonOptionItem.Write);
      serializers.Register(AutomationOptionItem.Read, AutomationOptionItem.Write);
      serializers.Register(SimpleOptionsPageContent.Read, SimpleOptionsPageContent.Write);
      serializers.Register(BeSimpleOptionsPageContent.Read, BeSimpleOptionsPageContent.Write);
      serializers.Register(CodeCleanupProfileCloneRequest.Read, CodeCleanupProfileCloneRequest.Write);
      serializers.Register(CodeCleanupOptionsPageContent.Read, CodeCleanupOptionsPageContent.Write);
      serializers.Register(CompositeOptionsPageContent.Read, CompositeOptionsPageContent.Write);
      serializers.RegisterEnum<NamingStyleKinds>();
      serializers.RegisterEnum<StyleItemState>();
      serializers.Register(NamingRule.Read, NamingRule.Write);
      serializers.Register(NamingPolicy.Read, NamingPolicy.Write);
      serializers.Register(NamingRuleItem.Read, NamingRuleItem.Write);
      serializers.Register(NamingPageContent.Read, NamingPageContent.Write);
      serializers.Register(CSharpNamingPageContent.Read, CSharpNamingPageContent.Write);
      serializers.Register(EnumWithValue.Read, EnumWithValue.Write);
      serializers.Register(RdColor.Read, RdColor.Write);
      serializers.Register(SeverityElement.Read, SeverityElement.Write);
      serializers.Register(Severity.Read, Severity.Write);
      serializers.Register(CodeStyleGroupOption.Read, CodeStyleGroupOption.Write);
      serializers.Register(CodeStyleBoolOption.Read, CodeStyleBoolOption.Write);
      serializers.Register(CodeStyleEnumOption.Read, CodeStyleEnumOption.Write);
      serializers.Register(FlaggedEnumOptionValue.Read, FlaggedEnumOptionValue.Write);
      serializers.Register(CodeStyleFlaggedEnumOption.Read, CodeStyleFlaggedEnumOption.Write);
      serializers.Register(CodeStyleNumericOption.Read, CodeStyleNumericOption.Write);
      serializers.Register(CodeStyleStringOption.Read, CodeStyleStringOption.Write);
      serializers.Register(OrderedCollection.Read, OrderedCollection.Write);
      serializers.Register(CodeStyleOrderedCollectionOption.Read, CodeStyleOrderedCollectionOption.Write);
      serializers.Register(CodeStyleCodePreview.Read, CodeStyleCodePreview.Write);
      serializers.Register(CodeStyleDiffPreview.Read, CodeStyleDiffPreview.Write);
      serializers.Register(CodeStyleDescriptionPreview.Read, CodeStyleDescriptionPreview.Write);
      serializers.Register(CodeStyleNonePreview.Read, CodeStyleNonePreview.Write);
      serializers.Register(CodeStyleEditorConfigNotification.Read, CodeStyleEditorConfigNotification.Write);
      serializers.Register(CodeStylePageContent.Read, CodeStylePageContent.Write);
      serializers.Register(SingleInspectionModel.Read, SingleInspectionModel.Write);
      serializers.Register(CompoundInspectionModel.Read, CompoundInspectionModel.Write);
      serializers.Register(InspectionSeverityPageContent.Read, InspectionSeverityPageContent.Write);
      serializers.Register(SymbolServersPage.Read, SymbolServersPage.Write);
      serializers.Register(ContextActionsPageContent.Read, ContextActionsPageContent.Write);
      serializers.Register(RdCSharpNullCheckingPatternReadOnly.Read, RdCSharpNullCheckingPatternReadOnly.Write);
      serializers.Register(RdCSharpNullCheckingPatternEditable.Read, RdCSharpNullCheckingPatternEditable.Write);
      serializers.Register(RdCSharpNullCheckingPage.Read, RdCSharpNullCheckingPage.Write);
      serializers.Register(RdCodeAnnotationsPage.Read, RdCodeAnnotationsPage.Write);
      serializers.Register(SettingsLayer.Read, SettingsLayer.Write);
      serializers.Register(SettingsLayerCollection.Read, SettingsLayerCollection.Write);
      serializers.Register(OptionsPageInfo.Read, OptionsPageInfo.Write);
      serializers.Register(OptionsPage.Read, OptionsPage.Write);
      serializers.Register(JetBrains.Rider.Model.OptionsDialog.Read, JetBrains.Rider.Model.OptionsDialog.Write);
      serializers.Register(RadioButtonGroupItem.Read, RadioButtonGroupItem.Write);
      serializers.Register(InspectionLanguageGroupModel.Read, InspectionLanguageGroupModel.Write);
      serializers.Register(ContextActionModel.Read, ContextActionModel.Write);
      serializers.Register(CSharpNullCheckingValidationResult.Read, CSharpNullCheckingValidationResult.Write);
      serializers.Register(RdCodeAnnotationsNamespace.Read, RdCodeAnnotationsNamespace.Write);
      serializers.Register(InspectionSeverityGroupModel.Read, InspectionSeverityGroupModel.Write);
      serializers.Register(OptionsPageContentBase_Unknown.Read, OptionsPageContentBase_Unknown.Write);
      serializers.Register(SimpleOption_Unknown.Read, SimpleOption_Unknown.Write);
      serializers.Register(NamingPageContentBase_Unknown.Read, NamingPageContentBase_Unknown.Write);
      serializers.Register(CodeStyleOptionBase_Unknown.Read, CodeStyleOptionBase_Unknown.Write);
      serializers.Register(CodeStylePreviewBase_Unknown.Read, CodeStylePreviewBase_Unknown.Write);
      serializers.Register(InspectionModelBase_Unknown.Read, InspectionModelBase_Unknown.Write);
      serializers.Register(RdCSharpNullCheckingPatternBase_Unknown.Read, RdCSharpNullCheckingPatternBase_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public SettingsViewModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("optionsDialog = "); _OptionsDialog.PrintEx(printer); printer.Println();
        printer.Print("keywordsDialog = "); _KeywordsDialog.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AutomationOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.Popups.ProtoViewModel Automation {get; private set;}
    
    //private fields
    //primary constructor
    private AutomationOptionItem(
      [NotNull] JetBrains.Rider.Model.Popups.ProtoViewModel automation,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (automation == null) throw new ArgumentNullException("automation");
      
      Automation = automation;
      BindableChildren.Add(new KeyValuePair<string, object>("automation", Automation));
    }
    //secondary constructor
    public AutomationOptionItem (
      [NotNull] JetBrains.Rider.Model.Popups.ProtoViewModel automation,
      int indent
    ) : this (
      automation,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<AutomationOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var automation = JetBrains.Rider.Model.Popups.ProtoViewModel.Read(ctx, reader);
      return new AutomationOptionItem(automation, enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<AutomationOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      JetBrains.Rider.Model.Popups.ProtoViewModel.Write(ctx, writer, value.Automation);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AutomationOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("automation = "); Automation.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSimpleOptionsPageContent : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.UIAutomation.BeControl Automation {get; private set;}
    
    //private fields
    //primary constructor
    public BeSimpleOptionsPageContent(
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl automation
    )
    {
      if (automation == null) throw new ArgumentNullException("automation");
      
      Automation = automation;
      BindableChildren.Add(new KeyValuePair<string, object>("automation", Automation));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeSimpleOptionsPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var automation = JetBrains.Rider.Model.UIAutomation.BeControl.Read(ctx, reader);
      return new BeSimpleOptionsPageContent(automation).WithId(_id);
    };
    
    public static new CtxWriteDelegate<BeSimpleOptionsPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      JetBrains.Rider.Model.UIAutomation.BeControl.Write(ctx, writer, value.Automation);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSimpleOptionsPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("automation = "); Automation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BoolOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsChecked { get { return _IsChecked; }}
    [NotNull] public string Text {get; private set;}
    [NotNull] public string ToolTip {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsChecked;
    
    //primary constructor
    private BoolOptionItem(
      [NotNull] RdProperty<bool> isChecked,
      [NotNull] string text,
      [NotNull] string toolTip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (isChecked == null) throw new ArgumentNullException("isChecked");
      if (text == null) throw new ArgumentNullException("text");
      if (toolTip == null) throw new ArgumentNullException("toolTip");
      
      _IsChecked = isChecked;
      Text = text;
      ToolTip = toolTip;
      _IsChecked.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isChecked", _IsChecked));
    }
    //secondary constructor
    public BoolOptionItem (
      [NotNull] string text,
      [NotNull] string toolTip,
      int indent
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      text,
      toolTip,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<BoolOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var isChecked = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var text = reader.ReadString();
      var toolTip = reader.ReadString();
      return new BoolOptionItem(isChecked, text, toolTip, enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<BoolOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      RdProperty<bool>.Write(ctx, writer, value._IsChecked);
      writer.Write(value.Text);
      writer.Write(value.ToolTip);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BoolOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("isChecked = "); _IsChecked.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("toolTip = "); ToolTip.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CSharpNamingPageContent : NamingPageContentBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsAutoDetectionValuesEnabled { get { return _IsAutoDetectionValuesEnabled; }}
    [NotNull] public IRdProperty<bool> IsNamingInspectionsEnabled { get { return _IsNamingInspectionsEnabled; }}
    [NotNull] public IRdProperty<bool> IsAnyRuleWasDetected { get { return _IsAnyRuleWasDetected; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsAutoDetectionValuesEnabled;
    [NotNull] private readonly RdProperty<bool> _IsNamingInspectionsEnabled;
    [NotNull] private readonly RdProperty<bool> _IsAnyRuleWasDetected;
    
    //primary constructor
    private CSharpNamingPageContent(
      [NotNull] RdProperty<bool> isAutoDetectionValuesEnabled,
      [NotNull] RdProperty<bool> isNamingInspectionsEnabled,
      [NotNull] RdProperty<bool> isAnyRuleWasDetected,
      [NotNull] List<NamingRuleItem> items
    ) : base (
      items
     ) 
    {
      if (isAutoDetectionValuesEnabled == null) throw new ArgumentNullException("isAutoDetectionValuesEnabled");
      if (isNamingInspectionsEnabled == null) throw new ArgumentNullException("isNamingInspectionsEnabled");
      if (isAnyRuleWasDetected == null) throw new ArgumentNullException("isAnyRuleWasDetected");
      
      _IsAutoDetectionValuesEnabled = isAutoDetectionValuesEnabled;
      _IsNamingInspectionsEnabled = isNamingInspectionsEnabled;
      _IsAnyRuleWasDetected = isAnyRuleWasDetected;
      _IsAutoDetectionValuesEnabled.OptimizeNested = true;
      _IsNamingInspectionsEnabled.OptimizeNested = true;
      _IsAnyRuleWasDetected.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isAutoDetectionValuesEnabled", _IsAutoDetectionValuesEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("isNamingInspectionsEnabled", _IsNamingInspectionsEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("isAnyRuleWasDetected", _IsAnyRuleWasDetected));
    }
    //secondary constructor
    public CSharpNamingPageContent (
      [NotNull] List<NamingRuleItem> items
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      items
    ) {}
    //statics
    
    public static new CtxReadDelegate<CSharpNamingPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadNamingRuleItemList(ctx, reader);
      var isAutoDetectionValuesEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isNamingInspectionsEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isAnyRuleWasDetected = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new CSharpNamingPageContent(isAutoDetectionValuesEnabled, isNamingInspectionsEnabled, isAnyRuleWasDetected, items).WithId(_id);
    };
    public static CtxReadDelegate<List<NamingRuleItem>> ReadNamingRuleItemList = NamingRuleItem.Read.List();
    
    public static new CtxWriteDelegate<CSharpNamingPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteNamingRuleItemList(ctx, writer, value.Items);
      RdProperty<bool>.Write(ctx, writer, value._IsAutoDetectionValuesEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsNamingInspectionsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsAnyRuleWasDetected);
    };
    public static CtxWriteDelegate<List<NamingRuleItem>> WriteNamingRuleItemList = NamingRuleItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CSharpNamingPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("isAutoDetectionValuesEnabled = "); _IsAutoDetectionValuesEnabled.PrintEx(printer); printer.Println();
        printer.Print("isNamingInspectionsEnabled = "); _IsNamingInspectionsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isAnyRuleWasDetected = "); _IsAnyRuleWasDetected.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CSharpNullCheckingValidationResult : IPrintable, IEquatable<CSharpNullCheckingValidationResult>
  {
    //fields
    //public fields
    public bool IsValid {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    
    //private fields
    //primary constructor
    public CSharpNullCheckingValidationResult(
      bool isValid,
      [CanBeNull] string message
    )
    {
      IsValid = isValid;
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CSharpNullCheckingValidationResult> Read = (ctx, reader) => 
    {
      var isValid = reader.ReadBool();
      var message = ReadStringNullable(ctx, reader);
      return new CSharpNullCheckingValidationResult(isValid, message);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<CSharpNullCheckingValidationResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsValid);
      WriteStringNullable(ctx, writer, value.Message);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CSharpNullCheckingValidationResult) obj);
    }
    public bool Equals(CSharpNullCheckingValidationResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsValid == other.IsValid && Equals(Message, other.Message);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsValid.GetHashCode();
        hash = hash * 31 + (Message != null ?Message.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CSharpNullCheckingValidationResult (");
      using (printer.IndentCookie()) {
        printer.Print("isValid = "); IsValid.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeCleanupOptionsPageContent : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<string, CleanupProfileModel> Profiles { get { return _Profiles; }}
    [NotNull] public IRdSignal<string> AddProfile { get { return _AddProfile; }}
    [NotNull] public IRdSignal<CodeCleanupProfileCloneRequest> CloneProfile { get { return _CloneProfile; }}
    [NotNull] public IRdSignal<string> RemoveProfile { get { return _RemoveProfile; }}
    [NotNull] public RdEndpoint<string, bool> CanUseName { get { return _CanUseName; }}
    [NotNull] public IRdProperty<string> SelectedProfile { get { return _SelectedProfile; }}
    
    //private fields
    [NotNull] private readonly RdMap<string, CleanupProfileModel> _Profiles;
    [NotNull] private readonly RdSignal<string> _AddProfile;
    [NotNull] private readonly RdSignal<CodeCleanupProfileCloneRequest> _CloneProfile;
    [NotNull] private readonly RdSignal<string> _RemoveProfile;
    [NotNull] private readonly RdEndpoint<string, bool> _CanUseName;
    [NotNull] private readonly RdProperty<string> _SelectedProfile;
    
    //primary constructor
    private CodeCleanupOptionsPageContent(
      [NotNull] RdMap<string, CleanupProfileModel> profiles,
      [NotNull] RdSignal<string> addProfile,
      [NotNull] RdSignal<CodeCleanupProfileCloneRequest> cloneProfile,
      [NotNull] RdSignal<string> removeProfile,
      [NotNull] RdEndpoint<string, bool> canUseName,
      [NotNull] RdProperty<string> selectedProfile
    )
    {
      if (profiles == null) throw new ArgumentNullException("profiles");
      if (addProfile == null) throw new ArgumentNullException("addProfile");
      if (cloneProfile == null) throw new ArgumentNullException("cloneProfile");
      if (removeProfile == null) throw new ArgumentNullException("removeProfile");
      if (canUseName == null) throw new ArgumentNullException("canUseName");
      if (selectedProfile == null) throw new ArgumentNullException("selectedProfile");
      
      _Profiles = profiles;
      _AddProfile = addProfile;
      _CloneProfile = cloneProfile;
      _RemoveProfile = removeProfile;
      _CanUseName = canUseName;
      _SelectedProfile = selectedProfile;
      _SelectedProfile.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("profiles", _Profiles));
      BindableChildren.Add(new KeyValuePair<string, object>("addProfile", _AddProfile));
      BindableChildren.Add(new KeyValuePair<string, object>("cloneProfile", _CloneProfile));
      BindableChildren.Add(new KeyValuePair<string, object>("removeProfile", _RemoveProfile));
      BindableChildren.Add(new KeyValuePair<string, object>("canUseName", _CanUseName));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedProfile", _SelectedProfile));
    }
    //secondary constructor
    public CodeCleanupOptionsPageContent (
    ) : this (
      new RdMap<string, CleanupProfileModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, CleanupProfileModel.Read, CleanupProfileModel.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<CodeCleanupProfileCloneRequest>(CodeCleanupProfileCloneRequest.Read, CodeCleanupProfileCloneRequest.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdEndpoint<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeCleanupOptionsPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var profiles = RdMap<string, CleanupProfileModel>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, CleanupProfileModel.Read, CleanupProfileModel.Write);
      var addProfile = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var cloneProfile = RdSignal<CodeCleanupProfileCloneRequest>.Read(ctx, reader, CodeCleanupProfileCloneRequest.Read, CodeCleanupProfileCloneRequest.Write);
      var removeProfile = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var canUseName = RdEndpoint<string, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var selectedProfile = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new CodeCleanupOptionsPageContent(profiles, addProfile, cloneProfile, removeProfile, canUseName, selectedProfile).WithId(_id);
    };
    
    public static new CtxWriteDelegate<CodeCleanupOptionsPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdMap<string, CleanupProfileModel>.Write(ctx, writer, value._Profiles);
      RdSignal<string>.Write(ctx, writer, value._AddProfile);
      RdSignal<CodeCleanupProfileCloneRequest>.Write(ctx, writer, value._CloneProfile);
      RdSignal<string>.Write(ctx, writer, value._RemoveProfile);
      RdEndpoint<string, bool>.Write(ctx, writer, value._CanUseName);
      RdProperty<string>.Write(ctx, writer, value._SelectedProfile);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeCleanupOptionsPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("profiles = "); _Profiles.PrintEx(printer); printer.Println();
        printer.Print("addProfile = "); _AddProfile.PrintEx(printer); printer.Println();
        printer.Print("cloneProfile = "); _CloneProfile.PrintEx(printer); printer.Println();
        printer.Print("removeProfile = "); _RemoveProfile.PrintEx(printer); printer.Println();
        printer.Print("canUseName = "); _CanUseName.PrintEx(printer); printer.Println();
        printer.Print("selectedProfile = "); _SelectedProfile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeCleanupProfileCloneRequest : IPrintable, IEquatable<CodeCleanupProfileCloneRequest>
  {
    //fields
    //public fields
    [NotNull] public string SourceId {get; private set;}
    [NotNull] public string NewName {get; private set;}
    
    //private fields
    //primary constructor
    public CodeCleanupProfileCloneRequest(
      [NotNull] string sourceId,
      [NotNull] string newName
    )
    {
      if (sourceId == null) throw new ArgumentNullException("sourceId");
      if (newName == null) throw new ArgumentNullException("newName");
      
      SourceId = sourceId;
      NewName = newName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeCleanupProfileCloneRequest> Read = (ctx, reader) => 
    {
      var sourceId = reader.ReadString();
      var newName = reader.ReadString();
      return new CodeCleanupProfileCloneRequest(sourceId, newName);
    };
    
    public static CtxWriteDelegate<CodeCleanupProfileCloneRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SourceId);
      writer.Write(value.NewName);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeCleanupProfileCloneRequest) obj);
    }
    public bool Equals(CodeCleanupProfileCloneRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SourceId == other.SourceId && NewName == other.NewName;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SourceId.GetHashCode();
        hash = hash * 31 + NewName.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeCleanupProfileCloneRequest (");
      using (printer.IndentCookie()) {
        printer.Print("sourceId = "); SourceId.PrintEx(printer); printer.Println();
        printer.Print("newName = "); NewName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleBoolOption : CodeStyleOptionBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Value;
    
    //primary constructor
    private CodeStyleBoolOption(
      [NotNull] RdProperty<bool> value,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public CodeStyleBoolOption (
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleBoolOption> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      var value = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new CodeStyleBoolOption(value, id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleBoolOption> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Value);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleBoolOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleCodePreview : CodeStylePreviewBase
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public CodeStyleCodePreview(
      [NotNull] string text
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleCodePreview> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      return new CodeStyleCodePreview(text).WithId(_id);
    };
    
    public static new CtxWriteDelegate<CodeStyleCodePreview> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleCodePreview (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleDescriptionPreview : CodeStylePreviewBase
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public CodeStyleDescriptionPreview(
      [NotNull] string text
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleDescriptionPreview> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      return new CodeStyleDescriptionPreview(text).WithId(_id);
    };
    
    public static new CtxWriteDelegate<CodeStyleDescriptionPreview> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleDescriptionPreview (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleDiffPreview : CodeStylePreviewBase
  {
    //fields
    //public fields
    [NotNull] public string Input {get; private set;}
    [NotNull] public string Output {get; private set;}
    
    //private fields
    //primary constructor
    public CodeStyleDiffPreview(
      [NotNull] string input,
      [NotNull] string output
    )
    {
      if (input == null) throw new ArgumentNullException("input");
      if (output == null) throw new ArgumentNullException("output");
      
      Input = input;
      Output = output;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleDiffPreview> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var input = reader.ReadString();
      var output = reader.ReadString();
      return new CodeStyleDiffPreview(input, output).WithId(_id);
    };
    
    public static new CtxWriteDelegate<CodeStyleDiffPreview> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Input);
      writer.Write(value.Output);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleDiffPreview (");
      using (printer.IndentCookie()) {
        printer.Print("input = "); Input.PrintEx(printer); printer.Println();
        printer.Print("output = "); Output.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleEditorConfigNotification : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public ISink<RdVoid> NavigateToHelp { get { return _NavigateToHelp; }}
    [NotNull] public string ConfigFileName {get; private set;}
    [NotNull] public string Suffix {get; private set;}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _NavigateToHelp;
    
    //primary constructor
    private CodeStyleEditorConfigNotification(
      [NotNull] RdSignal<RdVoid> navigateToHelp,
      [NotNull] string configFileName,
      [NotNull] string suffix
    )
    {
      if (navigateToHelp == null) throw new ArgumentNullException("navigateToHelp");
      if (configFileName == null) throw new ArgumentNullException("configFileName");
      if (suffix == null) throw new ArgumentNullException("suffix");
      
      _NavigateToHelp = navigateToHelp;
      ConfigFileName = configFileName;
      Suffix = suffix;
      BindableChildren.Add(new KeyValuePair<string, object>("navigateToHelp", _NavigateToHelp));
    }
    //secondary constructor
    public CodeStyleEditorConfigNotification (
      [NotNull] string configFileName,
      [NotNull] string suffix
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      configFileName,
      suffix
    ) {}
    //statics
    
    public static CtxReadDelegate<CodeStyleEditorConfigNotification> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var navigateToHelp = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var configFileName = reader.ReadString();
      var suffix = reader.ReadString();
      return new CodeStyleEditorConfigNotification(navigateToHelp, configFileName, suffix).WithId(_id);
    };
    
    public static CtxWriteDelegate<CodeStyleEditorConfigNotification> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._NavigateToHelp);
      writer.Write(value.ConfigFileName);
      writer.Write(value.Suffix);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleEditorConfigNotification (");
      using (printer.IndentCookie()) {
        printer.Print("navigateToHelp = "); _NavigateToHelp.PrintEx(printer); printer.Println();
        printer.Print("configFileName = "); ConfigFileName.PrintEx(printer); printer.Println();
        printer.Print("suffix = "); Suffix.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleEnumOption : CodeStyleOptionBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    [NotNull] public List<EnumWithValue> PossibleValues {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Value;
    
    //primary constructor
    private CodeStyleEnumOption(
      [NotNull] RdProperty<int> value,
      [NotNull] List<EnumWithValue> possibleValues,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      if (possibleValues == null) throw new ArgumentNullException("possibleValues");
      
      _Value = value;
      PossibleValues = possibleValues;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public CodeStyleEnumOption (
      [NotNull] List<EnumWithValue> possibleValues,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      possibleValues,
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleEnumOption> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      var value = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var possibleValues = ReadEnumWithValueList(ctx, reader);
      return new CodeStyleEnumOption(value, possibleValues, id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<List<EnumWithValue>> ReadEnumWithValueList = EnumWithValue.Read.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleEnumOption> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
      RdProperty<int>.Write(ctx, writer, value._Value);
      WriteEnumWithValueList(ctx, writer, value.PossibleValues);
    };
    public static CtxWriteDelegate<List<EnumWithValue>> WriteEnumWithValueList = EnumWithValue.Write.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleEnumOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("possibleValues = "); PossibleValues.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleFlaggedEnumOption : CodeStyleOptionBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<FlaggedEnumOptionValue> Value { get { return _Value; }}
    [NotNull] public List<EnumWithValue> PossibleValues {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<FlaggedEnumOptionValue> _Value;
    
    //primary constructor
    private CodeStyleFlaggedEnumOption(
      [NotNull] RdProperty<FlaggedEnumOptionValue> value,
      [NotNull] List<EnumWithValue> possibleValues,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      if (possibleValues == null) throw new ArgumentNullException("possibleValues");
      
      _Value = value;
      PossibleValues = possibleValues;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public CodeStyleFlaggedEnumOption (
      [NotNull] List<EnumWithValue> possibleValues,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      new RdProperty<FlaggedEnumOptionValue>(FlaggedEnumOptionValue.Read, FlaggedEnumOptionValue.Write),
      possibleValues,
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleFlaggedEnumOption> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      var value = RdProperty<FlaggedEnumOptionValue>.Read(ctx, reader, FlaggedEnumOptionValue.Read, FlaggedEnumOptionValue.Write);
      var possibleValues = ReadEnumWithValueList(ctx, reader);
      return new CodeStyleFlaggedEnumOption(value, possibleValues, id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<List<EnumWithValue>> ReadEnumWithValueList = EnumWithValue.Read.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleFlaggedEnumOption> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
      RdProperty<FlaggedEnumOptionValue>.Write(ctx, writer, value._Value);
      WriteEnumWithValueList(ctx, writer, value.PossibleValues);
    };
    public static CtxWriteDelegate<List<EnumWithValue>> WriteEnumWithValueList = EnumWithValue.Write.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleFlaggedEnumOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("possibleValues = "); PossibleValues.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleGroupOption : CodeStyleOptionBase
  {
    //fields
    //public fields
    [NotNull] public List<CodeStyleOptionBase> Children {get; private set;}
    
    //private fields
    //primary constructor
    private CodeStyleGroupOption(
      [NotNull] List<CodeStyleOptionBase> children,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
      if (children == null) throw new ArgumentNullException("children");
      
      Children = children;
      BindableChildren.Add(new KeyValuePair<string, object>("children", Children));
    }
    //secondary constructor
    public CodeStyleGroupOption (
      [NotNull] List<CodeStyleOptionBase> children,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      children,
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleGroupOption> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      var children = ReadCodeStyleOptionBaseList(ctx, reader);
      return new CodeStyleGroupOption(children, id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<List<CodeStyleOptionBase>> ReadCodeStyleOptionBaseList = CodeStyleOptionBase.Read.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleGroupOption> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
      WriteCodeStyleOptionBaseList(ctx, writer, value.Children);
    };
    public static CtxWriteDelegate<List<CodeStyleOptionBase>> WriteCodeStyleOptionBaseList = CodeStyleOptionBase.Write.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleGroupOption (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleNonePreview : CodeStylePreviewBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleNonePreview> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new CodeStyleNonePreview().WithId(_id);
    };
    
    public static new CtxWriteDelegate<CodeStyleNonePreview> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleNonePreview (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleNumericOption : CodeStyleOptionBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    public int Min {get; private set;}
    public int Max {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Value;
    
    //primary constructor
    private CodeStyleNumericOption(
      [NotNull] RdProperty<int> value,
      int min,
      int max,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      Min = min;
      Max = max;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public CodeStyleNumericOption (
      int min,
      int max,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      min,
      max,
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleNumericOption> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      var value = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var min = reader.ReadInt();
      var max = reader.ReadInt();
      return new CodeStyleNumericOption(value, min, max, id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleNumericOption> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
      RdProperty<int>.Write(ctx, writer, value._Value);
      writer.Write(value.Min);
      writer.Write(value.Max);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleNumericOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("min = "); Min.PrintEx(printer); printer.Println();
        printer.Print("max = "); Max.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class CodeStyleOptionBase : RdBindableBase
  {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public string Description {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Severity Severity {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] public IRdProperty<bool> IsHighlighted { get { return _IsHighlighted; }}
    [NotNull] public IRdProperty<ModelRichText> Tooltip { get { return _Tooltip; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool> _IsEnabled;
    [NotNull] protected readonly RdProperty<bool> _IsHighlighted;
    [NotNull] protected readonly RdProperty<ModelRichText> _Tooltip;
    
    //primary constructor
    protected CodeStyleOptionBase(
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      if (isHighlighted == null) throw new ArgumentNullException("isHighlighted");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      
      Id = id;
      Description = description;
      Severity = severity;
      _IsEnabled = isEnabled;
      _IsHighlighted = isHighlighted;
      _Tooltip = tooltip;
      _IsEnabled.OptimizeNested = true;
      _IsHighlighted.OptimizeNested = true;
      _Tooltip.OptimizeNested = true;
      _Tooltip.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("severity", Severity));
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("isHighlighted", _IsHighlighted));
      BindableChildren.Add(new KeyValuePair<string, object>("tooltip", _Tooltip));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeStyleOptionBase> Read = Polymorphic<CodeStyleOptionBase>.ReadAbstract(CodeStyleOptionBase_Unknown.Read);
    
    public static CtxWriteDelegate<CodeStyleOptionBase> Write = Polymorphic<CodeStyleOptionBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class CodeStyleOptionBase_Unknown : CodeStyleOptionBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private CodeStyleOptionBase_Unknown(
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
    }
    //secondary constructor
    public CodeStyleOptionBase_Unknown (
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleOptionBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      return new CodeStyleOptionBase_Unknown(id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleOptionBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleOptionBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleOrderedCollectionOption : CodeStyleOptionBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<OrderedCollection> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<OrderedCollection> _Value;
    
    //primary constructor
    private CodeStyleOrderedCollectionOption(
      [NotNull] RdProperty<OrderedCollection> value,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public CodeStyleOrderedCollectionOption (
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      new RdProperty<OrderedCollection>(OrderedCollection.Read, OrderedCollection.Write),
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleOrderedCollectionOption> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      var value = RdProperty<OrderedCollection>.Read(ctx, reader, OrderedCollection.Read, OrderedCollection.Write);
      return new CodeStyleOrderedCollectionOption(value, id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleOrderedCollectionOption> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
      RdProperty<OrderedCollection>.Write(ctx, writer, value._Value);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleOrderedCollectionOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStylePageContent : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public List<CodeStyleOptionBase> Options {get; private set;}
    [NotNull] public IRdProperty<int> SelectedItemId { get { return _SelectedItemId; }}
    [NotNull] public IRdProperty<CodeStylePreviewBase> Preview { get { return _Preview; }}
    [NotNull] public IRdProperty<CodeStyleEditorConfigNotification> EditorConfigNotification { get { return _EditorConfigNotification; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _SelectedItemId;
    [NotNull] private readonly RdProperty<CodeStylePreviewBase> _Preview;
    [NotNull] private readonly RdProperty<CodeStyleEditorConfigNotification> _EditorConfigNotification;
    
    //primary constructor
    private CodeStylePageContent(
      [NotNull] List<CodeStyleOptionBase> options,
      [NotNull] RdProperty<int> selectedItemId,
      [NotNull] RdProperty<CodeStylePreviewBase> preview,
      [NotNull] RdProperty<CodeStyleEditorConfigNotification> editorConfigNotification
    )
    {
      if (options == null) throw new ArgumentNullException("options");
      if (selectedItemId == null) throw new ArgumentNullException("selectedItemId");
      if (preview == null) throw new ArgumentNullException("preview");
      if (editorConfigNotification == null) throw new ArgumentNullException("editorConfigNotification");
      
      Options = options;
      _SelectedItemId = selectedItemId;
      _Preview = preview;
      _EditorConfigNotification = editorConfigNotification;
      _SelectedItemId.OptimizeNested = true;
      _EditorConfigNotification.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("options", Options));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedItemId", _SelectedItemId));
      BindableChildren.Add(new KeyValuePair<string, object>("preview", _Preview));
      BindableChildren.Add(new KeyValuePair<string, object>("editorConfigNotification", _EditorConfigNotification));
    }
    //secondary constructor
    public CodeStylePageContent (
      [NotNull] List<CodeStyleOptionBase> options
    ) : this (
      options,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<CodeStylePreviewBase>(CodeStylePreviewBase.Read, CodeStylePreviewBase.Write),
      new RdProperty<CodeStyleEditorConfigNotification>(ReadCodeStyleEditorConfigNotificationNullable, WriteCodeStyleEditorConfigNotificationNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStylePageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var options = ReadCodeStyleOptionBaseList(ctx, reader);
      var selectedItemId = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var preview = RdProperty<CodeStylePreviewBase>.Read(ctx, reader, CodeStylePreviewBase.Read, CodeStylePreviewBase.Write);
      var editorConfigNotification = RdProperty<CodeStyleEditorConfigNotification>.Read(ctx, reader, ReadCodeStyleEditorConfigNotificationNullable, WriteCodeStyleEditorConfigNotificationNullable);
      return new CodeStylePageContent(options, selectedItemId, preview, editorConfigNotification).WithId(_id);
    };
    public static CtxReadDelegate<List<CodeStyleOptionBase>> ReadCodeStyleOptionBaseList = CodeStyleOptionBase.Read.List();
    public static CtxReadDelegate<CodeStyleEditorConfigNotification> ReadCodeStyleEditorConfigNotificationNullable = CodeStyleEditorConfigNotification.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStylePageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteCodeStyleOptionBaseList(ctx, writer, value.Options);
      RdProperty<int>.Write(ctx, writer, value._SelectedItemId);
      RdProperty<CodeStylePreviewBase>.Write(ctx, writer, value._Preview);
      RdProperty<CodeStyleEditorConfigNotification>.Write(ctx, writer, value._EditorConfigNotification);
    };
    public static CtxWriteDelegate<List<CodeStyleOptionBase>> WriteCodeStyleOptionBaseList = CodeStyleOptionBase.Write.List();
    public static CtxWriteDelegate<CodeStyleEditorConfigNotification> WriteCodeStyleEditorConfigNotificationNullable = CodeStyleEditorConfigNotification.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStylePageContent (");
      using (printer.IndentCookie()) {
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
        printer.Print("selectedItemId = "); _SelectedItemId.PrintEx(printer); printer.Println();
        printer.Print("preview = "); _Preview.PrintEx(printer); printer.Println();
        printer.Print("editorConfigNotification = "); _EditorConfigNotification.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class CodeStylePreviewBase : RdBindableBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeStylePreviewBase> Read = Polymorphic<CodeStylePreviewBase>.ReadAbstract(CodeStylePreviewBase_Unknown.Read);
    
    public static CtxWriteDelegate<CodeStylePreviewBase> Write = Polymorphic<CodeStylePreviewBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class CodeStylePreviewBase_Unknown : CodeStylePreviewBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStylePreviewBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new CodeStylePreviewBase_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<CodeStylePreviewBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStylePreviewBase_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleStringOption : CodeStyleOptionBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private CodeStyleStringOption(
      [NotNull] RdProperty<string> value,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isHighlighted,
      [NotNull] RdProperty<ModelRichText> tooltip
    ) : base (
      id,
      description,
      severity,
      isEnabled,
      isHighlighted,
      tooltip
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public CodeStyleStringOption (
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      id,
      description,
      severity,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CodeStyleStringOption> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isHighlighted = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      var value = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new CodeStyleStringOption(value, id, description, severity, isEnabled, isHighlighted, tooltip).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    
    public static new CtxWriteDelegate<CodeStyleStringOption> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsHighlighted);
      RdProperty<ModelRichText>.Write(ctx, writer, value._Tooltip);
      RdProperty<string>.Write(ctx, writer, value._Value);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleStringOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isHighlighted = "); _IsHighlighted.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ComboOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public string Prefix {get; private set;}
    [NotNull] public string Suffix {get; private set;}
    [CanBeNull] public string Tooltip {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] public IRdProperty<List<string>> PossibleValues { get { return _PossibleValues; }}
    [NotNull] public List<string> PossibleToolTips {get; private set;}
    [NotNull] public string FallbackValue {get; private set;}
    [NotNull] public string FallbackPrefix {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Value;
    [NotNull] private readonly RdProperty<List<string>> _PossibleValues;
    
    //primary constructor
    private ComboOptionItem(
      [NotNull] string prefix,
      [NotNull] string suffix,
      [CanBeNull] string tooltip,
      [NotNull] RdProperty<string> value,
      [NotNull] RdProperty<List<string>> possibleValues,
      [NotNull] List<string> possibleToolTips,
      [NotNull] string fallbackValue,
      [NotNull] string fallbackPrefix,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (prefix == null) throw new ArgumentNullException("prefix");
      if (suffix == null) throw new ArgumentNullException("suffix");
      if (value == null) throw new ArgumentNullException("value");
      if (possibleValues == null) throw new ArgumentNullException("possibleValues");
      if (possibleToolTips == null) throw new ArgumentNullException("possibleToolTips");
      if (fallbackValue == null) throw new ArgumentNullException("fallbackValue");
      if (fallbackPrefix == null) throw new ArgumentNullException("fallbackPrefix");
      
      Prefix = prefix;
      Suffix = suffix;
      Tooltip = tooltip;
      _Value = value;
      _PossibleValues = possibleValues;
      PossibleToolTips = possibleToolTips;
      FallbackValue = fallbackValue;
      FallbackPrefix = fallbackPrefix;
      _Value.OptimizeNested = true;
      _PossibleValues.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
      BindableChildren.Add(new KeyValuePair<string, object>("possibleValues", _PossibleValues));
    }
    //secondary constructor
    public ComboOptionItem (
      [NotNull] string prefix,
      [NotNull] string suffix,
      [CanBeNull] string tooltip,
      [NotNull] List<string> possibleToolTips,
      [NotNull] string fallbackValue,
      [NotNull] string fallbackPrefix,
      int indent
    ) : this (
      prefix,
      suffix,
      tooltip,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<List<string>>(ReadStringList, WriteStringList),
      possibleToolTips,
      fallbackValue,
      fallbackPrefix,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<ComboOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var prefix = reader.ReadString();
      var suffix = reader.ReadString();
      var tooltip = ReadStringNullable(ctx, reader);
      var value = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var possibleValues = RdProperty<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      var possibleToolTips = ReadStringList(ctx, reader);
      var fallbackValue = reader.ReadString();
      var fallbackPrefix = reader.ReadString();
      return new ComboOptionItem(prefix, suffix, tooltip, value, possibleValues, possibleToolTips, fallbackValue, fallbackPrefix, enabled, visible, indent).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<ComboOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      writer.Write(value.Prefix);
      writer.Write(value.Suffix);
      WriteStringNullable(ctx, writer, value.Tooltip);
      RdProperty<string>.Write(ctx, writer, value._Value);
      RdProperty<List<string>>.Write(ctx, writer, value._PossibleValues);
      WriteStringList(ctx, writer, value.PossibleToolTips);
      writer.Write(value.FallbackValue);
      writer.Write(value.FallbackPrefix);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ComboOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("prefix = "); Prefix.PrintEx(printer); printer.Println();
        printer.Print("suffix = "); Suffix.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("possibleValues = "); _PossibleValues.PrintEx(printer); printer.Println();
        printer.Print("possibleToolTips = "); PossibleToolTips.PrintEx(printer); printer.Println();
        printer.Print("fallbackValue = "); FallbackValue.PrintEx(printer); printer.Println();
        printer.Print("fallbackPrefix = "); FallbackPrefix.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompositeOptionsPageContent : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public List<OptionsPageContentBase> Pages {get; private set;}
    
    //private fields
    //primary constructor
    public CompositeOptionsPageContent(
      [NotNull] List<OptionsPageContentBase> pages
    )
    {
      if (pages == null) throw new ArgumentNullException("pages");
      
      Pages = pages;
      BindableChildren.Add(new KeyValuePair<string, object>("pages", Pages));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CompositeOptionsPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var pages = ReadOptionsPageContentBaseList(ctx, reader);
      return new CompositeOptionsPageContent(pages).WithId(_id);
    };
    public static CtxReadDelegate<List<OptionsPageContentBase>> ReadOptionsPageContentBaseList = OptionsPageContentBase.Read.List();
    
    public static new CtxWriteDelegate<CompositeOptionsPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteOptionsPageContentBaseList(ctx, writer, value.Pages);
    };
    public static CtxWriteDelegate<List<OptionsPageContentBase>> WriteOptionsPageContentBaseList = OptionsPageContentBase.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompositeOptionsPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("pages = "); Pages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompoundInspectionModel : InspectionModelBase
  {
    //fields
    //public fields
    [NotNull] public List<SingleInspectionModel> SubElements {get; private set;}
    
    //private fields
    //primary constructor
    private CompoundInspectionModel(
      [NotNull] List<SingleInspectionModel> subElements,
      [NotNull] string inspectionName,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool?> isEnabled,
      [NotNull] RdProperty<bool> canResetSeverity,
      [NotNull] RdSignal<RdVoid> resetSeverity
    ) : base (
      inspectionName,
      description,
      severity,
      isEnabled,
      canResetSeverity,
      resetSeverity
     ) 
    {
      if (subElements == null) throw new ArgumentNullException("subElements");
      
      SubElements = subElements;
      BindableChildren.Add(new KeyValuePair<string, object>("subElements", SubElements));
    }
    //secondary constructor
    public CompoundInspectionModel (
      [NotNull] List<SingleInspectionModel> subElements,
      [NotNull] string inspectionName,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      subElements,
      inspectionName,
      description,
      severity,
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<CompoundInspectionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var inspectionName = reader.ReadString();
      var description = reader.ReadString();
      var severity = JetBrains.Rider.Model.Severity.Read(ctx, reader);
      var isEnabled = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      var canResetSeverity = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var resetSeverity = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var subElements = ReadSingleInspectionModelList(ctx, reader);
      return new CompoundInspectionModel(subElements, inspectionName, description, severity, isEnabled, canResetSeverity, resetSeverity).WithId(_id);
    };
    public static CtxReadDelegate<List<SingleInspectionModel>> ReadSingleInspectionModelList = SingleInspectionModel.Read.List();
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static new CtxWriteDelegate<CompoundInspectionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.InspectionName);
      writer.Write(value.Description);
      JetBrains.Rider.Model.Severity.Write(ctx, writer, value.Severity);
      RdProperty<bool?>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._CanResetSeverity);
      RdSignal<RdVoid>.Write(ctx, writer, value._ResetSeverity);
      WriteSingleInspectionModelList(ctx, writer, value.SubElements);
    };
    public static CtxWriteDelegate<List<SingleInspectionModel>> WriteSingleInspectionModelList = SingleInspectionModel.Write.List();
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompoundInspectionModel (");
      using (printer.IndentCookie()) {
        printer.Print("subElements = "); SubElements.PrintEx(printer); printer.Println();
        printer.Print("inspectionName = "); InspectionName.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("canResetSeverity = "); _CanResetSeverity.PrintEx(printer); printer.Println();
        printer.Print("resetSeverity = "); _ResetSeverity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ContextActionModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string ActionName {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public string Language {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    
    //primary constructor
    private ContextActionModel(
      [NotNull] string actionName,
      [NotNull] string description,
      [NotNull] string language,
      [NotNull] RdProperty<bool> isEnabled
    )
    {
      if (actionName == null) throw new ArgumentNullException("actionName");
      if (description == null) throw new ArgumentNullException("description");
      if (language == null) throw new ArgumentNullException("language");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      
      ActionName = actionName;
      Description = description;
      Language = language;
      _IsEnabled = isEnabled;
      _IsEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
    }
    //secondary constructor
    public ContextActionModel (
      [NotNull] string actionName,
      [NotNull] string description,
      [NotNull] string language
    ) : this (
      actionName,
      description,
      language,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<ContextActionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actionName = reader.ReadString();
      var description = reader.ReadString();
      var language = reader.ReadString();
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new ContextActionModel(actionName, description, language, isEnabled).WithId(_id);
    };
    
    public static CtxWriteDelegate<ContextActionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ActionName);
      writer.Write(value.Description);
      writer.Write(value.Language);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ContextActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("actionName = "); ActionName.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ContextActionsPageContent : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public List<ContextActionModel> Actions {get; private set;}
    
    //private fields
    //primary constructor
    public ContextActionsPageContent(
      [NotNull] List<ContextActionModel> actions
    )
    {
      if (actions == null) throw new ArgumentNullException("actions");
      
      Actions = actions;
      BindableChildren.Add(new KeyValuePair<string, object>("actions", Actions));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ContextActionsPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var actions = ReadContextActionModelList(ctx, reader);
      return new ContextActionsPageContent(actions).WithId(_id);
    };
    public static CtxReadDelegate<List<ContextActionModel>> ReadContextActionModelList = ContextActionModel.Read.List();
    
    public static new CtxWriteDelegate<ContextActionsPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteContextActionModelList(ctx, writer, value.Actions);
    };
    public static CtxWriteDelegate<List<ContextActionModel>> WriteContextActionModelList = ContextActionModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ContextActionsPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("actions = "); Actions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EnumWithValue : IPrintable, IEquatable<EnumWithValue>
  {
    //fields
    //public fields
    public int Value {get; private set;}
    [NotNull] public string Presentation {get; private set;}
    
    //private fields
    //primary constructor
    public EnumWithValue(
      int value,
      [NotNull] string presentation
    )
    {
      if (presentation == null) throw new ArgumentNullException("presentation");
      
      Value = value;
      Presentation = presentation;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EnumWithValue> Read = (ctx, reader) => 
    {
      var value = reader.ReadInt();
      var presentation = reader.ReadString();
      return new EnumWithValue(value, presentation);
    };
    
    public static CtxWriteDelegate<EnumWithValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Value);
      writer.Write(value.Presentation);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EnumWithValue) obj);
    }
    public bool Equals(EnumWithValue other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Value == other.Value && Presentation == other.Presentation;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Value.GetHashCode();
        hash = hash * 31 + Presentation.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EnumWithValue (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
        printer.Print("presentation = "); Presentation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FileAndFolderSetOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public IRdProperty<List<string>> Items { get { return _Items; }}
    [NotNull] public ISink<string> Add { get { return _Add; }}
    [NotNull] public ISink<string> Remove { get { return _Remove; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel> CompletionEditable { get { return _CompletionEditable; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<string>> _Items;
    [NotNull] private readonly RdSignal<string> _Add;
    [NotNull] private readonly RdSignal<string> _Remove;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel> _CompletionEditable;
    
    //primary constructor
    private FileAndFolderSetOptionItem(
      [NotNull] string title,
      [NotNull] RdProperty<List<string>> items,
      [NotNull] RdSignal<string> add,
      [NotNull] RdSignal<string> remove,
      [NotNull] RdProperty<JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel> completionEditable,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (title == null) throw new ArgumentNullException("title");
      if (items == null) throw new ArgumentNullException("items");
      if (add == null) throw new ArgumentNullException("add");
      if (remove == null) throw new ArgumentNullException("remove");
      if (completionEditable == null) throw new ArgumentNullException("completionEditable");
      
      Title = title;
      _Items = items;
      _Add = add;
      _Remove = remove;
      _CompletionEditable = completionEditable;
      _Items.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
      BindableChildren.Add(new KeyValuePair<string, object>("add", _Add));
      BindableChildren.Add(new KeyValuePair<string, object>("remove", _Remove));
      BindableChildren.Add(new KeyValuePair<string, object>("completionEditable", _CompletionEditable));
    }
    //secondary constructor
    public FileAndFolderSetOptionItem (
      [NotNull] string title,
      int indent
    ) : this (
      title,
      new RdProperty<List<string>>(ReadStringList, WriteStringList),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel>(JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel.Read, JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<FileAndFolderSetOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var title = reader.ReadString();
      var items = RdProperty<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      var add = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var remove = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var completionEditable = RdProperty<JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel>.Read(ctx, reader, JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel.Read, JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel.Write);
      return new FileAndFolderSetOptionItem(title, items, add, remove, completionEditable, enabled, visible, indent).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<FileAndFolderSetOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      writer.Write(value.Title);
      RdProperty<List<string>>.Write(ctx, writer, value._Items);
      RdSignal<string>.Write(ctx, writer, value._Add);
      RdSignal<string>.Write(ctx, writer, value._Remove);
      RdProperty<JetBrains.Rider.Model.Refactorings.RdEditableTextViewModel>.Write(ctx, writer, value._CompletionEditable);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FileAndFolderSetOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("add = "); _Add.PrintEx(printer); printer.Println();
        printer.Print("remove = "); _Remove.PrintEx(printer); printer.Println();
        printer.Print("completionEditable = "); _CompletionEditable.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FlaggedEnumOptionValue : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<int> Values {get; private set;}
    
    //private fields
    //primary constructor
    public FlaggedEnumOptionValue(
      [NotNull] List<int> values
    )
    {
      if (values == null) throw new ArgumentNullException("values");
      
      Values = values;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FlaggedEnumOptionValue> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var values = ReadIntList(ctx, reader);
      return new FlaggedEnumOptionValue(values).WithId(_id);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<FlaggedEnumOptionValue> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteIntList(ctx, writer, value.Values);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FlaggedEnumOptionValue (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InspectionLanguageGroupModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public RdLanguage Language {get; private set;}
    [NotNull] public List<InspectionSeverityGroupModel> Groups {get; private set;}
    
    //private fields
    //primary constructor
    public InspectionLanguageGroupModel(
      [NotNull] RdLanguage language,
      [NotNull] List<InspectionSeverityGroupModel> groups
    )
    {
      if (language == null) throw new ArgumentNullException("language");
      if (groups == null) throw new ArgumentNullException("groups");
      
      Language = language;
      Groups = groups;
      BindableChildren.Add(new KeyValuePair<string, object>("groups", Groups));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<InspectionLanguageGroupModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var language = RdLanguage.Read(ctx, reader);
      var groups = ReadInspectionSeverityGroupModelList(ctx, reader);
      return new InspectionLanguageGroupModel(language, groups).WithId(_id);
    };
    public static CtxReadDelegate<List<InspectionSeverityGroupModel>> ReadInspectionSeverityGroupModelList = InspectionSeverityGroupModel.Read.List();
    
    public static CtxWriteDelegate<InspectionLanguageGroupModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdLanguage.Write(ctx, writer, value.Language);
      WriteInspectionSeverityGroupModelList(ctx, writer, value.Groups);
    };
    public static CtxWriteDelegate<List<InspectionSeverityGroupModel>> WriteInspectionSeverityGroupModelList = InspectionSeverityGroupModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InspectionLanguageGroupModel (");
      using (printer.IndentCookie()) {
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class InspectionModelBase : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string InspectionName {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Severity Severity {get; private set;}
    [NotNull] public IRdProperty<bool?> IsEnabled { get { return _IsEnabled; }}
    [NotNull] public IRdProperty<bool> CanResetSeverity { get { return _CanResetSeverity; }}
    [NotNull] public ISink<RdVoid> ResetSeverity { get { return _ResetSeverity; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool?> _IsEnabled;
    [NotNull] protected readonly RdProperty<bool> _CanResetSeverity;
    [NotNull] protected readonly RdSignal<RdVoid> _ResetSeverity;
    
    //primary constructor
    protected InspectionModelBase(
      [NotNull] string inspectionName,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool?> isEnabled,
      [NotNull] RdProperty<bool> canResetSeverity,
      [NotNull] RdSignal<RdVoid> resetSeverity
    )
    {
      if (inspectionName == null) throw new ArgumentNullException("inspectionName");
      if (description == null) throw new ArgumentNullException("description");
      if (severity == null) throw new ArgumentNullException("severity");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      if (canResetSeverity == null) throw new ArgumentNullException("canResetSeverity");
      if (resetSeverity == null) throw new ArgumentNullException("resetSeverity");
      
      InspectionName = inspectionName;
      Description = description;
      Severity = severity;
      _IsEnabled = isEnabled;
      _CanResetSeverity = canResetSeverity;
      _ResetSeverity = resetSeverity;
      _IsEnabled.OptimizeNested = true;
      _CanResetSeverity.OptimizeNested = true;
      _IsEnabled.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("severity", Severity));
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("canResetSeverity", _CanResetSeverity));
      BindableChildren.Add(new KeyValuePair<string, object>("resetSeverity", _ResetSeverity));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<InspectionModelBase> Read = Polymorphic<InspectionModelBase>.ReadAbstract(InspectionModelBase_Unknown.Read);
    
    public static CtxWriteDelegate<InspectionModelBase> Write = Polymorphic<InspectionModelBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class InspectionModelBase_Unknown : InspectionModelBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private InspectionModelBase_Unknown(
      [NotNull] string inspectionName,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool?> isEnabled,
      [NotNull] RdProperty<bool> canResetSeverity,
      [NotNull] RdSignal<RdVoid> resetSeverity
    ) : base (
      inspectionName,
      description,
      severity,
      isEnabled,
      canResetSeverity,
      resetSeverity
     ) 
    {
    }
    //secondary constructor
    public InspectionModelBase_Unknown (
      [NotNull] string inspectionName,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      inspectionName,
      description,
      severity,
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<InspectionModelBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var inspectionName = reader.ReadString();
      var description = reader.ReadString();
      var severity = JetBrains.Rider.Model.Severity.Read(ctx, reader);
      var isEnabled = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      var canResetSeverity = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var resetSeverity = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new InspectionModelBase_Unknown(inspectionName, description, severity, isEnabled, canResetSeverity, resetSeverity).WithId(_id);
    };
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static new CtxWriteDelegate<InspectionModelBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.InspectionName);
      writer.Write(value.Description);
      JetBrains.Rider.Model.Severity.Write(ctx, writer, value.Severity);
      RdProperty<bool?>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._CanResetSeverity);
      RdSignal<RdVoid>.Write(ctx, writer, value._ResetSeverity);
    };
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InspectionModelBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("inspectionName = "); InspectionName.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("canResetSeverity = "); _CanResetSeverity.PrintEx(printer); printer.Println();
        printer.Print("resetSeverity = "); _ResetSeverity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InspectionSeverityGroupModel : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string GroupName {get; private set;}
    [NotNull] public List<InspectionModelBase> Inspections {get; private set;}
    [NotNull] public IRdProperty<bool> CanResetSeverity { get { return _CanResetSeverity; }}
    [NotNull] public ISink<RdVoid> ResetSeverity { get { return _ResetSeverity; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _CanResetSeverity;
    [NotNull] private readonly RdSignal<RdVoid> _ResetSeverity;
    
    //primary constructor
    private InspectionSeverityGroupModel(
      [NotNull] string groupName,
      [NotNull] List<InspectionModelBase> inspections,
      [NotNull] RdProperty<bool> canResetSeverity,
      [NotNull] RdSignal<RdVoid> resetSeverity
    )
    {
      if (groupName == null) throw new ArgumentNullException("groupName");
      if (inspections == null) throw new ArgumentNullException("inspections");
      if (canResetSeverity == null) throw new ArgumentNullException("canResetSeverity");
      if (resetSeverity == null) throw new ArgumentNullException("resetSeverity");
      
      GroupName = groupName;
      Inspections = inspections;
      _CanResetSeverity = canResetSeverity;
      _ResetSeverity = resetSeverity;
      _CanResetSeverity.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("inspections", Inspections));
      BindableChildren.Add(new KeyValuePair<string, object>("canResetSeverity", _CanResetSeverity));
      BindableChildren.Add(new KeyValuePair<string, object>("resetSeverity", _ResetSeverity));
    }
    //secondary constructor
    public InspectionSeverityGroupModel (
      [NotNull] string groupName,
      [NotNull] List<InspectionModelBase> inspections
    ) : this (
      groupName,
      inspections,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<InspectionSeverityGroupModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var groupName = reader.ReadString();
      var inspections = ReadInspectionModelBaseList(ctx, reader);
      var canResetSeverity = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var resetSeverity = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new InspectionSeverityGroupModel(groupName, inspections, canResetSeverity, resetSeverity).WithId(_id);
    };
    public static CtxReadDelegate<List<InspectionModelBase>> ReadInspectionModelBaseList = InspectionModelBase.Read.List();
    
    public static CtxWriteDelegate<InspectionSeverityGroupModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.GroupName);
      WriteInspectionModelBaseList(ctx, writer, value.Inspections);
      RdProperty<bool>.Write(ctx, writer, value._CanResetSeverity);
      RdSignal<RdVoid>.Write(ctx, writer, value._ResetSeverity);
    };
    public static CtxWriteDelegate<List<InspectionModelBase>> WriteInspectionModelBaseList = InspectionModelBase.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InspectionSeverityGroupModel (");
      using (printer.IndentCookie()) {
        printer.Print("groupName = "); GroupName.PrintEx(printer); printer.Println();
        printer.Print("inspections = "); Inspections.PrintEx(printer); printer.Println();
        printer.Print("canResetSeverity = "); _CanResetSeverity.PrintEx(printer); printer.Println();
        printer.Print("resetSeverity = "); _ResetSeverity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InspectionSeverityPageContent : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public List<SeverityElement> PossibleSeverities {get; private set;}
    [NotNull] public List<InspectionLanguageGroupModel> LanguageGroups {get; private set;}
    
    //private fields
    //primary constructor
    public InspectionSeverityPageContent(
      [NotNull] List<SeverityElement> possibleSeverities,
      [NotNull] List<InspectionLanguageGroupModel> languageGroups
    )
    {
      if (possibleSeverities == null) throw new ArgumentNullException("possibleSeverities");
      if (languageGroups == null) throw new ArgumentNullException("languageGroups");
      
      PossibleSeverities = possibleSeverities;
      LanguageGroups = languageGroups;
      BindableChildren.Add(new KeyValuePair<string, object>("languageGroups", LanguageGroups));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<InspectionSeverityPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var possibleSeverities = ReadSeverityElementList(ctx, reader);
      var languageGroups = ReadInspectionLanguageGroupModelList(ctx, reader);
      return new InspectionSeverityPageContent(possibleSeverities, languageGroups).WithId(_id);
    };
    public static CtxReadDelegate<List<SeverityElement>> ReadSeverityElementList = SeverityElement.Read.List();
    public static CtxReadDelegate<List<InspectionLanguageGroupModel>> ReadInspectionLanguageGroupModelList = InspectionLanguageGroupModel.Read.List();
    
    public static new CtxWriteDelegate<InspectionSeverityPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteSeverityElementList(ctx, writer, value.PossibleSeverities);
      WriteInspectionLanguageGroupModelList(ctx, writer, value.LanguageGroups);
    };
    public static CtxWriteDelegate<List<SeverityElement>> WriteSeverityElementList = SeverityElement.Write.List();
    public static CtxWriteDelegate<List<InspectionLanguageGroupModel>> WriteInspectionLanguageGroupModelList = InspectionLanguageGroupModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InspectionSeverityPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("possibleSeverities = "); PossibleSeverities.PrintEx(printer); printer.Println();
        printer.Print("languageGroups = "); LanguageGroups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IntOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    [NotNull] public string PrefixCaption {get; private set;}
    [NotNull] public string PostfixCaption {get; private set;}
    [NotNull] public string ToolTip {get; private set;}
    public int MinValue {get; private set;}
    public int MaxValue {get; private set;}
    public int Step {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Value;
    
    //primary constructor
    private IntOptionItem(
      [NotNull] RdProperty<int> value,
      [NotNull] string prefixCaption,
      [NotNull] string postfixCaption,
      [NotNull] string toolTip,
      int minValue,
      int maxValue,
      int step,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      if (prefixCaption == null) throw new ArgumentNullException("prefixCaption");
      if (postfixCaption == null) throw new ArgumentNullException("postfixCaption");
      if (toolTip == null) throw new ArgumentNullException("toolTip");
      
      _Value = value;
      PrefixCaption = prefixCaption;
      PostfixCaption = postfixCaption;
      ToolTip = toolTip;
      MinValue = minValue;
      MaxValue = maxValue;
      Step = step;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public IntOptionItem (
      [NotNull] string prefixCaption,
      [NotNull] string postfixCaption,
      [NotNull] string toolTip,
      int minValue,
      int maxValue,
      int step,
      int indent
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      prefixCaption,
      postfixCaption,
      toolTip,
      minValue,
      maxValue,
      step,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<IntOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var value = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var prefixCaption = reader.ReadString();
      var postfixCaption = reader.ReadString();
      var toolTip = reader.ReadString();
      var minValue = reader.ReadInt();
      var maxValue = reader.ReadInt();
      var step = reader.ReadInt();
      return new IntOptionItem(value, prefixCaption, postfixCaption, toolTip, minValue, maxValue, step, enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<IntOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      RdProperty<int>.Write(ctx, writer, value._Value);
      writer.Write(value.PrefixCaption);
      writer.Write(value.PostfixCaption);
      writer.Write(value.ToolTip);
      writer.Write(value.MinValue);
      writer.Write(value.MaxValue);
      writer.Write(value.Step);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IntOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("prefixCaption = "); PrefixCaption.PrintEx(printer); printer.Println();
        printer.Print("postfixCaption = "); PostfixCaption.PrintEx(printer); printer.Println();
        printer.Print("toolTip = "); ToolTip.PrintEx(printer); printer.Println();
        printer.Print("minValue = "); MinValue.PrintEx(printer); printer.Println();
        printer.Print("maxValue = "); MaxValue.PrintEx(printer); printer.Println();
        printer.Print("step = "); Step.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NamingPageContent : NamingPageContentBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public NamingPageContent(
      [NotNull] List<NamingRuleItem> items
    ) : base (
      items
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<NamingPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadNamingRuleItemList(ctx, reader);
      return new NamingPageContent(items).WithId(_id);
    };
    public static CtxReadDelegate<List<NamingRuleItem>> ReadNamingRuleItemList = NamingRuleItem.Read.List();
    
    public static new CtxWriteDelegate<NamingPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteNamingRuleItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<NamingRuleItem>> WriteNamingRuleItemList = NamingRuleItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("NamingPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class NamingPageContentBase : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public List<NamingRuleItem> Items {get; private set;}
    
    //private fields
    //primary constructor
    protected NamingPageContentBase(
      [NotNull] List<NamingRuleItem> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      BindableChildren.Add(new KeyValuePair<string, object>("items", Items));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<NamingPageContentBase> Read = Polymorphic<NamingPageContentBase>.ReadAbstract(NamingPageContentBase_Unknown.Read);
    
    public static new CtxWriteDelegate<NamingPageContentBase> Write = Polymorphic<NamingPageContentBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class NamingPageContentBase_Unknown : NamingPageContentBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public NamingPageContentBase_Unknown(
      [NotNull] List<NamingRuleItem> items
    ) : base (
      items
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<NamingPageContentBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadNamingRuleItemList(ctx, reader);
      return new NamingPageContentBase_Unknown(items).WithId(_id);
    };
    public static CtxReadDelegate<List<NamingRuleItem>> ReadNamingRuleItemList = NamingRuleItem.Read.List();
    
    public static new CtxWriteDelegate<NamingPageContentBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteNamingRuleItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<NamingRuleItem>> WriteNamingRuleItemList = NamingRuleItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("NamingPageContentBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NamingPolicy : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public NamingRule Rule {get; private set;}
    [NotNull] public List<NamingRule> ExtraRules {get; private set;}
    public bool EnableInspection {get; private set;}
    
    //private fields
    //primary constructor
    public NamingPolicy(
      [NotNull] NamingRule rule,
      [NotNull] List<NamingRule> extraRules,
      bool enableInspection
    )
    {
      if (rule == null) throw new ArgumentNullException("rule");
      if (extraRules == null) throw new ArgumentNullException("extraRules");
      
      Rule = rule;
      ExtraRules = extraRules;
      EnableInspection = enableInspection;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<NamingPolicy> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var rule = NamingRule.Read(ctx, reader);
      var extraRules = ReadNamingRuleList(ctx, reader);
      var enableInspection = reader.ReadBool();
      return new NamingPolicy(rule, extraRules, enableInspection).WithId(_id);
    };
    public static CtxReadDelegate<List<NamingRule>> ReadNamingRuleList = NamingRule.Read.List();
    
    public static CtxWriteDelegate<NamingPolicy> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      NamingRule.Write(ctx, writer, value.Rule);
      WriteNamingRuleList(ctx, writer, value.ExtraRules);
      writer.Write(value.EnableInspection);
    };
    public static CtxWriteDelegate<List<NamingRule>> WriteNamingRuleList = NamingRule.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("NamingPolicy (");
      using (printer.IndentCookie()) {
        printer.Print("rule = "); Rule.PrintEx(printer); printer.Println();
        printer.Print("extraRules = "); ExtraRules.PrintEx(printer); printer.Println();
        printer.Print("enableInspection = "); EnableInspection.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NamingRule : IPrintable, IEquatable<NamingRule>
  {
    //fields
    //public fields
    public NamingStyleKinds Kind {get; private set;}
    [NotNull] public string Prefix {get; private set;}
    [NotNull] public string Suffix {get; private set;}
    
    //private fields
    //primary constructor
    public NamingRule(
      NamingStyleKinds kind,
      [NotNull] string prefix,
      [NotNull] string suffix
    )
    {
      if (prefix == null) throw new ArgumentNullException("prefix");
      if (suffix == null) throw new ArgumentNullException("suffix");
      
      Kind = kind;
      Prefix = prefix;
      Suffix = suffix;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<NamingRule> Read = (ctx, reader) => 
    {
      var kind = (NamingStyleKinds)reader.ReadInt();
      var prefix = reader.ReadString();
      var suffix = reader.ReadString();
      return new NamingRule(kind, prefix, suffix);
    };
    
    public static CtxWriteDelegate<NamingRule> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      writer.Write(value.Prefix);
      writer.Write(value.Suffix);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((NamingRule) obj);
    }
    public bool Equals(NamingRule other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Prefix == other.Prefix && Suffix == other.Suffix;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + Prefix.GetHashCode();
        hash = hash * 31 + Suffix.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("NamingRule (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("prefix = "); Prefix.PrintEx(printer); printer.Println();
        printer.Print("suffix = "); Suffix.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NamingRuleItem : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdProperty<NamingPolicy> Policy { get { return _Policy; }}
    [NotNull] public IRdProperty<StyleItemState> State { get { return _State; }}
    [NotNull] public IRdProperty<string> Preview { get { return _Preview; }}
    [NotNull] public IRdProperty<bool> IsAutoDetected { get { return _IsAutoDetected; }}
    
    //private fields
    [NotNull] private readonly RdProperty<NamingPolicy> _Policy;
    [NotNull] private readonly RdProperty<StyleItemState> _State;
    [NotNull] private readonly RdProperty<string> _Preview;
    [NotNull] private readonly RdProperty<bool> _IsAutoDetected;
    
    //primary constructor
    private NamingRuleItem(
      [NotNull] string description,
      [NotNull] RdProperty<NamingPolicy> policy,
      [NotNull] RdProperty<StyleItemState> state,
      [NotNull] RdProperty<string> preview,
      [NotNull] RdProperty<bool> isAutoDetected
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      if (policy == null) throw new ArgumentNullException("policy");
      if (state == null) throw new ArgumentNullException("state");
      if (preview == null) throw new ArgumentNullException("preview");
      if (isAutoDetected == null) throw new ArgumentNullException("isAutoDetected");
      
      Description = description;
      _Policy = policy;
      _State = state;
      _Preview = preview;
      _IsAutoDetected = isAutoDetected;
      _State.OptimizeNested = true;
      _Preview.OptimizeNested = true;
      _IsAutoDetected.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("policy", _Policy));
      BindableChildren.Add(new KeyValuePair<string, object>("state", _State));
      BindableChildren.Add(new KeyValuePair<string, object>("preview", _Preview));
      BindableChildren.Add(new KeyValuePair<string, object>("isAutoDetected", _IsAutoDetected));
    }
    //secondary constructor
    public NamingRuleItem (
      [NotNull] string description
    ) : this (
      description,
      new RdProperty<NamingPolicy>(NamingPolicy.Read, NamingPolicy.Write),
      new RdProperty<StyleItemState>(ReadStyleItemState, WriteStyleItemState),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<NamingRuleItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = reader.ReadString();
      var policy = RdProperty<NamingPolicy>.Read(ctx, reader, NamingPolicy.Read, NamingPolicy.Write);
      var state = RdProperty<StyleItemState>.Read(ctx, reader, ReadStyleItemState, WriteStyleItemState);
      var preview = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isAutoDetected = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new NamingRuleItem(description, policy, state, preview, isAutoDetected).WithId(_id);
    };
    public static CtxReadDelegate<StyleItemState> ReadStyleItemState = new CtxReadDelegate<StyleItemState>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<StyleItemState>);
    
    public static CtxWriteDelegate<NamingRuleItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Description);
      RdProperty<NamingPolicy>.Write(ctx, writer, value._Policy);
      RdProperty<StyleItemState>.Write(ctx, writer, value._State);
      RdProperty<string>.Write(ctx, writer, value._Preview);
      RdProperty<bool>.Write(ctx, writer, value._IsAutoDetected);
    };
    public static CtxWriteDelegate<StyleItemState> WriteStyleItemState = new CtxWriteDelegate<StyleItemState>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<StyleItemState>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("NamingRuleItem (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("policy = "); _Policy.PrintEx(printer); printer.Println();
        printer.Print("state = "); _State.PrintEx(printer); printer.Println();
        printer.Print("preview = "); _Preview.PrintEx(printer); printer.Println();
        printer.Print("isAutoDetected = "); _IsAutoDetected.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum NamingStyleKinds {
    AaBb,
    AaBb_AaBb,
    AaBb_aaBb,
    aaBb,
    aaBb_AaBb,
    aaBb_aaBb,
    AA_BB,
    aa_bb,
    Aa_bb
  }
  
  
  public class OptionsDialog : RdBindableBase
  {
    //fields
    //public fields
    [CanBeNull] public SettingsLayer Layer {get; private set;}
    [NotNull] public IViewableMap<string, OptionsPage> Pages { get { return _Pages; }}
    [NotNull] public ISink<RdVoid> Save { get { return _Save; }}
    [NotNull] public ISink<RdVoid> Cancel { get { return _Cancel; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.SettingsLayerCollection> SettingsLayerCollection { get { return _SettingsLayerCollection; }}
    [NotNull] public ISink<SettingsLayer> SaveTo { get { return _SaveTo; }}
    [NotNull] public ISource<string> SelectPage { get { return _SelectPage; }}
    
    //private fields
    [NotNull] private readonly RdMap<string, OptionsPage> _Pages;
    [NotNull] private readonly RdSignal<RdVoid> _Save;
    [NotNull] private readonly RdSignal<RdVoid> _Cancel;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.SettingsLayerCollection> _SettingsLayerCollection;
    [NotNull] private readonly RdSignal<SettingsLayer> _SaveTo;
    [NotNull] private readonly RdSignal<string> _SelectPage;
    
    //primary constructor
    private OptionsDialog(
      [CanBeNull] SettingsLayer layer,
      [NotNull] RdMap<string, OptionsPage> pages,
      [NotNull] RdSignal<RdVoid> save,
      [NotNull] RdSignal<RdVoid> cancel,
      [NotNull] RdProperty<JetBrains.Rider.Model.SettingsLayerCollection> settingsLayerCollection,
      [NotNull] RdSignal<SettingsLayer> saveTo,
      [NotNull] RdSignal<string> selectPage
    )
    {
      if (pages == null) throw new ArgumentNullException("pages");
      if (save == null) throw new ArgumentNullException("save");
      if (cancel == null) throw new ArgumentNullException("cancel");
      if (settingsLayerCollection == null) throw new ArgumentNullException("settingsLayerCollection");
      if (saveTo == null) throw new ArgumentNullException("saveTo");
      if (selectPage == null) throw new ArgumentNullException("selectPage");
      
      Layer = layer;
      _Pages = pages;
      _Save = save;
      _Cancel = cancel;
      _SettingsLayerCollection = settingsLayerCollection;
      _SaveTo = saveTo;
      _SelectPage = selectPage;
      BindableChildren.Add(new KeyValuePair<string, object>("pages", _Pages));
      BindableChildren.Add(new KeyValuePair<string, object>("save", _Save));
      BindableChildren.Add(new KeyValuePair<string, object>("cancel", _Cancel));
      BindableChildren.Add(new KeyValuePair<string, object>("settingsLayerCollection", _SettingsLayerCollection));
      BindableChildren.Add(new KeyValuePair<string, object>("saveTo", _SaveTo));
      BindableChildren.Add(new KeyValuePair<string, object>("selectPage", _SelectPage));
    }
    //secondary constructor
    public OptionsDialog (
      [CanBeNull] SettingsLayer layer
    ) : this (
      layer,
      new RdMap<string, OptionsPage>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, OptionsPage.Read, OptionsPage.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.SettingsLayerCollection>(JetBrains.Rider.Model.SettingsLayerCollection.Read, JetBrains.Rider.Model.SettingsLayerCollection.Write),
      new RdSignal<SettingsLayer>(SettingsLayer.Read, SettingsLayer.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<OptionsDialog> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var layer = ReadSettingsLayerNullable(ctx, reader);
      var pages = RdMap<string, OptionsPage>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, OptionsPage.Read, OptionsPage.Write);
      var save = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var cancel = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var settingsLayerCollection = RdProperty<JetBrains.Rider.Model.SettingsLayerCollection>.Read(ctx, reader, JetBrains.Rider.Model.SettingsLayerCollection.Read, JetBrains.Rider.Model.SettingsLayerCollection.Write);
      var saveTo = RdSignal<SettingsLayer>.Read(ctx, reader, SettingsLayer.Read, SettingsLayer.Write);
      var selectPage = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new OptionsDialog(layer, pages, save, cancel, settingsLayerCollection, saveTo, selectPage).WithId(_id);
    };
    public static CtxReadDelegate<SettingsLayer> ReadSettingsLayerNullable = SettingsLayer.Read.NullableClass();
    
    public static CtxWriteDelegate<OptionsDialog> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteSettingsLayerNullable(ctx, writer, value.Layer);
      RdMap<string, OptionsPage>.Write(ctx, writer, value._Pages);
      RdSignal<RdVoid>.Write(ctx, writer, value._Save);
      RdSignal<RdVoid>.Write(ctx, writer, value._Cancel);
      RdProperty<JetBrains.Rider.Model.SettingsLayerCollection>.Write(ctx, writer, value._SettingsLayerCollection);
      RdSignal<SettingsLayer>.Write(ctx, writer, value._SaveTo);
      RdSignal<string>.Write(ctx, writer, value._SelectPage);
    };
    public static CtxWriteDelegate<SettingsLayer> WriteSettingsLayerNullable = SettingsLayer.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OptionsDialog (");
      using (printer.IndentCookie()) {
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("pages = "); _Pages.PrintEx(printer); printer.Println();
        printer.Print("save = "); _Save.PrintEx(printer); printer.Println();
        printer.Print("cancel = "); _Cancel.PrintEx(printer); printer.Println();
        printer.Print("settingsLayerCollection = "); _SettingsLayerCollection.PrintEx(printer); printer.Println();
        printer.Print("saveTo = "); _SaveTo.PrintEx(printer); printer.Println();
        printer.Print("selectPage = "); _SelectPage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OptionsPage : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<OptionsPageInfo> Info { get { return _Info; }}
    
    //private fields
    [NotNull] private readonly RdProperty<OptionsPageInfo> _Info;
    
    //primary constructor
    private OptionsPage(
      [NotNull] RdProperty<OptionsPageInfo> info
    )
    {
      if (info == null) throw new ArgumentNullException("info");
      
      _Info = info;
      _Info.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("info", _Info));
    }
    //secondary constructor
    public OptionsPage (
    ) : this (
      new RdProperty<OptionsPageInfo>(ReadOptionsPageInfoNullable, WriteOptionsPageInfoNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<OptionsPage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var info = RdProperty<OptionsPageInfo>.Read(ctx, reader, ReadOptionsPageInfoNullable, WriteOptionsPageInfoNullable);
      return new OptionsPage(info).WithId(_id);
    };
    public static CtxReadDelegate<OptionsPageInfo> ReadOptionsPageInfoNullable = OptionsPageInfo.Read.NullableClass();
    
    public static CtxWriteDelegate<OptionsPage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<OptionsPageInfo>.Write(ctx, writer, value._Info);
    };
    public static CtxWriteDelegate<OptionsPageInfo> WriteOptionsPageInfoNullable = OptionsPageInfo.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OptionsPage (");
      using (printer.IndentCookie()) {
        printer.Print("info = "); _Info.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class OptionsPageContentBase : RdBindableBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<OptionsPageContentBase> Read = Polymorphic<OptionsPageContentBase>.ReadAbstract(OptionsPageContentBase_Unknown.Read);
    
    public static CtxWriteDelegate<OptionsPageContentBase> Write = Polymorphic<OptionsPageContentBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class OptionsPageContentBase_Unknown : OptionsPageContentBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<OptionsPageContentBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new OptionsPageContentBase_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<OptionsPageContentBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OptionsPageContentBase_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OptionsPageInfo : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<string> SearchableKeywords {get; private set;}
    [NotNull] public OptionsPageContentBase Content {get; private set;}
    
    //private fields
    //primary constructor
    public OptionsPageInfo(
      [NotNull] List<string> searchableKeywords,
      [NotNull] OptionsPageContentBase content
    )
    {
      if (searchableKeywords == null) throw new ArgumentNullException("searchableKeywords");
      if (content == null) throw new ArgumentNullException("content");
      
      SearchableKeywords = searchableKeywords;
      Content = content;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<OptionsPageInfo> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var searchableKeywords = ReadStringList(ctx, reader);
      var content = OptionsPageContentBase.Read(ctx, reader);
      return new OptionsPageInfo(searchableKeywords, content).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<OptionsPageInfo> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringList(ctx, writer, value.SearchableKeywords);
      OptionsPageContentBase.Write(ctx, writer, value.Content);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OptionsPageInfo (");
      using (printer.IndentCookie()) {
        printer.Print("searchableKeywords = "); SearchableKeywords.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OrderedCollection : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<string> Items {get; private set;}
    
    //private fields
    //primary constructor
    public OrderedCollection(
      [NotNull] List<string> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<OrderedCollection> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadStringList(ctx, reader);
      return new OrderedCollection(items).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<OrderedCollection> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OrderedCollection (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PathChooserOptionItem : SimpleOption
  {
    //fields
    //public fields
    public PathChooserType PathType {get; private set;}
    [NotNull] public string ButtonText {get; private set;}
    public bool CanReset {get; private set;}
    [NotNull] public string ResetButtonText {get; private set;}
    [NotNull] public IRdProperty<string> Path { get { return _Path; }}
    [NotNull] public IRdProperty<bool> Valid { get { return _Valid; }}
    [NotNull] public IRdProperty<string> ToolTip { get { return _ToolTip; }}
    [NotNull] public ISink<string> SetNewPath { get { return _SetNewPath; }}
    [NotNull] public ISink<RdVoid> Reset { get { return _Reset; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Path;
    [NotNull] private readonly RdProperty<bool> _Valid;
    [NotNull] private readonly RdProperty<string> _ToolTip;
    [NotNull] private readonly RdSignal<string> _SetNewPath;
    [NotNull] private readonly RdSignal<RdVoid> _Reset;
    
    //primary constructor
    private PathChooserOptionItem(
      PathChooserType pathType,
      [NotNull] string buttonText,
      bool canReset,
      [NotNull] string resetButtonText,
      [NotNull] RdProperty<string> path,
      [NotNull] RdProperty<bool> valid,
      [NotNull] RdProperty<string> toolTip,
      [NotNull] RdSignal<string> setNewPath,
      [NotNull] RdSignal<RdVoid> reset,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (buttonText == null) throw new ArgumentNullException("buttonText");
      if (resetButtonText == null) throw new ArgumentNullException("resetButtonText");
      if (path == null) throw new ArgumentNullException("path");
      if (valid == null) throw new ArgumentNullException("valid");
      if (toolTip == null) throw new ArgumentNullException("toolTip");
      if (setNewPath == null) throw new ArgumentNullException("setNewPath");
      if (reset == null) throw new ArgumentNullException("reset");
      
      PathType = pathType;
      ButtonText = buttonText;
      CanReset = canReset;
      ResetButtonText = resetButtonText;
      _Path = path;
      _Valid = valid;
      _ToolTip = toolTip;
      _SetNewPath = setNewPath;
      _Reset = reset;
      _Path.OptimizeNested = true;
      _Valid.OptimizeNested = true;
      _ToolTip.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("path", _Path));
      BindableChildren.Add(new KeyValuePair<string, object>("valid", _Valid));
      BindableChildren.Add(new KeyValuePair<string, object>("toolTip", _ToolTip));
      BindableChildren.Add(new KeyValuePair<string, object>("setNewPath", _SetNewPath));
      BindableChildren.Add(new KeyValuePair<string, object>("reset", _Reset));
    }
    //secondary constructor
    public PathChooserOptionItem (
      PathChooserType pathType,
      [NotNull] string buttonText,
      bool canReset,
      [NotNull] string resetButtonText,
      int indent
    ) : this (
      pathType,
      buttonText,
      canReset,
      resetButtonText,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<PathChooserOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var pathType = (PathChooserType)reader.ReadInt();
      var buttonText = reader.ReadString();
      var canReset = reader.ReadBool();
      var resetButtonText = reader.ReadString();
      var path = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var valid = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var toolTip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var setNewPath = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var reset = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new PathChooserOptionItem(pathType, buttonText, canReset, resetButtonText, path, valid, toolTip, setNewPath, reset, enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<PathChooserOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      writer.Write((int)value.PathType);
      writer.Write(value.ButtonText);
      writer.Write(value.CanReset);
      writer.Write(value.ResetButtonText);
      RdProperty<string>.Write(ctx, writer, value._Path);
      RdProperty<bool>.Write(ctx, writer, value._Valid);
      RdProperty<string>.Write(ctx, writer, value._ToolTip);
      RdSignal<string>.Write(ctx, writer, value._SetNewPath);
      RdSignal<RdVoid>.Write(ctx, writer, value._Reset);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PathChooserOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("pathType = "); PathType.PrintEx(printer); printer.Println();
        printer.Print("buttonText = "); ButtonText.PrintEx(printer); printer.Println();
        printer.Print("canReset = "); CanReset.PrintEx(printer); printer.Println();
        printer.Print("resetButtonText = "); ResetButtonText.PrintEx(printer); printer.Println();
        printer.Print("path = "); _Path.PrintEx(printer); printer.Println();
        printer.Print("valid = "); _Valid.PrintEx(printer); printer.Println();
        printer.Print("toolTip = "); _ToolTip.PrintEx(printer); printer.Println();
        printer.Print("setNewPath = "); _SetNewPath.PrintEx(printer); printer.Println();
        printer.Print("reset = "); _Reset.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum PathChooserType {
    File,
    Folder
  }
  
  
  public class RadioButtonGroupItem : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string Label {get; private set;}
    [NotNull] public string Tooltip {get; private set;}
    [NotNull] public List<string> SubItems {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] public IRdProperty<bool> IsChecked { get { return _IsChecked; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    [NotNull] private readonly RdProperty<bool> _IsChecked;
    
    //primary constructor
    private RadioButtonGroupItem(
      [NotNull] string label,
      [NotNull] string tooltip,
      [NotNull] List<string> subItems,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<bool> isChecked
    )
    {
      if (label == null) throw new ArgumentNullException("label");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      if (subItems == null) throw new ArgumentNullException("subItems");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      if (isChecked == null) throw new ArgumentNullException("isChecked");
      
      Label = label;
      Tooltip = tooltip;
      SubItems = subItems;
      _IsEnabled = isEnabled;
      _IsChecked = isChecked;
      _IsEnabled.OptimizeNested = true;
      _IsChecked.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("isChecked", _IsChecked));
    }
    //secondary constructor
    public RadioButtonGroupItem (
      [NotNull] string label,
      [NotNull] string tooltip,
      [NotNull] List<string> subItems
    ) : this (
      label,
      tooltip,
      subItems,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RadioButtonGroupItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var label = reader.ReadString();
      var tooltip = reader.ReadString();
      var subItems = ReadStringList(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isChecked = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RadioButtonGroupItem(label, tooltip, subItems, isEnabled, isChecked).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RadioButtonGroupItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Label);
      writer.Write(value.Tooltip);
      WriteStringList(ctx, writer, value.SubItems);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._IsChecked);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RadioButtonGroupItem (");
      using (printer.IndentCookie()) {
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("subItems = "); SubItems.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("isChecked = "); _IsChecked.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RadioButtonOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public string LabelText {get; private set;}
    [NotNull] public IRdProperty<bool> IsCheckBoxVisible { get { return _IsCheckBoxVisible; }}
    [NotNull] public IRdProperty<bool> IsChecked { get { return _IsChecked; }}
    [NotNull] public List<RadioButtonGroupItem> Buttons {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsCheckBoxVisible;
    [NotNull] private readonly RdProperty<bool> _IsChecked;
    
    //primary constructor
    private RadioButtonOptionItem(
      [NotNull] string labelText,
      [NotNull] RdProperty<bool> isCheckBoxVisible,
      [NotNull] RdProperty<bool> isChecked,
      [NotNull] List<RadioButtonGroupItem> buttons,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (labelText == null) throw new ArgumentNullException("labelText");
      if (isCheckBoxVisible == null) throw new ArgumentNullException("isCheckBoxVisible");
      if (isChecked == null) throw new ArgumentNullException("isChecked");
      if (buttons == null) throw new ArgumentNullException("buttons");
      
      LabelText = labelText;
      _IsCheckBoxVisible = isCheckBoxVisible;
      _IsChecked = isChecked;
      Buttons = buttons;
      _IsCheckBoxVisible.OptimizeNested = true;
      _IsChecked.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isCheckBoxVisible", _IsCheckBoxVisible));
      BindableChildren.Add(new KeyValuePair<string, object>("isChecked", _IsChecked));
      BindableChildren.Add(new KeyValuePair<string, object>("buttons", Buttons));
    }
    //secondary constructor
    public RadioButtonOptionItem (
      [NotNull] string labelText,
      [NotNull] List<RadioButtonGroupItem> buttons,
      int indent
    ) : this (
      labelText,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      buttons,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<RadioButtonOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var labelText = reader.ReadString();
      var isCheckBoxVisible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isChecked = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var buttons = ReadRadioButtonGroupItemList(ctx, reader);
      return new RadioButtonOptionItem(labelText, isCheckBoxVisible, isChecked, buttons, enabled, visible, indent).WithId(_id);
    };
    public static CtxReadDelegate<List<RadioButtonGroupItem>> ReadRadioButtonGroupItemList = RadioButtonGroupItem.Read.List();
    
    public static new CtxWriteDelegate<RadioButtonOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      writer.Write(value.LabelText);
      RdProperty<bool>.Write(ctx, writer, value._IsCheckBoxVisible);
      RdProperty<bool>.Write(ctx, writer, value._IsChecked);
      WriteRadioButtonGroupItemList(ctx, writer, value.Buttons);
    };
    public static CtxWriteDelegate<List<RadioButtonGroupItem>> WriteRadioButtonGroupItemList = RadioButtonGroupItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RadioButtonOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("labelText = "); LabelText.PrintEx(printer); printer.Println();
        printer.Print("isCheckBoxVisible = "); _IsCheckBoxVisible.PrintEx(printer); printer.Println();
        printer.Print("isChecked = "); _IsChecked.PrintEx(printer); printer.Println();
        printer.Print("buttons = "); Buttons.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCSharpNullCheckingPage : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public List<RdCSharpNullCheckingPatternBase> Patterns {get; private set;}
    [NotNull] public IRdProperty<int> SelectedItemIndex { get { return _SelectedItemIndex; }}
    [NotNull] public IRdProperty<bool> CanIncreasePriority { get { return _CanIncreasePriority; }}
    [NotNull] public IRdProperty<bool> CanDecreasePriority { get { return _CanDecreasePriority; }}
    [NotNull] public IRdSignal<RdVoid> IncreasePriority { get { return _IncreasePriority; }}
    [NotNull] public IRdSignal<RdVoid> DecreasePriority { get { return _DecreasePriority; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _SelectedItemIndex;
    [NotNull] private readonly RdProperty<bool> _CanIncreasePriority;
    [NotNull] private readonly RdProperty<bool> _CanDecreasePriority;
    [NotNull] private readonly RdSignal<RdVoid> _IncreasePriority;
    [NotNull] private readonly RdSignal<RdVoid> _DecreasePriority;
    
    //primary constructor
    private RdCSharpNullCheckingPage(
      [NotNull] List<RdCSharpNullCheckingPatternBase> patterns,
      [NotNull] RdProperty<int> selectedItemIndex,
      [NotNull] RdProperty<bool> canIncreasePriority,
      [NotNull] RdProperty<bool> canDecreasePriority,
      [NotNull] RdSignal<RdVoid> increasePriority,
      [NotNull] RdSignal<RdVoid> decreasePriority
    )
    {
      if (patterns == null) throw new ArgumentNullException("patterns");
      if (selectedItemIndex == null) throw new ArgumentNullException("selectedItemIndex");
      if (canIncreasePriority == null) throw new ArgumentNullException("canIncreasePriority");
      if (canDecreasePriority == null) throw new ArgumentNullException("canDecreasePriority");
      if (increasePriority == null) throw new ArgumentNullException("increasePriority");
      if (decreasePriority == null) throw new ArgumentNullException("decreasePriority");
      
      Patterns = patterns;
      _SelectedItemIndex = selectedItemIndex;
      _CanIncreasePriority = canIncreasePriority;
      _CanDecreasePriority = canDecreasePriority;
      _IncreasePriority = increasePriority;
      _DecreasePriority = decreasePriority;
      _SelectedItemIndex.OptimizeNested = true;
      _CanIncreasePriority.OptimizeNested = true;
      _CanDecreasePriority.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("patterns", Patterns));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedItemIndex", _SelectedItemIndex));
      BindableChildren.Add(new KeyValuePair<string, object>("canIncreasePriority", _CanIncreasePriority));
      BindableChildren.Add(new KeyValuePair<string, object>("canDecreasePriority", _CanDecreasePriority));
      BindableChildren.Add(new KeyValuePair<string, object>("increasePriority", _IncreasePriority));
      BindableChildren.Add(new KeyValuePair<string, object>("decreasePriority", _DecreasePriority));
    }
    //secondary constructor
    public RdCSharpNullCheckingPage (
      [NotNull] List<RdCSharpNullCheckingPatternBase> patterns
    ) : this (
      patterns,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdCSharpNullCheckingPage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var patterns = ReadRdCSharpNullCheckingPatternBaseList(ctx, reader);
      var selectedItemIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var canIncreasePriority = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var canDecreasePriority = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var increasePriority = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var decreasePriority = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdCSharpNullCheckingPage(patterns, selectedItemIndex, canIncreasePriority, canDecreasePriority, increasePriority, decreasePriority).WithId(_id);
    };
    public static CtxReadDelegate<List<RdCSharpNullCheckingPatternBase>> ReadRdCSharpNullCheckingPatternBaseList = RdCSharpNullCheckingPatternBase.Read.List();
    
    public static new CtxWriteDelegate<RdCSharpNullCheckingPage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdCSharpNullCheckingPatternBaseList(ctx, writer, value.Patterns);
      RdProperty<int>.Write(ctx, writer, value._SelectedItemIndex);
      RdProperty<bool>.Write(ctx, writer, value._CanIncreasePriority);
      RdProperty<bool>.Write(ctx, writer, value._CanDecreasePriority);
      RdSignal<RdVoid>.Write(ctx, writer, value._IncreasePriority);
      RdSignal<RdVoid>.Write(ctx, writer, value._DecreasePriority);
    };
    public static CtxWriteDelegate<List<RdCSharpNullCheckingPatternBase>> WriteRdCSharpNullCheckingPatternBaseList = RdCSharpNullCheckingPatternBase.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCSharpNullCheckingPage (");
      using (printer.IndentCookie()) {
        printer.Print("patterns = "); Patterns.PrintEx(printer); printer.Println();
        printer.Print("selectedItemIndex = "); _SelectedItemIndex.PrintEx(printer); printer.Println();
        printer.Print("canIncreasePriority = "); _CanIncreasePriority.PrintEx(printer); printer.Println();
        printer.Print("canDecreasePriority = "); _CanDecreasePriority.PrintEx(printer); printer.Println();
        printer.Print("increasePriority = "); _IncreasePriority.PrintEx(printer); printer.Println();
        printer.Print("decreasePriority = "); _DecreasePriority.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdCSharpNullCheckingPatternBase : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Priority { get { return _Priority; }}
    [NotNull] public string PatternName {get; private set;}
    
    //private fields
    [NotNull] protected readonly RdProperty<int> _Priority;
    
    //primary constructor
    protected RdCSharpNullCheckingPatternBase(
      [NotNull] RdProperty<int> priority,
      [NotNull] string patternName
    )
    {
      if (priority == null) throw new ArgumentNullException("priority");
      if (patternName == null) throw new ArgumentNullException("patternName");
      
      _Priority = priority;
      PatternName = patternName;
      _Priority.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("priority", _Priority));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCSharpNullCheckingPatternBase> Read = Polymorphic<RdCSharpNullCheckingPatternBase>.ReadAbstract(RdCSharpNullCheckingPatternBase_Unknown.Read);
    
    public static CtxWriteDelegate<RdCSharpNullCheckingPatternBase> Write = Polymorphic<RdCSharpNullCheckingPatternBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdCSharpNullCheckingPatternBase_Unknown : RdCSharpNullCheckingPatternBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private RdCSharpNullCheckingPatternBase_Unknown(
      [NotNull] RdProperty<int> priority,
      [NotNull] string patternName
    ) : base (
      priority,
      patternName
     ) 
    {
    }
    //secondary constructor
    public RdCSharpNullCheckingPatternBase_Unknown (
      [NotNull] string patternName
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      patternName
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdCSharpNullCheckingPatternBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var priority = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var patternName = reader.ReadString();
      return new RdCSharpNullCheckingPatternBase_Unknown(priority, patternName).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdCSharpNullCheckingPatternBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<int>.Write(ctx, writer, value._Priority);
      writer.Write(value.PatternName);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCSharpNullCheckingPatternBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("priority = "); _Priority.PrintEx(printer); printer.Println();
        printer.Print("patternName = "); PatternName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCSharpNullCheckingPatternEditable : RdCSharpNullCheckingPatternBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Example { get { return _Example; }}
    [NotNull] public IRdProperty<string> PatternText { get { return _PatternText; }}
    [NotNull] public IRdProperty<bool> CanUseForAssertion { get { return _CanUseForAssertion; }}
    [NotNull] public IRdProperty<CSharpNullCheckingValidationResult> ValidationResult { get { return _ValidationResult; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Example;
    [NotNull] private readonly RdProperty<string> _PatternText;
    [NotNull] private readonly RdProperty<bool> _CanUseForAssertion;
    [NotNull] private readonly RdProperty<CSharpNullCheckingValidationResult> _ValidationResult;
    
    //primary constructor
    private RdCSharpNullCheckingPatternEditable(
      [NotNull] RdProperty<string> example,
      [NotNull] RdProperty<string> patternText,
      [NotNull] RdProperty<bool> canUseForAssertion,
      [NotNull] RdProperty<CSharpNullCheckingValidationResult> validationResult,
      [NotNull] RdProperty<int> priority,
      [NotNull] string patternName
    ) : base (
      priority,
      patternName
     ) 
    {
      if (example == null) throw new ArgumentNullException("example");
      if (patternText == null) throw new ArgumentNullException("patternText");
      if (canUseForAssertion == null) throw new ArgumentNullException("canUseForAssertion");
      if (validationResult == null) throw new ArgumentNullException("validationResult");
      
      _Example = example;
      _PatternText = patternText;
      _CanUseForAssertion = canUseForAssertion;
      _ValidationResult = validationResult;
      _Example.OptimizeNested = true;
      _PatternText.OptimizeNested = true;
      _CanUseForAssertion.OptimizeNested = true;
      _ValidationResult.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("example", _Example));
      BindableChildren.Add(new KeyValuePair<string, object>("patternText", _PatternText));
      BindableChildren.Add(new KeyValuePair<string, object>("canUseForAssertion", _CanUseForAssertion));
      BindableChildren.Add(new KeyValuePair<string, object>("validationResult", _ValidationResult));
    }
    //secondary constructor
    public RdCSharpNullCheckingPatternEditable (
      [NotNull] string patternName
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<CSharpNullCheckingValidationResult>(CSharpNullCheckingValidationResult.Read, CSharpNullCheckingValidationResult.Write),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      patternName
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdCSharpNullCheckingPatternEditable> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var priority = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var patternName = reader.ReadString();
      var example = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var patternText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var canUseForAssertion = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdProperty<CSharpNullCheckingValidationResult>.Read(ctx, reader, CSharpNullCheckingValidationResult.Read, CSharpNullCheckingValidationResult.Write);
      return new RdCSharpNullCheckingPatternEditable(example, patternText, canUseForAssertion, validationResult, priority, patternName).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdCSharpNullCheckingPatternEditable> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<int>.Write(ctx, writer, value._Priority);
      writer.Write(value.PatternName);
      RdProperty<string>.Write(ctx, writer, value._Example);
      RdProperty<string>.Write(ctx, writer, value._PatternText);
      RdProperty<bool>.Write(ctx, writer, value._CanUseForAssertion);
      RdProperty<CSharpNullCheckingValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCSharpNullCheckingPatternEditable (");
      using (printer.IndentCookie()) {
        printer.Print("example = "); _Example.PrintEx(printer); printer.Println();
        printer.Print("patternText = "); _PatternText.PrintEx(printer); printer.Println();
        printer.Print("canUseForAssertion = "); _CanUseForAssertion.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("priority = "); _Priority.PrintEx(printer); printer.Println();
        printer.Print("patternName = "); PatternName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCSharpNullCheckingPatternReadOnly : RdCSharpNullCheckingPatternBase
  {
    //fields
    //public fields
    [NotNull] public string Example {get; private set;}
    [NotNull] public string PatternText {get; private set;}
    public bool CanUseForAssertion {get; private set;}
    
    //private fields
    //primary constructor
    private RdCSharpNullCheckingPatternReadOnly(
      [NotNull] string example,
      [NotNull] string patternText,
      bool canUseForAssertion,
      [NotNull] RdProperty<int> priority,
      [NotNull] string patternName
    ) : base (
      priority,
      patternName
     ) 
    {
      if (example == null) throw new ArgumentNullException("example");
      if (patternText == null) throw new ArgumentNullException("patternText");
      
      Example = example;
      PatternText = patternText;
      CanUseForAssertion = canUseForAssertion;
    }
    //secondary constructor
    public RdCSharpNullCheckingPatternReadOnly (
      [NotNull] string example,
      [NotNull] string patternText,
      bool canUseForAssertion,
      [NotNull] string patternName
    ) : this (
      example,
      patternText,
      canUseForAssertion,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      patternName
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdCSharpNullCheckingPatternReadOnly> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var priority = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var patternName = reader.ReadString();
      var example = reader.ReadString();
      var patternText = reader.ReadString();
      var canUseForAssertion = reader.ReadBool();
      return new RdCSharpNullCheckingPatternReadOnly(example, patternText, canUseForAssertion, priority, patternName).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdCSharpNullCheckingPatternReadOnly> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<int>.Write(ctx, writer, value._Priority);
      writer.Write(value.PatternName);
      writer.Write(value.Example);
      writer.Write(value.PatternText);
      writer.Write(value.CanUseForAssertion);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCSharpNullCheckingPatternReadOnly (");
      using (printer.IndentCookie()) {
        printer.Print("example = "); Example.PrintEx(printer); printer.Println();
        printer.Print("patternText = "); PatternText.PrintEx(printer); printer.Println();
        printer.Print("canUseForAssertion = "); CanUseForAssertion.PrintEx(printer); printer.Println();
        printer.Print("priority = "); _Priority.PrintEx(printer); printer.Println();
        printer.Print("patternName = "); PatternName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCodeAnnotationsNamespace : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public ModelRichText NamespaceName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    
    //primary constructor
    private RdCodeAnnotationsNamespace(
      [NotNull] ModelRichText namespaceName,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> isEnabled
    )
    {
      if (namespaceName == null) throw new ArgumentNullException("namespaceName");
      if (icon == null) throw new ArgumentNullException("icon");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      
      NamespaceName = namespaceName;
      Icon = icon;
      _IsEnabled = isEnabled;
      _IsEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
    }
    //secondary constructor
    public RdCodeAnnotationsNamespace (
      [NotNull] ModelRichText namespaceName,
      [NotNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      namespaceName,
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCodeAnnotationsNamespace> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var namespaceName = ModelRichText.Read(ctx, reader);
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdCodeAnnotationsNamespace(namespaceName, icon, isEnabled).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdCodeAnnotationsNamespace> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      ModelRichText.Write(ctx, writer, value.NamespaceName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCodeAnnotationsNamespace (");
      using (printer.IndentCookie()) {
        printer.Print("namespaceName = "); NamespaceName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCodeAnnotationsPage : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public ModelRichText GeneralText {get; private set;}
    [NotNull] public string PackageText {get; private set;}
    [NotNull] public string SourceText {get; private set;}
    [NotNull] public ModelRichText CustomNamespaceText {get; private set;}
    [NotNull] public string CopyText {get; private set;}
    [NotNull] public string PropagateText {get; private set;}
    [NotNull] public ModelRichText NullabilitySuggestionText {get; private set;}
    [NotNull] public string DefaultNamespaceText {get; private set;}
    [NotNull] public List<string> DefaultNamespaceOptions {get; private set;}
    [NotNull] public List<RdCodeAnnotationsNamespace> AvailableNamespaces {get; private set;}
    [NotNull] public IRdProperty<string> SelectedDefaultNamespace { get { return _SelectedDefaultNamespace; }}
    [NotNull] public IRdProperty<bool> PropagateAnnotations { get { return _PropagateAnnotations; }}
    [NotNull] public IRdProperty<bool> MakeInternal { get { return _MakeInternal; }}
    [NotNull] public IRdProperty<bool> MakeConditional { get { return _MakeConditional; }}
    [NotNull] public ISink<RdVoid> CopyCode { get { return _CopyCode; }}
    [NotNull] public ISink<RdVoid> GotoPackage { get { return _GotoPackage; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _SelectedDefaultNamespace;
    [NotNull] private readonly RdProperty<bool> _PropagateAnnotations;
    [NotNull] private readonly RdProperty<bool> _MakeInternal;
    [NotNull] private readonly RdProperty<bool> _MakeConditional;
    [NotNull] private readonly RdSignal<RdVoid> _CopyCode;
    [NotNull] private readonly RdSignal<RdVoid> _GotoPackage;
    
    //primary constructor
    private RdCodeAnnotationsPage(
      [NotNull] ModelRichText generalText,
      [NotNull] string packageText,
      [NotNull] string sourceText,
      [NotNull] ModelRichText customNamespaceText,
      [NotNull] string copyText,
      [NotNull] string propagateText,
      [NotNull] ModelRichText nullabilitySuggestionText,
      [NotNull] string defaultNamespaceText,
      [NotNull] List<string> defaultNamespaceOptions,
      [NotNull] List<RdCodeAnnotationsNamespace> availableNamespaces,
      [NotNull] RdProperty<string> selectedDefaultNamespace,
      [NotNull] RdProperty<bool> propagateAnnotations,
      [NotNull] RdProperty<bool> makeInternal,
      [NotNull] RdProperty<bool> makeConditional,
      [NotNull] RdSignal<RdVoid> copyCode,
      [NotNull] RdSignal<RdVoid> gotoPackage
    )
    {
      if (generalText == null) throw new ArgumentNullException("generalText");
      if (packageText == null) throw new ArgumentNullException("packageText");
      if (sourceText == null) throw new ArgumentNullException("sourceText");
      if (customNamespaceText == null) throw new ArgumentNullException("customNamespaceText");
      if (copyText == null) throw new ArgumentNullException("copyText");
      if (propagateText == null) throw new ArgumentNullException("propagateText");
      if (nullabilitySuggestionText == null) throw new ArgumentNullException("nullabilitySuggestionText");
      if (defaultNamespaceText == null) throw new ArgumentNullException("defaultNamespaceText");
      if (defaultNamespaceOptions == null) throw new ArgumentNullException("defaultNamespaceOptions");
      if (availableNamespaces == null) throw new ArgumentNullException("availableNamespaces");
      if (selectedDefaultNamespace == null) throw new ArgumentNullException("selectedDefaultNamespace");
      if (propagateAnnotations == null) throw new ArgumentNullException("propagateAnnotations");
      if (makeInternal == null) throw new ArgumentNullException("makeInternal");
      if (makeConditional == null) throw new ArgumentNullException("makeConditional");
      if (copyCode == null) throw new ArgumentNullException("copyCode");
      if (gotoPackage == null) throw new ArgumentNullException("gotoPackage");
      
      GeneralText = generalText;
      PackageText = packageText;
      SourceText = sourceText;
      CustomNamespaceText = customNamespaceText;
      CopyText = copyText;
      PropagateText = propagateText;
      NullabilitySuggestionText = nullabilitySuggestionText;
      DefaultNamespaceText = defaultNamespaceText;
      DefaultNamespaceOptions = defaultNamespaceOptions;
      AvailableNamespaces = availableNamespaces;
      _SelectedDefaultNamespace = selectedDefaultNamespace;
      _PropagateAnnotations = propagateAnnotations;
      _MakeInternal = makeInternal;
      _MakeConditional = makeConditional;
      _CopyCode = copyCode;
      _GotoPackage = gotoPackage;
      _SelectedDefaultNamespace.OptimizeNested = true;
      _PropagateAnnotations.OptimizeNested = true;
      _MakeInternal.OptimizeNested = true;
      _MakeConditional.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("availableNamespaces", AvailableNamespaces));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedDefaultNamespace", _SelectedDefaultNamespace));
      BindableChildren.Add(new KeyValuePair<string, object>("propagateAnnotations", _PropagateAnnotations));
      BindableChildren.Add(new KeyValuePair<string, object>("makeInternal", _MakeInternal));
      BindableChildren.Add(new KeyValuePair<string, object>("makeConditional", _MakeConditional));
      BindableChildren.Add(new KeyValuePair<string, object>("copyCode", _CopyCode));
      BindableChildren.Add(new KeyValuePair<string, object>("gotoPackage", _GotoPackage));
    }
    //secondary constructor
    public RdCodeAnnotationsPage (
      [NotNull] ModelRichText generalText,
      [NotNull] string packageText,
      [NotNull] string sourceText,
      [NotNull] ModelRichText customNamespaceText,
      [NotNull] string copyText,
      [NotNull] string propagateText,
      [NotNull] ModelRichText nullabilitySuggestionText,
      [NotNull] string defaultNamespaceText,
      [NotNull] List<string> defaultNamespaceOptions,
      [NotNull] List<RdCodeAnnotationsNamespace> availableNamespaces
    ) : this (
      generalText,
      packageText,
      sourceText,
      customNamespaceText,
      copyText,
      propagateText,
      nullabilitySuggestionText,
      defaultNamespaceText,
      defaultNamespaceOptions,
      availableNamespaces,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdCodeAnnotationsPage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var generalText = ModelRichText.Read(ctx, reader);
      var packageText = reader.ReadString();
      var sourceText = reader.ReadString();
      var customNamespaceText = ModelRichText.Read(ctx, reader);
      var copyText = reader.ReadString();
      var propagateText = reader.ReadString();
      var nullabilitySuggestionText = ModelRichText.Read(ctx, reader);
      var defaultNamespaceText = reader.ReadString();
      var defaultNamespaceOptions = ReadStringList(ctx, reader);
      var availableNamespaces = ReadRdCodeAnnotationsNamespaceList(ctx, reader);
      var selectedDefaultNamespace = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var propagateAnnotations = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var makeInternal = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var makeConditional = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var copyCode = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var gotoPackage = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdCodeAnnotationsPage(generalText, packageText, sourceText, customNamespaceText, copyText, propagateText, nullabilitySuggestionText, defaultNamespaceText, defaultNamespaceOptions, availableNamespaces, selectedDefaultNamespace, propagateAnnotations, makeInternal, makeConditional, copyCode, gotoPackage).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<RdCodeAnnotationsNamespace>> ReadRdCodeAnnotationsNamespaceList = RdCodeAnnotationsNamespace.Read.List();
    
    public static new CtxWriteDelegate<RdCodeAnnotationsPage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      ModelRichText.Write(ctx, writer, value.GeneralText);
      writer.Write(value.PackageText);
      writer.Write(value.SourceText);
      ModelRichText.Write(ctx, writer, value.CustomNamespaceText);
      writer.Write(value.CopyText);
      writer.Write(value.PropagateText);
      ModelRichText.Write(ctx, writer, value.NullabilitySuggestionText);
      writer.Write(value.DefaultNamespaceText);
      WriteStringList(ctx, writer, value.DefaultNamespaceOptions);
      WriteRdCodeAnnotationsNamespaceList(ctx, writer, value.AvailableNamespaces);
      RdProperty<string>.Write(ctx, writer, value._SelectedDefaultNamespace);
      RdProperty<bool>.Write(ctx, writer, value._PropagateAnnotations);
      RdProperty<bool>.Write(ctx, writer, value._MakeInternal);
      RdProperty<bool>.Write(ctx, writer, value._MakeConditional);
      RdSignal<RdVoid>.Write(ctx, writer, value._CopyCode);
      RdSignal<RdVoid>.Write(ctx, writer, value._GotoPackage);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<RdCodeAnnotationsNamespace>> WriteRdCodeAnnotationsNamespaceList = RdCodeAnnotationsNamespace.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCodeAnnotationsPage (");
      using (printer.IndentCookie()) {
        printer.Print("generalText = "); GeneralText.PrintEx(printer); printer.Println();
        printer.Print("packageText = "); PackageText.PrintEx(printer); printer.Println();
        printer.Print("sourceText = "); SourceText.PrintEx(printer); printer.Println();
        printer.Print("customNamespaceText = "); CustomNamespaceText.PrintEx(printer); printer.Println();
        printer.Print("copyText = "); CopyText.PrintEx(printer); printer.Println();
        printer.Print("propagateText = "); PropagateText.PrintEx(printer); printer.Println();
        printer.Print("nullabilitySuggestionText = "); NullabilitySuggestionText.PrintEx(printer); printer.Println();
        printer.Print("defaultNamespaceText = "); DefaultNamespaceText.PrintEx(printer); printer.Println();
        printer.Print("defaultNamespaceOptions = "); DefaultNamespaceOptions.PrintEx(printer); printer.Println();
        printer.Print("availableNamespaces = "); AvailableNamespaces.PrintEx(printer); printer.Println();
        printer.Print("selectedDefaultNamespace = "); _SelectedDefaultNamespace.PrintEx(printer); printer.Println();
        printer.Print("propagateAnnotations = "); _PropagateAnnotations.PrintEx(printer); printer.Println();
        printer.Print("makeInternal = "); _MakeInternal.PrintEx(printer); printer.Println();
        printer.Print("makeConditional = "); _MakeConditional.PrintEx(printer); printer.Println();
        printer.Print("copyCode = "); _CopyCode.PrintEx(printer); printer.Println();
        printer.Print("gotoPackage = "); _GotoPackage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdColor : IPrintable, IEquatable<RdColor>
  {
    //fields
    //public fields
    public int A {get; private set;}
    public int R {get; private set;}
    public int G {get; private set;}
    public int B {get; private set;}
    
    //private fields
    //primary constructor
    public RdColor(
      int a,
      int r,
      int g,
      int b
    )
    {
      A = a;
      R = r;
      G = g;
      B = b;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdColor> Read = (ctx, reader) => 
    {
      var a = reader.ReadInt();
      var r = reader.ReadInt();
      var g = reader.ReadInt();
      var b = reader.ReadInt();
      return new RdColor(a, r, g, b);
    };
    
    public static CtxWriteDelegate<RdColor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.A);
      writer.Write(value.R);
      writer.Write(value.G);
      writer.Write(value.B);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdColor) obj);
    }
    public bool Equals(RdColor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return A == other.A && R == other.R && G == other.G && B == other.B;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + A.GetHashCode();
        hash = hash * 31 + R.GetHashCode();
        hash = hash * 31 + G.GetHashCode();
        hash = hash * 31 + B.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdColor (");
      using (printer.IndentCookie()) {
        printer.Print("a = "); A.PrintEx(printer); printer.Println();
        printer.Print("r = "); R.PrintEx(printer); printer.Println();
        printer.Print("g = "); G.PrintEx(printer); printer.Println();
        printer.Print("b = "); B.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RichTextOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public bool IsHeader {get; private set;}
    
    //private fields
    //primary constructor
    private RichTextOptionItem(
      [NotNull] string text,
      bool isHeader,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      IsHeader = isHeader;
    }
    //secondary constructor
    public RichTextOptionItem (
      [NotNull] string text,
      bool isHeader,
      int indent
    ) : this (
      text,
      isHeader,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<RichTextOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var text = reader.ReadString();
      var isHeader = reader.ReadBool();
      return new RichTextOptionItem(text, isHeader, enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RichTextOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      writer.Write(value.Text);
      writer.Write(value.IsHeader);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RichTextOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isHeader = "); IsHeader.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsLayer : IPrintable, IEquatable<SettingsLayer>
  {
    //fields
    //public fields
    [NotNull] public string DisplayName {get; private set;}
    [CanBeNull] public string OriginText {get; private set;}
    
    //private fields
    //primary constructor
    public SettingsLayer(
      [NotNull] string displayName,
      [CanBeNull] string originText
    )
    {
      if (displayName == null) throw new ArgumentNullException("displayName");
      
      DisplayName = displayName;
      OriginText = originText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SettingsLayer> Read = (ctx, reader) => 
    {
      var displayName = reader.ReadString();
      var originText = ReadStringNullable(ctx, reader);
      return new SettingsLayer(displayName, originText);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<SettingsLayer> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DisplayName);
      WriteStringNullable(ctx, writer, value.OriginText);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SettingsLayer) obj);
    }
    public bool Equals(SettingsLayer other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DisplayName == other.DisplayName && Equals(OriginText, other.OriginText);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DisplayName.GetHashCode();
        hash = hash * 31 + (OriginText != null ?OriginText.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsLayer (");
      using (printer.IndentCookie()) {
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("originText = "); OriginText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsLayerCollection : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<SettingsLayer> Layers {get; private set;}
    
    //private fields
    //primary constructor
    public SettingsLayerCollection(
      [NotNull] List<SettingsLayer> layers
    )
    {
      if (layers == null) throw new ArgumentNullException("layers");
      
      Layers = layers;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SettingsLayerCollection> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var layers = ReadSettingsLayerList(ctx, reader);
      return new SettingsLayerCollection(layers).WithId(_id);
    };
    public static CtxReadDelegate<List<SettingsLayer>> ReadSettingsLayerList = SettingsLayer.Read.List();
    
    public static CtxWriteDelegate<SettingsLayerCollection> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteSettingsLayerList(ctx, writer, value.Layers);
    };
    public static CtxWriteDelegate<List<SettingsLayer>> WriteSettingsLayerList = SettingsLayer.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsLayerCollection (");
      using (printer.IndentCookie()) {
        printer.Print("layers = "); Layers.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class Severity : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    [NotNull] public List<SeverityElement> PossibleValues {get; private set;}
    public bool IsEnabled {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Value;
    
    //primary constructor
    private Severity(
      [NotNull] RdProperty<int> value,
      [NotNull] List<SeverityElement> possibleValues,
      bool isEnabled
    )
    {
      if (value == null) throw new ArgumentNullException("value");
      if (possibleValues == null) throw new ArgumentNullException("possibleValues");
      
      _Value = value;
      PossibleValues = possibleValues;
      IsEnabled = isEnabled;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public Severity (
      [NotNull] List<SeverityElement> possibleValues,
      bool isEnabled
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      possibleValues,
      isEnabled
    ) {}
    //statics
    
    public static CtxReadDelegate<Severity> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var value = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var possibleValues = ReadSeverityElementList(ctx, reader);
      var isEnabled = reader.ReadBool();
      return new Severity(value, possibleValues, isEnabled).WithId(_id);
    };
    public static CtxReadDelegate<List<SeverityElement>> ReadSeverityElementList = SeverityElement.Read.List();
    
    public static CtxWriteDelegate<Severity> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<int>.Write(ctx, writer, value._Value);
      WriteSeverityElementList(ctx, writer, value.PossibleValues);
      writer.Write(value.IsEnabled);
    };
    public static CtxWriteDelegate<List<SeverityElement>> WriteSeverityElementList = SeverityElement.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Severity (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("possibleValues = "); PossibleValues.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SeverityElement : IPrintable, IEquatable<SeverityElement>
  {
    //fields
    //public fields
    [NotNull] public EnumWithValue Value {get; private set;}
    [NotNull] public RdColor Color {get; private set;}
    
    //private fields
    //primary constructor
    public SeverityElement(
      [NotNull] EnumWithValue value,
      [NotNull] RdColor color
    )
    {
      if (value == null) throw new ArgumentNullException("value");
      if (color == null) throw new ArgumentNullException("color");
      
      Value = value;
      Color = color;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SeverityElement> Read = (ctx, reader) => 
    {
      var value = EnumWithValue.Read(ctx, reader);
      var color = RdColor.Read(ctx, reader);
      return new SeverityElement(value, color);
    };
    
    public static CtxWriteDelegate<SeverityElement> Write = (ctx, writer, value) => 
    {
      EnumWithValue.Write(ctx, writer, value.Value);
      RdColor.Write(ctx, writer, value.Color);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SeverityElement) obj);
    }
    public bool Equals(SeverityElement other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Value, other.Value) && Equals(Color, other.Color);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Value.GetHashCode();
        hash = hash * 31 + Color.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SeverityElement (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
        printer.Print("color = "); Color.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class SimpleOption : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] public IRdProperty<bool> Visible { get { return _Visible; }}
    public int Indent {get; private set;}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool> _Enabled;
    [NotNull] protected readonly RdProperty<bool> _Visible;
    
    //primary constructor
    protected SimpleOption(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    )
    {
      if (enabled == null) throw new ArgumentNullException("enabled");
      if (visible == null) throw new ArgumentNullException("visible");
      
      _Enabled = enabled;
      _Visible = visible;
      Indent = indent;
      _Enabled.OptimizeNested = true;
      _Visible.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
      BindableChildren.Add(new KeyValuePair<string, object>("visible", _Visible));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SimpleOption> Read = Polymorphic<SimpleOption>.ReadAbstract(SimpleOption_Unknown.Read);
    
    public static CtxWriteDelegate<SimpleOption> Write = Polymorphic<SimpleOption>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class SimpleOption_Unknown : SimpleOption
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private SimpleOption_Unknown(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
    }
    //secondary constructor
    public SimpleOption_Unknown (
      int indent
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<SimpleOption_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      return new SimpleOption_Unknown(enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<SimpleOption_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SimpleOption_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SimpleOptionsPageContent : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public List<SimpleOption> SimpleOptions {get; private set;}
    
    //private fields
    //primary constructor
    public SimpleOptionsPageContent(
      [NotNull] List<SimpleOption> simpleOptions
    )
    {
      if (simpleOptions == null) throw new ArgumentNullException("simpleOptions");
      
      SimpleOptions = simpleOptions;
      BindableChildren.Add(new KeyValuePair<string, object>("simpleOptions", SimpleOptions));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SimpleOptionsPageContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var simpleOptions = ReadSimpleOptionList(ctx, reader);
      return new SimpleOptionsPageContent(simpleOptions).WithId(_id);
    };
    public static CtxReadDelegate<List<SimpleOption>> ReadSimpleOptionList = SimpleOption.Read.List();
    
    public static new CtxWriteDelegate<SimpleOptionsPageContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteSimpleOptionList(ctx, writer, value.SimpleOptions);
    };
    public static CtxWriteDelegate<List<SimpleOption>> WriteSimpleOptionList = SimpleOption.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SimpleOptionsPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("simpleOptions = "); SimpleOptions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SingleInspectionModel : InspectionModelBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private SingleInspectionModel(
      [NotNull] string inspectionName,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool?> isEnabled,
      [NotNull] RdProperty<bool> canResetSeverity,
      [NotNull] RdSignal<RdVoid> resetSeverity
    ) : base (
      inspectionName,
      description,
      severity,
      isEnabled,
      canResetSeverity,
      resetSeverity
     ) 
    {
    }
    //secondary constructor
    public SingleInspectionModel (
      [NotNull] string inspectionName,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Severity severity
    ) : this (
      inspectionName,
      description,
      severity,
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SingleInspectionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var inspectionName = reader.ReadString();
      var description = reader.ReadString();
      var severity = JetBrains.Rider.Model.Severity.Read(ctx, reader);
      var isEnabled = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      var canResetSeverity = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var resetSeverity = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new SingleInspectionModel(inspectionName, description, severity, isEnabled, canResetSeverity, resetSeverity).WithId(_id);
    };
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static new CtxWriteDelegate<SingleInspectionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.InspectionName);
      writer.Write(value.Description);
      JetBrains.Rider.Model.Severity.Write(ctx, writer, value.Severity);
      RdProperty<bool?>.Write(ctx, writer, value._IsEnabled);
      RdProperty<bool>.Write(ctx, writer, value._CanResetSeverity);
      RdSignal<RdVoid>.Write(ctx, writer, value._ResetSeverity);
    };
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SingleInspectionModel (");
      using (printer.IndentCookie()) {
        printer.Print("inspectionName = "); InspectionName.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("canResetSeverity = "); _CanResetSeverity.PrintEx(printer); printer.Println();
        printer.Print("resetSeverity = "); _ResetSeverity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StringOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] public string Text {get; private set;}
    [NotNull] public string ToolTip {get; private set;}
    public bool AcceptsReturn {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private StringOptionItem(
      [NotNull] RdProperty<string> value,
      [NotNull] string text,
      [NotNull] string toolTip,
      bool acceptsReturn,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      if (text == null) throw new ArgumentNullException("text");
      if (toolTip == null) throw new ArgumentNullException("toolTip");
      
      _Value = value;
      Text = text;
      ToolTip = toolTip;
      AcceptsReturn = acceptsReturn;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public StringOptionItem (
      [NotNull] string text,
      [NotNull] string toolTip,
      bool acceptsReturn,
      int indent
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      text,
      toolTip,
      acceptsReturn,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<StringOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var value = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var text = reader.ReadString();
      var toolTip = reader.ReadString();
      var acceptsReturn = reader.ReadBool();
      return new StringOptionItem(value, text, toolTip, acceptsReturn, enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<StringOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.Text);
      writer.Write(value.ToolTip);
      writer.Write(value.AcceptsReturn);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("StringOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("toolTip = "); ToolTip.PrintEx(printer); printer.Println();
        printer.Print("acceptsReturn = "); AcceptsReturn.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StringSetOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public IRdProperty<List<string>> Items { get { return _Items; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<string>> _Items;
    
    //primary constructor
    private StringSetOptionItem(
      [NotNull] string title,
      [NotNull] RdProperty<List<string>> items,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (title == null) throw new ArgumentNullException("title");
      if (items == null) throw new ArgumentNullException("items");
      
      Title = title;
      _Items = items;
      _Items.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
    }
    //secondary constructor
    public StringSetOptionItem (
      [NotNull] string title,
      int indent
    ) : this (
      title,
      new RdProperty<List<string>>(ReadStringList, WriteStringList),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<StringSetOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var title = reader.ReadString();
      var items = RdProperty<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      return new StringSetOptionItem(title, items, enabled, visible, indent).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<StringSetOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      writer.Write(value.Title);
      RdProperty<List<string>>.Write(ctx, writer, value._Items);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("StringSetOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum StyleItemState {
    Default,
    Unchanged,
    Reset,
    Modified
  }
  
  
  public class SymbolServersPage : OptionsPageContentBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> ServerList { get { return _ServerList; }}
    [NotNull] public IRdProperty<bool> UseSymbolFiles { get { return _UseSymbolFiles; }}
    [NotNull] public IRdProperty<bool> DownloadSources { get { return _DownloadSources; }}
    [NotNull] public IRdProperty<bool> DecompileMethodBodies { get { return _DecompileMethodBodies; }}
    [NotNull] public IRdProperty<bool> ShowNonPublicCompiledElementsInGoto { get { return _ShowNonPublicCompiledElementsInGoto; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _ServerList;
    [NotNull] private readonly RdProperty<bool> _UseSymbolFiles;
    [NotNull] private readonly RdProperty<bool> _DownloadSources;
    [NotNull] private readonly RdProperty<bool> _DecompileMethodBodies;
    [NotNull] private readonly RdProperty<bool> _ShowNonPublicCompiledElementsInGoto;
    
    //primary constructor
    private SymbolServersPage(
      [NotNull] RdProperty<string> serverList,
      [NotNull] RdProperty<bool> useSymbolFiles,
      [NotNull] RdProperty<bool> downloadSources,
      [NotNull] RdProperty<bool> decompileMethodBodies,
      [NotNull] RdProperty<bool> showNonPublicCompiledElementsInGoto
    )
    {
      if (serverList == null) throw new ArgumentNullException("serverList");
      if (useSymbolFiles == null) throw new ArgumentNullException("useSymbolFiles");
      if (downloadSources == null) throw new ArgumentNullException("downloadSources");
      if (decompileMethodBodies == null) throw new ArgumentNullException("decompileMethodBodies");
      if (showNonPublicCompiledElementsInGoto == null) throw new ArgumentNullException("showNonPublicCompiledElementsInGoto");
      
      _ServerList = serverList;
      _UseSymbolFiles = useSymbolFiles;
      _DownloadSources = downloadSources;
      _DecompileMethodBodies = decompileMethodBodies;
      _ShowNonPublicCompiledElementsInGoto = showNonPublicCompiledElementsInGoto;
      _ServerList.OptimizeNested = true;
      _UseSymbolFiles.OptimizeNested = true;
      _DownloadSources.OptimizeNested = true;
      _DecompileMethodBodies.OptimizeNested = true;
      _ShowNonPublicCompiledElementsInGoto.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("serverList", _ServerList));
      BindableChildren.Add(new KeyValuePair<string, object>("useSymbolFiles", _UseSymbolFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("downloadSources", _DownloadSources));
      BindableChildren.Add(new KeyValuePair<string, object>("decompileMethodBodies", _DecompileMethodBodies));
      BindableChildren.Add(new KeyValuePair<string, object>("showNonPublicCompiledElementsInGoto", _ShowNonPublicCompiledElementsInGoto));
    }
    //secondary constructor
    public SymbolServersPage (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SymbolServersPage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var serverList = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var useSymbolFiles = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var downloadSources = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var decompileMethodBodies = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var showNonPublicCompiledElementsInGoto = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new SymbolServersPage(serverList, useSymbolFiles, downloadSources, decompileMethodBodies, showNonPublicCompiledElementsInGoto).WithId(_id);
    };
    
    public static new CtxWriteDelegate<SymbolServersPage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._ServerList);
      RdProperty<bool>.Write(ctx, writer, value._UseSymbolFiles);
      RdProperty<bool>.Write(ctx, writer, value._DownloadSources);
      RdProperty<bool>.Write(ctx, writer, value._DecompileMethodBodies);
      RdProperty<bool>.Write(ctx, writer, value._ShowNonPublicCompiledElementsInGoto);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SymbolServersPage (");
      using (printer.IndentCookie()) {
        printer.Print("serverList = "); _ServerList.PrintEx(printer); printer.Println();
        printer.Print("useSymbolFiles = "); _UseSymbolFiles.PrintEx(printer); printer.Println();
        printer.Print("downloadSources = "); _DownloadSources.PrintEx(printer); printer.Println();
        printer.Print("decompileMethodBodies = "); _DecompileMethodBodies.PrintEx(printer); printer.Println();
        printer.Print("showNonPublicCompiledElementsInGoto = "); _ShowNonPublicCompiledElementsInGoto.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TwoSidedOptionItem : SimpleOption
  {
    //fields
    //public fields
    [NotNull] public SimpleOption LeftItem {get; private set;}
    [NotNull] public SimpleOption RightItem {get; private set;}
    
    //private fields
    //primary constructor
    private TwoSidedOptionItem(
      [NotNull] SimpleOption leftItem,
      [NotNull] SimpleOption rightItem,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<bool> visible,
      int indent
    ) : base (
      enabled,
      visible,
      indent
     ) 
    {
      if (leftItem == null) throw new ArgumentNullException("leftItem");
      if (rightItem == null) throw new ArgumentNullException("rightItem");
      
      LeftItem = leftItem;
      RightItem = rightItem;
      BindableChildren.Add(new KeyValuePair<string, object>("leftItem", LeftItem));
      BindableChildren.Add(new KeyValuePair<string, object>("rightItem", RightItem));
    }
    //secondary constructor
    public TwoSidedOptionItem (
      [NotNull] SimpleOption leftItem,
      [NotNull] SimpleOption rightItem,
      int indent
    ) : this (
      leftItem,
      rightItem,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      indent
    ) {}
    //statics
    
    public static new CtxReadDelegate<TwoSidedOptionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var visible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indent = reader.ReadInt();
      var leftItem = SimpleOption.Read(ctx, reader);
      var rightItem = SimpleOption.Read(ctx, reader);
      return new TwoSidedOptionItem(leftItem, rightItem, enabled, visible, indent).WithId(_id);
    };
    
    public static new CtxWriteDelegate<TwoSidedOptionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Visible);
      writer.Write(value.Indent);
      SimpleOption.Write(ctx, writer, value.LeftItem);
      SimpleOption.Write(ctx, writer, value.RightItem);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TwoSidedOptionItem (");
      using (printer.IndentCookie()) {
        printer.Print("leftItem = "); LeftItem.PrintEx(printer); printer.Println();
        printer.Print("rightItem = "); RightItem.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
