using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class ShellModel : RdExtBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private ShellModel(
    )
    {
    }
    //secondary constructor
    //statics
    
    
    
    protected override long SerializationHash => 6855769976056447460L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(ImageSourceIconNode.Read, ImageSourceIconNode.Write);
      serializers.Register(CompositionIconNode.Read, CompositionIconNode.Write);
      serializers.Register(RotatedIconNode.Read, RotatedIconNode.Write);
      serializers.Register(ShellIconNode.Read, ShellIconNode.Write);
      serializers.Register(ColorIconNode.Read, ColorIconNode.Write);
      serializers.Register(IdeaIconNode.Read, IdeaIconNode.Write);
      serializers.Register(RowIconNode.Read, RowIconNode.Write);
      serializers.RegisterEnum<EffectStyle>();
      serializers.RegisterEnum<FontStyle>();
      serializers.Register(ModelRichString.Read, ModelRichString.Write);
      serializers.Register(ModelRichText.Read, ModelRichText.Write);
      serializers.Register(EnvironmentVariable.Read, EnvironmentVariable.Write);
      serializers.Register(Icon_Unknown.Read, Icon_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public ShellModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ShellModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ColorIconNode : Icon
  {
    //fields
    //public fields
    [NotNull] public RgbaColor Color {get; private set;}
    
    //private fields
    //primary constructor
    public ColorIconNode(
      [NotNull] RgbaColor color
    )
    {
      if (color == null) throw new ArgumentNullException("color");
      
      Color = color;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ColorIconNode> Read = (ctx, reader) => 
    {
      var color = RgbaColor.Read(ctx, reader);
      return new ColorIconNode(color);
    };
    
    public static new CtxWriteDelegate<ColorIconNode> Write = (ctx, writer, value) => 
    {
      RgbaColor.Write(ctx, writer, value.Color);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ColorIconNode) obj);
    }
    public bool Equals(ColorIconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Color, other.Color);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Color.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ColorIconNode (");
      using (printer.IndentCookie()) {
        printer.Print("color = "); Color.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompositionIconNode : Icon
  {
    //fields
    //public fields
    [NotNull] public List<Icon> SubNodes {get; private set;}
    
    //private fields
    //primary constructor
    public CompositionIconNode(
      [NotNull] List<Icon> subNodes
    )
    {
      if (subNodes == null) throw new ArgumentNullException("subNodes");
      
      SubNodes = subNodes;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CompositionIconNode> Read = (ctx, reader) => 
    {
      var subNodes = ReadIconList(ctx, reader);
      return new CompositionIconNode(subNodes);
    };
    public static CtxReadDelegate<List<Icon>> ReadIconList = Icon.Read.List();
    
    public static new CtxWriteDelegate<CompositionIconNode> Write = (ctx, writer, value) => 
    {
      WriteIconList(ctx, writer, value.SubNodes);
    };
    public static CtxWriteDelegate<List<Icon>> WriteIconList = Icon.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CompositionIconNode) obj);
    }
    public bool Equals(CompositionIconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SubNodes.SequenceEqual(other.SubNodes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(SubNodes);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CompositionIconNode (");
      using (printer.IndentCookie()) {
        printer.Print("subNodes = "); SubNodes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum EffectStyle {
    None,
    StraightUnderline,
    WeavyUnderline,
    StrikeOut,
    SearchMatch_IDEA
  }
  
  
  public class EnvironmentVariable : IPrintable, IEquatable<EnvironmentVariable>
  {
    //fields
    //public fields
    [NotNull] public string Key {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public EnvironmentVariable(
      [NotNull] string key,
      [NotNull] string value
    )
    {
      if (key == null) throw new ArgumentNullException("key");
      if (value == null) throw new ArgumentNullException("value");
      
      Key = key;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EnvironmentVariable> Read = (ctx, reader) => 
    {
      var key = reader.ReadString();
      var value = reader.ReadString();
      return new EnvironmentVariable(key, value);
    };
    
    public static CtxWriteDelegate<EnvironmentVariable> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Key);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EnvironmentVariable) obj);
    }
    public bool Equals(EnvironmentVariable other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Key == other.Key && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Key.GetHashCode();
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EnvironmentVariable (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum FontStyle {
    Regular,
    Bold,
    Italic,
    Underline,
    Strikeout
  }
  
  
  public abstract class Icon{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Icon> Read = Polymorphic<Icon>.ReadAbstract(Icon_Unknown.Read);
    
    public static CtxWriteDelegate<Icon> Write = Polymorphic<Icon>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class Icon_Unknown : Icon
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<Icon_Unknown> Read = (ctx, reader) => 
    {
      return new Icon_Unknown();
    };
    
    public static new CtxWriteDelegate<Icon_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((Icon_Unknown) obj);
    }
    public bool Equals(Icon_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("Icon_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IdeaIconNode : Icon
  {
    //fields
    //public fields
    [NotNull] public string IconUrl {get; private set;}
    
    //private fields
    //primary constructor
    public IdeaIconNode(
      [NotNull] string iconUrl
    )
    {
      if (iconUrl == null) throw new ArgumentNullException("iconUrl");
      
      IconUrl = iconUrl;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<IdeaIconNode> Read = (ctx, reader) => 
    {
      var iconUrl = reader.ReadString();
      return new IdeaIconNode(iconUrl);
    };
    
    public static new CtxWriteDelegate<IdeaIconNode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IconUrl);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IdeaIconNode) obj);
    }
    public bool Equals(IdeaIconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IconUrl == other.IconUrl;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IconUrl.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IdeaIconNode (");
      using (printer.IndentCookie()) {
        printer.Print("iconUrl = "); IconUrl.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ImageSourceIconNode : Icon
  {
    //fields
    //public fields
    public int IconPackStringId {get; private set;}
    public int IconNameStringId {get; private set;}
    
    //private fields
    //primary constructor
    public ImageSourceIconNode(
      int iconPackStringId,
      int iconNameStringId
    )
    {
      IconPackStringId = iconPackStringId;
      IconNameStringId = iconNameStringId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ImageSourceIconNode> Read = (ctx, reader) => 
    {
      var iconPackStringId = reader.ReadInt();
      var iconNameStringId = reader.ReadInt();
      return new ImageSourceIconNode(iconPackStringId, iconNameStringId);
    };
    
    public static new CtxWriteDelegate<ImageSourceIconNode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IconPackStringId);
      writer.Write(value.IconNameStringId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ImageSourceIconNode) obj);
    }
    public bool Equals(ImageSourceIconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IconPackStringId == other.IconPackStringId && IconNameStringId == other.IconNameStringId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IconPackStringId.GetHashCode();
        hash = hash * 31 + IconNameStringId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ImageSourceIconNode (");
      using (printer.IndentCookie()) {
        printer.Print("iconPackStringId = "); IconPackStringId.PrintEx(printer); printer.Println();
        printer.Print("iconNameStringId = "); IconNameStringId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ModelRichString : IPrintable, IEquatable<ModelRichString>
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public AbstractColor ForegroundColor {get; private set;}
    [CanBeNull] public AbstractColor BackgroundColor {get; private set;}
    [CanBeNull] public AbstractColor EffectColor {get; private set;}
    public JetBrains.Rider.Model.EffectStyle EffectStyle {get; private set;}
    public JetBrains.Rider.Model.FontStyle FontStyle {get; private set;}
    
    //private fields
    //primary constructor
    public ModelRichString(
      [NotNull] string text,
      [Optional] AbstractColor foregroundColor,
      [Optional] AbstractColor backgroundColor,
      [Optional] AbstractColor effectColor,
      JetBrains.Rider.Model.EffectStyle effectStyle,
      JetBrains.Rider.Model.FontStyle fontStyle
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      ForegroundColor = foregroundColor;
      BackgroundColor = backgroundColor;
      EffectColor = effectColor;
      EffectStyle = effectStyle;
      FontStyle = fontStyle;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ModelRichString> Read = (ctx, reader) => 
    {
      var text = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var foregroundColor = ReadAbstractColorNullable(ctx, reader);
      var backgroundColor = ReadAbstractColorNullable(ctx, reader);
      var effectColor = ReadAbstractColorNullable(ctx, reader);
      var effectStyle = (JetBrains.Rider.Model.EffectStyle)reader.ReadInt();
      var fontStyle = (JetBrains.Rider.Model.FontStyle)reader.ReadInt();
      return new ModelRichString(text, foregroundColor, backgroundColor, effectColor, effectStyle, fontStyle);
    };
    public static CtxReadDelegate<AbstractColor> ReadAbstractColorNullable = AbstractColor.Read.NullableClass();
    
    public static CtxWriteDelegate<ModelRichString> Write = (ctx, writer, value) => 
    {
      ctx.WriteInterned(writer, value.Text, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      WriteAbstractColorNullable(ctx, writer, value.ForegroundColor);
      WriteAbstractColorNullable(ctx, writer, value.BackgroundColor);
      WriteAbstractColorNullable(ctx, writer, value.EffectColor);
      writer.Write((int)value.EffectStyle);
      writer.Write((int)value.FontStyle);
    };
    public static CtxWriteDelegate<AbstractColor> WriteAbstractColorNullable = AbstractColor.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ModelRichString) obj);
    }
    public bool Equals(ModelRichString other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Text, other.Text) && Equals(ForegroundColor, other.ForegroundColor) && Equals(BackgroundColor, other.BackgroundColor) && Equals(EffectColor, other.EffectColor) && EffectStyle == other.EffectStyle && FontStyle == other.FontStyle;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + (ForegroundColor != null ?ForegroundColor.GetHashCode() : 0);
        hash = hash * 31 + (BackgroundColor != null ?BackgroundColor.GetHashCode() : 0);
        hash = hash * 31 + (EffectColor != null ?EffectColor.GetHashCode() : 0);
        hash = hash * 31 + (int) EffectStyle;
        hash = hash * 31 + (int) FontStyle;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ModelRichString (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("foregroundColor = "); ForegroundColor.PrintEx(printer); printer.Println();
        printer.Print("backgroundColor = "); BackgroundColor.PrintEx(printer); printer.Println();
        printer.Print("effectColor = "); EffectColor.PrintEx(printer); printer.Println();
        printer.Print("effectStyle = "); EffectStyle.PrintEx(printer); printer.Println();
        printer.Print("fontStyle = "); FontStyle.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ModelRichText : IPrintable, IEquatable<ModelRichText>
  {
    //fields
    //public fields
    [NotNull] public List<ModelRichString> Parts {get; private set;}
    
    //private fields
    //primary constructor
    public ModelRichText(
      [NotNull] List<ModelRichString> parts
    )
    {
      if (parts == null) throw new ArgumentNullException("parts");
      
      Parts = parts;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ModelRichText> Read = (ctx, reader) => 
    {
      var parts = ReadModelRichStringList(ctx, reader);
      return new ModelRichText(parts);
    };
    public static CtxReadDelegate<List<ModelRichString>> ReadModelRichStringList = ModelRichString.Read.List();
    
    public static CtxWriteDelegate<ModelRichText> Write = (ctx, writer, value) => 
    {
      WriteModelRichStringList(ctx, writer, value.Parts);
    };
    public static CtxWriteDelegate<List<ModelRichString>> WriteModelRichStringList = ModelRichString.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ModelRichText) obj);
    }
    public bool Equals(ModelRichText other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Parts.SequenceEqual(other.Parts);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Parts);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ModelRichText (");
      using (printer.IndentCookie()) {
        printer.Print("parts = "); Parts.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RotatedIconNode : Icon
  {
    //fields
    //public fields
    [NotNull] public Icon StaticNode {get; private set;}
    
    //private fields
    //primary constructor
    public RotatedIconNode(
      [NotNull] Icon staticNode
    )
    {
      if (staticNode == null) throw new ArgumentNullException("staticNode");
      
      StaticNode = staticNode;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RotatedIconNode> Read = (ctx, reader) => 
    {
      var staticNode = Icon.Read(ctx, reader);
      return new RotatedIconNode(staticNode);
    };
    
    public static new CtxWriteDelegate<RotatedIconNode> Write = (ctx, writer, value) => 
    {
      Icon.Write(ctx, writer, value.StaticNode);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RotatedIconNode) obj);
    }
    public bool Equals(RotatedIconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(StaticNode, other.StaticNode);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + StaticNode.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RotatedIconNode (");
      using (printer.IndentCookie()) {
        printer.Print("staticNode = "); StaticNode.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RowIconNode : Icon
  {
    //fields
    //public fields
    [NotNull] public List<Icon> SubNodes {get; private set;}
    
    //private fields
    //primary constructor
    public RowIconNode(
      [NotNull] List<Icon> subNodes
    )
    {
      if (subNodes == null) throw new ArgumentNullException("subNodes");
      
      SubNodes = subNodes;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RowIconNode> Read = (ctx, reader) => 
    {
      var subNodes = ReadIconList(ctx, reader);
      return new RowIconNode(subNodes);
    };
    public static CtxReadDelegate<List<Icon>> ReadIconList = Icon.Read.List();
    
    public static new CtxWriteDelegate<RowIconNode> Write = (ctx, writer, value) => 
    {
      WriteIconList(ctx, writer, value.SubNodes);
    };
    public static CtxWriteDelegate<List<Icon>> WriteIconList = Icon.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RowIconNode) obj);
    }
    public bool Equals(RowIconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SubNodes.SequenceEqual(other.SubNodes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(SubNodes);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RowIconNode (");
      using (printer.IndentCookie()) {
        printer.Print("subNodes = "); SubNodes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ShellIconNode : Icon
  {
    //fields
    //public fields
    public int ExtensionWithDotStringId {get; private set;}
    
    //private fields
    //primary constructor
    public ShellIconNode(
      int extensionWithDotStringId
    )
    {
      ExtensionWithDotStringId = extensionWithDotStringId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ShellIconNode> Read = (ctx, reader) => 
    {
      var extensionWithDotStringId = reader.ReadInt();
      return new ShellIconNode(extensionWithDotStringId);
    };
    
    public static new CtxWriteDelegate<ShellIconNode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ExtensionWithDotStringId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ShellIconNode) obj);
    }
    public bool Equals(ShellIconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ExtensionWithDotStringId == other.ExtensionWithDotStringId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ExtensionWithDotStringId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ShellIconNode (");
      using (printer.IndentCookie()) {
        printer.Print("extensionWithDotStringId = "); ExtensionWithDotStringId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
