using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class SolutionAnalysisModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<SolutionAnalysisState> State { get { return _State; }}
    [NotNull] public ISink<bool> SetEnabled { get { return _SetEnabled; }}
    [NotNull] public ISink<bool> SetPaused { get { return _SetPaused; }}
    [NotNull] public IRdProperty<bool> Ready { get { return _Ready; }}
    [NotNull] public IRdProperty<bool> HostReady { get { return _HostReady; }}
    [NotNull] public IRdProperty<bool> Loaded { get { return _Loaded; }}
    [NotNull] public IRdProperty<bool> IncludeWarnings { get { return _IncludeWarnings; }}
    [NotNull] public IViewableMap<SolutionAnalysisIdWithContext, SolutionAnalysisErrors> FileErrors { get { return _FileErrors; }}
    [NotNull] public ISource<SolutionAnalysisIconState> IconState { get { return _IconState; }}
    [NotNull] public ISink<SolutionAnalysisAction> RunAction { get { return _RunAction; }}
    [NotNull] public ISink<SolutionAnalysisProjectModelIgnore> IgnoreErrorsByProjectModel { get { return _IgnoreErrorsByProjectModel; }}
    [NotNull] public RdEndpoint<List<SolutionAnalysisFileWithErrorList>, SolutionAnalysisIssueReport> CopyIssueReport { get { return _CopyIssueReport; }}
    
    //private fields
    [NotNull] private readonly RdProperty<SolutionAnalysisState> _State;
    [NotNull] private readonly RdSignal<bool> _SetEnabled;
    [NotNull] private readonly RdSignal<bool> _SetPaused;
    [NotNull] private readonly RdProperty<bool> _Ready;
    [NotNull] private readonly RdProperty<bool> _HostReady;
    [NotNull] private readonly RdProperty<bool> _Loaded;
    [NotNull] private readonly RdProperty<bool> _IncludeWarnings;
    [NotNull] private readonly RdMap<SolutionAnalysisIdWithContext, SolutionAnalysisErrors> _FileErrors;
    [NotNull] private readonly RdSignal<SolutionAnalysisIconState> _IconState;
    [NotNull] private readonly RdSignal<SolutionAnalysisAction> _RunAction;
    [NotNull] private readonly RdSignal<SolutionAnalysisProjectModelIgnore> _IgnoreErrorsByProjectModel;
    [NotNull] private readonly RdEndpoint<List<SolutionAnalysisFileWithErrorList>, SolutionAnalysisIssueReport> _CopyIssueReport;
    
    //primary constructor
    private SolutionAnalysisModel(
      [NotNull] RdProperty<SolutionAnalysisState> state,
      [NotNull] RdSignal<bool> setEnabled,
      [NotNull] RdSignal<bool> setPaused,
      [NotNull] RdProperty<bool> ready,
      [NotNull] RdProperty<bool> hostReady,
      [NotNull] RdProperty<bool> loaded,
      [NotNull] RdProperty<bool> includeWarnings,
      [NotNull] RdMap<SolutionAnalysisIdWithContext, SolutionAnalysisErrors> fileErrors,
      [NotNull] RdSignal<SolutionAnalysisIconState> iconState,
      [NotNull] RdSignal<SolutionAnalysisAction> runAction,
      [NotNull] RdSignal<SolutionAnalysisProjectModelIgnore> ignoreErrorsByProjectModel,
      [NotNull] RdEndpoint<List<SolutionAnalysisFileWithErrorList>, SolutionAnalysisIssueReport> copyIssueReport
    )
    {
      if (state == null) throw new ArgumentNullException("state");
      if (setEnabled == null) throw new ArgumentNullException("setEnabled");
      if (setPaused == null) throw new ArgumentNullException("setPaused");
      if (ready == null) throw new ArgumentNullException("ready");
      if (hostReady == null) throw new ArgumentNullException("hostReady");
      if (loaded == null) throw new ArgumentNullException("loaded");
      if (includeWarnings == null) throw new ArgumentNullException("includeWarnings");
      if (fileErrors == null) throw new ArgumentNullException("fileErrors");
      if (iconState == null) throw new ArgumentNullException("iconState");
      if (runAction == null) throw new ArgumentNullException("runAction");
      if (ignoreErrorsByProjectModel == null) throw new ArgumentNullException("ignoreErrorsByProjectModel");
      if (copyIssueReport == null) throw new ArgumentNullException("copyIssueReport");
      
      _State = state;
      _SetEnabled = setEnabled;
      _SetPaused = setPaused;
      _Ready = ready;
      _HostReady = hostReady;
      _Loaded = loaded;
      _IncludeWarnings = includeWarnings;
      _FileErrors = fileErrors;
      _IconState = iconState;
      _RunAction = runAction;
      _IgnoreErrorsByProjectModel = ignoreErrorsByProjectModel;
      _CopyIssueReport = copyIssueReport;
      _Ready.OptimizeNested = true;
      _HostReady.OptimizeNested = true;
      _Loaded.OptimizeNested = true;
      _IncludeWarnings.OptimizeNested = true;
      _IconState.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("state", _State));
      BindableChildren.Add(new KeyValuePair<string, object>("setEnabled", _SetEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("setPaused", _SetPaused));
      BindableChildren.Add(new KeyValuePair<string, object>("ready", _Ready));
      BindableChildren.Add(new KeyValuePair<string, object>("hostReady", _HostReady));
      BindableChildren.Add(new KeyValuePair<string, object>("loaded", _Loaded));
      BindableChildren.Add(new KeyValuePair<string, object>("includeWarnings", _IncludeWarnings));
      BindableChildren.Add(new KeyValuePair<string, object>("fileErrors", _FileErrors));
      BindableChildren.Add(new KeyValuePair<string, object>("iconState", _IconState));
      BindableChildren.Add(new KeyValuePair<string, object>("runAction", _RunAction));
      BindableChildren.Add(new KeyValuePair<string, object>("ignoreErrorsByProjectModel", _IgnoreErrorsByProjectModel));
      BindableChildren.Add(new KeyValuePair<string, object>("copyIssueReport", _CopyIssueReport));
    }
    //secondary constructor
    internal SolutionAnalysisModel (
    ) : this (
      new RdProperty<SolutionAnalysisState>(SolutionAnalysisState.Read, SolutionAnalysisState.Write),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdMap<SolutionAnalysisIdWithContext, SolutionAnalysisErrors>(SolutionAnalysisIdWithContext.Read, SolutionAnalysisIdWithContext.Write, SolutionAnalysisErrors.Read, SolutionAnalysisErrors.Write),
      new RdSignal<SolutionAnalysisIconState>(SolutionAnalysisIconState.Read, SolutionAnalysisIconState.Write),
      new RdSignal<SolutionAnalysisAction>(ReadSolutionAnalysisAction, WriteSolutionAnalysisAction),
      new RdSignal<SolutionAnalysisProjectModelIgnore>(SolutionAnalysisProjectModelIgnore.Read, SolutionAnalysisProjectModelIgnore.Write),
      new RdEndpoint<List<SolutionAnalysisFileWithErrorList>, SolutionAnalysisIssueReport>(ReadSolutionAnalysisFileWithErrorListList, WriteSolutionAnalysisFileWithErrorListList, SolutionAnalysisIssueReport.Read, SolutionAnalysisIssueReport.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisAction> ReadSolutionAnalysisAction = new CtxReadDelegate<SolutionAnalysisAction>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<SolutionAnalysisAction>);
    public static CtxReadDelegate<List<SolutionAnalysisFileWithErrorList>> ReadSolutionAnalysisFileWithErrorListList = SolutionAnalysisFileWithErrorList.Read.List();
    
    public static CtxWriteDelegate<SolutionAnalysisAction> WriteSolutionAnalysisAction = new CtxWriteDelegate<SolutionAnalysisAction>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<SolutionAnalysisAction>);
    public static CtxWriteDelegate<List<SolutionAnalysisFileWithErrorList>> WriteSolutionAnalysisFileWithErrorListList = SolutionAnalysisFileWithErrorList.Write.List();
    
    protected override long SerializationHash => -4513804526561305751L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(SolutionAnalysisError.Read, SolutionAnalysisError.Write);
      serializers.Register(SolutionAnalysisErrorListWithIgnore.Read, SolutionAnalysisErrorListWithIgnore.Write);
      serializers.Register(SolutionAnalysisIdWithContext.Read, SolutionAnalysisIdWithContext.Write);
      serializers.Register(SolutionAnalysisState.Read, SolutionAnalysisState.Write);
      serializers.Register(SolutionAnalysisErrors.Read, SolutionAnalysisErrors.Write);
      serializers.Register(SolutionAnalysisIconState.Read, SolutionAnalysisIconState.Write);
      serializers.RegisterEnum<SolutionAnalysisAction>();
      serializers.Register(SolutionAnalysisProjectModelIgnore.Read, SolutionAnalysisProjectModelIgnore.Write);
      serializers.Register(SolutionAnalysisFileWithErrorList.Read, SolutionAnalysisFileWithErrorList.Write);
      serializers.Register(SolutionAnalysisIssueReport.Read, SolutionAnalysisIssueReport.Write);
      serializers.Register(SolutionAnalysisErrorWithIgnore.Read, SolutionAnalysisErrorWithIgnore.Write);
      serializers.Register(SolutionAnalysisNavigation.Read, SolutionAnalysisNavigation.Write);
      serializers.Register(SolutionAnalysisIgnore.Read, SolutionAnalysisIgnore.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisModel (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); _State.PrintEx(printer); printer.Println();
        printer.Print("setEnabled = "); _SetEnabled.PrintEx(printer); printer.Println();
        printer.Print("setPaused = "); _SetPaused.PrintEx(printer); printer.Println();
        printer.Print("ready = "); _Ready.PrintEx(printer); printer.Println();
        printer.Print("hostReady = "); _HostReady.PrintEx(printer); printer.Println();
        printer.Print("loaded = "); _Loaded.PrintEx(printer); printer.Println();
        printer.Print("includeWarnings = "); _IncludeWarnings.PrintEx(printer); printer.Println();
        printer.Print("fileErrors = "); _FileErrors.PrintEx(printer); printer.Println();
        printer.Print("iconState = "); _IconState.PrintEx(printer); printer.Println();
        printer.Print("runAction = "); _RunAction.PrintEx(printer); printer.Println();
        printer.Print("ignoreErrorsByProjectModel = "); _IgnoreErrorsByProjectModel.PrintEx(printer); printer.Println();
        printer.Print("copyIssueReport = "); _CopyIssueReport.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionSolutionAnalysisModelEx
   {
    public static SolutionAnalysisModel GetSolutionAnalysisModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("solutionAnalysisModel", () => new SolutionAnalysisModel());
    }
  }
  
  
  public enum SolutionAnalysisAction {
    ReanalyzeAll,
    GotoPrevious,
    GotoNext
  }
  
  
  public class SolutionAnalysisError : IPrintable, IEquatable<SolutionAnalysisError>
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public int Offset {get; private set;}
    public bool IsWarning {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisError(
      [NotNull] string text,
      int offset,
      bool isWarning
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      Offset = offset;
      IsWarning = isWarning;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisError> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var offset = reader.ReadInt();
      var isWarning = reader.ReadBool();
      return new SolutionAnalysisError(text, offset, isWarning);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisError> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.Offset);
      writer.Write(value.IsWarning);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisError) obj);
    }
    public bool Equals(SolutionAnalysisError other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && Offset == other.Offset && IsWarning == other.IsWarning;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + IsWarning.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisError (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("isWarning = "); IsWarning.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisErrorListWithIgnore : IPrintable, IEquatable<SolutionAnalysisErrorListWithIgnore>
  {
    //fields
    //public fields
    [NotNull] public List<SolutionAnalysisErrorWithIgnore> Errors {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisErrorListWithIgnore(
      [NotNull] List<SolutionAnalysisErrorWithIgnore> errors
    )
    {
      if (errors == null) throw new ArgumentNullException("errors");
      
      Errors = errors;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisErrorListWithIgnore> Read = (ctx, reader) => 
    {
      var errors = ReadSolutionAnalysisErrorWithIgnoreList(ctx, reader);
      return new SolutionAnalysisErrorListWithIgnore(errors);
    };
    public static CtxReadDelegate<List<SolutionAnalysisErrorWithIgnore>> ReadSolutionAnalysisErrorWithIgnoreList = SolutionAnalysisErrorWithIgnore.Read.List();
    
    public static CtxWriteDelegate<SolutionAnalysisErrorListWithIgnore> Write = (ctx, writer, value) => 
    {
      WriteSolutionAnalysisErrorWithIgnoreList(ctx, writer, value.Errors);
    };
    public static CtxWriteDelegate<List<SolutionAnalysisErrorWithIgnore>> WriteSolutionAnalysisErrorWithIgnoreList = SolutionAnalysisErrorWithIgnore.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisErrorListWithIgnore) obj);
    }
    public bool Equals(SolutionAnalysisErrorListWithIgnore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Errors.SequenceEqual(other.Errors);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Errors);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisErrorListWithIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("errors = "); Errors.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisErrorWithIgnore : IPrintable, IEquatable<SolutionAnalysisErrorWithIgnore>
  {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public int Offset {get; private set;}
    public bool IsWarning {get; private set;}
    public bool Ignored {get; private set;}
    public bool ComesFromRoslyn {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisErrorWithIgnore(
      [NotNull] string text,
      int offset,
      bool isWarning,
      bool ignored,
      bool comesFromRoslyn
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      Offset = offset;
      IsWarning = isWarning;
      Ignored = ignored;
      ComesFromRoslyn = comesFromRoslyn;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisErrorWithIgnore> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var offset = reader.ReadInt();
      var isWarning = reader.ReadBool();
      var ignored = reader.ReadBool();
      var comesFromRoslyn = reader.ReadBool();
      return new SolutionAnalysisErrorWithIgnore(text, offset, isWarning, ignored, comesFromRoslyn);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisErrorWithIgnore> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.Offset);
      writer.Write(value.IsWarning);
      writer.Write(value.Ignored);
      writer.Write(value.ComesFromRoslyn);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisErrorWithIgnore) obj);
    }
    public bool Equals(SolutionAnalysisErrorWithIgnore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && Offset == other.Offset && IsWarning == other.IsWarning && Ignored == other.Ignored && ComesFromRoslyn == other.ComesFromRoslyn;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + IsWarning.GetHashCode();
        hash = hash * 31 + Ignored.GetHashCode();
        hash = hash * 31 + ComesFromRoslyn.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisErrorWithIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("isWarning = "); IsWarning.PrintEx(printer); printer.Println();
        printer.Print("ignored = "); Ignored.PrintEx(printer); printer.Println();
        printer.Print("comesFromRoslyn = "); ComesFromRoslyn.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisErrors : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string FileName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public SolutionAnalysisIdWithContext FileKey {get; private set;}
    [NotNull] public IRdProperty<int> TotalErrorCount { get { return _TotalErrorCount; }}
    [NotNull] public IRdProperty<int> TotalWarningCount { get { return _TotalWarningCount; }}
    [NotNull] public IRdProperty<int> VisibleErrorCount { get { return _VisibleErrorCount; }}
    [NotNull] public IRdProperty<int> VisibleWarningCount { get { return _VisibleWarningCount; }}
    [NotNull] public IRdProperty<SolutionAnalysisErrorListWithIgnore> Errors { get { return _Errors; }}
    [NotNull] public IRdProperty<bool> RequireUpdates { get { return _RequireUpdates; }}
    [NotNull] public ISink<SolutionAnalysisNavigation> NavigateToError { get { return _NavigateToError; }}
    [NotNull] public ISink<SolutionAnalysisIgnore> IgnoreIssues { get { return _IgnoreIssues; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _TotalErrorCount;
    [NotNull] private readonly RdProperty<int> _TotalWarningCount;
    [NotNull] private readonly RdProperty<int> _VisibleErrorCount;
    [NotNull] private readonly RdProperty<int> _VisibleWarningCount;
    [NotNull] private readonly RdProperty<SolutionAnalysisErrorListWithIgnore> _Errors;
    [NotNull] private readonly RdProperty<bool> _RequireUpdates;
    [NotNull] private readonly RdSignal<SolutionAnalysisNavigation> _NavigateToError;
    [NotNull] private readonly RdSignal<SolutionAnalysisIgnore> _IgnoreIssues;
    
    //primary constructor
    private SolutionAnalysisErrors(
      [NotNull] string fileName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] SolutionAnalysisIdWithContext fileKey,
      [NotNull] RdProperty<int> totalErrorCount,
      [NotNull] RdProperty<int> totalWarningCount,
      [NotNull] RdProperty<int> visibleErrorCount,
      [NotNull] RdProperty<int> visibleWarningCount,
      [NotNull] RdProperty<SolutionAnalysisErrorListWithIgnore> errors,
      [NotNull] RdProperty<bool> requireUpdates,
      [NotNull] RdSignal<SolutionAnalysisNavigation> navigateToError,
      [NotNull] RdSignal<SolutionAnalysisIgnore> ignoreIssues
    )
    {
      if (fileName == null) throw new ArgumentNullException("fileName");
      if (fileKey == null) throw new ArgumentNullException("fileKey");
      if (totalErrorCount == null) throw new ArgumentNullException("totalErrorCount");
      if (totalWarningCount == null) throw new ArgumentNullException("totalWarningCount");
      if (visibleErrorCount == null) throw new ArgumentNullException("visibleErrorCount");
      if (visibleWarningCount == null) throw new ArgumentNullException("visibleWarningCount");
      if (errors == null) throw new ArgumentNullException("errors");
      if (requireUpdates == null) throw new ArgumentNullException("requireUpdates");
      if (navigateToError == null) throw new ArgumentNullException("navigateToError");
      if (ignoreIssues == null) throw new ArgumentNullException("ignoreIssues");
      
      FileName = fileName;
      Icon = icon;
      FileKey = fileKey;
      _TotalErrorCount = totalErrorCount;
      _TotalWarningCount = totalWarningCount;
      _VisibleErrorCount = visibleErrorCount;
      _VisibleWarningCount = visibleWarningCount;
      _Errors = errors;
      _RequireUpdates = requireUpdates;
      _NavigateToError = navigateToError;
      _IgnoreIssues = ignoreIssues;
      _TotalErrorCount.OptimizeNested = true;
      _TotalWarningCount.OptimizeNested = true;
      _VisibleErrorCount.OptimizeNested = true;
      _VisibleWarningCount.OptimizeNested = true;
      _Errors.OptimizeNested = true;
      _RequireUpdates.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("totalErrorCount", _TotalErrorCount));
      BindableChildren.Add(new KeyValuePair<string, object>("totalWarningCount", _TotalWarningCount));
      BindableChildren.Add(new KeyValuePair<string, object>("visibleErrorCount", _VisibleErrorCount));
      BindableChildren.Add(new KeyValuePair<string, object>("visibleWarningCount", _VisibleWarningCount));
      BindableChildren.Add(new KeyValuePair<string, object>("errors", _Errors));
      BindableChildren.Add(new KeyValuePair<string, object>("requireUpdates", _RequireUpdates));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateToError", _NavigateToError));
      BindableChildren.Add(new KeyValuePair<string, object>("ignoreIssues", _IgnoreIssues));
    }
    //secondary constructor
    public SolutionAnalysisErrors (
      [NotNull] string fileName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] SolutionAnalysisIdWithContext fileKey
    ) : this (
      fileName,
      icon,
      fileKey,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<SolutionAnalysisErrorListWithIgnore>(SolutionAnalysisErrorListWithIgnore.Read, SolutionAnalysisErrorListWithIgnore.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<SolutionAnalysisNavigation>(SolutionAnalysisNavigation.Read, SolutionAnalysisNavigation.Write),
      new RdSignal<SolutionAnalysisIgnore>(SolutionAnalysisIgnore.Read, SolutionAnalysisIgnore.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisErrors> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var fileName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var fileKey = SolutionAnalysisIdWithContext.Read(ctx, reader);
      var totalErrorCount = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var totalWarningCount = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var visibleErrorCount = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var visibleWarningCount = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var errors = RdProperty<SolutionAnalysisErrorListWithIgnore>.Read(ctx, reader, SolutionAnalysisErrorListWithIgnore.Read, SolutionAnalysisErrorListWithIgnore.Write);
      var requireUpdates = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigateToError = RdSignal<SolutionAnalysisNavigation>.Read(ctx, reader, SolutionAnalysisNavigation.Read, SolutionAnalysisNavigation.Write);
      var ignoreIssues = RdSignal<SolutionAnalysisIgnore>.Read(ctx, reader, SolutionAnalysisIgnore.Read, SolutionAnalysisIgnore.Write);
      return new SolutionAnalysisErrors(fileName, icon, fileKey, totalErrorCount, totalWarningCount, visibleErrorCount, visibleWarningCount, errors, requireUpdates, navigateToError, ignoreIssues).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<SolutionAnalysisErrors> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.FileName);
      WriteIconNullable(ctx, writer, value.Icon);
      SolutionAnalysisIdWithContext.Write(ctx, writer, value.FileKey);
      RdProperty<int>.Write(ctx, writer, value._TotalErrorCount);
      RdProperty<int>.Write(ctx, writer, value._TotalWarningCount);
      RdProperty<int>.Write(ctx, writer, value._VisibleErrorCount);
      RdProperty<int>.Write(ctx, writer, value._VisibleWarningCount);
      RdProperty<SolutionAnalysisErrorListWithIgnore>.Write(ctx, writer, value._Errors);
      RdProperty<bool>.Write(ctx, writer, value._RequireUpdates);
      RdSignal<SolutionAnalysisNavigation>.Write(ctx, writer, value._NavigateToError);
      RdSignal<SolutionAnalysisIgnore>.Write(ctx, writer, value._IgnoreIssues);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisErrors (");
      using (printer.IndentCookie()) {
        printer.Print("fileName = "); FileName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("fileKey = "); FileKey.PrintEx(printer); printer.Println();
        printer.Print("totalErrorCount = "); _TotalErrorCount.PrintEx(printer); printer.Println();
        printer.Print("totalWarningCount = "); _TotalWarningCount.PrintEx(printer); printer.Println();
        printer.Print("visibleErrorCount = "); _VisibleErrorCount.PrintEx(printer); printer.Println();
        printer.Print("visibleWarningCount = "); _VisibleWarningCount.PrintEx(printer); printer.Println();
        printer.Print("errors = "); _Errors.PrintEx(printer); printer.Println();
        printer.Print("requireUpdates = "); _RequireUpdates.PrintEx(printer); printer.Println();
        printer.Print("navigateToError = "); _NavigateToError.PrintEx(printer); printer.Println();
        printer.Print("ignoreIssues = "); _IgnoreIssues.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisFileWithErrorList : IPrintable, IEquatable<SolutionAnalysisFileWithErrorList>
  {
    //fields
    //public fields
    [NotNull] public SolutionAnalysisIdWithContext File {get; private set;}
    [NotNull] public List<SolutionAnalysisError> Issues {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisFileWithErrorList(
      [NotNull] SolutionAnalysisIdWithContext file,
      [NotNull] List<SolutionAnalysisError> issues
    )
    {
      if (file == null) throw new ArgumentNullException("file");
      if (issues == null) throw new ArgumentNullException("issues");
      
      File = file;
      Issues = issues;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisFileWithErrorList> Read = (ctx, reader) => 
    {
      var file = SolutionAnalysisIdWithContext.Read(ctx, reader);
      var issues = ReadSolutionAnalysisErrorList(ctx, reader);
      return new SolutionAnalysisFileWithErrorList(file, issues);
    };
    public static CtxReadDelegate<List<SolutionAnalysisError>> ReadSolutionAnalysisErrorList = SolutionAnalysisError.Read.List();
    
    public static CtxWriteDelegate<SolutionAnalysisFileWithErrorList> Write = (ctx, writer, value) => 
    {
      SolutionAnalysisIdWithContext.Write(ctx, writer, value.File);
      WriteSolutionAnalysisErrorList(ctx, writer, value.Issues);
    };
    public static CtxWriteDelegate<List<SolutionAnalysisError>> WriteSolutionAnalysisErrorList = SolutionAnalysisError.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisFileWithErrorList) obj);
    }
    public bool Equals(SolutionAnalysisFileWithErrorList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(File, other.File) && Issues.SequenceEqual(other.Issues);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + File.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Issues);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisFileWithErrorList (");
      using (printer.IndentCookie()) {
        printer.Print("file = "); File.PrintEx(printer); printer.Println();
        printer.Print("issues = "); Issues.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisIconState : IPrintable, IEquatable<SolutionAnalysisIconState>
  {
    //fields
    //public fields
    [NotNull] public List<Icon> Icons {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public string Tooltip {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisIconState(
      [NotNull] List<Icon> icons,
      [NotNull] string text,
      [NotNull] string tooltip
    )
    {
      if (icons == null) throw new ArgumentNullException("icons");
      if (text == null) throw new ArgumentNullException("text");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      
      Icons = icons;
      Text = text;
      Tooltip = tooltip;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisIconState> Read = (ctx, reader) => 
    {
      var icons = ReadIconList(ctx, reader);
      var text = reader.ReadString();
      var tooltip = reader.ReadString();
      return new SolutionAnalysisIconState(icons, text, tooltip);
    };
    public static CtxReadDelegate<List<Icon>> ReadIconList = Icon.Read.List();
    
    public static CtxWriteDelegate<SolutionAnalysisIconState> Write = (ctx, writer, value) => 
    {
      WriteIconList(ctx, writer, value.Icons);
      writer.Write(value.Text);
      writer.Write(value.Tooltip);
    };
    public static CtxWriteDelegate<List<Icon>> WriteIconList = Icon.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisIconState) obj);
    }
    public bool Equals(SolutionAnalysisIconState other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Icons.SequenceEqual(other.Icons) && Text == other.Text && Tooltip == other.Tooltip;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Icons);
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + Tooltip.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisIconState (");
      using (printer.IndentCookie()) {
        printer.Print("icons = "); Icons.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisIdWithContext : IPrintable, IEquatable<SolutionAnalysisIdWithContext>
  {
    //fields
    //public fields
    public int FileId {get; private set;}
    [NotNull] public string Context {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisIdWithContext(
      int fileId,
      [NotNull] string context
    )
    {
      if (context == null) throw new ArgumentNullException("context");
      
      FileId = fileId;
      Context = context;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisIdWithContext> Read = (ctx, reader) => 
    {
      var fileId = reader.ReadInt();
      var context = reader.ReadString();
      return new SolutionAnalysisIdWithContext(fileId, context);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisIdWithContext> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FileId);
      writer.Write(value.Context);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisIdWithContext) obj);
    }
    public bool Equals(SolutionAnalysisIdWithContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FileId == other.FileId && Context == other.Context;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FileId.GetHashCode();
        hash = hash * 31 + Context.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisIdWithContext (");
      using (printer.IndentCookie()) {
        printer.Print("fileId = "); FileId.PrintEx(printer); printer.Println();
        printer.Print("context = "); Context.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisIgnore : IPrintable, IEquatable<SolutionAnalysisIgnore>
  {
    //fields
    //public fields
    [NotNull] public List<SolutionAnalysisError> Issues {get; private set;}
    public bool Ignore {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisIgnore(
      [NotNull] List<SolutionAnalysisError> issues,
      bool ignore
    )
    {
      if (issues == null) throw new ArgumentNullException("issues");
      
      Issues = issues;
      Ignore = ignore;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisIgnore> Read = (ctx, reader) => 
    {
      var issues = ReadSolutionAnalysisErrorList(ctx, reader);
      var ignore = reader.ReadBool();
      return new SolutionAnalysisIgnore(issues, ignore);
    };
    public static CtxReadDelegate<List<SolutionAnalysisError>> ReadSolutionAnalysisErrorList = SolutionAnalysisError.Read.List();
    
    public static CtxWriteDelegate<SolutionAnalysisIgnore> Write = (ctx, writer, value) => 
    {
      WriteSolutionAnalysisErrorList(ctx, writer, value.Issues);
      writer.Write(value.Ignore);
    };
    public static CtxWriteDelegate<List<SolutionAnalysisError>> WriteSolutionAnalysisErrorList = SolutionAnalysisError.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisIgnore) obj);
    }
    public bool Equals(SolutionAnalysisIgnore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Issues.SequenceEqual(other.Issues) && Ignore == other.Ignore;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Issues);
        hash = hash * 31 + Ignore.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("issues = "); Issues.PrintEx(printer); printer.Println();
        printer.Print("ignore = "); Ignore.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisIssueReport : IPrintable, IEquatable<SolutionAnalysisIssueReport>
  {
    //fields
    //public fields
    [NotNull] public string PlainText {get; private set;}
    [NotNull] public string HtmlText {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisIssueReport(
      [NotNull] string plainText,
      [NotNull] string htmlText
    )
    {
      if (plainText == null) throw new ArgumentNullException("plainText");
      if (htmlText == null) throw new ArgumentNullException("htmlText");
      
      PlainText = plainText;
      HtmlText = htmlText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisIssueReport> Read = (ctx, reader) => 
    {
      var plainText = reader.ReadString();
      var htmlText = reader.ReadString();
      return new SolutionAnalysisIssueReport(plainText, htmlText);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisIssueReport> Write = (ctx, writer, value) => 
    {
      writer.Write(value.PlainText);
      writer.Write(value.HtmlText);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisIssueReport) obj);
    }
    public bool Equals(SolutionAnalysisIssueReport other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return PlainText == other.PlainText && HtmlText == other.HtmlText;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + PlainText.GetHashCode();
        hash = hash * 31 + HtmlText.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisIssueReport (");
      using (printer.IndentCookie()) {
        printer.Print("plainText = "); PlainText.PrintEx(printer); printer.Println();
        printer.Print("htmlText = "); HtmlText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisNavigation : IPrintable, IEquatable<SolutionAnalysisNavigation>
  {
    //fields
    //public fields
    public int Offset {get; private set;}
    public bool Activate {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisNavigation(
      int offset,
      bool activate
    )
    {
      Offset = offset;
      Activate = activate;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisNavigation> Read = (ctx, reader) => 
    {
      var offset = reader.ReadInt();
      var activate = reader.ReadBool();
      return new SolutionAnalysisNavigation(offset, activate);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisNavigation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Offset);
      writer.Write(value.Activate);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisNavigation) obj);
    }
    public bool Equals(SolutionAnalysisNavigation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Offset == other.Offset && Activate == other.Activate;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + Activate.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisNavigation (");
      using (printer.IndentCookie()) {
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("activate = "); Activate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisProjectModelIgnore : IPrintable, IEquatable<SolutionAnalysisProjectModelIgnore>
  {
    //fields
    //public fields
    [NotNull] public List<int> NodeIDs {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisProjectModelIgnore(
      [NotNull] List<int> nodeIDs
    )
    {
      if (nodeIDs == null) throw new ArgumentNullException("nodeIDs");
      
      NodeIDs = nodeIDs;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisProjectModelIgnore> Read = (ctx, reader) => 
    {
      var nodeIDs = ReadIntList(ctx, reader);
      return new SolutionAnalysisProjectModelIgnore(nodeIDs);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<SolutionAnalysisProjectModelIgnore> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.NodeIDs);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisProjectModelIgnore) obj);
    }
    public bool Equals(SolutionAnalysisProjectModelIgnore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return NodeIDs.SequenceEqual(other.NodeIDs);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(NodeIDs);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisProjectModelIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("nodeIDs = "); NodeIDs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisState : RdBindableBase
  {
    //fields
    //public fields
    public bool Enabled {get; private set;}
    public bool Paused {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionAnalysisState(
      bool enabled,
      bool paused
    )
    {
      Enabled = enabled;
      Paused = paused;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisState> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = reader.ReadBool();
      var paused = reader.ReadBool();
      return new SolutionAnalysisState(enabled, paused).WithId(_id);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisState> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Enabled);
      writer.Write(value.Paused);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisState (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); Enabled.PrintEx(printer); printer.Println();
        printer.Print("paused = "); Paused.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
