using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class StackTraceFilterProvider : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<string, List<StackTraceHighlighter>> ApplyFilter { get { return _ApplyFilter; }}
    [NotNull] public ISink<StackTraceNavigationPoint> Navigate { get { return _Navigate; }}
    [NotNull] public ISource<StackTraceConsole> ShowConsole { get { return _ShowConsole; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<string, List<StackTraceHighlighter>> _ApplyFilter;
    [NotNull] private readonly RdSignal<StackTraceNavigationPoint> _Navigate;
    [NotNull] private readonly RdSignal<StackTraceConsole> _ShowConsole;
    
    //primary constructor
    private StackTraceFilterProvider(
      [NotNull] RdEndpoint<string, List<StackTraceHighlighter>> applyFilter,
      [NotNull] RdSignal<StackTraceNavigationPoint> navigate,
      [NotNull] RdSignal<StackTraceConsole> showConsole
    )
    {
      if (applyFilter == null) throw new ArgumentNullException("applyFilter");
      if (navigate == null) throw new ArgumentNullException("navigate");
      if (showConsole == null) throw new ArgumentNullException("showConsole");
      
      _ApplyFilter = applyFilter;
      _Navigate = navigate;
      _ShowConsole = showConsole;
      _ApplyFilter.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("applyFilter", _ApplyFilter));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
      BindableChildren.Add(new KeyValuePair<string, object>("showConsole", _ShowConsole));
    }
    //secondary constructor
    internal StackTraceFilterProvider (
    ) : this (
      new RdEndpoint<string, List<StackTraceHighlighter>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ReadStackTraceHighlighterList, WriteStackTraceHighlighterList),
      new RdSignal<StackTraceNavigationPoint>(StackTraceNavigationPoint.Read, StackTraceNavigationPoint.Write),
      new RdSignal<StackTraceConsole>(StackTraceConsole.Read, StackTraceConsole.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<List<StackTraceHighlighter>> ReadStackTraceHighlighterList = StackTraceHighlighter.Read.List();
    
    public static CtxWriteDelegate<List<StackTraceHighlighter>> WriteStackTraceHighlighterList = StackTraceHighlighter.Write.List();
    
    protected override long SerializationHash => 4459571342171084254L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(StackTraceFileHyperlinkHighlighter.Read, StackTraceFileHyperlinkHighlighter.Write);
      serializers.Register(StackTraceHyperlinkHighlighter.Read, StackTraceHyperlinkHighlighter.Write);
      serializers.Register(StackTraceIdentifierHighlighter.Read, StackTraceIdentifierHighlighter.Write);
      serializers.Register(StackTraceNavigationPoint.Read, StackTraceNavigationPoint.Write);
      serializers.Register(StackTraceConsole.Read, StackTraceConsole.Write);
      serializers.Register(StackTraceHighlighter_Unknown.Read, StackTraceHighlighter_Unknown.Write);
      serializers.Register(StackTraceHyperlinkHighlighterBase_Unknown.Read, StackTraceHyperlinkHighlighterBase_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceFilterProvider (");
      using (printer.IndentCookie()) {
        printer.Print("applyFilter = "); _ApplyFilter.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("showConsole = "); _ShowConsole.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionStackTraceFilterProviderEx
   {
    public static StackTraceFilterProvider GetStackTraceFilterProvider(this Solution solution)
    {
      return solution.GetOrCreateExtension("stackTraceFilterProvider", () => new StackTraceFilterProvider());
    }
  }
  
  
  public class StackTraceConsole : IPrintable, IEquatable<StackTraceConsole>
  {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Content {get; private set;}
    
    //private fields
    //primary constructor
    public StackTraceConsole(
      [NotNull] string title,
      [NotNull] string content
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (content == null) throw new ArgumentNullException("content");
      
      Title = title;
      Content = content;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<StackTraceConsole> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var content = reader.ReadString();
      return new StackTraceConsole(title, content);
    };
    
    public static CtxWriteDelegate<StackTraceConsole> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.Content);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceConsole) obj);
    }
    public bool Equals(StackTraceConsole other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Title == other.Title && Content == other.Content;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + Content.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceConsole (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceFileHyperlinkHighlighter : StackTraceHyperlinkHighlighterBase
  {
    //fields
    //public fields
    [NotNull] public string FilePath {get; private set;}
    public int Line {get; private set;}
    
    //private fields
    //primary constructor
    public StackTraceFileHyperlinkHighlighter(
      [NotNull] string filePath,
      int line,
      bool includeInOccurenceNavigation,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      includeInOccurenceNavigation,
      id,
      attributeId,
      start,
      end
     ) 
    {
      if (filePath == null) throw new ArgumentNullException("filePath");
      
      FilePath = filePath;
      Line = line;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceFileHyperlinkHighlighter> Read = (ctx, reader) => 
    {
      var includeInOccurenceNavigation = reader.ReadBool();
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var filePath = reader.ReadString();
      var line = reader.ReadInt();
      return new StackTraceFileHyperlinkHighlighter(filePath, line, includeInOccurenceNavigation, id, attributeId, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceFileHyperlinkHighlighter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IncludeInOccurenceNavigation);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write(value.FilePath);
      writer.Write(value.Line);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceFileHyperlinkHighlighter) obj);
    }
    public bool Equals(StackTraceFileHyperlinkHighlighter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FilePath == other.FilePath && Line == other.Line && IncludeInOccurenceNavigation == other.IncludeInOccurenceNavigation && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FilePath.GetHashCode();
        hash = hash * 31 + Line.GetHashCode();
        hash = hash * 31 + IncludeInOccurenceNavigation.GetHashCode();
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceFileHyperlinkHighlighter (");
      using (printer.IndentCookie()) {
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("includeInOccurenceNavigation = "); IncludeInOccurenceNavigation.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class StackTraceHighlighter : LightweightHighlighter
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    protected StackTraceHighlighter(
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHighlighter> Read = Polymorphic<StackTraceHighlighter>.ReadAbstract(StackTraceHighlighter_Unknown.Read);
    
    public static new CtxWriteDelegate<StackTraceHighlighter> Write = Polymorphic<StackTraceHighlighter>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class StackTraceHighlighter_Unknown : StackTraceHighlighter
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public StackTraceHighlighter_Unknown(
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHighlighter_Unknown> Read = (ctx, reader) => 
    {
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new StackTraceHighlighter_Unknown(id, attributeId, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceHighlighter_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceHighlighter_Unknown) obj);
    }
    public bool Equals(StackTraceHighlighter_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceHighlighter_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceHyperlinkHighlighter : StackTraceHyperlinkHighlighterBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public StackTraceHyperlinkHighlighter(
      bool includeInOccurenceNavigation,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      includeInOccurenceNavigation,
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHyperlinkHighlighter> Read = (ctx, reader) => 
    {
      var includeInOccurenceNavigation = reader.ReadBool();
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new StackTraceHyperlinkHighlighter(includeInOccurenceNavigation, id, attributeId, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceHyperlinkHighlighter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IncludeInOccurenceNavigation);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceHyperlinkHighlighter) obj);
    }
    public bool Equals(StackTraceHyperlinkHighlighter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IncludeInOccurenceNavigation == other.IncludeInOccurenceNavigation && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IncludeInOccurenceNavigation.GetHashCode();
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceHyperlinkHighlighter (");
      using (printer.IndentCookie()) {
        printer.Print("includeInOccurenceNavigation = "); IncludeInOccurenceNavigation.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class StackTraceHyperlinkHighlighterBase : StackTraceHighlighter
  {
    //fields
    //public fields
    public bool IncludeInOccurenceNavigation {get; private set;}
    
    //private fields
    //primary constructor
    protected StackTraceHyperlinkHighlighterBase(
      bool includeInOccurenceNavigation,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      id,
      attributeId,
      start,
      end
     ) 
    {
      IncludeInOccurenceNavigation = includeInOccurenceNavigation;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHyperlinkHighlighterBase> Read = Polymorphic<StackTraceHyperlinkHighlighterBase>.ReadAbstract(StackTraceHyperlinkHighlighterBase_Unknown.Read);
    
    public static new CtxWriteDelegate<StackTraceHyperlinkHighlighterBase> Write = Polymorphic<StackTraceHyperlinkHighlighterBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class StackTraceHyperlinkHighlighterBase_Unknown : StackTraceHyperlinkHighlighterBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public StackTraceHyperlinkHighlighterBase_Unknown(
      bool includeInOccurenceNavigation,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      includeInOccurenceNavigation,
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHyperlinkHighlighterBase_Unknown> Read = (ctx, reader) => 
    {
      var includeInOccurenceNavigation = reader.ReadBool();
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new StackTraceHyperlinkHighlighterBase_Unknown(includeInOccurenceNavigation, id, attributeId, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceHyperlinkHighlighterBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IncludeInOccurenceNavigation);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceHyperlinkHighlighterBase_Unknown) obj);
    }
    public bool Equals(StackTraceHyperlinkHighlighterBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IncludeInOccurenceNavigation == other.IncludeInOccurenceNavigation && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IncludeInOccurenceNavigation.GetHashCode();
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceHyperlinkHighlighterBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("includeInOccurenceNavigation = "); IncludeInOccurenceNavigation.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceIdentifierHighlighter : StackTraceHighlighter
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public StackTraceIdentifierHighlighter(
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceIdentifierHighlighter> Read = (ctx, reader) => 
    {
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new StackTraceIdentifierHighlighter(id, attributeId, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceIdentifierHighlighter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceIdentifierHighlighter) obj);
    }
    public bool Equals(StackTraceIdentifierHighlighter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceIdentifierHighlighter (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceNavigationPoint : IPrintable, IEquatable<StackTraceNavigationPoint>
  {
    //fields
    //public fields
    [NotNull] public string Line {get; private set;}
    [NotNull] public StackTraceHyperlinkHighlighter Hyperlink {get; private set;}
    
    //private fields
    //primary constructor
    public StackTraceNavigationPoint(
      [NotNull] string line,
      [NotNull] StackTraceHyperlinkHighlighter hyperlink
    )
    {
      if (line == null) throw new ArgumentNullException("line");
      if (hyperlink == null) throw new ArgumentNullException("hyperlink");
      
      Line = line;
      Hyperlink = hyperlink;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<StackTraceNavigationPoint> Read = (ctx, reader) => 
    {
      var line = reader.ReadString();
      var hyperlink = StackTraceHyperlinkHighlighter.Read(ctx, reader);
      return new StackTraceNavigationPoint(line, hyperlink);
    };
    
    public static CtxWriteDelegate<StackTraceNavigationPoint> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Line);
      StackTraceHyperlinkHighlighter.Write(ctx, writer, value.Hyperlink);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceNavigationPoint) obj);
    }
    public bool Equals(StackTraceNavigationPoint other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Line == other.Line && Equals(Hyperlink, other.Hyperlink);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Line.GetHashCode();
        hash = hash * 31 + Hyperlink.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceNavigationPoint (");
      using (printer.IndentCookie()) {
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("hyperlink = "); Hyperlink.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
