using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class TestModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<RdVoid, RdVoid> SyncImpulse { get { return _SyncImpulse; }}
    [NotNull] public RdEndpoint<string, RdVoid> RefreshVFS { get { return _RefreshVFS; }}
    [NotNull] public IViewableList<string> EnabledInspections { get { return _EnabledInspections; }}
    [NotNull] public IViewableList<TestModeFlag> TestModeFlags { get { return _TestModeFlags; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _SyncImpulse;
    [NotNull] private readonly RdEndpoint<string, RdVoid> _RefreshVFS;
    [NotNull] private readonly RdList<string> _EnabledInspections;
    [NotNull] private readonly RdList<TestModeFlag> _TestModeFlags;
    
    //primary constructor
    private TestModel(
      [NotNull] RdEndpoint<RdVoid, RdVoid> syncImpulse,
      [NotNull] RdEndpoint<string, RdVoid> refreshVFS,
      [NotNull] RdList<string> enabledInspections,
      [NotNull] RdList<TestModeFlag> testModeFlags
    )
    {
      if (syncImpulse == null) throw new ArgumentNullException("syncImpulse");
      if (refreshVFS == null) throw new ArgumentNullException("refreshVFS");
      if (enabledInspections == null) throw new ArgumentNullException("enabledInspections");
      if (testModeFlags == null) throw new ArgumentNullException("testModeFlags");
      
      _SyncImpulse = syncImpulse;
      _RefreshVFS = refreshVFS;
      _EnabledInspections = enabledInspections;
      _TestModeFlags = testModeFlags;
      _EnabledInspections.OptimizeNested = true;
      _TestModeFlags.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("syncImpulse", _SyncImpulse));
      BindableChildren.Add(new KeyValuePair<string, object>("refreshVFS", _RefreshVFS));
      BindableChildren.Add(new KeyValuePair<string, object>("enabledInspections", _EnabledInspections));
      BindableChildren.Add(new KeyValuePair<string, object>("testModeFlags", _TestModeFlags));
    }
    //secondary constructor
    private TestModel (
    ) : this (
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<string, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdList<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdList<TestModeFlag>(TestModeFlag.Read, TestModeFlag.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 1368043992507720570L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(DefaultNameDataConstant.Read, DefaultNameDataConstant.Write);
      serializers.Register(TestModeBooleanFlag.Read, TestModeBooleanFlag.Write);
      serializers.Register(TestModeStringFlag.Read, TestModeStringFlag.Write);
      serializers.Register(TestModeFlag_Unknown.Read, TestModeFlag_Unknown.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public TestModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TestModel (");
      using (printer.IndentCookie()) {
        printer.Print("syncImpulse = "); _SyncImpulse.PrintEx(printer); printer.Println();
        printer.Print("refreshVFS = "); _RefreshVFS.PrintEx(printer); printer.Println();
        printer.Print("enabledInspections = "); _EnabledInspections.PrintEx(printer); printer.Println();
        printer.Print("testModeFlags = "); _TestModeFlags.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DefaultNameDataConstant : RdDataConstant
  {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    
    //private fields
    //primary constructor
    public DefaultNameDataConstant(
      [NotNull] string name
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      
      Name = name;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DefaultNameDataConstant> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      return new DefaultNameDataConstant(name);
    };
    
    public static new CtxWriteDelegate<DefaultNameDataConstant> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DefaultNameDataConstant) obj);
    }
    public bool Equals(DefaultNameDataConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DefaultNameDataConstant (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TestModeBooleanFlag : TestModeFlag
  {
    //fields
    //public fields
    public bool BooleanValue {get; private set;}
    
    //private fields
    //primary constructor
    public TestModeBooleanFlag(
      bool booleanValue,
      [NotNull] string name
    ) : base (
      name
     ) 
    {
      BooleanValue = booleanValue;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<TestModeBooleanFlag> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var booleanValue = reader.ReadBool();
      return new TestModeBooleanFlag(booleanValue, name);
    };
    
    public static new CtxWriteDelegate<TestModeBooleanFlag> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.BooleanValue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TestModeBooleanFlag) obj);
    }
    public bool Equals(TestModeBooleanFlag other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return BooleanValue == other.BooleanValue && Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + BooleanValue.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TestModeBooleanFlag (");
      using (printer.IndentCookie()) {
        printer.Print("booleanValue = "); BooleanValue.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class TestModeFlag{
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    
    //private fields
    //primary constructor
    protected TestModeFlag(
      [NotNull] string name
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      
      Name = name;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TestModeFlag> Read = Polymorphic<TestModeFlag>.ReadAbstract(TestModeFlag_Unknown.Read);
    
    public static CtxWriteDelegate<TestModeFlag> Write = Polymorphic<TestModeFlag>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class TestModeFlag_Unknown : TestModeFlag
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    public TestModeFlag_Unknown(
      [NotNull] string name
    ) : base (
      name
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<TestModeFlag_Unknown> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      return new TestModeFlag_Unknown(name);
    };
    
    public static new CtxWriteDelegate<TestModeFlag_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TestModeFlag_Unknown) obj);
    }
    public bool Equals(TestModeFlag_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TestModeFlag_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TestModeStringFlag : TestModeFlag
  {
    //fields
    //public fields
    [NotNull] public string StringValue {get; private set;}
    
    //private fields
    //primary constructor
    public TestModeStringFlag(
      [NotNull] string stringValue,
      [NotNull] string name
    ) : base (
      name
     ) 
    {
      if (stringValue == null) throw new ArgumentNullException("stringValue");
      
      StringValue = stringValue;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<TestModeStringFlag> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var stringValue = reader.ReadString();
      return new TestModeStringFlag(stringValue, name);
    };
    
    public static new CtxWriteDelegate<TestModeStringFlag> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.StringValue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TestModeStringFlag) obj);
    }
    public bool Equals(TestModeStringFlag other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StringValue == other.StringValue && Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + StringValue.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TestModeStringFlag (");
      using (printer.IndentCookie()) {
        printer.Print("stringValue = "); StringValue.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
