using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Tooltips
{
  
  
  public class TooltipsModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public ISource<TooltipDescriptor> Message { get { return _Message; }}
    
    //private fields
    [NotNull] private readonly RdSignal<TooltipDescriptor> _Message;
    
    //primary constructor
    private TooltipsModel(
      [NotNull] RdSignal<TooltipDescriptor> message
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      
      _Message = message;
      BindableChildren.Add(new KeyValuePair<string, object>("message", _Message));
    }
    //secondary constructor
    private TooltipsModel (
    ) : this (
      new RdSignal<TooltipDescriptor>(TooltipDescriptor.Read, TooltipDescriptor.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -2795958535345101747L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<TooltipType>();
      serializers.Register(TooltipDescriptor.Read, TooltipDescriptor.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public TooltipsModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TooltipsModel (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); _Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TooltipDescriptor : IPrintable, IEquatable<TooltipDescriptor>
  {
    //fields
    //public fields
    public TooltipType Type {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps {get; private set;}
    
    //private fields
    //primary constructor
    public TooltipDescriptor(
      TooltipType type,
      [NotNull] string text,
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (timestamps == null) throw new ArgumentNullException("timestamps");
      
      Type = type;
      Text = text;
      Timestamps = timestamps;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TooltipDescriptor> Read = (ctx, reader) => 
    {
      var type = (TooltipType)reader.ReadInt();
      var text = reader.ReadString();
      var timestamps = ReadContextPairList(ctx, reader);
      return new TooltipDescriptor(type, text, timestamps);
    };
    public static CtxReadDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> ReadContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Read.List();
    
    public static CtxWriteDelegate<TooltipDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Type);
      writer.Write(value.Text);
      WriteContextPairList(ctx, writer, value.Timestamps);
    };
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> WriteContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TooltipDescriptor) obj);
    }
    public bool Equals(TooltipDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Text == other.Text && Timestamps.SequenceEqual(other.Timestamps);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Type;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Timestamps);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TooltipDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("timestamps = "); Timestamps.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum TooltipType {
    ERROR,
    INFO
  }
}
