using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class TypeHierarchyModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdTypeHierarchyTree> Sessions { get { return _Sessions; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdTypeHierarchyTree> _Sessions;
    
    //primary constructor
    private TypeHierarchyModel(
      [NotNull] RdMap<int, RdTypeHierarchyTree> sessions
    )
    {
      if (sessions == null) throw new ArgumentNullException("sessions");
      
      _Sessions = sessions;
      BindableChildren.Add(new KeyValuePair<string, object>("sessions", _Sessions));
    }
    //secondary constructor
    internal TypeHierarchyModel (
    ) : this (
      new RdMap<int, RdTypeHierarchyTree>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdTypeHierarchyTree.Read, RdTypeHierarchyTree.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 6896965459158508486L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<TypeHierarchyViewStyle>();
      serializers.Register(RdTypeHierarchyTreeSelectedItemConstant.Read, RdTypeHierarchyTreeSelectedItemConstant.Write);
      serializers.Register(RdTypeHierarchyTreeItem.Read, RdTypeHierarchyTreeItem.Write);
      serializers.Register(RdTypeHierarchyTreeView.Read, RdTypeHierarchyTreeView.Write);
      serializers.Register(RdTypeHierarchyTree.Read, RdTypeHierarchyTree.Write);
      serializers.Register(RdTypeHierarchyTreeNavigateArgs.Read, RdTypeHierarchyTreeNavigateArgs.Write);
      serializers.Register(RdTypeHierarchyTreeBuildViewArgs.Read, RdTypeHierarchyTreeBuildViewArgs.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TypeHierarchyModel (");
      using (printer.IndentCookie()) {
        printer.Print("sessions = "); _Sessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionTypeHierarchyModelEx
   {
    public static TypeHierarchyModel GetTypeHierarchyModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("typeHierarchyModel", () => new TypeHierarchyModel());
    }
  }
  
  
  public class RdTypeHierarchyTree : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> BaseTypeName { get { return _BaseTypeName; }}
    [NotNull] public IRdProperty<string> BaseTypeContainerInfo { get { return _BaseTypeContainerInfo; }}
    [NotNull] public IRdProperty<TypeHierarchyViewStyle?> ViewToObserveChanges { get { return _ViewToObserveChanges; }}
    [NotNull] public IRdSignal<RdVoid> Refresh { get { return _Refresh; }}
    [NotNull] public IRdProperty<bool> IsRefreshing { get { return _IsRefreshing; }}
    [NotNull] public IViewableMap<TypeHierarchyViewStyle, RdTypeHierarchyTreeView> Views { get { return _Views; }}
    [NotNull] public IRdSignal<RdTypeHierarchyTreeBuildViewArgs> BuildView { get { return _BuildView; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _BaseTypeName;
    [NotNull] private readonly RdProperty<string> _BaseTypeContainerInfo;
    [NotNull] private readonly RdProperty<TypeHierarchyViewStyle?> _ViewToObserveChanges;
    [NotNull] private readonly RdSignal<RdVoid> _Refresh;
    [NotNull] private readonly RdProperty<bool> _IsRefreshing;
    [NotNull] private readonly RdMap<TypeHierarchyViewStyle, RdTypeHierarchyTreeView> _Views;
    [NotNull] private readonly RdSignal<RdTypeHierarchyTreeBuildViewArgs> _BuildView;
    
    private SerializationCtx mySerializationContext;
    public override SerializationCtx SerializationContext { get { return mySerializationContext; } }
    //primary constructor
    private RdTypeHierarchyTree(
      [NotNull] RdProperty<string> baseTypeName,
      [NotNull] RdProperty<string> baseTypeContainerInfo,
      [NotNull] RdProperty<TypeHierarchyViewStyle?> viewToObserveChanges,
      [NotNull] RdSignal<RdVoid> refresh,
      [NotNull] RdProperty<bool> isRefreshing,
      [NotNull] RdMap<TypeHierarchyViewStyle, RdTypeHierarchyTreeView> views,
      [NotNull] RdSignal<RdTypeHierarchyTreeBuildViewArgs> buildView
    )
    {
      if (baseTypeName == null) throw new ArgumentNullException("baseTypeName");
      if (baseTypeContainerInfo == null) throw new ArgumentNullException("baseTypeContainerInfo");
      if (viewToObserveChanges == null) throw new ArgumentNullException("viewToObserveChanges");
      if (refresh == null) throw new ArgumentNullException("refresh");
      if (isRefreshing == null) throw new ArgumentNullException("isRefreshing");
      if (views == null) throw new ArgumentNullException("views");
      if (buildView == null) throw new ArgumentNullException("buildView");
      
      _BaseTypeName = baseTypeName;
      _BaseTypeContainerInfo = baseTypeContainerInfo;
      _ViewToObserveChanges = viewToObserveChanges;
      _Refresh = refresh;
      _IsRefreshing = isRefreshing;
      _Views = views;
      _BuildView = buildView;
      _BaseTypeName.OptimizeNested = true;
      _BaseTypeContainerInfo.OptimizeNested = true;
      _ViewToObserveChanges.OptimizeNested = true;
      _IsRefreshing.OptimizeNested = true;
      _ViewToObserveChanges.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("baseTypeName", _BaseTypeName));
      BindableChildren.Add(new KeyValuePair<string, object>("baseTypeContainerInfo", _BaseTypeContainerInfo));
      BindableChildren.Add(new KeyValuePair<string, object>("viewToObserveChanges", _ViewToObserveChanges));
      BindableChildren.Add(new KeyValuePair<string, object>("refresh", _Refresh));
      BindableChildren.Add(new KeyValuePair<string, object>("isRefreshing", _IsRefreshing));
      BindableChildren.Add(new KeyValuePair<string, object>("views", _Views));
      BindableChildren.Add(new KeyValuePair<string, object>("buildView", _BuildView));
    }
    //secondary constructor
    public RdTypeHierarchyTree (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<TypeHierarchyViewStyle?>(ReadTypeHierarchyViewStyleNullable, WriteTypeHierarchyViewStyleNullable),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdMap<TypeHierarchyViewStyle, RdTypeHierarchyTreeView>(ReadTypeHierarchyViewStyle, WriteTypeHierarchyViewStyle, RdTypeHierarchyTreeView.Read, RdTypeHierarchyTreeView.Write),
      new RdSignal<RdTypeHierarchyTreeBuildViewArgs>(RdTypeHierarchyTreeBuildViewArgs.Read, RdTypeHierarchyTreeBuildViewArgs.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdTypeHierarchyTree> Read = (ctx, reader) => 
    {
      ctx = ctx.WithInternRootHere(false);
      var _id = RdId.Read(reader);
      var baseTypeName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var baseTypeContainerInfo = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var viewToObserveChanges = RdProperty<TypeHierarchyViewStyle?>.Read(ctx, reader, ReadTypeHierarchyViewStyleNullable, WriteTypeHierarchyViewStyleNullable);
      var refresh = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var isRefreshing = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var views = RdMap<TypeHierarchyViewStyle, RdTypeHierarchyTreeView>.Read(ctx, reader, ReadTypeHierarchyViewStyle, WriteTypeHierarchyViewStyle, RdTypeHierarchyTreeView.Read, RdTypeHierarchyTreeView.Write);
      var buildView = RdSignal<RdTypeHierarchyTreeBuildViewArgs>.Read(ctx, reader, RdTypeHierarchyTreeBuildViewArgs.Read, RdTypeHierarchyTreeBuildViewArgs.Write);
      return new RdTypeHierarchyTree(baseTypeName, baseTypeContainerInfo, viewToObserveChanges, refresh, isRefreshing, views, buildView) { mySerializationContext = ctx }.WithId(_id);
    };
    public static CtxReadDelegate<TypeHierarchyViewStyle?> ReadTypeHierarchyViewStyleNullable = new CtxReadDelegate<TypeHierarchyViewStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<TypeHierarchyViewStyle>).NullableStruct();
    public static CtxReadDelegate<TypeHierarchyViewStyle> ReadTypeHierarchyViewStyle = new CtxReadDelegate<TypeHierarchyViewStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<TypeHierarchyViewStyle>);
    
    public static CtxWriteDelegate<RdTypeHierarchyTree> Write = (ctx, writer, value) => 
    {
      ctx = ctx.WithInternRootHere(true);
      value.mySerializationContext = ctx;
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._BaseTypeName);
      RdProperty<string>.Write(ctx, writer, value._BaseTypeContainerInfo);
      RdProperty<TypeHierarchyViewStyle?>.Write(ctx, writer, value._ViewToObserveChanges);
      RdSignal<RdVoid>.Write(ctx, writer, value._Refresh);
      RdProperty<bool>.Write(ctx, writer, value._IsRefreshing);
      RdMap<TypeHierarchyViewStyle, RdTypeHierarchyTreeView>.Write(ctx, writer, value._Views);
      RdSignal<RdTypeHierarchyTreeBuildViewArgs>.Write(ctx, writer, value._BuildView);
    };
    public static CtxWriteDelegate<TypeHierarchyViewStyle?> WriteTypeHierarchyViewStyleNullable = new CtxWriteDelegate<TypeHierarchyViewStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<TypeHierarchyViewStyle>).NullableStruct();
    public static CtxWriteDelegate<TypeHierarchyViewStyle> WriteTypeHierarchyViewStyle = new CtxWriteDelegate<TypeHierarchyViewStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<TypeHierarchyViewStyle>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTypeHierarchyTree (");
      using (printer.IndentCookie()) {
        printer.Print("baseTypeName = "); _BaseTypeName.PrintEx(printer); printer.Println();
        printer.Print("baseTypeContainerInfo = "); _BaseTypeContainerInfo.PrintEx(printer); printer.Println();
        printer.Print("viewToObserveChanges = "); _ViewToObserveChanges.PrintEx(printer); printer.Println();
        printer.Print("refresh = "); _Refresh.PrintEx(printer); printer.Println();
        printer.Print("isRefreshing = "); _IsRefreshing.PrintEx(printer); printer.Println();
        printer.Print("views = "); _Views.PrintEx(printer); printer.Println();
        printer.Print("buildView = "); _BuildView.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTypeHierarchyTreeBuildViewArgs : IPrintable, IEquatable<RdTypeHierarchyTreeBuildViewArgs>
  {
    //fields
    //public fields
    public TypeHierarchyViewStyle Style {get; private set;}
    
    //private fields
    //primary constructor
    public RdTypeHierarchyTreeBuildViewArgs(
      TypeHierarchyViewStyle style
    )
    {
      Style = style;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTypeHierarchyTreeBuildViewArgs> Read = (ctx, reader) => 
    {
      var style = (TypeHierarchyViewStyle)reader.ReadInt();
      return new RdTypeHierarchyTreeBuildViewArgs(style);
    };
    
    public static CtxWriteDelegate<RdTypeHierarchyTreeBuildViewArgs> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Style);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTypeHierarchyTreeBuildViewArgs) obj);
    }
    public bool Equals(RdTypeHierarchyTreeBuildViewArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Style == other.Style;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Style;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTypeHierarchyTreeBuildViewArgs (");
      using (printer.IndentCookie()) {
        printer.Print("style = "); Style.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTypeHierarchyTreeItem : IPrintable, IEquatable<RdTypeHierarchyTreeItem>
  {
    //fields
    //public fields
    public int Id {get; private set;}
    [CanBeNull] public int? ParentId {get; private set;}
    public int FileId {get; private set;}
    [CanBeNull] public string ModuleName {get; private set;}
    public bool IsModuleDisambigNeeded {get; private set;}
    [NotNull] public string ContainerInfo {get; private set;}
    [NotNull] public string TypeName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public bool IsValid {get; private set;}
    public bool IsBase {get; private set;}
    
    //private fields
    //primary constructor
    public RdTypeHierarchyTreeItem(
      int id,
      [CanBeNull] int? parentId,
      int fileId,
      [CanBeNull] string moduleName,
      bool isModuleDisambigNeeded,
      [NotNull] string containerInfo,
      [NotNull] string typeName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      bool isValid,
      bool isBase
    )
    {
      if (containerInfo == null) throw new ArgumentNullException("containerInfo");
      if (typeName == null) throw new ArgumentNullException("typeName");
      
      Id = id;
      ParentId = parentId;
      FileId = fileId;
      ModuleName = moduleName;
      IsModuleDisambigNeeded = isModuleDisambigNeeded;
      ContainerInfo = containerInfo;
      TypeName = typeName;
      Icon = icon;
      IsValid = isValid;
      IsBase = isBase;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTypeHierarchyTreeItem> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var parentId = ReadIntNullable(ctx, reader);
      var fileId = reader.ReadInt();
      var moduleName = ReadStringInternedNullable(ctx, reader);
      var isModuleDisambigNeeded = reader.ReadBool();
      var containerInfo = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var typeName = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var icon = ReadIconInternedNullable(ctx, reader);
      var isValid = reader.ReadBool();
      var isBase = reader.ReadBool();
      return new RdTypeHierarchyTreeItem(id, parentId, fileId, moduleName, isModuleDisambigNeeded, containerInfo, typeName, icon, isValid, isBase);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<string> ReadStringInternedNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.Interned().NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconInternedNullable = JetBrains.Rider.Model.Icon.Read.Interned().NullableClass();
    
    public static CtxWriteDelegate<RdTypeHierarchyTreeItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteIntNullable(ctx, writer, value.ParentId);
      writer.Write(value.FileId);
      WriteStringInternedNullable(ctx, writer, value.ModuleName);
      writer.Write(value.IsModuleDisambigNeeded);
      ctx.WriteInterned(writer, value.ContainerInfo, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      ctx.WriteInterned(writer, value.TypeName, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      WriteIconInternedNullable(ctx, writer, value.Icon);
      writer.Write(value.IsValid);
      writer.Write(value.IsBase);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<string> WriteStringInternedNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.Interned().NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconInternedNullable = JetBrains.Rider.Model.Icon.Write.Interned().NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTypeHierarchyTreeItem) obj);
    }
    public bool Equals(RdTypeHierarchyTreeItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(ParentId, other.ParentId) && FileId == other.FileId && Equals(ModuleName, other.ModuleName) && IsModuleDisambigNeeded == other.IsModuleDisambigNeeded && Equals(ContainerInfo, other.ContainerInfo) && Equals(TypeName, other.TypeName) && Equals(Icon, other.Icon) && IsValid == other.IsValid && IsBase == other.IsBase;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + (ParentId != null ?ParentId.GetHashCode() : 0);
        hash = hash * 31 + FileId.GetHashCode();
        hash = hash * 31 + (ModuleName != null ?ModuleName.GetHashCode() : 0);
        hash = hash * 31 + IsModuleDisambigNeeded.GetHashCode();
        hash = hash * 31 + ContainerInfo.GetHashCode();
        hash = hash * 31 + TypeName.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + IsValid.GetHashCode();
        hash = hash * 31 + IsBase.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTypeHierarchyTreeItem (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("fileId = "); FileId.PrintEx(printer); printer.Println();
        printer.Print("moduleName = "); ModuleName.PrintEx(printer); printer.Println();
        printer.Print("isModuleDisambigNeeded = "); IsModuleDisambigNeeded.PrintEx(printer); printer.Println();
        printer.Print("containerInfo = "); ContainerInfo.PrintEx(printer); printer.Println();
        printer.Print("typeName = "); TypeName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isValid = "); IsValid.PrintEx(printer); printer.Println();
        printer.Print("isBase = "); IsBase.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTypeHierarchyTreeNavigateArgs : IPrintable, IEquatable<RdTypeHierarchyTreeNavigateArgs>
  {
    //fields
    //public fields
    public int ItemId {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdTypeHierarchyTreeNavigateArgs(
      int itemId,
      bool requestFocus
    )
    {
      ItemId = itemId;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTypeHierarchyTreeNavigateArgs> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdTypeHierarchyTreeNavigateArgs(itemId, requestFocus);
    };
    
    public static CtxWriteDelegate<RdTypeHierarchyTreeNavigateArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTypeHierarchyTreeNavigateArgs) obj);
    }
    public bool Equals(RdTypeHierarchyTreeNavigateArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTypeHierarchyTreeNavigateArgs (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTypeHierarchyTreeSelectedItemConstant : RdDataConstant
  {
    //fields
    //public fields
    public int SessionId {get; private set;}
    public TypeHierarchyViewStyle ViewStyle {get; private set;}
    public int ItemId {get; private set;}
    
    //private fields
    //primary constructor
    public RdTypeHierarchyTreeSelectedItemConstant(
      int sessionId,
      TypeHierarchyViewStyle viewStyle,
      int itemId
    )
    {
      SessionId = sessionId;
      ViewStyle = viewStyle;
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdTypeHierarchyTreeSelectedItemConstant> Read = (ctx, reader) => 
    {
      var sessionId = reader.ReadInt();
      var viewStyle = (TypeHierarchyViewStyle)reader.ReadInt();
      var itemId = reader.ReadInt();
      return new RdTypeHierarchyTreeSelectedItemConstant(sessionId, viewStyle, itemId);
    };
    
    public static new CtxWriteDelegate<RdTypeHierarchyTreeSelectedItemConstant> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SessionId);
      writer.Write((int)value.ViewStyle);
      writer.Write(value.ItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTypeHierarchyTreeSelectedItemConstant) obj);
    }
    public bool Equals(RdTypeHierarchyTreeSelectedItemConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SessionId == other.SessionId && ViewStyle == other.ViewStyle && ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SessionId.GetHashCode();
        hash = hash * 31 + (int) ViewStyle;
        hash = hash * 31 + ItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTypeHierarchyTreeSelectedItemConstant (");
      using (printer.IndentCookie()) {
        printer.Print("sessionId = "); SessionId.PrintEx(printer); printer.Println();
        printer.Print("viewStyle = "); ViewStyle.PrintEx(printer); printer.Println();
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTypeHierarchyTreeView : RdBindableBase
  {
    //fields
    //public fields
    public TypeHierarchyViewStyle Style {get; private set;}
    [NotNull] public IViewableMap<int, RdTypeHierarchyTreeItem> Items { get { return _Items; }}
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] public IRdSignal<RdTypeHierarchyTreeNavigateArgs> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdTypeHierarchyTreeItem> _Items;
    [NotNull] private readonly RdProperty<bool> _IsReady;
    [NotNull] private readonly RdSignal<RdTypeHierarchyTreeNavigateArgs> _Navigate;
    
    //primary constructor
    private RdTypeHierarchyTreeView(
      TypeHierarchyViewStyle style,
      [NotNull] RdMap<int, RdTypeHierarchyTreeItem> items,
      [NotNull] RdProperty<bool> isReady,
      [NotNull] RdSignal<RdTypeHierarchyTreeNavigateArgs> navigate
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      if (isReady == null) throw new ArgumentNullException("isReady");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      Style = style;
      _Items = items;
      _IsReady = isReady;
      _Navigate = navigate;
      _Items.OptimizeNested = true;
      _IsReady.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
      BindableChildren.Add(new KeyValuePair<string, object>("isReady", _IsReady));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public RdTypeHierarchyTreeView (
      TypeHierarchyViewStyle style
    ) : this (
      style,
      new RdMap<int, RdTypeHierarchyTreeItem>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdTypeHierarchyTreeItem.Read, RdTypeHierarchyTreeItem.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdTypeHierarchyTreeNavigateArgs>(RdTypeHierarchyTreeNavigateArgs.Read, RdTypeHierarchyTreeNavigateArgs.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdTypeHierarchyTreeView> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var style = (TypeHierarchyViewStyle)reader.ReadInt();
      var items = RdMap<int, RdTypeHierarchyTreeItem>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdTypeHierarchyTreeItem.Read, RdTypeHierarchyTreeItem.Write);
      var isReady = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdTypeHierarchyTreeNavigateArgs>.Read(ctx, reader, RdTypeHierarchyTreeNavigateArgs.Read, RdTypeHierarchyTreeNavigateArgs.Write);
      return new RdTypeHierarchyTreeView(style, items, isReady, navigate).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdTypeHierarchyTreeView> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write((int)value.Style);
      RdMap<int, RdTypeHierarchyTreeItem>.Write(ctx, writer, value._Items);
      RdProperty<bool>.Write(ctx, writer, value._IsReady);
      RdSignal<RdTypeHierarchyTreeNavigateArgs>.Write(ctx, writer, value._Navigate);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTypeHierarchyTreeView (");
      using (printer.IndentCookie()) {
        printer.Print("style = "); Style.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum TypeHierarchyViewStyle {
    Hierarchy,
    SubTypes,
    SuperTypes,
    Implementation,
    InterfaceLeaves
  }
}
