using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.UIAutomation
{
  
  
  [JetBrains.Application.ShellComponent]
  public class UIAutomationInteractionModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<BeControl> CurrentUIElement { get { return _CurrentUIElement; }}
    [NotNull] public IRdProperty<BeBalloon> CurrentBalloon { get { return _CurrentBalloon; }}
    
    //private fields
    [NotNull] private readonly RdProperty<BeControl> _CurrentUIElement;
    [NotNull] private readonly RdProperty<BeBalloon> _CurrentBalloon;
    
    //primary constructor
    private UIAutomationInteractionModel(
      [NotNull] RdProperty<BeControl> currentUIElement,
      [NotNull] RdProperty<BeBalloon> currentBalloon
    )
    {
      if (currentUIElement == null) throw new ArgumentNullException("currentUIElement");
      if (currentBalloon == null) throw new ArgumentNullException("currentBalloon");
      
      _CurrentUIElement = currentUIElement;
      _CurrentBalloon = currentBalloon;
      _CurrentUIElement.ValueCanBeNull = true;
      _CurrentBalloon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("currentUIElement", _CurrentUIElement));
      BindableChildren.Add(new KeyValuePair<string, object>("currentBalloon", _CurrentBalloon));
    }
    //secondary constructor
    private UIAutomationInteractionModel (
    ) : this (
      new RdProperty<BeControl>(ReadBeControlNullable, WriteBeControlNullable),
      new RdProperty<BeBalloon>(ReadBeBalloonNullable, WriteBeBalloonNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<BeControl> ReadBeControlNullable = BeControl.Read.NullableClass();
    public static CtxReadDelegate<BeBalloon> ReadBeBalloonNullable = BeBalloon.Read.NullableClass();
    
    public static CtxWriteDelegate<BeControl> WriteBeControlNullable = BeControl.Write.NullableClass();
    public static CtxWriteDelegate<BeBalloon> WriteBeBalloonNullable = BeBalloon.Write.NullableClass();
    
    protected override long SerializationHash => -2096600369133523576L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<ValidationStates>();
      serializers.RegisterEnum<ValidationStyle>();
      serializers.Register(ValidationResult.Read, ValidationResult.Write);
      serializers.Register(BeRichText.Read, BeRichText.Write);
      serializers.Register(BeHeader.Read, BeHeader.Write);
      serializers.Register(BeCompletionItem.Read, BeCompletionItem.Write);
      serializers.Register(BeTextBoxSettings.Read, BeTextBoxSettings.Write);
      serializers.Register(BeTextBox.Read, BeTextBox.Write);
      serializers.Register(BeTextControl.Read, BeTextControl.Write);
      serializers.Register(BeTextControlWithLanguage.Read, BeTextControlWithLanguage.Write);
      serializers.Register(BeCheckbox.Read, BeCheckbox.Write);
      serializers.Register(BeRadioButton.Read, BeRadioButton.Write);
      serializers.Register(BeSearchBox.Read, BeSearchBox.Write);
      serializers.RegisterEnum<BeDock>();
      serializers.RegisterEnum<BeToolbarStyle>();
      serializers.Register(BeToolbar.Read, BeToolbar.Write);
      serializers.Register(BeResharperAction.Read, BeResharperAction.Write);
      serializers.Register(BeIcon.Read, BeIcon.Write);
      serializers.Register(BeSpacer.Read, BeSpacer.Write);
      serializers.Register(BeSpinner.Read, BeSpinner.Write);
      serializers.Register(BeColoredControl.Read, BeColoredControl.Write);
      serializers.Register(BeSeparator.Read, BeSeparator.Write);
      serializers.Register(BeComboBox.Read, BeComboBox.Write);
      serializers.RegisterEnum<PathChooser>();
      serializers.RegisterEnum<BeButtonStyle>();
      serializers.Register(BeUserAction.Read, BeUserAction.Write);
      serializers.Register(BeOpenDialogAction.Read, BeOpenDialogAction.Write);
      serializers.Register(BePathChooserAction.Read, BePathChooserAction.Write);
      serializers.Register(BeButton.Read, BeButton.Write);
      serializers.Register(BeToggleButton.Read, BeToggleButton.Write);
      serializers.RegisterEnum<BeTreeSelection>();
      serializers.Register(BeColumnDefinition.Read, BeColumnDefinition.Write);
      serializers.Register(BeTreeGridLine.Read, BeTreeGridLine.Write);
      serializers.RegisterEnum<BeShowBorders>();
      serializers.Register(BeTreeConfiguration.Read, BeTreeConfiguration.Write);
      serializers.Register(BeTreeGrid.Read, BeTreeGrid.Write);
      serializers.RegisterEnum<GridOrientation>();
      serializers.RegisterEnum<BeSizingType>();
      serializers.RegisterEnum<BeIntercellSpacing>();
      serializers.Register(BeUnitSize.Read, BeUnitSize.Write);
      serializers.Register(BeGridElement.Read, BeGridElement.Write);
      serializers.Register(BeGrid.Read, BeGrid.Write);
      serializers.Register(BeSpanColumnElement.Read, BeSpanColumnElement.Write);
      serializers.Register(BeSpanRowElement.Read, BeSpanRowElement.Write);
      serializers.Register(BeSpanGrid.Read, BeSpanGrid.Write);
      serializers.RegisterEnum<BeMarginType>();
      serializers.Register(BeMarginItem.Read, BeMarginItem.Write);
      serializers.Register(BeMargin.Read, BeMargin.Write);
      serializers.Register(BeMarginWrapper.Read, BeMarginWrapper.Write);
      serializers.Register(BeCollapsiblePanel.Read, BeCollapsiblePanel.Write);
      serializers.Register(BeTab.Read, BeTab.Write);
      serializers.Register(BeTabbedControl.Read, BeTabbedControl.Write);
      serializers.Register(BeSplitControl.Read, BeSplitControl.Write);
      serializers.Register(BeBalloon.Read, BeBalloon.Write);
      serializers.RegisterEnum<BeControlSizeType>();
      serializers.Register(BeControlSizeCustom.Read, BeControlSizeCustom.Write);
      serializers.Register(BeControlSizePredefined.Read, BeControlSizePredefined.Write);
      serializers.Register(BeControlSizeProportional.Read, BeControlSizeProportional.Write);
      serializers.Register(BeScrollbarPolicy.Read, BeScrollbarPolicy.Write);
      serializers.Register(BeScrollablePanel.Read, BeScrollablePanel.Write);
      serializers.RegisterEnum<DialogResult>();
      serializers.RegisterEnum<DialogModality>();
      serializers.Register(BeDialog.Read, BeDialog.Write);
      serializers.Register(BeControlConstant.Read, BeControlConstant.Write);
      serializers.Register(BeBackendContextMenu.Read, BeBackendContextMenu.Write);
      serializers.Register(IndefiniteProgress.Read, IndefiniteProgress.Write);
      serializers.RegisterEnum<ControlVisibility>();
      serializers.RegisterEnum<Place>();
      serializers.RegisterEnum<ChildOffsetSize>();
      serializers.Register(BeControl_Unknown.Read, BeControl_Unknown.Write);
      serializers.Register(BeControlWithValidation_Unknown.Read, BeControlWithValidation_Unknown.Write);
      serializers.Register(BeButtonAction_Unknown.Read, BeButtonAction_Unknown.Write);
      serializers.Register(BeAbstractButton_Unknown.Read, BeAbstractButton_Unknown.Write);
      serializers.Register(BeControlSize_Unknown.Read, BeControlSize_Unknown.Write);
      serializers.Register(AbstractProgress_Unknown.Read, AbstractProgress_Unknown.Write);
      
    }
    
    public UIAutomationInteractionModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("UIAutomationInteractionModel (");
      using (printer.IndentCookie()) {
        printer.Print("currentUIElement = "); _CurrentUIElement.PrintEx(printer); printer.Println();
        printer.Print("currentBalloon = "); _CurrentBalloon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class AbstractProgress : RdBindableBase
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AbstractProgress> Read = Polymorphic<AbstractProgress>.ReadAbstract(AbstractProgress_Unknown.Read);
    
    public static CtxWriteDelegate<AbstractProgress> Write = Polymorphic<AbstractProgress>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class AbstractProgress_Unknown : AbstractProgress
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<AbstractProgress_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new AbstractProgress_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<AbstractProgress_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AbstractProgress_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BeAbstractButton : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeRichText Content {get; private set;}
    public BeButtonStyle Style {get; private set;}
    [NotNull] public IRdProperty<bool> IsMouseOver { get { return _IsMouseOver; }}
    [NotNull] public IRdProperty<string> Tooltip { get { return _Tooltip; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool> _IsMouseOver;
    [NotNull] protected readonly RdProperty<string> _Tooltip;
    
    //primary constructor
    protected BeAbstractButton(
      [NotNull] BeRichText content,
      BeButtonStyle style,
      [NotNull] RdProperty<bool> isMouseOver,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (isMouseOver == null) throw new ArgumentNullException("isMouseOver");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      
      Content = content;
      Style = style;
      _IsMouseOver = isMouseOver;
      _Tooltip = tooltip;
      _IsMouseOver.OptimizeNested = true;
      _Tooltip.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("isMouseOver", _IsMouseOver));
      BindableChildren.Add(new KeyValuePair<string, object>("tooltip", _Tooltip));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeAbstractButton> Read = Polymorphic<BeAbstractButton>.ReadAbstract(BeAbstractButton_Unknown.Read);
    
    public static new CtxWriteDelegate<BeAbstractButton> Write = Polymorphic<BeAbstractButton>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeAbstractButton_Unknown : BeAbstractButton
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private BeAbstractButton_Unknown(
      [NotNull] BeRichText content,
      BeButtonStyle style,
      [NotNull] RdProperty<bool> isMouseOver,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      content,
      style,
      isMouseOver,
      tooltip,
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeAbstractButton_Unknown (
      [NotNull] BeRichText content,
      BeButtonStyle style = BeButtonStyle.DEFAULT
    ) : this (
      content,
      style,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeAbstractButton_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = BeRichText.Read(ctx, reader);
      var style = (BeButtonStyle)reader.ReadInt();
      var isMouseOver = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeAbstractButton_Unknown(content, style, isMouseOver, tooltip, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeAbstractButton_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BeRichText.Write(ctx, writer, value.Content);
      writer.Write((int)value.Style);
      RdProperty<bool>.Write(ctx, writer, value._IsMouseOver);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeAbstractButton_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("style = "); Style.PrintEx(printer); printer.Println();
        printer.Print("isMouseOver = "); _IsMouseOver.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeBackendContextMenu : IPrintable, IEquatable<BeBackendContextMenu>
  {
    //fields
    //public fields
    [NotNull] public string BackendMenuGroupId {get; private set;}
    
    //private fields
    //primary constructor
    public BeBackendContextMenu(
      [NotNull] string backendMenuGroupId
    )
    {
      if (backendMenuGroupId == null) throw new ArgumentNullException("backendMenuGroupId");
      
      BackendMenuGroupId = backendMenuGroupId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeBackendContextMenu> Read = (ctx, reader) => 
    {
      var backendMenuGroupId = reader.ReadString();
      return new BeBackendContextMenu(backendMenuGroupId);
    };
    
    public static CtxWriteDelegate<BeBackendContextMenu> Write = (ctx, writer, value) => 
    {
      writer.Write(value.BackendMenuGroupId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeBackendContextMenu) obj);
    }
    public bool Equals(BeBackendContextMenu other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return BackendMenuGroupId == other.BackendMenuGroupId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + BackendMenuGroupId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeBackendContextMenu (");
      using (printer.IndentCookie()) {
        printer.Print("backendMenuGroupId = "); BackendMenuGroupId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeBalloon : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeControl Content {get; private set;}
    [NotNull] public JetBrains.Rider.Model.RdTextRange Range {get; private set;}
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    
    //private fields
    //primary constructor
    private BeBalloon(
      [NotNull] BeControl content,
      [NotNull] JetBrains.Rider.Model.RdTextRange range,
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (range == null) throw new ArgumentNullException("range");
      if (textControlId == null) throw new ArgumentNullException("textControlId");
      
      Content = content;
      Range = range;
      TextControlId = textControlId;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    public BeBalloon (
      [NotNull] BeControl content,
      [NotNull] JetBrains.Rider.Model.RdTextRange range,
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId
    ) : this (
      content,
      range,
      textControlId,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeBalloon> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeControl.Read(ctx, reader);
      var range = JetBrains.Rider.Model.RdTextRange.Read(ctx, reader);
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      return new BeBalloon(content, range, textControlId, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeBalloon> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Content);
      JetBrains.Rider.Model.RdTextRange.Write(ctx, writer, value.Range);
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeBalloon (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("range = "); Range.PrintEx(printer); printer.Println();
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeButton : BeAbstractButton
  {
    //fields
    //public fields
    [NotNull] public BeButtonAction Action {get; private set;}
    
    //private fields
    //primary constructor
    private BeButton(
      [NotNull] BeButtonAction action,
      [NotNull] BeRichText content,
      BeButtonStyle style,
      [NotNull] RdProperty<bool> isMouseOver,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      content,
      style,
      isMouseOver,
      tooltip,
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (action == null) throw new ArgumentNullException("action");
      
      Action = action;
      BindableChildren.Add(new KeyValuePair<string, object>("action", Action));
    }
    //secondary constructor
    public BeButton (
      [NotNull] BeButtonAction action,
      [NotNull] BeRichText content,
      BeButtonStyle style = BeButtonStyle.DEFAULT
    ) : this (
      action,
      content,
      style,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = BeRichText.Read(ctx, reader);
      var style = (BeButtonStyle)reader.ReadInt();
      var isMouseOver = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var action = BeButtonAction.Read(ctx, reader);
      return new BeButton(action, content, style, isMouseOver, tooltip, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BeRichText.Write(ctx, writer, value.Content);
      writer.Write((int)value.Style);
      RdProperty<bool>.Write(ctx, writer, value._IsMouseOver);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeButtonAction.Write(ctx, writer, value.Action);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeButton (");
      using (printer.IndentCookie()) {
        printer.Print("action = "); Action.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("style = "); Style.PrintEx(printer); printer.Println();
        printer.Print("isMouseOver = "); _IsMouseOver.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BeButtonAction : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdSignal<RdVoid> Click { get { return _Click; }}
    
    //private fields
    [NotNull] protected readonly RdSignal<RdVoid> _Click;
    
    //primary constructor
    protected BeButtonAction(
      [NotNull] RdSignal<RdVoid> click
    )
    {
      if (click == null) throw new ArgumentNullException("click");
      
      _Click = click;
      BindableChildren.Add(new KeyValuePair<string, object>("click", _Click));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeButtonAction> Read = Polymorphic<BeButtonAction>.ReadAbstract(BeButtonAction_Unknown.Read);
    
    public static CtxWriteDelegate<BeButtonAction> Write = Polymorphic<BeButtonAction>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeButtonAction_Unknown : BeButtonAction
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private BeButtonAction_Unknown(
      [NotNull] RdSignal<RdVoid> click
    ) : base (
      click
     ) 
    {
    }
    //secondary constructor
    public BeButtonAction_Unknown (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeButtonAction_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var click = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new BeButtonAction_Unknown(click).WithId(_id);
    };
    
    public static new CtxWriteDelegate<BeButtonAction_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._Click);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeButtonAction_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("click = "); _Click.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeButtonStyle {
    DEFAULT,
    NO_BORDER
  }
  
  
  public class BeCheckbox : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeRichText Description {get; private set;}
    [NotNull] public IRdProperty<bool?> Property { get { return _Property; }}
    [NotNull] public IRdProperty<bool> IsThreeState { get { return _IsThreeState; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool?> _Property;
    [NotNull] private readonly RdProperty<bool> _IsThreeState;
    
    //primary constructor
    private BeCheckbox(
      [NotNull] BeRichText description,
      [NotNull] RdProperty<bool?> property,
      [NotNull] RdProperty<bool> isThreeState,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (description == null) throw new ArgumentNullException("description");
      if (property == null) throw new ArgumentNullException("property");
      if (isThreeState == null) throw new ArgumentNullException("isThreeState");
      
      Description = description;
      _Property = property;
      _IsThreeState = isThreeState;
      _Property.OptimizeNested = true;
      _IsThreeState.OptimizeNested = true;
      _Property.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("description", Description));
      BindableChildren.Add(new KeyValuePair<string, object>("property", _Property));
      BindableChildren.Add(new KeyValuePair<string, object>("isThreeState", _IsThreeState));
    }
    //secondary constructor
    public BeCheckbox (
      [NotNull] BeRichText description
    ) : this (
      description,
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeCheckbox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var description = BeRichText.Read(ctx, reader);
      var property = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      var isThreeState = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new BeCheckbox(description, property, isThreeState, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeCheckbox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeRichText.Write(ctx, writer, value.Description);
      RdProperty<bool?>.Write(ctx, writer, value._Property);
      RdProperty<bool>.Write(ctx, writer, value._IsThreeState);
    };
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeCheckbox (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("property = "); _Property.PrintEx(printer); printer.Println();
        printer.Print("isThreeState = "); _IsThreeState.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeCollapsiblePanel : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeControl Contents {get; private set;}
    [NotNull] public IRdProperty<string> HeaderText { get { return _HeaderText; }}
    [NotNull] public IRdProperty<bool> IsExpanded { get { return _IsExpanded; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _HeaderText;
    [NotNull] private readonly RdProperty<bool> _IsExpanded;
    
    //primary constructor
    private BeCollapsiblePanel(
      [NotNull] BeControl contents,
      [NotNull] RdProperty<string> headerText,
      [NotNull] RdProperty<bool> isExpanded,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (contents == null) throw new ArgumentNullException("contents");
      if (headerText == null) throw new ArgumentNullException("headerText");
      if (isExpanded == null) throw new ArgumentNullException("isExpanded");
      
      Contents = contents;
      _HeaderText = headerText;
      _IsExpanded = isExpanded;
      _HeaderText.OptimizeNested = true;
      _IsExpanded.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("contents", Contents));
      BindableChildren.Add(new KeyValuePair<string, object>("headerText", _HeaderText));
      BindableChildren.Add(new KeyValuePair<string, object>("isExpanded", _IsExpanded));
    }
    //secondary constructor
    public BeCollapsiblePanel (
      [NotNull] BeControl contents
    ) : this (
      contents,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeCollapsiblePanel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var contents = BeControl.Read(ctx, reader);
      var headerText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isExpanded = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new BeCollapsiblePanel(contents, headerText, isExpanded, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeCollapsiblePanel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Contents);
      RdProperty<string>.Write(ctx, writer, value._HeaderText);
      RdProperty<bool>.Write(ctx, writer, value._IsExpanded);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeCollapsiblePanel (");
      using (printer.IndentCookie()) {
        printer.Print("contents = "); Contents.PrintEx(printer); printer.Println();
        printer.Print("headerText = "); _HeaderText.PrintEx(printer); printer.Println();
        printer.Print("isExpanded = "); _IsExpanded.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeColoredControl : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeControl Content {get; private set;}
    [NotNull] public JetBrains.Rider.Model.AbstractColor Color {get; private set;}
    
    //private fields
    //primary constructor
    private BeColoredControl(
      [NotNull] BeControl content,
      [NotNull] JetBrains.Rider.Model.AbstractColor color,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (color == null) throw new ArgumentNullException("color");
      
      Content = content;
      Color = color;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    public BeColoredControl (
      [NotNull] BeControl content,
      [NotNull] JetBrains.Rider.Model.AbstractColor color
    ) : this (
      content,
      color,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeColoredControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeControl.Read(ctx, reader);
      var color = JetBrains.Rider.Model.AbstractColor.Read(ctx, reader);
      return new BeColoredControl(content, color, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeColoredControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Content);
      JetBrains.Rider.Model.AbstractColor.Write(ctx, writer, value.Color);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeColoredControl (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("color = "); Color.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeColumnDefinition : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public string ColumnName {get; private set;}
    [NotNull] public BeUnitSize Size {get; private set;}
    
    //private fields
    //primary constructor
    public BeColumnDefinition(
      [NotNull] string columnName,
      [NotNull] BeUnitSize size
    )
    {
      if (columnName == null) throw new ArgumentNullException("columnName");
      if (size == null) throw new ArgumentNullException("size");
      
      ColumnName = columnName;
      Size = size;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeColumnDefinition> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var columnName = reader.ReadString();
      var size = BeUnitSize.Read(ctx, reader);
      return new BeColumnDefinition(columnName, size).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeColumnDefinition> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ColumnName);
      BeUnitSize.Write(ctx, writer, value.Size);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeColumnDefinition (");
      using (printer.IndentCookie()) {
        printer.Print("columnName = "); ColumnName.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeComboBox : BeControlWithValidation
  {
    //fields
    //public fields
    [NotNull] public IViewableList<BeControl> Values { get { return _Values; }}
    [NotNull] public IRdProperty<bool> IsEditable { get { return _IsEditable; }}
    [NotNull] public IRdProperty<bool> IsReadonly { get { return _IsReadonly; }}
    [NotNull] public IRdProperty<string> SelectedValue { get { return _SelectedValue; }}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    
    //private fields
    [NotNull] private readonly RdList<BeControl> _Values;
    [NotNull] private readonly RdProperty<bool> _IsEditable;
    [NotNull] private readonly RdProperty<bool> _IsReadonly;
    [NotNull] private readonly RdProperty<string> _SelectedValue;
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    
    //primary constructor
    private BeComboBox(
      [NotNull] RdList<BeControl> values,
      [NotNull] RdProperty<bool> isEditable,
      [NotNull] RdProperty<bool> isReadonly,
      [NotNull] RdProperty<string> selectedValue,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle> validationStyle,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      validationResult,
      validationStyle,
      handledByParent,
      revalidate,
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (values == null) throw new ArgumentNullException("values");
      if (isEditable == null) throw new ArgumentNullException("isEditable");
      if (isReadonly == null) throw new ArgumentNullException("isReadonly");
      if (selectedValue == null) throw new ArgumentNullException("selectedValue");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      
      _Values = values;
      _IsEditable = isEditable;
      _IsReadonly = isReadonly;
      _SelectedValue = selectedValue;
      _SelectedIndex = selectedIndex;
      _IsEditable.OptimizeNested = true;
      _IsReadonly.OptimizeNested = true;
      _SelectedValue.OptimizeNested = true;
      _SelectedIndex.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("values", _Values));
      BindableChildren.Add(new KeyValuePair<string, object>("isEditable", _IsEditable));
      BindableChildren.Add(new KeyValuePair<string, object>("isReadonly", _IsReadonly));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedValue", _SelectedValue));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
    }
    //secondary constructor
    public BeComboBox (
    ) : this (
      new RdList<BeControl>(BeControl.Read, BeControl.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, 0),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(ReadValidationStyle, WriteValidationStyle),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeComboBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var validationStyle = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Read(ctx, reader, ReadValidationStyle, WriteValidationStyle);
      var handledByParent = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var revalidate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var values = RdList<BeControl>.Read(ctx, reader, BeControl.Read, BeControl.Write);
      var isEditable = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isReadonly = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var selectedValue = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new BeComboBox(values, isEditable, isReadonly, selectedValue, selectedIndex, validationResult, validationStyle, handledByParent, revalidate, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> ReadValidationStyle = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeComboBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Write(ctx, writer, value._ValidationStyle);
      RdProperty<bool>.Write(ctx, writer, value._HandledByParent);
      RdSignal<RdVoid>.Write(ctx, writer, value._Revalidate);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdList<BeControl>.Write(ctx, writer, value._Values);
      RdProperty<bool>.Write(ctx, writer, value._IsEditable);
      RdProperty<bool>.Write(ctx, writer, value._IsReadonly);
      RdProperty<string>.Write(ctx, writer, value._SelectedValue);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> WriteValidationStyle = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeComboBox (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); _Values.PrintEx(printer); printer.Println();
        printer.Print("isEditable = "); _IsEditable.PrintEx(printer); printer.Println();
        printer.Print("isReadonly = "); _IsReadonly.PrintEx(printer); printer.Println();
        printer.Print("selectedValue = "); _SelectedValue.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("validationStyle = "); _ValidationStyle.PrintEx(printer); printer.Println();
        printer.Print("handledByParent = "); _HandledByParent.PrintEx(printer); printer.Println();
        printer.Print("revalidate = "); _Revalidate.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeCompletionItem : RdBindableBase
  {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.Icon LeftIcon {get; private set;}
    [NotNull] public BeRichText LeftText {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> RightIcon { get { return _RightIcon; }}
    [NotNull] public IRdProperty<BeRichText> RightText { get { return _RightText; }}
    [NotNull] public string TranslatedText {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _RightIcon;
    [NotNull] private readonly RdProperty<BeRichText> _RightText;
    
    //primary constructor
    private BeCompletionItem(
      [CanBeNull] JetBrains.Rider.Model.Icon leftIcon,
      [NotNull] BeRichText leftText,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> rightIcon,
      [NotNull] RdProperty<BeRichText> rightText,
      [NotNull] string translatedText
    )
    {
      if (leftText == null) throw new ArgumentNullException("leftText");
      if (rightIcon == null) throw new ArgumentNullException("rightIcon");
      if (rightText == null) throw new ArgumentNullException("rightText");
      if (translatedText == null) throw new ArgumentNullException("translatedText");
      
      LeftIcon = leftIcon;
      LeftText = leftText;
      _RightIcon = rightIcon;
      _RightText = rightText;
      TranslatedText = translatedText;
      _RightIcon.OptimizeNested = true;
      _RightIcon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("leftText", LeftText));
      BindableChildren.Add(new KeyValuePair<string, object>("rightIcon", _RightIcon));
      BindableChildren.Add(new KeyValuePair<string, object>("rightText", _RightText));
    }
    //secondary constructor
    public BeCompletionItem (
      [CanBeNull] JetBrains.Rider.Model.Icon leftIcon,
      [NotNull] BeRichText leftText,
      [NotNull] string translatedText
    ) : this (
      leftIcon,
      leftText,
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<BeRichText>(BeRichText.Read, BeRichText.Write),
      translatedText
    ) {}
    //statics
    
    public static CtxReadDelegate<BeCompletionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var leftIcon = ReadIconNullable(ctx, reader);
      var leftText = BeRichText.Read(ctx, reader);
      var rightIcon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      var rightText = RdProperty<BeRichText>.Read(ctx, reader, BeRichText.Read, BeRichText.Write);
      var translatedText = reader.ReadString();
      return new BeCompletionItem(leftIcon, leftText, rightIcon, rightText, translatedText).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<BeCompletionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteIconNullable(ctx, writer, value.LeftIcon);
      BeRichText.Write(ctx, writer, value.LeftText);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._RightIcon);
      RdProperty<BeRichText>.Write(ctx, writer, value._RightText);
      writer.Write(value.TranslatedText);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeCompletionItem (");
      using (printer.IndentCookie()) {
        printer.Print("leftIcon = "); LeftIcon.PrintEx(printer); printer.Println();
        printer.Print("leftText = "); LeftText.PrintEx(printer); printer.Println();
        printer.Print("rightIcon = "); _RightIcon.PrintEx(printer); printer.Println();
        printer.Print("rightText = "); _RightText.PrintEx(printer); printer.Println();
        printer.Print("translatedText = "); TranslatedText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BeControl : JetBrains.Rider.Model.Popups.ProtoViewModel
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    
    /// <summary>
    /// Needed for accelerators to work and for search
    /// </summary>
    [NotNull] public IRdProperty<string> ControlId { get { return _ControlId; }}
    [NotNull] public IRdSignal<RdVoid> Focus { get { return _Focus; }}
    
    /// <summary>
    /// Warning: currently doesn't work as expected.
    /// </summary>
    [NotNull] public IRdProperty<ControlVisibility> Visible { get { return _Visible; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool> _Enabled;
    [NotNull] protected readonly RdProperty<string> _ControlId;
    [NotNull] protected readonly RdSignal<RdVoid> _Focus;
    [NotNull] protected readonly RdProperty<ControlVisibility> _Visible;
    
    //primary constructor
    protected BeControl(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    )
    {
      if (enabled == null) throw new ArgumentNullException("enabled");
      if (controlId == null) throw new ArgumentNullException("controlId");
      if (focus == null) throw new ArgumentNullException("focus");
      if (visible == null) throw new ArgumentNullException("visible");
      
      _Enabled = enabled;
      _ControlId = controlId;
      _Focus = focus;
      _Visible = visible;
      _Enabled.OptimizeNested = true;
      _ControlId.OptimizeNested = true;
      _Visible.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
      BindableChildren.Add(new KeyValuePair<string, object>("controlId", _ControlId));
      BindableChildren.Add(new KeyValuePair<string, object>("focus", _Focus));
      BindableChildren.Add(new KeyValuePair<string, object>("visible", _Visible));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControl> Read = Polymorphic<BeControl>.ReadAbstract(BeControl_Unknown.Read);
    
    public static new CtxWriteDelegate<BeControl> Write = Polymorphic<BeControl>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeControlConstant : JetBrains.Rider.Model.RdDataConstant
  {
    //fields
    //public fields
    [CanBeNull] public string EnclosingControlId {get; private set;}
    [CanBeNull] public List<string> ControlId {get; private set;}
    
    //private fields
    //primary constructor
    public BeControlConstant(
      [CanBeNull] string enclosingControlId,
      [CanBeNull] List<string> controlId
    )
    {
      EnclosingControlId = enclosingControlId;
      ControlId = controlId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlConstant> Read = (ctx, reader) => 
    {
      var enclosingControlId = ReadStringNullable(ctx, reader);
      var controlId = ReadStringListNullable(ctx, reader);
      return new BeControlConstant(enclosingControlId, controlId);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List().NullableClass();
    
    public static new CtxWriteDelegate<BeControlConstant> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.EnclosingControlId);
      WriteStringListNullable(ctx, writer, value.ControlId);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List().NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeControlConstant) obj);
    }
    public bool Equals(BeControlConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(EnclosingControlId, other.EnclosingControlId) && Equals(ControlId, other.ControlId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (EnclosingControlId != null ?EnclosingControlId.GetHashCode() : 0);
        hash = hash * 31 + (ControlId != null ?Collections.GetHashCode(ControlId) : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlConstant (");
      using (printer.IndentCookie()) {
        printer.Print("enclosingControlId = "); EnclosingControlId.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); ControlId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BeControlSize{
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeControlSize> Read = Polymorphic<BeControlSize>.ReadAbstract(BeControlSize_Unknown.Read);
    
    public static CtxWriteDelegate<BeControlSize> Write = Polymorphic<BeControlSize>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeControlSizeCustom : BeControlSize
  {
    //fields
    //public fields
    public int Width {get; private set;}
    public int Height {get; private set;}
    
    //private fields
    //primary constructor
    public BeControlSizeCustom(
      int width,
      int height
    )
    {
      Width = width;
      Height = height;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlSizeCustom> Read = (ctx, reader) => 
    {
      var width = reader.ReadInt();
      var height = reader.ReadInt();
      return new BeControlSizeCustom(width, height);
    };
    
    public static new CtxWriteDelegate<BeControlSizeCustom> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Width);
      writer.Write(value.Height);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeControlSizeCustom) obj);
    }
    public bool Equals(BeControlSizeCustom other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Width == other.Width && Height == other.Height;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Width.GetHashCode();
        hash = hash * 31 + Height.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlSizeCustom (");
      using (printer.IndentCookie()) {
        printer.Print("width = "); Width.PrintEx(printer); printer.Println();
        printer.Print("height = "); Height.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeControlSizePredefined : BeControlSize
  {
    //fields
    //public fields
    public BeControlSizeType Width {get; private set;}
    public BeControlSizeType Height {get; private set;}
    
    //private fields
    //primary constructor
    public BeControlSizePredefined(
      BeControlSizeType width,
      BeControlSizeType height
    )
    {
      Width = width;
      Height = height;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlSizePredefined> Read = (ctx, reader) => 
    {
      var width = (BeControlSizeType)reader.ReadInt();
      var height = (BeControlSizeType)reader.ReadInt();
      return new BeControlSizePredefined(width, height);
    };
    
    public static new CtxWriteDelegate<BeControlSizePredefined> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Width);
      writer.Write((int)value.Height);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeControlSizePredefined) obj);
    }
    public bool Equals(BeControlSizePredefined other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Width == other.Width && Height == other.Height;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Width;
        hash = hash * 31 + (int) Height;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlSizePredefined (");
      using (printer.IndentCookie()) {
        printer.Print("width = "); Width.PrintEx(printer); printer.Println();
        printer.Print("height = "); Height.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeControlSizeProportional : BeControlSize
  {
    //fields
    //public fields
    public BeControlSizeType Size {get; private set;}
    public float Proportion {get; private set;}
    
    //private fields
    //primary constructor
    public BeControlSizeProportional(
      BeControlSizeType size,
      float proportion
    )
    {
      Size = size;
      Proportion = proportion;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlSizeProportional> Read = (ctx, reader) => 
    {
      var size = (BeControlSizeType)reader.ReadInt();
      var proportion = reader.ReadFloat();
      return new BeControlSizeProportional(size, proportion);
    };
    
    public static new CtxWriteDelegate<BeControlSizeProportional> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Size);
      writer.Write(value.Proportion);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeControlSizeProportional) obj);
    }
    public bool Equals(BeControlSizeProportional other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Size == other.Size && Proportion == other.Proportion;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Size;
        hash = hash * 31 + Proportion.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlSizeProportional (");
      using (printer.IndentCookie()) {
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
        printer.Print("proportion = "); Proportion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeControlSizeType {
    TINY,
    SMALL,
    MEDIUM,
    LARGE,
    HUGE,
    FIT_TO_CONTENT
  }
  
  
  public class BeControlSize_Unknown : BeControlSize
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlSize_Unknown> Read = (ctx, reader) => 
    {
      return new BeControlSize_Unknown();
    };
    
    public static new CtxWriteDelegate<BeControlSize_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeControlSize_Unknown) obj);
    }
    public bool Equals(BeControlSize_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlSize_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BeControlWithValidation : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> ValidationResult { get { return _ValidationResult; }}
    
    /// <summary>
    /// Questionable property. Defines how error should look for current control
    /// </summary>
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle> ValidationStyle { get { return _ValidationStyle; }}
    
    /// <summary>
    /// Defines if this control is inside tree (or any control which will handle validation of control by itself)
    /// </summary>
    [NotNull] public IRdProperty<bool> HandledByParent { get { return _HandledByParent; }}
    
    /// <summary>
    /// This property forces control to revalidate all rules for it. Better do not call explicitly
    /// </summary>
    [NotNull] public IRdSignal<RdVoid> Revalidate { get { return _Revalidate; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> _ValidationResult;
    [NotNull] protected readonly RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle> _ValidationStyle;
    [NotNull] protected readonly RdProperty<bool> _HandledByParent;
    [NotNull] protected readonly RdSignal<RdVoid> _Revalidate;
    
    //primary constructor
    protected BeControlWithValidation(
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle> validationStyle,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (validationResult == null) throw new ArgumentNullException("validationResult");
      if (validationStyle == null) throw new ArgumentNullException("validationStyle");
      if (handledByParent == null) throw new ArgumentNullException("handledByParent");
      if (revalidate == null) throw new ArgumentNullException("revalidate");
      
      _ValidationResult = validationResult;
      _ValidationStyle = validationStyle;
      _HandledByParent = handledByParent;
      _Revalidate = revalidate;
      _ValidationStyle.OptimizeNested = true;
      _HandledByParent.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("validationResult", _ValidationResult));
      BindableChildren.Add(new KeyValuePair<string, object>("validationStyle", _ValidationStyle));
      BindableChildren.Add(new KeyValuePair<string, object>("handledByParent", _HandledByParent));
      BindableChildren.Add(new KeyValuePair<string, object>("revalidate", _Revalidate));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlWithValidation> Read = Polymorphic<BeControlWithValidation>.ReadAbstract(BeControlWithValidation_Unknown.Read);
    
    public static new CtxWriteDelegate<BeControlWithValidation> Write = Polymorphic<BeControlWithValidation>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeControlWithValidation_Unknown : BeControlWithValidation
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private BeControlWithValidation_Unknown(
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle> validationStyle,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      validationResult,
      validationStyle,
      handledByParent,
      revalidate,
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeControlWithValidation_Unknown (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(ReadValidationStyle, WriteValidationStyle),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeControlWithValidation_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var validationStyle = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Read(ctx, reader, ReadValidationStyle, WriteValidationStyle);
      var handledByParent = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var revalidate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeControlWithValidation_Unknown(validationResult, validationStyle, handledByParent, revalidate, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> ReadValidationStyle = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeControlWithValidation_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Write(ctx, writer, value._ValidationStyle);
      RdProperty<bool>.Write(ctx, writer, value._HandledByParent);
      RdSignal<RdVoid>.Write(ctx, writer, value._Revalidate);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> WriteValidationStyle = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlWithValidation_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("validationStyle = "); _ValidationStyle.PrintEx(printer); printer.Println();
        printer.Print("handledByParent = "); _HandledByParent.PrintEx(printer); printer.Println();
        printer.Print("revalidate = "); _Revalidate.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeControl_Unknown : BeControl
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private BeControl_Unknown(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeControl_Unknown (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeControl_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeControl_Unknown(enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeControl_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeControl_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeDialog : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeScrollablePanel Content {get; private set;}
    public DialogModality Modality {get; private set;}
    [CanBeNull] public string Title {get; private set;}
    [NotNull] public IRdProperty<DialogResult> Result { get { return _Result; }}
    [NotNull] public IRdProperty<List<BeButton>> Buttons { get { return _Buttons; }}
    
    //private fields
    [NotNull] private readonly RdProperty<DialogResult> _Result;
    [NotNull] private readonly RdProperty<List<BeButton>> _Buttons;
    
    //primary constructor
    private BeDialog(
      [NotNull] BeScrollablePanel content,
      DialogModality modality,
      [CanBeNull] string title,
      [NotNull] RdProperty<DialogResult> result,
      [NotNull] RdProperty<List<BeButton>> buttons,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (result == null) throw new ArgumentNullException("result");
      if (buttons == null) throw new ArgumentNullException("buttons");
      
      Content = content;
      Modality = modality;
      Title = title;
      _Result = result;
      _Buttons = buttons;
      _Result.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("result", _Result));
      BindableChildren.Add(new KeyValuePair<string, object>("buttons", _Buttons));
    }
    //secondary constructor
    public BeDialog (
      [NotNull] BeScrollablePanel content,
      DialogModality modality,
      [CanBeNull] string title
    ) : this (
      content,
      modality,
      title,
      new RdProperty<DialogResult>(ReadDialogResult, WriteDialogResult),
      new RdProperty<List<BeButton>>(ReadBeButtonList, WriteBeButtonList),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeDialog> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeScrollablePanel.Read(ctx, reader);
      var modality = (DialogModality)reader.ReadInt();
      var title = ReadStringNullable(ctx, reader);
      var result = RdProperty<DialogResult>.Read(ctx, reader, ReadDialogResult, WriteDialogResult);
      var buttons = RdProperty<List<BeButton>>.Read(ctx, reader, ReadBeButtonList, WriteBeButtonList);
      return new BeDialog(content, modality, title, result, buttons, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<DialogResult> ReadDialogResult = new CtxReadDelegate<DialogResult>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<DialogResult>);
    public static CtxReadDelegate<List<BeButton>> ReadBeButtonList = BeButton.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeDialog> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeScrollablePanel.Write(ctx, writer, value.Content);
      writer.Write((int)value.Modality);
      WriteStringNullable(ctx, writer, value.Title);
      RdProperty<DialogResult>.Write(ctx, writer, value._Result);
      RdProperty<List<BeButton>>.Write(ctx, writer, value._Buttons);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<DialogResult> WriteDialogResult = new CtxWriteDelegate<DialogResult>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<DialogResult>);
    public static CtxWriteDelegate<List<BeButton>> WriteBeButtonList = BeButton.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeDialog (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("modality = "); Modality.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
        printer.Print("buttons = "); _Buttons.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeDock {
    TOP,
    BOTTOM,
    LEFT,
    RIGHT
  }
  
  
  public class BeGrid : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<BeGridElement>> Items { get { return _Items; }}
    public GridOrientation Orientation {get; private set;}
    public BeIntercellSpacing IntercellSpacing {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<BeGridElement>> _Items;
    
    //primary constructor
    private BeGrid(
      [NotNull] RdProperty<List<BeGridElement>> items,
      GridOrientation orientation,
      BeIntercellSpacing intercellSpacing,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (items == null) throw new ArgumentNullException("items");
      
      _Items = items;
      Orientation = orientation;
      IntercellSpacing = intercellSpacing;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
    }
    //secondary constructor
    public BeGrid (
      GridOrientation orientation,
      BeIntercellSpacing intercellSpacing = BeIntercellSpacing.Default
    ) : this (
      new RdProperty<List<BeGridElement>>(ReadBeGridElementList, WriteBeGridElementList),
      orientation,
      intercellSpacing,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeGrid> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var items = RdProperty<List<BeGridElement>>.Read(ctx, reader, ReadBeGridElementList, WriteBeGridElementList);
      var orientation = (GridOrientation)reader.ReadInt();
      var intercellSpacing = (BeIntercellSpacing)reader.ReadInt();
      return new BeGrid(items, orientation, intercellSpacing, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeGridElement>> ReadBeGridElementList = BeGridElement.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeGrid> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<List<BeGridElement>>.Write(ctx, writer, value._Items);
      writer.Write((int)value.Orientation);
      writer.Write((int)value.IntercellSpacing);
    };
    public static CtxWriteDelegate<List<BeGridElement>> WriteBeGridElementList = BeGridElement.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeGrid (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("orientation = "); Orientation.PrintEx(printer); printer.Println();
        printer.Print("intercellSpacing = "); IntercellSpacing.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeGridElement : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public BeControl Content {get; private set;}
    [NotNull] public BeUnitSize Size {get; private set;}
    
    //private fields
    //primary constructor
    public BeGridElement(
      [NotNull] BeControl content,
      [NotNull] BeUnitSize size
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      if (size == null) throw new ArgumentNullException("size");
      
      Content = content;
      Size = size;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeGridElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = BeControl.Read(ctx, reader);
      var size = BeUnitSize.Read(ctx, reader);
      return new BeGridElement(content, size).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeGridElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BeControl.Write(ctx, writer, value.Content);
      BeUnitSize.Write(ctx, writer, value.Size);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeGridElement (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeHeader : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    
    //primary constructor
    private BeHeader(
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      if (icon == null) throw new ArgumentNullException("icon");
      
      _Text = text;
      _Icon = icon;
      _Text.OptimizeNested = true;
      _Icon.OptimizeNested = true;
      _Icon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
    }
    //secondary constructor
    public BeHeader (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeHeader> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      return new BeHeader(text, icon, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeHeader> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeHeader (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeIcon : BeControl
  {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    private BeIcon(
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      Icon = icon;
    }
    //secondary constructor
    public BeIcon (
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeIcon> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var icon = ReadIconNullable(ctx, reader);
      return new BeIcon(icon, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeIcon> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeIcon (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeIntercellSpacing {
    Default,
    None
  }
  
  
  public class BeMargin : IPrintable, IEquatable<BeMargin>
  {
    //fields
    //public fields
    [NotNull] public BeMarginItem Left {get; private set;}
    [NotNull] public BeMarginItem Top {get; private set;}
    [NotNull] public BeMarginItem Right {get; private set;}
    [NotNull] public BeMarginItem Bottom {get; private set;}
    
    //private fields
    //primary constructor
    public BeMargin(
      [NotNull] BeMarginItem left,
      [NotNull] BeMarginItem top,
      [NotNull] BeMarginItem right,
      [NotNull] BeMarginItem bottom
    )
    {
      if (left == null) throw new ArgumentNullException("left");
      if (top == null) throw new ArgumentNullException("top");
      if (right == null) throw new ArgumentNullException("right");
      if (bottom == null) throw new ArgumentNullException("bottom");
      
      Left = left;
      Top = top;
      Right = right;
      Bottom = bottom;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeMargin> Read = (ctx, reader) => 
    {
      var left = BeMarginItem.Read(ctx, reader);
      var top = BeMarginItem.Read(ctx, reader);
      var right = BeMarginItem.Read(ctx, reader);
      var bottom = BeMarginItem.Read(ctx, reader);
      return new BeMargin(left, top, right, bottom);
    };
    
    public static CtxWriteDelegate<BeMargin> Write = (ctx, writer, value) => 
    {
      BeMarginItem.Write(ctx, writer, value.Left);
      BeMarginItem.Write(ctx, writer, value.Top);
      BeMarginItem.Write(ctx, writer, value.Right);
      BeMarginItem.Write(ctx, writer, value.Bottom);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeMargin) obj);
    }
    public bool Equals(BeMargin other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Left, other.Left) && Equals(Top, other.Top) && Equals(Right, other.Right) && Equals(Bottom, other.Bottom);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Left.GetHashCode();
        hash = hash * 31 + Top.GetHashCode();
        hash = hash * 31 + Right.GetHashCode();
        hash = hash * 31 + Bottom.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeMargin (");
      using (printer.IndentCookie()) {
        printer.Print("left = "); Left.PrintEx(printer); printer.Println();
        printer.Print("top = "); Top.PrintEx(printer); printer.Println();
        printer.Print("right = "); Right.PrintEx(printer); printer.Println();
        printer.Print("bottom = "); Bottom.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeMarginItem : IPrintable, IEquatable<BeMarginItem>
  {
    //fields
    //public fields
    public BeMarginType Unit {get; private set;}
    public int Multiplier {get; private set;}
    
    //private fields
    //primary constructor
    public BeMarginItem(
      BeMarginType unit,
      int multiplier
    )
    {
      Unit = unit;
      Multiplier = multiplier;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeMarginItem> Read = (ctx, reader) => 
    {
      var unit = (BeMarginType)reader.ReadInt();
      var multiplier = reader.ReadInt();
      return new BeMarginItem(unit, multiplier);
    };
    
    public static CtxWriteDelegate<BeMarginItem> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Unit);
      writer.Write(value.Multiplier);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeMarginItem) obj);
    }
    public bool Equals(BeMarginItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Unit == other.Unit && Multiplier == other.Multiplier;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Unit;
        hash = hash * 31 + Multiplier.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeMarginItem (");
      using (printer.IndentCookie()) {
        printer.Print("unit = "); Unit.PrintEx(printer); printer.Println();
        printer.Print("multiplier = "); Multiplier.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeMarginType {
    None,
    OnePx,
    Checkbox,
    RadioButton
  }
  
  
  public class BeMarginWrapper : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeMargin Margin {get; private set;}
    [NotNull] public BeControl Contents {get; private set;}
    
    //private fields
    //primary constructor
    private BeMarginWrapper(
      [NotNull] BeMargin margin,
      [NotNull] BeControl contents,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (margin == null) throw new ArgumentNullException("margin");
      if (contents == null) throw new ArgumentNullException("contents");
      
      Margin = margin;
      Contents = contents;
      BindableChildren.Add(new KeyValuePair<string, object>("contents", Contents));
    }
    //secondary constructor
    public BeMarginWrapper (
      [NotNull] BeMargin margin,
      [NotNull] BeControl contents
    ) : this (
      margin,
      contents,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeMarginWrapper> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var margin = BeMargin.Read(ctx, reader);
      var contents = BeControl.Read(ctx, reader);
      return new BeMarginWrapper(margin, contents, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeMarginWrapper> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeMargin.Write(ctx, writer, value.Margin);
      BeControl.Write(ctx, writer, value.Contents);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeMarginWrapper (");
      using (printer.IndentCookie()) {
        printer.Print("margin = "); Margin.PrintEx(printer); printer.Println();
        printer.Print("contents = "); Contents.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeOpenDialogAction : BeButtonAction
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<BeDialog> Dialog { get { return _Dialog; }}
    
    //private fields
    [NotNull] private readonly RdProperty<BeDialog> _Dialog;
    
    //primary constructor
    private BeOpenDialogAction(
      [NotNull] RdProperty<BeDialog> dialog,
      [NotNull] RdSignal<RdVoid> click
    ) : base (
      click
     ) 
    {
      if (dialog == null) throw new ArgumentNullException("dialog");
      
      _Dialog = dialog;
      BindableChildren.Add(new KeyValuePair<string, object>("dialog", _Dialog));
    }
    //secondary constructor
    public BeOpenDialogAction (
    ) : this (
      new RdProperty<BeDialog>(BeDialog.Read, BeDialog.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeOpenDialogAction> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var click = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var dialog = RdProperty<BeDialog>.Read(ctx, reader, BeDialog.Read, BeDialog.Write);
      return new BeOpenDialogAction(dialog, click).WithId(_id);
    };
    
    public static new CtxWriteDelegate<BeOpenDialogAction> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._Click);
      RdProperty<BeDialog>.Write(ctx, writer, value._Dialog);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeOpenDialogAction (");
      using (printer.IndentCookie()) {
        printer.Print("dialog = "); _Dialog.PrintEx(printer); printer.Println();
        printer.Print("click = "); _Click.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BePathChooserAction : BeButtonAction
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> SelectedPath { get { return _SelectedPath; }}
    [NotNull] public IRdProperty<string> InitialPath { get { return _InitialPath; }}
    [NotNull] public IRdProperty<string> Mask { get { return _Mask; }}
    public JetBrains.Rider.Model.UIAutomation.PathChooser PathChooser {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _SelectedPath;
    [NotNull] private readonly RdProperty<string> _InitialPath;
    [NotNull] private readonly RdProperty<string> _Mask;
    
    //primary constructor
    private BePathChooserAction(
      [NotNull] RdProperty<string> selectedPath,
      [NotNull] RdProperty<string> initialPath,
      [NotNull] RdProperty<string> mask,
      JetBrains.Rider.Model.UIAutomation.PathChooser pathChooser,
      [NotNull] RdSignal<RdVoid> click
    ) : base (
      click
     ) 
    {
      if (selectedPath == null) throw new ArgumentNullException("selectedPath");
      if (initialPath == null) throw new ArgumentNullException("initialPath");
      if (mask == null) throw new ArgumentNullException("mask");
      
      _SelectedPath = selectedPath;
      _InitialPath = initialPath;
      _Mask = mask;
      PathChooser = pathChooser;
      _SelectedPath.OptimizeNested = true;
      _InitialPath.OptimizeNested = true;
      _Mask.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("selectedPath", _SelectedPath));
      BindableChildren.Add(new KeyValuePair<string, object>("initialPath", _InitialPath));
      BindableChildren.Add(new KeyValuePair<string, object>("mask", _Mask));
    }
    //secondary constructor
    public BePathChooserAction (
      JetBrains.Rider.Model.UIAutomation.PathChooser pathChooser
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      pathChooser,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BePathChooserAction> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var click = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var selectedPath = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var initialPath = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var mask = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var pathChooser = (JetBrains.Rider.Model.UIAutomation.PathChooser)reader.ReadInt();
      return new BePathChooserAction(selectedPath, initialPath, mask, pathChooser, click).WithId(_id);
    };
    
    public static new CtxWriteDelegate<BePathChooserAction> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._Click);
      RdProperty<string>.Write(ctx, writer, value._SelectedPath);
      RdProperty<string>.Write(ctx, writer, value._InitialPath);
      RdProperty<string>.Write(ctx, writer, value._Mask);
      writer.Write((int)value.PathChooser);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BePathChooserAction (");
      using (printer.IndentCookie()) {
        printer.Print("selectedPath = "); _SelectedPath.PrintEx(printer); printer.Println();
        printer.Print("initialPath = "); _InitialPath.PrintEx(printer); printer.Println();
        printer.Print("mask = "); _Mask.PrintEx(printer); printer.Println();
        printer.Print("pathChooser = "); PathChooser.PrintEx(printer); printer.Println();
        printer.Print("click = "); _Click.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeRadioButton : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Property { get { return _Property; }}
    [NotNull] public BeRichText Description {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Property;
    
    //primary constructor
    private BeRadioButton(
      [NotNull] RdProperty<bool> property,
      [NotNull] BeRichText description,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (property == null) throw new ArgumentNullException("property");
      if (description == null) throw new ArgumentNullException("description");
      
      _Property = property;
      Description = description;
      _Property.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("property", _Property));
      BindableChildren.Add(new KeyValuePair<string, object>("description", Description));
    }
    //secondary constructor
    public BeRadioButton (
      [NotNull] BeRichText description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeRadioButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var property = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var description = BeRichText.Read(ctx, reader);
      return new BeRadioButton(property, description, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeRadioButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<bool>.Write(ctx, writer, value._Property);
      BeRichText.Write(ctx, writer, value.Description);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeRadioButton (");
      using (printer.IndentCookie()) {
        printer.Print("property = "); _Property.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeResharperAction : BeControl
  {
    //fields
    //public fields
    
    /// <summary>
    /// Not implemented in WPF frontend yet
    /// </summary>
    [NotNull] public string ResharperActionGroupId {get; private set;}
    
    /// <summary>
    /// Not implemented in WPF frontend yet
    /// </summary>
    [NotNull] public string ResharperActionId {get; private set;}
    
    //private fields
    //primary constructor
    private BeResharperAction(
      [NotNull] string resharperActionGroupId,
      [NotNull] string resharperActionId,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (resharperActionGroupId == null) throw new ArgumentNullException("resharperActionGroupId");
      if (resharperActionId == null) throw new ArgumentNullException("resharperActionId");
      
      ResharperActionGroupId = resharperActionGroupId;
      ResharperActionId = resharperActionId;
    }
    //secondary constructor
    public BeResharperAction (
      [NotNull] string resharperActionGroupId,
      [NotNull] string resharperActionId
    ) : this (
      resharperActionGroupId,
      resharperActionId,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeResharperAction> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var resharperActionGroupId = reader.ReadString();
      var resharperActionId = reader.ReadString();
      return new BeResharperAction(resharperActionGroupId, resharperActionId, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeResharperAction> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      writer.Write(value.ResharperActionGroupId);
      writer.Write(value.ResharperActionId);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeResharperAction (");
      using (printer.IndentCookie()) {
        printer.Print("resharperActionGroupId = "); ResharperActionGroupId.PrintEx(printer); printer.Println();
        printer.Print("resharperActionId = "); ResharperActionId.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeRichText : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.ModelRichText> Text { get { return _Text; }}
    public bool WrapText {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    
    /// <summary>
    /// For accelerators to work, targetId should be specified
    /// </summary>
    [NotNull] public IRdProperty<int> ShortcutIndex { get { return _ShortcutIndex; }}
    
    /// <summary>
    /// ControlId of the control associated with the label with shortcut
    /// </summary>
    [NotNull] public IRdProperty<string> Target { get { return _Target; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.ModelRichText> _Text;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    [NotNull] private readonly RdProperty<int> _ShortcutIndex;
    [NotNull] private readonly RdProperty<string> _Target;
    
    //primary constructor
    private BeRichText(
      [NotNull] RdProperty<JetBrains.Rider.Model.ModelRichText> text,
      bool wrapText,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon,
      [NotNull] RdProperty<int> shortcutIndex,
      [NotNull] RdProperty<string> target,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      if (icon == null) throw new ArgumentNullException("icon");
      if (shortcutIndex == null) throw new ArgumentNullException("shortcutIndex");
      if (target == null) throw new ArgumentNullException("target");
      
      _Text = text;
      WrapText = wrapText;
      _Icon = icon;
      _ShortcutIndex = shortcutIndex;
      _Target = target;
      _Text.OptimizeNested = true;
      _Icon.OptimizeNested = true;
      _ShortcutIndex.OptimizeNested = true;
      _Target.OptimizeNested = true;
      _Icon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
      BindableChildren.Add(new KeyValuePair<string, object>("shortcutIndex", _ShortcutIndex));
      BindableChildren.Add(new KeyValuePair<string, object>("target", _Target));
    }
    //secondary constructor
    public BeRichText (
      bool wrapText
    ) : this (
      new RdProperty<JetBrains.Rider.Model.ModelRichText>(JetBrains.Rider.Model.ModelRichText.Read, JetBrains.Rider.Model.ModelRichText.Write),
      wrapText,
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, -1),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeRichText> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<JetBrains.Rider.Model.ModelRichText>.Read(ctx, reader, JetBrains.Rider.Model.ModelRichText.Read, JetBrains.Rider.Model.ModelRichText.Write);
      var wrapText = reader.ReadBool();
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      var shortcutIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var target = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new BeRichText(text, wrapText, icon, shortcutIndex, target, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeRichText> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<JetBrains.Rider.Model.ModelRichText>.Write(ctx, writer, value._Text);
      writer.Write(value.WrapText);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
      RdProperty<int>.Write(ctx, writer, value._ShortcutIndex);
      RdProperty<string>.Write(ctx, writer, value._Target);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeRichText (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("wrapText = "); WrapText.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
        printer.Print("shortcutIndex = "); _ShortcutIndex.PrintEx(printer); printer.Println();
        printer.Print("target = "); _Target.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeScrollablePanel : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeScrollbarPolicy ScrollbarPolicy {get; private set;}
    [NotNull] public BeControlSize Size {get; private set;}
    [NotNull] public BeControl Content {get; private set;}
    
    //private fields
    //primary constructor
    private BeScrollablePanel(
      [NotNull] BeScrollbarPolicy scrollbarPolicy,
      [NotNull] BeControlSize size,
      [NotNull] BeControl content,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (scrollbarPolicy == null) throw new ArgumentNullException("scrollbarPolicy");
      if (size == null) throw new ArgumentNullException("size");
      if (content == null) throw new ArgumentNullException("content");
      
      ScrollbarPolicy = scrollbarPolicy;
      Size = size;
      Content = content;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    public BeScrollablePanel (
      [NotNull] BeScrollbarPolicy scrollbarPolicy,
      [NotNull] BeControlSize size,
      [NotNull] BeControl content
    ) : this (
      scrollbarPolicy,
      size,
      content,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeScrollablePanel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var scrollbarPolicy = BeScrollbarPolicy.Read(ctx, reader);
      var size = BeControlSize.Read(ctx, reader);
      var content = BeControl.Read(ctx, reader);
      return new BeScrollablePanel(scrollbarPolicy, size, content, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeScrollablePanel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeScrollbarPolicy.Write(ctx, writer, value.ScrollbarPolicy);
      BeControlSize.Write(ctx, writer, value.Size);
      BeControl.Write(ctx, writer, value.Content);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeScrollablePanel (");
      using (printer.IndentCookie()) {
        printer.Print("scrollbarPolicy = "); ScrollbarPolicy.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeScrollbarPolicy : IPrintable, IEquatable<BeScrollbarPolicy>
  {
    //fields
    //public fields
    public bool AllowHorizontalScrollbars {get; private set;}
    public bool AllowVerticalScrollbars {get; private set;}
    
    //private fields
    //primary constructor
    public BeScrollbarPolicy(
      bool allowHorizontalScrollbars,
      bool allowVerticalScrollbars
    )
    {
      AllowHorizontalScrollbars = allowHorizontalScrollbars;
      AllowVerticalScrollbars = allowVerticalScrollbars;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeScrollbarPolicy> Read = (ctx, reader) => 
    {
      var allowHorizontalScrollbars = reader.ReadBool();
      var allowVerticalScrollbars = reader.ReadBool();
      return new BeScrollbarPolicy(allowHorizontalScrollbars, allowVerticalScrollbars);
    };
    
    public static CtxWriteDelegate<BeScrollbarPolicy> Write = (ctx, writer, value) => 
    {
      writer.Write(value.AllowHorizontalScrollbars);
      writer.Write(value.AllowVerticalScrollbars);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeScrollbarPolicy) obj);
    }
    public bool Equals(BeScrollbarPolicy other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AllowHorizontalScrollbars == other.AllowHorizontalScrollbars && AllowVerticalScrollbars == other.AllowVerticalScrollbars;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AllowHorizontalScrollbars.GetHashCode();
        hash = hash * 31 + AllowVerticalScrollbars.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeScrollbarPolicy (");
      using (printer.IndentCookie()) {
        printer.Print("allowHorizontalScrollbars = "); AllowHorizontalScrollbars.PrintEx(printer); printer.Println();
        printer.Print("allowVerticalScrollbars = "); AllowVerticalScrollbars.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSearchBox : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    public JetBrains.Rider.Model.UIAutomation.Place Place {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    
    //primary constructor
    private BeSearchBox(
      [NotNull] RdProperty<string> text,
      JetBrains.Rider.Model.UIAutomation.Place place,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      _Text = text;
      Place = place;
      _Text.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
    }
    //secondary constructor
    public BeSearchBox (
      JetBrains.Rider.Model.UIAutomation.Place place = JetBrains.Rider.Model.UIAutomation.Place.Default
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      place,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSearchBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var place = (JetBrains.Rider.Model.UIAutomation.Place)reader.ReadInt();
      return new BeSearchBox(text, place, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSearchBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      writer.Write((int)value.Place);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSearchBox (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("place = "); Place.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSeparator : BeControl
  {
    //fields
    //public fields
    public GridOrientation Orientation {get; private set;}
    
    //private fields
    //primary constructor
    private BeSeparator(
      GridOrientation orientation,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      Orientation = orientation;
    }
    //secondary constructor
    public BeSeparator (
      GridOrientation orientation
    ) : this (
      orientation,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSeparator> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var orientation = (GridOrientation)reader.ReadInt();
      return new BeSeparator(orientation, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSeparator> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      writer.Write((int)value.Orientation);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSeparator (");
      using (printer.IndentCookie()) {
        printer.Print("orientation = "); Orientation.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeShowBorders {
    All,
    OnlyTop,
    OnlyBottom,
    TopAndBottom
  }
  
  
  public enum BeSizingType {
    Fill,
    Fit
  }
  
  
  public class BeSpacer : BeControl
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private BeSpacer(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeSpacer (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSpacer> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeSpacer(enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSpacer> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpacer (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpanColumnElement : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public BeGridElement Content {get; private set;}
    public int ColumnSpan {get; private set;}
    
    //private fields
    //primary constructor
    public BeSpanColumnElement(
      [NotNull] BeGridElement content,
      int columnSpan
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      
      Content = content;
      ColumnSpan = columnSpan;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeSpanColumnElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = BeGridElement.Read(ctx, reader);
      var columnSpan = reader.ReadInt();
      return new BeSpanColumnElement(content, columnSpan).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeSpanColumnElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BeGridElement.Write(ctx, writer, value.Content);
      writer.Write(value.ColumnSpan);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpanColumnElement (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("columnSpan = "); ColumnSpan.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpanGrid : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<BeSpanRowElement>> Items { get { return _Items; }}
    [NotNull] public List<BeUnitSize> Columns {get; private set;}
    public BeIntercellSpacing IntercellSpacing {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<BeSpanRowElement>> _Items;
    
    //primary constructor
    private BeSpanGrid(
      [NotNull] RdProperty<List<BeSpanRowElement>> items,
      [NotNull] List<BeUnitSize> columns,
      BeIntercellSpacing intercellSpacing,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (items == null) throw new ArgumentNullException("items");
      if (columns == null) throw new ArgumentNullException("columns");
      
      _Items = items;
      Columns = columns;
      IntercellSpacing = intercellSpacing;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
    }
    //secondary constructor
    public BeSpanGrid (
      [NotNull] List<BeUnitSize> columns,
      BeIntercellSpacing intercellSpacing
    ) : this (
      new RdProperty<List<BeSpanRowElement>>(ReadBeSpanRowElementList, WriteBeSpanRowElementList),
      columns,
      intercellSpacing,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSpanGrid> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var items = RdProperty<List<BeSpanRowElement>>.Read(ctx, reader, ReadBeSpanRowElementList, WriteBeSpanRowElementList);
      var columns = ReadBeUnitSizeList(ctx, reader);
      var intercellSpacing = (BeIntercellSpacing)reader.ReadInt();
      return new BeSpanGrid(items, columns, intercellSpacing, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeSpanRowElement>> ReadBeSpanRowElementList = BeSpanRowElement.Read.List();
    public static CtxReadDelegate<List<BeUnitSize>> ReadBeUnitSizeList = BeUnitSize.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSpanGrid> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<List<BeSpanRowElement>>.Write(ctx, writer, value._Items);
      WriteBeUnitSizeList(ctx, writer, value.Columns);
      writer.Write((int)value.IntercellSpacing);
    };
    public static CtxWriteDelegate<List<BeSpanRowElement>> WriteBeSpanRowElementList = BeSpanRowElement.Write.List();
    public static CtxWriteDelegate<List<BeUnitSize>> WriteBeUnitSizeList = BeUnitSize.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpanGrid (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("columns = "); Columns.PrintEx(printer); printer.Println();
        printer.Print("intercellSpacing = "); IntercellSpacing.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpanRowElement : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<BeSpanColumnElement>> Content { get { return _Content; }}
    [NotNull] public BeUnitSize Size {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<BeSpanColumnElement>> _Content;
    
    //primary constructor
    private BeSpanRowElement(
      [NotNull] RdProperty<List<BeSpanColumnElement>> content,
      [NotNull] BeUnitSize size
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      if (size == null) throw new ArgumentNullException("size");
      
      _Content = content;
      Size = size;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
    }
    //secondary constructor
    public BeSpanRowElement (
      [NotNull] BeUnitSize size
    ) : this (
      new RdProperty<List<BeSpanColumnElement>>(ReadBeSpanColumnElementList, WriteBeSpanColumnElementList),
      size
    ) {}
    //statics
    
    public static CtxReadDelegate<BeSpanRowElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = RdProperty<List<BeSpanColumnElement>>.Read(ctx, reader, ReadBeSpanColumnElementList, WriteBeSpanColumnElementList);
      var size = BeUnitSize.Read(ctx, reader);
      return new BeSpanRowElement(content, size).WithId(_id);
    };
    public static CtxReadDelegate<List<BeSpanColumnElement>> ReadBeSpanColumnElementList = BeSpanColumnElement.Read.List();
    
    public static CtxWriteDelegate<BeSpanRowElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<List<BeSpanColumnElement>>.Write(ctx, writer, value._Content);
      BeUnitSize.Write(ctx, writer, value.Size);
    };
    public static CtxWriteDelegate<List<BeSpanColumnElement>> WriteBeSpanColumnElementList = BeSpanColumnElement.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpanRowElement (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpinner : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    public int MinValue {get; private set;}
    public int MaxValue {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Value;
    
    //primary constructor
    private BeSpinner(
      [NotNull] RdProperty<int> value,
      int minValue,
      int maxValue,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      MinValue = minValue;
      MaxValue = maxValue;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public BeSpinner (
      int minValue,
      int maxValue
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      minValue,
      maxValue,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSpinner> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var value = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var minValue = reader.ReadInt();
      var maxValue = reader.ReadInt();
      return new BeSpinner(value, minValue, maxValue, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSpinner> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<int>.Write(ctx, writer, value._Value);
      writer.Write(value.MinValue);
      writer.Write(value.MaxValue);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpinner (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("minValue = "); MinValue.PrintEx(printer); printer.Println();
        printer.Print("maxValue = "); MaxValue.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSplitControl : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeControl FirstPanel {get; private set;}
    [NotNull] public BeControl SecondPanel {get; private set;}
    public bool IsVertical {get; private set;}
    public float Proportion {get; private set;}
    
    //private fields
    //primary constructor
    private BeSplitControl(
      [NotNull] BeControl firstPanel,
      [NotNull] BeControl secondPanel,
      bool isVertical,
      float proportion,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (firstPanel == null) throw new ArgumentNullException("firstPanel");
      if (secondPanel == null) throw new ArgumentNullException("secondPanel");
      
      FirstPanel = firstPanel;
      SecondPanel = secondPanel;
      IsVertical = isVertical;
      Proportion = proportion;
      BindableChildren.Add(new KeyValuePair<string, object>("firstPanel", FirstPanel));
      BindableChildren.Add(new KeyValuePair<string, object>("secondPanel", SecondPanel));
    }
    //secondary constructor
    public BeSplitControl (
      [NotNull] BeControl firstPanel,
      [NotNull] BeControl secondPanel,
      bool isVertical,
      float proportion
    ) : this (
      firstPanel,
      secondPanel,
      isVertical,
      proportion,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSplitControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var firstPanel = BeControl.Read(ctx, reader);
      var secondPanel = BeControl.Read(ctx, reader);
      var isVertical = reader.ReadBool();
      var proportion = reader.ReadFloat();
      return new BeSplitControl(firstPanel, secondPanel, isVertical, proportion, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSplitControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.FirstPanel);
      BeControl.Write(ctx, writer, value.SecondPanel);
      writer.Write(value.IsVertical);
      writer.Write(value.Proportion);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSplitControl (");
      using (printer.IndentCookie()) {
        printer.Print("firstPanel = "); FirstPanel.PrintEx(printer); printer.Println();
        printer.Print("secondPanel = "); SecondPanel.PrintEx(printer); printer.Println();
        printer.Print("isVertical = "); IsVertical.PrintEx(printer); printer.Println();
        printer.Print("proportion = "); Proportion.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTab : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeRichText TabName {get; private set;}
    [NotNull] public BeControl Content {get; private set;}
    
    //private fields
    //primary constructor
    private BeTab(
      [NotNull] BeRichText tabName,
      [NotNull] BeControl content,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (tabName == null) throw new ArgumentNullException("tabName");
      if (content == null) throw new ArgumentNullException("content");
      
      TabName = tabName;
      Content = content;
      BindableChildren.Add(new KeyValuePair<string, object>("tabName", TabName));
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    public BeTab (
      [NotNull] BeRichText tabName,
      [NotNull] BeControl content
    ) : this (
      tabName,
      content,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTab> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var tabName = BeRichText.Read(ctx, reader);
      var content = BeControl.Read(ctx, reader);
      return new BeTab(tabName, content, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTab> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeRichText.Write(ctx, writer, value.TabName);
      BeControl.Write(ctx, writer, value.Content);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTab (");
      using (printer.IndentCookie()) {
        printer.Print("tabName = "); TabName.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTabbedControl : BeControl
  {
    //fields
    //public fields
    [NotNull] public IViewableList<BeTab> Tabs { get { return _Tabs; }}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    
    //private fields
    [NotNull] private readonly RdList<BeTab> _Tabs;
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    
    //primary constructor
    private BeTabbedControl(
      [NotNull] RdList<BeTab> tabs,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (tabs == null) throw new ArgumentNullException("tabs");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      
      _Tabs = tabs;
      _SelectedIndex = selectedIndex;
      _SelectedIndex.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("tabs", _Tabs));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
    }
    //secondary constructor
    public BeTabbedControl (
    ) : this (
      new RdList<BeTab>(BeTab.Read, BeTab.Write),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTabbedControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var tabs = RdList<BeTab>.Read(ctx, reader, BeTab.Read, BeTab.Write);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new BeTabbedControl(tabs, selectedIndex, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTabbedControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdList<BeTab>.Write(ctx, writer, value._Tabs);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTabbedControl (");
      using (printer.IndentCookie()) {
        printer.Print("tabs = "); _Tabs.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTextBox : BeControlWithValidation
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public IRdProperty<int> SelectionLength { get { return _SelectionLength; }}
    [NotNull] public IRdProperty<int> Caret { get { return _Caret; }}
    [NotNull] public BeTextBoxSettings Settings {get; private set;}
    [NotNull] public IRdProperty<List<BeCompletionItem>> CompletionItems { get { return _CompletionItems; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] private readonly RdProperty<int> _SelectionLength;
    [NotNull] private readonly RdProperty<int> _Caret;
    [NotNull] private readonly RdProperty<List<BeCompletionItem>> _CompletionItems;
    
    //primary constructor
    private BeTextBox(
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<int> selectionLength,
      [NotNull] RdProperty<int> caret,
      [NotNull] BeTextBoxSettings settings,
      [NotNull] RdProperty<List<BeCompletionItem>> completionItems,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle> validationStyle,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      validationResult,
      validationStyle,
      handledByParent,
      revalidate,
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      if (selectionLength == null) throw new ArgumentNullException("selectionLength");
      if (caret == null) throw new ArgumentNullException("caret");
      if (settings == null) throw new ArgumentNullException("settings");
      if (completionItems == null) throw new ArgumentNullException("completionItems");
      
      _Text = text;
      _SelectionLength = selectionLength;
      _Caret = caret;
      Settings = settings;
      _CompletionItems = completionItems;
      _Text.OptimizeNested = true;
      _SelectionLength.OptimizeNested = true;
      _Caret.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("selectionLength", _SelectionLength));
      BindableChildren.Add(new KeyValuePair<string, object>("caret", _Caret));
      BindableChildren.Add(new KeyValuePair<string, object>("settings", Settings));
      BindableChildren.Add(new KeyValuePair<string, object>("completionItems", _CompletionItems));
    }
    //secondary constructor
    public BeTextBox (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, 0),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, 0),
      new BeTextBoxSettings(),
      new RdProperty<List<BeCompletionItem>>(ReadBeCompletionItemList, WriteBeCompletionItemList),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(ReadValidationStyle, WriteValidationStyle),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTextBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var validationStyle = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Read(ctx, reader, ReadValidationStyle, WriteValidationStyle);
      var handledByParent = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var revalidate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var selectionLength = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var caret = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var settings = BeTextBoxSettings.Read(ctx, reader);
      var completionItems = RdProperty<List<BeCompletionItem>>.Read(ctx, reader, ReadBeCompletionItemList, WriteBeCompletionItemList);
      return new BeTextBox(text, selectionLength, caret, settings, completionItems, validationResult, validationStyle, handledByParent, revalidate, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeCompletionItem>> ReadBeCompletionItemList = BeCompletionItem.Read.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> ReadValidationStyle = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTextBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Write(ctx, writer, value._ValidationStyle);
      RdProperty<bool>.Write(ctx, writer, value._HandledByParent);
      RdSignal<RdVoid>.Write(ctx, writer, value._Revalidate);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<int>.Write(ctx, writer, value._SelectionLength);
      RdProperty<int>.Write(ctx, writer, value._Caret);
      BeTextBoxSettings.Write(ctx, writer, value.Settings);
      RdProperty<List<BeCompletionItem>>.Write(ctx, writer, value._CompletionItems);
    };
    public static CtxWriteDelegate<List<BeCompletionItem>> WriteBeCompletionItemList = BeCompletionItem.Write.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> WriteValidationStyle = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTextBox (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("selectionLength = "); _SelectionLength.PrintEx(printer); printer.Println();
        printer.Print("caret = "); _Caret.PrintEx(printer); printer.Println();
        printer.Print("settings = "); Settings.PrintEx(printer); printer.Println();
        printer.Print("completionItems = "); _CompletionItems.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("validationStyle = "); _ValidationStyle.PrintEx(printer); printer.Println();
        printer.Print("handledByParent = "); _HandledByParent.PrintEx(printer); printer.Println();
        printer.Print("revalidate = "); _Revalidate.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTextBoxSettings : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Readonly { get { return _Readonly; }}
    [NotNull] public IRdProperty<bool> Monospace { get { return _Monospace; }}
    [NotNull] public IRdProperty<bool> UseCamelHumps { get { return _UseCamelHumps; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Readonly;
    [NotNull] private readonly RdProperty<bool> _Monospace;
    [NotNull] private readonly RdProperty<bool> _UseCamelHumps;
    
    //primary constructor
    private BeTextBoxSettings(
      [NotNull] RdProperty<bool> @readonly,
      [NotNull] RdProperty<bool> monospace,
      [NotNull] RdProperty<bool> useCamelHumps
    )
    {
      if (@readonly == null) throw new ArgumentNullException("readonly");
      if (monospace == null) throw new ArgumentNullException("monospace");
      if (useCamelHumps == null) throw new ArgumentNullException("useCamelHumps");
      
      _Readonly = @readonly;
      _Monospace = monospace;
      _UseCamelHumps = useCamelHumps;
      _Readonly.OptimizeNested = true;
      _Monospace.OptimizeNested = true;
      _UseCamelHumps.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("readonly", _Readonly));
      BindableChildren.Add(new KeyValuePair<string, object>("monospace", _Monospace));
      BindableChildren.Add(new KeyValuePair<string, object>("useCamelHumps", _UseCamelHumps));
    }
    //secondary constructor
    public BeTextBoxSettings (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false)
    ) {}
    //statics
    
    public static CtxReadDelegate<BeTextBoxSettings> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var @readonly = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var monospace = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var useCamelHumps = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new BeTextBoxSettings(@readonly, monospace, useCamelHumps).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeTextBoxSettings> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Readonly);
      RdProperty<bool>.Write(ctx, writer, value._Monospace);
      RdProperty<bool>.Write(ctx, writer, value._UseCamelHumps);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTextBoxSettings (");
      using (printer.IndentCookie()) {
        printer.Print("readonly = "); _Readonly.PrintEx(printer); printer.Println();
        printer.Print("monospace = "); _Monospace.PrintEx(printer); printer.Println();
        printer.Print("useCamelHumps = "); _UseCamelHumps.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTextControl : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public BeTextBoxSettings Settings {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    
    //primary constructor
    private BeTextControl(
      [NotNull] RdProperty<string> text,
      [NotNull] BeTextBoxSettings settings,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      if (settings == null) throw new ArgumentNullException("settings");
      
      _Text = text;
      Settings = settings;
      _Text.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("settings", Settings));
    }
    //secondary constructor
    public BeTextControl (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new BeTextBoxSettings(),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTextControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var settings = BeTextBoxSettings.Read(ctx, reader);
      return new BeTextControl(text, settings, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTextControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      BeTextBoxSettings.Write(ctx, writer, value.Settings);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTextControl (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("settings = "); Settings.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTextControlWithLanguage : BeControl
  {
    //fields
    //public fields
    [NotNull] public BeTextControl TextControl {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.RdLanguage Language {get; private set;}
    
    //private fields
    //primary constructor
    private BeTextControlWithLanguage(
      [NotNull] BeTextControl textControl,
      [CanBeNull] JetBrains.Rider.Model.RdLanguage language,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (textControl == null) throw new ArgumentNullException("textControl");
      
      TextControl = textControl;
      Language = language;
      BindableChildren.Add(new KeyValuePair<string, object>("textControl", TextControl));
    }
    //secondary constructor
    public BeTextControlWithLanguage (
      [NotNull] BeTextControl textControl,
      [CanBeNull] JetBrains.Rider.Model.RdLanguage language
    ) : this (
      textControl,
      language,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTextControlWithLanguage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var textControl = BeTextControl.Read(ctx, reader);
      var language = ReadRdLanguageNullable(ctx, reader);
      return new BeTextControlWithLanguage(textControl, language, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.RdLanguage> ReadRdLanguageNullable = JetBrains.Rider.Model.RdLanguage.Read.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTextControlWithLanguage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeTextControl.Write(ctx, writer, value.TextControl);
      WriteRdLanguageNullable(ctx, writer, value.Language);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.RdLanguage> WriteRdLanguageNullable = JetBrains.Rider.Model.RdLanguage.Write.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTextControlWithLanguage (");
      using (printer.IndentCookie()) {
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeToggleButton : BeAbstractButton
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsChecked { get { return _IsChecked; }}
    [NotNull] public IRdProperty<bool> UseLabelRenderer { get { return _UseLabelRenderer; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsChecked;
    [NotNull] private readonly RdProperty<bool> _UseLabelRenderer;
    
    //primary constructor
    private BeToggleButton(
      [NotNull] RdProperty<bool> isChecked,
      [NotNull] RdProperty<bool> useLabelRenderer,
      [NotNull] BeRichText content,
      BeButtonStyle style,
      [NotNull] RdProperty<bool> isMouseOver,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      content,
      style,
      isMouseOver,
      tooltip,
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (isChecked == null) throw new ArgumentNullException("isChecked");
      if (useLabelRenderer == null) throw new ArgumentNullException("useLabelRenderer");
      
      _IsChecked = isChecked;
      _UseLabelRenderer = useLabelRenderer;
      _IsChecked.OptimizeNested = true;
      _UseLabelRenderer.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isChecked", _IsChecked));
      BindableChildren.Add(new KeyValuePair<string, object>("useLabelRenderer", _UseLabelRenderer));
    }
    //secondary constructor
    public BeToggleButton (
      [NotNull] BeRichText content,
      BeButtonStyle style = BeButtonStyle.DEFAULT
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      content,
      style,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeToggleButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = BeRichText.Read(ctx, reader);
      var style = (BeButtonStyle)reader.ReadInt();
      var isMouseOver = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var isChecked = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var useLabelRenderer = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new BeToggleButton(isChecked, useLabelRenderer, content, style, isMouseOver, tooltip, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeToggleButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BeRichText.Write(ctx, writer, value.Content);
      writer.Write((int)value.Style);
      RdProperty<bool>.Write(ctx, writer, value._IsMouseOver);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<bool>.Write(ctx, writer, value._IsChecked);
      RdProperty<bool>.Write(ctx, writer, value._UseLabelRenderer);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeToggleButton (");
      using (printer.IndentCookie()) {
        printer.Print("isChecked = "); _IsChecked.PrintEx(printer); printer.Println();
        printer.Print("useLabelRenderer = "); _UseLabelRenderer.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("style = "); Style.PrintEx(printer); printer.Println();
        printer.Print("isMouseOver = "); _IsMouseOver.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeToolbar : BeControl
  {
    //fields
    //public fields
    
    /// <summary>
    /// placed inside because sometimes placement of toolbar depends on OS
    /// </summary>
    [NotNull] public BeControl Content {get; private set;}
    public BeDock Dock {get; private set;}
    public BeToolbarStyle Style {get; private set;}
    [NotNull] public IViewableList<BeControl> ToolbarItems { get { return _ToolbarItems; }}
    
    //private fields
    [NotNull] private readonly RdList<BeControl> _ToolbarItems;
    
    //primary constructor
    private BeToolbar(
      [NotNull] BeControl content,
      BeDock dock,
      BeToolbarStyle style,
      [NotNull] RdList<BeControl> toolbarItems,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (toolbarItems == null) throw new ArgumentNullException("toolbarItems");
      
      Content = content;
      Dock = dock;
      Style = style;
      _ToolbarItems = toolbarItems;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("toolbarItems", _ToolbarItems));
    }
    //secondary constructor
    public BeToolbar (
      [NotNull] BeControl content,
      BeDock dock,
      BeToolbarStyle style
    ) : this (
      content,
      dock,
      style,
      new RdList<BeControl>(BeControl.Read, BeControl.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeToolbar> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeControl.Read(ctx, reader);
      var dock = (BeDock)reader.ReadInt();
      var style = (BeToolbarStyle)reader.ReadInt();
      var toolbarItems = RdList<BeControl>.Read(ctx, reader, BeControl.Read, BeControl.Write);
      return new BeToolbar(content, dock, style, toolbarItems, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeToolbar> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Content);
      writer.Write((int)value.Dock);
      writer.Write((int)value.Style);
      RdList<BeControl>.Write(ctx, writer, value._ToolbarItems);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeToolbar (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("dock = "); Dock.PrintEx(printer); printer.Println();
        printer.Print("style = "); Style.PrintEx(printer); printer.Println();
        printer.Print("toolbarItems = "); _ToolbarItems.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeToolbarStyle {
    
    /// <summary>
    /// Icon only
    /// </summary>
    DEFAULT,
    
    /// <summary>
    /// Icon only in IDEA and Icon+Text in VS
    /// </summary>
    HYBRID
  }
  
  
  public class BeTreeConfiguration : RdBindableBase
  {
    //fields
    //public fields
    [NotNull] public List<BeColumnDefinition> ColumnDefinitions {get; private set;}
    public BeTreeSelection Selection {get; private set;}
    public bool HasHeader {get; private set;}
    [NotNull] public IRdProperty<BeBackendContextMenu> BackendContextMenu { get { return _BackendContextMenu; }}
    public JetBrains.Rider.Model.UIAutomation.ChildOffsetSize ChildOffsetSize {get; private set;}
    public bool ShowAsList {get; private set;}
    public bool AutoScrollToEnd {get; private set;}
    public BeShowBorders ShowBorders {get; private set;}
    public bool AutoStartEditing {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<BeBackendContextMenu> _BackendContextMenu;
    
    //primary constructor
    private BeTreeConfiguration(
      [NotNull] List<BeColumnDefinition> columnDefinitions,
      BeTreeSelection selection,
      bool hasHeader,
      [NotNull] RdProperty<BeBackendContextMenu> backendContextMenu,
      JetBrains.Rider.Model.UIAutomation.ChildOffsetSize childOffsetSize,
      bool showAsList,
      bool autoScrollToEnd,
      BeShowBorders showBorders,
      bool autoStartEditing
    )
    {
      if (columnDefinitions == null) throw new ArgumentNullException("columnDefinitions");
      if (backendContextMenu == null) throw new ArgumentNullException("backendContextMenu");
      
      ColumnDefinitions = columnDefinitions;
      Selection = selection;
      HasHeader = hasHeader;
      _BackendContextMenu = backendContextMenu;
      ChildOffsetSize = childOffsetSize;
      ShowAsList = showAsList;
      AutoScrollToEnd = autoScrollToEnd;
      ShowBorders = showBorders;
      AutoStartEditing = autoStartEditing;
      _BackendContextMenu.OptimizeNested = true;
      _BackendContextMenu.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("columnDefinitions", ColumnDefinitions));
      BindableChildren.Add(new KeyValuePair<string, object>("backendContextMenu", _BackendContextMenu));
    }
    //secondary constructor
    public BeTreeConfiguration (
      [NotNull] List<BeColumnDefinition> columnDefinitions,
      BeTreeSelection selection,
      bool hasHeader,
      JetBrains.Rider.Model.UIAutomation.ChildOffsetSize childOffsetSize,
      bool showAsList,
      bool autoScrollToEnd,
      BeShowBorders showBorders = BeShowBorders.All,
      bool autoStartEditing = true
    ) : this (
      columnDefinitions,
      selection,
      hasHeader,
      new RdProperty<BeBackendContextMenu>(ReadBeBackendContextMenuNullable, WriteBeBackendContextMenuNullable),
      childOffsetSize,
      showAsList,
      autoScrollToEnd,
      showBorders,
      autoStartEditing
    ) {}
    //statics
    
    public static CtxReadDelegate<BeTreeConfiguration> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var columnDefinitions = ReadBeColumnDefinitionList(ctx, reader);
      var selection = (BeTreeSelection)reader.ReadInt();
      var hasHeader = reader.ReadBool();
      var backendContextMenu = RdProperty<BeBackendContextMenu>.Read(ctx, reader, ReadBeBackendContextMenuNullable, WriteBeBackendContextMenuNullable);
      var childOffsetSize = (JetBrains.Rider.Model.UIAutomation.ChildOffsetSize)reader.ReadInt();
      var showAsList = reader.ReadBool();
      var autoScrollToEnd = reader.ReadBool();
      var showBorders = (BeShowBorders)reader.ReadInt();
      var autoStartEditing = reader.ReadBool();
      return new BeTreeConfiguration(columnDefinitions, selection, hasHeader, backendContextMenu, childOffsetSize, showAsList, autoScrollToEnd, showBorders, autoStartEditing).WithId(_id);
    };
    public static CtxReadDelegate<List<BeColumnDefinition>> ReadBeColumnDefinitionList = BeColumnDefinition.Read.List();
    public static CtxReadDelegate<BeBackendContextMenu> ReadBeBackendContextMenuNullable = BeBackendContextMenu.Read.NullableClass();
    
    public static CtxWriteDelegate<BeTreeConfiguration> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteBeColumnDefinitionList(ctx, writer, value.ColumnDefinitions);
      writer.Write((int)value.Selection);
      writer.Write(value.HasHeader);
      RdProperty<BeBackendContextMenu>.Write(ctx, writer, value._BackendContextMenu);
      writer.Write((int)value.ChildOffsetSize);
      writer.Write(value.ShowAsList);
      writer.Write(value.AutoScrollToEnd);
      writer.Write((int)value.ShowBorders);
      writer.Write(value.AutoStartEditing);
    };
    public static CtxWriteDelegate<List<BeColumnDefinition>> WriteBeColumnDefinitionList = BeColumnDefinition.Write.List();
    public static CtxWriteDelegate<BeBackendContextMenu> WriteBeBackendContextMenuNullable = BeBackendContextMenu.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTreeConfiguration (");
      using (printer.IndentCookie()) {
        printer.Print("columnDefinitions = "); ColumnDefinitions.PrintEx(printer); printer.Println();
        printer.Print("selection = "); Selection.PrintEx(printer); printer.Println();
        printer.Print("hasHeader = "); HasHeader.PrintEx(printer); printer.Println();
        printer.Print("backendContextMenu = "); _BackendContextMenu.PrintEx(printer); printer.Println();
        printer.Print("childOffsetSize = "); ChildOffsetSize.PrintEx(printer); printer.Println();
        printer.Print("showAsList = "); ShowAsList.PrintEx(printer); printer.Println();
        printer.Print("autoScrollToEnd = "); AutoScrollToEnd.PrintEx(printer); printer.Println();
        printer.Print("showBorders = "); ShowBorders.PrintEx(printer); printer.Println();
        printer.Print("autoStartEditing = "); AutoStartEditing.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTreeGrid : BeControlWithValidation
  {
    //fields
    //public fields
    [NotNull] public BeTreeGridLine FakeRoot {get; private set;}
    [NotNull] public BeTreeConfiguration Configuration {get; private set;}
    [NotNull] public IRdProperty<AbstractProgress> Progress { get { return _Progress; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.ModelRichText> EmptyText { get { return _EmptyText; }}
    
    //private fields
    [NotNull] private readonly RdProperty<AbstractProgress> _Progress;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.ModelRichText> _EmptyText;
    
    //primary constructor
    private BeTreeGrid(
      [NotNull] BeTreeGridLine fakeRoot,
      [NotNull] BeTreeConfiguration configuration,
      [NotNull] RdProperty<AbstractProgress> progress,
      [NotNull] RdProperty<JetBrains.Rider.Model.ModelRichText> emptyText,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle> validationStyle,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      validationResult,
      validationStyle,
      handledByParent,
      revalidate,
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (fakeRoot == null) throw new ArgumentNullException("fakeRoot");
      if (configuration == null) throw new ArgumentNullException("configuration");
      if (progress == null) throw new ArgumentNullException("progress");
      if (emptyText == null) throw new ArgumentNullException("emptyText");
      
      FakeRoot = fakeRoot;
      Configuration = configuration;
      _Progress = progress;
      _EmptyText = emptyText;
      _EmptyText.OptimizeNested = true;
      _Progress.ValueCanBeNull = true;
      _EmptyText.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("fakeRoot", FakeRoot));
      BindableChildren.Add(new KeyValuePair<string, object>("configuration", Configuration));
      BindableChildren.Add(new KeyValuePair<string, object>("progress", _Progress));
      BindableChildren.Add(new KeyValuePair<string, object>("emptyText", _EmptyText));
    }
    //secondary constructor
    public BeTreeGrid (
      [NotNull] BeTreeGridLine fakeRoot,
      [NotNull] BeTreeConfiguration configuration
    ) : this (
      fakeRoot,
      configuration,
      new RdProperty<AbstractProgress>(ReadAbstractProgressNullable, WriteAbstractProgressNullable),
      new RdProperty<JetBrains.Rider.Model.ModelRichText>(ReadModelRichTextNullable, WriteModelRichTextNullable),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(ReadValidationStyle, WriteValidationStyle),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTreeGrid> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var validationStyle = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Read(ctx, reader, ReadValidationStyle, WriteValidationStyle);
      var handledByParent = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var revalidate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var fakeRoot = BeTreeGridLine.Read(ctx, reader);
      var configuration = BeTreeConfiguration.Read(ctx, reader);
      var progress = RdProperty<AbstractProgress>.Read(ctx, reader, ReadAbstractProgressNullable, WriteAbstractProgressNullable);
      var emptyText = RdProperty<JetBrains.Rider.Model.ModelRichText>.Read(ctx, reader, ReadModelRichTextNullable, WriteModelRichTextNullable);
      return new BeTreeGrid(fakeRoot, configuration, progress, emptyText, validationResult, validationStyle, handledByParent, revalidate, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<AbstractProgress> ReadAbstractProgressNullable = AbstractProgress.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.ModelRichText> ReadModelRichTextNullable = JetBrains.Rider.Model.ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> ReadValidationStyle = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTreeGrid> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationStyle>.Write(ctx, writer, value._ValidationStyle);
      RdProperty<bool>.Write(ctx, writer, value._HandledByParent);
      RdSignal<RdVoid>.Write(ctx, writer, value._Revalidate);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeTreeGridLine.Write(ctx, writer, value.FakeRoot);
      BeTreeConfiguration.Write(ctx, writer, value.Configuration);
      RdProperty<AbstractProgress>.Write(ctx, writer, value._Progress);
      RdProperty<JetBrains.Rider.Model.ModelRichText>.Write(ctx, writer, value._EmptyText);
    };
    public static CtxWriteDelegate<AbstractProgress> WriteAbstractProgressNullable = AbstractProgress.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.ModelRichText> WriteModelRichTextNullable = JetBrains.Rider.Model.ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle> WriteValidationStyle = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ValidationStyle>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ValidationStyle>);
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTreeGrid (");
      using (printer.IndentCookie()) {
        printer.Print("fakeRoot = "); FakeRoot.PrintEx(printer); printer.Println();
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
        printer.Print("progress = "); _Progress.PrintEx(printer); printer.Println();
        printer.Print("emptyText = "); _EmptyText.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("validationStyle = "); _ValidationStyle.PrintEx(printer); printer.Println();
        printer.Print("handledByParent = "); _HandledByParent.PrintEx(printer); printer.Println();
        printer.Print("revalidate = "); _Revalidate.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTreeGridLine : BeControl
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] public List<BeControl> ColumnElements {get; private set;}
    [NotNull] public IRdProperty<bool> IsExpanded { get { return _IsExpanded; }}
    [NotNull] public IViewableList<BeControl> Children { get { return _Children; }}
    [NotNull] public IRdSignal<RdVoid> Signal { get { return _Signal; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    [NotNull] private readonly RdProperty<bool> _IsExpanded;
    [NotNull] private readonly RdList<BeControl> _Children;
    [NotNull] private readonly RdSignal<RdVoid> _Signal;
    
    //primary constructor
    private BeTreeGridLine(
      [NotNull] RdProperty<bool> isSelected,
      [NotNull] List<BeControl> columnElements,
      [NotNull] RdProperty<bool> isExpanded,
      [NotNull] RdList<BeControl> children,
      [NotNull] RdSignal<RdVoid> signal,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdSignal<RdVoid> focus,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      focus,
      visible
     ) 
    {
      if (isSelected == null) throw new ArgumentNullException("isSelected");
      if (columnElements == null) throw new ArgumentNullException("columnElements");
      if (isExpanded == null) throw new ArgumentNullException("isExpanded");
      if (children == null) throw new ArgumentNullException("children");
      if (signal == null) throw new ArgumentNullException("signal");
      
      _IsSelected = isSelected;
      ColumnElements = columnElements;
      _IsExpanded = isExpanded;
      _Children = children;
      _Signal = signal;
      _IsSelected.OptimizeNested = true;
      _IsExpanded.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isSelected", _IsSelected));
      BindableChildren.Add(new KeyValuePair<string, object>("columnElements", ColumnElements));
      BindableChildren.Add(new KeyValuePair<string, object>("isExpanded", _IsExpanded));
      BindableChildren.Add(new KeyValuePair<string, object>("children", _Children));
      BindableChildren.Add(new KeyValuePair<string, object>("signal", _Signal));
    }
    //secondary constructor
    public BeTreeGridLine (
      [NotNull] List<BeControl> columnElements
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      columnElements,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdList<BeControl>(BeControl.Read, BeControl.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, true),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ""),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTreeGridLine> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var focus = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var isSelected = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var columnElements = ReadBeControlList(ctx, reader);
      var isExpanded = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var children = RdList<BeControl>.Read(ctx, reader, BeControl.Read, BeControl.Write);
      var signal = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new BeTreeGridLine(isSelected, columnElements, isExpanded, children, signal, enabled, controlId, focus, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeControl>> ReadBeControlList = BeControl.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTreeGridLine> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdSignal<RdVoid>.Write(ctx, writer, value._Focus);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
      WriteBeControlList(ctx, writer, value.ColumnElements);
      RdProperty<bool>.Write(ctx, writer, value._IsExpanded);
      RdList<BeControl>.Write(ctx, writer, value._Children);
      RdSignal<RdVoid>.Write(ctx, writer, value._Signal);
    };
    public static CtxWriteDelegate<List<BeControl>> WriteBeControlList = BeControl.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTreeGridLine (");
      using (printer.IndentCookie()) {
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
        printer.Print("columnElements = "); ColumnElements.PrintEx(printer); printer.Println();
        printer.Print("isExpanded = "); _IsExpanded.PrintEx(printer); printer.Println();
        printer.Print("children = "); _Children.PrintEx(printer); printer.Println();
        printer.Print("signal = "); _Signal.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeTreeSelection {
    Multi,
    Single
  }
  
  
  public class BeUnitSize : IPrintable, IEquatable<BeUnitSize>
  {
    //fields
    //public fields
    public BeSizingType Unit {get; private set;}
    public int Multiplier {get; private set;}
    
    //private fields
    //primary constructor
    public BeUnitSize(
      BeSizingType unit,
      int multiplier
    )
    {
      Unit = unit;
      Multiplier = multiplier;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeUnitSize> Read = (ctx, reader) => 
    {
      var unit = (BeSizingType)reader.ReadInt();
      var multiplier = reader.ReadInt();
      return new BeUnitSize(unit, multiplier);
    };
    
    public static CtxWriteDelegate<BeUnitSize> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Unit);
      writer.Write(value.Multiplier);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeUnitSize) obj);
    }
    public bool Equals(BeUnitSize other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Unit == other.Unit && Multiplier == other.Multiplier;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Unit;
        hash = hash * 31 + Multiplier.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeUnitSize (");
      using (printer.IndentCookie()) {
        printer.Print("unit = "); Unit.PrintEx(printer); printer.Println();
        printer.Print("multiplier = "); Multiplier.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeUserAction : BeButtonAction
  {
    //fields
    //public fields
    
    //private fields
    //primary constructor
    private BeUserAction(
      [NotNull] RdSignal<RdVoid> click
    ) : base (
      click
     ) 
    {
    }
    //secondary constructor
    public BeUserAction (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeUserAction> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var click = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new BeUserAction(click).WithId(_id);
    };
    
    public static new CtxWriteDelegate<BeUserAction> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._Click);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeUserAction (");
      using (printer.IndentCookie()) {
        printer.Print("click = "); _Click.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ChildOffsetSize {
    DEFAULT,
    SMALL
  }
  
  
  public enum ControlVisibility {
    Visible,
    Collapsed,
    Hidden
  }
  
  
  public enum DialogModality {
    MODAL,
    NON_MODAL
  }
  
  
  public enum DialogResult {
    OK,
    CANCEL,
    CLOSE
  }
  
  
  public enum GridOrientation {
    Horizontal,
    Vertical
  }
  
  
  public class IndefiniteProgress : AbstractProgress
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> InProgress { get { return _InProgress; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _InProgress;
    
    //primary constructor
    private IndefiniteProgress(
      [NotNull] RdProperty<bool> inProgress
    )
    {
      if (inProgress == null) throw new ArgumentNullException("inProgress");
      
      _InProgress = inProgress;
      _InProgress.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("inProgress", _InProgress));
    }
    //secondary constructor
    public IndefiniteProgress (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static new CtxReadDelegate<IndefiniteProgress> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var inProgress = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new IndefiniteProgress(inProgress).WithId(_id);
    };
    
    public static new CtxWriteDelegate<IndefiniteProgress> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._InProgress);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IndefiniteProgress (");
      using (printer.IndentCookie()) {
        printer.Print("inProgress = "); _InProgress.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum PathChooser {
    File,
    Folder
  }
  
  
  public enum Place {
    Default,
    ToolbarLeft
  }
  
  
  public class ValidationResult : RdBindableBase
  {
    //fields
    //public fields
    
    /// <summary>
    /// Defines validation result state
    /// </summary>
    public ValidationStates State {get; private set;}
    
    /// <summary>
    /// Error text, empty when passed
    /// </summary>
    [NotNull] public string ResultMessage {get; private set;}
    
    /// <summary>
    /// Icon (currently is shown only in WPF control
    /// </summary>
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    
    //primary constructor
    private ValidationResult(
      ValidationStates state,
      [NotNull] string resultMessage,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon
    )
    {
      if (resultMessage == null) throw new ArgumentNullException("resultMessage");
      if (icon == null) throw new ArgumentNullException("icon");
      
      State = state;
      ResultMessage = resultMessage;
      _Icon = icon;
      _Icon.OptimizeNested = true;
      _Icon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
    }
    //secondary constructor
    public ValidationResult (
      ValidationStates state = ValidationStates.validationPassed,
      [NotNull] string resultMessage = ""
    ) : this (
      state,
      resultMessage,
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<ValidationResult> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var state = (ValidationStates)reader.ReadInt();
      var resultMessage = reader.ReadString();
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      return new ValidationResult(state, resultMessage, icon).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<ValidationResult> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write((int)value.State);
      writer.Write(value.ResultMessage);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ValidationResult (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("resultMessage = "); ResultMessage.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ValidationStates {
    validationPassed,
    validationWarning,
    validationError
  }
  
  
  public enum ValidationStyle {
    Text,
    Border
  }
}
