using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.UiContext
{
  
  
  public class UiContextModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Caret { get { return _Caret; }}
    [NotNull] public IRdProperty<int> Selection { get { return _Selection; }}
    [NotNull] public IRdProperty<int> Focus { get { return _Focus; }}
    [NotNull] public IRdProperty<int> TextControl { get { return _TextControl; }}
    [NotNull] public IRdProperty<int> Document { get { return _Document; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Caret;
    [NotNull] private readonly RdProperty<int> _Selection;
    [NotNull] private readonly RdProperty<int> _Focus;
    [NotNull] private readonly RdProperty<int> _TextControl;
    [NotNull] private readonly RdProperty<int> _Document;
    
    //primary constructor
    private UiContextModel(
      [NotNull] RdProperty<int> caret,
      [NotNull] RdProperty<int> selection,
      [NotNull] RdProperty<int> focus,
      [NotNull] RdProperty<int> textControl,
      [NotNull] RdProperty<int> document
    )
    {
      if (caret == null) throw new ArgumentNullException("caret");
      if (selection == null) throw new ArgumentNullException("selection");
      if (focus == null) throw new ArgumentNullException("focus");
      if (textControl == null) throw new ArgumentNullException("textControl");
      if (document == null) throw new ArgumentNullException("document");
      
      _Caret = caret;
      _Selection = selection;
      _Focus = focus;
      _TextControl = textControl;
      _Document = document;
      _Caret.OptimizeNested = true;
      _Selection.OptimizeNested = true;
      _Focus.OptimizeNested = true;
      _TextControl.OptimizeNested = true;
      _Document.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("caret", _Caret));
      BindableChildren.Add(new KeyValuePair<string, object>("selection", _Selection));
      BindableChildren.Add(new KeyValuePair<string, object>("focus", _Focus));
      BindableChildren.Add(new KeyValuePair<string, object>("textControl", _TextControl));
      BindableChildren.Add(new KeyValuePair<string, object>("document", _Document));
    }
    //secondary constructor
    private UiContextModel (
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -8227276819003039081L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<ContextKey>();
      serializers.Register(ContextPair.Read, ContextPair.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public UiContextModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("UiContextModel (");
      using (printer.IndentCookie()) {
        printer.Print("caret = "); _Caret.PrintEx(printer); printer.Println();
        printer.Print("selection = "); _Selection.PrintEx(printer); printer.Println();
        printer.Print("focus = "); _Focus.PrintEx(printer); printer.Println();
        printer.Print("textControl = "); _TextControl.PrintEx(printer); printer.Println();
        printer.Print("document = "); _Document.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ContextKey {
    Caret,
    Selection,
    Focus,
    TextControl,
    Document
  }
  
  
  public class ContextPair : IPrintable, IEquatable<ContextPair>
  {
    //fields
    //public fields
    public ContextKey Key {get; private set;}
    public int Timestamp {get; private set;}
    
    //private fields
    //primary constructor
    public ContextPair(
      ContextKey key,
      int timestamp
    )
    {
      Key = key;
      Timestamp = timestamp;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ContextPair> Read = (ctx, reader) => 
    {
      var key = (ContextKey)reader.ReadInt();
      var timestamp = reader.ReadInt();
      return new ContextPair(key, timestamp);
    };
    
    public static CtxWriteDelegate<ContextPair> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Key);
      writer.Write(value.Timestamp);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ContextPair) obj);
    }
    public bool Equals(ContextPair other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Key == other.Key && Timestamp == other.Timestamp;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Key;
        hash = hash * 31 + Timestamp.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ContextPair (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("timestamp = "); Timestamp.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
